"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tz2 = exports.Tz3 = exports.ECKey = void 0;
var libsodium_wrappers_1 = require("libsodium-wrappers");
var utils_1 = require("@taquito/utils");
var typedarray_to_buffer_1 = require("typedarray-to-buffer");
var elliptic_1 = require("elliptic");
var pref = {
    p256: {
        pk: utils_1.prefix['p2pk'],
        sk: utils_1.prefix['p2sk'],
        pkh: utils_1.prefix.tz3,
        sig: utils_1.prefix.p2sig,
    },
    secp256k1: {
        pk: utils_1.prefix['sppk'],
        sk: utils_1.prefix['spsk'],
        pkh: utils_1.prefix.tz2,
        sig: utils_1.prefix.spsig,
    },
};
/**
 * @description Provide signing logic for elliptic curve based key (tz2, tz3)
 */
var ECKey = /** @class */ (function () {
    /**
     *
     * @param curve Curve to use with the key
     * @param key Encoded private key
     * @param encrypted Is the private key encrypted
     * @param decrypt Decrypt function
     */
    function ECKey(curve, key, encrypted, decrypt) {
        this.curve = curve;
        this.key = key;
        var keyPrefix = key.substr(0, encrypted ? 5 : 4);
        if (!utils_1.isValidPrefix(keyPrefix)) {
            throw new Error('key contains invalid prefix');
        }
        this._key = decrypt(utils_1.b58cdecode(this.key, utils_1.prefix[keyPrefix]));
        var keyPair = new elliptic_1.default.ec(this.curve).keyFromPrivate(this._key);
        var pref = keyPair.getPublic().getY().toArray()[31] % 2 ? 3 : 2;
        var pad = new Array(32).fill(0);
        this._publicKey = typedarray_to_buffer_1.default(new Uint8Array([pref].concat(pad.concat(keyPair.getPublic().getX().toArray()).slice(-32))));
    }
    /**
     *
     * @param bytes Bytes to sign
     * @param bytesHash Blake2b hash of the bytes to sign
     */
    ECKey.prototype.sign = function (bytes, bytesHash) {
        return __awaiter(this, void 0, void 0, function () {
            var key, sig, signature, sbytes;
            return __generator(this, function (_a) {
                key = new elliptic_1.default.ec(this.curve).keyFromPrivate(this._key);
                sig = key.sign(bytesHash, { canonical: true });
                signature = sig.r.toString('hex', 64) + sig.s.toString('hex', 64);
                sbytes = bytes + signature;
                return [2 /*return*/, {
                        bytes: bytes,
                        sig: utils_1.b58cencode(signature, utils_1.prefix.sig),
                        prefixSig: utils_1.b58cencode(signature, pref[this.curve].sig),
                        sbytes: sbytes,
                    }];
            });
        });
    };
    /**
     * @returns Encoded public key
     */
    ECKey.prototype.publicKey = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, utils_1.b58cencode(this._publicKey, pref[this.curve].pk)];
            });
        });
    };
    /**
     * @returns Encoded public key hash
     */
    ECKey.prototype.publicKeyHash = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, libsodium_wrappers_1.default.ready];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, utils_1.b58cencode(libsodium_wrappers_1.default.crypto_generichash(20, new Uint8Array(this._publicKey)), pref[this.curve].pkh)];
                }
            });
        });
    };
    /**
     * @returns Encoded private key
     */
    ECKey.prototype.secretKey = function () {
        return __awaiter(this, void 0, void 0, function () {
            var key;
            return __generator(this, function (_a) {
                key = this._key;
                return [2 /*return*/, utils_1.b58cencode(key, pref[this.curve].sk)];
            });
        });
    };
    return ECKey;
}());
exports.ECKey = ECKey;
/**
 * @description Tz3 key class using the p256 curve
 */
exports.Tz3 = ECKey.bind(null, 'p256');
/**
 * @description Tz3 key class using the secp256k1 curve
 */
exports.Tz2 = ECKey.bind(null, 'secp256k1');
//# sourceMappingURL=ec-key.js.map