"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TicketToken = exports.EncodeTicketError = void 0;
var int_1 = require("./comparable/int");
var contract_1 = require("./contract");
var token_1 = require("./token");
var EncodeTicketError = /** @class */ (function () {
    function EncodeTicketError() {
        this.name = 'TicketEncodeError';
        this.message = 'Tickets cannot be sent to the blockchain; they are created on-chain';
    }
    return EncodeTicketError;
}());
exports.EncodeTicketError = EncodeTicketError;
var ticketerType = { "prim": "contract" };
var amountType = { "prim": "int" };
var TicketToken = /** @class */ (function (_super) {
    __extends(TicketToken, _super);
    function TicketToken(val, idx, fac) {
        var _this = _super.call(this, val, idx, fac) || this;
        _this.val = val;
        _this.idx = idx;
        _this.fac = fac;
        return _this;
    }
    TicketToken.prototype.Encode = function (_args) {
        throw new EncodeTicketError();
    };
    TicketToken.prototype.EncodeObject = function (_args) {
        throw new EncodeTicketError();
    };
    TicketToken.prototype.Execute = function (val, semantics) {
        if (semantics && semantics[TicketToken.prim]) {
            return semantics[TicketToken.prim](val, this.val);
        }
        var ticketer = this.createToken(ticketerType, this.idx);
        var value = this.createToken(this.val.args[0], this.idx);
        var amount = this.createToken(amountType, this.idx);
        return {
            ticketer: ticketer.Execute(val.args[0], semantics),
            value: value.Execute(val.args[1], semantics),
            amount: amount.Execute(val.args[2], semantics)
        };
    };
    TicketToken.prototype.ExtractSchema = function () {
        var valueSchema = this.createToken(this.val.args[0], this.idx);
        return {
            ticketer: contract_1.ContractToken.prim,
            value: valueSchema.ExtractSchema(),
            amount: int_1.IntToken.prim
        };
    };
    TicketToken.prim = 'ticket';
    return TicketToken;
}(token_1.Token));
exports.TicketToken = TicketToken;
//# sourceMappingURL=ticket.js.map