"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaplingTransactionToken = exports.SaplingTransactionValidationError = void 0;
var token_1 = require("./token");
var SaplingTransactionValidationError = /** @class */ (function (_super) {
    __extends(SaplingTransactionValidationError, _super);
    function SaplingTransactionValidationError(value, token, message) {
        var _this = _super.call(this, value, token, message) || this;
        _this.value = value;
        _this.token = token;
        _this.name = 'SaplingTransactionValidationError';
        return _this;
    }
    return SaplingTransactionValidationError;
}(token_1.TokenValidationError));
exports.SaplingTransactionValidationError = SaplingTransactionValidationError;
var SaplingTransactionToken = /** @class */ (function (_super) {
    __extends(SaplingTransactionToken, _super);
    function SaplingTransactionToken(val, idx, fac) {
        var _this = _super.call(this, val, idx, fac) || this;
        _this.val = val;
        _this.idx = idx;
        _this.fac = fac;
        return _this;
    }
    SaplingTransactionToken.prototype.Execute = function (_val) {
        throw new Error('There is no literal value for the sapling_transaction type.');
    };
    SaplingTransactionToken.prototype.validateBytes = function (val) {
        var bytes = /^(0x|0X)?([0-9a-fA-F]*$)/.exec(val);
        if (bytes && bytes[2].length % 2 === 0) {
            return bytes[2];
        }
        else {
            throw new SaplingTransactionValidationError(val, this, "Invalid bytes: " + val);
        }
    };
    SaplingTransactionToken.prototype.convertUint8ArrayToHexString = function (val) {
        return val.constructor === Uint8Array ? Buffer.from(val).toString('hex') : val;
    };
    SaplingTransactionToken.prototype.Encode = function (args) {
        var val = args.pop();
        val = this.validateBytes(this.convertUint8ArrayToHexString(val));
        return { bytes: String(val).toString() };
    };
    SaplingTransactionToken.prototype.EncodeObject = function (val) {
        val = this.validateBytes(this.convertUint8ArrayToHexString(val));
        return { bytes: String(val).toString() };
    };
    SaplingTransactionToken.prototype.ExtractSchema = function () {
        var _a;
        return _a = {},
            _a[SaplingTransactionToken.prim] = {
                'memo-size': Number(this.val.args[0]['int']),
            },
            _a;
    };
    SaplingTransactionToken.prim = 'sapling_transaction';
    return SaplingTransactionToken;
}(token_1.Token));
exports.SaplingTransactionToken = SaplingTransactionToken;
//# sourceMappingURL=sapling-transaction.js.map