"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaplingStateToken = exports.SaplingStateValidationError = void 0;
var token_1 = require("./token");
var SaplingStateValidationError = /** @class */ (function (_super) {
    __extends(SaplingStateValidationError, _super);
    function SaplingStateValidationError(value, token, message) {
        var _this = _super.call(this, value, token, message) || this;
        _this.value = value;
        _this.token = token;
        _this.name = 'SaplingStateValidationError';
        return _this;
    }
    return SaplingStateValidationError;
}(token_1.TokenValidationError));
exports.SaplingStateValidationError = SaplingStateValidationError;
var SaplingStateToken = /** @class */ (function (_super) {
    __extends(SaplingStateToken, _super);
    function SaplingStateToken(val, idx, fac) {
        var _this = _super.call(this, val, idx, fac) || this;
        _this.val = val;
        _this.idx = idx;
        _this.fac = fac;
        return _this;
    }
    SaplingStateToken.prototype.isValid = function (val) {
        return typeof val === 'object' && Object.keys(val).length === 0;
    };
    SaplingStateToken.prototype.Execute = function (val, semantic) {
        if (semantic && semantic[SaplingStateToken.prim]) {
            return semantic[SaplingStateToken.prim](val, this.val);
        }
        if ('int' in val) {
            return val.int;
        }
        else {
            // Unknown case
            throw new Error("Sapling state is expecting an object with an int property. Got " + JSON.stringify(val));
        }
    };
    SaplingStateToken.prototype.Encode = function (args) {
        var val = args.pop();
        if (this.isValid(val)) {
            return [];
        }
        else {
            throw new SaplingStateValidationError(val, this, "Invalid sapling_state. Received: " + val + " while expecting: {}");
        }
    };
    SaplingStateToken.prototype.EncodeObject = function (val) {
        if (this.isValid(val)) {
            return [];
        }
        else {
            throw new SaplingStateValidationError(val, this, "Invalid sapling_state. Received: " + val + " while expecting: {}");
        }
    };
    SaplingStateToken.prototype.ExtractSchema = function () {
        var _a;
        return _a = {},
            _a[SaplingStateToken.prim] = {
                'memo-size': Number(this.val.args[0]['int']),
            },
            _a;
    };
    SaplingStateToken.prim = 'sapling_state';
    return SaplingStateToken;
}(token_1.Token));
exports.SaplingStateToken = SaplingStateToken;
//# sourceMappingURL=sapling-state.js.map