import { Expr } from "./micheline";
export interface FormatOptions {
    /**
     * A string used for code indentation if desired. Usually a tab character or a number of spaces.
     */
    indent?: string;
    /**
     * A string used for line separation. Usually a newline character ("\n");
     */
    newline?: string;
}
/**
 * Formats Micheline expression
 * @param expr An AST node
 * @param opt Options
 */
export declare function emitMicheline(expr: Expr, opt?: FormatOptions, foldMacros?: boolean): string;
