def hex2rgb(hex_):
    return tuple(int(hex_.strip('#')[i:i+2], 16) for i in (0, 2, 4))

COLOR_WHITE    = hex2rgb('#ffffff')
COLOR_BLACK    = hex2rgb('#000000')
COLOR_GRAY_A   = hex2rgb('#f6f6f6')
COLOR_GRAY_B   = hex2rgb('#e1e1e1')
COLOR_GRAY_C   = hex2rgb('#848484')
COLOR_GRAY_D   = hex2rgb('#646464')
COLOR_YELLOW_A = hex2rgb('#fce78e')
COLOR_YELLOW_B = hex2rgb('#d6c479')
COLOR_YELLOW_C = hex2rgb('#afa062')
COLOR_BLUE_A   = hex2rgb('#c2c9ff')
COLOR_BLUE_B   = hex2rgb('#afb9e6')
COLOR_BLUE_C   = hex2rgb('#878cb2')
COLOR_GREEN_A  = hex2rgb('#b2e22a')
COLOR_GREEN_B  = hex2rgb('#96be25')
COLOR_GREEN_C  = hex2rgb('#597116')
COLOR_RED_A    = hex2rgb('#ff5e67')
COLOR_RED_B    = hex2rgb('#d9506a')
COLOR_RED_C    = hex2rgb('#8c3344')

INTERFACE_CONFIG_IPS = 10000
INTERFACE_CONFIG_FPS = 120
INTERFACE_CONFIG_WINDOW_WIDTH = 800
INTERFACE_CONFIG_WINDOW_HEIGHT = 600
INTERFACE_CONFIG_SHOW_STATUS_BAR = True
INTERFACE_CONFIG_SHOW_CONTROLS = True
INTERFACE_CONFIG_SCREEN_BG_COLOR = COLOR_GRAY_D

INTERFACE_FONT_FACE = 'consolas'
INTERFACE_FONT_SIZE        = 15
INTERFACE_FONT_BIG_SIZE    = 45
INTERFACE_STATUSBAR_HEIGTH = 20
INTERFACE_IPS_AVERAGE      = 1000
INTERFACE_FPS_AVERAGE      = 120
INTERFACE_STATUSBAR_COLOR = COLOR_GRAY_C
INTERFACE_CONTROLS_PANEL_WIDTH = 120
INTERFACE_CONTROLS_PANEL_HEIGHT = 40
INTERFACE_CONTROLS_PANEL_RADIUS = 5
INTERFACE_CONTROLS_PANEL_BG_COLOR     = COLOR_YELLOW_B
INTERFACE_CONTROLS_PANEL_BORDER_COLOR = COLOR_YELLOW_C
INTERFACE_CONTROLS_PANEL_BORDER_WIDTH = 1
INTERFACE_CONTROLS_MARGIN = 10
INTERFACE_CONTROLS_BUTTONS_PADDING = 15
INTERFACE_CONTROLS_BUTTONS_BG_MOUSEOVER_COLOR = COLOR_WHITE
INTERFACE_CONTROLS_BUTTONS_BG_COLOR = COLOR_YELLOW_A
INTERFACE_CONTROLS_BUTTONS_BG_CLICKED_COLOR = COLOR_YELLOW_C
INTERFACE_CONTROLS_MENU_VERTICAL_PADDING = 3
INTERFACE_CONTROLS_MENU_HORIZONTAL_PADDING = 20
INTERFACE_CONTROLS_MENUITEM_BG_MOUSEOVER_COLOR = COLOR_WHITE
INTERFACE_CONTROLS_MENUITEM_BG_COLOR = COLOR_YELLOW_A
INTERFACE_CONTROLS_MENUITEM_BG_CLICKED_COLOR = COLOR_YELLOW_C

TOOLBOX_INITIAL_X  = 30
TOOLBOX_INITIAL_Y  = 30
TOOLBOX_MIN_WIDTH  = 250
TOOLBOX_MIN_HEIGHT = 5
TOOLBOX_TITLE_BAR_HEIGHT = 30
TOOLBOX_TITLE_BAR_BG_COLOR               = COLOR_GRAY_B
TOOLBOX_TITLE_BAR_BORDER_COLOR           = COLOR_GRAY_C
TOOLBOX_TITLE_BAR_CE_BUTTOM_BG_COLOR     = COLOR_YELLOW_B
TOOLBOX_TITLE_BAR_CE_BUTTOM_BORDER_COLOR = COLOR_YELLOW_C
TOOLBOX_VERTICAL_SPACE = 15
TOOLBOX_BORDER_WIDTH = 2
TOOLBOX_BUTTON_PADDING = 5
TOOLBOX_FOOTER_HEIGHT = 5
TOOLBOX_BODY_BG_COLOR     = COLOR_GRAY_A
TOOLBOX_BODY_BORDER_COLOR = COLOR_GRAY_C
TOOLBOX_STANDARD_TEXT_COLOR = COLOR_BLACK
TOOLBOX_DISABLED_TEXT_COLOR = COLOR_GRAY_C

WIDGET_STANDARD_SLOT_HEIGHT = 40
WIDGET_MARGIN_LEFT   = 15 
WIDGET_MARGIN_RIGHT  = 15 
WIDGET_MARGIN_TOP    = 4 
WIDGET_MARGIN_BOTTOM = 4 
WIDGET_PADDING_LEFT   = 10 
WIDGET_PADDING_RIGHT  = 10 
WIDGET_PADDING_TOP    = 5 
WIDGET_PADDING_BOTTOM = 5
WIDGET_BORDER_WIDTH = 1
WIDGET_BORDER_RADIUS = 10
WIDGET_BORDER_COLOR          = COLOR_GRAY_B
WIDGET_DISABLED_BG_COLOR     = COLOR_GRAY_B
WIDGET_DISABLED_BORDER_COLOR = COLOR_GRAY_C
WIDGET_RESETICON_UNCHECKED_BG_COLOR = COLOR_WHITE
WIDGET_RESETICON_CHECKED_BG_MOUSEOVER_COLOR = COLOR_YELLOW_A
WIDGET_RESETICON_CHECKED_BG_COLOR   = COLOR_YELLOW_B
WIDGET_RESETICON_BORDER_COLOR       = COLOR_GRAY_C
WIDGET_RESETICON_BORDER_WIDTH = 1
WIDGET_RESETICON_SIDE = 10

LABEL_MIN_SIZE_FACTOR = 1
LABEL_MAX_SIZE_FACTOR = 1
LABEL_DEFAULT_SIZE_FACTOR = 1

NUMERIC_OUTPUT_MIN_SIZE_FACTOR = 1
NUMERIC_OUTPUT_MAX_SIZE_FACTOR = 1
NUMERIC_OUTPUT_DEFAULT_SIZE_FACTOR = 1
NUMERIC_OUTPUT_FIELD_BORDER_WIDTH = 1
NUMERIC_OUTPUT_FIELD_HEIGHT = 0.5 * WIDGET_STANDARD_SLOT_HEIGHT
NUMERIC_OUTPUT_FIELD_WIDTH = 80
NUMERIC_OUTPUT_FIELD_PADDING = 5
NUMERIC_OUTPUT_FIELD_BG_COLOR     = COLOR_GRAY_B
NUMERIC_OUTPUT_FIELD_BORDER_COLOR = COLOR_GRAY_D

NUMERIC_INPUT_MIN_SIZE_FACTOR = 1
NUMERIC_INPUT_MAX_SIZE_FACTOR = 1
NUMERIC_INPUT_DEFAULT_SIZE_FACTOR = 1
NUMERIC_INPUT_FIELD_BORDER_WIDTH = 1
NUMERIC_INPUT_FIELD_HEIGHT = 0.5 * WIDGET_STANDARD_SLOT_HEIGHT
NUMERIC_INPUT_FIELD_WIDTH = 80
NUMERIC_INPUT_FIELD_PADDING = 5
NUMERIC_INPUT_FIELD_BG_COLOR                 = COLOR_WHITE
NUMERIC_INPUT_FIELD_BG_EDITING_VALID_COLOR   = COLOR_BLUE_A
NUMERIC_INPUT_FIELD_BG_EDITING_INVALID_COLOR = COLOR_RED_A
NUMERIC_INPUT_FIELD_BORDER_COLOR             = COLOR_GRAY_D

TANK_MIN_SIZE_FACTOR = 3
TANK_MAX_SIZE_FACTOR = 5
TANK_DEFAULT_SIZE_FACTOR = 4
TANK_WIDTH = 45
TANK_MARGIN = 15
TANK_BORDER_WIDTH = 2
TANK_BORDER_RADIUS = 20
TANK_BORDER_HACK_INFLATE = 12
TANK_BORDER_HACK_WIDTH = 7
TANK_MARK_WIDTH = 2
TANK_BODY_BG_COLOR   = TOOLBOX_BODY_BG_COLOR
TANK_BG_GREEN_COLOR  = COLOR_GREEN_B
TANK_BG_RED_COLOR    = COLOR_RED_B
TANK_BG_YELLOW_COLOR = COLOR_YELLOW_B
TANK_BORDER_COLOR    = COLOR_GRAY_C

SLIDER_MIN_SIZE_FACTOR = 2
SLIDER_MAX_SIZE_FACTOR = 2
SLIDER_DEFAULT_SIZE_FACTOR = 2
SLIDER_HANDLE_RADIUS = 8
SLIDER_HANDLE_SIZE = 2 * SLIDER_HANDLE_RADIUS
SLIDER_HANDLE_BG_MOUSE_OVER_COLOR = COLOR_YELLOW_A
SLIDER_HANDLE_BG_COLOR            = COLOR_YELLOW_B
SLIDER_HANDLE_BG_DRAGGED_COLOR    = COLOR_YELLOW_C
SLIDER_HANDLE_BORDER_COLOR = COLOR_GRAY_C
SLIDER_HANDLE_BORDER_WIDTH = 1
SLIDER_TRACK_TO_RIGHT_BG_COLOR = COLOR_WHITE
SLIDER_TRACK_TO_LEFT_BG_MOUSE_OVER_COLOR = COLOR_YELLOW_A
SLIDER_TRACK_TO_LEFT_BG_COLOR            = COLOR_YELLOW_B
SLIDER_TRACK_TO_LEFT_BG_DRAGGED_COLOR    = COLOR_YELLOW_C
SLIDER_TRACK_BORDER_COLOR = COLOR_GRAY_C
SLIDER_TRACK_BORDER_WIDTH = 1
SLIDER_TRACK_THICKNESS = 5

BUTTON_MIN_SIZE_FACTOR     = 1
BUTTON_MAX_SIZE_FACTOR     = 1
BUTTON_DEFAULT_SIZE_FACTOR = 1
BUTTON_BORDER_RADIUS       = 10
BUTTON_BORDER_WIDTH        = 1
BUTTON_BG_COLOR         = COLOR_YELLOW_B
BUTTON_BG_HOVER_COLOR   = COLOR_YELLOW_A
BUTTON_BG_CLICKED_COLOR = COLOR_YELLOW_C
BUTTON_BORDER_COLOR     = COLOR_GRAY_C

CHECKBOX_MIN_SIZE_FACTOR = 1
CHECKBOX_MAX_SIZE_FACTOR = 1
CHECKBOX_DEFAULT_SIZE_FACTOR = 1
CHECKBOX_SIDE = 0.4 * WIDGET_STANDARD_SLOT_HEIGHT
CHECKBOX_BORDER_WIDTH = 1
CHECKBOX_UNCHECKED_BG_COLOR = COLOR_WHITE
CHECKBOX_CHECKED_BG_MOUSEOVER_COLOR = COLOR_YELLOW_A
CHECKBOX_CHECKED_BG_COLOR   = COLOR_YELLOW_B
CHECKBOX_BORDER_COLOR       = COLOR_GRAY_C

RADIOBUTTON_MIN_SIZE_FACTOR = 3
RADIOBUTTON_MAX_SIZE_FACTOR = None
RADIOBUTTON_DEFAULT_SIZE_FACTOR = 3
RADIOBUTTON_SIDE = CHECKBOX_SIDE
RADIOBUTTON_SELECTED_BG_MOUSEOVER_COLOR = COLOR_YELLOW_A
RADIOBUTTON_SELECTED_BG_COLOR   = COLOR_YELLOW_B
RADIOBUTTON_UNSELECTED_BG_COLOR = COLOR_WHITE
RADIOBUTTON_BORDER_COLOR        = COLOR_GRAY_C
RADIOBUTTON_BORDER_WIDTH        = 1
RADIOBUTTON_RADIUS = 0.5 * CHECKBOX_SIDE

CHART_AREA_PADDING_HORIZONTAL = 10
CHART_AREA_PADDING_VERTICAL = 60
CHART_LABEL_PADDING_VERTICAL = 10

SPARKLINE_MIN_SIZE_FACTOR = 3
SPARKLINE_MAX_SIZE_FACTOR = 4
SPARKLINE_DEFAULT_SIZE_FACTOR = 4
SPARKLINE_LINE_GREEN_COLOR = COLOR_GREEN_C
SPARKLINE_FILL_GREEN_COLOR = COLOR_GREEN_A
SPARKLINE_LINE_RED_COLOR = COLOR_RED_C
SPARKLINE_FILL_RED_COLOR = COLOR_RED_A
SPARKLINE_LINE_YELLOW_COLOR = COLOR_YELLOW_C
SPARKLINE_FILL_YELLOW_COLOR = COLOR_YELLOW_A
SPARKLINE_LINE_BLUE_COLOR = COLOR_BLUE_C
SPARKLINE_FILL_BLUE_COLOR = COLOR_BLUE_A
SPARKLINE_BULLET_BG_COLOR = COLOR_WHITE
SPARKLINE_LINE_WIDTH = 2
