# osirixgrpc

Welcome to the osirixgrpc library. This provides the protobuf definitions for interacting with the osirixgrpc plugin. This code is autogenerated by the grpc tools using the [proto template files](https://github.com/osirixgrpc/osirixgrpc/tree/main/protos) provided in the main [osirixgrpc project](https://github.com/osirixgrpc/osirixgrpc/).

For day-day usage we suggest using the dedicated [pyosirix package](https://pypi.org/project/pyosirix/) instead.

## Examples
### Establishing a connection with grpc
```
import grpc
import osirix_pb2_grpc

port = 12345  # Must match activated port in OsiriX plugin
server_url_localhost = 'localhost:' + str(port)
channel_opt = [('grpc.max_send_message_length', 512 * 1024 * 1024), ('grpc.max_receive_message_length', 512 * 1024 * 1024)]
channel = grpc.insecure_channel(server_url_localhost, options=channel_opt)
stub = osirix_pb2_grpc.OsiriXServiceStub(channel)
```
### Obtain a copy of the current browser
```
import utilities_pb2

request = utilities_pb2.Empty()  # For functions with no input, use an empty request
response = stub.OsirixCurrentBrowser(request)
if response.status.status == 0:
    raise Exception("Could not get browser.  Reason: %s" % response.status.message)
browser_controller = response.browser_controller
```
### Get the current database selection within the browser controller
```
import browsercontroller_pb2

response = stub.BrowserControllerDatabaseSelection(browser_controller)
series = response.series
studies = response.studies
```
### Obtain the names of the selected studies
```
import dicomstudy_pb2

for dicom_study in studies:
    response = stub.DicomStudyName(dicom_study)
    print("Study name: ", response.name)
```
