"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
const cache_behavior_1 = require("../../lib/private/cache-behavior");
let app;
beforeEach(() => {
    app = new core_1.App();
    new core_1.Stack(app, 'Stack', {
        env: { account: '1234', region: 'testregion' },
    });
});
test('renders the minimum template with an origin and path specified', () => {
    const behavior = new cache_behavior_1.CacheBehavior('origin_id', {
        pathPattern: '*',
    });
    expect(behavior._renderBehavior()).toEqual({
        targetOriginId: 'origin_id',
        pathPattern: '*',
        forwardedValues: { queryString: false },
        viewerProtocolPolicy: 'allow-all',
    });
});
test('renders with all properties specified', () => {
    const behavior = new cache_behavior_1.CacheBehavior('origin_id', {
        pathPattern: '*',
        allowedMethods: lib_1.AllowedMethods.ALLOW_ALL,
        cachedMethods: lib_1.CachedMethods.CACHE_GET_HEAD_OPTIONS,
        compress: true,
        forwardQueryString: true,
        forwardQueryStringCacheKeys: ['user_id', 'auth'],
        smoothStreaming: true,
        viewerProtocolPolicy: lib_1.ViewerProtocolPolicy.HTTPS_ONLY,
    });
    expect(behavior._renderBehavior()).toEqual({
        targetOriginId: 'origin_id',
        pathPattern: '*',
        allowedMethods: ['GET', 'HEAD', 'OPTIONS', 'PUT', 'PATCH', 'POST', 'DELETE'],
        cachedMethods: ['GET', 'HEAD', 'OPTIONS'],
        compress: true,
        forwardedValues: {
            queryString: true,
            queryStringCacheKeys: ['user_id', 'auth'],
        },
        smoothStreaming: true,
        viewerProtocolPolicy: 'https-only',
    });
});
//# sourceMappingURL=data:application/json;base64,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