"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
let app;
let stack;
beforeEach(() => {
    app = new core_1.App();
    stack = new core_1.Stack(app, 'Stack', {
        env: { account: '1234', region: 'testregion' },
    });
});
test.each([
    core_1.Duration.seconds(0),
    core_1.Duration.seconds(0.5),
    core_1.Duration.seconds(10.5),
    core_1.Duration.seconds(11),
    core_1.Duration.minutes(5),
])('validates connectionTimeout is an int between 1 and 10 seconds', (connectionTimeout) => {
    expect(() => {
        new TestOrigin('www.example.com', {
            connectionTimeout,
        });
    }).toThrow(`connectionTimeout: Must be an int between 1 and 10 seconds (inclusive); received ${connectionTimeout.toSeconds()}.`);
});
test.each([-0.5, 0.5, 1.5, 4])('validates connectionAttempts is an int between 1 and 3', (connectionAttempts) => {
    expect(() => {
        new TestOrigin('www.example.com', {
            connectionAttempts,
        });
    }).toThrow(`connectionAttempts: Must be an int between 1 and 3 (inclusive); received ${connectionAttempts}.`);
});
test.each(['api', '/api', '/api/', 'api/'])('enforces that originPath starts but does not end, with a /', (originPath) => {
    var _a;
    const origin = new TestOrigin('www.example.com', {
        originPath,
    });
    const originBindConfig = origin.bind(stack, { originId: '0' });
    expect((_a = originBindConfig.originProperty) === null || _a === void 0 ? void 0 : _a.originPath).toEqual('/api');
});
/** Used for testing common Origin functionality */
class TestOrigin extends lib_1.OriginBase {
    constructor(domainName, props = {}) { super(domainName, props); }
    renderCustomOriginConfig() {
        return { originProtocolPolicy: lib_1.OriginProtocolPolicy.HTTPS_ONLY };
    }
}
//# sourceMappingURL=data:application/json;base64,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