"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const cloudfront = require("../lib");
class AcmCertificateAliasStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const s3BucketSource = new s3.Bucket(this, 'Bucket');
        const distribution = new cloudfront.CloudFrontWebDistribution(this, 'AnAmazingWebsiteProbably', {
            originConfigs: [{
                    s3OriginSource: { s3BucketSource },
                    behaviors: [{ isDefaultBehavior: true }],
                }],
            viewerCertificate: cloudfront.ViewerCertificate.fromIamCertificate('certificateId', {
                aliases: ['example.com'],
                securityPolicy: cloudfront.SecurityPolicyProtocol.SSL_V3,
                sslMethod: cloudfront.SSLMethod.SNI,
            }),
        });
        /// !hide
        Array.isArray(s3BucketSource);
        Array.isArray(distribution);
    }
}
const app = new core_1.App();
new AcmCertificateAliasStack(app, 'AcmCertificateAliasStack');
app.synth();
//# sourceMappingURL=data:application/json;base64,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