import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IUserPool } from './user-pool';
/**
 * Represents a Cognito user pool resource server.
 *
 * @stability stable
 */
export interface IUserPoolResourceServer extends IResource {
    /**
     * Resource server id.
     *
     * @stability stable
     * @attribute true
     */
    readonly userPoolResourceServerId: string;
}
/**
 * Props to initialize ResourceServerScope.
 *
 * @stability stable
 */
export interface ResourceServerScopeProps {
    /**
     * The name of the scope.
     *
     * @stability stable
     */
    readonly scopeName: string;
    /**
     * A description of the scope.
     *
     * @stability stable
     */
    readonly scopeDescription: string;
}
/**
 * A scope for ResourceServer.
 *
 * @stability stable
 */
export declare class ResourceServerScope {
    /**
     * The name of the scope.
     *
     * @stability stable
     */
    readonly scopeName: string;
    /**
     * A description of the scope.
     *
     * @stability stable
     */
    readonly scopeDescription: string;
    /**
     * @stability stable
     */
    constructor(props: ResourceServerScopeProps);
}
/**
 * Options to create a UserPoolResourceServer.
 *
 * @stability stable
 */
export interface UserPoolResourceServerOptions {
    /**
     * A unique resource server identifier for the resource server.
     *
     * @stability stable
     */
    readonly identifier: string;
    /**
     * A friendly name for the resource server.
     *
     * @default - same as `identifier`
     * @stability stable
     */
    readonly userPoolResourceServerName?: string;
    /**
     * Oauth scopes.
     *
     * @default - No scopes will be added
     * @stability stable
     */
    readonly scopes?: ResourceServerScope[];
}
/**
 * Properties for the UserPoolResourceServer construct.
 *
 * @stability stable
 */
export interface UserPoolResourceServerProps extends UserPoolResourceServerOptions {
    /**
     * The user pool to add this resource server to.
     *
     * @stability stable
     */
    readonly userPool: IUserPool;
}
/**
 * Defines a User Pool OAuth2.0 Resource Server.
 *
 * @stability stable
 */
export declare class UserPoolResourceServer extends Resource implements IUserPoolResourceServer {
    /**
     * Import a user pool resource client given its id.
     *
     * @stability stable
     */
    static fromUserPoolResourceServerId(scope: Construct, id: string, userPoolResourceServerId: string): IUserPoolResourceServer;
    /**
     * Resource server id.
     *
     * @stability stable
     */
    readonly userPoolResourceServerId: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: UserPoolResourceServerProps);
}
