# pulp_certguard-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 1.3.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_certguard
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_certguard
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_certguard
from pulpcore.client.pulp_certguard.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_certguard.Configuration(
    host = "http://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_certguard.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_certguard.Configuration(
    host = "http://pulp",
    api_key = {
        'Session': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Session'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_certguard.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_certguard.ContentguardsRhsmApi(api_client)
    certguard_rhsm_cert_guard = pulpcore.client.pulp_certguard.CertguardRHSMCertGuard() # CertguardRHSMCertGuard | 

    try:
        # Create a rhsm cert guard
        api_response = api_instance.create(certguard_rhsm_cert_guard)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentguardsRhsmApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentguardsRhsmApi* | [**create**](docs/ContentguardsRhsmApi.md#create) | **POST** /pulp/api/v3/contentguards/certguard/rhsm/ | Create a rhsm cert guard
*ContentguardsRhsmApi* | [**delete**](docs/ContentguardsRhsmApi.md#delete) | **DELETE** {certguard_r_h_s_m_cert_guard_href} | Delete a rhsm cert guard
*ContentguardsRhsmApi* | [**list**](docs/ContentguardsRhsmApi.md#list) | **GET** /pulp/api/v3/contentguards/certguard/rhsm/ | List rhsm cert guards
*ContentguardsRhsmApi* | [**partial_update**](docs/ContentguardsRhsmApi.md#partial_update) | **PATCH** {certguard_r_h_s_m_cert_guard_href} | Update a rhsm cert guard
*ContentguardsRhsmApi* | [**read**](docs/ContentguardsRhsmApi.md#read) | **GET** {certguard_r_h_s_m_cert_guard_href} | Inspect a rhsm cert guard
*ContentguardsRhsmApi* | [**update**](docs/ContentguardsRhsmApi.md#update) | **PUT** {certguard_r_h_s_m_cert_guard_href} | Update a rhsm cert guard
*ContentguardsX509Api* | [**create**](docs/ContentguardsX509Api.md#create) | **POST** /pulp/api/v3/contentguards/certguard/x509/ | Create a x509 cert guard
*ContentguardsX509Api* | [**delete**](docs/ContentguardsX509Api.md#delete) | **DELETE** {certguard_x509_cert_guard_href} | Delete a x509 cert guard
*ContentguardsX509Api* | [**list**](docs/ContentguardsX509Api.md#list) | **GET** /pulp/api/v3/contentguards/certguard/x509/ | List x509 cert guards
*ContentguardsX509Api* | [**partial_update**](docs/ContentguardsX509Api.md#partial_update) | **PATCH** {certguard_x509_cert_guard_href} | Update a x509 cert guard
*ContentguardsX509Api* | [**read**](docs/ContentguardsX509Api.md#read) | **GET** {certguard_x509_cert_guard_href} | Inspect a x509 cert guard
*ContentguardsX509Api* | [**update**](docs/ContentguardsX509Api.md#update) | **PUT** {certguard_x509_cert_guard_href} | Update a x509 cert guard


## Documentation For Models

 - [CertguardRHSMCertGuard](docs/CertguardRHSMCertGuard.md)
 - [CertguardRHSMCertGuardResponse](docs/CertguardRHSMCertGuardResponse.md)
 - [CertguardX509CertGuard](docs/CertguardX509CertGuard.md)
 - [CertguardX509CertGuardResponse](docs/CertguardX509CertGuardResponse.md)
 - [PaginatedcertguardRHSMCertGuardResponseList](docs/PaginatedcertguardRHSMCertGuardResponseList.md)
 - [PaginatedcertguardX509CertGuardResponseList](docs/PaginatedcertguardX509CertGuardResponseList.md)
 - [PatchedcertguardRHSMCertGuard](docs/PatchedcertguardRHSMCertGuard.md)
 - [PatchedcertguardX509CertGuard](docs/PatchedcertguardX509CertGuard.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: Session
- **Location**: 


## Author

pulp-list@redhat.com


