/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.ShallowSkipRuleSet;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.TextOnlyCopyRuleSet;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.DeepCopyRuleSet;
import net.sf.saxon.trans.rules.DeepSkipRuleSet;
import net.sf.saxon.trans.rules.FailRuleSet;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.trans.rules.RuleSetWithWarnings;
import net.sf.saxon.trans.rules.ShallowCopyRuleSet;
import net.sf.saxon.value.Whitespace;

public class XSLMode
extends StyleElement {
    private SimpleMode mode;
    private Set<? extends Accumulator> accumulators;
    private boolean prepared = false;
    private boolean streamable = false;
    private boolean failOnMultipleMatch = false;
    private boolean warningOnNoMatch = false;
    private boolean warningOnMultipleMatch = true;
    private BuiltInRuleSet defaultRules = TextOnlyCopyRuleSet.getInstance();

    public boolean isDeclaration() {
        return true;
    }

    public boolean isInstruction() {
        return false;
    }

    public StructuredQName getObjectName() {
        StructuredQName qn = super.getObjectName();
        if (qn == null) {
            String nameAtt = Whitespace.trim(this.getAttributeValue("", "name"));
            if (nameAtt == null) {
                return Mode.UNNAMED_MODE_NAME;
            }
            try {
                qn = this.makeQName(nameAtt);
                this.setObjectName(qn);
            }
            catch (NamespaceException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-mode-" + this.generateId());
            }
            catch (XPathException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-mode-" + this.generateId());
            }
        }
        return qn;
    }

    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        Component other;
        StructuredQName name = this.getObjectName();
        SymbolicName sName = new SymbolicName(174, name);
        HashMap<SymbolicName, Component> componentIndex = top.getStylesheetPackage().getComponentIndex();
        if (!name.equals(Mode.UNNAMED_MODE_NAME) && (other = componentIndex.get(sName)) != null && other.getDeclaringPackage() != top.getStylesheetPackage()) {
            this.compileError("Mode " + name.getDisplayName() + " conflicts with a public named mode in package " + other.getDeclaringPackage().getPackageName(), "XTSE3050");
        }
        this.mode = (SimpleMode)top.getRuleManager().obtainMode(name, true);
        if (name.equals(Mode.UNNAMED_MODE_NAME)) {
            top.getRuleManager().setUnnamedModeExplicit(true);
        } else if (this.mode.getDeclaringComponent().getDeclaringPackage() != this.getContainingPackage()) {
            this.compileError("Mode name conflicts with a mode in a used package", "XTSE3050");
        } else {
            top.indexMode(decl);
        }
    }

    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String visibilityAtt = null;
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        AttributeCollection atts = this.getAttributeList();
        Visibility visibility = Visibility.PRIVATE;
        for (int a = 0; a < atts.getLength(); ++a) {
            String att;
            String f = atts.getQName(a);
            if (f.equals("streamable")) {
                this.streamable = this.processStreamableAtt(atts.getValue(a));
                continue;
            }
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                if (nameAtt.equals("#default")) continue;
                try {
                    this.setObjectName(this.makeQName(nameAtt));
                }
                catch (NamespaceException err) {
                    this.compileError(err.getMessage(), "XTSE0280");
                }
                catch (XPathException err) {
                    this.compileError(err);
                }
                continue;
            }
            if (f.equals("use-accumulators")) {
                String useAccAtt = atts.getValue(a);
                this.accumulators = this.getPrincipalStylesheetModule().getStylesheetPackage().getAccumulatorRegistry().getUsedAccumulators(useAccAtt, this);
                continue;
            }
            if (f.equals("on-multiple-match")) {
                att = Whitespace.trim(atts.getValue(a));
                if (att.equals("fail")) {
                    this.failOnMultipleMatch = true;
                    continue;
                }
                if (att.equals("use-last")) {
                    this.failOnMultipleMatch = false;
                    continue;
                }
                this.invalidAttribute(f, "fail|use-last");
                continue;
            }
            if (f.equals("on-no-match")) {
                String value = Whitespace.trim(atts.getValue(a));
                assert (value != null);
                if (value.equals("text-only-copy")) continue;
                if (value.equals("shallow-copy")) {
                    this.defaultRules = ShallowCopyRuleSet.getInstance();
                    continue;
                }
                if (value.equals("deep-copy")) {
                    this.defaultRules = DeepCopyRuleSet.getInstance();
                    continue;
                }
                if (value.equals("shallow-skip")) {
                    this.defaultRules = ShallowSkipRuleSet.getInstance();
                    continue;
                }
                if (value.equals("deep-skip")) {
                    this.defaultRules = DeepSkipRuleSet.getInstance();
                    continue;
                }
                if (value.equals("fail")) {
                    this.defaultRules = FailRuleSet.getInstance();
                    continue;
                }
                this.invalidAttribute(f, "text-only-copy|shallow-copy|deep-copy|shallow-skip|deep-skip|fail");
                continue;
            }
            if (f.equals("warning-on-multiple-match")) {
                att = Whitespace.trim(atts.getValue(a));
                this.warningOnMultipleMatch = this.processBooleanAttribute("warning-on-multiple-match", att);
                continue;
            }
            if (f.equals("warning-on-no-match")) {
                att = Whitespace.trim(atts.getValue(a));
                this.warningOnNoMatch = this.processBooleanAttribute("warning-on-no-match", att);
                continue;
            }
            if (f.equals("typed")) {
                att = Whitespace.trim(atts.getValue(a));
                this.checkAttributeValue("typed", att, false, new String[]{"0", "1", "false", "lax", "no", "strict", "true", "unspecified", "yes"});
                continue;
            }
            if (f.equals("visibility")) {
                visibilityAtt = Whitespace.trim(atts.getValue(a));
                visibility = this.interpretVisibilityValue(visibilityAtt, "");
                if (visibility == Visibility.ABSTRACT) {
                    this.invalidAttribute(f, "public|private|final");
                }
                if (visibility == Visibility.PRIVATE) continue;
                this.mode.setDeclaredVisibility(visibility);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (nameAtt == null && visibilityAtt != null && this.mode.getDeclaredVisibility() != Visibility.PRIVATE) {
            this.compileError("The unnamed mode must be private", "XTSE0020");
        }
        RuleManager manager = this.getCompilation().getPrincipalStylesheetModule().getRuleManager();
        if (this.getObjectName() == null) {
            this.mode = manager.getUnnamedMode();
        } else {
            Mode m = manager.obtainMode(this.getObjectName(), true);
            if (m instanceof SimpleMode) {
                this.mode = (SimpleMode)m;
            } else {
                this.compileError("Mode name refers to an overridden mode");
                this.mode = manager.getUnnamedMode();
            }
        }
        this.mode.setStreamable(this.streamable);
        if (this.streamable) {
            Mode omniMode = manager.obtainMode(Mode.OMNI_MODE, true);
            omniMode.setStreamable(true);
        }
        if (this.warningOnNoMatch) {
            this.defaultRules = new RuleSetWithWarnings(this.defaultRules);
        }
        this.mode.setBuiltInRuleSet(this.defaultRules);
        int recoveryPolicy = this.failOnMultipleMatch ? 2 : (this.warningOnMultipleMatch ? 1 : 0);
        this.mode.setRecoveryPolicy(recoveryPolicy);
        if (this.mode.getDeclaringComponent() == null) {
            this.mode.makeDeclaringComponent(visibility, this.getContainingPackage());
        }
        this.getContainingPackage().getComponent(this.mode.getSymbolicName()).setVisibility(visibility, visibilityAtt != null);
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkTopLevel("XTSE0010", false);
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("streamable") || f.equals("on-multiple-match") || f.equals("on-no-match") || f.equals("warning-on-multiple-match") || f.equals("warning-on-no-match") || f.equals("typed")) {
                String att = Whitespace.trim(atts.getValue(a));
                String normalizedAtt = "true".equals(att) || "1".equals(att) ? "yes" : ("false".equals(att) || "0".equals(att) ? "no" : att);
                this.mode.getActivePart().setExplicitProperty(f, normalizedAtt, decl.getPrecedence());
                if (!this.mode.isMustBeTyped() || !this.getContainingPackage().getTargetEdition().equals("JS")) continue;
                this.compileWarning("In Saxon-JS, all data is untyped", "XTTE3110");
                continue;
            }
            if (!f.equals("use-accumulators") || this.accumulators == null) continue;
            Object[] names = new String[this.accumulators.size()];
            int i = 0;
            for (Accumulator accumulator : this.accumulators) {
                names[i++] = accumulator.getAccumulatorName().getEQName();
            }
            Arrays.sort(names);
            String allNames = Arrays.toString(names);
            this.mode.getActivePart().setExplicitProperty(f, allNames, decl.getPrecedence());
        }
        this.checkEmpty();
        this.checkTopLevel("XTSE0010", false);
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        StylesheetPackage pack = this.getPrincipalStylesheetModule().getStylesheetPackage();
        Component c = pack.getComponent(this.mode.getSymbolicName());
        if (c == null) {
            throw new AssertionError();
        }
        if (this.accumulators != null) {
            this.mode.setAccumulators(this.accumulators);
        }
    }
}

