/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.opf.LinkedResources;
import com.adobe.epubcheck.opf.MetadataSet;
import com.adobe.epubcheck.opf.ResourceCollections;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class ResourceCollection {
    private final Set<String> roles;
    private final MetadataSet metadata;
    private final LinkedResources metadataLinks;
    private final ResourceCollections collections;
    private final LinkedResources resources;

    private ResourceCollection(Set<String> roles, MetadataSet metadata, LinkedResources metadataLinks, ResourceCollections collections, LinkedResources resources) {
        this.roles = roles;
        this.metadata = metadata;
        this.metadataLinks = metadataLinks;
        this.collections = collections;
        this.resources = resources;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        return role != null && this.roles.contains(role);
    }

    public boolean hasRole(Roles role) {
        return role != null && this.roles.contains(role.toString());
    }

    public MetadataSet getMetadata() {
        return this.metadata;
    }

    public LinkedResources getMetadataLinks() {
        return this.metadataLinks;
    }

    public ResourceCollections getCollections() {
        return this.collections;
    }

    public LinkedResources getResources() {
        return this.resources;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Set<String> roles = new HashSet<String>();
        private MetadataSet metadata = null;
        private LinkedResources metadataLinks = null;
        private final ResourceCollections.Builder collections = ResourceCollections.builder();
        private LinkedResources resources = null;

        public Builder roles(Iterable<String> roles) {
            Iterables.addAll(this.roles, roles);
            return this;
        }

        public Builder metadata(MetadataSet metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadataLinks(LinkedResources metadataLinks) {
            this.metadataLinks = metadataLinks;
            return this;
        }

        public Builder collection(ResourceCollection collection) {
            this.collections.add(collection);
            return this;
        }

        public Builder resources(LinkedResources resources) {
            this.resources = resources;
            return this;
        }

        public ResourceCollection build() {
            Preconditions.checkState((this.roles != null ? 1 : 0) != 0);
            return new ResourceCollection((Set)ImmutableSet.copyOf(this.roles), this.metadata != null ? this.metadata : MetadataSet.builder().build(), this.metadataLinks != null ? this.metadataLinks : LinkedResources.builder().build(), this.collections.build(), this.resources != null ? this.resources : LinkedResources.builder().build());
        }
    }

    public static enum Roles {
        DICTIONARY,
        DISTRIBUTABLE_OBJECT,
        INDEX,
        INDEX_GROUP,
        MANIFEST,
        PREVIEW,
        SCRIPTABLE_COMPONENT;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT).replace('_', '-');
        }

        public static Optional<Roles> fromString(String role) {
            try {
                return Optional.of((Object)((Object)Roles.valueOf(Strings.nullToEmpty((String)role).toUpperCase(Locale.ROOT).replace('-', '_'))));
            }
            catch (IllegalArgumentException e) {
                return Optional.absent();
            }
        }
    }
}

