# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_assemblyai.ipynb.

# %% auto 0
__all__ = ['submit_transcript', 'AssemblyAI']

# %% ../nbs/00_assemblyai.ipynb 2
from fastcore.utils import *
import requests

# %% ../nbs/00_assemblyai.ipynb 4
submit_transcript = "https://api.assemblyai.com/v2/transcript" # AssemblyAI endpoint
class AssemblyAI:
    ''' AssemblAI class for transcribing '''
    def __init__(self, #AssemblyAI
                 api_key:str # AssemblyAI API Key, Get it for free from https://app.assemblyai.com/
                ):
        self.api_key = api_key
    
    
    def get_headers(self):
        return {"authorization": self.api_key, "content-type": "application/json"}
    
    
    def get_status_of_transcription(self,
                                    transcripiton_id: str) -> str:
        endpoint = f"{submit_transcript}/{transcripiton_id}"
        response = requests.get(endpoint, headers=self.get_headers())
        
        return response.json()

# %% ../nbs/00_assemblyai.ipynb 5
@patch
def submit_url_for_transcription(self:AssemblyAI,
                                 audio_url: str, #Audio URL 
                                 sentiment_analysis: bool = False, # Include Sentiment Analysis
                                 auto_chapters: bool = False, # Include Auto Chapaters
                                 entity_detection: bool = False, # Include Entity Detection
                                 auto_highlights: bool = False, # Include Auto Highlights 
                                ):
        ''' Submit Audio/Video URL for Transcription '''
        json = {
            "audio_url": audio_url,
            "sentiment_analysis": sentiment_analysis,
            "auto_chapters": auto_chapters,
            "entity_detection": entity_detection,
            "auto_highlights": auto_highlights,
        }
        response = requests.post(submit_transcript, json=json, headers=self.get_headers())
        return response.json()

# %% ../nbs/00_assemblyai.ipynb 6
@patch
def get_transcription_results(self:AssemblyAI,
                              transcripiton_id: str, # Transcrption ID that we got from `submit_url_for_transcription`
                              all_details: bool = False # Include All the details, by default it `text` and `id` are returned
                             ):
    """Get the transcription results for the given id"""
    full_details = self.get_status_of_transcription(transcripiton_id)
    status = full_details.get("status")
    while status not in ["completed", "error"]:
        time.sleep(5)  # sleep for secs
        full_details = get_status_of_transcription(transcripiton_id)
        status = full_details.get("status")

    if all_details:
        return full_details


    return {
        "id": full_details.get("id"),
        "confidence": full_details.get("confidence"),
        "text": full_details.get("text"),
    }
