"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Product = exports.ProductProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "ProductProperty", { enumerable: true, get: function () { return iot_generated_1.RosProduct; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::Product`
 */
class Product extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::Product`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosProduct = new iot_generated_1.RosProduct(this, id, {
            publishAuto: props.publishAuto,
            description: props.description,
            iotInstanceId: props.iotInstanceId,
            productName: props.productName,
            resourceGroupId: props.resourceGroupId,
            aliyunCommodityCode: props.aliyunCommodityCode,
            categoryKey: props.categoryKey,
            protocolType: props.protocolType,
            id2: props.id2,
            nodeType: props.nodeType,
            dataFormat: props.dataFormat,
            authType: props.authType,
            joinPermissionId: props.joinPermissionId,
            netType: props.netType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProduct;
        this.attrIotInstanceId = rosProduct.attrIotInstanceId;
        this.attrProductKey = rosProduct.attrProductKey;
    }
}
exports.Product = Product;
//# sourceMappingURL=data:application/json;base64,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