"""
    NVIDIA NeMo LLM service

    # Introduction NeMo LLM Service offers state-of-the-art LLMs that were pre-trained on internet-scale text corpora. </br> With NeMo LLM Service API users can invoke the services from within their application code. </br> These models can be flexibly adapted to solve almost any language processing task for your use cases. You can conveniently and quickly try them out, and via an API that you can easily integrate into your applications. </br> Further, the NeMo LLM Service also offers customization capabilities, where the models can be effectively adapted to new tasks, using your own uploaded data.  ### Models:  The NeMo LLM Service is powered by a set of large language models of varying sizes and capabilities. Generally, larger models extend the capabilities of what smaller models can do with text. - Large models, such as the 530B, are excellent for complex tasks that require a deep understanding of human languages and all their nuances, such as text summarization, creative writing, or chatbot applications. - Medium models, such as the 20B, are faster than the large models. They are sufficiently good for many tasks such as writing emails and factual question answering. - Small models, such as the 5B, are the fastest and can perform many simple language tasks, such as text classification and spelling correction. </br></br> Each model can be used for \"Completion\" or text generation with One/Few-Shot Learning as well as \"Customization\" with your custom dataset. </br></br> ### The NeMo LLM Service API  comprises the following features:   - Text Completion. With one of the available and pre-trained model the LLM service responds to an input prompt by generating an extension to the provided intut text, that is, a completion. This technique can be used for solving multiple NLP tasks using Zero/Few-shot learning techniques.   - Model Customization. With which you can finetune an existing model on your own custom data in the form of prompt+completion pairs. This enhances the model’s ability to adapt to your use cases by ingesting hundreds to thousands of domain-specific examples.   Please **[submit NVBug](https://nvbugswb.nvidia.com/NvBugs5/SWBug.aspx?bugid=3682160&cmtNo=)** (by cloning and submitting) if discovered any issues.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nemollm.api_client import ApiClient
from nemollm.api_client import Endpoint as _Endpoint
from nemollm.model.completion_request_body import CompletionRequestBody
from nemollm.model.completion_response_body import CompletionResponseBody
from nemollm.model.create_customizations_request_body import CreateCustomizationsRequestBody
from nemollm.model.customization import Customization
from nemollm.model.customizations_list_response_body import CustomizationsListResponseBody
from nemollm.model.file import File
from nemollm.model.file_format import FileFormat
from nemollm.model.models_list_response import ModelsListResponse
from nemollm.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_customization_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/models/{model_id}/customizations',
                'operation_id': 'create_customization',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': ['model_id', 'create_customizations_request_body',],
                'required': ['model_id',],
                'nullable': [],
                'enum': [],
                'validation': [],
            },
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {
                    'model_id': (str,),
                    'create_customizations_request_body': (CreateCustomizationsRequestBody,),
                },
                'attribute_map': {'model_id': 'model_id',},
                'location_map': {'model_id': 'path', 'create_customizations_request_body': 'body',},
                'collection_format_map': {},
            },
            headers_map={'accept': [], 'content_type': ['application/json']},
            api_client=api_client,
        )
        self.delete_customization_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/models/{model_id}/customizations/{customization_id}',
                'operation_id': 'delete_customization',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': ['model_id', 'customization_id',],
                'required': ['model_id', 'customization_id',],
                'nullable': [],
                'enum': [],
                'validation': [],
            },
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {'model_id': (str,), 'customization_id': (str,),},
                'attribute_map': {'model_id': 'model_id', 'customization_id': 'customization_id',},
                'location_map': {'model_id': 'path', 'customization_id': 'path',},
                'collection_format_map': {},
            },
            headers_map={'accept': [], 'content_type': [],},
            api_client=api_client,
        )
        self.delete_file_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/files/{file_id}',
                'operation_id': 'delete_file',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={'all': ['file_id',], 'required': ['file_id',], 'nullable': [], 'enum': [], 'validation': []},
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {'file_id': (str,),},
                'attribute_map': {'file_id': 'file_id',},
                'location_map': {'file_id': 'path',},
                'collection_format_map': {},
            },
            headers_map={'accept': [], 'content_type': [],},
            api_client=api_client,
        )
        self.fetch_model_file_for_customization_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/models/{model_id}/customizations/{customization_id}/fetch',
                'operation_id': 'fetch_model_file_for_customization',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': ['model_id', 'customization_id',],
                'required': ['model_id', 'customization_id',],
                'nullable': [],
                'enum': [],
                'validation': [],
            },
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {'model_id': (str,), 'customization_id': (str,),},
                'attribute_map': {'model_id': 'model_id', 'customization_id': 'customization_id',},
                'location_map': {'model_id': 'path', 'customization_id': 'path',},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/octet-stream'], 'content_type': [],},
            api_client=api_client,
        )
        self.generate_completion_endpoint = _Endpoint(
            settings={
                'response_type': (CompletionResponseBody,),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/models/{model_id}/completions',
                'operation_id': 'generate_completion',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': ['model_id', 'completion_request_body',],
                'required': ['model_id',],
                'nullable': [],
                'enum': [],
                'validation': [],
            },
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {'model_id': (str,), 'completion_request_body': (CompletionRequestBody,),},
                'attribute_map': {'model_id': 'model_id',},
                'location_map': {'model_id': 'path', 'completion_request_body': 'body',},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': ['application/json']},
            api_client=api_client,
        )
        self.generate_customization_completion_endpoint = _Endpoint(
            settings={
                'response_type': (CompletionResponseBody,),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/models/{model_id}/customizations/{customization_id}/completions',
                'operation_id': 'generate_customization_completion',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': ['model_id', 'customization_id', 'completion_request_body',],
                'required': ['model_id', 'customization_id',],
                'nullable': [],
                'enum': [],
                'validation': [],
            },
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {
                    'model_id': (str,),
                    'customization_id': (str,),
                    'completion_request_body': (CompletionRequestBody,),
                },
                'attribute_map': {'model_id': 'model_id', 'customization_id': 'customization_id',},
                'location_map': {'model_id': 'path', 'customization_id': 'path', 'completion_request_body': 'body',},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': ['application/json']},
            api_client=api_client,
        )
        self.get_customization_endpoint = _Endpoint(
            settings={
                'response_type': (Customization,),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/models/{model_id}/customizations/{customization_id}',
                'operation_id': 'get_customization',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': ['model_id', 'customization_id',],
                'required': ['model_id', 'customization_id',],
                'nullable': [],
                'enum': [],
                'validation': [],
            },
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {'model_id': (str,), 'customization_id': (str,),},
                'attribute_map': {'model_id': 'model_id', 'customization_id': 'customization_id',},
                'location_map': {'model_id': 'path', 'customization_id': 'path',},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': [],},
            api_client=api_client,
        )
        self.get_file_endpoint = _Endpoint(
            settings={
                'response_type': (File,),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/files/{file_id}',
                'operation_id': 'get_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={'all': ['file_id',], 'required': ['file_id',], 'nullable': [], 'enum': [], 'validation': []},
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {'file_id': (str,),},
                'attribute_map': {'file_id': 'file_id',},
                'location_map': {'file_id': 'path',},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': [],},
            api_client=api_client,
        )
        self.list_customizations_endpoint = _Endpoint(
            settings={
                'response_type': (CustomizationsListResponseBody,),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/customizations',
                'operation_id': 'list_customizations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': ['shared', 'page', 'page_size', 'sort_by', 'order',],
                'required': [],
                'nullable': [],
                'enum': ['shared', 'sort_by', 'order',],
                'validation': ['page', 'page_size',],
            },
            root_map={
                'validations': {
                    ('page',): {'inclusive_minimum': 1,},
                    ('page_size',): {'inclusive_maximum': 100, 'inclusive_minimum': 1,},
                },
                'allowed_values': {
                    ('shared',): {"PRIVATE": "private", "PUBLIC": "public"},
                    ('sort_by',): {"CREATED_AT": "created_at", "UPDATED_AT": "updated_at"},
                    ('order',): {"ASC": "asc", "DESC": "desc"},
                },
                'openapi_types': {
                    'shared': (str,),
                    'page': (int,),
                    'page_size': (int,),
                    'sort_by': (str,),
                    'order': (str,),
                },
                'attribute_map': {
                    'shared': 'shared',
                    'page': 'page',
                    'page_size': 'page_size',
                    'sort_by': 'sort_by',
                    'order': 'order',
                },
                'location_map': {
                    'shared': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'sort_by': 'query',
                    'order': 'query',
                },
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': [],},
            api_client=api_client,
        )
        self.list_customizations_for_model_endpoint = _Endpoint(
            settings={
                'response_type': ([Customization],),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/models/{model_id}/customizations',
                'operation_id': 'list_customizations_for_model',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': ['model_id', 'shared',],
                'required': ['model_id',],
                'nullable': [],
                'enum': ['shared',],
                'validation': [],
            },
            root_map={
                'validations': {},
                'allowed_values': {('shared',): {"PRIVATE": "private", "PUBLIC": "public"},},
                'openapi_types': {'model_id': (str,), 'shared': (str,),},
                'attribute_map': {'model_id': 'model_id', 'shared': 'shared',},
                'location_map': {'model_id': 'path', 'shared': 'query',},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': [],},
            api_client=api_client,
        )
        self.list_files_endpoint = _Endpoint(
            settings={
                'response_type': ([File],),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/files',
                'operation_id': 'list_files',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={'all': [], 'required': [], 'nullable': [], 'enum': [], 'validation': []},
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {},
                'attribute_map': {},
                'location_map': {},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': [],},
            api_client=api_client,
        )
        self.list_models_endpoint = _Endpoint(
            settings={
                'response_type': (ModelsListResponse,),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/models',
                'operation_id': 'list_models',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={'all': [], 'required': [], 'nullable': [], 'enum': [], 'validation': []},
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {},
                'attribute_map': {},
                'location_map': {},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': [],},
            api_client=api_client,
        )
        self.upload_file_endpoint = _Endpoint(
            settings={
                'response_type': (File,),
                'auth': ['ApiKeyAuth'],
                'endpoint_path': '/files',
                'operation_id': 'upload_file',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': ['file', 'format',],
                'required': ['file', 'format',],
                'nullable': [],
                'enum': [],
                'validation': ['file',],
            },
            root_map={
                'validations': {},
                'allowed_values': {},
                'openapi_types': {'file': (file_type,), 'format': (FileFormat,),},
                'attribute_map': {'file': 'file', 'format': 'format',},
                'location_map': {'file': 'form', 'format': 'form',},
                'collection_format_map': {},
            },
            headers_map={'accept': ['application/json'], 'content_type': ['multipart/form-data']},
            api_client=api_client,
        )

    def create_customization(self, model_id, **kwargs):
        """Create model customization  # noqa: E501

        This API endpoint allows the creation of a new customized model using an available uploaded dataset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customization(model_id, async_req=True)
        >>> result = thread.get()

        Args:
            model_id (str): The Model ID. Completion requests can be sent to different backend engines serving different models. 

        Keyword Args:
            create_customizations_request_body (CreateCustomizationsRequestBody): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['model_id'] = model_id
        return self.create_customization_endpoint.call_with_http_info(**kwargs)

    def delete_customization(self, model_id, customization_id, **kwargs):
        """Delete the custom model  # noqa: E501

        Delete the customization of the model created by user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_customization(model_id, customization_id, async_req=True)
        >>> result = thread.get()

        Args:
            model_id (str): The Model ID. Completion requests can be sent to different backend engines serving different models. 
            customization_id (str): The customization ID 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['model_id'] = model_id
        kwargs['customization_id'] = customization_id
        return self.delete_customization_endpoint.call_with_http_info(**kwargs)

    def delete_file(self, file_id, **kwargs):
        """Delete file  # noqa: E501

        Delete file (dataset).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file(file_id, async_req=True)
        >>> result = thread.get()

        Args:
            file_id (str): File ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['file_id'] = file_id
        return self.delete_file_endpoint.call_with_http_info(**kwargs)

    def fetch_model_file_for_customization(self, model_id, customization_id, **kwargs):
        """Fetch NEMO file with trained prompt tokens  # noqa: E501

        Fetch NEMO file with trained prompt tokens.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_model_file_for_customization(model_id, customization_id, async_req=True)
        >>> result = thread.get()

        Args:
            model_id (str): The Model ID. Completion requests can be sent to different backend engines serving different models. 
            customization_id (str): The customization ID 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['model_id'] = model_id
        kwargs['customization_id'] = customization_id
        return self.fetch_model_file_for_customization_endpoint.call_with_http_info(**kwargs)

    def generate_completion(self, model_id, **kwargs):
        """Create text completion  # noqa: E501

        The text completion function is the center of the NeMo LLM service, generating a text completion given the prompt and hyperparameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_completion(model_id, async_req=True)
        >>> result = thread.get()

        Args:
            model_id (str): The Model ID. Completion requests can be sent to different backend engines serving different models. 

        Keyword Args:
            completion_request_body (CompletionRequestBody): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CompletionResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['model_id'] = model_id
        return self.generate_completion_endpoint.call_with_http_info(**kwargs)

    def generate_customization_completion(self, model_id, customization_id, **kwargs):
        """Create text completion with customized model  # noqa: E501

        Creates a text completion with one of the models customized by the user given a prompt and hyperparameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_customization_completion(model_id, customization_id, async_req=True)
        >>> result = thread.get()

        Args:
            model_id (str): The Model ID. Completion requests can be sent to different backend engines serving different models. 
            customization_id (str): The customization ID 

        Keyword Args:
            completion_request_body (CompletionRequestBody): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CompletionResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['model_id'] = model_id
        kwargs['customization_id'] = customization_id
        return self.generate_customization_completion_endpoint.call_with_http_info(**kwargs)

    def get_customization(self, model_id, customization_id, **kwargs):
        """Get info about model customization  # noqa: E501

        Get information and status about the custom model. Can be used for checking the status of the customization process.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_customization(model_id, customization_id, async_req=True)
        >>> result = thread.get()

        Args:
            model_id (str): The Model ID. Completion requests can be sent to different backend engines serving different models. 
            customization_id (str): The customization ID 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Customization
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['model_id'] = model_id
        kwargs['customization_id'] = customization_id
        return self.get_customization_endpoint.call_with_http_info(**kwargs)

    def get_file(self, file_id, **kwargs):
        """Get file  # noqa: E501

        Download file (dataset) in jsonl format that can be used for model customization or validation of the customized model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file(file_id, async_req=True)
        >>> result = thread.get()

        Args:
            file_id (str): File ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            File
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['file_id'] = file_id
        return self.get_file_endpoint.call_with_http_info(**kwargs)

    def list_customizations(self, **kwargs):
        """List customizations for the model  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_customizations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            shared (str): Public and private customizations. [optional]
            page (int): Page number. [optional] if omitted the server will use the default value of 1
            page_size (int): Number of results per page. [optional] if omitted the server will use the default value of 15
            sort_by (str): Sort results by the specified field. [optional] if omitted the server will use the default value of "created_at"
            order (str): Order the results. [optional] if omitted the server will use the default value of "desc"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CustomizationsListResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_customizations_endpoint.call_with_http_info(**kwargs)

    def list_customizations_for_model(self, model_id, **kwargs):
        """List models customizations  # noqa: E501

        This API endpoint returns the list of models customized by user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_customizations_for_model(model_id, async_req=True)
        >>> result = thread.get()

        Args:
            model_id (str): The Model ID. Completion requests can be sent to different backend engines serving different models. 

        Keyword Args:
            shared (str): Public and private customizations. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Customization]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['model_id'] = model_id
        return self.list_customizations_for_model_endpoint.call_with_http_info(**kwargs)

    def list_files(self, **kwargs):
        """List all files  # noqa: E501

        Provides a list of all files uploaded by the user. These files are datasets in jsonl format that can be used for model customization or validation of the customized model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_files(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [File]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_files_endpoint.call_with_http_info(**kwargs)

    def list_models(self, **kwargs):
        """List models  # noqa: E501

        An API function is provides to obtain a list of all models available for text completion as well as for customization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_models(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ModelsListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_models_endpoint.call_with_http_info(**kwargs)

    def upload_file(self, file, format, **kwargs):
        """Upload file  # noqa: E501

        Upload file in jsonl format that can be used for model customization or validation of the customized model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_file(file, format, async_req=True)
        >>> result = thread.get()

        Args:
            file (file_type):
            format (FileFormat):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            File
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get('async_req', False)
        kwargs['_return_http_data_only'] = kwargs.get('_return_http_data_only', True)
        kwargs['_preload_content'] = kwargs.get('_preload_content', True)
        kwargs['_request_timeout'] = kwargs.get('_request_timeout', None)
        kwargs['_check_input_type'] = kwargs.get('_check_input_type', True)
        kwargs['_check_return_type'] = kwargs.get('_check_return_type', True)
        kwargs['_spec_property_naming'] = kwargs.get('_spec_property_naming', False)
        kwargs['_content_type'] = kwargs.get('_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['file'] = file
        kwargs['format'] = format
        return self.upload_file_endpoint.call_with_http_info(**kwargs)
