# flake8: noqa

"""
    NVIDIA NeMo LLM service

    # Introduction NeMo LLM Service offers state-of-the-art LLMs that were pre-trained on internet-scale text corpora. </br> With NeMo LLM Service API users can invoke the services from within their application code. </br> These models can be flexibly adapted to solve almost any language processing task for your use cases. You can conveniently and quickly try them out, and via an API that you can easily integrate into your applications. </br> Further, the NeMo LLM Service also offers customization capabilities, where the models can be effectively adapted to new tasks, using your own uploaded data.  ### Models:  The NeMo LLM Service is powered by a set of large language models of varying sizes and capabilities. Generally, larger models extend the capabilities of what smaller models can do with text. - Large models, such as the 530B, are excellent for complex tasks that require a deep understanding of human languages and all their nuances, such as text summarization, creative writing, or chatbot applications. - Medium models, such as the 20B, are faster than the large models. They are sufficiently good for many tasks such as writing emails and factual question answering. - Small models, such as the 5B, are the fastest and can perform many simple language tasks, such as text classification and spelling correction. </br></br> Each model can be used for \"Completion\" or text generation with One/Few-Shot Learning as well as \"Customization\" with your custom dataset. </br></br> ### The NeMo LLM Service API  comprises the following features:   - Text Completion. With one of the available and pre-trained model the LLM service responds to an input prompt by generating an extension to the provided intut text, that is, a completion. This technique can be used for solving multiple NLP tasks using Zero/Few-shot learning techniques.   - Model Customization. With which you can finetune an existing model on your own custom data in the form of prompt+completion pairs. This enhances the model’s ability to adapt to your use cases by ingesting hundreds to thousands of domain-specific examples.   Please **[submit NVBug](https://nvbugswb.nvidia.com/NvBugs5/SWBug.aspx?bugid=3682160&cmtNo=)** (by cloning and submitting) if discovered any issues.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


__version__ = "0.1.0"

from nemollm.api.default_api import DefaultApi

# import ApiClient
from nemollm.api_client import ApiClient

# import Configuration
from nemollm.configuration import Configuration

# import exceptions
from nemollm.exceptions import (
    ApiAttributeError,
    ApiException,
    ApiKeyError,
    ApiTypeError,
    ApiValueError,
    OpenApiException,
)
from nemollm.handy import Connection
from nemollm.model.completion_request_body import CompletionRequestBody
from nemollm.model.completion_response_body import CompletionResponseBody
from nemollm.model.create_customizations_request_body import CreateCustomizationsRequestBody
from nemollm.model.create_customizations_request_body_additional_hyperparameters import (
    CreateCustomizationsRequestBodyAdditionalHyperparameters,
)
from nemollm.model.customization import Customization
from nemollm.model.customizations_list_response_body import CustomizationsListResponseBody
from nemollm.model.file import File
from nemollm.model.file_format import FileFormat
from nemollm.model.models_list_response import ModelsListResponse
from nemollm.model.p_tuning_hyperparms import PTuningHyperparms
