# nemollm
# Introduction
NVIDIA NeMo LLM service provides a simple and powerful REST API to interact with large language models.
This API reference provides information on available endpoints and how to interact with it.

Please **[submit NVBug](https://nvbugswb.nvidia.com/NvBugs5/SWBug.aspx?bugid=3682160&cmtNo=)** (by cloning and submitting) if discovered any issues.
Copyright (c) 2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.1.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

Import the package:
```python
import nemollm
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nemollm
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import nemollm
from pprint import pprint
from nemollm.api import default_api
from nemollm.model.completion_request_body import CompletionRequestBody
from nemollm.model.completion_response_body import CompletionResponseBody
from nemollm.model.create_customizations_request_body import CreateCustomizationsRequestBody
from nemollm.model.customization import Customization
from nemollm.model.file import File
from nemollm.model.file_format import FileFormat
from nemollm.model.models_list_response import ModelsListResponse
# Defining the host is optional and defaults to https://api.bignlp.nvidia.com/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = nemollm.Configuration(
    host = "https://api.bignlp.nvidia.com/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: ApiKeyAuth
configuration = nemollm.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with nemollm.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    model_id = "gpt530b" # str | The Model ID. Completion requests can be sent to different backend engines serving different models. 
    create_customizations_request_body = CreateCustomizationsRequestBody(
        name="question answering",
        description="Question answering customization trained on squad-1k dataset",
        prompt_template="context: {question} Question: {question} answer:",
        training_dataset_file_id="4d32c02f-5e54-42cb-968c-042c4d3021fe",
        validation_dataset_file_id="4d32c02f-5e54-42cb-968c-042c4d3021fe",
        batch_size=64,
        epochs=25,
        learning_rate=0.00010,
        additional_hyperparameters=CreateCustomizationsRequestBodyAdditionalHyperparameters(None),
    ) # CreateCustomizationsRequestBody |  (optional)

    try:
        # Create a customization for a base model trained on a custom dataset.
        api_instance.create_customization(model_id, create_customizations_request_body=create_customizations_request_body)
    except nemollm.ApiException as e:
        print("Exception when calling DefaultApi->create_customization: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.bignlp.nvidia.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_customization**](docs/DefaultApi.md#create_customization) | **POST** /models/{model_id}/customizations | Create a customization for a base model trained on a custom dataset.
*DefaultApi* | [**delete_customization**](docs/DefaultApi.md#delete_customization) | **DELETE** /models/{model_id}/customizations/{customization_id} | Delete the custom model
*DefaultApi* | [**delete_file**](docs/DefaultApi.md#delete_file) | **DELETE** /files/{file_id} | Delete file
*DefaultApi* | [**fetch_model_file_for_customization**](docs/DefaultApi.md#fetch_model_file_for_customization) | **GET** /models/{model_id}/customizations/{customization_id}/fetch | Fetch NEMO file with trained prompt tokens
*DefaultApi* | [**generate_completion**](docs/DefaultApi.md#generate_completion) | **POST** /models/{model_id}/completions | Create text completion.
*DefaultApi* | [**generate_customization_completion**](docs/DefaultApi.md#generate_customization_completion) | **POST** /models/{model_id}/customizations/{customization_id}/completions | Create text completion using customization for a model
*DefaultApi* | [**get_customization**](docs/DefaultApi.md#get_customization) | **GET** /models/{model_id}/customizations/{customization_id} | Get information and status about the custom model
*DefaultApi* | [**get_file**](docs/DefaultApi.md#get_file) | **GET** /files/{file_id} | Get file
*DefaultApi* | [**list_customizations_for_model**](docs/DefaultApi.md#list_customizations_for_model) | **GET** /models/{model_id}/customizations | List downstream customizations for the model
*DefaultApi* | [**list_files**](docs/DefaultApi.md#list_files) | **GET** /files | List all files
*DefaultApi* | [**list_models**](docs/DefaultApi.md#list_models) | **GET** /models | List available models
*DefaultApi* | [**upload_file**](docs/DefaultApi.md#upload_file) | **POST** /files | File upload


## Documentation For Models

 - [Classification](docs/Classification.md)
 - [CompletionRequestBody](docs/CompletionRequestBody.md)
 - [CompletionResponseBody](docs/CompletionResponseBody.md)
 - [CreateCustomizationsRequestBody](docs/CreateCustomizationsRequestBody.md)
 - [CreateCustomizationsRequestBodyAdditionalHyperparameters](docs/CreateCustomizationsRequestBodyAdditionalHyperparameters.md)
 - [Customization](docs/Customization.md)
 - [CustomizationStatus](docs/CustomizationStatus.md)
 - [File](docs/File.md)
 - [FileFormat](docs/FileFormat.md)
 - [Model](docs/Model.md)
 - [ModelsListResponse](docs/ModelsListResponse.md)
 - [PTuningHyperparms](docs/PTuningHyperparms.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: Bearer authentication


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in nemollm.apis and nemollm.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from nemollm.api.default_api import DefaultApi`
- `from nemollm.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import nemollm
from nemollm.apis import *
from nemollm.models import *
```

