# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/03d_utils.config.ipynb.

# %% auto 0
__all__ = ['set_config', 'get_config', 'config']

# %% ../../nbs/03d_utils.config.ipynb 3
from copy import copy
from types import SimpleNamespace
from contextlib import contextmanager

import numpy as np

# %% ../../nbs/03d_utils.config.ipynb 4
_config = SimpleNamespace(
    precision     = 3,    # Digits after `.`
    threshold_max = 3,    # .abs() larger than 1e3 -> Sci mode
    threshold_min = -4,    # .abs() smaller that 1e-4 -> Sci mode
    sci_mode      = None, # None = auto. Otherwise, force sci mode (2.3e4) on/off.
    indent        = 2,    # Indent for .deeper()
    color         = True, # ANSI colors in text
)

# %% ../../nbs/03d_utils.config.ipynb 5
def set_config( precision       :int =None,     # Digits after `.`
                threshold_min   :int =None,     # .abs() larger than 1e3 -> Sci mode
                threshold_max   :int =None,     # .abs() smaller that 1e-4 -> Sci mode
                sci_mode        :bool=None,     # None = auto. Otherwise, force sci mode (2.3e4) on/off.
                indent          :bool=None,     # Indent for .deeper()
                color           :bool=None):    # ANSI colors in text

    "Set config variables"
    for k,v in locals().items():
        if v is not None: setattr(_config, k, v)

# %% ../../nbs/03d_utils.config.ipynb 6
def get_config():
    "Get a copy of config variables"
    return copy(_config)

# %% ../../nbs/03d_utils.config.ipynb 7
@contextmanager
def config( precision       :int =None,     # Digits after `.`
            threshold_min   :int =None,     # .abs() larger than 1e3 -> Sci mode
            threshold_max   :int =None,     # .abs() smaller that 1e-4 -> Sci mode
            sci_mode        :bool=None,     # None = auto. Otherwise, force sci mode (2.3e4) on/off.
            indent          :bool=None,     # Indent for .deeper()
            color           :bool=None):    # ANSI colors in text
    "Context manager for temporarily setting printting options."
    global _config
    new_opts = locals()
    opts = get_config()

    try:
        set_config(**new_opts)
        yield
    finally:
        _config = opts
