# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_repr_str.ipynb.

# %% auto 0
__all__ = ['lovely']

# %% ../nbs/00_repr_str.ipynb 3
from typing import Optional, Union
from collections import defaultdict
from fastcore.foundation import store_attr
import warnings
import numpy as np

from .utils import pretty_str, history_warning, sparse_join, np_to_str_common
from .utils.config import get_config

# %% ../nbs/00_repr_str.ipynb 5
dtnames =   {   "float16": "f16",
                "float32": "f32",
                "float64": "", # Default dtype in numpy
                "uint8": "u8",
                "uint16": "u16",
                "uint32": "u32",
                "uint64": "u64",
                "int8": "i8",
                "int16": "i16",
                "int32": "i32",
                "int64": "i64",
            }

def short_dtype(x: Union[np.ndarray, np.generic]): return dtnames.get(x.dtype.name, str(x.dtype)[6:])

# %% ../nbs/00_repr_str.ipynb 8
def lovely(x: Union[np.ndarray, np.generic], # The data you want to explore 
            plain: bool=False,               # Plain old way
            verbose: bool=False,             # Both summaty and plain
            depth=0,                         # Show deeper summary, up to `depth`
            lvl=0,                           # Indentation level 
            color: bool=None                 # Override `get_config().color`
            ) -> str:                        # The summary

    "Pretty-print the stats of a numpy array or scalar"

    if plain or not np.isrealobj(x):
        return repr(x)
    
    if isinstance(x, np.generic):
        tname = None
    else: 
        tname = "array" if type(x) == np.ndarray else type(x).__name__.split(".")[-1]

    shape = str(list(x.shape)) if x.ndim else None
    type_str = sparse_join([tname, shape], sep="")

    color = get_config().color if color is None else color
    common = np_to_str_common(x, color=color)
    dtype = short_dtype(x)
    
    vals = pretty_str(x) if x.size <= 10 else None
    res = sparse_join([type_str, dtype, common, vals])

    if verbose:
        res += "\n" + repr(x)

    if depth and x.ndim > 1:
        res += "\n" + "\n".join([
            " " * get_config().indent * (lvl+1) +
            str(lovely(x[i,:], depth=depth-1, lvl=lvl+1))
            for i in range(x.shape[0])])

    return res
