# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/pdf.ipynb.

# %% auto 0
__all__ = ['PDF']

# %% ../nbs/pdf.ipynb 2
from .loader import np, subplots, show, resize, L

try:
    from pdf2image import convert_from_path
except:
    ...

# %% ../nbs/pdf.ipynb 3
class PDF:
    """Load a PDF file from `path` as a list of images
    Use `show` function to see the images
    **WIP**"""

    def __init__(self, path, bbss=None, dfs=None):
        self.path = path
        self.ims = convert_from_path(path)
        self.ims = L([resize(np.array(im), 1.5) for im in self.ims])
        self.bbss = L(bbss) if bbss is not None else L([None] * len(self))
        self.dfs = L(dfs) if dfs is not None else L([None] * len(self))

    def __len__(self):
        return len(self.ims)

    def __getitem__(self, ix):
        return self.ims[ix]

    def show(self, ix=None, ixs=None, **kwargs):
        if ixs is not None:
            assert isinstance(ixs, (list, L))
            subplots(L(self.ims)[ixs], bbss=self.bbss[ixs], **kwargs)
        if ix is not None:
            show(self.ims[ix], bbs=self.bbss[ix], **kwargs)
            return

        if len(self) == 1:
            show(self.ims[0], df=self.dfs[0], bbs=self.bbss[0], **kwargs)
        else:
            subplots(self.ims, dfs=self.dfs, bbss=self.bbss, **kwargs)

