# Copyright 2015 Oliver Cope
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#     Unless required by applicable law or agreed to in writing, software
#     distributed under the License is distributed on an "AS IS" BASIS,
#     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#     See the License for the specific language governing permissions and
#     limitations under the License.
#
# flake8: noqa
from base64 import b64decode

multipart_samples = []
formencoded_samples = []

# 1k block of random bytes
FILE_UPLOAD_DATA = b64decode(
    b"""
QJHX77oVa5GoHaIthmjSe8i8r6AhNIpIYx9Yw46gDqifTyd14aE/hWGoTCMR0hjFcE0GAQ7KE/S7
wnpoaAMManjCR4wD39lzhUsUPLy1N/ANwAEo0fk93y8ggEhbN8lEi0zl5rIecC1ZsEA8WG4dw3gh
61FRZdZ/fG8sojnfAjWM9UnSdhkd6idvF8qwKGBRpFPFUT4gRNu+di4i9r6+XQ7IiXbc2KXiXyy0
7AsrcOsOOiincLkw/IvDVYUgZmUiTqs0XKHfsFexpznIVIKubYGGlGpIyBdq04VmtPoQvj9weqZh
di5F9jlGBJ479vHNS+6xwbnxqpSNkAkzsBOQ6a68Ae9in1R0t+UIlUlRKG6jsUelkbJlq3+qnzqt
RFBuOneh/vdlFEhuXQSxZ4a7oPl+wuv94fE6AsWyiV4urZR16CaioAbeozrd5MOqBkKk7Q2TyWX/
hHA05mlv6g4/34lh5N4UWH8YTLEjgL9ykMJ6zodmGujmvmYwIiVQuhIcjsZ5n0m0zYBlDP4BDspV
bQsTxPa+0ptiQJ+qTStqPWCDaNFO6Fwdia7jxs7asPAuCwIcgUL2ztmCfafvlniMSwC8lmjs77Zt
gvgeCWr6IoASWOso1oEFsCgk6HMEU+XW5bLD5h5cva0/on/K1wwpFF+FQlQEqvd2cAEFZrZ8Dk4E
zKK+tdU3qK5maooKTIwpj8llk3ENpRAZXJUYRpUzvdb3m4kDg+sHCbZw5t8bpC5Oph89AHytc+Op
zY6+/UUHiUuIuf0hflVqQgb9uangMAkHkMyjw6o7dFPPanfu2j0DouqGF2QKRczdcs9itbWh65/O
PX1KbztEqAAxTqZixNI9qkG8A9rW24lDX6QFSws/0Wjh/UUvixAq9u/Dobbqn+hUgsQl2xqoMtci
sRJajasOPIyIOgwpLP5ul2DMIqZUDmAii3OcOQL4y4b0vgUHk26iNp9omPpzenJuAECoyIE8KnEf
SK1Cv9mQOU6Gbl3gyLsMp9fdsespzLFv8M+VrlaLCDTgL6OL2DW9SwOH4FWKH8qAjJfTsWnhqpbS
PBRsHlujXX1lAZC5eKCA4ekug2+aW7g+Mpse2Rt1XP4w8UZ231bxCYmYsKrzsB5f/0Pfp/vAjYHm
GYtj6RBhRoTym2Sm/A1VOOOBYSRPZXeqdx2WoIrGtSlkEZnH2ySM5z1Se6v9y4uI0TN5Oa5q691G
UegOAO9Yx4oa1L+7BXs+lkIqz94bVCLNI6gwLC+QOhz6iC96LyagKZtcYyagLeiQGhh91oJXWCCm
sz4EbqNbiEtfTa6LhAs+mkLSOfrAsyWLr/reTu4uHwJXsGzgn17Uhe/+VxV74/yEuwTLTbHHgA==
"""
)

# Mozilla/5.0 (X11; U; FreeBSD i386; en-US; rv:1.9.0.11) Gecko/2009061410 Firefox/3.0.11
multipart_samples.append(
    {
        "content_length": "1638",
        "data": b'-----------------------------1282332249122276511499183892\r\nContent-Disposition: form-data; name="empty-text-input"\r\n\r\n\r\n-----------------------------1282332249122276511499183892\r\nContent-Disposition: form-data; name="text-input-ascii"\r\n\r\nabcdef\r\n-----------------------------1282332249122276511499183892\r\nContent-Disposition: form-data; name="text-input-unicode"\r\n\r\n\xce\xb1\xce\xb2\xce\xb3\xce\xb4\r\n-----------------------------1282332249122276511499183892\r\nContent-Disposition: form-data; name="file-upload"; filename="test.data"\r\nContent-Type: application/octet-stream\r\n\r\n@\x91\xd7\xef\xba\x15k\x91\xa8\x1d\xa2-\x86h\xd2{\xc8\xbc\xaf\xa0!4\x8aHc\x1fX\xc3\x8e\xa0\x0e\xa8\x9fO\'u\xe1\xa1?\x85a\xa8L#\x11\xd2\x18\xc5pM\x06\x01\x0e\xca\x13\xf4\xbb\xc2zhh\x03\x0cjx\xc2G\x8c\x03\xdf\xd9s\x85K\x14<\xbc\xb57\xf0\r\xc0\x01(\xd1\xf9=\xdf/ \x80H[7\xc9D\x8bL\xe5\xe6\xb2\x1ep-Y\xb0@<Xn\x1d\xc3x!\xebQQe\xd6\x7f|o,\xa29\xdf\x025\x8c\xf5I\xd2v\x19\x1d\xea\'o\x17\xca\xb0(`Q\xa4S\xc5Q> D\xdb\xbev."\xf6\xbe\xbe]\x0e\xc8\x89v\xdc\xd8\xa5\xe2_,\xb4\xec\x0b+p\xeb\x0e:(\xa7p\xb90\xfc\x8b\xc3U\x85 fe"N\xab4\\\xa1\xdf\xb0W\xb1\xa79\xc8T\x82\xaem\x81\x86\x94jH\xc8\x17j\xd3\x85f\xb4\xfa\x10\xbe?pz\xa6av.E\xf69F\x04\x9e;\xf6\xf1\xcdK\xee\xb1\xc1\xb9\xf1\xaa\x94\x8d\x90\t3\xb0\x13\x90\xe9\xae\xbc\x01\xefb\x9fTt\xb7\xe5\x08\x95IQ(n\xa3\xb1G\xa5\x91\xb2e\xab\x7f\xaa\x9f:\xadDPn:w\xa1\xfe\xf7e\x14Hn]\x04\xb1g\x86\xbb\xa0\xf9~\xc2\xeb\xfd\xe1\xf1:\x02\xc5\xb2\x89^.\xad\x94u\xe8&\xa2\xa0\x06\xde\xa3:\xdd\xe4\xc3\xaa\x06B\xa4\xed\r\x93\xc9e\xff\x84p4\xe6io\xea\x0e?\xdf\x89a\xe4\xde\x14X\x7f\x18L\xb1#\x80\xbfr\x90\xc2z\xce\x87f\x1a\xe8\xe6\xbef0"%P\xba\x12\x1c\x8e\xc6y\x9fI\xb4\xcd\x80e\x0c\xfe\x01\x0e\xcaUm\x0b\x13\xc4\xf6\xbe\xd2\x9bb@\x9f\xaaM+j=`\x83h\xd1N\xe8\\\x1d\x89\xae\xe3\xc6\xce\xda\xb0\xf0.\x0b\x02\x1c\x81B\xf6\xce\xd9\x82}\xa7\xef\x96x\x8cK\x00\xbc\x96h\xec\xef\xb6m\x82\xf8\x1e\tj\xfa"\x80\x12X\xeb(\xd6\x81\x05\xb0($\xe8s\x04S\xe5\xd6\xe5\xb2\xc3\xe6\x1e\\\xbd\xad?\xa2\x7f\xca\xd7\x0c)\x14_\x85BT\x04\xaa\xf7vp\x01\x05f\xb6|\x0eN\x04\xcc\xa2\xbe\xb5\xd57\xa8\xaefj\x8a\nL\x8c)\x8f\xc9e\x93q\r\xa5\x10\x19\\\x95\x18F\x953\xbd\xd6\xf7\x9b\x89\x03\x83\xeb\x07\t\xb6p\xe6\xdf\x1b\xa4.N\xa6\x1f=\x00|\xads\xe3\xa9\xcd\x8e\xbe\xfdE\x07\x89K\x88\xb9\xfd!~UjB\x06\xfd\xb9\xa9\xe00\t\x07\x90\xcc\xa3\xc3\xaa;tS\xcfjw\xee\xda=\x03\xa2\xea\x86\x17d\nE\xcc\xddr\xcfb\xb5\xb5\xa1\xeb\x9f\xce=}Jo;D\xa8\x001N\xa6b\xc4\xd2=\xaaA\xbc\x03\xda\xd6\xdb\x89C_\xa4\x05K\x0b?\xd1h\xe1\xfdE/\x8b\x10*\xf6\xef\xc3\xa1\xb6\xea\x9f\xe8T\x82\xc4%\xdb\x1a\xa82\xd7"\xb1\x12Z\x8d\xab\x0e<\x8c\x88:\x0c),\xfen\x97`\xcc"\xa6T\x0e`"\x8bs\x9c9\x02\xf8\xcb\x86\xf4\xbe\x05\x07\x93n\xa26\x9fh\x98\xfaszrn\x00@\xa8\xc8\x81<*q\x1fH\xadB\xbf\xd9\x909N\x86n]\xe0\xc8\xbb\x0c\xa7\xd7\xdd\xb1\xeb)\xcc\xb1o\xf0\xcf\x95\xaeV\x8b\x084\xe0/\xa3\x8b\xd85\xbdK\x03\x87\xe0U\x8a\x1f\xca\x80\x8c\x97\xd3\xb1i\xe1\xaa\x96\xd2<\x14l\x1e[\xa3]}e\x01\x90\xb9x\xa0\x80\xe1\xe9.\x83o\x9a[\xb8>2\x9b\x1e\xd9\x1bu\\\xfe0\xf1Fv\xdfV\xf1\t\x89\x98\xb0\xaa\xf3\xb0\x1e_\xffC\xdf\xa7\xfb\xc0\x8d\x81\xe6\x19\x8bc\xe9\x10aF\x84\xf2\x9bd\xa6\xfc\rU8\xe3\x81a$Oew\xaaw\x1d\x96\xa0\x8a\xc6\xb5)d\x11\x99\xc7\xdb$\x8c\xe7=R{\xab\xfd\xcb\x8b\x88\xd13y9\xaej\xeb\xddFQ\xe8\x0e\x00\xefX\xc7\x8a\x1a\xd4\xbf\xbb\x05{>\x96B*\xcf\xde\x1bT"\xcd#\xa80,/\x90:\x1c\xfa\x88/z/&\xa0)\x9b\\c&\xa0-\xe8\x90\x1a\x18}\xd6\x82WX \xa6\xb3>\x04n\xa3[\x88K_M\xae\x8b\x84\x0b>\x9aB\xd29\xfa\xc0\xb3%\x8b\xaf\xfa\xdeN\xee.\x1f\x02W\xb0l\xe0\x9f^\xd4\x85\xef\xfeW\x15{\xe3\xfc\x84\xbb\x04\xcbM\xb1\xc7\x80\r\n-----------------------------1282332249122276511499183892--\r\n',
        "content_type": "multipart/form-data; boundary=---------------------------1282332249122276511499183892",
    }
)

# Mozilla/5.0 (X11; U; FreeBSD i386; en-US; rv:1.9.0.11) Gecko/2009061410 Firefox/3.0.11
formencoded_samples.append(
    {
        "content_length": "85",
        "data": b"empty-text-input=&text-input-ascii=abcdef&text-input-unicode=%CE%B1%CE%B2%CE%B3%CE%B4",
        "content_type": "application/x-www-form-urlencoded",
    }
)

# Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; InfoPath.2)
multipart_samples.append(
    {
        "content_length": "1616",
        "data": b'-----------------------------7d91772e200be\r\nContent-Disposition: form-data; name="empty-text-input"\r\n\r\n\r\n-----------------------------7d91772e200be\r\nContent-Disposition: form-data; name="text-input-ascii"\r\n\r\nabcdef\r\n-----------------------------7d91772e200be\r\nContent-Disposition: form-data; name="text-input-unicode"\r\n\r\n\xce\xb1\xce\xb2\xce\xb3\xce\xb4\r\n-----------------------------7d91772e200be\r\nContent-Disposition: form-data; name="file-upload"; filename="C:\\Documents and Settings\\Administrator\\My Documents\\test.data"\r\nContent-Type: application/octet-stream\r\n\r\n@\x91\xd7\xef\xba\x15k\x91\xa8\x1d\xa2-\x86h\xd2{\xc8\xbc\xaf\xa0!4\x8aHc\x1fX\xc3\x8e\xa0\x0e\xa8\x9fO\'u\xe1\xa1?\x85a\xa8L#\x11\xd2\x18\xc5pM\x06\x01\x0e\xca\x13\xf4\xbb\xc2zhh\x03\x0cjx\xc2G\x8c\x03\xdf\xd9s\x85K\x14<\xbc\xb57\xf0\r\xc0\x01(\xd1\xf9=\xdf/ \x80H[7\xc9D\x8bL\xe5\xe6\xb2\x1ep-Y\xb0@<Xn\x1d\xc3x!\xebQQe\xd6\x7f|o,\xa29\xdf\x025\x8c\xf5I\xd2v\x19\x1d\xea\'o\x17\xca\xb0(`Q\xa4S\xc5Q> D\xdb\xbev."\xf6\xbe\xbe]\x0e\xc8\x89v\xdc\xd8\xa5\xe2_,\xb4\xec\x0b+p\xeb\x0e:(\xa7p\xb90\xfc\x8b\xc3U\x85 fe"N\xab4\\\xa1\xdf\xb0W\xb1\xa79\xc8T\x82\xaem\x81\x86\x94jH\xc8\x17j\xd3\x85f\xb4\xfa\x10\xbe?pz\xa6av.E\xf69F\x04\x9e;\xf6\xf1\xcdK\xee\xb1\xc1\xb9\xf1\xaa\x94\x8d\x90\t3\xb0\x13\x90\xe9\xae\xbc\x01\xefb\x9fTt\xb7\xe5\x08\x95IQ(n\xa3\xb1G\xa5\x91\xb2e\xab\x7f\xaa\x9f:\xadDPn:w\xa1\xfe\xf7e\x14Hn]\x04\xb1g\x86\xbb\xa0\xf9~\xc2\xeb\xfd\xe1\xf1:\x02\xc5\xb2\x89^.\xad\x94u\xe8&\xa2\xa0\x06\xde\xa3:\xdd\xe4\xc3\xaa\x06B\xa4\xed\r\x93\xc9e\xff\x84p4\xe6io\xea\x0e?\xdf\x89a\xe4\xde\x14X\x7f\x18L\xb1#\x80\xbfr\x90\xc2z\xce\x87f\x1a\xe8\xe6\xbef0"%P\xba\x12\x1c\x8e\xc6y\x9fI\xb4\xcd\x80e\x0c\xfe\x01\x0e\xcaUm\x0b\x13\xc4\xf6\xbe\xd2\x9bb@\x9f\xaaM+j=`\x83h\xd1N\xe8\\\x1d\x89\xae\xe3\xc6\xce\xda\xb0\xf0.\x0b\x02\x1c\x81B\xf6\xce\xd9\x82}\xa7\xef\x96x\x8cK\x00\xbc\x96h\xec\xef\xb6m\x82\xf8\x1e\tj\xfa"\x80\x12X\xeb(\xd6\x81\x05\xb0($\xe8s\x04S\xe5\xd6\xe5\xb2\xc3\xe6\x1e\\\xbd\xad?\xa2\x7f\xca\xd7\x0c)\x14_\x85BT\x04\xaa\xf7vp\x01\x05f\xb6|\x0eN\x04\xcc\xa2\xbe\xb5\xd57\xa8\xaefj\x8a\nL\x8c)\x8f\xc9e\x93q\r\xa5\x10\x19\\\x95\x18F\x953\xbd\xd6\xf7\x9b\x89\x03\x83\xeb\x07\t\xb6p\xe6\xdf\x1b\xa4.N\xa6\x1f=\x00|\xads\xe3\xa9\xcd\x8e\xbe\xfdE\x07\x89K\x88\xb9\xfd!~UjB\x06\xfd\xb9\xa9\xe00\t\x07\x90\xcc\xa3\xc3\xaa;tS\xcfjw\xee\xda=\x03\xa2\xea\x86\x17d\nE\xcc\xddr\xcfb\xb5\xb5\xa1\xeb\x9f\xce=}Jo;D\xa8\x001N\xa6b\xc4\xd2=\xaaA\xbc\x03\xda\xd6\xdb\x89C_\xa4\x05K\x0b?\xd1h\xe1\xfdE/\x8b\x10*\xf6\xef\xc3\xa1\xb6\xea\x9f\xe8T\x82\xc4%\xdb\x1a\xa82\xd7"\xb1\x12Z\x8d\xab\x0e<\x8c\x88:\x0c),\xfen\x97`\xcc"\xa6T\x0e`"\x8bs\x9c9\x02\xf8\xcb\x86\xf4\xbe\x05\x07\x93n\xa26\x9fh\x98\xfaszrn\x00@\xa8\xc8\x81<*q\x1fH\xadB\xbf\xd9\x909N\x86n]\xe0\xc8\xbb\x0c\xa7\xd7\xdd\xb1\xeb)\xcc\xb1o\xf0\xcf\x95\xaeV\x8b\x084\xe0/\xa3\x8b\xd85\xbdK\x03\x87\xe0U\x8a\x1f\xca\x80\x8c\x97\xd3\xb1i\xe1\xaa\x96\xd2<\x14l\x1e[\xa3]}e\x01\x90\xb9x\xa0\x80\xe1\xe9.\x83o\x9a[\xb8>2\x9b\x1e\xd9\x1bu\\\xfe0\xf1Fv\xdfV\xf1\t\x89\x98\xb0\xaa\xf3\xb0\x1e_\xffC\xdf\xa7\xfb\xc0\x8d\x81\xe6\x19\x8bc\xe9\x10aF\x84\xf2\x9bd\xa6\xfc\rU8\xe3\x81a$Oew\xaaw\x1d\x96\xa0\x8a\xc6\xb5)d\x11\x99\xc7\xdb$\x8c\xe7=R{\xab\xfd\xcb\x8b\x88\xd13y9\xaej\xeb\xddFQ\xe8\x0e\x00\xefX\xc7\x8a\x1a\xd4\xbf\xbb\x05{>\x96B*\xcf\xde\x1bT"\xcd#\xa80,/\x90:\x1c\xfa\x88/z/&\xa0)\x9b\\c&\xa0-\xe8\x90\x1a\x18}\xd6\x82WX \xa6\xb3>\x04n\xa3[\x88K_M\xae\x8b\x84\x0b>\x9aB\xd29\xfa\xc0\xb3%\x8b\xaf\xfa\xdeN\xee.\x1f\x02W\xb0l\xe0\x9f^\xd4\x85\xef\xfeW\x15{\xe3\xfc\x84\xbb\x04\xcbM\xb1\xc7\x80\r\n-----------------------------7d91772e200be--\r\n',
        "content_type": "multipart/form-data; boundary=---------------------------7d91772e200be",
    }
)

# Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; InfoPath.2)
formencoded_samples.append(
    {
        "content_length": "85",
        "data": b"empty-text-input=&text-input-ascii=abcdef&text-input-unicode=%CE%B1%CE%B2%CE%B3%CE%B4",
        "content_type": "application/x-www-form-urlencoded",
    }
)
