/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = global || self, global.mapboxgl = factory());
}(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = 'var sharedChunk = {}; (' + shared + ')(sharedChunk); (' + worker + ')(sharedChunk);'

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined') {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){"use strict";var e=r;function r(t,e,r,i){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(i-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=i,this.p2x=r,this.p2y=i;}r.prototype.sampleCurveX=function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},r.prototype.sampleCurveY=function(t){return ((this.ay*t+this.by)*t+this.cy)*t},r.prototype.sampleCurveDerivativeX=function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},r.prototype.solveCurveX=function(t,e){var r,i,n,s,a;for(void 0===e&&(e=1e-6),n=t,a=0;a<8;a++){if(s=this.sampleCurveX(n)-t,Math.abs(s)<e)return n;var o=this.sampleCurveDerivativeX(n);if(Math.abs(o)<1e-6)break;n-=s/o;}if((n=t)<(r=0))return r;if(n>(i=1))return i;for(;r<i;){if(s=this.sampleCurveX(n),Math.abs(s-t)<e)return n;t>s?r=n:i=n,n=.5*(i-r)+r;}return n},r.prototype.solve=function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))};var i=n;function n(t,e){this.x=t,this.y=e;}n.prototype={clone:function(){return new n(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),i=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=i,this},_rotateAround:function(t,e){var r=Math.cos(t),i=Math.sin(t),n=e.y+i*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-i*(this.y-e.y),this.y=n,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},n.convert=function(t){return t instanceof n?t:Array.isArray(t)?new n(t[0],t[1]):t};var s="undefined"!=typeof self?self:{};function a(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!a(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!a(t[r],e[r]))return !1;return !0}return t===e}const o=Math.pow(2,53)-1,l=Math.PI/180,u=180/Math.PI;function c(t){return t*l}function h(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function p(t,r,i,n){const s=new e(t,r,i,n);return function(t){return s.solve(t)}}const d=p(.25,.1,.25,1);function f(t,e,r){return Math.min(r,Math.max(e,t))}function y(t,e,r){const i=r-e,n=((t-e)%i+i)%i+e;return n===e?r:n}function m(t){const e=[];for(const r in t)e.push(t[r]);return e}function g(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let x=1;function v(){return x++}function b(){return function t(e){return e?(e^16*Math.random()>>e/4).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()}function w(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)}function _(t,e){t.forEach(t=>{e[t]&&(e[t]=e[t].bind(e));});}function A(t,e){return -1!==t.indexOf(e,t.length-e.length)}function k(t,e,r){const i={};for(const n in t)i[n]=e.call(r||this,t[n],n,t);return i}function S(t,e,r){const i={};for(const n in t)e.call(r||this,t[n],n,t)&&(i[n]=t[n]);return i}function I(t){return Array.isArray(t)?t.map(I):"object"==typeof t&&t?k(t,I):t}const T={};function z(t){T[t]||("undefined"!=typeof console&&console.warn(t),T[t]=!0);}function E(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function C(t){let e=0;for(let r,i,n=0,s=t.length,a=s-1;n<s;a=n++)r=t[n],i=t[a],e+=(i.x-r.x)*(r.y+i.y);return e}function M(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function B(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,(t,r,i,n)=>{const s=i||n;return e[r]=!s||s.toLowerCase(),""}),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let D,P,V=null;function F(t){if(null==V){const e=t.navigator?t.navigator.userAgent:null;V=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return V}function R(t){try{const e=s[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}}let L,U=!1;const O={now:()=>void 0!==L?L:s.performance.now(),setErrorState(){U=!0;},setNow(t){L=t;},restoreNow(){L=void 0;},frame(t){if(U)return {cancel:()=>{}};const e=s.requestAnimationFrame(t);return {cancel:()=>s.cancelAnimationFrame(e)}},getImageData(t,e=0){const r=s.document.createElement("canvas"),i=r.getContext("2d");if(!i)throw new Error("failed to create canvas 2d context");return r.width=t.width,r.height=t.height,i.drawImage(t,0,0,t.width,t.height),i.getImageData(-e,-e,t.width+2*e,t.height+2*e)},resolveURL:t=>(D||(D=s.document.createElement("a")),D.href=t,D.href),get devicePixelRatio(){return s.devicePixelRatio},get prefersReducedMotion(){return !!s.matchMedia&&(null==P&&(P=s.matchMedia("(prefers-reduced-motion: reduce)")),P.matches)}};let $;const q={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==$){const t=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{$=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):t;}catch(e){$=t;}}return $},get EVENTS_URL(){return this.API_URL?0===this.API_URL.indexOf("https://api.mapbox.cn")?"https://events.mapbox.cn/events/v2":0===this.API_URL.indexOf("https://api.mapbox.com")?"https://events.mapbox.com/events/v2":null:null},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,MAX_PARALLEL_IMAGE_REQUESTS:16},N={supported:!1,testSupport:function(t){!Z&&K&&(X?G(t):j=t);}};let j,K,Z=!1,X=!1;function G(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,K),t.isContextLost())return;N.supported=!0;}catch(t){}t.deleteTexture(e),Z=!0;}s.document&&(K=s.document.createElement("img"),K.onload=function(){j&&G(j),j=null,X=!0;},K.onerror=function(){Z=!0,j=null;},K.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const H="01";function J(t){return 0===t.indexOf("mapbox:")}function Y(t){return q.API_URL_REGEX.test(t)}const W=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function Q(t){const e=t.match(W);if(!e)throw new Error("Unable to parse URL object");return {protocol:e[1],authority:e[2],path:e[3]||"/",params:e[4]?e[4].split("&"):[]}}function tt(t){const e=t.params.length?`?${t.params.join("&")}`:"";return `${t.protocol}://${t.authority}${t.path}${e}`}function et(t){if(!t)return null;const e=t.split(".");if(!e||3!==e.length)return null;try{return JSON.parse(decodeURIComponent(s.atob(e[1]).split("").map(t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2)).join("")))}catch(t){return null}}class rt{constructor(t){this.type=t,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const e=et(q.ACCESS_TOKEN);let r="";return r=e&&e.u?s.btoa(encodeURIComponent(e.u).replace(/%([0-9A-F]{2})/g,(t,e)=>String.fromCharCode(Number("0x"+e)))):q.ACCESS_TOKEN||"",t?`mapbox.eventData.${t}:${r}`:`mapbox.eventData:${r}`}fetchEventData(){const t=R("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{const t=s.localStorage.getItem(e);t&&(this.eventData=JSON.parse(t));const i=s.localStorage.getItem(r);i&&(this.anonId=i);}catch(t){z("Unable to read from LocalStorage");}}saveEventData(){const t=R("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{s.localStorage.setItem(r,this.anonId),Object.keys(this.eventData).length>=1&&s.localStorage.setItem(e,JSON.stringify(this.eventData));}catch(t){z("Unable to write to LocalStorage");}}processRequests(t){}postEvent(t,e,r,i){if(!q.EVENTS_URL)return;const n=Q(q.EVENTS_URL);n.params.push(`access_token=${i||q.ACCESS_TOKEN||""}`);const s={event:this.type,created:new Date(t).toISOString(),sdkIdentifier:"mapbox-gl-js",sdkVersion:"2.0.1",skuId:H,userId:this.anonId},a=e?g(s,e):s,o={url:tt(n),headers:{"Content-Type":"text/plain"},body:JSON.stringify([a])};this.pendingRequest=At(o,t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(i);});}queueRequest(t,e){this.queue.push(t),this.processRequests(e);}}const it=new class extends rt{constructor(t){super("appUserTurnstile"),this._customAccessToken=t;}postTurnstileEvent(t,e){q.EVENTS_URL&&q.ACCESS_TOKEN&&Array.isArray(t)&&t.some(t=>J(t)||Y(t))&&this.queueRequest(Date.now(),e);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const e=et(q.ACCESS_TOKEN),r=e?e.u:q.ACCESS_TOKEN;let i=r!==this.eventData.tokenU;w(this.anonId)||(this.anonId=b(),i=!0);const n=this.queue.shift();if(this.eventData.lastSuccess){const t=new Date(this.eventData.lastSuccess),e=new Date(n),r=(n-this.eventData.lastSuccess)/864e5;i=i||r>=1||r<-1||t.getDate()!==e.getDate();}else i=!0;if(!i)return this.processRequests();this.postEvent(n,{"enabled.telemetry":!1},t=>{t||(this.eventData.lastSuccess=n,this.eventData.tokenU=r);},t);}},nt=it.postTurnstileEvent.bind(it),st=new class extends rt{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,e,r,i){this.skuToken=e,this.errorCb=i,q.EVENTS_URL&&(r||q.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error("A valid Mapbox access token is required to use Mapbox GL JS. To create an account or a new access token, visit https://account.mapbox.com/")));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||(this.anonId||this.fetchEventData(),w(this.anonId)||(this.anonId=b()),this.postEvent(r,{skuToken:this.skuToken},t=>{t?this.errorCb(t):e&&(this.success[e]=!0);},t));}},at=st.postMapLoadEvent.bind(st),ot=new class extends rt{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,e,r,i){if(!q.API_URL||!q.SESSION_PATH)return;const n=Q(q.API_URL+q.SESSION_PATH);n.params.push(`sku=${e||""}`),n.params.push(`access_token=${i||q.ACCESS_TOKEN||""}`);const s={url:tt(n),headers:{"Content-Type":"text/plain"}};this.pendingRequest=kt(s,t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(i);});}getSessionAPI(t,e,r,i){this.skuToken=e,this.errorCb=i,q.SESSION_PATH&&q.API_URL&&(r||q.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error("NO_ACCESS_TOKEN")));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||this.getSession(r,this.skuToken,t=>{t?this.errorCb(t):e&&(this.success[e]=!0);},t);}},lt=ot.getSessionAPI.bind(ot);let ut,ct,ht=500,pt=50;function dt(){s.caches&&!ut&&(ut=s.caches.open("mapbox-tiles"));}function ft(t){const e=t.indexOf("?");return e<0?t:t.slice(0,e)}let yt,mt=1/0;function gt(){return null==yt&&(yt=s.OffscreenCanvas&&new s.OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof s.createImageBitmap),yt}const xt={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image"};"function"==typeof Object.freeze&&Object.freeze(xt);class vt extends Error{constructor(t,e,r){401===e&&Y(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://www.mapbox.com/api-documentation/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const bt=M()?()=>self.worker&&self.worker.referrer:()=>("blob:"===s.location.protocol?s.parent:s).location.href;const wt=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(bt())&&!/^\w+:/.test(r))){if(s.fetch&&s.Request&&s.AbortController&&s.Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new s.AbortController,i=new s.Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:bt(),signal:r.signal});let n=!1,a=!1;const o=(l=i.url).indexOf("sku=")>0&&Y(l);var l;"json"===t.type&&i.headers.set("Accept","application/json");const u=(r,n,l)=>{if(a)return;if(r&&"SecurityError"!==r.message&&z(r),n&&l)return c(n);const u=Date.now();s.fetch(i).then(r=>{if(r.ok){const t=o?r.clone():null;return c(r,t,u)}return e(new vt(r.statusText,r.status,t.url))}).catch(t=>{20!==t.code&&e(new Error(t.message));});},c=(r,o,l)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then(t=>{a||(o&&l&&function(t,e,r){if(dt(),!ut)return;const i={status:e.status,statusText:e.statusText,headers:new s.Headers};e.headers.forEach((t,e)=>i.headers.set(e,t));const n=B(e.headers.get("Cache-Control")||"");n["no-store"]||(n["max-age"]&&i.headers.set("Expires",new Date(r+1e3*n["max-age"]).toUTCString()),new Date(i.headers.get("Expires")).getTime()-r<42e4||function(t,e){if(void 0===ct)try{new Response(new ReadableStream),ct=!0;}catch(t){ct=!1;}ct?e(t.body):t.blob().then(e);}(e,e=>{const r=new s.Response(e,i);dt(),ut&&ut.then(e=>e.put(ft(t.url),r)).catch(t=>z(t.message));}));}(i,o,l),n=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));}).catch(t=>{a||e(new Error(t.message));});};return o?function(t,e){if(dt(),!ut)return e(null);const r=ft(t.url);ut.then(t=>{t.match(r).then(i=>{const n=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=B(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(i);t.delete(r),n&&t.put(r,i.clone()),e(null,i,n);}).catch(e);}).catch(e);}(i,u):u(null,null),{cancel:()=>{a=!0,n||r.abort();}}}(t,e);if(M()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new s.XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let i=r.response;if("json"===t.type)try{i=JSON.parse(r.response);}catch(t){return e(t)}e(null,i,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new vt(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},_t=function(t,e){return wt(g(t,{type:"arrayBuffer"}),e)},At=function(t,e){return wt(g(t,{method:"POST"}),e)},kt=function(t,e){return wt(g(t,{method:"GET"}),e)};function St(t){const e=s.document.createElement("a");return e.href=t,e.protocol===s.document.location.protocol&&e.host===s.document.location.host}const It="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let Tt,zt;Tt=[],zt=0;const Et=function(t,e){if(N.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),zt>=q.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return Tt.push(r),r}zt++;let r=!1;const i=()=>{if(!r)for(r=!0,zt--;Tt.length&&zt<q.MAX_PARALLEL_IMAGE_REQUESTS;){const t=Tt.shift(),{requestParameters:e,callback:r,cancelled:i}=t;i||(t.cancel=Et(e,r).cancel);}},n=_t(t,(t,r,n,a)=>{i(),t?e(t):r&&(gt()?function(t,e){const r=new s.Blob([new Uint8Array(t)],{type:"image/png"});s.createImageBitmap(r).then(t=>{e(null,t);}).catch(t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));});}(r,e):function(t,e,r,i){const n=new s.Image,a=s.URL;n.onload=()=>{e(null,n),a.revokeObjectURL(n.src),n.onload=null,s.requestAnimationFrame(()=>{n.src=It;});},n.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const o=new s.Blob([new Uint8Array(t)],{type:"image/png"});n.cacheControl=r,n.expires=i,n.src=t.byteLength?a.createObjectURL(o):It;}(r,e,n,a));});return {cancel:()=>{n.cancel(),i();}}};function Ct(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function Mt(t,e,r){if(r&&r[t]){const i=r[t].indexOf(e);-1!==i&&r[t].splice(i,1);}}class Bt{constructor(t,e={}){g(this,e),this.type=t;}}class Dt extends Bt{constructor(t,e={}){super("error",g({error:t},e));}}class Pt{on(t,e){return this._listeners=this._listeners||{},Ct(t,e,this._listeners),this}off(t,e){return Mt(t,e,this._listeners),Mt(t,e,this._oneTimeListeners),this}once(t,e){return this._oneTimeListeners=this._oneTimeListeners||{},Ct(t,e,this._oneTimeListeners),this}fire(t,e){"string"==typeof t&&(t=new Bt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const i=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of i)Mt(r,e,this._oneTimeListeners),e.call(this,t);const n=this._eventedParent;n&&(g(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(t));}else t instanceof Dt&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var Vt={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},light:{type:"light"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"string"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{}},default:"mapbox"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{},sky:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background","layout_sky"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_sky:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{},within:{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number","property-type":"data-constant",default:1,minimum:0,maximum:1e3,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_sky:{"sky-type":{type:"enum",values:{gradient:{},atmosphere:{}},default:"atmosphere",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{type:"array",value:"number",length:2,transition:!1,requires:[{"sky-type":"atmosphere"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{type:"number",requires:[{"sky-type":"atmosphere"}],default:10,minimum:0,maximum:100,transition:!1,"property-type":"data-constant"},"sky-gradient-center":{type:"array",requires:[{"sky-type":"gradient"}],value:"number",default:[0,0],length:2,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{type:"number",requires:[{"sky-type":"gradient"}],default:90,minimum:0,maximum:180,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-gradient":{type:"color",default:["interpolate",["linear"],["sky-radial-progress"],.8,"#87ceeb",1,"white"],transition:!1,requires:[{"sky-type":"gradient"}],expression:{interpolated:!0,parameters:["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{type:"color",default:"white",transition:!1,requires:[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-atmosphere-color":{type:"color",default:"white",transition:!1,requires:[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};class Ft{constructor(t,e,r,i){this.message=(t?`${t}: `:"")+r,i&&(this.identifier=i),null!=e&&e.__line__&&(this.line=e.__line__);}}function Rt(t){const e=t.value;return e?[new Ft(t.key,e,"constants have been deprecated as of v8")]:[]}function Lt(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function Ut(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Ot(t){if(Array.isArray(t))return t.map(Ot);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Ot(t[r]);return e}return Ut(t)}class $t extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class qt{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new qt(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Nt={kind:"null"},jt={kind:"number"},Kt={kind:"string"},Zt={kind:"boolean"},Xt={kind:"color"},Gt={kind:"object"},Ht={kind:"value"},Jt={kind:"collator"},Yt={kind:"formatted"},Wt={kind:"resolvedImage"};function Qt(t,e){return {kind:"array",itemType:t,N:e}}function te(t){if("array"===t.kind){const e=te(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const ee=[Nt,jt,Kt,Zt,Xt,Yt,Gt,Qt(Ht),Wt];function re(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!re(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of ee)if(!re(t,e))return null}return `Expected ${te(t)} but found ${te(e)} instead.`}function ie(t,e){return e.some(e=>e.kind===t.kind)}function ne(t,e){return e.some(e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t)}function se(t,e){return t(e={exports:{}},e.exports),e.exports}var ae=se((function(t,e){var r={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function i(t){return (t=Math.round(t))<0?0:t>255?255:t}function n(t){return i("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function s(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function a(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{e.parseCSSColor=function(t){var e,o=t.replace(/ /g,"").toLowerCase();if(o in r)return r[o].slice();if("#"===o[0])return 4===o.length?(e=parseInt(o.substr(1),16))>=0&&e<=4095?[(3840&e)>>4|(3840&e)>>8,240&e|(240&e)>>4,15&e|(15&e)<<4,1]:null:7===o.length&&(e=parseInt(o.substr(1),16))>=0&&e<=16777215?[(16711680&e)>>16,(65280&e)>>8,255&e,1]:null;var l=o.indexOf("("),u=o.indexOf(")");if(-1!==l&&u+1===o.length){var c=o.substr(0,l),h=o.substr(l+1,u-(l+1)).split(","),p=1;switch(c){case"rgba":if(4!==h.length)return null;p=s(h.pop());case"rgb":return 3!==h.length?null:[n(h[0]),n(h[1]),n(h[2]),p];case"hsla":if(4!==h.length)return null;p=s(h.pop());case"hsl":if(3!==h.length)return null;var d=(parseFloat(h[0])%360+360)%360/360,f=s(h[1]),y=s(h[2]),m=y<=.5?y*(f+1):y+f-y*f,g=2*y-m;return [i(255*a(g,m,d+1/3)),i(255*a(g,m,d)),i(255*a(g,m,d-1/3)),p];default:return null}}return null};}catch(t){}})).parseCSSColor;class oe{constructor(t,e,r,i=1){this.r=t,this.g=e,this.b=r,this.a=i;}static parse(t){if(!t)return;if(t instanceof oe)return t;if("string"!=typeof t)return;const e=ae(t);return e?new oe(e[0]/255*e[3],e[1]/255*e[3],e[2]/255*e[3],e[3]):void 0}toString(){const[t,e,r,i]=this.toArray();return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${i})`}toArray(){const{r:t,g:e,b:r,a:i}=this;return 0===i?[0,0,0,0]:[255*t/i,255*e/i,255*r/i,i]}}oe.black=new oe(0,0,0,1),oe.white=new oe(1,1,1,1),oe.transparent=new oe(0,0,0,0),oe.red=new oe(1,0,0,1),oe.blue=new oe(0,0,1,1);class le{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class ue{constructor(t,e,r,i,n){this.text=t,this.image=e,this.scale=r,this.fontStack=i,this.textColor=n;}}class ce{constructor(t){this.sections=t;}static fromString(t){return new ce([new ue(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some(t=>0!==t.text.length||t.image&&0!==t.image.name.length)}static factory(t){return t instanceof ce?t:ce.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map(t=>t.text).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){t.push(["image",e.image.name]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toArray())),t.push(r);}return t}}class he{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new he({name:t,available:!1}):null}serialize(){return ["image",this.name]}}function pe(t,e,r,i){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===i||"number"==typeof i&&i>=0&&i<=1?null:`Invalid rgba value [${[t,e,r,i].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof i?[t,e,r,i]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function de(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof oe)return !0;if(t instanceof le)return !0;if(t instanceof ce)return !0;if(t instanceof he)return !0;if(Array.isArray(t)){for(const e of t)if(!de(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!de(t[e]))return !1;return !0}return !1}function fe(t){if(null===t)return Nt;if("string"==typeof t)return Kt;if("boolean"==typeof t)return Zt;if("number"==typeof t)return jt;if(t instanceof oe)return Xt;if(t instanceof le)return Jt;if(t instanceof ce)return Yt;if(t instanceof he)return Wt;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=fe(e);if(r){if(r===t)continue;r=Ht;break}r=t;}return Qt(r||Ht,e)}return Gt}function ye(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof oe||t instanceof ce||t instanceof he?t.toString():JSON.stringify(t)}class me{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!de(t[1]))return e.error("invalid value");const r=t[1];let i=fe(r);const n=e.expectedType;return "array"!==i.kind||0!==i.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(i=n),new me(i,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof oe?["rgba"].concat(this.value.toArray()):this.value instanceof ce?this.value.serialize():this.value}}class ge{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const xe={string:Kt,number:jt,boolean:Zt,object:Gt};class ve{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,i=1;const n=t[0];if("array"===n){let n,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in xe)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);n=xe[r],i++;}else n=Ht;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],i++;}r=Qt(n,s);}else r=xe[n];const s=[];for(;i<t.length;i++){const r=e.parse(t[i],i,Ht);if(!r)return null;s.push(r);}return new ve(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!re(this.type,fe(r)))return r;if(e===this.args.length-1)throw new ge(`Expected value to be of type ${te(this.type)}, but found ${te(fe(r))} instead.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined())}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const i=t.N;("number"==typeof i||this.args.length>1)&&e.push(i);}}return e.concat(this.args.map(t=>t.serialize()))}}class be{constructor(t){this.type=Yt,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const i=[];let n=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(n&&"object"==typeof s&&!Array.isArray(s)){n=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,jt),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,Qt(Kt)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,Xt),!a))return null;const o=i[i.length-1];o.scale=t,o.font=r,o.textColor=a;}else {const s=e.parse(t[r],1,Ht);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,i.push({content:s,scale:null,font:null,textColor:null});}}return new be(i)}evaluate(t){return new ce(this.sections.map(e=>{const r=e.content.evaluate(t);return fe(r)===Wt?new ue("",r,null,null,null):new ue(ye(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)}))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class we{constructor(t){this.type=Wt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Kt);return r?new we(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=he.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){return ["image",this.input.serialize()]}}const _e={"to-boolean":Zt,"to-color":Xt,"to-number":jt,"to-string":Kt};class Ae{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const i=_e[r],n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],r,Ht);if(!i)return null;n.push(i);}return new Ae(i,n)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const i of this.args){if(e=i.evaluate(t),r=null,e instanceof oe)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:pe(e[0],e[1],e[2],e[3]),!r))return new oe(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new ge(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const i=Number(e);if(!isNaN(i))return i}throw new ge(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?ce.fromString(ye(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?he.fromString(ye(this.args[0].evaluate(t))):ye(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined())}serialize(){if("formatted"===this.type.kind)return new be([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new we(this.args[0]).serialize();const t=[`to-${this.type.kind}`];return this.eachChild(e=>{t.push(e.serialize());}),t}}const ke=["Unknown","Point","LineString","Polygon"];class Se{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?ke[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=oe.parse(t)),e}}class Ie{constructor(t,e,r,i){this.name=t,this.type=e,this._evaluate=r,this.args=i;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map(t=>t.serialize()))}static parse(t,e){const r=t[0],i=Ie.definitions[r];if(!i)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(i)?i[0]:i.type,s=Array.isArray(i)?[[i[1],i[2]]]:i.overloads,a=s.filter(([e])=>!Array.isArray(e)||e.length===t.length-1);let o=null;for(const[i,s]of a){o=new Ge(e.registry,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],n=Array.isArray(i)?i[e-1]:i.type,s=o.parse(r,1+a.length,n);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(i)&&i.length!==a.length)o.error(`Expected ${i.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(i)?i[t]:i.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Ie(r,n,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map(([t])=>{return e=t,Array.isArray(e)?`(${e.map(te).join(", ")})`:`(${te(e.type)}...)`;var e;}).join(" | "),i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],1+i.length);if(!n)return null;i.push(te(n.type));}e.error(`Expected arguments of type ${r}, but found (${i.join(", ")}) instead.`);}return null}static register(t,e){Ie.definitions=e;for(const r in e)t[r]=Ie;}}class Te{constructor(t,e,r){this.type=Jt,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const i=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,Zt);if(!i)return null;const n=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,Zt);if(!n)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,Kt),!s)?null:new Te(i,n,s)}evaluate(t){return new le(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}function ze(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Ee(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Ce(t,e){const r=(180+t[0])/360,i=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,n=Math.pow(2,e.z);return [Math.round(r*n*8192),Math.round(i*n*8192)]}function Me(t,e,r){const i=t[0]-e[0],n=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return i*a-s*n==0&&i*s<=0&&n*a<=0}function Be(t,e){let r=!1;for(let a=0,o=e.length;a<o;a++){const o=e[a];for(let e=0,a=o.length;e<a-1;e++){if(Me(t,o[e],o[e+1]))return !1;(n=o[e])[1]>(i=t)[1]!=(s=o[e+1])[1]>i[1]&&i[0]<(s[0]-n[0])*(i[1]-n[1])/(s[1]-n[1])+n[0]&&(r=!r);}}var i,n,s;return r}function De(t,e){for(let r=0;r<e.length;r++)if(Be(t,e[r]))return !0;return !1}function Pe(t,e,r,i){const n=i[0]-r[0],s=i[1]-r[1],a=(t[0]-r[0])*s-n*(t[1]-r[1]),o=(e[0]-r[0])*s-n*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function Ve(t,e,r){for(const u of r)for(let r=0;r<u.length-1;++r)if(0!=(o=[(a=u[r+1])[0]-(s=u[r])[0],a[1]-s[1]])[0]*(l=[(n=e)[0]-(i=t)[0],n[1]-i[1]])[1]-o[1]*l[0]&&Pe(i,n,s,a)&&Pe(s,a,i,n))return !0;var i,n,s,a,o,l;return !1}function Fe(t,e){for(let r=0;r<t.length;++r)if(!Be(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(Ve(t[r],t[r+1],e))return !1;return !0}function Re(t,e){for(let r=0;r<e.length;r++)if(Fe(t,e[r]))return !0;return !1}function Le(t,e,r){const i=[];for(let n=0;n<t.length;n++){const s=[];for(let i=0;i<t[n].length;i++){const a=Ce(t[n][i],r);ze(e,a),s.push(a);}i.push(s);}return i}function Ue(t,e,r){const i=[];for(let n=0;n<t.length;n++){const s=Le(t[n],e,r);i.push(s);}return i}function Oe(t,e,r,i){if(t[0]<r[0]||t[0]>r[2]){const e=.5*i;let n=t[0]-r[0]>e?-i:r[0]-t[0]>e?i:0;0===n&&(n=t[0]-r[2]>e?-i:r[2]-t[0]>e?i:0),t[0]+=n;}ze(e,t);}function $e(t,e,r,i){const n=8192*Math.pow(2,i.z),s=[8192*i.x,8192*i.y],a=[];for(const i of t)for(const t of i){const i=[t.x+s[0],t.y+s[1]];Oe(i,e,r,n),a.push(i);}return a}function qe(t,e,r,i){const n=8192*Math.pow(2,i.z),s=[8192*i.x,8192*i.y],a=[];for(const r of t){const t=[];for(const i of r){const r=[i.x+s[0],i.y+s[1]];ze(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=n/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const i of t)Oe(i,e,r,n);}var o;return a}class Ne{constructor(t,e){this.type=Zt,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(de(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new Ne(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Ne(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Ne(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],i=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Le(e.coordinates,i,n),a=$e(t.geometry(),r,i,n);if(!Ee(r,i))return !1;for(const t of a)if(!Be(t,s))return !1}if("MultiPolygon"===e.type){const s=Ue(e.coordinates,i,n),a=$e(t.geometry(),r,i,n);if(!Ee(r,i))return !1;for(const t of a)if(!De(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],i=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Le(e.coordinates,i,n),a=qe(t.geometry(),r,i,n);if(!Ee(r,i))return !1;for(const t of a)if(!Fe(t,s))return !1}if("MultiPolygon"===e.type){const s=Ue(e.coordinates,i,n),a=qe(t.geometry(),r,i,n);if(!Ee(r,i))return !1;for(const t of a)if(!Re(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}function je(t){if(t instanceof Ie){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Ne)return !1;let e=!0;return t.eachChild(t=>{e&&!je(t)&&(e=!1);}),e}function Ke(t){if(t instanceof Ie&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild(t=>{e&&!Ke(t)&&(e=!1);}),e}function Ze(t,e){if(t instanceof Ie&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild(t=>{r&&!Ze(t,e)&&(r=!1);}),r}class Xe{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Xe(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class Ge{constructor(t,e=[],r,i=new qt,n=[]){this.registry=t,this.path=e,this.key=e.map(t=>`[${t}]`).join(""),this.scope=i,this.errors=n,this.expectedType=r;}parse(t,e,r,i,n={}){return e?this.concat(e,r,i)._parse(t,n):this._parse(t,n)}_parse(t,e){function r(t,e,r){return "assert"===r?new ve(e,[t]):"coerce"===r?new Ae(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const i=t[0];if("string"!=typeof i)return this.error(`Expression name must be a string, but found ${typeof i} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const n=this.registry[i];if(n){let i=n.parse(t,this);if(!i)return null;if(this.expectedType){const t=this.expectedType,n=i.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(t,n))return null}else i=r(i,t,e.typeAnnotation||"coerce");else i=r(i,t,e.typeAnnotation||"assert");}if(!(i instanceof me)&&"resolvedImage"!==i.type.kind&&function t(e){if(e instanceof Xe)return t(e.boundExpression);if(e instanceof Ie&&"error"===e.name)return !1;if(e instanceof Te)return !1;if(e instanceof Ne)return !1;const r=e instanceof Ae||e instanceof ve;let i=!0;return e.eachChild(e=>{i=r?i&&t(e):i&&e instanceof me;}),!!i&&je(e)&&Ze(e,["zoom","heatmap-density","line-progress","sky-radial-progress","accumulated","is-supported-script"])}(i)){const t=new Se;try{i=new me(i.type,i.evaluate(t));}catch(t){return this.error(t.message),null}}return i}return this.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const i="number"==typeof t?this.path.concat(t):this.path,n=r?this.scope.concat(r):this.scope;return new Ge(this.registry,i,e||null,n,this.errors)}error(t,...e){const r=`${this.key}${e.map(t=>`[${t}]`).join("")}`;this.errors.push(new $t(r,t));}checkSubtype(t,e){const r=re(t,e);return r&&this.error(r),r}}function He(t,e){const r=t.length-1;let i,n,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),i=t[o],n=t[o+1],i<=e){if(o===r||e<n)return o;s=o+1;}else {if(!(i>e))throw new ge("Input is not a number.");a=o-1;}return 0}class Je{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,jt);if(!r)return null;const i=[];let n=null;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(i.length&&i[i.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,n);if(!u)return null;n=n||u.type,i.push([s,u]);}return new Je(n,r,i)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const i=this.input.evaluate(t);if(i<=e[0])return r[0].evaluate(t);const n=e.length;return i>=e[n-1]?r[n-1].evaluate(t):r[He(e,i)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every(t=>t.outputDefined())}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}function Ye(t,e,r){return t*(1-r)+e*r}var We=Object.freeze({__proto__:null,number:Ye,color:function(t,e,r){return new oe(Ye(t.r,e.r,r),Ye(t.g,e.g,r),Ye(t.b,e.b,r),Ye(t.a,e.a,r))},array:function(t,e,r){return t.map((t,i)=>Ye(t,e[i],r))}});const Qe=6/29*3*(6/29),tr=Math.PI/180,er=180/Math.PI;function rr(t){return t>.008856451679035631?Math.pow(t,1/3):t/Qe+4/29}function ir(t){return t>6/29?t*t*t:Qe*(t-4/29)}function nr(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function sr(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function ar(t){const e=sr(t.r),r=sr(t.g),i=sr(t.b),n=rr((.4124564*e+.3575761*r+.1804375*i)/.95047),s=rr((.2126729*e+.7151522*r+.072175*i)/1);return {l:116*s-16,a:500*(n-s),b:200*(s-rr((.0193339*e+.119192*r+.9503041*i)/1.08883)),alpha:t.a}}function or(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,i=isNaN(t.b)?e:e-t.b/200;return e=1*ir(e),r=.95047*ir(r),i=1.08883*ir(i),new oe(nr(3.2404542*r-1.5371385*e-.4985314*i),nr(-.969266*r+1.8760108*e+.041556*i),nr(.0556434*r-.2040259*e+1.0572252*i),t.alpha)}function lr(t,e,r){const i=e-t;return t+r*(i>180||i<-180?i-360*Math.round(i/360):i)}const ur={forward:ar,reverse:or,interpolate:function(t,e,r){return {l:Ye(t.l,e.l,r),a:Ye(t.a,e.a,r),b:Ye(t.b,e.b,r),alpha:Ye(t.alpha,e.alpha,r)}}},cr={forward:function(t){const{l:e,a:r,b:i}=ar(t),n=Math.atan2(i,r)*er;return {h:n<0?n+360:n,c:Math.sqrt(r*r+i*i),l:e,alpha:t.a}},reverse:function(t){const e=t.h*tr,r=t.c;return or({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:lr(t.h,e.h,r),c:Ye(t.c,e.c,r),l:Ye(t.l,e.l,r),alpha:Ye(t.alpha,e.alpha,r)}}};var hr=Object.freeze({__proto__:null,lab:ur,hcl:cr});class pr{constructor(t,e,r,i,n){this.type=t,this.operator=e,this.interpolation=r,this.input=i,this.labels=[],this.outputs=[];for(const[t,e]of n)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,r,i,n){let s=0;if("exponential"===t.name)s=dr(r,t.base,i,n);else if("linear"===t.name)s=dr(r,1,i,n);else if("cubic-bezier"===t.name){const a=t.controlPoints;s=new e(a[0],a[1],a[2],a[3]).solve(dr(r,1,i,n));}return s}static parse(t,e){let[r,i,n,...s]=t;if(!Array.isArray(i)||0===i.length)return e.error("Expected an interpolation type expression.",1);if("linear"===i[0])i={name:"linear"};else if("exponential"===i[0]){const t=i[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);i={name:"exponential",base:t};}else {if("cubic-bezier"!==i[0])return e.error(`Unknown interpolation type ${String(i[0])}`,1,0);{const t=i.slice(1);if(4!==t.length||t.some(t=>"number"!=typeof t||t<0||t>1))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);i={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(n=e.parse(n,2,jt),!n)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=Xt:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],i=s[t+1],n=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const u=e.parse(i,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new pr(o,r,i,n,a):e.error(`Type ${te(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const i=this.input.evaluate(t);if(i<=e[0])return r[0].evaluate(t);const n=e.length;if(i>=e[n-1])return r[n-1].evaluate(t);const s=He(e,i),a=pr.interpolationFactor(this.interpolation,i,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?We[this.type.kind.toLowerCase()](o,l,a):"interpolate-hcl"===this.operator?cr.reverse(cr.interpolate(cr.forward(o),cr.forward(l),a)):ur.reverse(ur.interpolate(ur.forward(o),ur.forward(l),a))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every(t=>t.outputDefined())}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function dr(t,e,r,i){const n=i-r,s=t-r;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}class fr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const i=e.expectedType;i&&"value"!==i.kind&&(r=i);const n=[];for(const i of t.slice(1)){const t=e.parse(i,1+n.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,n.push(t);}const s=i&&n.some(t=>re(i,t.type));return new fr(s?Ht:r,n)}evaluate(t){let e,r=null,i=0;for(const n of this.args)if(i++,r=n.evaluate(t),r&&r instanceof he&&!r.available&&(e||(e=r.name),r=null,i===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined())}serialize(){const t=["coalesce"];return this.eachChild(e=>{t.push(e.serialize());}),t}}class yr{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let i=1;i<t.length-1;i+=2){const n=t[i];if("string"!=typeof n)return e.error(`Expected string, but found ${typeof n} instead.`,i);if(/[^a-zA-Z0-9_]/.test(n))return e.error("Variable names must contain only alphanumeric characters or '_'.",i);const s=e.parse(t[i+1],i+1);if(!s)return null;r.push([n,s]);}const i=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return i?new yr(r,i):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class mr{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,jt),i=e.parse(t[2],2,Qt(e.expectedType||Ht));return r&&i?new mr(i.type.itemType,r,i):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new ge(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new ge(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new ge(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class gr{constructor(t,e){this.type=Zt,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ht),i=e.parse(t[2],2,Ht);return r&&i?ie(r.type,[Zt,Kt,jt,Nt,Ht])?new gr(r,i):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${te(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!ne(e,["boolean","string","number","null"]))throw new ge(`Expected first argument to be of type boolean, string, number or null, but found ${te(fe(e))} instead.`);if(!ne(r,["string","array"]))throw new ge(`Expected second argument to be of type array or string, but found ${te(fe(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class xr{constructor(t,e,r){this.type=jt,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ht),i=e.parse(t[2],2,Ht);if(!r||!i)return null;if(!ie(r.type,[Zt,Kt,jt,Nt,Ht]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${te(r.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,jt);return n?new xr(r,i,n):null}return new xr(r,i)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!ne(e,["boolean","string","number","null"]))throw new ge(`Expected first argument to be of type boolean, string, number or null, but found ${te(fe(e))} instead.`);if(!ne(r,["string","array"]))throw new ge(`Expected second argument to be of type array or string, but found ${te(fe(r))} instead.`);if(this.fromIndex){const i=this.fromIndex.evaluate(t);return r.indexOf(e,i)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class vr{constructor(t,e,r,i,n,s){this.inputType=t,this.type=e,this.input=r,this.cases=i,this.outputs=n,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,i;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);const n={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,fe(t)))return null}else r=fe(t);if(void 0!==n[String(t)])return u.error("Branch labels must be unique.");n[String(t)]=s.length;}const c=e.parse(l,a,i);if(!c)return null;i=i||c.type,s.push(c);}const a=e.parse(t[1],1,Ht);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,i);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new vr(r,i,a,n,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (fe(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every(t=>t.outputDefined())&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],i={};for(const t of e){const e=i[this.cases[t]];void 0===e?(i[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const n=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,i]of r)t.push(1===i.length?n(i[0]):i.map(n)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class br{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const i=[];for(let n=1;n<t.length-1;n+=2){const s=e.parse(t[n],n,Zt);if(!s)return null;const a=e.parse(t[n+1],n+1,r);if(!a)return null;i.push([s,a]),r=r||a.type;}const n=e.parse(t[t.length-1],t.length-1,r);return n?new br(r,i,n):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every(([t,e])=>e.outputDefined())&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild(e=>{t.push(e.serialize());}),t}}class wr{constructor(t,e,r,i){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=i;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ht),i=e.parse(t[2],2,jt);if(!r||!i)return null;if(!ie(r.type,[Qt(Ht),Kt,Ht]))return e.error(`Expected first argument to be of type array or string, but found ${te(r.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,jt);return n?new wr(r.type,r,i,n):null}return new wr(r.type,r,i)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!ne(e,["string","array"]))throw new ge(`Expected first argument to be of type array or string, but found ${te(fe(e))} instead.`);if(this.endIndex){const i=this.endIndex.evaluate(t);return e.slice(r,i)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}function _r(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function Ar(t,e,r,i){return 0===i.compare(e,r)}function kr(t,e,r){const i="=="!==t&&"!="!==t;return class n{constructor(t,e,r){this.type=Zt,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Ht);if(!s)return null;if(!_r(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${te(s.type)}'.`);let a=e.parse(t[2],2,Ht);if(!a)return null;if(!_r(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${te(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${te(s.type)}' and '${te(a.type)}'.`);i&&("value"===s.type.kind&&"value"!==a.type.kind?s=new ve(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new ve(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Jt),!o)return null}return new n(s,a,o)}evaluate(n){const s=this.lhs.evaluate(n),a=this.rhs.evaluate(n);if(i&&this.hasUntypedArgument){const e=fe(s),r=fe(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new ge(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!i&&this.hasUntypedArgument){const t=fe(s),r=fe(a);if("string"!==t.kind||"string"!==r.kind)return e(n,s,a)}return this.collator?r(n,s,a,this.collator.evaluate(n)):e(n,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild(t=>{e.push(t.serialize());}),e}}}const Sr=kr("==",(function(t,e,r){return e===r}),Ar),Ir=kr("!=",(function(t,e,r){return e!==r}),(function(t,e,r,i){return !Ar(0,e,r,i)})),Tr=kr("<",(function(t,e,r){return e<r}),(function(t,e,r,i){return i.compare(e,r)<0})),zr=kr(">",(function(t,e,r){return e>r}),(function(t,e,r,i){return i.compare(e,r)>0})),Er=kr("<=",(function(t,e,r){return e<=r}),(function(t,e,r,i){return i.compare(e,r)<=0}));class Cr{constructor(t,e,r,i,n){this.type=Kt,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=i,this.maxFractionDigits=n;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,jt);if(!r)return null;const i=t[2];if("object"!=typeof i||Array.isArray(i))return e.error("NumberFormat options argument must be an object.");let n=null;if(i.locale&&(n=e.parse(i.locale,1,Kt),!n))return null;let s=null;if(i.currency&&(s=e.parse(i.currency,1,Kt),!s))return null;let a=null;if(i["min-fraction-digits"]&&(a=e.parse(i["min-fraction-digits"],1,jt),!a))return null;let o=null;return i["max-fraction-digits"]&&(o=e.parse(i["max-fraction-digits"],1,jt),!o)?null:new Cr(r,n,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class Mr{constructor(t){this.type=jt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${te(r.type)} instead.`):new Mr(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new ge(`Expected value to be of type string or array, but found ${te(fe(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild(e=>{t.push(e.serialize());}),t}}const Br={"==":Sr,"!=":Ir,">":zr,"<":Tr,">=":kr(">=",(function(t,e,r){return e>=r}),(function(t,e,r,i){return i.compare(e,r)>=0})),"<=":Er,array:ve,at:mr,boolean:ve,case:br,coalesce:fr,collator:Te,format:be,image:we,in:gr,"index-of":xr,interpolate:pr,"interpolate-hcl":pr,"interpolate-lab":pr,length:Mr,let:yr,literal:me,match:vr,number:ve,"number-format":Cr,object:ve,slice:wr,step:Je,string:ve,"to-boolean":Ae,"to-color":Ae,"to-number":Ae,"to-string":Ae,var:Xe,within:Ne};function Dr(t,[e,r,i,n]){e=e.evaluate(t),r=r.evaluate(t),i=i.evaluate(t);const s=n?n.evaluate(t):1,a=pe(e,r,i,s);if(a)throw new ge(a);return new oe(e/255*s,r/255*s,i/255*s,s)}function Pr(t,e){return t in e}function Vr(t,e){const r=e[t];return void 0===r?null:r}function Fr(t){return {type:t}}function Rr(t){return {result:"success",value:t}}function Lr(t){return {result:"error",value:t}}function Ur(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Or(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function $r(t){return !!t.expression&&t.expression.interpolated}function qr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Nr(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function jr(t){return t}function Kr(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Zr(t,e,r,i,n){return Kr(typeof r===n?i[r]:void 0,t.default,e.default)}function Xr(t,e,r){if("number"!==qr(r))return Kr(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const n=He(t.stops.map(t=>t[0]),r);return t.stops[n][1]}function Gr(t,e,r){const i=void 0!==t.base?t.base:1;if("number"!==qr(r))return Kr(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const s=He(t.stops.map(t=>t[0]),r),a=function(t,e,r,i){const n=i-r,s=t-r;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}(r,i,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1];let u=We[e.type]||jr;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=hr[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),a));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,a)}}:u(o,l,a)}function Hr(t,e,r){return "color"===e.type?r=oe.parse(r):"formatted"===e.type?r=ce.fromString(r.toString()):"resolvedImage"===e.type?r=he.fromString(r.toString()):qr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),Kr(r,t.default,e.default)}Ie.register(Br,{error:[{kind:"error"},[Kt],(t,[e])=>{throw new ge(e.evaluate(t))}],typeof:[Kt,[Ht],(t,[e])=>te(fe(e.evaluate(t)))],"to-rgba":[Qt(jt,4),[Xt],(t,[e])=>e.evaluate(t).toArray()],rgb:[Xt,[jt,jt,jt],Dr],rgba:[Xt,[jt,jt,jt,jt],Dr],has:{type:Zt,overloads:[[[Kt],(t,[e])=>Pr(e.evaluate(t),t.properties())],[[Kt,Gt],(t,[e,r])=>Pr(e.evaluate(t),r.evaluate(t))]]},get:{type:Ht,overloads:[[[Kt],(t,[e])=>Vr(e.evaluate(t),t.properties())],[[Kt,Gt],(t,[e,r])=>Vr(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Ht,[Kt],(t,[e])=>Vr(e.evaluate(t),t.featureState||{})],properties:[Gt,[],t=>t.properties()],"geometry-type":[Kt,[],t=>t.geometryType()],id:[Ht,[],t=>t.id()],zoom:[jt,[],t=>t.globals.zoom],"heatmap-density":[jt,[],t=>t.globals.heatmapDensity||0],"line-progress":[jt,[],t=>t.globals.lineProgress||0],"sky-radial-progress":[jt,[],t=>t.globals.skyRadialProgress||0],accumulated:[Ht,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[jt,Fr(jt),(t,e)=>{let r=0;for(const i of e)r+=i.evaluate(t);return r}],"*":[jt,Fr(jt),(t,e)=>{let r=1;for(const i of e)r*=i.evaluate(t);return r}],"-":{type:jt,overloads:[[[jt,jt],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[jt],(t,[e])=>-e.evaluate(t)]]},"/":[jt,[jt,jt],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[jt,[jt,jt],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[jt,[],()=>Math.LN2],pi:[jt,[],()=>Math.PI],e:[jt,[],()=>Math.E],"^":[jt,[jt,jt],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[jt,[jt],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[jt,[jt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[jt,[jt],(t,[e])=>Math.log(e.evaluate(t))],log2:[jt,[jt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[jt,[jt],(t,[e])=>Math.sin(e.evaluate(t))],cos:[jt,[jt],(t,[e])=>Math.cos(e.evaluate(t))],tan:[jt,[jt],(t,[e])=>Math.tan(e.evaluate(t))],asin:[jt,[jt],(t,[e])=>Math.asin(e.evaluate(t))],acos:[jt,[jt],(t,[e])=>Math.acos(e.evaluate(t))],atan:[jt,[jt],(t,[e])=>Math.atan(e.evaluate(t))],min:[jt,Fr(jt),(t,e)=>Math.min(...e.map(e=>e.evaluate(t)))],max:[jt,Fr(jt),(t,e)=>Math.max(...e.map(e=>e.evaluate(t)))],abs:[jt,[jt],(t,[e])=>Math.abs(e.evaluate(t))],round:[jt,[jt],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[jt,[jt],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[jt,[jt],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Zt,[Kt,Ht],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[Zt,[Ht],(t,[e])=>t.id()===e.value],"filter-type-==":[Zt,[Kt],(t,[e])=>t.geometryType()===e.value],"filter-<":[Zt,[Kt,Ht],(t,[e,r])=>{const i=t.properties()[e.value],n=r.value;return typeof i==typeof n&&i<n}],"filter-id-<":[Zt,[Ht],(t,[e])=>{const r=t.id(),i=e.value;return typeof r==typeof i&&r<i}],"filter->":[Zt,[Kt,Ht],(t,[e,r])=>{const i=t.properties()[e.value],n=r.value;return typeof i==typeof n&&i>n}],"filter-id->":[Zt,[Ht],(t,[e])=>{const r=t.id(),i=e.value;return typeof r==typeof i&&r>i}],"filter-<=":[Zt,[Kt,Ht],(t,[e,r])=>{const i=t.properties()[e.value],n=r.value;return typeof i==typeof n&&i<=n}],"filter-id-<=":[Zt,[Ht],(t,[e])=>{const r=t.id(),i=e.value;return typeof r==typeof i&&r<=i}],"filter->=":[Zt,[Kt,Ht],(t,[e,r])=>{const i=t.properties()[e.value],n=r.value;return typeof i==typeof n&&i>=n}],"filter-id->=":[Zt,[Ht],(t,[e])=>{const r=t.id(),i=e.value;return typeof r==typeof i&&r>=i}],"filter-has":[Zt,[Ht],(t,[e])=>e.value in t.properties()],"filter-has-id":[Zt,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Zt,[Qt(Kt)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Zt,[Qt(Ht)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Zt,[Kt,Qt(Ht)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Zt,[Kt,Qt(Ht)],(t,[e,r])=>function(t,e,r,i){for(;r<=i;){const n=r+i>>1;if(e[n]===t)return !0;e[n]>t?i=n-1:r=n+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:Zt,overloads:[[[Zt,Zt],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Fr(Zt),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:Zt,overloads:[[[Zt,Zt],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Fr(Zt),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[Zt,[Zt],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Zt,[Kt],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Kt,[Kt],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Kt,[Kt],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Kt,Fr(Ht),(t,e)=>e.map(e=>ye(e.evaluate(t))).join("")],"resolved-locale":[Kt,[Jt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class Jr{constructor(t,e){this.expression=t,this._warningHistory={},this._evaluator=new Se,this._defaultValue=e?function(t){return "color"===t.type&&Nr(t.default)?new oe(0,0,0,0):"color"===t.type?oe.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,i,n,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=i,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,i,n,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=i,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new ge(`Expected value to be one of ${Object.keys(this._enumValues).map(t=>JSON.stringify(t)).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function Yr(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Br}function Wr(t,e){const r=new Ge(Br,[],e?function(t){const e={color:Xt,string:Kt,number:jt,enum:Kt,boolean:Zt,formatted:Yt,resolvedImage:Wt};return "array"===t.type?Qt(e[t.value]||Ht,t.length):e[t.type]}(e):void 0),i=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return i?Rr(new Jr(i,e)):Lr(r.errors)}class Qr{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!Ke(e.expression);}evaluateWithoutErrorHandling(t,e,r,i,n,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,i,n,s)}evaluate(t,e,r,i,n,s){return this._styleExpression.evaluate(t,e,r,i,n,s)}}class ti{constructor(t,e,r,i){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Ke(e.expression),this.interpolationType=i;}evaluateWithoutErrorHandling(t,e,r,i,n,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,i,n,s)}evaluate(t,e,r,i,n,s){return this._styleExpression.evaluate(t,e,r,i,n,s)}interpolationFactor(t,e,r){return this.interpolationType?pr.interpolationFactor(this.interpolationType,t,e,r):0}}function ei(t,e){if("error"===(t=Wr(t,e)).result)return t;const r=t.value.expression,i=je(r);if(!i&&!Ur(e))return Lr([new $t("","data expressions not supported")]);const n=Ze(r,["zoom"]);if(!n&&!Or(e))return Lr([new $t("","zoom expressions not supported")]);const s=function t(e){let r=null;if(e instanceof yr)r=t(e.result);else if(e instanceof fr){for(const i of e.args)if(r=t(i),r)break}else (e instanceof Je||e instanceof pr)&&e.input instanceof Ie&&"zoom"===e.input.name&&(r=e);return r instanceof $t||e.eachChild(e=>{const i=t(e);i instanceof $t?r=i:!r&&i?r=new $t("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):r&&i&&r!==i&&(r=new $t("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));}),r}(r);return s||n?s instanceof $t?Lr([s]):s instanceof pr&&!$r(e)?Lr([new $t("",'"interpolate" expressions cannot be used with this property')]):Rr(s?new ti(i?"camera":"composite",t.value,s.labels,s instanceof pr?s.interpolation:void 0):new Qr(i?"constant":"source",t.value)):Lr([new $t("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class ri{constructor(t,e){this._parameters=t,this._specification=e,Lt(this,function t(e,r){const i="color"===r.type,n=e.stops&&"object"==typeof e.stops[0][0],s=n||!(n||void 0!==e.property),a=e.type||($r(r)?"exponential":"interval");if(i&&((e=Lt({},e)).stops&&(e.stops=e.stops.map(t=>[t[0],oe.parse(t[1])])),e.default=oe.parse(e.default?e.default:r.default)),e.colorSpace&&"rgb"!==e.colorSpace&&!hr[e.colorSpace])throw new Error(`Unknown color space: ${e.colorSpace}`);let o,l,u;if("exponential"===a)o=Gr;else if("interval"===a)o=Xr;else if("categorical"===a){o=Zr,l=Object.create(null);for(const t of e.stops)l[t[0]]=t[1];u=typeof e.stops[0][0];}else {if("identity"!==a)throw new Error(`Unknown function type "${a}"`);o=Hr;}if(n){const i={},n=[];for(let t=0;t<e.stops.length;t++){const r=e.stops[t],s=r[0].zoom;void 0===i[s]&&(i[s]={zoom:s,type:e.type,property:e.property,default:e.default,stops:[]},n.push(s)),i[s].stops.push([r[0].value,r[1]]);}const s=[];for(const e of n)s.push([i[e].zoom,t(i[e],r)]);const a={name:"linear"};return {kind:"composite",interpolationType:a,interpolationFactor:pr.interpolationFactor.bind(void 0,a),zoomStops:s.map(t=>t[0]),evaluate:({zoom:t},i)=>Gr({stops:s,base:e.base},r,t).evaluate(t,i)}}if(s){const t="exponential"===a?{name:"exponential",base:void 0!==e.base?e.base:1}:null;return {kind:"camera",interpolationType:t,interpolationFactor:pr.interpolationFactor.bind(void 0,t),zoomStops:e.stops.map(t=>t[0]),evaluate:({zoom:t})=>o(e,r,t,l,u)}}return {kind:"source",evaluate(t,i){const n=i&&i.properties?i.properties[e.property]:void 0;return void 0===n?Kr(e.default,r.default):o(e,r,n,l,u)}}}(this._parameters,this._specification));}static deserialize(t){return new ri(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function ii(t){const e=t.key,r=t.value,i=t.valueSpec||{},n=t.objectElementValidators||{},s=t.style,a=t.styleSpec;let o=[];const l=qr(r);if("object"!==l)return [new Ft(e,r,`object expected, ${l} found`)];for(const t in r){const l=t.split(".")[0],u=i[l]||i["*"];let c;if(n[l])c=n[l];else if(i[l])c=Ei;else if(n["*"])c=n["*"];else {if(!i["*"]){o.push(new Ft(e,r[t],`unknown property "${t}"`));continue}c=Ei;}o=o.concat(c({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:u,style:s,styleSpec:a,object:r,objectKey:t},r));}for(const t in i)n[t]||i[t].required&&void 0===i[t].default&&void 0===r[t]&&o.push(new Ft(e,r,`missing required property "${t}"`));return o}function ni(t){const e=t.value,r=t.valueSpec,i=t.style,n=t.styleSpec,s=t.key,a=t.arrayElementValidator||Ei;if("array"!==qr(e))return [new Ft(s,e,`array expected, ${qr(e)} found`)];if(r.length&&e.length!==r.length)return [new Ft(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new Ft(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values};n.$version<7&&(o.function=r.function),"object"===qr(r.value)&&(o=r.value);let l=[];for(let t=0;t<e.length;t++)l=l.concat(a({array:e,arrayIndex:t,value:e[t],valueSpec:o,style:i,styleSpec:n,key:`${s}[${t}]`}));return l}function si(t){const e=t.key,r=t.value,i=t.valueSpec;let n=qr(r);return "number"===n&&r!=r&&(n="NaN"),"number"!==n?[new Ft(e,r,`number expected, ${n} found`)]:"minimum"in i&&r<i.minimum?[new Ft(e,r,`${r} is less than the minimum value ${i.minimum}`)]:"maximum"in i&&r>i.maximum?[new Ft(e,r,`${r} is greater than the maximum value ${i.maximum}`)]:[]}function ai(t){const e=t.valueSpec,r=Ut(t.value.type);let i,n,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===qr(t.value.stops)&&"array"===qr(t.value.stops[0])&&"object"===qr(t.value.stops[0][0]),c=ii({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new Ft(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const i=t.value;return e=e.concat(ni({key:t.key,value:i,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===qr(i)&&0===i.length&&e.push(new Ft(t.key,i,"array must have at least one stop")),e},default:function(t){return Ei({key:t.key,value:t.value,valueSpec:e,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new Ft(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new Ft(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!$r(t.valueSpec)&&c.push(new Ft(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Ur(t.valueSpec)?c.push(new Ft(t.key,t.value,"property functions not supported")):o&&!Or(t.valueSpec)&&c.push(new Ft(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new Ft(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const i=t.value,o=t.key;if("array"!==qr(i))return [new Ft(o,i,`array expected, ${qr(i)} found`)];if(2!==i.length)return [new Ft(o,i,`array length 2 expected, length ${i.length} found`)];if(u){if("object"!==qr(i[0]))return [new Ft(o,i,`object expected, ${qr(i[0])} found`)];if(void 0===i[0].zoom)return [new Ft(o,i,"object stop key must have zoom")];if(void 0===i[0].value)return [new Ft(o,i,"object stop key must have value")];if(s&&s>Ut(i[0].zoom))return [new Ft(o,i[0].zoom,"stop zoom values must appear in ascending order")];Ut(i[0].zoom)!==s&&(s=Ut(i[0].zoom),n=void 0,a={}),r=r.concat(ii({key:`${o}[0]`,value:i[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:si,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:i[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},i));return Yr(Ot(i[1]))?r.concat([new Ft(`${o}[1]`,i[1],"expressions are not allowed in function stops.")]):r.concat(Ei({key:`${o}[1]`,value:i[1],valueSpec:e,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=qr(t.value),l=Ut(t.value),u=null!==t.value?t.value:s;if(i){if(o!==i)return [new Ft(t.key,u,`${o} stop domain type must match previous stop domain type ${i}`)]}else i=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new Ft(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let i=`number expected, ${o} found`;return Ur(e)&&void 0===r&&(i+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Ft(t.key,u,i)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==n&&l<n?[new Ft(t.key,u,"stop domain values must appear in ascending order")]:(n=l,"categorical"===r&&l in a?[new Ft(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new Ft(t.key,u,`integer expected, found ${l}`)]}}function oi(t){const e=("property"===t.expressionContext?ei:Wr)(Ot(t.value),t.valueSpec);if("error"===e.result)return e.value.map(e=>new Ft(`${t.key}${e.key}`,t.value,e.message));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new Ft(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!Ke(r))return [new Ft(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!Ke(r))return [new Ft(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Ze(r,["zoom","feature-state"]))return [new Ft(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!je(r))return [new Ft(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function li(t){const e=t.key,r=t.value,i=t.valueSpec,n=[];return Array.isArray(i.values)?-1===i.values.indexOf(Ut(r))&&n.push(new Ft(e,r,`expected one of [${i.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(i.values).indexOf(Ut(r))&&n.push(new Ft(e,r,`expected one of [${Object.keys(i.values).join(", ")}], ${JSON.stringify(r)} found`)),n}function ui(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!ui(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const ci={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function hi(t){if(null==t)return {filter:()=>!0,needGeometry:!1};ui(t)||(t=di(t));const e=Wr(t,ci);if("error"===e.result)throw new Error(e.value.map(t=>`${t.key}: ${t.message}`).join(", "));return {filter:(t,r,i)=>e.value.evaluate(t,r,{},i),needGeometry:function t(e){if(!Array.isArray(e))return !1;if("within"===e[0])return !0;for(let r=1;r<e.length;r++)if(t(e[r]))return !0;return !1}(t)}}function pi(t,e){return t<e?-1:t>e?1:0}function di(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?fi(t[1],t[2],"=="):"!="===e?gi(fi(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?fi(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(di))):"all"===e?["all"].concat(t.slice(1).map(di)):"none"===e?["all"].concat(t.slice(1).map(di).map(gi)):"in"===e?yi(t[1],t.slice(2)):"!in"===e?gi(yi(t[1],t.slice(2))):"has"===e?mi(t[1]):"!has"===e?gi(mi(t[1])):"within"!==e||t;var r;}function fi(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function yi(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some(t=>typeof t!=typeof e[0])?["filter-in-large",t,["literal",e.sort(pi)]]:["filter-in-small",t,["literal",e]]}}function mi(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function gi(t){return ["!",t]}function xi(t){return ui(Ot(t.value))?oi(Lt({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):function t(e){const r=e.value,i=e.key;if("array"!==qr(r))return [new Ft(i,r,`array expected, ${qr(r)} found`)];const n=e.styleSpec;let s,a=[];if(r.length<1)return [new Ft(i,r,"filter array must have at least 1 element")];switch(a=a.concat(li({key:`${i}[0]`,value:r[0],valueSpec:n.filter_operator,style:e.style,styleSpec:e.styleSpec})),Ut(r[0])){case"<":case"<=":case">":case">=":r.length>=2&&"$type"===Ut(r[1])&&a.push(new Ft(i,r,`"$type" cannot be use with operator "${r[0]}"`));case"==":case"!=":3!==r.length&&a.push(new Ft(i,r,`filter array for operator "${r[0]}" must have 3 elements`));case"in":case"!in":r.length>=2&&(s=qr(r[1]),"string"!==s&&a.push(new Ft(`${i}[1]`,r[1],`string expected, ${s} found`)));for(let t=2;t<r.length;t++)s=qr(r[t]),"$type"===Ut(r[1])?a=a.concat(li({key:`${i}[${t}]`,value:r[t],valueSpec:n.geometry_type,style:e.style,styleSpec:e.styleSpec})):"string"!==s&&"number"!==s&&"boolean"!==s&&a.push(new Ft(`${i}[${t}]`,r[t],`string, number, or boolean expected, ${s} found`));break;case"any":case"all":case"none":for(let n=1;n<r.length;n++)a=a.concat(t({key:`${i}[${n}]`,value:r[n],style:e.style,styleSpec:e.styleSpec}));break;case"has":case"!has":s=qr(r[1]),2!==r.length?a.push(new Ft(i,r,`filter array for "${r[0]}" operator must have 2 elements`)):"string"!==s&&a.push(new Ft(`${i}[1]`,r[1],`string expected, ${s} found`));break;case"within":s=qr(r[1]),2!==r.length?a.push(new Ft(i,r,`filter array for "${r[0]}" operator must have 2 elements`)):"object"!==s&&a.push(new Ft(`${i}[1]`,r[1],`object expected, ${s} found`));}return a}(t)}function vi(t,e){const r=t.key,i=t.style,n=t.styleSpec,s=t.value,a=t.objectKey,o=n[`${e}_${t.layerType}`];if(!o)return [];const l=a.match(/^(.*)-transition$/);if("paint"===e&&l&&o[l[1]]&&o[l[1]].transition)return Ei({key:r,value:s,valueSpec:n.transition,style:i,styleSpec:n});const u=t.valueSpec||o[a];if(!u)return [new Ft(r,s,`unknown property "${a}"`)];let c;if("string"===qr(s)&&Ur(u)&&!u.tokens&&(c=/^{([^}]+)}$/.exec(s)))return [new Ft(r,s,`"${a}" does not support interpolation syntax\n`+`Use an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(c[1])} }\`.`)];const h=[];return "symbol"===t.layerType&&("text-field"===a&&i&&!i.glyphs&&h.push(new Ft(r,s,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&Nr(Ot(s))&&"identity"===Ut(s.type)&&h.push(new Ft(r,s,'"text-font" does not support identity functions'))),h.concat(Ei({key:t.key,value:s,valueSpec:u,style:i,styleSpec:n,expressionContext:"property",propertyType:e,propertyKey:a}))}function bi(t){return vi(t,"paint")}function wi(t){return vi(t,"layout")}function _i(t){let e=[];const r=t.value,i=t.key,n=t.style,s=t.styleSpec;r.type||r.ref||e.push(new Ft(i,r,'either "type" or "ref" is required'));let a=Ut(r.type);const o=Ut(r.ref);if(r.id){const s=Ut(r.id);for(let a=0;a<t.arrayIndex;a++){const t=n.layers[a];Ut(t.id)===s&&e.push(new Ft(i,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach(t=>{t in r&&e.push(new Ft(i,r[t],`"${t}" is prohibited for ref layers`));}),n.layers.forEach(e=>{Ut(e.id)===o&&(t=e);}),t?t.ref?e.push(new Ft(i,r.ref,"ref cannot reference another ref layer")):a=Ut(t.type):e.push(new Ft(i,r.ref,`ref layer "${o}" not found`));}else if("background"!==a&&"sky"!==a)if(r.source){const t=n.sources&&n.sources[r.source],s=t&&Ut(t.type);t?"vector"===s&&"raster"===a?e.push(new Ft(i,r.source,`layer "${r.id}" requires a raster source`)):"raster"===s&&"raster"!==a?e.push(new Ft(i,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a?e.push(new Ft(i,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Ft(i,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Ft(i,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new Ft(i,r.source,`source "${r.source}" not found`));}else e.push(new Ft(i,r,'missing required property "source"'));return e=e.concat(ii({key:i,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>Ei({key:`${i}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,object:r,objectKey:"type"}),filter:xi,layout:t=>ii({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>wi(Lt({layerType:a},t))}}),paint:t=>ii({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>bi(Lt({layerType:a},t))}})}})),e}function Ai(t){const e=t.value,r=t.key,i=qr(e);return "string"!==i?[new Ft(r,e,`string expected, ${i} found`)]:[]}const ki={promoteId:function({key:t,value:e}){if("string"===qr(e))return Ai({key:t,value:e});{const r=[];for(const i in e)r.push(...Ai({key:`${t}.${i}`,value:e[i]}));return r}}};function Si(t){const e=t.value,r=t.key,i=t.styleSpec,n=t.style;if(!e.type)return [new Ft(r,e,'"type" is required')];const s=Ut(e.type);let a;switch(s){case"vector":case"raster":case"raster-dem":return a=ii({key:r,value:e,valueSpec:i[`source_${s.replace("-","_")}`],style:t.style,styleSpec:i,objectElementValidators:ki}),a;case"geojson":if(a=ii({key:r,value:e,valueSpec:i.source_geojson,style:n,styleSpec:i,objectElementValidators:ki}),e.cluster)for(const t in e.clusterProperties){const[i,n]=e.clusterProperties[t],s="string"==typeof i?[i,["accumulated"],["get",t]]:i;a.push(...oi({key:`${r}.${t}.map`,value:n,expressionContext:"cluster-map"})),a.push(...oi({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return a;case"video":return ii({key:r,value:e,valueSpec:i.source_video,style:n,styleSpec:i});case"image":return ii({key:r,value:e,valueSpec:i.source_image,style:n,styleSpec:i});case"canvas":return [new Ft(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return li({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:n,styleSpec:i})}}function Ii(t){const e=t.value,r=t.styleSpec,i=r.light,n=t.style;let s=[];const a=qr(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Ft("light",e,`object expected, ${a} found`)]),s;for(const t in e){const a=t.match(/^(.*)-transition$/);s=s.concat(a&&i[a[1]]&&i[a[1]].transition?Ei({key:t,value:e[t],valueSpec:r.transition,style:n,styleSpec:r}):i[t]?Ei({key:t,value:e[t],valueSpec:i[t],style:n,styleSpec:r}):[new Ft(t,e[t],`unknown property "${t}"`)]);}return s}function Ti(t){const e=t.value,r=t.key,i=t.style,n=t.styleSpec,s=n.terrain;let a=[];const o=qr(e);if(void 0===e)return a;if("object"!==o)return a=a.concat([new Ft("terrain",e,`object expected, ${o} found`)]),a;for(const t in e){const r=t.match(/^(.*)-transition$/);a=a.concat(r&&s[r[1]]&&s[r[1]].transition?Ei({key:t,value:e[t],valueSpec:n.transition,style:i,styleSpec:n}):s[t]?Ei({key:t,value:e[t],valueSpec:s[t],style:i,styleSpec:n}):[new Ft(t,e[t],`unknown property "${t}"`)]);}if(e.source){const t=i.sources&&i.sources[e.source],n=t&&Ut(t.type);t?"raster-dem"!==n&&a.push(new Ft(r,e.source,`terrain cannot be used with a source of type ${n}, it only be used with a "raster-dem" source type`)):a.push(new Ft(r,e.source,`source "${e.source}" not found`));}else a.push(new Ft(r,e,'terrain is missing required property "source"'));return a}const zi={"*":()=>[],array:ni,boolean:function(t){const e=t.value,r=t.key,i=qr(e);return "boolean"!==i?[new Ft(r,e,`boolean expected, ${i} found`)]:[]},number:si,color:function(t){const e=t.key,r=t.value,i=qr(r);return "string"!==i?[new Ft(e,r,`color expected, ${i} found`)]:null===ae(r)?[new Ft(e,r,`color expected, "${r}" found`)]:[]},constants:Rt,enum:li,filter:xi,function:ai,layer:_i,object:ii,source:Si,light:Ii,terrain:Ti,string:Ai,formatted:function(t){return 0===Ai(t).length?[]:oi(t)},resolvedImage:function(t){return 0===Ai(t).length?[]:oi(t)}};function Ei(t){const e=t.value,r=t.valueSpec,i=t.styleSpec;return r.expression&&Nr(Ut(e))?ai(t):r.expression&&Yr(Ot(e))?oi(t):r.type&&zi[r.type]?zi[r.type](t):ii(Lt({},t,{valueSpec:r.type?i[r.type]:r}))}function Ci(t){const e=t.value,r=t.key,i=Ai(t);return i.length||(-1===e.indexOf("{fontstack}")&&i.push(new Ft(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&i.push(new Ft(r,e,'"glyphs" url must include a "{range}" token'))),i}function Mi(t,e=Vt){let r=[];return r=r.concat(Ei({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,objectElementValidators:{glyphs:Ci,"*":()=>[]}})),t.constants&&(r=r.concat(Rt({key:"constants",value:t.constants,style:t,styleSpec:e}))),Bi(r)}function Bi(t){return [].concat(t).sort((t,e)=>t.line-e.line)}function Di(t){return function(...e){return Bi(t.apply(this,e))}}Mi.source=Di(Si),Mi.light=Di(Ii),Mi.terrain=Di(Ti),Mi.layer=Di(_i),Mi.filter=Di(xi),Mi.paintProperty=Di(bi),Mi.layoutProperty=Di(wi);const Pi=Mi,Vi=Pi.light,Fi=Pi.paintProperty,Ri=Pi.layoutProperty;function Li(t,e){let r=!1;if(e&&e.length)for(const i of e)t.fire(new Dt(new Error(i.message))),r=!0;return r}var Ui=Oi;function Oi(t,e,r){var i=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;var n=new Int32Array(this.arrayBuffer);t=n[0],this.d=(e=n[1])+2*(r=n[2]);for(var s=0;s<this.d*this.d;s++){var a=n[3+s],o=n[3+s+1];i.push(a===o?null:n.subarray(a,o));}var l=n[3+i.length+1];this.keys=n.subarray(n[3+i.length],l),this.bboxes=n.subarray(l),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(var u=0;u<this.d*this.d;u++)i.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;var c=r/e*t;this.min=-c,this.max=t+c;}Oi.prototype.insert=function(t,e,r,i,n){this._forEachCell(e,r,i,n,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(i),this.bboxes.push(n);},Oi.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},Oi.prototype._insertCell=function(t,e,r,i,n,s){this.cells[n].push(s);},Oi.prototype.query=function(t,e,r,i,n){var s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=i&&!n)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,i,this._queryCell,o,{},n),o},Oi.prototype._queryCell=function(t,e,r,i,n,s,a,o){var l=this.cells[n];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===a[p]){var d=4*p;(o?o(c[d+0],c[d+1],c[d+2],c[d+3]):t<=c[d+2]&&e<=c[d+3]&&r>=c[d+0]&&i>=c[d+1])?(a[p]=!0,s.push(u[p])):a[p]=!1;}}},Oi.prototype._forEachCell=function(t,e,r,i,n,s,a,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(i),p=l;p<=c;p++)for(var d=u;d<=h;d++){var f=this.d*d+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(d),this._convertFromCellCoord(p+1),this._convertFromCellCoord(d+1)))&&n.call(this,t,e,r,i,f,s,a,o))return}},Oi.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},Oi.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},Oi.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var t=this.cells,e=3+this.cells.length+1+1,r=0,i=0;i<this.cells.length;i++)r+=this.cells[i].length;var n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;for(var s=e,a=0;a<t.length;a++){var o=t[a];n[3+a]=s,n.set(o,s),s+=o.length;}return n[3+t.length]=s,n.set(this.keys,s),n[3+t.length+1]=s+=this.keys.length,n.set(this.bboxes,s),s+=this.bboxes.length,n.buffer};const{ImageData:$i,ImageBitmap:qi}=s,Ni={};function ji(t,e,r={}){Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),Ni[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}ji("Object",Object),Ui.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}},Ui.deserialize=function(t){return new Ui(t.buffer)},ji("Grid",Ui),ji("Color",oe),ji("Error",Error),ji("ResolvedImage",he),ji("StylePropertyFunction",ri),ji("StyleExpression",Jr,{omit:["_evaluator"]}),ji("ZoomDependentExpression",ti),ji("ZoomConstantExpression",Qr),ji("CompoundExpression",Ie,{omit:["_evaluate"]});for(const t in Br)Br[t]._classRegistryKey||ji(`Expression_${t}`,Br[t]);function Ki(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Zi(t){return qi&&t instanceof qi}function Xi(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(Ki(t)||Zi(t))return e&&e.push(t),t;if(ArrayBuffer.isView(t)){const r=t;return e&&e.push(r.buffer),r}if(t instanceof $i)return e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const i of t)r.push(Xi(i,e));return r}if("object"==typeof t){const r=t.constructor,i=r._classRegistryKey;if(!i)throw new Error("can't serialize object of unregistered class");const n=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t){if(!t.hasOwnProperty(r))continue;if(Ni[i].omit.indexOf(r)>=0)continue;const s=t[r];n[r]=Ni[i].shallow.indexOf(r)>=0?s:Xi(s,e);}t instanceof Error&&(n.message=t.message);}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==i&&(n.$name=i),n}throw new Error(`can't serialize object of type ${typeof t}`)}function Gi(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||Ki(t)||Zi(t)||ArrayBuffer.isView(t)||t instanceof $i)return t;if(Array.isArray(t))return t.map(Gi);if("object"==typeof t){const e=t.$name||"Object",{klass:r}=Ni[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const i=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const n=t[r];i[r]=Ni[e].shallow.indexOf(r)>=0?n:Gi(n);}return i}throw new Error(`can't deserialize object of type ${typeof t}`)}class Hi{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const Ji={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function Yi(t){for(const e of t)if(tn(e.charCodeAt(0)))return !0;return !1}function Wi(t){for(const e of t)if(!Qi(e.charCodeAt(0)))return !1;return !0}function Qi(t){return !(Ji.Arabic(t)||Ji["Arabic Supplement"](t)||Ji["Arabic Extended-A"](t)||Ji["Arabic Presentation Forms-A"](t)||Ji["Arabic Presentation Forms-B"](t))}function tn(t){return !(746!==t&&747!==t&&(t<4352||!(Ji["Bopomofo Extended"](t)||Ji.Bopomofo(t)||Ji["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||Ji["CJK Compatibility Ideographs"](t)||Ji["CJK Compatibility"](t)||Ji["CJK Radicals Supplement"](t)||Ji["CJK Strokes"](t)||!(!Ji["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Ji["CJK Unified Ideographs Extension A"](t)||Ji["CJK Unified Ideographs"](t)||Ji["Enclosed CJK Letters and Months"](t)||Ji["Hangul Compatibility Jamo"](t)||Ji["Hangul Jamo Extended-A"](t)||Ji["Hangul Jamo Extended-B"](t)||Ji["Hangul Jamo"](t)||Ji["Hangul Syllables"](t)||Ji.Hiragana(t)||Ji["Ideographic Description Characters"](t)||Ji.Kanbun(t)||Ji["Kangxi Radicals"](t)||Ji["Katakana Phonetic Extensions"](t)||Ji.Katakana(t)&&12540!==t||!(!Ji["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Ji["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Ji["Unified Canadian Aboriginal Syllabics"](t)||Ji["Unified Canadian Aboriginal Syllabics Extended"](t)||Ji["Vertical Forms"](t)||Ji["Yijing Hexagram Symbols"](t)||Ji["Yi Syllables"](t)||Ji["Yi Radicals"](t))))}function en(t){return !(tn(t)||function(t){return !!(Ji["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||Ji["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||Ji["Letterlike Symbols"](t)||Ji["Number Forms"](t)||Ji["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||Ji["Control Pictures"](t)&&9251!==t||Ji["Optical Character Recognition"](t)||Ji["Enclosed Alphanumerics"](t)||Ji["Geometric Shapes"](t)||Ji["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||Ji["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||Ji["CJK Symbols and Punctuation"](t)||Ji.Katakana(t)||Ji["Private Use Area"](t)||Ji["CJK Compatibility Forms"](t)||Ji["Small Form Variants"](t)||Ji["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function rn(t){return t>=1424&&t<=2303||Ji["Arabic Presentation Forms-A"](t)||Ji["Arabic Presentation Forms-B"](t)}function nn(t,e){return !(!e&&rn(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||Ji.Khmer(t))}function sn(t){for(const e of t)if(rn(e.charCodeAt(0)))return !0;return !1}let an=null,on="unavailable",ln=null;const un=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(on="error"),an&&an(t);};function cn(){hn.fire(new Bt("pluginStateChange",{pluginStatus:on,pluginURL:ln}));}const hn=new Pt,pn=function(){return on},dn=function(){if("deferred"!==on||!ln)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");on="loading",cn(),ln&&_t({url:ln},t=>{t?un(t):(on="loaded",cn());});},fn={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>"loaded"===on||null!=fn.applyArabicShaping,isLoading:()=>"loading"===on,setState(t){on=t.pluginStatus,ln=t.pluginURL;},isParsed:()=>null!=fn.applyArabicShaping&&null!=fn.processBidirectionalText&&null!=fn.processStyledBidirectionalText,getPluginURL:()=>ln};class yn{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Hi,this.transition={});}isSupportedScript(t){return function(t,e){for(const r of t)if(!nn(r.charCodeAt(0),e))return !1;return !0}(t,fn.isLoaded())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class mn{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Nr(t))return new ri(t,e);if(Yr(t)){const r=ei(t,e);if("error"===r.result)throw new Error(r.value.map(t=>`${t.key}: ${t.message}`).join(", "));return r.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=oe.parse(t)),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class gn{constructor(t){this.property=t,this.value=new mn(t,void 0);}transitioned(t,e){return new vn(this.property,this.value,e,g({},t.transition,this.transition),t.now)}untransitioned(){return new vn(this.property,this.value,null,{},0)}}class xn{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return I(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new gn(this._values[t].property)),this._values[t].value=new mn(this._values[t].property,null===e?void 0:I(e));}getTransition(t){return I(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new gn(this._values[t].property)),this._values[t].transition=I(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const i=this.getTransition(e);void 0!==i&&(t[`${e}-transition`]=i);}return t}transitioned(t,e){const r=new bn(this._properties);for(const i of Object.keys(this._values))r._values[i]=this._values[i].transitioned(t,e._values[i]);return r}untransitioned(){const t=new bn(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class vn{constructor(t,e,r,i,n){this.property=t,this.value=e,this.begin=n+i.delay||0,this.end=this.begin+i.duration||0,t.specification.transition&&(i.delay||i.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const i=t.now||0,n=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(i>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(i<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(i-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),n,h(a))}}return n}}class bn{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const i=new An(this._properties);for(const n of Object.keys(this._values))i._values[n]=this._values[n].possiblyEvaluate(t,e,r);return i}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class wn{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues);}getValue(t){return I(this._values[t].value)}setValue(t,e){this._values[t]=new mn(this._values[t].property,null===e?void 0:I(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const i=new An(this._properties);for(const n of Object.keys(this._values))i._values[n]=this._values[n].possiblyEvaluate(t,e,r);return i}}class _n{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,i){return this.property.evaluate(this.value,this.parameters,t,e,r,i)}}class An{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class kn{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const i=We[this.specification.type];return i?i(t,e,r):t}}class Sn{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,i){return new _n(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,i)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new _n(this,{kind:"constant",value:void 0},t.parameters);const i=We[this.specification.type];return i?new _n(this,{kind:"constant",value:i(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,i,n,s){return "constant"===t.kind?t.value:t.evaluate(e,r,i,n,s)}}class In extends Sn{possiblyEvaluate(t,e,r,i){if(void 0===t.value)return new _n(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},r,i),s="resolvedImage"===t.property.specification.type&&"string"!=typeof n?n.name:n,a=this._calculate(s,s,s,e);return new _n(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new _n(this,{kind:"constant",value:r},e)}return new _n(this,t.expression,e)}evaluate(t,e,r,i,n,s){if("source"===t.kind){const a=t.evaluate(e,r,i,n,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,i),t.evaluate({zoom:Math.floor(e.zoom)},r,i),t.evaluate({zoom:Math.floor(e.zoom)+1},r,i),e):t.value}_calculate(t,e,r,i){return i.zoom>i.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class Tn{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,i){if(void 0!==t.value){if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},r,i);return this._calculate(n,n,n,e)}return this._calculate(t.expression.evaluate(new yn(Math.floor(e.zoom-1),e)),t.expression.evaluate(new yn(Math.floor(e.zoom),e)),t.expression.evaluate(new yn(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,i){return i.zoom>i.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class zn{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,i){return !!t.expression.evaluate(e,null,{},r,i)}interpolate(){return !1}}class En{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const i=this.defaultPropertyValues[e]=new mn(r,void 0),n=this.defaultTransitionablePropertyValues[e]=new gn(r);this.defaultTransitioningPropertyValues[e]=n.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=i.possiblyEvaluate({});}}}function Cn(t,e){return 256*(t=f(Math.floor(t),0,255))+f(Math.floor(e),0,255)}ji("DataDrivenProperty",Sn),ji("DataConstantProperty",kn),ji("CrossFadedDataDrivenProperty",In),ji("CrossFadedProperty",Tn),ji("ColorRampProperty",zn);const Mn={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Bn{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class Dn{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function Pn(t,e=1){let r=0,i=0;return {members:t.map(t=>{const n=Mn[t.type].BYTES_PER_ELEMENT,s=r=Vn(r,Math.max(e,n)),a=t.components||1;return i=Math.max(i,n),r+=n*a,{name:t.name,type:t.type,components:a,offset:s}}),size:Vn(r,Math.max(i,e)),alignment:e}}function Vn(t,e){return Math.ceil(t/e)*e}class Fn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const i=2*t;return this.int16[i+0]=e,this.int16[i+1]=r,t}}Fn.prototype.bytesPerElement=4,ji("StructArrayLayout2i4",Fn);class Rn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,i){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r,i)}emplace(t,e,r,i,n){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=i,this.int16[s+3]=n,t}}Rn.prototype.bytesPerElement=8,ji("StructArrayLayout4i8",Rn);class Ln extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,i,n,s,a)}emplace(t,e,r,i,n,s,a,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=i,this.uint8[u+5]=n,this.uint8[u+6]=s,this.uint8[u+7]=a,this.float32[c+2]=o,t}}Ln.prototype.bytesPerElement=12,ji("StructArrayLayout2i4ub1f12",Ln);class Un extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const i=2*t;return this.float32[i+0]=e,this.float32[i+1]=r,t}}Un.prototype.bytesPerElement=8,ji("StructArrayLayout2f8",Un);class On extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,i,n,s,a,o,l,u)}emplace(t,e,r,i,n,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=i,this.uint16[h+3]=n,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}On.prototype.bytesPerElement=20,ji("StructArrayLayout10ui20",On);class $n extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,i,n,s,a,o,l,u,c,h)}emplace(t,e,r,i,n,s,a,o,l,u,c,h,p){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=i,this.int16[d+3]=n,this.uint16[d+4]=s,this.uint16[d+5]=a,this.uint16[d+6]=o,this.uint16[d+7]=l,this.int16[d+8]=u,this.int16[d+9]=c,this.int16[d+10]=h,this.int16[d+11]=p,t}}$n.prototype.bytesPerElement=24,ji("StructArrayLayout4i4ui4i24",$n);class qn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r)}emplace(t,e,r,i){const n=3*t;return this.float32[n+0]=e,this.float32[n+1]=r,this.float32[n+2]=i,t}}qn.prototype.bytesPerElement=12,ji("StructArrayLayout3f12",qn);class Nn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}Nn.prototype.bytesPerElement=4,ji("StructArrayLayout1ul4",Nn);class jn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,i,n,s,a,o,l,u)}emplace(t,e,r,i,n,s,a,o,l,u,c){const h=16*t,p=8*t;return this.int16[h+0]=e,this.int16[h+1]=r,this.float32[p+1]=i,this.float32[p+2]=n,this.float32[p+3]=s,this.float32[p+4]=a,this.int16[h+10]=o,this.uint32[p+6]=l,this.uint16[h+14]=u,this.uint16[h+15]=c,t}}jn.prototype.bytesPerElement=32,ji("StructArrayLayout2i4f1i1ul2ui32",jn);class Kn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,i,n,s)}emplace(t,e,r,i,n,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=i,this.int16[o+3]=n,this.int16[o+4]=s,this.int16[o+5]=a,t}}Kn.prototype.bytesPerElement=12,ji("StructArrayLayout2i2i2i12",Kn);class Zn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,i,n)}emplace(t,e,r,i,n,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=i,this.int16[o+6]=n,this.int16[o+7]=s,t}}Zn.prototype.bytesPerElement=16,ji("StructArrayLayout2f1f2i16",Zn);class Xn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r,i)}emplace(t,e,r,i,n){const s=12*t,a=3*t;return this.uint8[s+0]=e,this.uint8[s+1]=r,this.float32[a+1]=i,this.float32[a+2]=n,t}}Xn.prototype.bytesPerElement=12,ji("StructArrayLayout2ub2f12",Xn);class Gn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r)}emplace(t,e,r,i){const n=3*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,this.uint16[n+2]=i,t}}Gn.prototype.bytesPerElement=6,ji("StructArrayLayout3ui6",Gn);class Hn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m)}emplace(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=i,this.uint16[x+3]=n,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=d,this.uint8[b+37]=f,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}Hn.prototype.bytesPerElement=48,ji("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Hn);class Jn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,A,k,S,I,T){const z=this.length;return this.resize(z+1),this.emplace(z,t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,A,k,S,I,T)}emplace(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,A,k,S,I,T,z){const E=34*t,C=17*t;return this.int16[E+0]=e,this.int16[E+1]=r,this.int16[E+2]=i,this.int16[E+3]=n,this.int16[E+4]=s,this.int16[E+5]=a,this.int16[E+6]=o,this.int16[E+7]=l,this.uint16[E+8]=u,this.uint16[E+9]=c,this.uint16[E+10]=h,this.uint16[E+11]=p,this.uint16[E+12]=d,this.uint16[E+13]=f,this.uint16[E+14]=y,this.uint16[E+15]=m,this.uint16[E+16]=g,this.uint16[E+17]=x,this.uint16[E+18]=v,this.uint16[E+19]=b,this.uint16[E+20]=w,this.uint16[E+21]=_,this.uint16[E+22]=A,this.uint32[C+12]=k,this.float32[C+13]=S,this.float32[C+14]=I,this.float32[C+15]=T,this.float32[C+16]=z,t}}Jn.prototype.bytesPerElement=68,ji("StructArrayLayout8i15ui1ul4f68",Jn);class Yn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Yn.prototype.bytesPerElement=4,ji("StructArrayLayout1f4",Yn);class Wn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r)}emplace(t,e,r,i){const n=3*t;return this.int16[n+0]=e,this.int16[n+1]=r,this.int16[n+2]=i,t}}Wn.prototype.bytesPerElement=6,ji("StructArrayLayout3i6",Wn);class Qn extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r)}emplace(t,e,r,i){const n=4*t;return this.uint32[2*t+0]=e,this.uint16[n+2]=r,this.uint16[n+3]=i,t}}Qn.prototype.bytesPerElement=8,ji("StructArrayLayout1ul2ui8",Qn);class ts extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const i=2*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,t}}ts.prototype.bytesPerElement=4,ji("StructArrayLayout2ui4",ts);class es extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}es.prototype.bytesPerElement=2,ji("StructArrayLayout1ui2",es);class rs extends Dn{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r,i)}emplace(t,e,r,i,n){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=i,this.float32[s+3]=n,t}}rs.prototype.bytesPerElement=16,ji("StructArrayLayout4f16",rs);class is extends Bn{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.float32[this._pos4+1]}get y1(){return this._structArray.float32[this._pos4+2]}get x2(){return this._structArray.float32[this._pos4+3]}get y2(){return this._structArray.float32[this._pos4+4]}get padding(){return this._structArray.int16[this._pos2+10]}get featureIndex(){return this._structArray.uint32[this._pos4+6]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+14]}get bucketIndex(){return this._structArray.uint16[this._pos2+15]}get anchorPoint(){return new i(this.anchorPointX,this.anchorPointY)}}is.prototype.size=32;class ns extends jn{get(t){return new is(this,t)}}ji("CollisionBoxArray",ns);class ss extends Bn{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}ss.prototype.size=48;class as extends Hn{get(t){return new ss(this,t)}}ji("PlacedSymbolArray",as);class os extends Bn{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get textOffset0(){return this._structArray.float32[this._pos4+14]}get textOffset1(){return this._structArray.float32[this._pos4+15]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+16]}}os.prototype.size=68;class ls extends Jn{get(t){return new os(this,t)}}ji("SymbolInstanceArray",ls);class us extends Yn{getoffsetX(t){return this.float32[1*t+0]}}ji("GlyphOffsetArray",us);class cs extends Wn{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}ji("SymbolLineVertexArray",cs);class hs extends Bn{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}hs.prototype.size=8;class ps extends Qn{get(t){return new hs(this,t)}}ji("FeatureIndexArray",ps);const ds=Pn([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var fs=se((function(t){t.exports=function(t,e){var r,i,n,s,a,o,l,u;for(i=t.length-(r=3&t.length),n=e,a=3432918353,o=461845907,u=0;u<i;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,n=27492+(65535&(s=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return n^=t.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0};})),ys=se((function(t){t.exports=function(t,e){for(var r,i=t.length,n=e^i,s=0;i>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),i-=4,++s;switch(i){case 3:n^=(255&t.charCodeAt(s+2))<<16;case 2:n^=(255&t.charCodeAt(s+1))<<8;case 1:n=1540483477*(65535&(n^=255&t.charCodeAt(s)))+((1540483477*(n>>>16)&65535)<<16);}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0};})),ms=fs,gs=ys;ms.murmur3=fs,ms.murmur2=gs;class xs{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,i){this.ids.push(vs(t)),this.positions.push(e,r,i);}getPositions(t){const e=vs(t);let r=0,i=this.ids.length-1;for(;r<i;){const t=r+i>>1;this.ids[t]>=e?i=t:r=t+1;}const n=[];for(;this.ids[r]===e;)n.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return n}static serialize(t,e){const r=new Float64Array(t.ids),i=new Uint32Array(t.positions);return function t(e,r,i,n){for(;i<n;){const s=e[i+n>>1];let a=i-1,o=n+1;for(;;){do{a++;}while(e[a]<s);do{o--;}while(e[o]>s);if(a>=o)break;bs(e,a,o),bs(r,3*a,3*o),bs(r,3*a+1,3*o+1),bs(r,3*a+2,3*o+2);}o-i<n-o?(t(e,r,i,o),i=o+1):(t(e,r,o+1,n),n=o);}}(r,i,0,r.length-1),e&&e.push(r.buffer,i.buffer),{ids:r,positions:i}}static deserialize(t){const e=new xs;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function vs(t){const e=+t;return !isNaN(e)&&e<=o?e:ms(String(t))}function bs(t,e,r){const i=t[e];t[e]=t[r],t[r]=i;}ji("FeaturePositionMap",xs);class ws{constructor(t,e){this.gl=t.gl,this.location=e;}}class _s extends ws{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class As extends ws{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class ks extends ws{constructor(t,e){super(t,e),this.current=oe.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const Ss=new Float32Array(16),Is=new Float32Array(9);function Ts(t){return [Cn(255*t.r,255*t.g),Cn(255*t.b,255*t.a)]}class zs{constructor(t,e,r){this.value=t,this.uniformNames=e.map(t=>`u_${t}`),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new ks(t,e):new _s(t,e)}}class Es{constructor(t,e){this.uniformNames=e.map(t=>`u_${t}`),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setUniform(t,e,r,i){const n="u_pattern_to"===i?this.patternTo:"u_pattern_from"===i?this.patternFrom:"u_pixel_ratio_to"===i?this.pixelRatioTo:"u_pixel_ratio_from"===i?this.pixelRatioFrom:null;n&&t.set(n);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)?new As(t,e):new _s(t,e)}}class Cs{constructor(t,e,r,i){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map(t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0})),this.paintVertexArray=new i;}populatePaintArray(t,e,r,i,n){const s=this.paintVertexArray.length,a=this.expression.evaluate(new yn(0),e,{},i,[],n);this.paintVertexArray.resize(t),this._setPaintValue(s,t,a);}updatePaintArray(t,e,r,i){const n=this.expression.evaluate({zoom:0},r,i);this._setPaintValue(t,e,n);}_setPaintValue(t,e,r){if("color"===this.type){const i=Ts(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Ms{constructor(t,e,r,i,n,s){this.expression=t,this.uniformNames=e.map(t=>`u_${t}_t`),this.type=r,this.useIntegerZoom=i,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=e.map(t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0})),this.paintVertexArray=new s;}populatePaintArray(t,e,r,i,n){const s=this.expression.evaluate(new yn(this.zoom),e,{},i,[],n),a=this.expression.evaluate(new yn(this.zoom+1),e,{},i,[],n),o=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(o,t,s,a);}updatePaintArray(t,e,r,i){const n=this.expression.evaluate({zoom:this.zoom},r,i),s=this.expression.evaluate({zoom:this.zoom+1},r,i);this._setPaintValue(t,e,n,s);}_setPaintValue(t,e,r,i){if("color"===this.type){const n=Ts(r),s=Ts(i);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1],s[0],s[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r,i);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(i));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,i=f(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(i);}getBinding(t,e,r){return new _s(t,e)}}class Bs{constructor(t,e,r,i,n,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=i,this.layerId=s,this.zoomInPaintVertexArray=new n,this.zoomOutPaintVertexArray=new n;}populatePaintArray(t,e,r){const i=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(i,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,i,n){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],n);}_setPaintValues(t,e,r,i){if(!i||!r)return;const{min:n,mid:s,max:a}=r,o=i[n],l=i[s],u=i[a];if(o&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,ds.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,ds.members,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class Ds{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[];const i=[];for(const n in t.paint._values){if(!r(n))continue;const s=t.paint.get(n);if(!(s instanceof _n&&Ur(s.property.specification)))continue;const a=Vs(n,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[n]=h?new Es(o.value,a):new zs(o.value,a,l),i.push(`/u_${n}`);else if("source"===o.kind||h){const r=Fs(n,l,"source");this.binders[n]=h?new Bs(o,l,u,e,r,t.id):new Cs(o,a,l,r),i.push(`/a_${n}`);}else {const t=Fs(n,l,"composite");this.binders[n]=new Ms(o,a,l,u,e,t),i.push(`/z_${n}`);}}this.cacheKey=i.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Cs||e instanceof Ms?e.maxValue:0}populatePaintArrays(t,e,r,i,n){for(const s in this.binders){const a=this.binders[s];(a instanceof Cs||a instanceof Ms||a instanceof Bs)&&a.populatePaintArray(t,e,r,i,n);}}setConstantPatternPositions(t,e){for(const r in this.binders){const i=this.binders[r];i instanceof Es&&i.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,i,n){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Cs||l instanceof Ms||l instanceof Bs)&&!0===l.expression.isStateDependent){const u=i.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],n),s=!0;}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof zs||r instanceof Es)&&t.push(...r.uniformNames.map(t=>`#define HAS_UNIFORM_${t}`));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Cs||r instanceof Ms)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof Bs)for(let e=0;e<ds.members.length;e++)t.push(ds.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof zs||r instanceof Es||r instanceof Ms)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const i in this.binders){const n=this.binders[i];if(n instanceof zs||n instanceof Es||n instanceof Ms)for(const s of n.uniformNames)if(e[s]){const a=n.getBinding(t,e[s],s);r.push({name:s,property:i,binding:a});}}return r}setUniforms(t,e,r,i){for(const{name:t,property:n,binding:s}of e)this.binders[n].setUniform(s,i,r.get(n),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof Bs){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof Cs||r instanceof Ms)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Cs||r instanceof Ms||r instanceof Bs)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Cs||e instanceof Ms||e instanceof Bs)&&e.destroy();}}}class Ps{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const i of t)this.programConfigurations[i.id]=new Ds(i,e,r);this.needsUpload=!1,this._featureMap=new xs,this._bufferOffset=0;}populatePaintArrays(t,e,r,i,n,s){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,i,n,s);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,i){for(const n of r)this.needsUpload=this.programConfigurations[n.id].updatePaintArrays(t,this._featureMap,e,n,i)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function Vs(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Fs(t,e,r){const i={color:{source:Un,composite:rs},number:{source:Yn,composite:Un}},n=function(t){return {"line-pattern":{source:On,composite:On},"fill-pattern":{source:On,composite:On},"fill-extrusion-pattern":{source:On,composite:On}}[t]}(t);return n&&n[r]||i[e][r]}ji("ConstantBinder",zs),ji("CrossFadedConstantBinder",Es),ji("SourceExpressionBinder",Cs),ji("CrossFadedCompositeBinder",Bs),ji("CompositeExpressionBinder",Ms),ji("ProgramConfiguration",Ds,{omit:["_buffers"]}),ji("ProgramConfigurationSet",Ps);class Rs extends Pt{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=(t=t).metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&"sky"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new wn(e.layout)),e.paint)){this._transitionablePaint=new xn(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new An(e.paint);}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(Ri,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return A(t,"-transition")?this._transitionablePaint.getTransition(t.slice(0,-"-transition".length)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Fi,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(A(t,"-transition"))return this._transitionablePaint.setTransition(t.slice(0,-"-transition".length),e||void 0),!1;{const r=this._transitionablePaint._values[t],i="cross-faded-data-driven"===r.property.specification["property-type"],n=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||n||i||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getProgramConfiguration(t){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),S(t,(t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length))}_validate(t,e,r,i,n={}){return (!n||!1!==n.validate)&&Li(this,t.call(Pi,{key:e,layerType:this.type,objectKey:r,value:i,styleSpec:Vt,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof _n&&Ur(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}const Ls=Pn([{name:"a_pos",components:2,type:"Int16"}],4),{members:Us}=Ls;class Os{constructor(t=[]){this.segments=t;}prepareSegment(t,e,r,i){let n=this.segments[this.segments.length-1];return t>Os.MAX_VERTEX_ARRAY_LENGTH&&z(`Max vertices per segment is ${Os.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!n||n.vertexLength+t>Os.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==i)&&(n={vertexOffset:e.length,primitiveOffset:r.length,vertexLength:0,primitiveLength:0},void 0!==i&&(n.sortKey=i),this.segments.push(n)),n}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,i){return new Os([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:i,vaos:{},sortKey:0}])}}Os.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,ji("SegmentVector",Os);const $s=Math.pow(2,14)-1,qs=-$s-1;function Ns(t){const e=8192/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const i=r[t];for(let t=0;t<i.length;t++){const r=i[t],n=Math.round(r.x*e),s=Math.round(r.y*e);r.x=f(n,qs,$s),r.y=f(s,qs,$s),(n<r.x||n>r.x+1||s<r.y||s>r.y+1)&&z("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function js(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?Ns(t):[]}}function Ks(t,e,r,i,n){t.emplaceBack(2*e+(i+1)/2,2*r+(n+1)/2);}class Zs{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Fn,this.indexArray=new Gn,this.segments=new Os,this.programConfigurations=new Ps(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){const i=this.layers[0],n=[];let s=null;"circle"===i.type&&(s=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=js(e,t);if(!this.layers[0]._featureFilter.filter(new yn(this.zoom),l,r))continue;const u=s?s.evaluate(l,{},r):void 0,c={id:i,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:Ns(e),patterns:{},sortKey:u};n.push(c);}s&&n.sort((t,e)=>t.sortKey-e.sortKey);for(const i of n){const{geometry:n,index:s,sourceLayerIndex:a}=i,o=t[s].feature;this.addFeature(i,n,s,r),e.featureIndex.insert(o,n,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Us),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,i){for(const r of e)for(const e of r){const r=e.x,i=e.y;if(r<0||r>=8192||i<0||i>=8192)continue;const n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),s=n.vertexLength;Ks(this.layoutVertexArray,r,i,-1,-1),Ks(this.layoutVertexArray,r,i,1,-1),Ks(this.layoutVertexArray,r,i,1,1),Ks(this.layoutVertexArray,r,i,-1,1),this.indexArray.emplaceBack(s,s+1,s+2),this.indexArray.emplaceBack(s,s+3,s+2),n.vertexLength+=4,n.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},i);}}function Xs(t,e){for(let r=0;r<t.length;r++)if(ra(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(ra(t,e[r]))return !0;return !!Ys(t,e)}function Gs(t,e,r){return !!ra(t,e)||!!Qs(e,t,r)}function Hs(t,e){if(1===t.length)return ea(e,t[0]);for(let r=0;r<e.length;r++){const i=e[r];for(let e=0;e<i.length;e++)if(ra(t,i[e]))return !0}for(let r=0;r<t.length;r++)if(ea(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Ys(t,e[r]))return !0;return !1}function Js(t,e,r){if(t.length>1){if(Ys(t,e))return !0;for(let i=0;i<e.length;i++)if(Qs(e[i],t,r))return !0}for(let i=0;i<t.length;i++)if(Qs(t[i],e,r))return !0;return !1}function Ys(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const i=t[r],n=t[r+1];for(let t=0;t<e.length-1;t++)if(Ws(i,n,e[t],e[t+1]))return !0}return !1}function Ws(t,e,r,i){return E(t,r,i)!==E(e,r,i)&&E(t,e,r)!==E(t,e,i)}function Qs(t,e,r){const i=r*r;if(1===e.length)return t.distSqr(e[0])<i;for(let r=1;r<e.length;r++)if(ta(t,e[r-1],e[r])<i)return !0;return !1}function ta(t,e,r){const i=e.distSqr(r);if(0===i)return t.distSqr(e);const n=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/i;return t.distSqr(n<0?e:n>1?r:r.sub(e)._mult(n)._add(e))}function ea(t,e){let r,i,n,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)i=r[t],n=r[a],i.y>e.y!=n.y>e.y&&e.x<(n.x-i.x)*(e.y-i.y)/(n.y-i.y)+i.x&&(s=!s);}return s}function ra(t,e){let r=!1;for(let i=0,n=t.length-1;i<t.length;n=i++){const s=t[i],a=t[n];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function ia(t,e,r,n,s){for(const i of t)if(e<=i.x&&r<=i.y&&n>=i.x&&s>=i.y)return !0;const a=[new i(e,r),new i(e,s),new i(n,s),new i(n,r)];if(t.length>2)for(const e of a)if(ra(t,e))return !0;for(let e=0;e<t.length-1;e++)if(na(t[e],t[e+1],a))return !0;return !1}function na(t,e,r){const i=r[0],n=r[2];if(t.x<i.x&&e.x<i.x||t.x>n.x&&e.x>n.x||t.y<i.y&&e.y<i.y||t.y>n.y&&e.y>n.y)return !1;const s=E(t,e,r[0]);return s!==E(t,e,r[1])||s!==E(t,e,r[2])||s!==E(t,e,r[3])}function sa(t,e,r){const i=e.paint.get(t).value;return "constant"===i.kind?i.value:r.programConfigurations.get(e.id).getMaxValue(t)}function aa(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function oa(t,e,r,n,s){if(!e[0]&&!e[1])return t;const a=i.convert(e)._mult(s);"viewport"===r&&a._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o}function la(t,e,r,n){const s=i.convert(t)._mult(n);return "viewport"===e&&s._rotate(-r),s}ji("CircleBucket",Zs,{omit:["layers"]});const ua=new En({"circle-sort-key":new Sn(Vt.layout_circle["circle-sort-key"])});var ca={paint:new En({"circle-radius":new Sn(Vt.paint_circle["circle-radius"]),"circle-color":new Sn(Vt.paint_circle["circle-color"]),"circle-blur":new Sn(Vt.paint_circle["circle-blur"]),"circle-opacity":new Sn(Vt.paint_circle["circle-opacity"]),"circle-translate":new kn(Vt.paint_circle["circle-translate"]),"circle-translate-anchor":new kn(Vt.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new kn(Vt.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new kn(Vt.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Sn(Vt.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Sn(Vt.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Sn(Vt.paint_circle["circle-stroke-opacity"])}),layout:ua},ha="undefined"!=typeof Float32Array?Float32Array:Array;function pa(){var t=new ha(9);return ha!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function da(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function fa(t,e,r){var i=e[0],n=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*i+b*o+w*h+_*y,t[1]=v*n+b*l+w*p+_*m,t[2]=v*s+b*u+w*d+_*g,t[3]=v*a+b*c+w*f+_*x,t[4]=(v=r[4])*i+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*n+b*l+w*p+_*m,t[6]=v*s+b*u+w*d+_*g,t[7]=v*a+b*c+w*f+_*x,t[8]=(v=r[8])*i+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*n+b*l+w*p+_*m,t[10]=v*s+b*u+w*d+_*g,t[11]=v*a+b*c+w*f+_*x,t[12]=(v=r[12])*i+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*n+b*l+w*p+_*m,t[14]=v*s+b*u+w*d+_*g,t[15]=v*a+b*c+w*f+_*x,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var ya=fa;function ma(){var t=new ha(3);return ha!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function ga(t){var e=new ha(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function xa(t){return Math.hypot(t[0],t[1],t[2])}function va(t,e,r){var i=new ha(3);return i[0]=t,i[1]=e,i[2]=r,i}function ba(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t}function wa(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function _a(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t}function Aa(t,e,r,i){return t[0]=e[0]+r[0]*i,t[1]=e[1]+r[1]*i,t[2]=e[2]+r[2]*i,t}function ka(t,e){var r=e[0],i=e[1],n=e[2],s=r*r+i*i+n*n;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function Sa(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function Ia(t,e,r){var i=e[0],n=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=n*l-s*o,t[1]=s*a-i*l,t[2]=i*o-n*a,t}function Ta(t,e,r){var i=r[0],n=r[1],s=r[2],a=e[0],o=e[1],l=e[2],u=n*l-s*o,c=s*a-i*l,h=i*o-n*a,p=n*h-s*c,d=s*u-i*h,f=i*c-n*u,y=2*r[3];return c*=y,h*=y,d*=2,f*=2,t[0]=a+(u*=y)+(p*=2),t[1]=o+c+d,t[2]=l+h+f,t}var za,Ea=wa,Ca=xa;function Ma(t,e,r){var i=e[0],n=e[1],s=e[2],a=e[3];return t[0]=r[0]*i+r[4]*n+r[8]*s+r[12]*a,t[1]=r[1]*i+r[5]*n+r[9]*s+r[13]*a,t[2]=r[2]*i+r[6]*n+r[10]*s+r[14]*a,t[3]=r[3]*i+r[7]*n+r[11]*s+r[15]*a,t}function Ba(){var t=new ha(4);return ha!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function Da(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t}function Pa(t,e,r){r*=.5;var i=e[0],n=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=i*l+a*o,t[1]=n*l+s*o,t[2]=s*l-n*o,t[3]=a*l-i*o,t}ma(),za=new ha(4),ha!=Float32Array&&(za[0]=0,za[1]=0,za[2]=0,za[3]=0),ma(),va(1,0,0),va(0,1,0),Ba(),Ba(),pa();class Va{constructor(t,e){this.points=t,this.planes=e;}static fromInvProjectionMatrix(t,e,r){const i=Math.pow(2,r),n=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map(r=>{const n=Ma([],r,t),s=1/n[3]/e*i;return function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t}(n,n,[s,s,1/n[3],s])}),s=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map(t=>{const e=ka([],Ia([],Ea([],n[t[0]],n[t[1]]),Ea([],n[t[2]],n[t[1]]))),r=-Sa(e,n[t[1]]);return e.concat(r)});return new Va(n,s)}}class Fa{constructor(t,e){this.min=t,this.max=e,this.center=_a([],ba([],this.min,this.max),.5);}quadrant(t){const e=[t%2==0,t<2],r=ga(this.min),i=ga(this.max);for(let t=0;t<e.length;t++)r[t]=e[t]?this.min[t]:this.center[t],i[t]=e[t]?this.center[t]:this.max[t];return i[2]=this.max[2],new Fa(r,i)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}intersects(t){const e=[[this.min[0],this.min[1],this.min[2],1],[this.max[0],this.min[1],this.min[2],1],[this.max[0],this.max[1],this.min[2],1],[this.min[0],this.max[1],this.min[2],1],[this.min[0],this.min[1],this.max[2],1],[this.max[0],this.min[1],this.max[2],1],[this.max[0],this.max[1],this.max[2],1],[this.min[0],this.max[1],this.max[2],1]];let r=!0;for(let s=0;s<t.planes.length;s++){const a=t.planes[s];let o=0;for(let t=0;t<e.length;t++)o+=(i=a)[0]*(n=e[t])[0]+i[1]*n[1]+i[2]*n[2]+i[3]*n[3]>=0;if(0===o)return 0;o!==e.length&&(r=!1);}var i,n;if(r)return 2;for(let e=0;e<3;e++){let r=Number.MAX_VALUE,i=-Number.MAX_VALUE;for(let n=0;n<t.points.length;n++){const s=t.points[n][e]-this.min[e];r=Math.min(r,s),i=Math.max(i,s);}if(i<0||r>this.max[e]-this.min[e])return 0}return 1}}function Ra(t,e,r){const n=Ma([],[t.x,t.y,e,1],r);return new i(n[0]/n[3],n[1]/n[3])}const La=va(0,0,0),Ua=va(0,0,1);function Oa(t,e){const r=ma();return La[2]=e,t.intersectsPlane(La,Ua,r),new i(r[0],r[1])}class $a extends Zs{}function qa(t,{width:e,height:r},i,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==e*r*i)throw new RangeError("mismatched image size")}else n=new Uint8Array(e*r*i);return t.width=e,t.height=r,t.data=n,t}function Na(t,{width:e,height:r},i){if(e===t.width&&r===t.height)return;const n=qa({},{width:e,height:r},i);ja(t,n,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},i),t.width=e,t.height=r,t.data=n.data;}function ja(t,e,r,i,n,s){if(0===n.width||0===n.height)return e;if(n.width>t.width||n.height>t.height||r.x>t.width-n.width||r.y>t.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>e.width||n.height>e.height||i.x>e.width-n.width||i.y>e.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;for(let l=0;l<n.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((i.y+l)*e.width+i.x)*s;for(let t=0;t<n.width*s;t++)o[c+t]=a[u+t];}return e}ji("HeatmapBucket",$a,{omit:["layers"]});class Ka{constructor(t,e){qa(this,t,1,e);}resize(t){Na(this,t,1);}clone(){return new Ka({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,i,n){ja(t,e,r,i,n,1);}}class Za{constructor(t,e){qa(this,t,4,e);}resize(t){Na(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Za({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,i,n){ja(t,e,r,i,n,4);}}ji("AlphaImage",Ka),ji("RGBAImage",Za);var Xa={paint:new En({"heatmap-radius":new Sn(Vt.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Sn(Vt.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new kn(Vt.paint_heatmap["heatmap-intensity"]),"heatmap-color":new zn(Vt.paint_heatmap["heatmap-color"]),"heatmap-opacity":new kn(Vt.paint_heatmap["heatmap-opacity"])})};function Ga(t){const e={},r=t.resolution||256,i=t.clips?t.clips.length:1,n=t.image||new Za({width:r,height:i}),s=(r,i,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);n.data[r+i+0]=Math.floor(255*a.r/a.a),n.data[r+i+1]=Math.floor(255*a.g/a.a),n.data[r+i+2]=Math.floor(255*a.b/a.a),n.data[r+i+3]=Math.floor(255*a.a);};if(t.clips)for(let e=0,n=0;e<i;++e,n+=4*r)for(let i=0,a=0;i<r;i++,a+=4){const o=i/(r-1),{start:l,end:u}=t.clips[e];s(n,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return n}var Ha={paint:new En({"hillshade-illumination-direction":new kn(Vt.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new kn(Vt.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new kn(Vt.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new kn(Vt.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new kn(Vt.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new kn(Vt.paint_hillshade["hillshade-accent-color"])})};const Ja=Pn([{name:"a_pos",components:2,type:"Int16"}],4),{members:Ya}=Ja;var Wa=to,Qa=to;function to(t,e,r){r=r||2;var i,n,s,a,o,l,u,c=e&&e.length,h=c?e[0]*r:t.length,p=eo(t,0,h,r,!0),d=[];if(!p||p.next===p.prev)return d;if(c&&(p=function(t,e,r,i){var n,s,a,o=[];for(n=0,s=e.length;n<s;n++)(a=eo(t,e[n]*i,n<s-1?e[n+1]*i:t.length,i,!1))===a.next&&(a.steiner=!0),o.push(po(a));for(o.sort(lo),n=0;n<o.length;n++)uo(o[n],r),r=ro(r,r.next);return r}(t,e,p,r)),t.length>80*r){i=s=t[0],n=a=t[1];for(var f=r;f<h;f+=r)(o=t[f])<i&&(i=o),(l=t[f+1])<n&&(n=l),o>s&&(s=o),l>a&&(a=l);u=0!==(u=Math.max(s-i,a-n))?1/u:0;}return io(p,d,r,i,n,u),d}function eo(t,e,r,i,n){var s,a;if(n===Io(t,e,r,i)>0)for(s=e;s<r;s+=i)a=Ao(s,t[s],t[s+1],a);else for(s=r-i;s>=e;s-=i)a=Ao(s,t[s],t[s+1],a);return a&&go(a,a.next)&&(ko(a),a=a.next),a}function ro(t,e){if(!t)return t;e||(e=t);var r,i=t;do{if(r=!1,i.steiner||!go(i,i.next)&&0!==mo(i.prev,i,i.next))i=i.next;else {if(ko(i),(i=e=i.prev)===i.next)break;r=!0;}}while(r||i!==e);return e}function io(t,e,r,i,n,s,a){if(t){!a&&s&&function(t,e,r,i){var n=t;do{null===n.z&&(n.z=ho(n.x,n.y,e,r,i)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next;}while(n!==t);n.prevZ.nextZ=null,n.prevZ=null,function(t){var e,r,i,n,s,a,o,l,u=1;do{for(r=t,t=null,s=null,a=0;r;){for(a++,i=r,o=0,e=0;e<u&&(o++,i=i.nextZ);e++);for(l=u;o>0||l>0&&i;)0!==o&&(0===l||!i||r.z<=i.z)?(n=r,r=r.nextZ,o--):(n=i,i=i.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;r=i;}s.nextZ=null,u*=2;}while(a>1)}(n);}(t,i,n,s);for(var o,l,u=t;t.prev!==t.next;)if(o=t.prev,l=t.next,s?so(t,i,n,s):no(t))e.push(o.i/r),e.push(t.i/r),e.push(l.i/r),ko(t),t=l.next,u=l.next;else if((t=l)===u){a?1===a?io(t=ao(ro(t),e,r),e,r,i,n,s,2):2===a&&oo(t,e,r,i,n,s):io(ro(t),e,r,i,n,s,1);break}}}function no(t){var e=t.prev,r=t,i=t.next;if(mo(e,r,i)>=0)return !1;for(var n=t.next.next;n!==t.prev;){if(fo(e.x,e.y,r.x,r.y,i.x,i.y,n.x,n.y)&&mo(n.prev,n,n.next)>=0)return !1;n=n.next;}return !0}function so(t,e,r,i){var n=t.prev,s=t,a=t.next;if(mo(n,s,a)>=0)return !1;for(var o=n.x>s.x?n.x>a.x?n.x:a.x:s.x>a.x?s.x:a.x,l=n.y>s.y?n.y>a.y?n.y:a.y:s.y>a.y?s.y:a.y,u=ho(n.x<s.x?n.x<a.x?n.x:a.x:s.x<a.x?s.x:a.x,n.y<s.y?n.y<a.y?n.y:a.y:s.y<a.y?s.y:a.y,e,r,i),c=ho(o,l,e,r,i),h=t.prevZ,p=t.nextZ;h&&h.z>=u&&p&&p.z<=c;){if(h!==t.prev&&h!==t.next&&fo(n.x,n.y,s.x,s.y,a.x,a.y,h.x,h.y)&&mo(h.prev,h,h.next)>=0)return !1;if(h=h.prevZ,p!==t.prev&&p!==t.next&&fo(n.x,n.y,s.x,s.y,a.x,a.y,p.x,p.y)&&mo(p.prev,p,p.next)>=0)return !1;p=p.nextZ;}for(;h&&h.z>=u;){if(h!==t.prev&&h!==t.next&&fo(n.x,n.y,s.x,s.y,a.x,a.y,h.x,h.y)&&mo(h.prev,h,h.next)>=0)return !1;h=h.prevZ;}for(;p&&p.z<=c;){if(p!==t.prev&&p!==t.next&&fo(n.x,n.y,s.x,s.y,a.x,a.y,p.x,p.y)&&mo(p.prev,p,p.next)>=0)return !1;p=p.nextZ;}return !0}function ao(t,e,r){var i=t;do{var n=i.prev,s=i.next.next;!go(n,s)&&xo(n,i,i.next,s)&&wo(n,s)&&wo(s,n)&&(e.push(n.i/r),e.push(i.i/r),e.push(s.i/r),ko(i),ko(i.next),i=t=s),i=i.next;}while(i!==t);return ro(i)}function oo(t,e,r,i,n,s){var a=t;do{for(var o=a.next.next;o!==a.prev;){if(a.i!==o.i&&yo(a,o)){var l=_o(a,o);return a=ro(a,a.next),l=ro(l,l.next),io(a,e,r,i,n,s),void io(l,e,r,i,n,s)}o=o.next;}a=a.next;}while(a!==t)}function lo(t,e){return t.x-e.x}function uo(t,e){if(e=function(t,e){var r,i=e,n=t.x,s=t.y,a=-1/0;do{if(s<=i.y&&s>=i.next.y&&i.next.y!==i.y){var o=i.x+(s-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(o<=n&&o>a){if(a=o,o===n){if(s===i.y)return i;if(s===i.next.y)return i.next}r=i.x<i.next.x?i:i.next;}}i=i.next;}while(i!==e);if(!r)return null;if(n===a)return r;var l,u=r,c=r.x,h=r.y,p=1/0;i=r;do{n>=i.x&&i.x>=c&&n!==i.x&&fo(s<h?n:a,s,c,h,s<h?a:n,s,i.x,i.y)&&(l=Math.abs(s-i.y)/(n-i.x),wo(i,t)&&(l<p||l===p&&(i.x>r.x||i.x===r.x&&co(r,i)))&&(r=i,p=l)),i=i.next;}while(i!==u);return r}(t,e)){var r=_o(e,t);ro(e,e.next),ro(r,r.next);}}function co(t,e){return mo(t.prev,t,e.prev)<0&&mo(e.next,t,t.next)<0}function ho(t,e,r,i,n){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*n)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-i)*n)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function po(t){var e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function fo(t,e,r,i,n,s,a,o){return (n-a)*(e-o)-(t-a)*(s-o)>=0&&(t-a)*(i-o)-(r-a)*(e-o)>=0&&(r-a)*(s-o)-(n-a)*(i-o)>=0}function yo(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&xo(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(wo(t,e)&&wo(e,t)&&function(t,e){var r=t,i=!1,n=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&n<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(i=!i),r=r.next;}while(r!==t);return i}(t,e)&&(mo(t.prev,t,e.prev)||mo(t,e.prev,e))||go(t,e)&&mo(t.prev,t,t.next)>0&&mo(e.prev,e,e.next)>0)}function mo(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function go(t,e){return t.x===e.x&&t.y===e.y}function xo(t,e,r,i){var n=bo(mo(t,e,r)),s=bo(mo(t,e,i)),a=bo(mo(r,i,t)),o=bo(mo(r,i,e));return n!==s&&a!==o||!(0!==n||!vo(t,r,e))||!(0!==s||!vo(t,i,e))||!(0!==a||!vo(r,t,i))||!(0!==o||!vo(r,e,i))}function vo(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function bo(t){return t>0?1:t<0?-1:0}function wo(t,e){return mo(t.prev,t,t.next)<0?mo(t,e,t.next)>=0&&mo(t,t.prev,e)>=0:mo(t,e,t.prev)<0||mo(t,t.next,e)<0}function _o(t,e){var r=new So(t.i,t.x,t.y),i=new So(e.i,e.x,e.y),n=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=n,n.prev=r,i.next=r,r.prev=i,s.next=i,i.prev=s,i}function Ao(t,e,r,i){var n=new So(t,e,r);return i?(n.next=i.next,n.prev=i,i.next.prev=n,i.next=n):(n.prev=n,n.next=n),n}function ko(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function So(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1;}function Io(t,e,r,i){for(var n=0,s=e,a=r-i;s<r;s+=i)n+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return n}function To(t,e,r,i,n){!function t(e,r,i,n,s){for(;n>i;){if(n-i>600){var a=n-i+1,o=r-i+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);t(e,r,Math.max(i,Math.floor(r-o*u/a+c)),Math.min(n,Math.floor(r+(a-o)*u/a+c)),s);}var h=e[r],p=i,d=n;for(zo(e,i,r),s(e[n],h)>0&&zo(e,i,n);p<d;){for(zo(e,p,d),p++,d--;s(e[p],h)<0;)p++;for(;s(e[d],h)>0;)d--;}0===s(e[i],h)?zo(e,i,d):zo(e,++d,n),d<=r&&(i=d+1),r<=d&&(n=d-1);}}(t,e,r||0,i||t.length-1,n||Eo);}function zo(t,e,r){var i=t[e];t[e]=t[r],t[r]=i;}function Eo(t,e){return t<e?-1:t>e?1:0}function Co(t,e){const r=t.length;if(r<=1)return [t];const i=[];let n,s;for(let e=0;e<r;e++){const r=C(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(n&&i.push(n),n=[t[e]]):n.push(t[e]));}if(n&&i.push(n),e>1)for(let t=0;t<i.length;t++)i[t].length<=e||(To(i[t],e,1,i[t].length-1,Mo),i[t]=i[t].slice(0,e));return i}function Mo(t,e){return e.area-t.area}function Bo(t,e,r){const i=r.patternDependencies;let n=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(n=!0);const s=e.constantOr(null);s&&(n=!0,i[s.to]=!0,i[s.from]=!0);}return n}function Do(t,e,r,i,n){const s=n.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:i-1},r,{},n.availableImages),o=e.evaluate({zoom:i},r,{},n.availableImages),l=e.evaluate({zoom:i+1},r,{},n.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,s[t]=!0,s[o]=!0,s[l]=!0,r.patterns[a.id]={min:t,mid:o,max:l};}}return r}to.deviation=function(t,e,r,i){var n=e&&e.length,s=Math.abs(Io(t,0,n?e[0]*r:t.length,r));if(n)for(var a=0,o=e.length;a<o;a++)s-=Math.abs(Io(t,e[a]*r,a<o-1?e[a+1]*r:t.length,r));var l=0;for(a=0;a<i.length;a+=3){var u=i[a]*r,c=i[a+1]*r,h=i[a+2]*r;l+=Math.abs((t[u]-t[h])*(t[c+1]-t[u+1])-(t[u]-t[c])*(t[h+1]-t[u+1]));}return 0===s&&0===l?0:Math.abs((l-s)/s)},to.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},i=0,n=0;n<t.length;n++){for(var s=0;s<t[n].length;s++)for(var a=0;a<e;a++)r.vertices.push(t[n][s][a]);n>0&&r.holes.push(i+=t[n-1].length);}return r},Wa.default=Qa;class Po{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new Fn,this.indexArray=new Gn,this.indexArray2=new ts,this.programConfigurations=new Ps(t.layers,t.zoom),this.segments=new Os,this.segments2=new Os,this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){this.hasPattern=Bo("fill",this.layers,e);const i=this.layers[0].layout.get("fill-sort-key"),n=[];for(const{feature:s,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=js(s,t);if(!this.layers[0]._featureFilter.filter(new yn(this.zoom),u,r))continue;const c=i?i.evaluate(u,{},r,e.availableImages):void 0,h={id:a,properties:s.properties,type:s.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Ns(s),patterns:{},sortKey:c};n.push(h);}i&&n.sort((t,e)=>t.sortKey-e.sortKey);for(const i of n){const{geometry:n,index:s,sourceLayerIndex:a}=i;if(this.hasPattern){const t=Do("fill",this.layers,i,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(i,n,s,r,{});e.featureIndex.insert(t[s].feature,n,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ya),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,i,n){for(const t of Co(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),i=r.vertexLength,n=[],s=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&s.push(n.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),i=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(i+e.length-1,i),n.push(e[0].x),n.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(i+t-1,i+t),n.push(e[t].x),n.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const a=Wa(n,s);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(i+a[t],i+a[t+1],i+a[t+2]);r.vertexLength+=e,r.primitiveLength+=a.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,n,i);}}ji("FillBucket",Po,{omit:["layers","patternFeatures"]});const Vo=new En({"fill-sort-key":new Sn(Vt.layout_fill["fill-sort-key"])});var Fo={paint:new En({"fill-antialias":new kn(Vt.paint_fill["fill-antialias"]),"fill-opacity":new Sn(Vt.paint_fill["fill-opacity"]),"fill-color":new Sn(Vt.paint_fill["fill-color"]),"fill-outline-color":new Sn(Vt.paint_fill["fill-outline-color"]),"fill-translate":new kn(Vt.paint_fill["fill-translate"]),"fill-translate-anchor":new kn(Vt.paint_fill["fill-translate-anchor"]),"fill-pattern":new In(Vt.paint_fill["fill-pattern"])}),layout:Vo};const Ro=Pn([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),Lo=Pn([{name:"a_centroid_pos",components:2,type:"Uint16"}]),{members:Uo}=Ro;var Oo=$o;function $o(t,e,r,i,n){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=i,this._values=n,t.readFields(qo,this,e);}function qo(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var i=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[i]=n;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function No(t){for(var e,r,i=0,n=0,s=t.length,a=s-1;n<s;a=n++)i+=((r=t[a]).x-(e=t[n]).x)*(e.y+r.y);return i}$o.types=["Unknown","Point","LineString","Polygon"],$o.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,s=0,a=0,o=0,l=[];t.pos<r;){if(s<=0){var u=t.readVarint();n=7&u,s=u>>3;}if(s--,1===n||2===n)a+=t.readSVarint(),o+=t.readSVarint(),1===n&&(e&&l.push(e),e=[]),e.push(new i(a,o));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&l.push(e),l},$o.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,i=0,n=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(i<=0){var c=t.readVarint();r=7&c,i=c>>3;}if(i--,1===r||2===r)(n+=t.readSVarint())<a&&(a=n),n>o&&(o=n),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},$o.prototype.toGeoJSON=function(t,e,r){var i,n,s=this.extent*Math.pow(2,r),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=$o.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+a)/s-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/s)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(i=0;i<l.length;i++)h[i]=l[i][0];c(l=h);break;case 2:for(i=0;i<l.length;i++)c(l[i]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,i,n=[],s=0;s<e;s++){var a=No(t[s]);0!==a&&(void 0===i&&(i=a<0),i===a<0?(r&&n.push(r),r=[t[s]]):r.push(t[s]));}return r&&n.push(r),n}(l),i=0;i<l.length;i++)for(n=0;n<l[i].length;n++)c(l[i][n]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var jo=Ko;function Ko(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Zo,this,e),this.length=this._features.length;}function Zo(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var i=t.readVarint()>>3;e=1===i?t.readString():2===i?t.readFloat():3===i?t.readDouble():4===i?t.readVarint64():5===i?t.readVarint():6===i?t.readSVarint():7===i?t.readBoolean():null;}return e}(r));}function Xo(t,e,r){if(3===t){var i=new jo(r,r.readVarint()+r.pos);i.length&&(e[i.name]=i);}}Ko.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new Oo(this._pbf,e,this.extent,this._keys,this._values)};var Go={VectorTile:function(t,e){this.layers=t.readFields(Xo,{},e);},VectorTileFeature:Oo,VectorTileLayer:jo};const Ho=Go.VectorTileFeature.types,Jo=Math.pow(2,13);function Yo(t,e,r,i,n,s,a,o){t.emplaceBack((e<<1)+a,(r<<1)+s,(Math.floor(i*Jo)<<1)+n,Math.round(o));}class Wo{constructor(){this.acc=new i(0,0),this.polyCount=[];}startRing(t){this.currentPolyCount={edges:0,top:0},this.polyCount.push(this.currentPolyCount),this.min||(this.min=new i(t.x,t.y),this.max=new i(t.x,t.y));}append(t,e){this.currentPolyCount.edges++,this.acc._add(t);let r=!!this.borders;const i=this.min,n=this.max;t.x<i.x?(i.x=t.x,r=!0):t.x>n.x&&(n.x=t.x,r=!0),t.y<i.y?(i.y=t.y,r=!0):t.y>n.y&&(n.y=t.y,r=!0),((0===t.x||8192===t.x)&&t.x===e.x)!=((0===t.y||8192===t.y)&&t.y===e.y)&&this.processBorderOverlap(t,e),r&&this.checkBorderIntersection(t,e);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,Ye(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>8192!=t.x>8192&&this.addBorderIntersection(1,Ye(e.y,t.y,(8192-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,Ye(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>8192!=t.y>8192&&this.addBorderIntersection(3,Ye(e.x,t.x,(8192-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){const t=this.polyCount.reduce((t,e)=>t+e.edges,0);return 0!==t?this.acc.div(t)._round():new i(0,0)}span(){return new i(this.max.x-this.min.x,this.max.y-this.min.y)}intersectsCount(){return this.borders.reduce((t,e)=>t+ +(e[0]!==Number.MAX_VALUE),0)}}class Qo{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Rn,this.centroidVertexArray=new ts,this.indexArray=new Gn,this.programConfigurations=new Ps(t.layers,t.zoom),this.segments=new Os,this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id),this.enableTerrain=t.enableTerrain;}populate(t,e,r){this.features=[],this.hasPattern=Bo("fill-extrusion",this.layers,e),this.featuresOnBorder=[],this.borders=[[],[],[],[]],this.borderDone=[!1,!1,!1,!1],this.tileToMeter=function(t){const e=Math.exp(Math.PI*(1-t.y/(1<<t.z)*2));return 80150034*e/(e*e+1)/8192/(1<<t.z)}(r);for(const{feature:i,id:n,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=js(i,t);if(!this.layers[0]._featureFilter.filter(new yn(this.zoom),o,r))continue;const l={id:n,sourceLayerIndex:a,index:s,geometry:t?o.geometry:Ns(i),properties:i.properties,type:i.type,patterns:{}};this.hasPattern?this.features.push(Do("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,r,{}),e.featureIndex.insert(i,l.geometry,s,a,this.index);}this.sortBorders();}addFeatures(t,e,r){for(const t of this.features){const{geometry:i}=t;this.addFeature(t,i,t.index,e,r);}this.sortBorders();}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Uo),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){0!==this.centroidVertexArray.length&&(this.centroidVertexBuffer?this.needsCentroidUpdate&&this.centroidVertexBuffer.updateData(this.centroidVertexArray):this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Lo.members,!0),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,i,n){const s=this.enableTerrain&&t.properties&&t.properties.hasOwnProperty("type")&&t.properties.hasOwnProperty("height")&&"Polygon"===Ho[t.type]?new Wo:null;for(const r of Co(e,500)){let e=0,i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray);if(0===r.length||(a=r[0]).every(t=>t.x<=0)||a.every(t=>t.x>=8192)||a.every(t=>t.y<=0)||a.every(t=>t.y>=8192))continue;for(let t=0;t<r.length;t++){const n=r[t];if(0===n.length)continue;e+=n.length;let a=0;s&&s.startRing(n[0]);for(let t=0;t<n.length;t++){const e=n[t];if(t>=1){const r=n[t-1];if(!tl(e,r)){s&&s.append(e,r),i.vertexLength+4>Os.MAX_VERTEX_ARRAY_LENGTH&&(i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const t=e.sub(r)._perp(),n=t.x/(Math.abs(t.x)+Math.abs(t.y)),o=t.y>0?1:0,l=r.dist(e);a+l>32768&&(a=0),Yo(this.layoutVertexArray,e.x,e.y,n,o,0,0,a),Yo(this.layoutVertexArray,e.x,e.y,n,o,0,1,a),a+=l,Yo(this.layoutVertexArray,r.x,r.y,n,o,0,0,a),Yo(this.layoutVertexArray,r.x,r.y,n,o,0,1,a);const u=i.vertexLength;this.indexArray.emplaceBack(u,u+2,u+1),this.indexArray.emplaceBack(u+1,u+2,u+3),i.vertexLength+=4,i.primitiveLength+=2;}}}}if(i.vertexLength+e>Os.MAX_VERTEX_ARRAY_LENGTH&&(i=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray)),"Polygon"!==Ho[t.type])continue;const n=[],o=[],l=i.vertexLength;for(let t=0;t<r.length;t++){const e=r[t];if(0!==e.length){e!==r[0]&&o.push(n.length/2);for(let t=0;t<e.length;t++){const r=e[t];Yo(this.layoutVertexArray,r.x,r.y,0,0,1,1,0),n.push(r.x),n.push(r.y),s&&s.currentPolyCount.top++;}}}const u=Wa(n,o);for(let t=0;t<u.length;t+=3)this.indexArray.emplaceBack(l+u[t],l+u[t+2],l+u[t+1]);i.primitiveLength+=u.length/3,i.vertexLength+=e;}var a;if(s&&s.polyCount.length>0){if(s.borders){s.vertexArrayOffset=this.centroidVertexArray.length;const t=s.borders,e=this.featuresOnBorder.push(s)-1;for(let r=0;r<4;r++)t[r][0]!==Number.MAX_VALUE&&this.borders[r].push(e);}this.encodeCentroid(s.borders?void 0:s.centroid(),s);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,n,i);}sortBorders(){for(let t=0;t<4;t++)this.borders[t].sort((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]);}encodeCentroid(t,e,r=!0){let i,n;if(t)if(0!==t.y){const r=e.span()._mult(this.tileToMeter);i=(Math.max(t.x,1)<<3)+Math.min(7,Math.round(r.x/10)),n=(Math.max(t.y,1)<<3)+Math.min(7,Math.round(r.y/10));}else i=Math.ceil(7.3*t.x),n=0;else i=0,n=+r;let s=r?this.centroidVertexArray.length:e.vertexArrayOffset;for(const t of e.polyCount){r&&this.centroidVertexArray.resize(this.centroidVertexArray.length+4*t.edges+t.top);for(let e=0;e<2*t.edges;e++)this.centroidVertexArray.emplace(s++,0,n),this.centroidVertexArray.emplace(s++,i,n);for(let e=0;e<t.top;e++)this.centroidVertexArray.emplace(s++,i,n);}}}function tl(t,e){return t.x===e.x&&(t.x<0||t.x>8192)||t.y===e.y&&(t.y<0||t.y>8192)}ji("FillExtrusionBucket",Qo,{omit:["layers","features"]}),ji("PartMetadata",Wo);var el={paint:new En({"fill-extrusion-opacity":new kn(Vt["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Sn(Vt["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new kn(Vt["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new kn(Vt["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new In(Vt["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Sn(Vt["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Sn(Vt["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new kn(Vt["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})};function rl(t,e){return t.x*e.x+t.y*e.y}function il(t,e){if(1===t.length){let r=0;const i=e[r++];let n;for(;!n||i.equals(n);)if(n=e[r++],!n)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=n.sub(i),l=s.sub(i),u=a.sub(i),c=rl(o,o),h=rl(o,l),p=rl(l,l),d=rl(u,o),f=rl(u,l),y=c*p-h*h,m=(p*d-h*f)/y,g=(c*f-h*d)/y,x=i.z*(1-m-g)+n.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const nl=Pn([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:sl}=nl,al=Pn([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:ol}=al,ll=Go.VectorTileFeature.types,ul=Math.cos(Math.PI/180*37.5);class cl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach(t=>{this.gradients[t.id]={};}),this.layoutVertexArray=new Ln,this.layoutVertexArray2=new Un,this.indexArray=new Gn,this.programConfigurations=new Ps(t.layers,t.zoom),this.segments=new Os,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){this.hasPattern=Bo("line",this.layers,e);const i=this.layers[0].layout.get("line-sort-key"),n=[];for(const{feature:e,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=js(e,t);if(!this.layers[0]._featureFilter.filter(new yn(this.zoom),l,r))continue;const u=i?i.evaluate(l,{},r):void 0,c={id:s,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:Ns(e),patterns:{},sortKey:u};n.push(c);}i&&n.sort((t,e)=>t.sortKey-e.sortKey);for(const i of n){const{geometry:n,index:s,sourceLayerIndex:a}=i;if(this.hasPattern){const t=Do("line",this.layers,i,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(i,n,s,r,{});e.featureIndex.insert(t[s].feature,n,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,ol)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,sl),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,i,n){const s=this.layers[0].layout,a=s.get("line-join").evaluate(t,{}),o=s.get("line-cap"),l=s.get("line-miter-limit"),u=s.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,a,o,l,u);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,n,i);}addLine(t,e,r,i,n,s){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const a="Polygon"===ll[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(a?3:2))return;"bevel"===r&&(n=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p=void 0,d=void 0,f=void 0,y=void 0;this.e1=this.e2=-1,a&&(h=t[o-2],y=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(d=e===o-1?a?t[l+1]:void 0:t[e+1],d&&t[e].equals(d))continue;y&&(f=y),h&&(p=h),h=t[e],y=d?d.sub(h)._unit()._perp():f,f=f||y;let m=f.add(y);0===m.x&&0===m.y||m._unit();const g=f.x*y.x+f.y*y.y,x=m.x*y.x+m.y*y.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<ul&&p&&d,_=f.x*y.y-f.y*y.x>0;if(w&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,f,0,0,c),p=e;}}const A=p&&d;let k=A?r:a?"butt":i;if(A&&"round"===k&&(v<s?k="miter":v<=2&&(k="fakeround")),"miter"===k&&v>n&&(k="bevel"),"bevel"===k&&(v>2&&(k="flipbevel"),v<n&&(k="miter")),p&&this.updateDistance(p,h),"miter"===k)m._mult(v),this.addCurrentVertex(h,m,0,0,c);else if("flipbevel"===k){if(v>100)m=y.mult(-1);else {const t=v*f.add(y).mag()/f.sub(y).mag();m._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(h,m,0,0,c),this.addCurrentVertex(h,m.mult(-1),0,0,c);}else if("bevel"===k||"fakeround"===k){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(p&&this.addCurrentVertex(h,f,e,r,c),"fakeround"===k){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const i=y.sub(f)._mult(r)._add(f)._unit()._mult(_?-1:1);this.addHalfVertex(h,i.x,i.y,!1,_,0,c);}}d&&this.addCurrentVertex(h,y,-e,-r,c);}else if("butt"===k)this.addCurrentVertex(h,m,0,0,c);else if("square"===k){const t=p?1:-1;this.addCurrentVertex(h,m,t,t,c);}else "round"===k&&(p&&(this.addCurrentVertex(h,f,0,0,c),this.addCurrentVertex(h,f,1,1,c,!0)),d&&(this.addCurrentVertex(h,y,-1,-1,c,!0),this.addCurrentVertex(h,y,0,0,c)));if(w&&e<o-1){const t=h.dist(d);if(t>2*u){const e=h.add(d.sub(h)._mult(u/t)._round());this.updateDistance(h,e),this.addCurrentVertex(e,y,0,0,c),h=e;}}}}addCurrentVertex(t,e,r,i,n,s=!1){const a=e.y*i-e.x,o=-e.y-e.x*i;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,n),this.addHalfVertex(t,a,o,s,!0,-i,n);}addHalfVertex({x:t,y:e},r,i,n,s,a,o){this.layoutVertexArray.emplaceBack((t<<1)+(n?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*i)+128,1+(0===a?0:a<0?-1:1),0,this.lineSoFar),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length);const l=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,l),o.primitiveLength++),s?this.e2=l:this.e1=l;}updateScaledDistance(){if(this.lineClips){const t=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t*this.lineClips.start+this.distance;}else this.lineSoFar=this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}ji("LineBucket",cl,{omit:["layers","patternFeatures"]});const hl=new En({"line-cap":new kn(Vt.layout_line["line-cap"]),"line-join":new Sn(Vt.layout_line["line-join"]),"line-miter-limit":new kn(Vt.layout_line["line-miter-limit"]),"line-round-limit":new kn(Vt.layout_line["line-round-limit"]),"line-sort-key":new Sn(Vt.layout_line["line-sort-key"])});var pl={paint:new En({"line-opacity":new Sn(Vt.paint_line["line-opacity"]),"line-color":new Sn(Vt.paint_line["line-color"]),"line-translate":new kn(Vt.paint_line["line-translate"]),"line-translate-anchor":new kn(Vt.paint_line["line-translate-anchor"]),"line-width":new Sn(Vt.paint_line["line-width"]),"line-gap-width":new Sn(Vt.paint_line["line-gap-width"]),"line-offset":new Sn(Vt.paint_line["line-offset"]),"line-blur":new Sn(Vt.paint_line["line-blur"]),"line-dasharray":new Tn(Vt.paint_line["line-dasharray"]),"line-pattern":new In(Vt.paint_line["line-pattern"]),"line-gradient":new zn(Vt.paint_line["line-gradient"])}),layout:hl};const dl=new class extends Sn{possiblyEvaluate(t,e){return e=new yn(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,i){return e=g({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,i)}}(pl.paint.properties["line-width"].specification);function fl(t,e){return e>0?e+2*t:t}dl.useIntegerZoom=!0;const yl=Pn([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),ml=Pn([{name:"a_projected_pos",components:3,type:"Float32"}],4),gl=(Pn([{name:"a_fade_opacity",components:1,type:"Uint32"}],4),Pn([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}])),xl=Pn([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"}]),vl=(Pn([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]),Pn([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4)),bl=Pn([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function wl(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new yn(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:i}=r;let n=0;for(;n<e.length&&e[n]<=t;)n++;n=Math.max(0,n-1);let s=n;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[n],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:i}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new yn(a)),maxSize:r.evaluate(new yn(o)),interpolationType:i}}}function _l(t,{uSize:e,uSizeT:r},{lowerSize:i,upperSize:n}){return "source"===t.kind?i/128:"composite"===t.kind?Ye(i/128,n/128,r):e}function Al(t,e){let r=0,i=0;if("constant"===t.kind)i=t.layoutSize;else if("source"!==t.kind){const{interpolationType:n,minZoom:s,maxZoom:a}=t,o=n?f(pr.interpolationFactor(n,e,s,a),0,1):0;"camera"===t.kind?i=Ye(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:i}}Pn([{name:"triangle",components:3,type:"Uint16"}]),Pn([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),Pn([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"}]),Pn([{type:"Float32",name:"offsetX"}]),Pn([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]);var kl=Object.freeze({__proto__:null,getSizeData:wl,evaluateSizeForFeature:_l,evaluateSizeForZoom:Al,SIZE_PACK_FACTOR:128});function Sl(t,e,r){return t.sections.forEach(t=>{t.text=function(t,e,r){const i=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===i?t=t.toLocaleUpperCase():"lowercase"===i&&(t=t.toLocaleLowerCase()),fn.applyArabicShaping&&(t=fn.applyArabicShaping(t)),t}(t.text,e,r);}),t}const Il={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var Tl=function(t,e,r,i,n){var s,a,o=8*n-i-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?n-1:0,p=r?-1:1,d=t[e+h];for(h+=p,s=d&(1<<-c)-1,d>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=i;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(d?-1:1);a+=Math.pow(2,i),s-=u;}return (d?-1:1)*a*Math.pow(2,s-i)},zl=function(t,e,r,i,n,s){var a,o,l,u=8*s-n-1,c=(1<<u)-1,h=c>>1,p=23===n?Math.pow(2,-24)-Math.pow(2,-77):0,d=i?0:s-1,f=i?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,n),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,n),a=0));n>=8;t[r+d]=255&o,d+=f,o/=256,n-=8);for(a=a<<n|o,u+=n;u>0;t[r+d]=255&a,d+=f,a/=256,u-=8);t[r+d-f]|=128*y;},El=Cl;function Cl(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}Cl.Varint=0,Cl.Fixed64=1,Cl.Bytes=2,Cl.Fixed32=5;var Ml="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function Bl(t){return t.type===Cl.Bytes?t.readVarint()+t.pos:t.pos+1}function Dl(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function Pl(t,e,r){var i=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(i);for(var n=r.pos-1;n>=t;n--)r.buf[n+i]=r.buf[n];}function Vl(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function Fl(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function Rl(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function Ll(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function Ul(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Ol(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function $l(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function ql(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function Nl(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function jl(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function Kl(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function Zl(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}function Xl(t,e,r){1===t&&r.readMessage(Gl,e);}function Gl(t,e,r){if(3===t){const{id:t,bitmap:i,width:n,height:s,left:a,top:o,advance:l}=r.readMessage(Hl,{});e.push({id:t,bitmap:new Ka({width:n+6,height:s+6},i),metrics:{width:n,height:s,left:a,top:o,advance:l}});}}function Hl(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function Jl(t){let e=0,r=0;for(const i of t)e+=i.w*i.h,r=Math.max(r,i.w);t.sort((t,e)=>e.h-t.h);const i=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let n=0,s=0;for(const e of t)for(let t=i.length-1;t>=0;t--){const r=i[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),n=Math.max(n,e.x+e.w),e.w===r.w&&e.h===r.h){const e=i.pop();t<i.length&&(i[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(i.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:n,h:s,fill:e/(n*s)||0}}Cl.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var i=this.readVarint(),n=i>>3,s=this.pos;this.type=7&i,t(n,e,this),this.pos===s&&this.skip(i);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=jl(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=Zl(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=jl(this.buf,this.pos)+4294967296*jl(this.buf,this.pos+4);return this.pos+=8,t},readSFixed64:function(){var t=jl(this.buf,this.pos)+4294967296*Zl(this.buf,this.pos+4);return this.pos+=8,t},readFloat:function(){var t=Tl(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=Tl(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,i=this.buf;return e=127&(r=i[this.pos++]),r<128?e:(e|=(127&(r=i[this.pos++]))<<7,r<128?e:(e|=(127&(r=i[this.pos++]))<<14,r<128?e:(e|=(127&(r=i[this.pos++]))<<21,r<128?e:function(t,e,r){var i,n,s=r.buf;if(i=(112&(n=s[r.pos++]))>>4,n<128)return Dl(t,i,e);if(i|=(127&(n=s[r.pos++]))<<3,n<128)return Dl(t,i,e);if(i|=(127&(n=s[r.pos++]))<<10,n<128)return Dl(t,i,e);if(i|=(127&(n=s[r.pos++]))<<17,n<128)return Dl(t,i,e);if(i|=(127&(n=s[r.pos++]))<<24,n<128)return Dl(t,i,e);if(i|=(1&(n=s[r.pos++]))<<31,n<128)return Dl(t,i,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=i[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&Ml?function(t,e,r){return Ml.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var i="",n=e;n<r;){var s,a,o,l=t[n],u=null,c=l>239?4:l>223?3:l>191?2:1;if(n+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[n+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[n+2],128==(192&(s=t[n+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[n+2],o=t[n+3],128==(192&(s=t[n+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,i+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),i+=String.fromCharCode(u),n+=c;}return i}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==Cl.Bytes)return t.push(this.readVarint(e));var r=Bl(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==Cl.Bytes)return t.push(this.readSVarint());var e=Bl(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==Cl.Bytes)return t.push(this.readBoolean());var e=Bl(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==Cl.Bytes)return t.push(this.readFloat());var e=Bl(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==Cl.Bytes)return t.push(this.readDouble());var e=Bl(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==Cl.Bytes)return t.push(this.readFixed32());var e=Bl(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==Cl.Bytes)return t.push(this.readSFixed32());var e=Bl(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==Cl.Bytes)return t.push(this.readFixed64());var e=Bl(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==Cl.Bytes)return t.push(this.readSFixed64());var e=Bl(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===Cl.Varint)for(;this.buf[this.pos++]>127;);else if(e===Cl.Bytes)this.pos=this.readVarint()+this.pos;else if(e===Cl.Fixed32)this.pos+=4;else {if(e!==Cl.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),Kl(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),Kl(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),Kl(this.buf,-1&t,this.pos),Kl(this.buf,Math.floor(t*(1/4294967296)),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),Kl(this.buf,-1&t,this.pos),Kl(this.buf,Math.floor(t*(1/4294967296)),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,i;if(t>=0?(r=t%4294967296|0,i=t/4294967296|0):(i=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,i=i+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(i,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var i,n,s=0;s<e.length;s++){if((i=e.charCodeAt(s))>55295&&i<57344){if(!n){i>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):n=i;continue}if(i<56320){t[r++]=239,t[r++]=191,t[r++]=189,n=i;continue}i=n-55296<<10|i-56320|65536,n=null;}else n&&(t[r++]=239,t[r++]=191,t[r++]=189,n=null);i<128?t[r++]=i:(i<2048?t[r++]=i>>6|192:(i<65536?t[r++]=i>>12|224:(t[r++]=i>>18|240,t[r++]=i>>12&63|128),t[r++]=i>>6&63|128),t[r++]=63&i|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&Pl(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),zl(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),zl(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var i=this.pos-r;i>=128&&Pl(r,i,this),this.pos=r-1,this.writeVarint(i),this.pos+=i;},writeMessage:function(t,e,r){this.writeTag(t,Cl.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,Vl,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,Fl,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,Ul,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,Rl,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,Ll,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,Ol,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,$l,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,ql,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,Nl,e);},writeBytesField:function(t,e){this.writeTag(t,Cl.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,Cl.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,Cl.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,Cl.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,Cl.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,Cl.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,Cl.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,Cl.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,Cl.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,Cl.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};class Yl{constructor(t,{pixelRatio:e,version:r,stretchX:i,stretchY:n,content:s}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=i,this.stretchY=n,this.content=s,this.version=r;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Wl{constructor(t,e){const r={},i={};this.haveRenderCallbacks=[];const n=[];this.addImages(t,r,n),this.addImages(e,i,n);const{w:s,h:a}=Jl(n),o=new Za({width:s||1,height:a||1});for(const e in t){const i=t[e],n=r[e].paddedRect;Za.copy(i.data,o,{x:0,y:0},{x:n.x+1,y:n.y+1},i.data);}for(const t in e){const r=e[t],n=i[t].paddedRect,s=n.x+1,a=n.y+1,l=r.data.width,u=r.data.height;Za.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),Za.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),Za.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),Za.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),Za.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=i;}addImages(t,e,r){for(const i in t){const n=t[i],s={x:0,y:0,w:n.data.width+2,h:n.data.height+2};r.push(s),e[i]=new Yl(s,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(i);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[i,n]=t.tl;r.update(e.data,void 0,{x:i,y:n});}}ji("ImagePosition",Yl),ji("ImageAtlas",Wl);const Ql={horizontal:1,vertical:2,horizontalOnly:3};class tu{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new tu;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new tu;return e.imageName=t,e}}class eu{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new eu;for(let i=0;i<t.sections.length;i++){const n=t.sections[i];n.image?r.addImageSection(n):r.addTextSection(n,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const i=t.charCodeAt(r+1)||null,n=t.charCodeAt(r-1)||null;e+=i&&en(i)&&!Il[t[r+1]]||n&&en(n)&&!Il[t[r-1]]||!Il[t[r]]?t[r]:Il[t[r]];}return e}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&iu[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&iu[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new eu;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce((t,e)=>Math.max(t,this.sections[e].scale),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(tu.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void z("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(tu.forImage(e)),this.sectionIndex.push(this.sections.length-1)):z("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function ru(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y){const m=eu.fromFeature(t,n);let g;h===Ql.vertical&&m.verticalizePunctuation();const{processBidirectionalText:x,processStyledBidirectionalText:v}=fn;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),uu(m,u,s,e,i,d,f));for(const e of t){const t=new eu;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(v){g=[];const t=v(m.text,m.sectionIndex,uu(m,u,s,e,i,d,f));for(const e of t){const t=new eu;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t);}}else g=function(t,e){const r=[],i=t.text;let n=0;for(const i of e)r.push(t.substring(n,i)),n=i;return n<i.length&&r.push(t.substring(n,i.length)),r}(m,uu(m,u,s,e,i,d,f));const b=[],w={positionedLines:b,text:m.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1};return function(t,e,r,i,n,s,a,o,l,u,c,h){let p=0,d=-17,f=0,y=0;const m="right"===o?1:"left"===o?0:.5;let g=0;for(const a of n){a.trim();const n=a.getMaxScale(),o=24*(n-1),v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let w=0;if(!a.length()){d+=s,++g;continue}for(let s=0;s<a.length();s++){const f=a.getSection(s),y=a.getSectionIndex(s),m=a.getCharCode(s);let g=0,v=null,_=null,A=null,k=24;const S=!(l===Ql.horizontal||!c&&!tn(m)||c&&(iu[m]||(x=m,Ji.Arabic(x)||Ji["Arabic Supplement"](x)||Ji["Arabic Extended-A"](x)||Ji["Arabic Presentation Forms-A"](x)||Ji["Arabic Presentation Forms-B"](x))));if(f.imageName){const e=i[f.imageName];if(!e)continue;A=f.imageName,t.iconsInText=t.iconsInText||!0,_=e.paddedRect;const r=e.displaySize;f.scale=24*f.scale/h,v={width:r[0],height:r[1],left:1,top:-3,advance:S?r[1]:r[0]},g=o+(24-r[1]*f.scale),k=v.advance;const s=S?r[0]*f.scale-24*n:r[1]*f.scale-24*n;s>0&&s>w&&(w=s);}else {const t=r[f.fontStack],i=t&&t[m];if(i&&i.rect)_=i.rect,v=i.metrics;else {const t=e[f.fontStack],r=t&&t[m];if(!r)continue;v=r.metrics;}g=24*(n-f.scale);}S?(t.verticalizable=!0,b.push({glyph:m,imageName:A,x:p,y:d+g,vertical:S,scale:f.scale,fontStack:f.fontStack,sectionIndex:y,metrics:v,rect:_}),p+=k*f.scale+u):(b.push({glyph:m,imageName:A,x:p,y:d+g,vertical:S,scale:f.scale,fontStack:f.fontStack,sectionIndex:y,metrics:v,rect:_}),p+=v.advance*f.scale+u);}0!==b.length&&(f=Math.max(p-u,f),hu(b,0,b.length-1,m,w)),p=0;const _=s*n+w;v.lineOffset=Math.max(w,o),d+=_,y=Math.max(_,y),++g;}var x;const v=d- -17,{horizontalAlign:b,verticalAlign:w}=cu(a);(function(t,e,r,i,n,s,a,o,l){const u=(e-r)*n;let c=0;c=s!==a?-o*i- -17:(-i*l+.5)*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;})(t.positionedLines,m,b,w,f,y,s,v,n.length),t.top+=-w*v,t.bottom=t.top+v,t.left+=-b*f,t.right=t.left+f;}(w,e,r,i,g,a,o,l,h,u,p,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&w}const iu={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},nu={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function su(t,e,r,i,n,s){if(e.imageName){const t=i[e.imageName];return t?t.displaySize[0]*e.scale*24/s+n:0}{const i=r[e.fontStack],s=i&&i[t];return s?s.metrics.advance*e.scale+n:0}}function au(t,e,r,i){const n=Math.pow(t-e,2);return i?t<e?n/2:2*n:n+Math.abs(r)*r}function ou(t,e,r){let i=0;return 10===t&&(i-=1e4),r&&(i+=150),40!==t&&65288!==t||(i+=50),41!==e&&65289!==e||(i+=50),i}function lu(t,e,r,i,n,s){let a=null,o=au(e,r,n,s);for(const t of i){const i=au(e-t.x,r,n,s)+t.badness;i<=o&&(a=t,o=i);}return {index:t,x:e,priorBreak:a,badness:o}}function uu(t,e,r,i,n,s,a){if("point"!==s)return [];if(!t)return [];const o=[],l=function(t,e,r,i,n,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=su(t.getCharCode(r),o,i,n,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,i,n,a),u=t.text.indexOf("​")>=0;let c=0;for(let r=0;r<t.length();r++){const s=t.getSection(r),p=t.getCharCode(r);if(iu[p]||(c+=su(p,s,i,n,e,a)),r<t.length()-1){const e=!((h=p)<11904||!(Ji["Bopomofo Extended"](h)||Ji.Bopomofo(h)||Ji["CJK Compatibility Forms"](h)||Ji["CJK Compatibility Ideographs"](h)||Ji["CJK Compatibility"](h)||Ji["CJK Radicals Supplement"](h)||Ji["CJK Strokes"](h)||Ji["CJK Symbols and Punctuation"](h)||Ji["CJK Unified Ideographs Extension A"](h)||Ji["CJK Unified Ideographs"](h)||Ji["Enclosed CJK Letters and Months"](h)||Ji["Halfwidth and Fullwidth Forms"](h)||Ji.Hiragana(h)||Ji["Ideographic Description Characters"](h)||Ji["Kangxi Radicals"](h)||Ji["Katakana Phonetic Extensions"](h)||Ji.Katakana(h)||Ji["Vertical Forms"](h)||Ji["Yi Radicals"](h)||Ji["Yi Syllables"](h)));(nu[p]||e||s.imageName)&&o.push(lu(r+1,c,l,o,ou(p,t.getCharCode(r+1),e&&u),!1));}}var h;return function t(e){return e?t(e.priorBreak).concat(e.index):[]}(lu(t.length(),c,l,o,0,!0))}function cu(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function hu(t,e,r,i,n){if(!i&&!n)return;const s=t[r],a=(t[r].x+s.metrics.advance*s.scale)*i;for(let i=e;i<=r;i++)t[i].x-=a,t[i].y+=n;}function pu(t,e,r){const{horizontalAlign:i,verticalAlign:n}=cu(r),s=e[0]-t.displaySize[0]*i,a=e[1]-t.displaySize[1]*n;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function du(t,e,r,i,n,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,d;"width"===r||"both"===r?(d=n[0]+l-i[3],h=n[0]+u+i[1]):(d=n[0]+(l+u-a.displaySize[0])/2,h=d+a.displaySize[0]);const f=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=n[1]+f-i[0],p=n[1]+y+i[2]):(c=n[1]+(f+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:d,collisionPadding:o}}class fu extends i{constructor(t,e,r,i){super(t,e),this.angle=r,void 0!==i&&(this.segment=i);}clone(){return new fu(this.x,this.y,this.angle,this.segment)}}function yu(t,e,r,i,n){if(void 0===e.segment)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>i;)u-=l.shift().angleDelta;if(u>n)return !1;a++,o+=e.dist(r);}return !0}function mu(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function gu(t,e,r){return t?.6*e*r:0}function xu(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function vu(t,e,r,i,n,s){const a=gu(r,n,s),o=xu(r,i)*s;let l=0;const u=mu(t)/2;for(let r=0;r<t.length-1;r++){const i=t[r],n=t[r+1],s=i.dist(n);if(l+s>u){const c=(u-l)/s,h=Ye(i.x,n.x,c),p=Ye(i.y,n.y,c),d=new fu(h,p,n.angleTo(i),r);return d._round(),!a||yu(t,d,o,a,e)?d:void 0}l+=s;}}function bu(t,e,r,i,n,s,a,o,l){const u=gu(i,s,a),c=xu(i,n),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),function t(e,r,i,n,s,a,o,l,u){const c=a/2,h=mu(e);let p=0,d=r-i,f=[];for(let t=0;t<e.length-1;t++){const r=e[t],o=e[t+1],l=r.dist(o),y=o.angleTo(r);for(;d+i<p+l;){d+=i;const m=(d-p)/l,g=Ye(r.x,o.x,m),x=Ye(r.y,o.y,m);if(g>=0&&g<u&&x>=0&&x<u&&d-c>=0&&d+c<=h){const r=new fu(g,x,y,t);r._round(),n&&!yu(e,r,a,n,s)||f.push(r);}}p+=l;}return l||f.length||o||(f=t(e,p/2,i,n,s,a,o,!0,u)),f}(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function wu(t,e,r,n,s){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new i(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new i(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<r&&c.y<r||(o.y<r?o=new i(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round():c.y<r&&(c=new i(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round()),o.x>=n&&c.x>=n||(o.x>=n?o=new i(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=n&&(c=new i(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=s&&c.y>=s||(o.y>=s?o=new i(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round():c.y>=s&&(c=new i(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a}function _u(t,e,r,n){const s=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2,u=a.paddedRect.h-2,c=t.right-t.left,h=t.bottom-t.top,p=a.stretchX||[[0,l]],d=a.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],y=p.reduce(f,0),m=d.reduce(f,0),g=l-y,x=u-m;let v=0,b=y,w=0,_=m,A=0,k=g,S=0,I=x;if(a.content&&n){const t=a.content;v=Au(p,0,t[0]),w=Au(d,0,t[1]),b=Au(p,t[0],t[2]),_=Au(d,t[1],t[3]),A=t[0]-v,S=t[1]-w,k=t[2]-t[0]-b,I=t[3]-t[1]-_;}const T=(n,s,l,u)=>{const p=Su(n.stretch-v,b,c,t.left),d=Iu(n.fixed-A,k,n.stretch,y),f=Su(s.stretch-w,_,h,t.top),g=Iu(s.fixed-S,I,s.stretch,m),x=Su(l.stretch-v,b,c,t.left),T=Iu(l.fixed-A,k,l.stretch,y),z=Su(u.stretch-w,_,h,t.top),E=Iu(u.fixed-S,I,u.stretch,m),C=new i(p,f),M=new i(x,f),B=new i(x,z),D=new i(p,z),P=new i(d/o,g/o),V=new i(T/o,E/o),F=e*Math.PI/180;if(F){const t=Math.sin(F),e=Math.cos(F),r=[e,-t,t,e];C._matMult(r),M._matMult(r),D._matMult(r),B._matMult(r);}const R=n.stretch+n.fixed,L=s.stretch+s.fixed;return {tl:C,tr:M,bl:D,br:B,tex:{x:a.paddedRect.x+1+R,y:a.paddedRect.y+1+L,w:l.stretch+l.fixed-R,h:u.stretch+u.fixed-L},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:P,pixelOffsetBR:V,minFontScaleX:k/o/c,minFontScaleY:I/o/h,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=ku(p,g,y),e=ku(d,x,m);for(let r=0;r<t.length-1;r++){const i=t[r],n=t[r+1];for(let t=0;t<e.length-1;t++)s.push(T(i,e[t],n,e[t+1]));}}else s.push(T({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function Au(t,e,r){let i=0;for(const n of t)i+=Math.max(e,Math.min(r,n[1]))-Math.max(e,Math.min(r,n[0]));return i}function ku(t,e,r){const i=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=i[i.length-1];i.push({fixed:e-t.stretch,stretch:t.stretch}),i.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return i.push({fixed:e+1,stretch:r}),i}function Su(t,e,r,i){return t/e*r+i}function Iu(t,e,r,i){return t-e*r/i}ji("Anchor",fu);class Tu{constructor(t=[],e=zu){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this.length++,this._up(this.length-1);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,i=e[t];for(;t>0;){const n=t-1>>1,s=e[n];if(r(i,s)>=0)break;e[t]=s,t=n;}e[t]=i;}_down(t){const{data:e,compare:r}=this,i=this.length>>1,n=e[t];for(;t<i;){let i=1+(t<<1),s=e[i];const a=i+1;if(a<this.length&&r(e[a],s)<0&&(i=a,s=e[a]),r(s,n)>=0)break;e[t]=s,t=i;}e[t]=n;}}function zu(t,e){return t<e?-1:t>e?1:0}function Eu(t,e=1,r=!1){let n=1/0,s=1/0,a=-1/0,o=-1/0;const l=t[0];for(let t=0;t<l.length;t++){const e=l[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<s)&&(s=e.y),(!t||e.x>a)&&(a=e.x),(!t||e.y>o)&&(o=e.y);}const u=Math.min(a-n,o-s);let c=u/2;const h=new Tu([],Cu);if(0===u)return new i(n,s);for(let e=n;e<a;e+=u)for(let r=s;r<o;r+=u)h.push(new Mu(e+c,r+c,c,t));let p=function(t){let e=0,r=0,i=0;const n=t[0];for(let t=0,s=n.length,a=s-1;t<s;a=t++){const s=n[t],o=n[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,i+=(s.y+o.y)*l,e+=3*l;}return new Mu(r/e,i/e,0,t)}(t),d=h.length;for(;h.length;){const i=h.pop();(i.d>p.d||!p.d)&&(p=i,r&&console.log("found best %d after %d probes",Math.round(1e4*i.d)/1e4,d)),i.max-p.d<=e||(c=i.h/2,h.push(new Mu(i.p.x-c,i.p.y-c,c,t)),h.push(new Mu(i.p.x+c,i.p.y-c,c,t)),h.push(new Mu(i.p.x-c,i.p.y+c,c,t)),h.push(new Mu(i.p.x+c,i.p.y+c,c,t)),d+=4);}return r&&(console.log(`num probes: ${d}`),console.log(`best distance: ${p.d}`)),p.p}function Cu(t,e){return e.max-t.max}function Mu(t,e,r,n){this.p=new i(t,e),this.h=r,this.d=function(t,e){let r=!1,i=1/0;for(let n=0;n<e.length;n++){const s=e[n];for(let e=0,n=s.length,a=n-1;e<n;a=e++){const n=s[e],o=s[a];n.y>t.y!=o.y>t.y&&t.x<(o.x-n.x)*(t.y-n.y)/(o.y-n.y)+n.x&&(r=!r),i=Math.min(i,ta(t,n,o));}}return (r?1:-1)*Math.sqrt(i)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}const Bu=Number.POSITIVE_INFINITY;function Du(t,e){return e[1]!==Bu?function(t,e,r){let i=0,n=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":n=r-7;break;case"bottom-right":case"bottom-left":case"bottom":n=7-r;}switch(t){case"top-right":case"bottom-right":case"right":i=-e;break;case"top-left":case"bottom-left":case"left":i=e;}return [i,n]}(t,e[0],e[1]):function(t,e){let r=0,i=0;e<0&&(e=0);const n=e/Math.sqrt(2);switch(t){case"top-right":case"top-left":i=n-7;break;case"bottom-right":case"bottom-left":i=7-n;break;case"bottom":i=7-e;break;case"top":i=e-7;}switch(t){case"top-right":case"bottom-right":r=-n;break;case"top-left":case"bottom-left":r=n;break;case"left":r=e;break;case"right":r=-e;}return [r,i]}(t,e[0])}function Pu(t,e,r,i,n,s,a,o){t.createArrays(),t.tilePixelRatio=8192/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const l=t.layers[0].layout,u=t.layers[0]._unevaluatedLayout._values,c={};if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;c.compositeTextSizes=[u["text-size"].possiblyEvaluate(new yn(e),a),u["text-size"].possiblyEvaluate(new yn(r),a)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;c.compositeIconSizes=[u["icon-size"].possiblyEvaluate(new yn(e),a),u["icon-size"].possiblyEvaluate(new yn(r),a)];}c.layoutTextSize=u["text-size"].possiblyEvaluate(new yn(o+1),a),c.layoutIconSize=u["icon-size"].possiblyEvaluate(new yn(o+1),a),c.textMaxSize=u["text-size"].possiblyEvaluate(new yn(18),a);const h=24*l.get("text-line-height"),p="map"===l.get("text-rotation-alignment")&&"point"!==l.get("symbol-placement"),d=l.get("text-keep-upright"),f=l.get("text-size");for(const s of t.features){const o=l.get("text-font").evaluate(s,{},a).join(","),u=f.evaluate(s,{},a),y=c.layoutTextSize.evaluate(s,{},a),m=(c.layoutIconSize.evaluate(s,{},a),{horizontal:{},vertical:void 0}),g=s.text;let x,v=[0,0];if(g){const i=g.toString(),c=24*l.get("text-letter-spacing").evaluate(s,{},a),f=Wi(i)?c:0,x=l.get("text-anchor").evaluate(s,{},a),b=l.get("text-variable-anchor");if(!b){const t=l.get("text-radial-offset").evaluate(s,{},a);v=t?Du(x,[24*t,Bu]):l.get("text-offset").evaluate(s,{},a).map(t=>24*t);}let w=p?"center":l.get("text-justify").evaluate(s,{},a);const _=l.get("symbol-placement"),A="point"===_?24*l.get("text-max-width").evaluate(s,{},a):0,k=()=>{t.allowVerticalPlacement&&Yi(i)&&(m.vertical=ru(g,e,r,n,o,A,h,x,"left",f,v,Ql.vertical,!0,_,y,u));};if(!p&&b){const t="auto"===w?b.map(t=>Vu(t)):[w];let i=!1;for(let s=0;s<t.length;s++){const a=t[s];if(!m.horizontal[a])if(i)m.horizontal[a]=m.horizontal[0];else {const t=ru(g,e,r,n,o,A,h,"center",a,f,v,Ql.horizontal,!1,_,y,u);t&&(m.horizontal[a]=t,i=1===t.positionedLines.length);}}k();}else {"auto"===w&&(w=Vu(x));const t=ru(g,e,r,n,o,A,h,x,w,f,v,Ql.horizontal,!1,_,y,u);t&&(m.horizontal[w]=t),k(),Yi(i)&&p&&d&&(m.vertical=ru(g,e,r,n,o,A,h,x,w,f,v,Ql.vertical,!1,_,y,u));}}let b=!1;if(s.icon&&s.icon.name){const e=i[s.icon.name];e&&(x=pu(n[s.icon.name],l.get("icon-offset").evaluate(s,{},a),l.get("icon-anchor").evaluate(s,{},a)),b=e.sdf,void 0===t.sdfIcons?t.sdfIcons=e.sdf:t.sdfIcons!==e.sdf&&z("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.pixelRatio||0!==l.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}const w=Lu(m.horizontal)||m.vertical;t.iconsInText=!!w&&w.iconsInText,(w||x)&&Fu(t,s,m,x,i,c,y,0,v,b,a);}s&&t.generateCollisionDebugBuffers(o,t.collisionBoxArray);}function Vu(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Fu(t,e,r,i,n,s,a,o,l,u,h){let p=s.textMaxSize.evaluate(e,{},h);void 0===p&&(p=a);const d=t.layers[0].layout,f=d.get("icon-offset").evaluate(e,{},h),y=Lu(r.horizontal),m=a/24,g=t.tilePixelRatio*m,x=t.tilePixelRatio*p/24,v=t.tilePixelRatio*d.get("symbol-spacing"),b=d.get("text-padding")*t.tilePixelRatio,w=d.get("icon-padding")*t.tilePixelRatio,_=c(d.get("text-max-angle")),A="map"===d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),k="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),S=d.get("symbol-placement"),I=v/2,T=d.get("icon-text-fit");let E;i&&"none"!==T&&(t.allowVerticalPlacement&&r.vertical&&(E=du(i,r.vertical,T,d.get("icon-text-fit-padding"),f,m)),y&&(i=du(i,y,T,d.get("icon-text-fit-padding"),f,m)));const C=(o,c)=>{c.x<0||c.x>=8192||c.y<0||c.y>=8192||function(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,A,k){const S=t.addToLineVertexArray(e,r);let I,T,E,C,M,B,D,P=0,V=0,F=0,R=0,L=-1,U=-1;const O={};let $=ms(""),q=0,N=0;if(void 0===o._unevaluatedLayout.getValue("text-radial-offset")?[q,N]=o.layout.get("text-offset").evaluate(b,{},A).map(t=>24*t):(q=24*o.layout.get("text-radial-offset").evaluate(b,{},A),N=Bu),t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(f)B=Ou(t),a&&(D=Ou(a));else {const r=o.layout.get("text-rotate").evaluate(b,{},A)+90;E=Uu(l,e,u,c,h,t,0,d,r),a&&(C=Uu(l,e,u,c,h,a,0,g,r));}}if(n){const r=o.layout.get("icon-rotate").evaluate(b,{},A),i="none"!==o.layout.get("icon-text-fit"),s=_u(n,r,_,i),p=a?_u(a,r,_,i):void 0;T=Uu(l,e,u,c,h,n,0,g,r),P=4*s.length;const d=t.iconSizeData;let f=null;"source"===d.kind?(f=[128*o.layout.get("icon-size").evaluate(b,{},A)],f[0]>32640&&z(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(f=[128*w.compositeIconSizes[0].evaluate(b,{},A),128*w.compositeIconSizes[1].evaluate(b,{},A)],(f[0]>32640||f[1]>32640)&&z(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,s,f,v,x,b,!1,e,S.lineStartIndex,S.lineLength,-1,A),L=t.icon.placedSymbolArray.length-1,p&&(V=4*p.length,t.addSymbols(t.icon,p,f,v,x,b,Ql.vertical,e,S.lineStartIndex,S.lineLength,-1,A),U=t.icon.placedSymbolArray.length-1);}for(const r in i.horizontal){const n=i.horizontal[r];I||($=ms(n.text),f?M=Ou(n):I=Uu(l,e,u,c,h,n,0,d,o.layout.get("text-rotate").evaluate(b,{},A)));const a=1===n.positionedLines.length;if(F+=Ru(t,e,n,s,o,f,b,y,S,i.vertical?Ql.horizontal:Ql.horizontalOnly,a?Object.keys(i.horizontal):[r],O,L,w,A),a)break}i.vertical&&(R+=Ru(t,e,i.vertical,s,o,f,b,y,S,Ql.vertical,["vertical"],O,U,w,A));let j=-1;const K=(t,e)=>t?Math.max(t,e):e;j=K(M,j),j=K(B,j),j=K(D,j);const Z=j>-1?1:0;Z&&(j*=k/24),t.glyphOffsetArray.length>=Hu.MAX_GLYPHS&&z("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,O.right>=0?O.right:-1,O.center>=0?O.center:-1,O.left>=0?O.left:-1,O.vertical||-1,L,U,$,void 0!==I?I:t.collisionBoxArray.length,void 0!==I?I+1:t.collisionBoxArray.length,void 0!==E?E:t.collisionBoxArray.length,void 0!==E?E+1:t.collisionBoxArray.length,void 0!==T?T:t.collisionBoxArray.length,void 0!==T?T+1:t.collisionBoxArray.length,C||t.collisionBoxArray.length,C?C+1:t.collisionBoxArray.length,u,F,R,P,V,Z,0,p,q,N,j);}(t,c,o,r,i,n,E,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,g,b,A,l,0,w,k,f,e,s,u,h,a);};if("line"===S)for(const n of wu(e.geometry,0,0,8192,8192)){const e=bu(n,v,_,r.vertical||y,i,24,x,t.overscaling,8192);for(const r of e){const e=y;e&&$u(t,e.text,I,r)||C(n,r);}}else if("line-center"===S){for(const t of e.geometry)if(t.length>1){const e=vu(t,_,r.vertical||y,i,24,x);e&&C(t,e);}}else if("Polygon"===e.type)for(const t of Co(e.geometry,0)){const e=Eu(t,16);C(t[0],new fu(e.x,e.y,0));}else if("LineString"===e.type)for(const t of e.geometry)C(t,new fu(t[0].x,t[0].y,0));else if("Point"===e.type)for(const t of e.geometry)for(const e of t)C([e],new fu(e.x,e.y,0));}function Ru(t,e,r,n,s,a,o,l,u,c,h,p,d,f,y){const m=function(t,e,r,n,s,a,o,l){const u=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const a=n.rect||{};let h=4,p=!0,d=1,f=0;const y=(s||l)&&n.vertical,m=n.metrics.advance*n.scale/2;if(l&&e.verticalizable){const e=24*(n.scale-1),r=(24-n.metrics.width*n.scale)/2;f=t.lineOffset/2-(n.imageName?-r:e);}if(n.imageName){const t=o[n.imageName];p=t.sdf,d=t.pixelRatio,h=1/d;}const g=s?[n.x+m,n.y]:[0,0];let x=s?[0,0]:[n.x+m+r[0],n.y+r[1]-f],v=[0,0];y&&(v=x,x=[0,0]);const b=(n.metrics.left-h)*n.scale-m+x[0],w=(-n.metrics.top-h)*n.scale+x[1],_=b+a.w*n.scale/d,A=w+a.h*n.scale/d,k=new i(b,w),S=new i(_,w),I=new i(b,A),T=new i(_,A);if(y){const t=new i(-m,m- -17),e=-Math.PI/2,r=12-m,s=new i(22-r,-(n.imageName?r:0)),a=new i(...v);k._rotateAround(e,t)._add(s)._add(a),S._rotateAround(e,t)._add(s)._add(a),I._rotateAround(e,t)._add(s)._add(a),T._rotateAround(e,t)._add(s)._add(a);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];k._matMult(r),S._matMult(r),I._matMult(r),T._matMult(r);}const z=new i(0,0),E=new i(0,0);c.push({tl:k,tr:S,bl:I,br:T,tex:a,writingMode:e.writingMode,glyphOffset:g,sectionIndex:n.sectionIndex,isSDF:p,pixelOffsetTL:z,pixelOffsetBR:E,minFontScaleX:0,minFontScaleY:0});}return c}(0,r,l,s,a,o,n,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[128*s.layout.get("text-size").evaluate(o,{},y)],x[0]>32640&&z(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[128*f.compositeTextSizes[0].evaluate(o,{},y),128*f.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>32640||x[1]>32640)&&z(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,a,o,c,e,u.lineStartIndex,u.lineLength,d,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function Lu(t){for(const e in t)return t[e];return null}function Uu(t,e,r,n,s,a,o,l,u){let h=a.top,p=a.bottom,d=a.left,f=a.right;const y=a.collisionPadding;if(y&&(d-=y[0],h-=y[1],f+=y[2],p+=y[3]),u){const t=new i(d,h),e=new i(f,h),r=new i(d,p),n=new i(f,p),s=c(u);t._rotate(s),e._rotate(s),r._rotate(s),n._rotate(s),d=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),h=Math.min(t.y,e.y,r.y,n.y),p=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,d,h,f,p,l,r,n,s),t.length-1}function Ou(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function $u(t,e,r,i){const n=t.compareText;if(e in n){const t=n[e];for(let e=t.length-1;e>=0;e--)if(i.dist(t[e])<r)return !0}else n[e]=[];return n[e].push(i),!1}const qu=Go.VectorTileFeature.types,Nu=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function ju(t,e,r,i,n,s,a,o,l,u,c,h,p){const d=o?Math.min(32640,Math.round(o[0])):0,f=o?Math.min(32640,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*i),Math.round(32*n),s,a,(d<<1)+(l?1:0),f,16*u,16*c,256*h,256*p);}function Ku(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function Zu(t){for(const e of t.sections)if(sn(e.text))return !0;return !1}class Xu{constructor(t){this.layoutVertexArray=new $n,this.indexArray=new Gn,this.programConfigurations=t,this.segments=new Os,this.dynamicLayoutVertexArray=new qn,this.opacityVertexArray=new Nn,this.placedSymbolArray=new as;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,i){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,yl.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,ml.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Nu,!0),this.opacityVertexBuffer.itemSize=1),(r||i)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}ji("SymbolBuffers",Xu);class Gu{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new Os,this.collisionVertexArray=new Xn,this.collisionVertexArrayExt=new qn;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,gl.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,xl.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}ji("CollisionBuffers",Gu);class Hu{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=da([]),this.placementViewportMatrix=da([]);const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=wl(this.zoom,e["text-size"]),this.iconSizeData=wl(this.zoom,e["icon-size"]);const r=this.layers[0].layout,i=r.get("symbol-sort-key"),n=r.get("symbol-z-order");this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&void 0!==i.constantOr(1),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===r.get("symbol-placement")&&(this.writingModes=r.get("text-writing-mode").map(t=>Ql[t])),this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id),this.sourceID=t.sourceID;}createArrays(){this.text=new Xu(new Ps(this.layers,this.zoom,t=>/^text/.test(t))),this.icon=new Xu(new Ps(this.layers,this.zoom,t=>/^icon/.test(t))),this.glyphOffsetArray=new us,this.lineVertexArray=new cs,this.symbolInstances=new ls;}calculateGlyphDependencies(t,e,r,i,n){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||i)&&n){const r=Il[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0);}}populate(t,e,r){const i=this.layers[0],n=i.layout,s=n.get("text-font"),a=n.get("text-field"),o=n.get("icon-image"),l=("constant"!==a.value.kind||a.value.value instanceof ce&&!a.value.value.isEmpty()||a.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),u="constant"!==o.value.kind||!!o.value.value||Object.keys(o.parameters).length>0,c=n.get("symbol-sort-key");if(this.features=[],!l&&!u)return;const h=e.iconDependencies,p=e.glyphDependencies,d=e.availableImages,f=new yn(this.zoom);for(const{feature:e,id:a,index:o,sourceLayerIndex:y}of t){const t=i._featureFilter.needGeometry,m=js(e,t);if(!i._featureFilter.filter(f,m,r))continue;let g,x;if(t||(m.geometry=Ns(e)),l){const t=i.getValueAndResolveTokens("text-field",m,r,d),e=ce.factory(t);Zu(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===pn()||this.hasRTLText&&fn.isParsed())&&(g=Sl(e,i,m));}if(u){const t=i.getValueAndResolveTokens("icon-image",m,r,d);x=t instanceof he?t:he.fromString(t);}if(!g&&!x)continue;const v=this.sortFeaturesByKey?c.evaluate(m,{},r):void 0;if(this.features.push({id:a,text:g,icon:x,index:o,sourceLayerIndex:y,geometry:m.geometry,properties:e.properties,type:qu[e.type],sortKey:v}),x&&(h[x.name]=!0),g){const t=s.evaluate(m,{},r).join(","),e="map"===n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Ql.vertical)>=0;for(const r of g.sections)if(r.image)h[r.image.name]=!0;else {const i=Yi(g.toString()),n=r.fontStack||t,s=p[n]=p[n]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,i);}}}"line"===n.get("symbol-placement")&&(this.features=function(t){const e={},r={},i=[];let n=0;function s(e){i.push(t[e]),n++;}function a(t,e,n){const s=r[t];return delete r[t],r[e]=s,i[s].geometry[0].pop(),i[s].geometry[0]=i[s].geometry[0].concat(n[0]),s}function o(t,r,n){const s=e[r];return delete e[r],e[t]=s,i[s].geometry[0].shift(),i[s].geometry[0]=n[0].concat(i[s].geometry[0]),s}function l(t,e,r){const i=r?e[0][e[0].length-1]:e[0][0];return `${t}:${i.x}:${i.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const d=l(p,h),f=l(p,h,!0);if(d in r&&f in e&&r[d]!==e[f]){const t=o(d,f,h),n=a(d,f,i[t].geometry);delete e[d],delete r[f],r[l(p,i[n].geometry,!0)]=n,i[t].geometry=null;}else d in r?a(d,f,h):f in e?o(d,f,h):(s(u),e[d]=n-1,r[f]=n-1);}return i.filter(t=>t.geometry)}(this.features)),this.sortFeaturesByKey&&this.features.sort((t,e)=>t.sortKey-e.sortKey);}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),i=t.dist(e[t.segment]);const n={};for(let i=t.segment+1;i<e.length;i++)n[i]={x:e[i].x,y:e[i].y,tileUnitDistanceFromAnchor:r},i<e.length-1&&(r+=e[i+1].dist(e[i]));for(let r=t.segment||0;r>=0;r--)n[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:i},r>0&&(i+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=n[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,i,n,s,a,o,l,u,c,h){const p=t.indexArray,d=t.layoutVertexArray,f=t.segments.prepareSegment(4*e.length,d,p,this.canOverlap?s.sortKey:void 0),y=this.glyphOffsetArray.length,m=f.vertexLength,g=this.allowVerticalPlacement&&a===Ql.vertical?Math.PI/2:0,x=s.text&&s.text.sections;for(let i=0;i<e.length;i++){const{tl:n,tr:a,bl:l,br:u,tex:c,pixelOffsetTL:y,pixelOffsetBR:m,minFontScaleX:v,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:A}=e[i],k=f.vertexLength,S=w[1];ju(d,o.x,o.y,n.x,S+n.y,c.x,c.y,r,_,y.x,y.y,v,b),ju(d,o.x,o.y,a.x,S+a.y,c.x+c.w,c.y,r,_,m.x,y.y,v,b),ju(d,o.x,o.y,l.x,S+l.y,c.x,c.y+c.h,r,_,y.x,m.y,v,b),ju(d,o.x,o.y,u.x,S+u.y,c.x+c.w,c.y+c.h,r,_,m.x,m.y,v,b),Ku(t.dynamicLayoutVertexArray,o,g),p.emplaceBack(k,k+1,k+2),p.emplaceBack(k+1,k+2,k+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),i!==e.length-1&&A===e[i+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,s,s.index,{},h,x&&x[A]);}t.placedSymbolArray.emplaceBack(o.x,o.y,y,this.glyphOffsetArray.length-y,m,l,u,o.segment,r?r[0]:0,r?r[1]:0,i[0],i[1],a,0,!1,0,c);}_commitLayoutVertex(t,e,r,i,n){t.emplaceBack(e.x,e.y,r,i,Math.round(n.x),Math.round(n.y));}_addCollisionDebugVertices(t,e,r,n,s){const a=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),o=a.vertexLength,l=s.anchorX,u=s.anchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0);r.collisionVertexArrayExt.emplaceBack(e,-t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,t.padding),r.collisionVertexArrayExt.emplaceBack(e,-t.padding,t.padding),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x1,t.y2)),a.vertexLength+=4;const c=r.indexArray;c.emplaceBack(o,o+1),c.emplaceBack(o+1,o+2),c.emplaceBack(o+2,o+3),c.emplaceBack(o+3,o),a.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,i,n,s){for(let a=i;a<n;a++){const i=r.get(a),n=this.getSymbolInstanceTextSize(t,s,e,a);this._addCollisionDebugVertices(i,n,this.textCollisionBox,i.anchorPoint,s);}}_addIconDebugCollisionBoxes(t,e,r,i,n,s){for(let a=i;a<n;a++){const i=r.get(a),n=this.getSymbolInstanceIconSize(t,e,a);this._addCollisionDebugVertices(i,n,this.iconCollisionBox,i.anchorPoint,s);}}generateCollisionDebugBuffers(t,e){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Gu(Kn,vl.members,ts),this.iconCollisionBox=new Gu(Kn,vl.members,ts);const r=Al(this.iconSizeData,t),i=Al(this.textSizeData,t);for(let n=0;n<this.symbolInstances.length;n++){const s=this.symbolInstances.get(n);this._addTextDebugCollisionBoxes(i,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(i,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,i){const n=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:i),s=_l(this.textSizeData,t,n)/24;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const i=this.icon.placedSymbolArray.get(r),n=_l(this.iconSizeData,t,i);return this.tilePixelRatio*n}_commitDebugCollisionVertexUpdate(t,e,r){t.emplaceBack(e,-r,-r),t.emplaceBack(e,r,-r),t.emplaceBack(e,r,r),t.emplaceBack(e,-r,r);}_updateTextDebugCollisionBoxes(t,e,r,i,n,s){for(let a=i;a<n;a++){const i=r.get(a),n=this.getSymbolInstanceTextSize(t,s,e,a);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,n,i.padding);}}_updateIconDebugCollisionBoxes(t,e,r,i,n){for(let s=i;s<n;s++){const i=r.get(s),n=this.getSymbolInstanceIconSize(t,e,s);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,n,i.padding);}}updateCollisionDebugBuffers(t,e){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const r=Al(this.iconSizeData,t),i=Al(this.textSizeData,t);for(let n=0;n<this.symbolInstances.length;n++){const s=this.symbolInstances.get(n);this._updateTextDebugCollisionBoxes(i,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._updateTextDebugCollisionBoxes(i,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._updateIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex),this._updateIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,i,n,s,a,o,l){const u={};for(let i=e;i<r;i++){const e=t.get(i);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,padding:e.padding,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=i;e<n;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),i=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<i;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),i=[],n=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);i.push(0|Math.round(e*a.anchorX+r*a.anchorY)),n.push(a.featureIndex);}return s.sort((t,e)=>i[t]-i[e]||n[e]-n[t]),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);}),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}ji("SymbolBucket",Hu,{omit:["layers","collisionBoxArray","features","compareText"]}),Hu.MAX_GLYPHS=65535,Hu.addDynamicAttributes=Ku;const Ju=new En({"symbol-placement":new kn(Vt.layout_symbol["symbol-placement"]),"symbol-spacing":new kn(Vt.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new kn(Vt.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Sn(Vt.layout_symbol["symbol-sort-key"]),"symbol-z-order":new kn(Vt.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new kn(Vt.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new kn(Vt.layout_symbol["icon-ignore-placement"]),"icon-optional":new kn(Vt.layout_symbol["icon-optional"]),"icon-rotation-alignment":new kn(Vt.layout_symbol["icon-rotation-alignment"]),"icon-size":new Sn(Vt.layout_symbol["icon-size"]),"icon-text-fit":new kn(Vt.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new kn(Vt.layout_symbol["icon-text-fit-padding"]),"icon-image":new Sn(Vt.layout_symbol["icon-image"]),"icon-rotate":new Sn(Vt.layout_symbol["icon-rotate"]),"icon-padding":new kn(Vt.layout_symbol["icon-padding"]),"icon-keep-upright":new kn(Vt.layout_symbol["icon-keep-upright"]),"icon-offset":new Sn(Vt.layout_symbol["icon-offset"]),"icon-anchor":new Sn(Vt.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new kn(Vt.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new kn(Vt.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new kn(Vt.layout_symbol["text-rotation-alignment"]),"text-field":new Sn(Vt.layout_symbol["text-field"]),"text-font":new Sn(Vt.layout_symbol["text-font"]),"text-size":new Sn(Vt.layout_symbol["text-size"]),"text-max-width":new Sn(Vt.layout_symbol["text-max-width"]),"text-line-height":new kn(Vt.layout_symbol["text-line-height"]),"text-letter-spacing":new Sn(Vt.layout_symbol["text-letter-spacing"]),"text-justify":new Sn(Vt.layout_symbol["text-justify"]),"text-radial-offset":new Sn(Vt.layout_symbol["text-radial-offset"]),"text-variable-anchor":new kn(Vt.layout_symbol["text-variable-anchor"]),"text-anchor":new Sn(Vt.layout_symbol["text-anchor"]),"text-max-angle":new kn(Vt.layout_symbol["text-max-angle"]),"text-writing-mode":new kn(Vt.layout_symbol["text-writing-mode"]),"text-rotate":new Sn(Vt.layout_symbol["text-rotate"]),"text-padding":new kn(Vt.layout_symbol["text-padding"]),"text-keep-upright":new kn(Vt.layout_symbol["text-keep-upright"]),"text-transform":new Sn(Vt.layout_symbol["text-transform"]),"text-offset":new Sn(Vt.layout_symbol["text-offset"]),"text-allow-overlap":new kn(Vt.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new kn(Vt.layout_symbol["text-ignore-placement"]),"text-optional":new kn(Vt.layout_symbol["text-optional"])});var Yu={paint:new En({"icon-opacity":new Sn(Vt.paint_symbol["icon-opacity"]),"icon-color":new Sn(Vt.paint_symbol["icon-color"]),"icon-halo-color":new Sn(Vt.paint_symbol["icon-halo-color"]),"icon-halo-width":new Sn(Vt.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Sn(Vt.paint_symbol["icon-halo-blur"]),"icon-translate":new kn(Vt.paint_symbol["icon-translate"]),"icon-translate-anchor":new kn(Vt.paint_symbol["icon-translate-anchor"]),"text-opacity":new Sn(Vt.paint_symbol["text-opacity"]),"text-color":new Sn(Vt.paint_symbol["text-color"],{runtimeType:Xt,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Sn(Vt.paint_symbol["text-halo-color"]),"text-halo-width":new Sn(Vt.paint_symbol["text-halo-width"]),"text-halo-blur":new Sn(Vt.paint_symbol["text-halo-blur"]),"text-translate":new kn(Vt.paint_symbol["text-translate"]),"text-translate-anchor":new kn(Vt.paint_symbol["text-translate-anchor"])}),layout:Ju};class Wu{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:Nt,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}ji("FormatSectionOverride",Wu,{omit:["defaultValue"]});class Qu extends Rs{constructor(t){super(t,Yu);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,i){const n=this.layout.get(t).evaluate(e,{},r,i),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Yr(s.value)||!n?n:function(t,e){return e.replace(/{([^{}]+)}/g,(e,r)=>r in t?String(t[r]):"")}(e.properties,n)}createBucket(t){return new Hu(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of Yu.paint.overridableProperties){if(!Qu.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Wu(e),i=new Jr(r,e.property.specification);let n=null;n="constant"===e.value.kind||"source"===e.value.kind?new Qr("source",i):new ti("composite",i,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new _n(e.property,n,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&Qu.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),i=Yu.paint.properties[e];let n=!1;const s=t=>{for(const e of t)if(i.overrides&&i.overrides.hasOverride(e))return void(n=!0)};if("constant"===r.value.kind&&r.value.value instanceof ce)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{n||(e instanceof me&&fe(e.value)===Yt?s(e.value.sections):e instanceof be?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return n}getProgramConfiguration(t){return new Ds(this,t)}}var tc={paint:new En({"background-color":new kn(Vt.paint_background["background-color"]),"background-pattern":new Tn(Vt.paint_background["background-pattern"]),"background-opacity":new kn(Vt.paint_background["background-opacity"])})},ec={paint:new En({"raster-opacity":new kn(Vt.paint_raster["raster-opacity"]),"raster-hue-rotate":new kn(Vt.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new kn(Vt.paint_raster["raster-brightness-min"]),"raster-brightness-max":new kn(Vt.paint_raster["raster-brightness-max"]),"raster-saturation":new kn(Vt.paint_raster["raster-saturation"]),"raster-contrast":new kn(Vt.paint_raster["raster-contrast"]),"raster-resampling":new kn(Vt.paint_raster["raster-resampling"]),"raster-fade-duration":new kn(Vt.paint_raster["raster-fade-duration"])})};class rc extends Rs{constructor(t){super(t,{}),this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}var ic={paint:new En({"sky-type":new kn(Vt.paint_sky["sky-type"]),"sky-atmosphere-sun":new kn(Vt.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new kn(Vt.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new kn(Vt.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new kn(Vt.paint_sky["sky-gradient-radius"]),"sky-gradient":new zn(Vt.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new kn(Vt.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new kn(Vt.paint_sky["sky-atmosphere-color"]),"sky-opacity":new kn(Vt.paint_sky["sky-opacity"])})};function nc(t,e,r){const i=va(0,0,1),n=Da(Ba());return function(t,e,r){r*=.5;var i=e[0],n=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);t[0]=i*l-s*o,t[1]=n*l+a*o,t[2]=s*l+i*o,t[3]=a*l-n*o;}(n,n,r?-c(t)+Math.PI:c(t)),Pa(n,n,-c(e)),Ta(i,i,n),ka(i,i)}const sc={circle:class extends Rs{constructor(t){super(t,ca);}createBucket(t){return new Zs(t)}queryRadius(t){const e=t;return sa("circle-radius",this,e)+sa("circle-stroke-width",this,e)+aa(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,i,n,s,a,o){const l="map"===this.paint.get("circle-pitch-alignment");if(l&&t.queryGeometry.isAboveHorizon)return !1;const u=la(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),c=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),h=l?c*t.pixelToTileUnitsFactor:c;for(const e of i)for(const r of e){const e=r.add(u),i=o&&s.elevation?s.elevation.exaggeration()*o.getElevationAt(e.x,e.y,!0):0,n=l?e:Ra(e,i,a),c=l?t.tilespaceRays.map(t=>Oa(t,i)):t.queryGeometry.screenGeometry;let p=h;const d=Ma([],[r.x,r.y,i,1],a);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?p*=d[3]/s.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(p*=s.cameraToCenterDistance/d[3]),Gs(c,n,p))return !0}return !1}getProgramIds(){return ["circle"]}getProgramConfiguration(t){return new Ds(this,t)}},heatmap:class extends Rs{createBucket(t){return new $a(t)}constructor(t){super(t,Xa),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Ga({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(){return 0}queryIntersectsFeature(){return !1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getProgramConfiguration(t){return new Ds(this,t)}},hillshade:class extends Rs{constructor(t){super(t,Ha);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getProgramConfiguration(t){return new Ds(this,t)}},fill:class extends Rs{constructor(t){super(t,Fo);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getProgramConfiguration(t){return new Ds(this,t)}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new Po(t)}queryRadius(){return aa(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,i,n,s){return !t.queryGeometry.isAboveHorizon&&Hs(oa(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),i)}isTileClipped(){return !0}},"fill-extrusion":class extends Rs{constructor(t){super(t,el);}createBucket(t){return new Qo(t)}queryRadius(){return aa(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}getProgramConfiguration(t){return new Ds(this,t)}queryIntersectsFeature(t,e,r,n,s,a,o){const l=la(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),u=this.paint.get("fill-extrusion-height").evaluate(e,r),c=this.paint.get("fill-extrusion-base").evaluate(e,r),h=t.queryGeometry.screenGeometry,p=function(t,e,r,n,s){const a=[],o=[],l=s[8]*e,u=s[9]*e,c=s[10]*e,h=s[11]*e,p=s[8]*r,d=s[9]*r,f=s[10]*r,y=s[11]*r;for(const e of t){const t=[],r=[];for(const a of e){const e=a.x+n.x,o=a.y+n.y,m=s[0]*e+s[4]*o+s[12],g=s[1]*e+s[5]*o+s[13],x=s[2]*e+s[6]*o+s[14],v=s[3]*e+s[7]*o+s[15],b=x+c,w=v+h,_=m+p,A=g+d,k=x+f,S=v+y,I=new i((m+l)/w,(g+u)/w);I.z=b/w,t.push(I);const T=new i(_/S,A/S);T.z=k/S,r.push(T);}a.push(t),o.push(r);}return [a,o]}(n,c,u,l,o);return function(t,e,r){let i=1/0;Hs(r,e)&&(i=il(r,e[0]));for(let n=0;n<e.length;n++){const s=e[n],a=t[n];for(let t=0;t<s.length-1;t++){const e=s[t],n=[e,s[t+1],a[t+1],a[t],e];Xs(r,n)&&(i=Math.min(i,il(r,n)));}}return i!==1/0&&i}(p[0],p[1],h)}},line:class extends Rs{constructor(t){super(t,pl),this.gradientVersion=0;}_handleSpecialPaintPropertyUpdate(t){"line-gradient"===t&&(this.stepInterpolant=this._transitionablePaint._values["line-gradient"].value.expression._styleExpression.expression instanceof Je,this.gradientVersion=(this.gradientVersion+1)%o);}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=dl.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new cl(t)}getProgramIds(){const t=this.paint.get("line-dasharray"),e=this.paint.get("line-pattern").constantOr(1),r=this.paint.get("line-gradient");return [e?"linePattern":t?"lineSDF":r?"lineGradient":"line"]}getProgramConfiguration(t){return new Ds(this,t)}queryRadius(t){const e=t,r=fl(sa("line-width",this,e),sa("line-gap-width",this,e)),i=sa("line-offset",this,e);return r/2+Math.abs(i)+aa(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,s,a){if(t.queryGeometry.isAboveHorizon)return !1;const o=oa(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),l=t.pixelToTileUnitsFactor/2*fl(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),u=this.paint.get("line-offset").evaluate(e,r);return u&&(n=function(t,e){const r=[],n=new i(0,0);for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const r=s[t-1],i=s[t],o=s[t+1],l=0===t?n:i.sub(r)._unit()._perp(),u=t===s.length-1?n:o.sub(i)._unit()._perp(),c=l._add(u)._unit();c._mult(1/(c.x*u.x+c.y*u.y)),a.push(c._mult(e)._add(i));}r.push(a);}return r}(n,u*t.pixelToTileUnitsFactor)),function(t,e,r){for(let i=0;i<e.length;i++){const n=e[i];if(t.length>=3)for(let e=0;e<n.length;e++)if(ra(t,n[e]))return !0;if(Js(t,n,r))return !0}return !1}(o,n,l)}isTileClipped(){return !0}},symbol:Qu,background:class extends Rs{constructor(t){super(t,tc);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}},raster:class extends Rs{constructor(t){super(t,ec);}getProgramIds(){return ["raster"]}},sky:class extends Rs{constructor(t){super(t,ic),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=Ga({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}}getCenter(t,e){const r=this.paint.get("sky-type");if("atmosphere"===r){const r=this.paint.get("sky-atmosphere-sun"),i=!r,n=t.style.light,s=n.properties.get("position");return i&&"viewport"===n.properties.get("anchor")&&z("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),i?nc(s.azimuthal,90-s.polar,e):nc(r[0],90-r[1],e)}if("gradient"===r){const t=this.paint.get("sky-gradient-center");return nc(t[0],90-t[1],e)}}is3D(){return !1}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}}},{HTMLImageElement:ac,HTMLCanvasElement:oc,HTMLVideoElement:lc,ImageData:uc,ImageBitmap:cc}=s;class hc{constructor(t,e,r,i){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,i);}update(t,e,r){const{width:i,height:n}=t,s=!(this.size&&this.size[0]===i&&this.size[1]===n||r),{context:a}=this,{gl:o}=a;if(this.useMipmap=Boolean(e&&e.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[i,n],t instanceof ac||t instanceof oc||t instanceof lc||t instanceof uc||cc&&t instanceof cc?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,i,n,0,this.format,o.UNSIGNED_BYTE,t.data);else {const{x:e,y:s}=r||{x:0,y:0};t instanceof ac||t instanceof oc||t instanceof lc||t instanceof uc||cc&&t instanceof cc?o.texSubImage2D(o.TEXTURE_2D,0,e,s,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,s,i,n,o.RGBA,o.UNSIGNED_BYTE,t.data);}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D);}bind(t,e,r){const{context:i}=this,{gl:n}=i;n.bindTexture(n.TEXTURE_2D,this.texture),r!==n.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=n.LINEAR),t!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,r||t),this.filter=t),e!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class pc{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout(()=>{this._triggered=!1,this._callback();},0));}remove(){delete this._channel,this._callback=()=>{};}}const dc=s.performance;class fc{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},dc.mark(this._marks.start);}finish(){dc.mark(this._marks.end);let t=dc.getEntriesByName(this._marks.measure);return 0===t.length&&(dc.measure(this._marks.measure,this._marks.start,this._marks.end),t=dc.getEntriesByName(this._marks.measure),dc.clearMarks(this._marks.start),dc.clearMarks(this._marks.end),dc.clearMeasures(this._marks.measure)),t}}class yc{constructor(){this.tasks={},this.taskQueue=[],_(["process"],this),this.invoker=new pc(this.process),this.nextId=0;}add(t,e){const r=this.nextId++;return this.tasks[r]={fn:t,metadata:e,priority:mc(e),id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){M();try{if(this.taskQueue=this.taskQueue.filter(t=>!!this.tasks[t]),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const i=this.tasks[this.taskQueue[r]];i.priority<e&&(e=i.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}function mc({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}class gc{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1]));}setNorthEast(t){return this._ne=t instanceof xc?new xc(t.lng,t.lat):xc.convert(t),this}setSouthWest(t){return this._sw=t instanceof xc?new xc(t.lng,t.lat):xc.convert(t),this}extend(t){const e=this._sw,r=this._ne;let i,n;if(t instanceof xc)i=t,n=t;else {if(!(t instanceof gc))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(gc.convert(t)):this.extend(xc.convert(t)):this;if(i=t._sw,n=t._ne,!i||!n)return this}return e||r?(e.lng=Math.min(i.lng,e.lng),e.lat=Math.min(i.lat,e.lat),r.lng=Math.max(n.lng,r.lng),r.lat=Math.max(n.lat,r.lat)):(this._sw=new xc(i.lng,i.lat),this._ne=new xc(n.lng,n.lat)),this}getCenter(){return new xc((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new xc(this.getWest(),this.getNorth())}getSouthEast(){return new xc(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=xc.convert(t);let i=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(i=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&i}static convert(t){return !t||t instanceof gc?t:new gc(t)}}class xc{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new xc(y(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,i=t.lat*e,n=Math.sin(r)*Math.sin(i)+Math.cos(r)*Math.cos(i)*Math.cos((t.lng-this.lng)*e);return 6371008.8*Math.acos(Math.min(n,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new gc(new xc(this.lng-r,this.lat-e),new xc(this.lng+r,this.lat+e))}static convert(t){if(t instanceof xc)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new xc(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new xc(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const vc=2*Math.PI*6371008.8;function bc(t){return vc*Math.cos(t*Math.PI/180)}function wc(t){return (180+t)/360}function _c(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Ac(t,e){return t/bc(e)}function kc(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Sc(t,e){return t*bc(kc(e))}class Ic{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=xc.convert(t);return new Ic(wc(r.lng),_c(r.lat),Ac(e,r.lat))}toLngLat(){return new xc(360*this.x-180,kc(this.y))}toAltitude(){return Sc(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/vc*(t=kc(this.y),1/Math.cos(t*Math.PI/180));var t;}}function Tc(t,e,r){var i=2*Math.PI*6378137/256/Math.pow(2,r);return [t*i-2*Math.PI*6378137/2,e*i-2*Math.PI*6378137/2]}class zc{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=Mc(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=(n=this.y,s=this.z,a=Tc(256*(i=this.x),256*(n=Math.pow(2,s)-n-1),s),o=Tc(256*(i+1),256*(n+1),s),a[0]+","+a[1]+","+o[0]+","+o[1]);var i,n,s,a,o;const l=function(t,e,r){let i,n="";for(let s=t;s>0;s--)i=1<<s-1,n+=(e&i?1:0)+(r&i?2:0);return n}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace("{z}",String(this.z)).replace("{x}",String(this.x)).replace("{y}",String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",l).replace("{bbox-epsg-3857}",r)}getTilePoint(t){const e=Math.pow(2,this.z);return new i(8192*(t.x*e-this.x),8192*(t.y*e-this.y))}getTileVec3(t){const e=Math.pow(2,this.z);return va(8192*(t.x*e-this.x),8192*(t.y*e-this.y),Sc(t.z,t.y))}toString(){return `${this.z}/${this.x}/${this.y}`}}class Ec{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Mc(t,e.z,e.z,e.x,e.y);}}class Cc{constructor(t,e,r,i,n){this.overscaledZ=t,this.wrap=e,this.canonical=new zc(r,+i,+n),this.key=0===e&&t===r?this.canonical.key:Mc(e,t,r,i,n);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new Cc(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Cc(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return Mc(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return Mc(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new Cc(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,i=2*this.canonical.y;return [new Cc(e,this.wrap,e,r,i),new Cc(e,this.wrap,e,r+1,i),new Cc(e,this.wrap,e,r,i+1),new Cc(e,this.wrap,e,r+1,i+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new Cc(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new Cc(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Ec(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new Ic(t.x-this.wrap,t.y))}getTileVec3(t){return this.canonical.getTileVec3(new Ic(t.x-this.wrap,t.y,t.z))}}function Mc(t,e,r,i,n){const s=1<<Math.min(r,22);let a=s*(n%s)+i%s;return t&&r<22&&(a+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*a+r)+(e-r)}ji("CanonicalTileID",zc),ji("OverscaledTileID",Cc,{omit:["posMatrix"]});class Bc{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}class Dc{constructor(t,e,r,i,n){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=i,this.properties=t.properties,this.id=n;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}var Pc=Pn([{name:"a_pos",type:"Int16",components:2}]);class Vc{constructor(t,e,r){this.tileID=t,this.uid=v(),this.uses=0,this.tileSize=e,this.tileZoom=r,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.expiredRequestCount=0,this.state="loading";}registerFadeDuration(t){const e=t+this.timeAdded;e<O.now()||this.fadeEndTime&&e<this.fadeEndTime||(this.fadeEndTime=e);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}loadVectorData(t,e,r){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const r={};if(!e)return r;for(const i of t){const t=i.layerIds.map(t=>e.getLayer(t)).filter(Boolean);if(0!==t.length){i.layers=t,i.stateDependentLayerIds&&(i.stateDependentLayers=i.stateDependentLayerIds.map(e=>t.filter(t=>t.id===e)[0]));for(const e of t)r[e.id]=i;}}return r}(t.buckets,e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Hu){if(this.hasSymbolBuckets=!0,!r)break;e.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Hu&&e.hasRTLText){this.hasRTLText=!0,fn.isLoading()||fn.isLoaded()||"deferred"!==pn()||dn();break}}this.queryPadding=0;for(const t in this.buckets){const r=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(r));}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage);}else this.collisionBoxArray=new ns;}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const r=this.buckets[e];r.uploadPending()&&r.upload(t);}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new hc(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new hc(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null);}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture);}queryRenderedFeatures(t,e,r,i,n,s,a,o){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({tileResult:i,pixelPosMatrix:a,transform:s,params:n},t,e,r):{}}querySourceFeatures(t,e){const r=this.latestFeatureIndex;if(!r||!r.rawTileData)return;const i=r.loadVTLayers(),n=e?e.sourceLayer:"",s=i._geojsonTileLayer||i[n];if(!s)return;const a=hi(e&&e.filter),{z:o,x:l,y:u}=this.tileID.canonical,c={z:o,x:l,y:u};for(let e=0;e<s.length;e++){const i=s.feature(e);if(a.needGeometry){const t=js(i,!0);if(!a.filter(new yn(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new yn(this.tileID.overscaledZ),i))continue;const h=r.getId(i,n),p=new Dc(i,o,l,u,h);p.tile=c,t.push(p);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=B(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let r=!1;if(this.expirationTime>t)r=!1;else if(e)if(this.expirationTime<e)r=!0;else {const i=this.expirationTime-e;i?this.expirationTime=t+Math.max(i,3e4):r=!0;}else r=!0;r?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const r=this.latestFeatureIndex.loadVTLayers();for(const i in this.buckets){if(!e.style.hasLayer(i))continue;const n=this.buckets[i],s=n.layers[0].sourceLayer||"_geojsonTileLayer",a=r[s],o=t[s];if(!a||!o||0===Object.keys(o).length)continue;n.update(o,a,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(i);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(n)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<O.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=O.now()+t;}setDependencies(t,e){const r={};for(const t of e)r[t]=!0;this.dependencies[t]=r;}hasDependency(t,e){for(const r of t){const t=this.dependencies[r];if(t)for(const r of e)if(t[r])return !0}return !1}clearQueryDebugViz(){}}class Fc{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,e,r){const i=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][i]=this.stateChanges[t][i]||{},g(this.stateChanges[t][i],r),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==i&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][i]){this.deletedStates[t][i]={};for(const e in this.state[t][i])r[e]||(this.deletedStates[t][i][e]=null);}else for(const e in r)this.deletedStates[t]&&this.deletedStates[t][i]&&null===this.deletedStates[t][i][e]&&delete this.deletedStates[t][i][e];}removeFeatureState(t,e,r){if(null===this.deletedStates[t])return;const i=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},r&&void 0!==e)null!==this.deletedStates[t][i]&&(this.deletedStates[t][i]=this.deletedStates[t][i]||{},this.deletedStates[t][i][r]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][i])for(r in this.deletedStates[t][i]={},this.stateChanges[t][i])this.deletedStates[t][i][r]=null;else this.deletedStates[t][i]=null;else this.deletedStates[t]=null;}getState(t,e){const r=String(e),i=g({},(this.state[t]||{})[r],(this.stateChanges[t]||{})[r]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const r=this.deletedStates[t][e];if(null===r)return {};for(const t in r)delete i[t];}return i}initializeTileState(t,e){t.setFeatureState(this.state,e);}coalesceChanges(t,e){const r={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const r in this.stateChanges[t])this.state[t][r]||(this.state[t][r]={}),g(this.state[t][r],this.stateChanges[t][r]),e[r]=this.state[t][r];r[t]=e;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const r in this.state[t])e[r]={},this.state[t][r]={};else for(const r in this.deletedStates[t]){if(null===this.deletedStates[t][r])this.state[t][r]={};else for(const e of Object.keys(this.deletedStates[t][r]))delete this.state[t][r][e];e[r]=this.state[t][r];}r[t]=r[t]||{},g(r[t],e);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(r).length)for(const i in t)t[i].setFeatureState(r,e);}}class Rc{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function Lc(t,e,r,i){let n=0,s=Number.MAX_VALUE;for(let a=0;a<3;a++)if(Math.abs(i[a])<1e-15){if(r[a]<t[a]||r[a]>e[a])return null}else {const o=1/i[a];let l=(t[a]-r[a])*o,u=(e[a]-r[a])*o;if(l>u){const t=l;l=u,u=t;}if(l>n&&(n=l),u<s&&(s=u),n>s)return null}return n}function Uc(t,e,r,i,n,s,a,o,l,u,c){const h=i-t,p=n-e,d=s-r,f=a-t,y=o-e,m=l-r,g=c[1]*m-c[2]*y,x=c[2]*f-c[0]*m,v=c[0]*y-c[1]*f,b=h*g+p*x+d*v;if(Math.abs(b)<1e-15)return null;const w=1/b,_=u[0]-t,A=u[1]-e,k=u[2]-r,S=(_*g+A*x+k*v)*w;if(S<0||S>1)return null;const I=A*d-k*p,T=k*h-_*d,z=_*p-A*h,E=(c[0]*I+c[1]*T+c[2]*z)*w;return E<0||S+E>1?null:(f*I+y*T+m*z)*w}function Oc(t,e,r){return (t-e)/(r-e)}function $c(t,e,r,i,n,s,a,o,l){const u=1<<r,c=s-i,h=a-n,p=(t+1)/u*c+i,d=(e+0)/u*h+n,f=(e+1)/u*h+n;o[0]=(t+0)/u*c+i,o[1]=d,l[0]=p,l[1]=f;}class qc{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let i=Math.ceil(Math.pow(2,e));const n=1/i,s=(t,e,r,i,n)=>{const s=i?1:0,a=(t+1)*r-s,o=e*r,l=(e+1)*r-s;n[0]=t*r,n[1]=o,n[2]=a,n[3]=l;};let a=new Rc(i);const o=[];for(let e=0;e<i*i;e++){s(e%i,Math.floor(e/i),n,!1,o);const r=jc(o[0],o[1],t),l=jc(o[2],o[1],t),u=jc(o[2],o[3],t),c=jc(o[0],o[3],t);a.minimums.push(Math.min(r,l,u,c)),a.maximums.push(Math.max(r,l,u,c)),a.leaves.push(1);}for(r.push(a),i/=2;i>=1;i/=2){const t=r[r.length-1];a=new Rc(i);for(let e=0;e<i*i;e++){s(e%i,Math.floor(e/i),2,!0,o);const r=t.getElevation(o[0],o[1]),n=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),d=t.isLeaf(o[0],o[3]),f=Math.min(r.min,n.min,l.min,u.min),y=Math.max(r.max,n.max,l.max,u.max),m=c&&h&&p&&d;a.maximums.push(y),a.minimums.push(f),a.leaves.push(y-f<=5&&m?1:0);}r.push(a);}return r}(this.dem),r=e.length-1,i=e[r];this._addNode(i.minimums[0],i.maximums[0],i.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,i,n,s,a=1){return Lc([t,e,-100],[r,i,this.maximums[0]*a],n,s)}raycast(t,e,r,i,n,s,a=1){if(!this.nodeCount)return null;const o=this.raycastRoot(t,e,r,i,n,s,a);if(null==o)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:o,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:o,t:d,nodex:f,nodey:y,depth:m}=p.pop();if(this.leaves[o]){$c(f,y,m,t,e,r,i,c,h);const o=1<<m,l=(f+0)/o,u=(f+1)/o,p=(y+0)/o,g=(y+1)/o,x=jc(l,p,this.dem)*a,v=jc(u,p,this.dem)*a,b=jc(u,g,this.dem)*a,w=jc(l,g,this.dem)*a,_=Uc(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,n,s),A=Uc(h[0],h[1],b,c[0],h[1],w,c[0],c[1],x,n,s),k=Math.min(null!==_?_:Number.MAX_VALUE,null!==A?A:Number.MAX_VALUE);if(k!==Number.MAX_VALUE)return k;{const t=Aa([],n,s,d);if(Nc(x,v,w,b,Oc(t[0],c[0],h[0]),Oc(t[1],c[1],h[1]))>=t[2])return d}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){$c((f<<1)+this._siblingOffset[p][0],(y<<1)+this._siblingOffset[p][1],m+1,t,e,r,i,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[o]+p]*a;const d=Lc(c,h,n,s);if(null!=d){const t=d;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[o]+e,t:l[e],nodex:(f<<1)+this._siblingOffset[e][0],nodey:(y<<1)+this._siblingOffset[e][1],depth:m+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,i,n){if(1===t[i].isLeaf(e,r))return;this.childOffsets[n]||(this.childOffsets[n]=this.nodeCount);const s=i-1,a=t[s];let o,l=0;for(let t=0;t<this._siblingOffset.length;t++){const i=2*e+this._siblingOffset[t][0],n=2*r+this._siblingOffset[t][1],s=a.getElevation(i,n),u=a.isLeaf(i,n),c=this._addNode(s.min,s.max,u);u&&(l|=1<<t),o||(o=c);}for(let i=0;i<this._siblingOffset.length;i++)l&1<<i||this._construct(t,2*e+this._siblingOffset[i][0],2*r+this._siblingOffset[i][1],s,o+i);}}function Nc(t,e,r,i,n,s){return Ye(Ye(t,r,s),Ye(e,i,s),n)}function jc(t,e,r){const i=r.dim,n=f(t*i-.5,0,i-1),s=f(e*i-.5,0,i-1),a=Math.floor(n),o=Math.floor(s),l=Math.min(a+1,i-1),u=Math.min(o+1,i-1);return Nc(r.get(a,o),r.get(l,o),r.get(a,u),r.get(l,u),n-a,s-o)}const Kc={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};class Zc{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,i=!1,n=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return z(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const s=this.dim=e.height-2;if(this.data=new Uint32Array(e.data.buffer),this.encoding=r||"mapbox",this.borderReady=i,!i){for(let t=0;t<s;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(s,t)]=this.data[this._idx(s-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,s)]=this.data[this._idx(t,s-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(s,-1)]=this.data[this._idx(s-1,0)],this.data[this._idx(-1,s)]=this.data[this._idx(0,s-1)],this.data[this._idx(s,s)]=this.data[this._idx(s-1,s-1)],n&&this._buildQuadTree();}}_buildQuadTree(){this._tree=new qc(this);}get(t,e){const r=new Uint8Array(this.data.buffer),i=4*this._idx(t,e);return ("terrarium"===this.encoding?this._unpackTerrarium:this._unpackMapbox)(r[i],r[i+1],r[i+2])}static getUnpackVector(t){return Kc[t]}get unpackVector(){return Kc[this.encoding]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}_unpackMapbox(t,e,r){return (256*t*256+256*e+r)/10-1e4}_unpackTerrarium(t,e,r){return 256*t+e+r/256-32768}static pack(t,e){const r=[0,0,0,0],i=Zc.getUnpackVector(e);let n=Math.floor((t+i[3])/i[2]);return r[2]=n%256,n=Math.floor(n/256),r[1]=n%256,n=Math.floor(n/256),r[0]=n,r}getPixels(){return new Za({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let i=e*this.dim,n=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:i=n-1;break;case 1:n=i+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=i;r<n;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}onDeserialize(){this._tree&&(this._tree.dem=this);}}ji("DEMData",Zc),ji("DemMinMaxQuadTree",qc,{omit:["dem"]});class Xc{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,r){const i=t.wrapped().key;void 0===this.data[i]&&(this.data[i]=[]);const n={value:e,timeout:void 0};if(void 0!==r&&(n.timeout=setTimeout(()=>{this.remove(t,n);},r)),this.data[i].push(n),this.order.push(i),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const r=t.wrapped().key,i=void 0===e?0:this.data[r].indexOf(e),n=this.data[r][i];return this.data[r].splice(i,1),n.timeout&&clearTimeout(n.timeout),0===this.data[r].length&&delete this.data[r],this.onRemove(n.value),this.order.splice(this.order.indexOf(r),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const r in this.data)for(const i of this.data[r])t(i.value)||e.push(i);for(const t of e)this.remove(t.value.tileID,t);}}class Gc{constructor(t,e,r){this.context=t;const i=t.gl;this.buffer=i.createBuffer(),this.dynamicDraw=Boolean(r),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),i.bufferData(i.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?i.DYNAMIC_DRAW:i.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(t){const e=this.context.gl;this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const Hc={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class Jc{constructor(t,e,r,i){this.length=e.length,this.attributes=r,this.itemSize=e.bytesPerElement,this.dynamicDraw=i,this.context=t;const n=t.gl;this.buffer=n.createBuffer(),t.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(t){const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer);}enableAttributes(t,e){for(let r=0;r<this.attributes.length;r++){const i=e.attributes[this.attributes[r].name];void 0!==i&&t.enableVertexAttribArray(i);}}setVertexAttribPointers(t,e,r){for(let i=0;i<this.attributes.length;i++){const n=this.attributes[i],s=e.attributes[n.name];void 0!==s&&t.vertexAttribPointer(s,n.components,t[Hc[n.type]],!1,this.itemSize,n.offset+this.itemSize*(r||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class Yc{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class Wc extends Yc{getDefault(){return oe.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class Qc extends Yc{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1);}}class th extends Yc{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1);}}class eh extends Yc{getDefault(){return [!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class rh extends Yc{getDefault(){return !0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1);}}class ih extends Yc{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1);}}class nh extends Yc{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1);}}class sh extends Yc{getDefault(){const t=this.gl;return [t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1);}}class ah extends Yc{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1;}}class oh extends Yc{getDefault(){return [0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1);}}class lh extends Yc{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1;}}class uh extends Yc{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1);}}class ch extends Yc{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1;}}class hh extends Yc{getDefault(){const t=this.gl;return [t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1);}}class ph extends Yc{getDefault(){return oe.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class dh extends Yc{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1);}}class fh extends Yc{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1;}}class yh extends Yc{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1);}}class mh extends Yc{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1);}}class gh extends Yc{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1);}}class xh extends Yc{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1);}}class vh extends Yc{getDefault(){const t=this.gl;return [0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class bh extends Yc{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1;}}class wh extends Yc{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class _h extends Yc{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1;}}class Ah extends Yc{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class kh extends Yc{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class Sh extends Yc{constructor(t){super(t),this.vao=t.extVertexArrayObject;}getDefault(){return null}set(t){this.vao&&(t!==this.current||this.dirty)&&(this.vao.bindVertexArrayOES(t),this.current=t,this.dirty=!1);}}class Ih extends Yc{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1;}}class Th extends Yc{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1;}}class zh extends Yc{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1;}}class Eh extends Yc{constructor(t,e){super(t),this.context=t,this.parent=e;}getDefault(){return null}}class Ch extends Eh{setDirty(){this.dirty=!0;}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1;}}class Mh extends Eh{attachment(){return this.gl.DEPTH_ATTACHMENT}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,this.attachment(),e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class Bh{constructor(t,e,r,i){this.context=t,this.width=e,this.height=r;const n=this.framebuffer=t.gl.createFramebuffer();this.colorAttachment=new Ch(t,n),i&&(this.depthAttachment=new Mh(t,n));}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e);}t.deleteFramebuffer(this.framebuffer);}}class Dh{constructor(t,e,r){this.func=t,this.mask=e,this.range=r;}}Dh.ReadOnly=!1,Dh.ReadWrite=!0,Dh.disabled=new Dh(519,Dh.ReadOnly,[0,1]);class Ph{constructor(t,e,r,i,n,s){this.test=t,this.ref=e,this.mask=r,this.fail=i,this.depthFail=n,this.pass=s;}}Ph.disabled=new Ph({func:519,mask:0},0,0,7680,7680,7680);class Vh{constructor(t,e,r){this.blendFunction=t,this.blendColor=e,this.mask=r;}}Vh.Replace=[1,0],Vh.disabled=new Vh(Vh.Replace,oe.transparent,[!1,!1,!1,!1]),Vh.unblended=new Vh(Vh.Replace,oe.transparent,[!0,!0,!0,!0]),Vh.alphaBlended=new Vh([1,771],oe.transparent,[!0,!0,!0,!0]);class Fh{constructor(t,e,r){this.enable=t,this.mode=e,this.frontFace=r;}}Fh.disabled=new Fh(!1,1029,2305),Fh.backCCW=new Fh(!0,1029,2305),Fh.backCW=new Fh(!0,1029,2304),Fh.frontCW=new Fh(!0,1028,2304),Fh.frontCCW=new Fh(!0,1028,2305);class Rh extends Pt{constructor(t,e,r){super(),this.id=t,this._onlySymbols=r,e.on("data",t=>{"source"===t.dataType&&"metadata"===t.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===t.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));}),e.on("error",()=>{this._sourceErrored=!0;}),this._source=e,this._tiles={},this._cache=new Xc(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new Fc;}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(t,e){return t.isSymbolTile=this._onlySymbols,this._source.loadTile(t,e)}_unloadTile(t){if(this._source.unloadTile)return this._source.unloadTile(t,()=>{})}_abortTile(t){if(this._source.abortTile)return this._source.abortTile(t,()=>{})}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const r=this._tiles[e];r.upload(t),r.prepare(this.map.style.imageManager);}}getIds(){return m(this._tiles).map(t=>t.tileID).sort(Lh).map(t=>t.key)}getRenderableIds(t){const e=[];for(const r in this._tiles)this._isIdRenderable(+r,t)&&e.push(this._tiles[r]);return t?e.sort((t,e)=>{const r=t.tileID,n=e.tileID,s=new i(r.canonical.x,r.canonical.y)._rotate(this.transform.angle),a=new i(n.canonical.x,n.canonical.y)._rotate(this.transform.angle);return r.overscaledZ-n.overscaledZ||a.y-s.y||a.x-s.x}).map(t=>t.tileID.key):e.map(t=>t.tileID).sort(Lh).map(t=>t.key)}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return !!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(+t,"reloading");}}_reloadTile(t,e){const r=this._tiles[t];r&&("loading"!==r.state&&(r.state=e),this._loadTile(r,this._tileLoaded.bind(this,r,t,e)));}_tileLoaded(t,e,r,i){if(i)return t.state="errored",void(404!==i.status?this._source.fire(new Dt(i,{tile:t})):this.update(this.transform));t.timeAdded=O.now(),"expired"===r&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new Bt("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(t){const e=this.getRenderableIds();for(let i=0;i<e.length;i++){const n=e[i];if(t.neighboringTiles&&t.neighboringTiles[n]){const e=this.getTileByID(n);r(t,e),r(e,t);}}function r(t,e){if(!t.dem||t.dem.borderReady)return;t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0;let r=e.tileID.canonical.x-t.tileID.canonical.x;const i=e.tileID.canonical.y-t.tileID.canonical.y,n=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===r&&0===i||Math.abs(i)>1||(Math.abs(r)>1&&(1===Math.abs(r+n)?r+=n:1===Math.abs(r-n)&&(r-=n)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,r,i),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)));}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,r,i){for(const n in this._tiles){let s=this._tiles[n];if(i[n]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>r)continue;let a=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(a=t);}let o=a;for(;o.overscaledZ>e;)if(o=o.scaledTo(o.overscaledZ-1),t[o.key]){i[a.key]=a;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const r=this._loadedParentTiles[t.key];return r&&r.tileID.overscaledZ>=e?r:null}for(let r=t.overscaledZ-1;r>=e;r--){const e=t.scaledTo(r),i=this._getLoadedTile(e);if(i)return i}}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(this._source.reparseOverscaled?t.wrapped().key:t.canonical.key)}updateCacheSize(t,e){e=e||this._source.tileSize;const r=Math.ceil(t.width/e)+1,i=Math.ceil(t.height/e)+1,n=Math.floor(r*i*5),s="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,n):n;this._cache.setMaxSize(s);}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const r in this._tiles){const i=this._tiles[r];i.tileID=i.tileID.unwrapTo(i.tileID.wrap+e),t[i.tileID.key]=i;}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(+t,this._tiles[t]);}}update(t,e,r){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!r)return;let i;this.updateCacheSize(t,e),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?i=t.getVisibleUnwrappedCoordinates(this._source.tileID).map(t=>new Cc(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y)):(i=t.coveringTiles({tileSize:e||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!r,reparseOverscaled:this._source.reparseOverscaled,useElevationData:!!this.transform.elevation&&!this.usedForTerrain}),this._source.hasTile&&(i=i.filter(t=>this._source.hasTile(t)))):i=[];const n=this._updateRetainedTiles(i);if(Uh(this._source.type)&&0!==i.length){const t={},e={},r=Object.keys(n);for(const i of r){const r=n[i],s=this._tiles[i];if(!s||s.fadeEndTime&&s.fadeEndTime<=O.now())continue;const a=this.findLoadedParent(r,Math.max(r.overscaledZ-Rh.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),t[a.tileID.key]=a.tileID),e[i]=r;}const s=i[i.length-1].overscaledZ;for(const t in this._tiles){const r=this._tiles[t];if(n[t]||!r.hasData())continue;let i=r.tileID;for(;i.overscaledZ>s;){i=i.scaledTo(i.overscaledZ-1);const s=this._tiles[i.key];if(s&&s.hasData()&&e[i.key]){n[t]=r.tileID;break}}}for(const e in t)n[e]||(this._coveredTiles[e]=!0,n[e]=t[e]);}for(const t in n)this._tiles[t].clearFadeHold();const s=function(t,e){const r=[];for(const i in t)i in e||r.push(i);return r}(this._tiles,n);for(const t of s){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(+t);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(+t);}_updateRetainedTiles(t){const e={};if(0===t.length)return e;const r={},i=t[t.length-1].overscaledZ,n=t[0].overscaledZ,s=Math.max(n-Rh.maxOverzooming,this._source.minzoom),a=Math.max(n+Rh.maxUnderzooming,this._source.minzoom),o={};for(const r of t){const t=this._addTile(r);e[r.key]=r,t.hasData()||i<this._source.maxzoom&&(o[r.key]=r);}this._retainLoadedChildren(o,i,a,e);for(const i of t){let t=this._tiles[i.key];if(t.hasData())continue;if(i.canonical.z>=this._source.maxzoom){const t=i.children(this._source.maxzoom)[0],r=this.getTile(t);if(r&&r.hasData()){e[t.key]=t;continue}}else {const t=i.children(this._source.maxzoom);if(e[t[0].key]&&e[t[1].key]&&e[t[2].key]&&e[t[3].key])continue}let n=t.wasRequested();for(let a=i.overscaledZ-1;a>=s;--a){const s=i.scaledTo(a);if(r[s.key])break;if(r[s.key]=!0,t=this.getTile(s),!t&&n&&(t=this._addTile(s)),t&&(e[s.key]=s,n=t.wasRequested(),t.hasData()))break}}return e}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let r,i=this._tiles[t].tileID;for(;i.overscaledZ>0;){if(i.key in this._loadedParentTiles){r=this._loadedParentTiles[i.key];break}e.push(i.key);const t=i.scaledTo(i.overscaledZ-1);if(r=this._getLoadedTile(t),r)break;i=t;}for(const t of e)this._loadedParentTiles[t]=r;}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const r=Boolean(e);return r||(e=new Vc(t,this._source.tileSize*t.overscaleFactor(),this.transform.tileZoom),this._loadTile(e,this._tileLoaded.bind(this,e,t.key,e.state))),e?(e.uses++,this._tiles[t.key]=e,r||this._source.fire(new Bt("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e):null}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const r=e.getExpiryTimeout();r&&(this._timers[t]=setTimeout(()=>{this._reloadTile(t,"expired"),delete this._timers[t];},r));}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(+t);this._cache.reset();}tilesIn(t,e,r){const i=[],n=this.transform;if(!n)return i;for(const s in this._tiles){const a=this._tiles[s];if(r&&a.clearQueryDebugViz(),a.holdingForFade())continue;const o=t.containsTile(a,n,e);o&&i.push(o);}return i}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map(t=>this._tiles[t].tileID);for(const t of e)t.posMatrix=this.transform.calculatePosMatrix(t.toUnwrapped());return e}hasTransition(){if(this._source.hasTransition())return !0;if(Uh(this._source.type))for(const t in this._tiles){const e=this._tiles[t];if(void 0!==e.fadeEndTime&&e.fadeEndTime>=O.now())return !0}return !1}setFeatureState(t,e,r){this._state.updateState(t=t||"_geojsonTileLayer",e,r);}removeFeatureState(t,e,r){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,r);}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,r){const i=this._tiles[t];i&&i.setDependencies(e,r);}reloadTilesForDependencies(t,e){for(const r in this._tiles)this._tiles[r].hasDependency(t,e)&&this._reloadTile(+r,"reloading");this._cache.filter(r=>!r.hasDependency(t,e));}}function Lh(t,e){const r=Math.abs(2*t.wrap)-+(t.wrap<0),i=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||i-r||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function Uh(t){return "raster"===t||"image"===t||"video"===t}Rh.maxOverzooming=10,Rh.maxUnderzooming=3;class Oh{constructor(t,e,r){this._dem=t,this._scale=e,this._offset=r;}static create(t,e,r){const i=r||t.findDEMTileFor(e);if(!i||!i.dem)return;const n=i.dem,s=i.tileID,a=1<<e.canonical.z-s.canonical.z;return new Oh(n,i.tileSize/8192/a,[(e.canonical.x/a-s.canonical.x)*n.dim,(e.canonical.y/a-s.canonical.y)*n.dim])}getElevationAt(t,e,r){const i=t*this._scale+this._offset[0],n=e*this._scale+this._offset[1],s=Math.floor(i),a=Math.floor(n),o=this._dem;return r?Ye(Ye(o.get(s,a),o.get(s,a+1),n-a),Ye(o.get(s+1,a),o.get(s+1,a+1),n-a),i-s):o.get(s,a)}}class $h{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new Ui(8192,16,0),this.featureIndexArray=new ps,this.promoteId=e;}insert(t,e,r,i,n){const s=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,i,n);const a=this.grid;for(let t=0;t<e.length;t++){const r=e[t],i=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];i[0]=Math.min(i[0],e.x),i[1]=Math.min(i[1],e.y),i[2]=Math.max(i[2],e.x),i[3]=Math.max(i[3],e.y);}i[0]<8192&&i[1]<8192&&i[2]>=0&&i[3]>=0&&a.insert(s,i[0],i[1],i[2],i[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Go.VectorTile(new El(this.rawTileData)).layers,this.sourceLayerCoder=new Bc(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,r,i){this.loadVTLayers();const n=t.params||{},s=hi(n.filter),a=t.tileResult,o=t.transform,l=a.bufferedTilespaceBounds,u=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,(t,e,r,i)=>ia(a.bufferedTilespaceGeometry,t,e,r,i));u.sort(Nh);let c=null;o.elevation&&u.length>0&&(c=Oh.create(o.elevation,this.tileID));const h={};let p;for(let o=0;o<u.length;o++){const l=u[o];if(l===p)continue;p=l;const d=this.featureIndexArray.get(l);let f=null;this.loadMatchingFeature(h,d.bucketIndex,d.sourceLayerIndex,d.featureIndex,s,n.layers,n.availableImages,e,r,i,(e,r,i)=>(f||(f=Ns(e)),r.queryIntersectsFeature(a,e,i,f,this.z,t.transform,t.pixelPosMatrix,c)));}return h}loadMatchingFeature(t,e,r,i,n,s,a,o,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(s,h))return;const p=this.sourceLayerCoder.decode(r),d=this.vtLayers[p].feature(i);if(n.needGeometry){const t=js(d,!0);if(!n.filter(new yn(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!n.filter(new yn(this.tileID.overscaledZ),d))return;const f=this.getId(d,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&s.indexOf(r)<0)continue;const n=o[r];if(!n)continue;let p={};void 0!==f&&u&&(p=u.getState(n.sourceLayer||"_geojsonTileLayer",f));const y=g({},l[r]);y.paint=qh(y.paint,n.paint,d,p,a),y.layout=qh(y.layout,n.layout,d,p,a);const m=!c||c(d,n,p);if(!m)continue;const x=new Dc(d,this.z,this.x,this.y,f);x.layer=y;let v=t[r];void 0===v&&(v=t[r]=[]),v.push({featureIndex:i,feature:x,intersectionZ:m});}}lookupSymbolFeatures(t,e,r,i,n,s,a,o){const l={};this.loadVTLayers();const u=hi(n);for(const n of t)this.loadMatchingFeature(l,r,i,n,u,s,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r))),r}}function qh(t,e,r,i,n){return k(t,(t,s)=>{const a=e instanceof An?e.get(s):null;return a&&a.evaluate?a.evaluate(r,i,n):a})}function Nh(t,e){return e-t}ji("FeatureIndex",$h,{omit:["rawTileData","sourceLayerCoder"]});class jh{constructor(t){const e={},r=[];for(const i in t){const n=t[i],s=e[i]={};for(const t in n){const e=n[+t];if(!e||0===e.bitmap.width||0===e.bitmap.height)continue;const i={x:0,y:0,w:e.bitmap.width+2,h:e.bitmap.height+2};r.push(i),s[t]={rect:i,metrics:e.metrics};}}const{w:i,h:n}=Jl(r),s=new Ka({width:i||1,height:n||1});for(const r in t){const i=t[r];for(const t in i){const n=i[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const a=e[r][t].rect;Ka.copy(n.bitmap,s,{x:0,y:0},{x:a.x+1,y:a.y+1},n.bitmap);}}this.image=s,this.positions=e;}}ji("GlyphAtlas",jh);class Kh{constructor(t){this.tileID=new Cc(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.enableTerrain=!!t.enableTerrain,this.isSymbolTile=t.isSymbolTile;}parse(t,e,r,i,n){this.status="parsing",this.data=t,this.collisionBoxArray=new ns;const s=new Bc(Object.keys(t.layers).sort()),a=new $h(this.tileID,this.promoteId);a.bucketLayerIDs=[];const o={},l={featureIndex:a,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:r},u=e.familiesBySource[this.source];for(const e in u){const i=t.layers[e];if(!i)continue;let n=!1,c=!1;for(const t of u[e])"symbol"===t[0].type?n=!0:c=!0;if(!0===this.isSymbolTile&&!n)continue;if(!1===this.isSymbolTile&&!c)continue;1===i.version&&z(`Vector tile source "${this.source}" layer "${e}" `+"does not use vector tile spec v2 and therefore may have some rendering errors.");const h=s.encode(e),p=[];for(let t=0;t<i.length;t++){const r=i.feature(t),n=a.getId(r,e);p.push({feature:r,id:n,index:t,sourceLayerIndex:h});}for(const t of u[e]){const e=t[0];void 0!==this.isSymbolTile&&"symbol"===e.type!==this.isSymbolTile||e.minzoom&&this.zoom<Math.floor(e.minzoom)||e.maxzoom&&this.zoom>=e.maxzoom||"none"!==e.visibility&&(Zh(t,this.zoom,r),(o[e.id]=e.createBucket({index:a.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:h,sourceID:this.source,enableTerrain:this.enableTerrain})).populate(p,l,this.tileID.canonical),a.bucketLayerIDs.push(t.map(t=>t.id)));}}let c,h,p,d;const f={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},y=k(l.glyphDependencies,t=>Object.keys(t).map(Number));Object.keys(y).length?i.send("getGlyphs",{uid:this.uid,stacks:y},(t,e)=>{c||(c=t,h=e,v.call(this));},void 0,void 0,f):h={};const g=Object.keys(l.iconDependencies);g.length?i.send("getImages",{icons:g,source:this.source,tileID:this.tileID,type:"icons"},(t,e)=>{c||(c=t,p=e,v.call(this));},void 0,void 0,f):p={};const x=Object.keys(l.patternDependencies);function v(){if(c)return n(c);if(h&&p&&d){const t=new jh(h),e=new Wl(p,d);for(const i in o){const n=o[i];n instanceof Hu?(Zh(n.layers,this.zoom,r),Pu(n,h,t.positions,p,e.iconPositions,this.showCollisionBoxes,this.tileID.canonical,this.tileZoom)):n.hasPattern&&(n instanceof cl||n instanceof Po||n instanceof Qo)&&(Zh(n.layers,this.zoom,r),n.addFeatures(l,this.tileID.canonical,e.patternPositions));}this.status="done",n(null,{buckets:m(o).filter(t=>!t.isEmpty()),featureIndex:a,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,imageAtlas:e,glyphMap:this.returnDependencies?h:null,iconMap:this.returnDependencies?p:null,glyphPositions:this.returnDependencies?t.positions:null});}}x.length?i.send("getImages",{icons:x,source:this.source,tileID:this.tileID,type:"patterns"},(t,e)=>{c||(c=t,d=e,v.call(this));},void 0,void 0,f):d={},v.call(this);}}function Zh(t,e,r){const i=new yn(e);for(const e of t)e.recalculate(i,r);}class Xh{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,i){const n=this.entries[t]=this.entries[t]||{callbacks:[]};if(n.result){const[t,r]=n.result;return this.scheduler?this.scheduler.add(()=>{i(t,r);},e):i(t,r),()=>{}}return n.callbacks.push(i),n.cancel||(n.cancel=r((r,i)=>{n.result=[r,i];for(const t of n.callbacks)this.scheduler?this.scheduler.add(()=>{t(r,i);},e):t(r,i);setTimeout(()=>delete this.entries[t],3e3);})),()=>{n.result||(n.callbacks=n.callbacks.filter(t=>t!==i),n.callbacks.length||(n.cancel(),delete this.entries[t]));}}}function Gh(t,e,r){const i=JSON.stringify(t.request);return t.data&&(this.deduped.entries[i]={result:[null,t.data]}),this.deduped.request(i,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},e=>{const i=_t(t.request,(t,i,n,s)=>{t?e(t):i&&e(null,{vectorTile:r?void 0:new Go.VectorTile(new El(i)),rawData:i,cacheControl:n,expires:s});});return ()=>{i.cancel(),e();}},e)}t.AUTH_ERR_MSG="NO_ACCESS_TOKEN",t.Aabb=Fa,t.Actor=class{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},_(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.globalScope=M()?t:s,this.scheduler=new yc;}send(t,e,r,i,n=!1,s){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[a]=r);const o=F(this.globalScope)?void 0:[];return this.target.postMessage({id:a,type:t,hasCallback:!!r,targetMapId:i,mustQueue:n,sourceMapId:this.mapId,data:Xi(e,o)},o),{cancel:()=>{r&&delete this.callbacks[a],this.target.postMessage({id:a,type:"<cancel>",targetMapId:i,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(M()||e.mustQueue){const t=this.callbacks[r];this.cancelCallbacks[r]=this.scheduler.add(()=>this.processTask(r,e),t&&t.metadata||{type:"message"});}else this.processTask(r,e);}processTask(t,e){if("<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(Gi(e.error)):r(null,Gi(e.data)));}else {const r=F(this.globalScope)?void 0:[],i=e.hasCallback?(e,i)=>{delete this.cancelCallbacks[t],this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?Xi(e):null,data:Xi(i,r)},r);}:t=>{},n=Gi(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,n,i);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],n.source)[t[1]](n,i);}else i(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}},t.AlphaImage=Ka,t.CanonicalTileID=zc,t.Color=oe,t.ColorMode=Vh,t.Context=class{constructor(t){this.gl=t,this.extVertexArrayObject=this.gl.getExtension("OES_vertex_array_object"),this.clearColor=new Wc(this),this.clearDepth=new Qc(this),this.clearStencil=new th(this),this.colorMask=new eh(this),this.depthMask=new rh(this),this.stencilMask=new ih(this),this.stencilFunc=new nh(this),this.stencilOp=new sh(this),this.stencilTest=new ah(this),this.depthRange=new oh(this),this.depthTest=new lh(this),this.depthFunc=new uh(this),this.blend=new ch(this),this.blendFunc=new hh(this),this.blendColor=new ph(this),this.blendEquation=new dh(this),this.cullFace=new fh(this),this.cullFaceSide=new yh(this),this.frontFace=new mh(this),this.program=new gh(this),this.activeTexture=new xh(this),this.viewport=new vh(this),this.bindFramebuffer=new bh(this),this.bindRenderbuffer=new wh(this),this.bindTexture=new _h(this),this.bindVertexBuffer=new Ah(this),this.bindElementBuffer=new kh(this),this.bindVertexArrayOES=this.extVertexArrayObject&&new Sh(this),this.pixelStoreUnpack=new Ih(this),this.pixelStoreUnpackPremultiplyAlpha=new Th(this),this.pixelStoreUnpackFlipY=new zh(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.extTextureFilterAnisotropicForceOff=!1,this.extTextureHalfFloat=t.getExtension("OES_texture_half_float"),this.extTextureHalfFloat&&(t.getExtension("OES_texture_half_float_linear"),this.extRenderToTextureHalfFloat=t.getExtension("EXT_color_buffer_half_float")),this.extTimerQuery=t.getExtension("EXT_disjoint_timer_query"),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE);}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.extVertexArrayObject&&(this.bindVertexArrayOES.dirty=!0),this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(t,e){return new Gc(this,t,e)}createVertexBuffer(t,e,r){return new Jc(this,t,e,r)}createRenderbuffer(t,e,r){const i=this.gl,n=i.createRenderbuffer();return this.bindRenderbuffer.set(n),i.renderbufferStorage(i.RENDERBUFFER,t,e,r),this.bindRenderbuffer.set(null),n}createFramebuffer(t,e,r){return new Bh(this,t,e,r)}clear({color:t,depth:e,stencil:r}){const i=this.gl;let n=0;t&&(n|=i.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(n|=i.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==r&&(n|=i.STENCIL_BUFFER_BIT,this.clearStencil.set(r),this.stencilMask.set(255)),i.clear(n);}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace));}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1);}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1);}setColorMode(t){a(t.blendFunction,Vh.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask);}unbindVAO(){this.extVertexArrayObject&&this.bindVertexArrayOES.set(null);}},t.CullFaceMode=Fh,t.DEMData=Zc,t.DataConstantProperty=kn,t.DedupedRequest=Xh,t.DepthMode=Dh,t.DepthStencilAttachment=class extends Mh{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}},t.EXTENT=8192,t.Elevation=class{getAtPoint(t,e=0){const r=this._source();if(!r)return e;if(t.y<0||t.y>1)return e;const i=r.getSource().maxzoom,n=1<<i,s=Math.floor(t.x),a=t.x-s,o=new Cc(i,s,i,Math.floor(a*n),Math.floor(t.y*n)),l=this.findDEMTileFor(o);if(!l||!l.dem)return e;const u=l.dem,c=1<<l.tileID.canonical.z,h=(a*c-l.tileID.canonical.x)*u.dim,p=(t.y*c-l.tileID.canonical.y)*u.dim,d=Math.floor(h),f=Math.floor(p);return this.exaggeration()*Ye(Ye(u.get(d,f),u.get(d,f+1),p-f),Ye(u.get(d+1,f),u.get(d+1,f+1),p-f),h-d)}getAtTileOffset(t,e,r){const i=1<<t.canonical.z;return this.getAtPoint(new Ic(t.wrap+(t.canonical.x+e/8192)/i,(t.canonical.y+r/8192)/i))}getForTilePoints(t,e,r,i){const n=Oh.create(this,t,i);return !!n&&(e.forEach(t=>{t[2]=this.exaggeration()*n.getElevationAt(t[0],t[1],r);}),!0)}getMinMaxForTile(t){const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,i=e.tileID,n=1<<t.canonical.z-i.canonical.z;let s=t.canonical.x/n-i.canonical.x,a=t.canonical.y/n-i.canonical.y,o=0;for(let e=0;e<t.canonical.z-i.canonical.z&&!r.leaves[o];e++){s*=2,a*=2;const t=2*Math.floor(a)+Math.floor(s);o=r.childOffsets[o]+t,s%=1,a%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}},t.ErrorEvent=Dt,t.EvaluationParameters=yn,t.Event=Bt,t.Evented=Pt,t.Frustum=Va,t.ImagePosition=Yl,t.LngLat=xc,t.LngLatBounds=gc,t.MAX_SAFE_INTEGER=o,t.MercatorCoordinate=Ic,t.ONE_EM=24,t.OverscaledTileID=Cc,t.Point=i,t.Point$1=i,t.Properties=En,t.RGBAImage=Za,t.Ray=class{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const i=Sa(e,this.dir);if(Math.abs(i)<1e-6)return !1;const n=Sa(Ea(ma(),t,this.pos),e)/i;return function(t,e){t[0]=e[0],t[1]=e[1],t[2]=e[2];}(r,Aa(ma(),this.pos,this.dir,n)),!0}},t.RequestManager=class{constructor(t,e){this._transformRequestFn=t,this._customAccessToken=e,this._createSkuToken();}_createSkuToken(){const t=function(){let t="";for(let e=0;e<10;e++)t+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",H,t].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=t.token,this._skuTokenExpiresAt=t.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}normalizeStyleURL(t,e){if(!J(t))return t;const r=Q(t);return r.path=`/styles/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeGlyphsURL(t,e){if(!J(t))return t;const r=Q(t);return r.path=`/fonts/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeSourceURL(t,e){if(!J(t))return t;const r=Q(t);return r.path=`/v4/${r.authority}.json`,r.params.push("secure"),this._makeAPIURL(r,this._customAccessToken||e)}normalizeSpriteURL(t,e,r,i){const n=Q(t);return J(t)?(n.path=`/styles/v1${n.path}/sprite${e}${r}`,this._makeAPIURL(n,this._customAccessToken||i)):(n.path+=`${e}${r}`,tt(n))}normalizeTileURL(t,e,r){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!J(t))return t;const i=Q(t);i.path=i.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${e||r&&"raster"!==i.authority&&512===r?"@2x":""}${N.supported?".webp":"$1"}`),"raster"===i.authority?i.path=`/${q.RASTER_URL_PREFIX}${i.path}`:(i.path=i.path.replace(/^.+\/v4\//,"/"),i.path=`/${q.TILE_URL_VERSION}${i.path}`);const n=this._customAccessToken||function(t){for(const e of t){const t=e.match(/^access_token=(.*)$/);if(t)return t[1]}return null}(i.params)||q.ACCESS_TOKEN;return q.REQUIRE_ACCESS_TOKEN&&n&&this._skuToken&&i.params.push(`sku=${this._skuToken}`),this._makeAPIURL(i,n)}canonicalizeTileURL(t,e){const r=Q(t);if(!r.path.match(/^(\/v4\/|\/raster\/v1\/)/)||!r.path.match(/\.[\w]+$/))return t;let i="mapbox://";r.path.match(/^\/raster\/v1\//)?i+=`raster/${r.path.replace(`/${q.RASTER_URL_PREFIX}/`,"")}`:i+=`tiles/${r.path.replace(`/${q.TILE_URL_VERSION}/`,"")}`;let n=r.params;return e&&(n=n.filter(t=>!t.match(/^access_token=/))),n.length&&(i+=`?${n.join("&")}`),i}canonicalizeTileset(t,e){const r=!!e&&J(e),i=[];for(const e of t.tiles||[])Y(e)?i.push(this.canonicalizeTileURL(e,r)):i.push(e);return i}_makeAPIURL(t,e){const r="See https://www.mapbox.com/api-documentation/#access-tokens-and-token-scopes",i=Q(q.API_URL);if(t.protocol=i.protocol,t.authority=i.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==i.path&&(t.path=`${i.path}${t.path}`),!q.REQUIRE_ACCESS_TOKEN)return tt(t);if(!(e=e||q.ACCESS_TOKEN))throw new Error(`An API access token is required to use Mapbox GL. ${r}`);if("s"===e[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${r}`);return t.params=t.params.filter(t=>-1===t.indexOf("access_token")),t.params.push(`access_token=${e}`),tt(t)}},t.RequestPerformance=fc,t.ResourceType=xt,t.SegmentVector=Os,t.SourceCache=Rh,t.StencilMode=Ph,t.StructArrayLayout1ui2=es,t.StructArrayLayout2f1f2i16=Zn,t.StructArrayLayout2i4=Fn,t.StructArrayLayout3f12=qn,t.StructArrayLayout3ui6=Gn,t.StructArrayLayout4i8=Rn,t.Texture=hc,t.Tile=Vc,t.Transitionable=xn,t.Uniform1f=_s,t.Uniform1i=class extends ws{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.Uniform2f=class extends ws{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.Uniform3f=class extends ws{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.Uniform4f=As,t.UniformColor=ks,t.UniformMatrix3f=class extends ws{constructor(t,e){super(t,e),this.current=Is;}set(t){for(let e=0;e<9;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix3fv(this.location,!1,t);break}}},t.UniformMatrix4f=class extends ws{constructor(t,e){super(t,e),this.current=Ss;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.UnwrappedTileID=Ec,t.ValidationError=Ft,t.VectorTileWorkerSource=class{constructor(t,e,r,i){this.actor=t,this.layerIndex=e,this.availableImages=r,this.loadVectorData=i||Gh,this.loading={},this.loaded={},this.deduped=new Xh(t.scheduler);}loadTile(t,e){const r=t.uid,i=!!(t&&t.request&&t.request.collectResourceTiming)&&new fc(t.request),n=this.loading[r]=new Kh(t);n.abort=this.loadVectorData(t,(t,s)=>{const a=!this.loading[r];if(delete this.loading[r],a||t||!s)return n.status="done",a||(this.loaded[r]=n),e(t);const o=s.rawData,l={};s.expires&&(l.expires=s.expires),s.cacheControl&&(l.cacheControl=s.cacheControl);const u={};if(i){const t=i.finish();t&&(u.resourceTiming=JSON.parse(JSON.stringify(t)));}n.vectorTile=s.vectorTile||new Go.VectorTile(new El(o)),n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,(t,r)=>{if(t||!r)return e(t);e(null,g({rawTileData:o.slice(0)},r,l,u));}),this.loaded=this.loaded||{},this.loaded[r]=n;});}reloadTile(t,e){const r=this.loaded,i=t.uid,n=this;if(r&&r[i]){const s=r[i];s.showCollisionBoxes=t.showCollisionBoxes,s.enableTerrain=!!t.enableTerrain;const a=(t,r)=>{const i=s.reloadCallback;i&&(delete s.reloadCallback,s.parse(s.vectorTile,n.layerIndex,this.availableImages,n.actor,i)),e(t,r);};"parsing"===s.status?s.reloadCallback=a:"done"===s.status&&(s.vectorTile?s.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,a):a());}}abortTile(t,e){const r=t.uid,i=this.loading[r];i&&(i.abort&&i.abort(),delete this.loading[r]),e();}removeTile(t,e){const r=this.loaded,i=t.uid;r&&r[i]&&delete r[i],e();}},t.WritingMode=Ql,t.ZoomHistory=Hi,t.add=ba,t.addDynamicAttributes=Ku,t.altitudeFromMercatorZ=Sc,t.asyncAll=function(t,e,r){if(!t.length)return r(null,[]);let i=t.length;const n=new Array(t.length);let s=null;t.forEach((t,a)=>{e(t,(t,e)=>{t&&(s=t),n[a]=e,0==--i&&r(s,n);});});},t.bezier=p,t.bindAll=_,t.browser=O,t.bufferConvexPolygon=function(t,e){const r=[];for(let i=0;i<t.length;i++){const n=y(i-1,-1,t.length-1),s=y(i+1,-1,t.length-1),a=t[i],o=t[s],l=t[n].sub(a).unit(),u=o.sub(a).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(a.add(h));}return r},t.cacheEntryPossiblyAdded=function(t){mt++,mt>pt&&(t.getActor().send("enforceCacheSizeLimit",ht),mt=0);},t.clamp=f,t.clearTileCache=function(t){const e=s.caches.delete("mapbox-tiles");t&&e.catch(t).then(()=>t());},t.clipLine=wu,t.clone=function(t){var e=new ha(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.clone$1=I,t.collisionCircleLayout=bl,t.config=q,t.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},t.create=function(){var t=new ha(16);return ha!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.create$1=pa,t.create$2=function(){var t=new ha(4);return ha!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},t.createExpression=Wr,t.createLayout=Pn,t.createStyleLayer=function(t){return "custom"===t.type?new rc(t):new sc[t.type](t)},t.cross=Ia,t.deepEqual=a,t.degToRad=c,t.div=function(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t},t.dot=Sa,t.ease=d,t.easeCubicInOut=h,t.emitValidationErrors=Li,t.endsWith=A,t.enforceCacheSizeLimit=function(t){dt(),ut&&ut.then(e=>{e.keys().then(r=>{for(let i=0;i<r.length-t;i++)e.delete(r[i]);});});},t.evaluateSizeForFeature=_l,t.evaluateSizeForZoom=Al,t.evaluateVariableOffset=Du,t.evented=hn,t.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},t.exactEquals$1=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},t.extend=g,t.featureFilter=hi,t.filterObject=S,t.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},t.fromQuat=function(t,e){var r=e[0],i=e[1],n=e[2],s=e[3],a=r+r,o=i+i,l=n+n,u=r*a,c=i*a,h=i*o,p=n*a,d=n*o,f=n*l,y=s*a,m=s*o,g=s*l;return t[0]=1-h-f,t[1]=c+g,t[2]=p-m,t[3]=0,t[4]=c-g,t[5]=1-u-f,t[6]=d+y,t[7]=0,t[8]=p+m,t[9]=d-y,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.fromRotation=function(t,e){var r=Math.sin(e),i=Math.cos(e);return t[0]=i,t[1]=r,t[2]=0,t[3]=-r,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.getAnchorAlignment=cu,t.getAnchorJustification=Vu,t.getArrayBuffer=_t,t.getBounds=function(t){let e=1/0,r=1/0,n=-1/0,s=-1/0;for(const i of t)e=Math.min(e,i.x),r=Math.min(r,i.y),n=Math.max(n,i.x),s=Math.max(s,i.y);return {min:new i(e,r),max:new i(n,s)}},t.getImage=Et,t.getJSON=function(t,e){return wt(g(t,{type:"json"}),e)},t.getMapSessionAPI=lt,t.getRTLTextPluginStatus=pn,t.getReferrer=bt,t.getVideo=function(t,e){const r=s.document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const i=s.document.createElement("source");St(t[e])||(r.crossOrigin="Anonymous"),i.src=t[e],r.appendChild(i);}return {cancel:()=>{}}},t.identity=da,t.identity$1=Da,t.invert=function(t,e){var r=e[0],i=e[1],n=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],d=e[11],f=e[12],y=e[13],m=e[14],g=e[15],x=r*o-i*a,v=r*l-n*a,b=r*u-s*a,w=i*l-n*o,_=i*u-s*o,A=n*u-s*l,k=c*y-h*f,S=c*m-p*f,I=c*g-d*f,T=h*m-p*y,z=h*g-d*y,E=p*g-d*m,C=x*E-v*z+b*T+w*I-_*S+A*k;return C?(t[0]=(o*E-l*z+u*T)*(C=1/C),t[1]=(n*z-i*E-s*T)*C,t[2]=(y*A-m*_+g*w)*C,t[3]=(p*_-h*A-d*w)*C,t[4]=(l*I-a*E-u*S)*C,t[5]=(r*E-n*I+s*S)*C,t[6]=(m*b-f*A-g*v)*C,t[7]=(c*A-p*b+d*v)*C,t[8]=(a*z-o*I+u*k)*C,t[9]=(i*I-r*z-s*k)*C,t[10]=(f*_-y*b+g*x)*C,t[11]=(h*b-c*_-d*x)*C,t[12]=(o*S-a*T-l*k)*C,t[13]=(r*T-i*S+n*k)*C,t[14]=(y*v-f*w-m*x)*C,t[15]=(c*w-h*v+p*x)*C,t):null},t.isChar=Ji,t.isMapboxURL=J,t.latFromMercatorY=kc,t.len=Ca,t.length=xa,t.length$1=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},t.loadVectorTile=Gh,t.makeRequest=wt,t.mercatorXfromLng=wc,t.mercatorYfromLat=_c,t.mercatorZfromAltitude=Ac,t.mul=ya,t.mul$1=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t},t.multiply=fa,t.mvt=Go,t.nextPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},t.normalize=ka,t.normalize$1=function(t,e){var r=e[0],i=e[1],n=e[2],s=e[3],a=r*r+i*i+n*n+s*s;return a>0&&(a=1/Math.sqrt(a)),t[0]=r*a,t[1]=i*a,t[2]=n*a,t[3]=s*a,t},t.number=Ye,t.offscreenCanvasSupported=gt,t.ortho=function(t,e,r,i,n,s,a){var o=1/(e-r),l=1/(i-n),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(n+i)*l,t[14]=(a+s)*u,t[15]=1,t},t.parseGlyphPBF=function(t){return new El(t).readFields(Xl,[])},t.pbf=El,t.perspective=function(t,e,r,i,n){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=n&&n!==1/0?(t[10]=(n+i)*(s=1/(i-n)),t[14]=2*n*i*s):(t[10]=-1,t[14]=-2*i),t},t.pick=function(t,e){const r={};for(let i=0;i<e.length;i++){const n=e[i];n in t&&(r[n]=t[n]);}return r},t.plugin=fn,t.polygonIntersectsBox=ia,t.polygonIntersectsPolygon=Xs,t.polygonizeBounds=function(t,e,r=0){const n=new i(r,r),s=t.sub(n),a=e.add(n);return [s,new i(a.x,s.y),a,new i(s.x,a.y),s]},t.posAttributes=Pc,t.postMapLoadEvent=at,t.postTurnstileEvent=nt,t.potpack=Jl,t.prevPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.radToDeg=function(t){return t*u},t.refProperties=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.registerForPluginStateChange=function(t){return t({pluginStatus:on,pluginURL:ln}),hn.on("pluginStateChange",t),t},t.renderColorRamp=Ga,t.rotate=function(t,e,r){var i=e[0],n=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=i*l+s*o,t[1]=n*l+a*o,t[2]=i*-o+s*l,t[3]=n*-o+a*l,t},t.rotateX=function(t,e,r){var i=Math.sin(r),n=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*n+u*i,t[5]=a*n+c*i,t[6]=o*n+h*i,t[7]=l*n+p*i,t[8]=u*n-s*i,t[9]=c*n-a*i,t[10]=h*n-o*i,t[11]=p*n-l*i,t},t.rotateX$1=Pa,t.rotateY=function(t,e,r){var i=Math.sin(r),n=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n-u*i,t[1]=a*n-c*i,t[2]=o*n-h*i,t[3]=l*n-p*i,t[8]=s*i+u*n,t[9]=a*i+c*n,t[10]=o*i+h*n,t[11]=l*i+p*n,t},t.rotateZ=function(t,e,r){var i=Math.sin(r),n=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n+u*i,t[1]=a*n+c*i,t[2]=o*n+h*i,t[3]=l*n+p*i,t[4]=u*n-s*i,t[5]=c*n-a*i,t[6]=h*n-o*i,t[7]=p*n-l*i,t},t.rotateZ$1=function(t,e,r){r*=.5;var i=e[0],n=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=i*l+n*o,t[1]=n*l-i*o,t[2]=s*l+a*o,t[3]=a*l-s*o,t},t.scale=function(t,e,r){var i=r[0],n=r[1],s=r[2];return t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i,t[3]=e[3]*i,t[4]=e[4]*n,t[5]=e[5]*n,t[6]=e[6]*n,t[7]=e[7]*n,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.scale$1=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},t.scale$2=_a,t.scaleAndAdd=Aa,t.setCacheLimits=function(t,e){ht=t,pt=e;},t.setRTLTextPlugin=function(t,e,r=!1){if("deferred"===on||"loading"===on||"loaded"===on)throw new Error("setRTLTextPlugin cannot be called multiple times.");ln=O.resolveURL(t),on="deferred",an=e,cn(),r||dn();},t.styleSpec=Vt,t.sub=Ea,t.subtract=wa,t.symbolSize=kl,t.transformMat3=function(t,e,r){var i=e[0],n=e[1],s=e[2];return t[0]=i*r[0]+n*r[3]+s*r[6],t[1]=i*r[1]+n*r[4]+s*r[7],t[2]=i*r[2]+n*r[5]+s*r[8],t},t.transformMat4=Ma,t.transformQuat=Ta,t.translate=function(t,e,r){var i,n,s,a,o,l,u,c,h,p,d,f,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(n=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],t[0]=i=e[0],t[1]=n,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=d,t[11]=f,t[12]=i*y+o*m+h*g+e[12],t[13]=n*y+l*m+p*g+e[13],t[14]=s*y+u*m+d*g+e[14],t[15]=a*y+c*m+f*g+e[15]),t},t.triggerPluginCompletionEvent=un,t.uniqueId=v,t.validateCustomStyleLayer=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.validateLight=Vi,t.validateStyle=Pi,t.values=m,t.vectorTile=Go,t.version="2.0.1",t.warnOnce=z,t.webpSupported=N,t.window=s,t.wrap=y;}));

define(["./shared"],(function(e){"use strict";function t(e){const r=typeof e;if("number"===r||"boolean"===r||"string"===r||null==e)return JSON.stringify(e);if(Array.isArray(e)){let r="[";for(const n of e)r+=`${t(n)},`;return `${r}]`}const n=Object.keys(e).sort();let o="{";for(let r=0;r<n.length;r++)o+=`${JSON.stringify(n[r])}:${t(e[n[r]])},`;return `${o}}`}function r(r){let n="";for(const o of e.refProperties)n+=`/${t(r[o])}`;return n}class n{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,n){for(const r of t){this._layerConfigs[r.id]=r;const t=this._layers[r.id]=e.createStyleLayer(r);t._featureFilter=e.featureFilter(t.filter),this.keyCache[r.id]&&delete this.keyCache[r.id];}for(const e of n)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const o=function(e,t){const n={};for(let o=0;o<e.length;o++){const i=t&&t[e[o].id]||r(e[o]);t&&(t[e[o].id]=i);let s=n[i];s||(s=n[i]=[]),s.push(e[o]);}const o=[];for(const e in n)o.push(n[e]);return o}(e.values(this._layerConfigs),this.keyCache);for(const e of o){const t=e.map(e=>this._layers[e.id]),r=t[0];if("none"===r.visibility)continue;const n=r.source||"";let o=this.familiesBySource[n];o||(o=this.familiesBySource[n]={});const i=r.sourceLayer||"_geojsonTileLayer";let s=o[i];s||(s=o[i]=[]),s.push(t);}}}const{ImageBitmap:o}=e.window;class i{loadTile(t,r){const{uid:n,encoding:i,rawImageData:s,padding:a,buildQuadTree:l}=t,u=o&&s instanceof o?this.getImageData(s,a):s;r(null,new e.DEMData(n,u,i,a<1,l));}getImageData(t,r){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(t.width,t.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d")),this.offscreenCanvas.width=t.width,this.offscreenCanvas.height=t.height,this.offscreenCanvasContext.drawImage(t,0,0,t.width,t.height);const n=this.offscreenCanvasContext.getImageData(-r,-r,t.width+2*r,t.height+2*r);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),new e.RGBAImage({width:n.width,height:n.height},n.data)}}function s(e,t){if(0!==e.length){a(e[0],t);for(var r=1;r<e.length;r++)a(e[r],!t);}}function a(e,t){for(var r=0,n=0,o=e.length,i=o-1;n<o;i=n++)r+=(e[n][0]-e[i][0])*(e[i][1]+e[n][1]);r>=0!=!!t&&e.reverse();}const l=e.vectorTile.VectorTileFeature.prototype.toGeoJSON;class u{constructor(t){this._feature=t,this.extent=e.EXTENT,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const r of this._feature.geometry)t.push([new e.Point$1(r[0],r[1])]);return t}{const t=[];for(const r of this._feature.geometry){const n=[];for(const t of r)n.push(new e.Point$1(t[0],t[1]));t.push(n);}return t}}toGeoJSON(e,t,r){return l.call(this,e,t,r)}}class h{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.EXTENT,this.length=t.length,this._features=t;}feature(e){return new u(this._features[e])}}var c=e.vectorTile.VectorTileFeature,f=p;function p(e,t){this.options=t||{},this.features=e,this.length=e.length;}function g(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}p.prototype.feature=function(e){return new g(this.features[e],this.options.extent)},g.prototype.loadGeometry=function(){var t=this.rawGeometry;this.geometry=[];for(var r=0;r<t.length;r++){for(var n=t[r],o=[],i=0;i<n.length;i++)o.push(new e.Point$1(n[i][0],n[i][1]));this.geometry.push(o);}return this.geometry},g.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,r=-1/0,n=1/0,o=-1/0,i=0;i<e.length;i++)for(var s=e[i],a=0;a<s.length;a++){var l=s[a];t=Math.min(t,l.x),r=Math.max(r,l.x),n=Math.min(n,l.y),o=Math.max(o,l.y);}return [t,n,r,o]},g.prototype.toGeoJSON=c.prototype.toGeoJSON;var d=y,m=f;function y(t){var r=new e.pbf;return function(e,t){for(var r in e.layers)t.writeMessage(3,v,e.layers[r]);}(t,r),r.finish()}function v(e,t){var r;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var n={keys:[],values:[],keycache:{},valuecache:{}};for(r=0;r<e.length;r++)n.feature=e.feature(r),t.writeMessage(2,x,n);var o=n.keys;for(r=0;r<o.length;r++)t.writeStringField(3,o[r]);var i=n.values;for(r=0;r<i.length;r++)t.writeMessage(4,P,i[r]);}function x(e,t){var r=e.feature;void 0!==r.id&&t.writeVarintField(1,r.id),t.writeMessage(2,w,e),t.writeVarintField(3,r.type),t.writeMessage(4,_,r);}function w(e,t){var r=e.feature,n=e.keys,o=e.values,i=e.keycache,s=e.valuecache;for(var a in r.properties){var l=i[a];void 0===l&&(n.push(a),i[a]=l=n.length-1),t.writeVarint(l);var u=r.properties[a],h=typeof u;"string"!==h&&"boolean"!==h&&"number"!==h&&(u=JSON.stringify(u));var c=h+":"+u,f=s[c];void 0===f&&(o.push(u),s[c]=f=o.length-1),t.writeVarint(f);}}function S(e,t){return (t<<3)+(7&e)}function M(e){return e<<1^e>>31}function _(e,t){for(var r=e.loadGeometry(),n=e.type,o=0,i=0,s=r.length,a=0;a<s;a++){var l=r[a],u=1;1===n&&(u=l.length),t.writeVarint(S(1,u));for(var h=3===n?l.length-1:l.length,c=0;c<h;c++){1===c&&1!==n&&t.writeVarint(S(2,h-1));var f=l[c].x-o,p=l[c].y-i;t.writeVarint(M(f)),t.writeVarint(M(p)),o+=f,i+=p;}3===n&&t.writeVarint(S(7,1));}}function P(e,t){var r=typeof e;"string"===r?t.writeStringField(1,e):"boolean"===r?t.writeBooleanField(7,e):"number"===r&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}function b(e,t,r,n){k(e,r,n),k(t,2*r,2*n),k(t,2*r+1,2*n+1);}function k(e,t,r){const n=e[t];e[t]=e[r],e[r]=n;}function I(e,t,r,n){const o=e-r,i=t-n;return o*o+i*i}d.fromVectorTileJs=y,d.fromGeojsonVt=function(e,t){t=t||{};var r={};for(var n in e)r[n]=new f(e[n].features,t),r[n].name=n,r[n].version=t.version,r[n].extent=t.extent;return y({layers:r})},d.GeoJSONWrapper=m;const T=e=>e[0],C=e=>e[1];class L{constructor(e,t=T,r=C,n=64,o=Float64Array){this.nodeSize=n,this.points=e;const i=e.length<65536?Uint16Array:Uint32Array,s=this.ids=new i(e.length),a=this.coords=new o(2*e.length);for(let n=0;n<e.length;n++)s[n]=n,a[2*n]=t(e[n]),a[2*n+1]=r(e[n]);!function e(t,r,n,o,i,s){if(i-o<=n)return;const a=o+i>>1;!function e(t,r,n,o,i,s){for(;i>o;){if(i-o>600){const a=i-o+1,l=n-o+1,u=Math.log(a),h=.5*Math.exp(2*u/3),c=.5*Math.sqrt(u*h*(a-h)/a)*(l-a/2<0?-1:1);e(t,r,n,Math.max(o,Math.floor(n-l*h/a+c)),Math.min(i,Math.floor(n+(a-l)*h/a+c)),s);}const a=r[2*n+s];let l=o,u=i;for(b(t,r,o,n),r[2*i+s]>a&&b(t,r,o,i);l<u;){for(b(t,r,l,u),l++,u--;r[2*l+s]<a;)l++;for(;r[2*u+s]>a;)u--;}r[2*o+s]===a?b(t,r,o,u):(u++,b(t,r,u,i)),u<=n&&(o=u+1),n<=u&&(i=u-1);}}(t,r,a,o,i,s%2),e(t,r,n,o,a-1,s+1),e(t,r,n,a+1,i,s+1);}(s,a,n,0,s.length-1,0);}range(e,t,r,n){return function(e,t,r,n,o,i,s){const a=[0,e.length-1,0],l=[];let u,h;for(;a.length;){const c=a.pop(),f=a.pop(),p=a.pop();if(f-p<=s){for(let s=p;s<=f;s++)u=t[2*s],h=t[2*s+1],u>=r&&u<=o&&h>=n&&h<=i&&l.push(e[s]);continue}const g=Math.floor((p+f)/2);u=t[2*g],h=t[2*g+1],u>=r&&u<=o&&h>=n&&h<=i&&l.push(e[g]);const d=(c+1)%2;(0===c?r<=u:n<=h)&&(a.push(p),a.push(g-1),a.push(d)),(0===c?o>=u:i>=h)&&(a.push(g+1),a.push(f),a.push(d));}return l}(this.ids,this.coords,e,t,r,n,this.nodeSize)}within(e,t,r){return function(e,t,r,n,o,i){const s=[0,e.length-1,0],a=[],l=o*o;for(;s.length;){const u=s.pop(),h=s.pop(),c=s.pop();if(h-c<=i){for(let o=c;o<=h;o++)I(t[2*o],t[2*o+1],r,n)<=l&&a.push(e[o]);continue}const f=Math.floor((c+h)/2),p=t[2*f],g=t[2*f+1];I(p,g,r,n)<=l&&a.push(e[f]);const d=(u+1)%2;(0===u?r-o<=p:n-o<=g)&&(s.push(c),s.push(f-1),s.push(d)),(0===u?r+o>=p:n+o>=g)&&(s.push(f+1),s.push(h),s.push(d));}return a}(this.ids,this.coords,e,t,r,this.nodeSize)}}const O={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e};class z{constructor(e){this.options=Y(Object.create(O),e),this.trees=new Array(this.options.maxZoom+1);}load(e){const{log:t,minZoom:r,maxZoom:n,nodeSize:o}=this.options;t&&console.time("total time");const i=`prepare ${e.length} points`;t&&console.time(i),this.points=e;let s=[];for(let t=0;t<e.length;t++)e[t].geometry&&s.push(N(e[t],t));this.trees[n+1]=new L(s,W,X,o,Float32Array),t&&console.timeEnd(i);for(let e=n;e>=r;e--){const r=+Date.now();s=this._cluster(s,e),this.trees[e]=new L(s,W,X,o,Float32Array),t&&console.log("z%d: %d clusters in %dms",e,s.length,+Date.now()-r);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let r=((e[0]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[1]));let o=180===e[2]?180:((e[2]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)r=-180,o=180;else if(r>o){const e=this.getClusters([r,n,180,i],t),s=this.getClusters([-180,n,o,i],t);return e.concat(s)}const s=this.trees[this._limitZoom(t)],a=s.range(J(r),D(i),J(o),D(n)),l=[];for(const e of a){const t=s.points[e];l.push(t.numPoints?F(t):this.points[t.index]);}return l}getChildren(e){const t=this._getOriginId(e),r=this._getOriginZoom(e),n="No cluster with the specified id.",o=this.trees[r];if(!o)throw new Error(n);const i=o.points[t];if(!i)throw new Error(n);const s=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=o.within(i.x,i.y,s),l=[];for(const t of a){const r=o.points[t];r.parentId===e&&l.push(r.numPoints?F(r):this.points[r.index]);}if(0===l.length)throw new Error(n);return l}getLeaves(e,t,r){const n=[];return this._appendLeaves(n,e,t=t||10,r=r||0,0),n}getTile(e,t,r){const n=this.trees[this._limitZoom(e)],o=Math.pow(2,e),{extent:i,radius:s}=this.options,a=s/i,l=(r-a)/o,u=(r+1+a)/o,h={features:[]};return this._addTileFeatures(n.range((t-a)/o,l,(t+1+a)/o,u),n.points,t,r,o,h),0===t&&this._addTileFeatures(n.range(1-a/o,l,1,u),n.points,o,r,o,h),t===o-1&&this._addTileFeatures(n.range(0,l,a/o,u),n.points,-1,r,o,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const r=this.getChildren(e);if(t++,1!==r.length)break;e=r[0].properties.cluster_id;}return t}_appendLeaves(e,t,r,n,o){const i=this.getChildren(t);for(const t of i){const i=t.properties;if(i&&i.cluster?o+i.point_count<=n?o+=i.point_count:o=this._appendLeaves(e,i.cluster_id,r,n,o):o<n?o++:e.push(t),e.length===r)break}return o}_addTileFeatures(e,t,r,n,o,i){for(const s of e){const e=t[s],a=e.numPoints,l={type:1,geometry:[[Math.round(this.options.extent*(e.x*o-r)),Math.round(this.options.extent*(e.y*o-n))]],tags:a?Z(e):this.points[e.index].properties};let u;a?u=e.id:this.options.generateId?u=e.index:this.points[e.index].id&&(u=this.points[e.index].id),void 0!==u&&(l.id=u),i.features.push(l);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(+e,this.options.maxZoom+1))}_cluster(e,t){const r=[],{radius:n,extent:o,reduce:i,minPoints:s}=this.options,a=n/(o*Math.pow(2,t));for(let n=0;n<e.length;n++){const o=e[n];if(o.zoom<=t)continue;o.zoom=t;const l=this.trees[t+1],u=l.within(o.x,o.y,a),h=o.numPoints||1;let c=h;for(const e of u){const r=l.points[e];r.zoom>t&&(c+=r.numPoints||1);}if(c>=s){let e=o.x*h,s=o.y*h,a=i&&h>1?this._map(o,!0):null;const f=(n<<5)+(t+1)+this.points.length;for(const r of u){const n=l.points[r];if(n.zoom<=t)continue;n.zoom=t;const u=n.numPoints||1;e+=n.x*u,s+=n.y*u,n.parentId=f,i&&(a||(a=this._map(o,!0)),i(a,this._map(n)));}o.parentId=f,r.push(E(e/c,s/c,f,c,a));}else if(r.push(o),c>1)for(const e of u){const n=l.points[e];n.zoom<=t||(n.zoom=t,r.push(n));}}return r}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t){if(e.numPoints)return t?Y({},e.properties):e.properties;const r=this.points[e.index].properties,n=this.options.map(r);return t&&n===r?Y({},n):n}}function E(e,t,r,n,o){return {x:e,y:t,zoom:1/0,id:r,parentId:-1,numPoints:n,properties:o}}function N(e,t){const[r,n]=e.geometry.coordinates;return {x:J(r),y:D(n),zoom:1/0,index:t,parentId:-1}}function F(e){return {type:"Feature",id:e.id,properties:Z(e),geometry:{type:"Point",coordinates:[(t=e.x,360*(t-.5)),G(e.y)]}};var t;}function Z(e){const t=e.numPoints,r=t>=1e4?`${Math.round(t/1e3)}k`:t>=1e3?`${Math.round(t/100)/10}k`:t;return Y(Y({},e.properties),{cluster:!0,cluster_id:e.id,point_count:t,point_count_abbreviated:r})}function J(e){return e/360+.5}function D(e){const t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function G(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function Y(e,t){for(const r in t)e[r]=t[r];return e}function W(e){return e.x}function X(e){return e.y}function V(e,t,r,n,o,i){var s=o-r,a=i-n;if(0!==s||0!==a){var l=((e-r)*s+(t-n)*a)/(s*s+a*a);l>1?(r=o,n=i):l>0&&(r+=s*l,n+=a*l);}return (s=e-r)*s+(a=t-n)*a}function $(e,t,r,n){var o={id:void 0===e?null:e,type:t,geometry:r,tags:n,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};return function(e){var t=e.geometry,r=e.type;if("Point"===r||"MultiPoint"===r||"LineString"===r)j(e,t);else if("Polygon"===r||"MultiLineString"===r)for(var n=0;n<t.length;n++)j(e,t[n]);else if("MultiPolygon"===r)for(n=0;n<t.length;n++)for(var o=0;o<t[n].length;o++)j(e,t[n][o]);}(o),o}function j(e,t){for(var r=0;r<t.length;r+=3)e.minX=Math.min(e.minX,t[r]),e.minY=Math.min(e.minY,t[r+1]),e.maxX=Math.max(e.maxX,t[r]),e.maxY=Math.max(e.maxY,t[r+1]);}function A(e,t,r,n){if(t.geometry){var o=t.geometry.coordinates,i=t.geometry.type,s=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2),a=[],l=t.id;if(r.promoteId?l=t.properties[r.promoteId]:r.generateId&&(l=n||0),"Point"===i)R(o,a);else if("MultiPoint"===i)for(var u=0;u<o.length;u++)R(o[u],a);else if("LineString"===i)B(o,a,s,!1);else if("MultiLineString"===i){if(r.lineMetrics){for(u=0;u<o.length;u++)B(o[u],a=[],s,!1),e.push($(l,"LineString",a,t.properties));return}q(o,a,s,!1);}else if("Polygon"===i)q(o,a,s,!0);else {if("MultiPolygon"!==i){if("GeometryCollection"===i){for(u=0;u<t.geometry.geometries.length;u++)A(e,{id:l,geometry:t.geometry.geometries[u],properties:t.properties},r,n);return}throw new Error("Input data is not a valid GeoJSON object.")}for(u=0;u<o.length;u++){var h=[];q(o[u],h,s,!0),a.push(h);}}e.push($(l,i,a,t.properties));}}function R(e,t){t.push(U(e[0])),t.push(Q(e[1])),t.push(0);}function B(e,t,r,n){for(var o,i,s=0,a=0;a<e.length;a++){var l=U(e[a][0]),u=Q(e[a][1]);t.push(l),t.push(u),t.push(0),a>0&&(s+=n?(o*u-l*i)/2:Math.sqrt(Math.pow(l-o,2)+Math.pow(u-i,2))),o=l,i=u;}var h=t.length-3;t[2]=1,function e(t,r,n,o){for(var i,s=o,a=n-r>>1,l=n-r,u=t[r],h=t[r+1],c=t[n],f=t[n+1],p=r+3;p<n;p+=3){var g=V(t[p],t[p+1],u,h,c,f);if(g>s)i=p,s=g;else if(g===s){var d=Math.abs(p-a);d<l&&(i=p,l=d);}}s>o&&(i-r>3&&e(t,r,i,o),t[i+2]=s,n-i>3&&e(t,i,n,o));}(t,0,h,r),t[h+2]=1,t.size=Math.abs(s),t.start=0,t.end=t.size;}function q(e,t,r,n){for(var o=0;o<e.length;o++){var i=[];B(e[o],i,r,n),t.push(i);}}function U(e){return e/360+.5}function Q(e){var t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function H(e,t,r,n,o,i,s,a){if(n/=t,i>=(r/=t)&&s<n)return e;if(s<r||i>=n)return null;for(var l=[],u=0;u<e.length;u++){var h=e[u],c=h.geometry,f=h.type,p=0===o?h.minX:h.minY,g=0===o?h.maxX:h.maxY;if(p>=r&&g<n)l.push(h);else if(!(g<r||p>=n)){var d=[];if("Point"===f||"MultiPoint"===f)K(c,d,r,n,o);else if("LineString"===f)ee(c,d,r,n,o,!1,a.lineMetrics);else if("MultiLineString"===f)re(c,d,r,n,o,!1);else if("Polygon"===f)re(c,d,r,n,o,!0);else if("MultiPolygon"===f)for(var m=0;m<c.length;m++){var y=[];re(c[m],y,r,n,o,!0),y.length&&d.push(y);}if(d.length){if(a.lineMetrics&&"LineString"===f){for(m=0;m<d.length;m++)l.push($(h.id,f,d[m],h.tags));continue}"LineString"!==f&&"MultiLineString"!==f||(1===d.length?(f="LineString",d=d[0]):f="MultiLineString"),"Point"!==f&&"MultiPoint"!==f||(f=3===d.length?"Point":"MultiPoint"),l.push($(h.id,f,d,h.tags));}}}return l.length?l:null}function K(e,t,r,n,o){for(var i=0;i<e.length;i+=3){var s=e[i+o];s>=r&&s<=n&&(t.push(e[i]),t.push(e[i+1]),t.push(e[i+2]));}}function ee(e,t,r,n,o,i,s){for(var a,l,u=te(e),h=0===o?oe:ie,c=e.start,f=0;f<e.length-3;f+=3){var p=e[f],g=e[f+1],d=e[f+2],m=e[f+3],y=e[f+4],v=0===o?p:g,x=0===o?m:y,w=!1;s&&(a=Math.sqrt(Math.pow(p-m,2)+Math.pow(g-y,2))),v<r?x>r&&(l=h(u,p,g,m,y,r),s&&(u.start=c+a*l)):v>n?x<n&&(l=h(u,p,g,m,y,n),s&&(u.start=c+a*l)):ne(u,p,g,d),x<r&&v>=r&&(l=h(u,p,g,m,y,r),w=!0),x>n&&v<=n&&(l=h(u,p,g,m,y,n),w=!0),!i&&w&&(s&&(u.end=c+a*l),t.push(u),u=te(e)),s&&(c+=a);}var S=e.length-3;p=e[S],g=e[S+1],d=e[S+2],(v=0===o?p:g)>=r&&v<=n&&ne(u,p,g,d),S=u.length-3,i&&S>=3&&(u[S]!==u[0]||u[S+1]!==u[1])&&ne(u,u[0],u[1],u[2]),u.length&&t.push(u);}function te(e){var t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function re(e,t,r,n,o,i){for(var s=0;s<e.length;s++)ee(e[s],t,r,n,o,i,!1);}function ne(e,t,r,n){e.push(t),e.push(r),e.push(n);}function oe(e,t,r,n,o,i){var s=(i-t)/(n-t);return e.push(i),e.push(r+(o-r)*s),e.push(1),s}function ie(e,t,r,n,o,i){var s=(i-r)/(o-r);return e.push(t+(n-t)*s),e.push(i),e.push(1),s}function se(e,t){for(var r=[],n=0;n<e.length;n++){var o,i=e[n],s=i.type;if("Point"===s||"MultiPoint"===s||"LineString"===s)o=ae(i.geometry,t);else if("MultiLineString"===s||"Polygon"===s){o=[];for(var a=0;a<i.geometry.length;a++)o.push(ae(i.geometry[a],t));}else if("MultiPolygon"===s)for(o=[],a=0;a<i.geometry.length;a++){for(var l=[],u=0;u<i.geometry[a].length;u++)l.push(ae(i.geometry[a][u],t));o.push(l);}r.push($(i.id,s,o,i.tags));}return r}function ae(e,t){var r=[];r.size=e.size,void 0!==e.start&&(r.start=e.start,r.end=e.end);for(var n=0;n<e.length;n+=3)r.push(e[n]+t,e[n+1],e[n+2]);return r}function le(e,t){if(e.transformed)return e;var r,n,o,i=1<<e.z,s=e.x,a=e.y;for(r=0;r<e.features.length;r++){var l=e.features[r],u=l.geometry,h=l.type;if(l.geometry=[],1===h)for(n=0;n<u.length;n+=2)l.geometry.push(ue(u[n],u[n+1],t,i,s,a));else for(n=0;n<u.length;n++){var c=[];for(o=0;o<u[n].length;o+=2)c.push(ue(u[n][o],u[n][o+1],t,i,s,a));l.geometry.push(c);}}return e.transformed=!0,e}function ue(e,t,r,n,o,i){return [Math.round(r*(e*n-o)),Math.round(r*(t*n-i))]}function he(e,t,r,n,o){for(var i=t===o.maxZoom?0:o.tolerance/((1<<t)*o.extent),s={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:r,y:n,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0},a=0;a<e.length;a++){s.numFeatures++,ce(s,e[a],i,o);var l=e[a].minX,u=e[a].minY,h=e[a].maxX,c=e[a].maxY;l<s.minX&&(s.minX=l),u<s.minY&&(s.minY=u),h>s.maxX&&(s.maxX=h),c>s.maxY&&(s.maxY=c);}return s}function ce(e,t,r,n){var o=t.geometry,i=t.type,s=[];if("Point"===i||"MultiPoint"===i)for(var a=0;a<o.length;a+=3)s.push(o[a]),s.push(o[a+1]),e.numPoints++,e.numSimplified++;else if("LineString"===i)fe(s,o,e,r,!1,!1);else if("MultiLineString"===i||"Polygon"===i)for(a=0;a<o.length;a++)fe(s,o[a],e,r,"Polygon"===i,0===a);else if("MultiPolygon"===i)for(var l=0;l<o.length;l++){var u=o[l];for(a=0;a<u.length;a++)fe(s,u[a],e,r,!0,0===a);}if(s.length){var h=t.tags||null;if("LineString"===i&&n.lineMetrics){for(var c in h={},t.tags)h[c]=t.tags[c];h.mapbox_clip_start=o.start/o.size,h.mapbox_clip_end=o.end/o.size;}var f={geometry:s,type:"Polygon"===i||"MultiPolygon"===i?3:"LineString"===i||"MultiLineString"===i?2:1,tags:h};null!==t.id&&(f.id=t.id),e.features.push(f);}}function fe(e,t,r,n,o,i){var s=n*n;if(n>0&&t.size<(o?s:n))r.numPoints+=t.length/3;else {for(var a=[],l=0;l<t.length;l+=3)(0===n||t[l+2]>s)&&(r.numSimplified++,a.push(t[l]),a.push(t[l+1])),r.numPoints++;o&&function(e,t){for(var r=0,n=0,o=e.length,i=o-2;n<o;i=n,n+=2)r+=(e[n]-e[i])*(e[n+1]+e[i+1]);if(r>0===t)for(n=0,o=e.length;n<o/2;n+=2){var s=e[n],a=e[n+1];e[n]=e[o-2-n],e[n+1]=e[o-1-n],e[o-2-n]=s,e[o-1-n]=a;}}(a,i),e.push(a);}}function pe(e,t){var r=(t=this.options=function(e,t){for(var r in t)e[r]=t[r];return e}(Object.create(this.options),t)).debug;if(r&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");var n=function(e,t){var r=[];if("FeatureCollection"===e.type)for(var n=0;n<e.features.length;n++)A(r,e.features[n],t,n);else A(r,"Feature"===e.type?e:{geometry:e},t);return r}(e,t);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),(n=function(e,t){var r=t.buffer/t.extent,n=e,o=H(e,1,-1-r,r,0,-1,2,t),i=H(e,1,1-r,2+r,0,-1,2,t);return (o||i)&&(n=H(e,1,-r,1+r,0,-1,2,t)||[],o&&(n=se(o,1).concat(n)),i&&(n=n.concat(se(i,-1)))),n}(n,t)).length&&this.splitTile(n,0,0,0),r&&(n.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function ge(e,t,r){return 32*((1<<e)*r+t)+e}function de(e,t){const r=e.tileID.canonical;if(!this._geoJSONIndex)return t(null,null);const n=this._geoJSONIndex.getTile(r.z,r.x,r.y);if(!n)return t(null,null);const o=new h(n.features);let i=d(o);0===i.byteOffset&&i.byteLength===i.buffer.byteLength||(i=new Uint8Array(i)),t(null,{vectorTile:o,rawData:i.buffer});}pe.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0},pe.prototype.splitTile=function(e,t,r,n,o,i,s){for(var a=[e,t,r,n],l=this.options,u=l.debug;a.length;){n=a.pop(),r=a.pop(),t=a.pop(),e=a.pop();var h=1<<t,c=ge(t,r,n),f=this.tiles[c];if(!f&&(u>1&&console.time("creation"),f=this.tiles[c]=he(e,t,r,n,l),this.tileCoords.push({z:t,x:r,y:n}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,n,f.numFeatures,f.numPoints,f.numSimplified),console.timeEnd("creation"));var p="z"+t;this.stats[p]=(this.stats[p]||0)+1,this.total++;}if(f.source=e,o){if(t===l.maxZoom||t===o)continue;var g=1<<o-t;if(r!==Math.floor(i/g)||n!==Math.floor(s/g))continue}else if(t===l.indexMaxZoom||f.numPoints<=l.indexMaxPoints)continue;if(f.source=null,0!==e.length){u>1&&console.time("clipping");var d,m,y,v,x,w,S=.5*l.buffer/l.extent,M=.5-S,_=.5+S,P=1+S;d=m=y=v=null,x=H(e,h,r-S,r+_,0,f.minX,f.maxX,l),w=H(e,h,r+M,r+P,0,f.minX,f.maxX,l),e=null,x&&(d=H(x,h,n-S,n+_,1,f.minY,f.maxY,l),m=H(x,h,n+M,n+P,1,f.minY,f.maxY,l),x=null),w&&(y=H(w,h,n-S,n+_,1,f.minY,f.maxY,l),v=H(w,h,n+M,n+P,1,f.minY,f.maxY,l),w=null),u>1&&console.timeEnd("clipping"),a.push(d||[],t+1,2*r,2*n),a.push(m||[],t+1,2*r,2*n+1),a.push(y||[],t+1,2*r+1,2*n),a.push(v||[],t+1,2*r+1,2*n+1);}}},pe.prototype.getTile=function(e,t,r){var n=this.options,o=n.extent,i=n.debug;if(e<0||e>24)return null;var s=1<<e,a=ge(e,t=(t%s+s)%s,r);if(this.tiles[a])return le(this.tiles[a],o);i>1&&console.log("drilling down to z%d-%d-%d",e,t,r);for(var l,u=e,h=t,c=r;!l&&u>0;)u--,h=Math.floor(h/2),c=Math.floor(c/2),l=this.tiles[ge(u,h,c)];return l&&l.source?(i>1&&console.log("found parent tile z%d-%d-%d",u,h,c),i>1&&console.time("drilling down"),this.splitTile(l.source,u,h,c,e,t,r),i>1&&console.timeEnd("drilling down"),this.tiles[a]?le(this.tiles[a],o):null):null};class me extends e.VectorTileWorkerSource{constructor(e,t,r,n){super(e,t,r,de),n&&(this.loadGeoJSON=n);}loadData(e,t){this._pendingCallback&&this._pendingCallback(null,{abandoned:!0}),this._pendingCallback=t,this._pendingLoadDataParams=e,this._state&&"Idle"!==this._state?this._state="NeedsLoadData":(this._state="Coalescing",this._loadData());}_loadData(){if(!this._pendingCallback||!this._pendingLoadDataParams)return;const t=this._pendingCallback,r=this._pendingLoadDataParams;delete this._pendingCallback,delete this._pendingLoadDataParams;const n=!!(r&&r.request&&r.request.collectResourceTiming)&&new e.RequestPerformance(r.request);this.loadGeoJSON(r,(o,i)=>{if(o||!i)return t(o);if("object"!=typeof i)return t(new Error(`Input data given to '${r.source}' is not a valid GeoJSON object.`));{!function e(t,r){var n,o=t&&t.type;if("FeatureCollection"===o)for(n=0;n<t.features.length;n++)e(t.features[n],r);else if("GeometryCollection"===o)for(n=0;n<t.geometries.length;n++)e(t.geometries[n],r);else if("Feature"===o)e(t.geometry,r);else if("Polygon"===o)s(t.coordinates,r);else if("MultiPolygon"===o)for(n=0;n<t.coordinates.length;n++)s(t.coordinates[n],r);return t}(i,!0);try{if(r.filter){const t=e.createExpression(r.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===t.result)throw new Error(t.value.map(e=>`${e.key}: ${e.message}`).join(", "));const n=i.features.filter(e=>t.value.evaluate({zoom:0},e));i={type:"FeatureCollection",features:n};}this._geoJSONIndex=r.cluster?new z(function({superclusterOptions:t,clusterProperties:r}){if(!r||!t)return t;const n={},o={},i={accumulated:null,zoom:0},s={properties:null},a=Object.keys(r);for(const t of a){const[i,s]=r[t],a=e.createExpression(s),l=e.createExpression("string"==typeof i?[i,["accumulated"],["get",t]]:i);n[t]=a.value,o[t]=l.value;}return t.map=e=>{s.properties=e;const t={};for(const e of a)t[e]=n[e].evaluate(i,s);return t},t.reduce=(e,t)=>{s.properties=t;for(const t of a)i.accumulated=e[t],e[t]=o[t].evaluate(i,s);},t}(r)).load(i.features):function(e,t){return new pe(e,t)}(i,r.geojsonVtOptions);}catch(o){return t(o)}this.loaded={};const a={};if(n){const e=n.finish();e&&(a.resourceTiming={},a.resourceTiming[r.source]=JSON.parse(JSON.stringify(e)));}t(null,a);}});}coalesce(){"Coalescing"===this._state?this._state="Idle":"NeedsLoadData"===this._state&&(this._state="Coalescing",this._loadData());}reloadTile(e,t){const r=this.loaded;return r&&r[e.uid]?super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,r){if(t.request)e.getJSON(t.request,r);else {if("string"!=typeof t.data)return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return r(null,JSON.parse(t.data))}catch(e){return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}removeSource(e,t){this._pendingCallback&&this._pendingCallback(null,{abandoned:!0}),t();}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class ye{constructor(t){this.self=t,this.actor=new e.Actor(t,this),this.layerIndexes={},this.availableImages={},this.workerSourceTypes={vector:e.VectorTileWorkerSource,geojson:me},this.workerSources={},this.demWorkerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.plugin.isParsed())throw new Error("RTL text plugin already registered.");e.plugin.applyArabicShaping=t.applyArabicShaping,e.plugin.processBidirectionalText=t.processBidirectionalText,e.plugin.processStyledBidirectionalText=t.processStyledBidirectionalText;};}checkIfReady(e,t,r){r();}setReferrer(e,t){this.referrer=t;}setImages(e,t,r){this.availableImages[e]=t;for(const r in this.workerSources[e]){const n=this.workerSources[e][r];for(const e in n)n[e].availableImages=t;}r();}enableTerrain(e,t,r){this.terrain=t,r();}setLayers(e,t,r){this.getLayerIndex(e).replace(t),r();}updateLayers(e,t,r){this.getLayerIndex(e).update(t.layers,t.removedIds),r();}loadTile(t,r,n){const o=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;this.getWorkerSource(t,r.type,r.source).loadTile(o,n);}loadDEMTile(t,r,n){const o=this.enableTerrain?e.extend({buildQuadTree:this.terrain},r):r;this.getDEMWorkerSource(t,r.source).loadTile(o,n);}reloadTile(t,r,n){const o=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;this.getWorkerSource(t,r.type,r.source).reloadTile(o,n);}abortTile(e,t,r){this.getWorkerSource(e,t.type,t.source).abortTile(t,r);}removeTile(e,t,r){this.getWorkerSource(e,t.type,t.source).removeTile(t,r);}removeSource(e,t,r){if(!this.workerSources[e]||!this.workerSources[e][t.type]||!this.workerSources[e][t.type][t.source])return;const n=this.workerSources[e][t.type][t.source];delete this.workerSources[e][t.type][t.source],void 0!==n.removeSource?n.removeSource(t,r):r();}loadWorkerSource(e,t,r){try{this.self.importScripts(t.url),r();}catch(e){r(e.toString());}}syncRTLPluginState(t,r,n){try{e.plugin.setState(r);const t=e.plugin.getPluginURL();if(e.plugin.isLoaded()&&!e.plugin.isParsed()&&null!=t){this.self.importScripts(t);const r=e.plugin.isParsed();n(r?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),r);}}catch(e){n(e.toString());}}getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}getLayerIndex(e){let t=this.layerIndexes[e];return t||(t=this.layerIndexes[e]=new n),t}getWorkerSource(e,t,r){return this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),this.workerSources[e][t][r]||(this.workerSources[e][t][r]=new this.workerSourceTypes[t]({send:(t,r,n,o,i,s)=>{this.actor.send(t,r,n,e,o,s);},scheduler:this.actor.scheduler},this.getLayerIndex(e),this.getAvailableImages(e))),this.workerSources[e][t][r]}getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new i),this.demWorkerSources[e][t]}enforceCacheSizeLimit(t,r){e.enforceCacheSizeLimit(r);}getWorkerPerformanceMetrics(e,t,r){r(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new ye(self)),ye}));

define(["./shared"],(function(t){"use strict";var e=i;function i(t){return !function(t){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":Array.prototype&&Array.prototype.every&&Array.prototype.filter&&Array.prototype.forEach&&Array.prototype.indexOf&&Array.prototype.lastIndexOf&&Array.prototype.map&&Array.prototype.some&&Array.prototype.reduce&&Array.prototype.reduceRight&&Array.isArray?Function.prototype&&Function.prototype.bind?Object.keys&&Object.create&&Object.getPrototypeOf&&Object.getOwnPropertyNames&&Object.isSealed&&Object.isFrozen&&Object.isExtensible&&Object.getOwnPropertyDescriptor&&Object.defineProperty&&Object.defineProperties&&Object.seal&&Object.freeze&&Object.preventExtensions?"JSON"in window&&"parse"in JSON&&"stringify"in JSON?function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var t,e,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{e=new Worker(o),t=!0;}catch(e){t=!1;}return e&&e.terminate(),URL.revokeObjectURL(o),t}()?"Uint8ClampedArray"in window?ArrayBuffer.isView?function(){var t=document.createElement("canvas");t.width=t.height=1;var e=t.getContext("2d");if(!e)return !1;var i=e.getImageData(0,0,1,1);return i&&i.width===t.width}()?(void 0===o[e=t&&t.failIfMajorPerformanceCaveat]&&(o[e]=function(t){var e,o=function(t){var e=document.createElement("canvas"),o=Object.create(i.webGLContextAttributes);return o.failIfMajorPerformanceCaveat=t,e.getContext("webgl",o)||e.getContext("experimental-webgl",o)}(t);if(!o)return !1;try{e=o.createShader(o.VERTEX_SHADER);}catch(t){return !1}return !(!e||o.isContextLost())&&(o.shaderSource(e,"void main() {}"),o.compileShader(e),!0===o.getShaderParameter(e,o.COMPILE_STATUS))}(e)),o[e]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL support"):"insufficient Canvas/getImageData support":"insufficient ArrayBuffer support":"insufficient Uint8ClampedArray support":"insufficient worker support":"insufficient JSON support":"insufficient Object support":"insufficient Function support":"insufficent Array support";var e;}(t)}var o={};i.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const a={create:function(e,i,o){const a=t.window.document.createElement(e);return void 0!==i&&(a.className=i),o&&o.appendChild(a),a},createNS:function(e,i){return t.window.document.createElementNS(e,i)}},r=t.window.document&&t.window.document.documentElement.style,n=r&&void 0!==r.userSelect?"userSelect":"WebkitUserSelect";let s;a.disableDrag=function(){r&&n&&(s=r[n],r[n]="none");},a.enableDrag=function(){r&&n&&(r[n]=s);},a.setTransform=function(t,e){t.style.transform=e;};let l=!1;try{const e=Object.defineProperty({},"passive",{get(){l=!0;}});t.window.addEventListener("test",e,e),t.window.removeEventListener("test",e,e);}catch(t){l=!1;}a.addEventListener=function(t,e,i,o={}){t.addEventListener(e,i,"passive"in o&&l?o:o.capture);},a.removeEventListener=function(t,e,i,o={}){t.removeEventListener(e,i,"passive"in o&&l?o:o.capture);};const c=function(e){e.preventDefault(),e.stopPropagation(),t.window.removeEventListener("click",c,!0);};function h(t){const{userImage:e}=t;return !!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}a.suppressClick=function(){t.window.addEventListener("click",c,!0),t.window.setTimeout(()=>{t.window.removeEventListener("click",c,!0);},0);},a.mousePos=function(e,i){const o=e.getBoundingClientRect();return new t.Point(i.clientX-o.left-e.clientLeft,i.clientY-o.top-e.clientTop)},a.touchPos=function(e,i){const o=e.getBoundingClientRect(),a=[];for(let r=0;r<i.length;r++)a.push(new t.Point(i[r].clientX-o.left-e.clientLeft,i[r].clientY-o.top-e.clientTop));return a},a.mouseButton=function(e){return void 0!==t.window.InstallTrigger&&2===e.button&&e.ctrlKey&&t.window.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:e.button},a.remove=function(t){t.parentNode&&t.parentNode.removeChild(t);};class u extends t.Evented{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new t.RGBAImage({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,callback:e}of this.requestors)this._notify(t,e);this.requestors=[];}}getImage(t){return this.images[t]}addImage(t,e){this._validate(t,e)&&(this.images[t]=e);}_validate(e,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new t.ErrorEvent(new Error(`Image "${e}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new t.ErrorEvent(new Error(`Image "${e}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new t.ErrorEvent(new Error(`Image "${e}" has invalid "content" value`))),o=!1),o}_validateStretch(t,e){if(!t)return !0;let i=0;for(const o of t){if(o[0]<i||o[1]<o[0]||e<o[1])return !1;i=o[1];}return !0}_validateContent(t,e){return !(t&&(4!==t.length||t[0]<0||e.data.width<t[0]||t[1]<0||e.data.height<t[1]||t[2]<0||e.data.width<t[2]||t[3]<0||e.data.height<t[3]||t[2]<t[0]||t[3]<t[1]))}updateImage(t,e){e.version=this.images[t].version+1,this.images[t]=e,this.updatedImages[t]=!0;}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(t,e){let i=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(i=!1);this.isLoaded()||i?this._notify(t,e):this.requestors.push({ids:t,callback:e});}_notify(e,i){const o={};for(const i of e){this.images[i]||this.fire(new t.Event("styleimagemissing",{id:i}));const e=this.images[i];e?o[i]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:t.warnOnce(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}i(null,o);}getPixelSize(){const{width:t,height:e}=this.atlasImage;return {width:t,height:e}}getPattern(e){const i=this.patterns[e],o=this.getImage(e);if(!o)return null;if(i&&i.position.version===o.version)return i.position;if(i)i.position.version=o.version;else {const i={w:o.data.width+2,h:o.data.height+2,x:0,y:0},a=new t.ImagePosition(i,o);this.patterns[e]={bin:i,position:a};}return this._updatePatternAtlas(),this.patterns[e].position}bind(e){const i=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new t.Texture(e,this.atlasImage,i.RGBA),this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:i,h:o}=t.potpack(e),a=this.atlasImage;a.resize({width:i||1,height:o||1});for(const e in this.patterns){const{bin:i}=this.patterns[e],o=i.x+1,r=i.y+1,n=this.images[e].data,s=n.width,l=n.height;t.RGBAImage.copy(n,a,{x:0,y:0},{x:o,y:r},{width:s,height:l}),t.RGBAImage.copy(n,a,{x:0,y:l-1},{x:o,y:r-1},{width:s,height:1}),t.RGBAImage.copy(n,a,{x:0,y:0},{x:o,y:r+l},{width:s,height:1}),t.RGBAImage.copy(n,a,{x:s-1,y:0},{x:o-1,y:r},{width:1,height:l}),t.RGBAImage.copy(n,a,{x:0,y:0},{x:o+s,y:r},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(t){for(const e of t){if(this.callbackDispatchedThisFrame[e])continue;this.callbackDispatchedThisFrame[e]=!0;const t=this.images[e];h(t)&&this.updateImage(e,t);}}}var d=p,_=p,m=1e20;function p(t,e,i,o,a,r){this.fontSize=t||24,this.buffer=void 0===e?3:e,this.cutoff=o||.25,this.fontFamily=a||"sans-serif",this.fontWeight=r||"normal",this.radius=i||8;var n=this.size=this.fontSize+2*this.buffer;this.canvas=document.createElement("canvas"),this.canvas.width=this.canvas.height=n,this.ctx=this.canvas.getContext("2d"),this.ctx.font=this.fontWeight+" "+this.fontSize+"px "+this.fontFamily,this.ctx.textBaseline="middle",this.ctx.fillStyle="black",this.gridOuter=new Float64Array(n*n),this.gridInner=new Float64Array(n*n),this.f=new Float64Array(n),this.d=new Float64Array(n),this.z=new Float64Array(n+1),this.v=new Int16Array(n),this.middle=Math.round(n/2*(navigator.userAgent.indexOf("Gecko/")>=0?1.2:1));}function f(t,e,i,o,a,r,n){for(var s=0;s<e;s++){for(var l=0;l<i;l++)o[l]=t[l*e+s];for(g(o,a,r,n,i),l=0;l<i;l++)t[l*e+s]=a[l];}for(l=0;l<i;l++){for(s=0;s<e;s++)o[s]=t[l*e+s];for(g(o,a,r,n,e),s=0;s<e;s++)t[l*e+s]=Math.sqrt(a[s]);}}function g(t,e,i,o,a){i[0]=0,o[0]=-m,o[1]=+m;for(var r=1,n=0;r<a;r++){for(var s=(t[r]+r*r-(t[i[n]]+i[n]*i[n]))/(2*r-2*i[n]);s<=o[n];)n--,s=(t[r]+r*r-(t[i[n]]+i[n]*i[n]))/(2*r-2*i[n]);i[++n]=r,o[n]=s,o[n+1]=+m;}for(r=0,n=0;r<a;r++){for(;o[n+1]<r;)n++;e[r]=(r-i[n])*(r-i[n])+t[i[n]];}}p.prototype.draw=function(t){this.ctx.clearRect(0,0,this.size,this.size),this.ctx.fillText(t,this.buffer,this.middle);for(var e=this.ctx.getImageData(0,0,this.size,this.size),i=new Uint8ClampedArray(this.size*this.size),o=0;o<this.size*this.size;o++){var a=e.data[4*o+3]/255;this.gridOuter[o]=1===a?0:0===a?m:Math.pow(Math.max(0,.5-a),2),this.gridInner[o]=1===a?m:0===a?0:Math.pow(Math.max(0,a-.5),2);}for(f(this.gridOuter,this.size,this.size,this.f,this.d,this.v,this.z),f(this.gridInner,this.size,this.size,this.f,this.d,this.v,this.z),o=0;o<this.size*this.size;o++)i[o]=Math.max(0,Math.min(255,Math.round(255-255*((this.gridOuter[o]-this.gridInner[o])/this.radius+this.cutoff))));return i},d.default=_;class v{constructor(t,e){this.requestManager=t,this.localIdeographFontFamily=e,this.entries={};}setURL(t){this.url=t;}getGlyphs(e,i){const o=[];for(const t in e)for(const i of e[t])o.push({stack:t,id:i});t.asyncAll(o,({stack:t,id:e},i)=>{let o=this.entries[t];o||(o=this.entries[t]={glyphs:{},requests:{},ranges:{}});let a=o.glyphs[e];if(void 0!==a)return void i(null,{stack:t,id:e,glyph:a});if(a=this._tinySDF(o,t,e),a)return o.glyphs[e]=a,void i(null,{stack:t,id:e,glyph:a});const r=Math.floor(e/256);if(256*r>65535)return void i(new Error("glyphs > 65535 not supported"));if(o.ranges[r])return void i(null,{stack:t,id:e,glyph:a});let n=o.requests[r];n||(n=o.requests[r]=[],v.loadGlyphRange(t,r,this.url,this.requestManager,(t,e)=>{if(e){for(const t in e)this._doesCharSupportLocalGlyph(+t)||(o.glyphs[+t]=e[+t]);o.ranges[r]=!0;}for(const i of n)i(t,e);delete o.requests[r];})),n.push((o,a)=>{o?i(o):a&&i(null,{stack:t,id:e,glyph:a[e]||null});});},(t,e)=>{if(t)i(t);else if(e){const t={};for(const{stack:i,id:o,glyph:a}of e)(t[i]||(t[i]={}))[o]=a&&{id:a.id,bitmap:a.bitmap.clone(),metrics:a.metrics};i(null,t);}});}_doesCharSupportLocalGlyph(e){return !!this.localIdeographFontFamily&&(t.isChar["CJK Unified Ideographs"](e)||t.isChar["Hangul Syllables"](e)||t.isChar.Hiragana(e)||t.isChar.Katakana(e))}_tinySDF(e,i,o){const a=this.localIdeographFontFamily;if(!a)return;if(!this._doesCharSupportLocalGlyph(o))return;let r=e.tinySDF;if(!r){let t="400";/bold/i.test(i)?t="900":/medium/i.test(i)?t="500":/light/i.test(i)&&(t="200"),r=e.tinySDF=new v.TinySDF(24,3,8,.25,a,t);}return {id:o,bitmap:new t.AlphaImage({width:30,height:30},r.draw(String.fromCharCode(o))),metrics:{width:24,height:24,left:0,top:-8,advance:24}}}}v.loadGlyphRange=function(e,i,o,a,r){const n=256*i,s=n+255,l=a.transformRequest(a.normalizeGlyphsURL(o).replace("{fontstack}",e).replace("{range}",`${n}-${s}`),t.ResourceType.Glyphs);t.getArrayBuffer(l,(e,i)=>{if(e)r(e);else if(i){const e={};for(const o of t.parseGlyphPBF(i))e[o.id]=o;r(null,e);}});},v.TinySDF=d;const x=new t.Properties({anchor:new t.DataConstantProperty(t.styleSpec.light.anchor),position:new class{constructor(){this.specification=t.styleSpec.light.position;}possiblyEvaluate(e,i){return function([e,i,o]){const a=t.degToRad(i+90),r=t.degToRad(o);return {x:e*Math.cos(a)*Math.sin(r),y:e*Math.sin(a)*Math.sin(r),z:e*Math.cos(r),azimuthal:i,polar:o}}(e.expression.evaluate(i))}interpolate(e,i,o){return {x:t.number(e.x,i.x,o),y:t.number(e.y,i.y,o),z:t.number(e.z,i.z,o),azimuthal:t.number(e.azimuthal,i.azimuthal,o),polar:t.number(e.polar,i.polar,o)}}},color:new t.DataConstantProperty(t.styleSpec.light.color),intensity:new t.DataConstantProperty(t.styleSpec.light.intensity)});class y extends t.Evented{constructor(e){super(),this._transitionable=new t.Transitionable(x),this.setLight(e),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,i={}){if(!this._validate(t.validateLight,e,i))for(const i in e){const o=e[i];t.endsWith(i,"-transition")?this._transitionable.setTransition(i.slice(0,-"-transition".length),o):this._transitionable.setValue(i,o);}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t);}_validate(e,i,o){return (!o||!1!==o.validate)&&t.emitValidationErrors(this,e.call(t.validateStyle,t.extend({value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.styleSpec})))}}const b=new t.Properties({source:new t.DataConstantProperty(t.styleSpec.terrain.source),exaggeration:new t.DataConstantProperty(t.styleSpec.terrain.exaggeration)});class w extends t.Evented{constructor(e){super(),this._transitionable=new t.Transitionable(b),this.set(e),this._transitioning=this._transitionable.untransitioned();}get(){return this._transitionable.serialize()}set(e){for(const i in e){const o=e[i];t.endsWith(i,"-transition")?this._transitionable.setTransition(i.slice(0,-"-transition".length),o):this._transitionable.setValue(i,o);}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t);}}class T{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const o=[];let a=t.length%2==1?-t[t.length-1]*i:0,r=t[0]*i,n=!0;o.push({left:a,right:r,isDash:n,zeroLength:0===t[0]});let s=t[0];for(let e=1;e<t.length;e++){n=!n;const l=t[e];a=s*i,s+=l,r=s*i,o.push({left:a,right:r,isDash:n,zeroLength:0===l});}return o}addRoundDash(t,e,i){const o=e/2;for(let e=-i;e<=i;e++){const a=this.width*(this.nextRow+i+e);let r=0,n=t[r];for(let s=0;s<this.width;s++){s/n.right>1&&(n=t[++r]);const l=Math.abs(s-n.left),c=Math.abs(s-n.right),h=Math.min(l,c);let u;const d=e/i*(o+1);if(n.isDash){const t=o-Math.abs(d);u=Math.sqrt(h*h+t*t);}else u=o-Math.sqrt(h*h+d*d);this.data[a+s]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],o=t[e+1];i.zeroLength?t.splice(e,1):o&&o.isDash===i.isDash&&(o.left=i.left,t.splice(e,1));}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const o=this.width*this.nextRow;let a=0,r=t[a];for(let e=0;e<this.width;e++){e/r.right>1&&(r=t[++a]);const i=Math.abs(e-r.left),n=Math.abs(e-r.right),s=Math.min(i,n);this.data[o+e]=Math.max(0,Math.min(255,(r.isDash?s:-s)+128));}}addDash(e,i){const o=i?7:0,a=2*o+1;if(this.nextRow+a>this.height)return t.warnOnce("LineAtlas out of space"),null;0===e.length&&e.push(1);let r=0;for(let i=0;i<e.length;i++)e[i]<0&&(t.warnOnce("Negative value is found in line dasharray, replacing values with 0"),e[i]=0),r+=e[i];if(0!==r){const t=this.width/r,a=this.getDashRanges(e,this.width,t);i?this.addRoundDash(a,t,o):this.addRegularDash(a);}const n={y:(this.nextRow+o+.5)/this.height,height:2*o/this.height,width:r};return this.nextRow+=a,this.dirty=!0,n}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data));}}class E{constructor(e,i){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=t.uniqueId();const o=this.workerPool.acquire(this.id);for(let t=0;t<o.length;t++){const e=new E.Actor(o[t],i,this.id);e.name=`Worker ${t}`,this.actors.push(e);}this.ready=!1,this.broadcast("checkIfReady",null,()=>{this.ready=!0;});}broadcast(e,i,o){t.asyncAll(this.actors,(t,o)=>{t.send(e,i,o);},o=o||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach(t=>{t.remove();}),this.actors=[],this.workerPool.release(this.id);}}function C(e,i,o){return i*(t.EXTENT/(e.tileSize*Math.pow(2,o-e.tileID.overscaledZ)))}E.Actor=t.Actor;class S{constructor(t,e,i,o){this.screenBounds=t,this.cameraPoint=e,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this.screenGeometry.map(t=>o.pointCoordinate3D(t)),this.cameraGeometry=this.bufferedCameraGeometry(0);}static createFromScreenPoints(e,i){let o,a;if(e instanceof t.Point||"number"==typeof e[0]){const r=t.Point.convert(e);o=[t.Point.convert(e)],a=i.isPointAboveHorizon(r);}else {const r=t.Point.convert(e[0]),n=t.Point.convert(e[1]);o=[r,n],a=t.polygonizeBounds(r,n).every(t=>i.isPointAboveHorizon(t));}return new S(o,i.getCameraPoint(),a,i)}bufferedScreenGeometry(e){return t.polygonizeBounds(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],e)}bufferedCameraGeometry(e){const i=[this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0].add(new t.Point(1,0)):this.screenBounds[1],this.cameraPoint];return t.bufferConvexPolygon(i,e)}containsTile(e,i,o){const a=e.queryPadding+1,r=o?this._bufferedCameraMercator(a,i).map(t=>e.tileID.getTilePoint(t)):this._bufferedScreenMercator(a,i).map(t=>e.tileID.getTilePoint(t)),n=this.screenGeometryMercator.map(t=>e.tileID.getTileVec3(t)),s=n.map(e=>new t.Point(e[0],e[1])),l=i.getFreeCameraOptions().position||new t.MercatorCoordinate(0,0,0),c=e.tileID.getTileVec3(l),h=n.map(e=>{const i=t.sub(e,e,c);return t.normalize(i,i),new t.Ray(c,i)}),u=C(e,1,i.zoom);if(t.polygonIntersectsBox(r,0,0,t.EXTENT,t.EXTENT))return {queryGeometry:this,tilespaceGeometry:s,tilespaceRays:h,bufferedTilespaceGeometry:r,bufferedTilespaceBounds:(d=t.getBounds(r),d.min.x=t.clamp(d.min.x,0,t.EXTENT),d.min.y=t.clamp(d.min.y,0,t.EXTENT),d.max.x=t.clamp(d.max.x,0,t.EXTENT),d.max.y=t.clamp(d.max.y,0,t.EXTENT),d),tile:e,tileID:e.tileID,pixelToTileUnitsFactor:u};var d;}_bufferedScreenMercator(t,e){const i=I(t);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{const o=this.bufferedScreenGeometry(t).map(t=>e.pointCoordinate3D(t));return this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(t,e){const i=I(t);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{const o=this.bufferedCameraGeometry(t).map(t=>e.pointCoordinate3D(t));return this._cameraRaycastCache[i]=o,o}}}function I(t){return 100*t|0}function P(e,i,o){const a=function(a,r){if(a)return o(a);if(r){const a=t.pick(t.extend(r,e),["tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);r.vector_layers&&(a.vectorLayers=r.vector_layers,a.vectorLayerIds=a.vectorLayers.map(t=>t.id)),a.tiles=i.canonicalizeTileset(a,e.url),o(null,a);}};return e.url?t.getJSON(i.transformRequest(i.normalizeSourceURL(e.url),t.ResourceType.Source),a):t.browser.frame(()=>a(null,e))}class M{constructor(e,i,o){this.bounds=t.LngLatBounds.convert(this.validateBounds(e)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(e){const i=Math.pow(2,e.z),o=Math.floor(t.mercatorXfromLng(this.bounds.getWest())*i),a=Math.floor(t.mercatorYfromLat(this.bounds.getNorth())*i),r=Math.ceil(t.mercatorXfromLng(this.bounds.getEast())*i),n=Math.ceil(t.mercatorYfromLat(this.bounds.getSouth())*i);return e.x>=o&&e.x<r&&e.y>=a&&e.y<n}}class z extends t.Evented{constructor(e,i,o,a){super(),this.id=e,this.dispatcher=o,this.setEventedParent(a),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=t.extend({type:"raster"},i),t.extend(this,t.pick(i,["url","scheme","tileSize"]));}load(){this._loaded=!1,this.fire(new t.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=P(this._options,this.map._requestManager,(e,i)=>{this._tileJSONRequest=null,this._loaded=!0,e?this.fire(new t.ErrorEvent(e)):i&&(t.extend(this,i),i.bounds&&(this.tileBounds=new M(i.bounds,this.minzoom,this.maxzoom)),t.postTurnstileEvent(i.tiles),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"content"})));});}loaded(){return this._loaded}onAdd(t){this.map=t,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}serialize(){return t.extend({},this._options)}hasTile(t){return !this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(e,i){const o=t.browser.devicePixelRatio>=2,a=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);e.request=t.getImage(this.map._requestManager.transformRequest(a,t.ResourceType.Tile),(o,a)=>{if(delete e.request,e.aborted)e.state="unloaded",i(null);else if(o)e.state="errored",i(o);else if(a){this.map._refreshExpiredTiles&&e.setExpiryData(a),delete a.cacheControl,delete a.expires;const o=this.map.painter.context,r=o.gl;e.texture=this.map.painter.getTileTexture(a.width),e.texture?e.texture.update(a,{useMipmap:!0}):(e.texture=new t.Texture(o,a,r.RGBA,{useMipmap:!0}),e.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST),o.extTextureFilterAnisotropic&&r.texParameterf(r.TEXTURE_2D,o.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,o.extTextureFilterAnisotropicMax)),e.state="loaded",t.cacheEntryPossiblyAdded(this.dispatcher),i(null);}});}abortTile(t,e){t.request&&(t.request.cancel(),delete t.request),e();}unloadTile(t,e){t.texture&&this.map.painter.saveTileTexture(t.texture),e();}hasTransition(){return !1}}var A=t.createLayout([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class D extends t.Evented{constructor(t,e,i,o){super(),this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(o),this.options=e;}load(e,i){this._loaded=!1,this.fire(new t.Event("dataloading",{dataType:"source"})),this.url=this.options.url,t.getImage(this.map._requestManager.transformRequest(this.url,t.ResourceType.Image),(o,a)=>{this._loaded=!0,o?this.fire(new t.ErrorEvent(o)):a&&(this.image=a,e&&(this.coordinates=e),i&&i(),this._finishLoading());});}loaded(){return this._loaded}updateImage(t){return this.image&&t.url?(this.options.url=t.url,this.load(t.coordinates,()=>{this.texture=null;}),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}setCoordinates(e){this.coordinates=e;const i=e.map(t.MercatorCoordinate.fromLngLat);this.tileID=function(e){let i=1/0,o=1/0,a=-1/0,r=-1/0;for(const t of e)i=Math.min(i,t.x),o=Math.min(o,t.y),a=Math.max(a,t.x),r=Math.max(r,t.y);const n=Math.max(a-i,r-o),s=Math.max(0,Math.floor(-Math.log(n)/Math.LN2)),l=Math.pow(2,s);return new t.CanonicalTileID(s,Math.floor((i+a)/2*l),Math.floor((o+r)/2*l))}(i),this.minzoom=this.maxzoom=this.tileID.z;const o=i.map(t=>this.tileID.getTilePoint(t)._round());return this._boundsArray=new t.StructArrayLayout4i8,this._boundsArray.emplaceBack(o[0].x,o[0].y,0,0),this._boundsArray.emplaceBack(o[1].x,o[1].y,t.EXTENT,0),this._boundsArray.emplaceBack(o[3].x,o[3].y,0,t.EXTENT),this._boundsArray.emplaceBack(o[2].x,o[2].y,t.EXTENT,t.EXTENT),this.boundsBuffer&&(this.boundsBuffer.destroy(),delete this.boundsBuffer),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,i=e.gl;this.boundsBuffer||(this.boundsBuffer=e.createVertexBuffer(this._boundsArray,A.members)),this.boundsSegments||(this.boundsSegments=t.SegmentVector.simpleSegment(0,0,4,2)),this.texture||(this.texture=new t.Texture(e,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}}loadTile(t,e){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={},e(null)):(t.state="errored",e(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}}const L={vector:class extends t.Evented{constructor(e,i,o,a){if(super(),this.id=e,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,t.extend(this,t.pick(i,["url","scheme","tileSize","promoteId"])),this._options=t.extend({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(a),this._tileWorkers={},this._deduped=new t.DedupedRequest;}load(){this._loaded=!1,this.fire(new t.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=P(this._options,this.map._requestManager,(e,i)=>{this._tileJSONRequest=null,this._loaded=!0,e?this.fire(new t.ErrorEvent(e)):i&&(t.extend(this,i),i.bounds&&(this.tileBounds=new M(i.bounds,this.minzoom,this.maxzoom)),t.postTurnstileEvent(i.tiles,this.map._requestManager._customAccessToken),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"content"})));});}loaded(){return this._loaded}hasTile(t){return !this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load();}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.cancel(),t();const e=this.map.style._getSourceCaches(this.id);for(const t of e)t.clearTiles();this.load();}setTiles(t){return this.setSourceProperty(()=>{this._options.tiles=t;}),this}setUrl(t){return this.setSourceProperty(()=>{this.url=t,this._options.url=t;}),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}serialize(){return t.extend({},this._options)}loadTile(e,i){const o=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme)),a={request:this.map._requestManager.transformRequest(o,t.ResourceType.Tile),data:void 0,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:t.browser.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:e.isSymbolTile};if(a.request.collectResourceTiming=this._collectResourceTiming,e.actor&&"expired"!==e.state)"loading"===e.state?e.reloadCallback=i:e.request=e.actor.send("reloadTile",a,r.bind(this));else if(e.actor=this._tileWorkers[o]=this._tileWorkers[o]||this.dispatcher.getActor(),this.dispatcher.ready)e.request=e.actor.send("loadTile",a,r.bind(this));else {const i=t.loadVectorTile.call({deduped:this._deduped},a,(t,i)=>{t||!i?r.call(this,t):(a.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},e.actor&&e.actor.send("loadTile",a,r.bind(this)));},!0);e.request={cancel:i};}function r(o,a){return delete e.request,e.aborted?i(null):o&&404!==o.status?i(o):(a&&a.resourceTiming&&(e.resourceTiming=a.resourceTiming),this.map._refreshExpiredTiles&&a&&e.setExpiryData(a),e.loadVectorData(a,this.map.painter),t.cacheEntryPossiblyAdded(this.dispatcher),i(null),void(e.reloadCallback&&(this.loadTile(e,e.reloadCallback),e.reloadCallback=null)))}}abortTile(t){t.request&&(t.request.cancel(),delete t.request),t.actor&&t.actor.send("abortTile",{uid:t.uid,type:this.type,source:this.id},void 0);}unloadTile(t){t.unloadVectorData(),t.actor&&t.actor.send("removeTile",{uid:t.uid,type:this.type,source:this.id},void 0);}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}},raster:z,"raster-dem":class extends z{constructor(e,i,o,a){super(e,i,o,a),this.type="raster-dem",this.maxzoom=22,this._options=t.extend({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}serialize(){return {type:"raster-dem",url:this.url,tileSize:this.tileSize,tiles:this.tiles,bounds:this.bounds,encoding:this.encoding}}loadTile(e,i){const o=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function a(t,o){t&&(e.state="errored",i(t)),o&&(e.dem=o,e.dem.onDeserialize(),e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0,e.state="loaded",i(null));}e.request=t.getImage(this.map._requestManager.transformRequest(o,t.ResourceType.Tile),function(o,r){if(delete e.request,e.aborted)e.state="unloaded",i(null);else if(o)e.state="errored",i(o);else if(r){this.map._refreshExpiredTiles&&e.setExpiryData(r),delete r.cacheControl,delete r.expires;const i=t.window.ImageBitmap&&r instanceof t.window.ImageBitmap&&t.offscreenCanvasSupported(),o=1-(r.width-t.prevPowerOfTwo(r.width))/2;o<1||e.neighboringTiles||(e.neighboringTiles=this._getNeighboringTiles(e.tileID));const n=i?r:t.browser.getImageData(r,o),s={uid:e.uid,coord:e.tileID,source:this.id,rawImageData:n,encoding:this.encoding,padding:o};e.actor&&"expired"!==e.state||(e.actor=this.dispatcher.getActor(),e.actor.send("loadDEMTile",s,a.bind(this)));}}.bind(this));}_getNeighboringTiles(e){const i=e.canonical,o=Math.pow(2,i.z),a=(i.x-1+o)%o,r=0===i.x?e.wrap-1:e.wrap,n=(i.x+1+o)%o,s=i.x+1===o?e.wrap+1:e.wrap,l={};return l[new t.OverscaledTileID(e.overscaledZ,r,i.z,a,i.y).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,s,i.z,n,i.y).key]={backfilled:!1},i.y>0&&(l[new t.OverscaledTileID(e.overscaledZ,r,i.z,a,i.y-1).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,e.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,s,i.z,n,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new t.OverscaledTileID(e.overscaledZ,r,i.z,a,i.y+1).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,e.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,s,i.z,n,i.y+1).key]={backfilled:!1}),l}unloadTile(t){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded";}},geojson:class extends t.Evented{constructor(e,i,o,a){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(a),this._data=i.data,this._options=t.extend({},i),this._collectResourceTiming=i.collectResourceTiming,this._resourceTiming=[],void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const r=t.EXTENT/this.tileSize;this.workerOptions=t.extend({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*r,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*r,extent:t.EXTENT,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?Math.min(i.clusterMaxZoom,this.maxzoom-1):this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:t.EXTENT,radius:(i.clusterRadius||50)*r,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions);}load(){this.fire(new t.Event("dataloading",{dataType:"source"})),this._updateWorkerData(e=>{if(e)return void this.fire(new t.ErrorEvent(e));const i={dataType:"source",sourceDataType:"metadata"};this._collectResourceTiming&&this._resourceTiming&&this._resourceTiming.length>0&&(i.resourceTiming=this._resourceTiming,this._resourceTiming=[]),this.fire(new t.Event("data",i));});}onAdd(t){this.map=t,this.load();}setData(e){return this._data=e,this.fire(new t.Event("dataloading",{dataType:"source"})),this._updateWorkerData(e=>{if(e)return void this.fire(new t.ErrorEvent(e));const i={dataType:"source",sourceDataType:"content"};this._collectResourceTiming&&this._resourceTiming&&this._resourceTiming.length>0&&(i.resourceTiming=this._resourceTiming,this._resourceTiming=[]),this.fire(new t.Event("data",i));}),this}getClusterExpansionZoom(t,e){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:t,source:this.id},e),this}getClusterChildren(t,e){return this.actor.send("geojson.getClusterChildren",{clusterId:t,source:this.id},e),this}getClusterLeaves(t,e,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,clusterId:t,limit:e,offset:i},o),this}_updateWorkerData(e){this._loaded=!1;const i=t.extend({},this.workerOptions),o=this._data;"string"==typeof o?(i.request=this.map._requestManager.transformRequest(t.browser.resolveURL(o),t.ResourceType.Source),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(o),this.actor.send(`${this.type}.loadData`,i,(t,o)=>{this._removed||o&&o.abandoned||(this._loaded=!0,o&&o.resourceTiming&&o.resourceTiming[this.id]&&(this._resourceTiming=o.resourceTiming[this.id].slice(0)),this.actor.send(`${this.type}.coalesce`,{source:i.source},null),e(t));});}loaded(){return this._loaded}loadTile(e,i){const o=e.actor?"reloadTile":"loadTile";e.actor=this.actor,e.request=this.actor.send(o,{type:this.type,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:t.browser.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId},(t,a)=>(delete e.request,e.unloadVectorData(),e.aborted?i(null):t?i(t):(e.loadVectorData(a,this.map.painter,"reloadTile"===o),i(null))));}abortTile(t){t.request&&(t.request.cancel(),delete t.request),t.aborted=!0;}unloadTile(t){t.unloadVectorData(),this.actor.send("removeTile",{uid:t.uid,type:this.type,source:this.id});}onRemove(){this._removed=!0,this.actor.send("removeSource",{type:this.type,source:this.id});}serialize(){return t.extend({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends D{constructor(t,e,i,o){super(t,e,i,o),this.roundZoom=!0,this.type="video",this.options=e;}load(){this._loaded=!1;const e=this.options;this.urls=[];for(const i of e.urls)this.urls.push(this.map._requestManager.transformRequest(i,t.ResourceType.Source).url);t.getVideo(this.urls,(e,i)=>{this._loaded=!0,e?this.fire(new t.ErrorEvent(e)):i&&(this.video=i,this.video.loop=!0,this.video.addEventListener("playing",()=>{this.map.triggerRepaint();}),this.map&&this.video.play(),this._finishLoading());});}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(e){if(this.video){const i=this.video.seekable;e<i.start(0)||e>i.end(0)?this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=e;}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,i=e.gl;this.boundsBuffer||(this.boundsBuffer=e.createVertexBuffer(this._boundsArray,A.members)),this.boundsSegments||(this.boundsSegments=t.SegmentVector.simpleSegment(0,0,4,2)),this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new t.Texture(e,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:D,canvas:class extends D{constructor(e,i,o,a){super(e,i,o,a),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some(t=>!Array.isArray(t)||2!==t.length||t.some(t=>"number"!=typeof t))||this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof t.window.HTMLCanvasElement||this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof t.window.HTMLCanvasElement?this.options.canvas:t.window.document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new t.ErrorEvent(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,o=i.gl;this.boundsBuffer||(this.boundsBuffer=i.createVertexBuffer(this._boundsArray,A.members)),this.boundsSegments||(this.boundsSegments=t.SegmentVector.simpleSegment(0,0,4,2)),this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new t.Texture(i,this.canvas,o.RGBA,{premultiply:!0});for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of [this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return !0;return !1}}},R=function(e,i,o,a){const r=new L[i.type](e,i,o,a);if(r.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${r.id}`);return t.bindAll(["load","abort","unload","serialize","prepare"],r),r};function k(e,i){const o=t.identity([]);return t.scale(o,o,[.5*e.width,.5*-e.height,1]),t.translate(o,o,[1,-1,0]),t.multiply(o,o,e.calculatePosMatrix(i.toUnwrapped()))}function B(t,e,i,o,a,r,n,s=!1){const l=t.tilesIn(o,n,s);l.sort(F);const c=[];for(const o of l)c.push({wrappedTileID:o.tile.tileID.wrapped().key,queryResults:o.tile.queryRenderedFeatures(e,i,t._state,o,a,r,k(t.transform,o.tile.tileID),s)});const h=function(t){const e={},i={};for(const o of t){const t=o.queryResults,a=o.wrappedTileID,r=i[a]=i[a]||{};for(const i in t){const o=t[i],a=r[i]=r[i]||{},n=e[i]=e[i]||[];for(const t of o)a[t.featureIndex]||(a[t.featureIndex]=!0,n.push(t));}}return e}(c);for(const e in h)h[e].forEach(e=>{const i=e.feature,o=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=o;});return h}function O(t,e){const i=t.getRenderableIds().map(e=>t.getTileByID(e)),o=[],a={};for(let t=0;t<i.length;t++){const r=i[t],n=r.tileID.canonical.key;a[n]||(a[n]=!0,r.querySourceFeatures(o,e));}return o}function F(t,e){const i=t.tileID,o=e.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function U(){return null!=Ta.workerClass?new Ta.workerClass:new t.window.Worker(Ta.workerUrl)}const N="mapboxgl_preloaded_worker_pool";class Z{constructor(){this.active={};}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<Z.workerCount;)this.workers.push(new U);return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach(t=>{t.terminate();}),this.workers=null);}isPreloaded(){return !!this.active[N]}numActive(){return Object.keys(this.active).length}}let G;function q(){return G||(G=new Z),G}function V(e,i){const o={};for(const t in e)"ref"!==t&&(o[t]=e[t]);return t.refProperties.forEach(t=>{t in i&&(o[t]=i[t]);}),o}function $(t){t=t.slice();const e=Object.create(null);for(let i=0;i<t.length;i++)e[t[i].id]=t[i];for(let i=0;i<t.length;i++)"ref"in t[i]&&(t[i]=V(t[i],e[t[i].ref]));return t}Z.workerCount=2;const j={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain"};function W(t,e,i){i.push({command:j.addSource,args:[t,e[t]]});}function X(t,e,i){e.push({command:j.removeSource,args:[t]}),i[t]=!0;}function H(t,e,i,o){X(t,i,o),W(t,e,i);}function K(e,i,o){let a;for(a in e[o])if(e[o].hasOwnProperty(a)&&"data"!==a&&!t.deepEqual(e[o][a],i[o][a]))return !1;for(a in i[o])if(i[o].hasOwnProperty(a)&&"data"!==a&&!t.deepEqual(e[o][a],i[o][a]))return !1;return !0}function Y(e,i,o,a,r,n){let s;for(s in i=i||{},e=e||{})e.hasOwnProperty(s)&&(t.deepEqual(e[s],i[s])||o.push({command:n,args:[a,s,i[s],r]}));for(s in i)i.hasOwnProperty(s)&&!e.hasOwnProperty(s)&&(t.deepEqual(e[s],i[s])||o.push({command:n,args:[a,s,i[s],r]}));}function J(t){return t.id}function Q(t,e){return t[e.id]=e,t}class tt{constructor(t,e){this.reset(t,e);}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(e){if(1===this.points.length)return this.points[0];e=t.clamp(e,0,1);let i=1,o=this._distances[i];const a=e*this.paddedLength+this.padding;for(;o<a&&i<this._distances.length;)o=this._distances[++i];const r=i-1,n=this._distances[r],s=o-n,l=s>0?(a-n)/s:0;return this.points[r].mult(1-l).add(this.points[i].mult(l))}}class et{constructor(t,e,i){const o=this.boxCells=[],a=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)o.push([]),a.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,o,a){this._forEachCell(e,i,o,a,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(a);}insertCircle(t,e,i,o){this._forEachCell(e-o,i-o,e+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(o);}_insertBoxCell(t,e,i,o,a,r){this.boxCells[a].push(r);}_insertCircleCell(t,e,i,o,a,r){this.circleCells[a].push(r);}_query(t,e,i,o,a,r){if(i<0||t>this.width||o<0||e>this.height)return !a&&[];const n=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=o){if(a)return !0;for(let t=0;t<this.boxKeys.length;t++)n.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],o=this.circles[3*t+2];n.push({key:this.circleKeys[t],x1:e-o,y1:i-o,x2:e+o,y2:i+o});}return r?n.filter(r):n}return this._forEachCell(t,e,i,o,this._queryCell,n,{hitTest:a,seenUids:{box:{},circle:{}}},r),a?n.length>0:n}_queryCircle(t,e,i,o,a){const r=t-i,n=t+i,s=e-i,l=e+i;if(n<0||r>this.width||l<0||s>this.height)return !o&&[];const c=[];return this._forEachCell(r,s,n,l,this._queryCellCircle,c,{hitTest:o,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},a),o?c.length>0:c}query(t,e,i,o,a){return this._query(t,e,i,o,!1,a)}hitTest(t,e,i,o,a){return this._query(t,e,i,o,!0,a)}hitTestCircle(t,e,i,o){return this._queryCircle(t,e,i,!0,o)}_queryCell(t,e,i,o,a,r,n,s){const l=n.seenUids,c=this.boxCells[a];if(null!==c){const a=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(t<=a[c+2]&&e<=a[c+3]&&i>=a[c+0]&&o>=a[c+1]&&(!s||s(this.boxKeys[h]))){if(n.hitTest)return r.push(!0),!0;r.push({key:this.boxKeys[h],x1:a[c],y1:a[c+1],x2:a[c+2],y2:a[c+3]});}}}const h=this.circleCells[a];if(null!==h){const a=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(a[h],a[h+1],a[h+2],t,e,i,o)&&(!s||s(this.circleKeys[c]))){if(n.hitTest)return r.push(!0),!0;{const t=a[h],e=a[h+1],i=a[h+2];r.push({key:this.circleKeys[c],x1:t-i,y1:e-i,x2:t+i,y2:e+i});}}}}}_queryCellCircle(t,e,i,o,a,r,n,s){const l=n.circle,c=n.seenUids,h=this.boxCells[a];if(null!==h){const t=this.bboxes;for(const e of h)if(!c.box[e]){c.box[e]=!0;const i=4*e;if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!s||s(this.boxKeys[e])))return r.push(!0),!0}}const u=this.circleCells[a];if(null!==u){const t=this.circles;for(const e of u)if(!c.circle[e]){c.circle[e]=!0;const i=3*e;if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!s||s(this.circleKeys[e])))return r.push(!0),!0}}}_forEachCell(t,e,i,o,a,r,n,s){const l=this._convertToXCellCoord(t),c=this._convertToYCellCoord(e),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(o);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(a.call(this,t,e,i,o,this.xCellCount*l+d,r,n,s))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,o,a,r){const n=o-t,s=a-e,l=i+r;return l*l>n*n+s*s}_circleAndRectCollide(t,e,i,o,a,r,n){const s=(r-o)/2,l=Math.abs(t-(o+s));if(l>s+i)return !1;const c=(n-a)/2,h=Math.abs(e-(a+c));if(h>c+i)return !1;if(l<=s||h<=c)return !0;const u=l-s,d=h-c;return u*u+d*d<=i*i}}function it(e,i,o,a,r){const n=t.create();return i?(t.scale(n,n,[1/r,1/r,1]),o||t.rotateZ(n,n,a.angle)):t.multiply(n,a.labelPlaneMatrix,e),n}function ot(e,i,o,a,r){if(i){const i=t.clone(e);return t.scale(i,i,[r,r,1]),o||t.rotateZ(i,i,-a.angle),i}return a.glCoordMatrix}function at(e,i,o=0){const a=[e.x,e.y,o,1];o?t.transformMat4(a,a,i):pt(a,a,i);const r=a[3];return {point:new t.Point(a[0]/r,a[1]/r),signedDistanceFromCamera:r}}function rt(t,e){return Math.min(.5+t/e*.5,1.5)}function nt(t,e){const i=t[0]/t[3],o=t[1]/t[3];return i>=-e[0]&&i<=e[0]&&o>=-e[1]&&o<=e[1]}function st(e,i,o,a,r,n,s,l,c){const h=a?e.textSizeData:e.iconSizeData,u=t.evaluateSizeForZoom(h,o.transform.zoom),d=[256/o.width*2+1,256/o.height*2+1],_=a?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;_.clear();const m=e.lineVertexArray,p=a?e.text.placedSymbolArray:e.icon.placedSymbolArray,f=o.transform.width/o.transform.height;let g=!1;for(let a=0;a<p.length;a++){const v=p.get(a);if(v.hidden||v.writingMode===t.WritingMode.vertical&&!g){mt(v.numGlyphs,_);continue}g=!1;const x=c?c({x:v.anchorX,y:v.anchorY}):0,y=[v.anchorX,v.anchorY,x,1];if(t.transformMat4(y,y,i),!nt(y,d)){mt(v.numGlyphs,_);continue}const b=rt(o.transform.cameraToCenterDistance,y[3]),w=t.evaluateSizeForFeature(h,u,v),T=s?w/b:w*b,E=new t.Point(v.anchorX,v.anchorY),C=at(E,r,x);if(C.signedDistanceFromCamera<=0){mt(v.numGlyphs,_);continue}const S=C.point;let I={};const P=s?null:c,M=ht(v,T,!1,l,i,r,n,e.glyphOffsetArray,m,_,S,E,I,f,P);g=M.useVertical,P&&M.needsFlipping&&(I={}),(M.notEnoughRoom||g||M.needsFlipping&&ht(v,T,!0,l,i,r,n,e.glyphOffsetArray,m,_,S,E,I,f,P).notEnoughRoom)&&mt(v.numGlyphs,_);}a?e.text.dynamicLayoutVertexBuffer.updateData(_):e.icon.dynamicLayoutVertexBuffer.updateData(_);}function lt(t,e,i,o,a,r,n,s,l,c,h,u,d){const _=s.glyphStartIndex+s.numGlyphs,m=s.lineStartIndex,p=s.lineStartIndex+s.lineLength,f=e.getoffsetX(s.glyphStartIndex),g=e.getoffsetX(_-1),v=dt(t*f,i,o,a,r,n,s.segment,m,p,l,c,h,u,d,!0);if(!v)return null;const x=dt(t*g,i,o,a,r,n,s.segment,m,p,l,c,h,u,d,!0);return x?{first:v,last:x}:null}function ct(e,i,o,a){return e===t.WritingMode.horizontal&&Math.abs(o.y-i.y)>Math.abs(o.x-i.x)*a?{useVertical:!0}:(e===t.WritingMode.vertical?i.y<o.y:i.x>o.x)?{needsFlipping:!0}:null}function ht(e,i,o,a,r,n,s,l,c,h,u,d,_,m,p){const f=i/24,g=e.lineOffsetX*f,v=e.lineOffsetY*f;let x;if(e.numGlyphs>1){const t=e.glyphStartIndex+e.numGlyphs,i=e.lineStartIndex,r=e.lineStartIndex+e.lineLength,h=lt(f,l,g,v,o,u,d,e,c,n,_,p);if(!h)return {notEnoughRoom:!0};const y=at(h.first.point,s).point,b=at(h.last.point,s).point;if(a&&!o){const t=ct(e.writingMode,y,b,m);if(t)return t}x=[h.first];for(let a=e.glyphStartIndex+1;a<t-1;a++)x.push(dt(f*l.getoffsetX(a),g,v,o,u,d,e.segment,i,r,c,n,_,p));x.push(h.last);}else {if(a&&!o){const i=at(d,r).point,o=e.lineStartIndex+e.segment+1,a=new t.Point(c.getx(o),c.gety(o)),n=at(a,r),s=n.signedDistanceFromCamera>0?n.point:ut(d,a,i,1,r),l=ct(e.writingMode,i,s,m);if(l)return l}const i=dt(f*l.getoffsetX(e.glyphStartIndex),g,v,o,u,d,e.segment,e.lineStartIndex,e.lineStartIndex+e.lineLength,c,n,_,p);if(!i)return {notEnoughRoom:!0};x=[i];}for(const e of x)t.addDynamicAttributes(h,e.point,e.angle);return {}}function ut(t,e,i,o,a,r){const n=t.add(t.sub(e)._unit()),s=at(n,a,r?r(n):0).point,l=i.sub(s);return i.add(l._mult(o/l.mag()))}function dt(e,i,o,a,r,n,s,l,c,h,u,d,_,m,p){const f=a?e-i:e+i;let g=f>0?1:-1,v=0;a&&(g*=-1,v=Math.PI),g<0&&(v+=Math.PI);let x=g>0?l+s:l+s+1,y=r,b=r,w=0,T=0;const E=Math.abs(f),C=[],S=[];let I=n;const P=()=>{const e=x-g;return 0===w?n:new t.Point(h.getx(e),h.gety(e))},M=()=>ut(P(),I,b,E-w+1,u,_);for(;w+T<=E;){if(x+=g,x<l||x>=c)return null;if(b=y,C.push(y),m&&S.push(I||P()),y=d[x],void 0===y){I=new t.Point(h.getx(x),h.gety(x));const e=at(I,u,_?_(I):0);y=e.signedDistanceFromCamera>0?d[x]=e.point:M();}else I=null;w+=T,T=b.dist(y);}p&&_&&(I=I||new t.Point(h.getx(x),h.gety(x)),d[x]=y=void 0===d[x]?y:M(),T=b.dist(y));const z=(E-w)/T,A=y.sub(b),D=A.mult(z)._add(b);o&&D._add(A._unit()._perp()._mult(o*g));const L=v+Math.atan2(y.y-b.y,y.x-b.x);return C.push(D),m&&(I=I||new t.Point(h.getx(x),h.gety(x)),S.push(function(e,i,o){const a=1-o;return new t.Point(e.x*a+i.x*o,e.y*a+i.y*o)}(S.length>0?S[S.length-1]:I,I,z))),{point:D,angle:L,path:C,tilePath:S}}const _t=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function mt(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(_t,3*t);}}function pt(t,e,i){const o=e[0],a=e[1];return t[0]=i[0]*o+i[4]*a+i[12],t[1]=i[1]*o+i[5]*a+i[13],t[3]=i[3]*o+i[7]*a+i[15],t}class ft{constructor(t,e=new et(t.width+200,t.height+200,25),i=new et(t.width+200,t.height+200,25)){this.transform=t,this.grid=e,this.ignoredGrid=i,this.pitchfactor=Math.cos(t._pitch)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+100,this.screenBottomBoundary=t.height+100,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200;}placeCollisionBox(t,e,i,o,a,r,n){const s=this.projectAndGetPerspectiveRatio(r,e.anchorPointX,e.anchorPointY,e.elevation),l=a*s.perspectiveRatio,c=(e.x1*t+i.x-e.padding)*l+s.point.x,h=(e.y1*t+i.y-e.padding)*l+s.point.y,u=(e.x2*t+i.x+e.padding)*l+s.point.x,d=(e.y2*t+i.y+e.padding)*l+s.point.y,_=s.perspectiveRatio<=.55;return !this.isInsideGrid(c,h,u,d)||!o&&this.grid.hitTest(c,h,u,d,n)||_?{box:[],offscreen:!1}:{box:[c,h,u,d],offscreen:this.isOffscreen(c,h,u,d)}}placeCollisionCircles(e,i,o,a,r,n,s,l,c,h,u,d,_,m){const p=[],f=this.transform.elevation,g=f?t=>f.getAtTileOffset(m,t.x,t.y):t=>0,v=new t.Point(i.anchorX,i.anchorY),x=g(v),y=at(v,n,x),b=rt(this.transform.cameraToCenterDistance,y.signedDistanceFromCamera),w=(h?r/b:r*b)/t.ONE_EM,T=at(v,s,x).point,E=y.signedDistanceFromCamera>0?lt(w,a,i.lineOffsetX*w,i.lineOffsetY*w,!1,T,v,i,o,s,{},f&&!h?g:null,h&&!!f):null;let C=!1,S=!1,I=!0;if(E){const i=.5*d*b+_,o=new t.Point(-100,-100),a=new t.Point(this.screenRightBoundary,this.screenBottomBoundary),r=new tt,n=E.first,s=E.last;let h=[];for(let t=n.path.length-1;t>=1;t--)h.push(n.path[t]);for(let t=1;t<s.path.length;t++)h.push(s.path[t]);const m=2.5*i;if(l){const t=h.map(f?(t,e)=>{const i=g(e<n.path.length-1?n.tilePath[n.path.length-1-e]:s.tilePath[e-n.path.length+2]);return at(t,l,i)}:t=>at(t,l));h=t.some(t=>t.signedDistanceFromCamera<=0)?[]:t.map(t=>t.point);}let v=[];if(h.length>0){const e=h[0].clone(),i=h[0].clone();for(let t=1;t<h.length;t++)e.x=Math.min(e.x,h[t].x),e.y=Math.min(e.y,h[t].y),i.x=Math.max(i.x,h[t].x),i.y=Math.max(i.y,h[t].y);v=e.x>=o.x&&i.x<=a.x&&e.y>=o.y&&i.y<=a.y?[h]:i.x<o.x||e.x>a.x||i.y<o.y||e.y>a.y?[]:t.clipLine([h],o.x,o.y,a.x,a.y);}for(const t of v){r.reset(t,.25*i);let o=0;o=r.length<=.5*i?1:Math.ceil(r.paddedLength/m)+1;for(let t=0;t<o;t++){const a=t/Math.max(o-1,1),n=r.lerp(a),s=n.x+100,l=n.y+100;p.push(s,l,i,0);const h=s-i,d=l-i,_=s+i,m=l+i;if(I=I&&this.isOffscreen(h,d,_,m),S=S||this.isInsideGrid(h,d,_,m),!e&&this.grid.hitTestCircle(s,l,i,u)&&(C=!0,!c))return {circles:[],offscreen:!1,collisionDetected:C}}}}return {circles:!c&&C||!S?[]:p,offscreen:I,collisionDetected:C}}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,a=1/0,r=-1/0,n=-1/0;for(const s of e){const e=new t.Point(s.x+100,s.y+100);o=Math.min(o,e.x),a=Math.min(a,e.y),r=Math.max(r,e.x),n=Math.max(n,e.y),i.push(e);}const s=this.grid.query(o,a,r,n).concat(this.ignoredGrid.query(o,a,r,n)),l={},c={};for(const e of s){const o=e.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const a=[new t.Point(e.x1,e.y1),new t.Point(e.x2,e.y1),new t.Point(e.x2,e.y2),new t.Point(e.x1,e.y2)];t.polygonIntersectsPolygon(i,a)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(t,e,i,o,a){(e?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:a},t[0],t[1],t[2],t[3]);}insertCollisionCircles(t,e,i,o,a){const r=e?this.ignoredGrid:this.grid,n={bucketInstanceId:i,featureIndex:o,collisionGroupID:a};for(let e=0;e<t.length;e+=4)r.insertCircle(n,t[e],t[e+1],t[e+2]);}projectAndGetPerspectiveRatio(e,i,o,a){const r=[i,o,0,1];return a?(r[2]=a,t.transformMat4(r,r,e)):pt(r,r,e),{point:new t.Point((r[0]/r[3]+1)/2*this.transform.width+100,(-r[1]/r[3]+1)/2*this.transform.height+100),perspectiveRatio:Math.min(.5+this.transform.cameraToCenterDistance/r[3]*.5,1.5)}}isOffscreen(t,e,i,o){return i<100||t>=this.screenRightBoundary||o<100||e>this.screenBottomBoundary}isInsideGrid(t,e,i,o){return i>=0&&t<this.gridRightBoundary&&o>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const e=t.identity([]);return t.translate(e,e,[-100,-100,0]),e}}class gt{constructor(t,e,i,o){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class vt{constructor(t,e,i,o,a){this.text=new gt(t?t.text:null,e,i,a),this.icon=new gt(t?t.icon:null,e,o,a);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class xt{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i;}}class yt{constructor(){this.invProjMatrix=t.create(),this.viewportMatrix=t.create(),this.circles=[];}}class bt{constructor(t,e,i,o,a){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=a;}}class wt{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={};}get(t){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e};}return this.collisionGroups[t]}}function Tt(e,i,o,a,r){const{horizontalAlign:n,verticalAlign:s}=t.getAnchorAlignment(e),l=-(n-.5)*i,c=-(s-.5)*o,h=t.evaluateVariableOffset(e,a);return new t.Point(l+h[0]*r,c+h[1]*r)}function Et(e,i,o,a,r){const n=new t.Point(e,i);return o&&n._rotate(a?r:-r),n}class Ct{constructor(t,e,i,o){this.transform=t.clone(),this.collisionIndex=new ft(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=e,this.retainedQueryData={},this.collisionGroups=new wt(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(e,i,o,a){const r=o.getBucket(i),n=o.latestFeatureIndex;if(!r||!n||i.id!==r.layerIds[0])return;const s=o.collisionBoxArray,l=r.layers[0].layout,c=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),h=o.tileSize/t.EXTENT,u=this.transform.calculatePosMatrix(o.tileID.toUnwrapped()),d="map"===l.get("text-pitch-alignment"),_="map"===l.get("text-rotation-alignment"),m=C(o,1,this.transform.zoom),p=it(u,d,_,this.transform,m);let f=null;if(d){const e=ot(u,d,_,this.transform,m);f=t.multiply([],this.transform.labelPlaneMatrix,e);}this.retainedQueryData[r.bucketInstanceId]=new bt(r.bucketInstanceId,n,r.sourceLayerIndex,r.index,o.tileID);const g={bucket:r,layout:l,posMatrix:u,textLabelPlaneMatrix:p,labelToScreenMatrix:f,scale:c,textPixelRatio:h,holdingForFade:o.holdingForFade(),collisionBoxArray:s,partiallyEvaluatedTextSize:t.evaluateSizeForZoom(r.textSizeData,this.transform.zoom),partiallyEvaluatedIconSize:t.evaluateSizeForZoom(r.iconSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(r.sourceID)};if(a)for(const t of r.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:a}=t;e.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:a,parameters:g});}else e.push({symbolInstanceStart:0,symbolInstanceEnd:r.symbolInstances.length,parameters:g});}attemptAnchorPlacement(t,e,i,o,a,r,n,s,l,c,h,u,d,_,m,p,f,g){const v=[u.textOffset0,u.textOffset1],x=_.getSymbolInstanceTextSize(f,u,this.transform.zoom,d),y=Tt(t,i,o,v,a),b=this.collisionIndex.placeCollisionBox(x,e,Et(y.x,y.y,r,n,this.transform.angle),h,s,l,c.predicate);if((!p||0!==this.collisionIndex.placeCollisionBox(_.getSymbolInstanceIconSize(g,this.transform.zoom,d),p,Et(y.x,y.y,r,n,this.transform.angle),h,s,l,c.predicate).box.length)&&b.box.length>0){let e;return this.prevPlacement&&this.prevPlacement.variableOffsets[u.crossTileID]&&this.prevPlacement.placements[u.crossTileID]&&this.prevPlacement.placements[u.crossTileID].text&&(e=this.prevPlacement.variableOffsets[u.crossTileID].anchor),this.variableOffsets[u.crossTileID]={textOffset:v,width:i,height:o,anchor:t,textBoxScale:a,prevAnchor:e},this.markUsedJustification(_,t,u,m),_.allowVerticalPlacement&&(this.markUsedOrientation(_,m,u),this.placedOrientations[u.crossTileID]=m),{shift:y,placedGlyphBoxes:b}}}placeLayerBucketPart(e,i,o){const{bucket:a,layout:r,posMatrix:n,textLabelPlaneMatrix:s,labelToScreenMatrix:l,textPixelRatio:c,holdingForFade:h,collisionBoxArray:u,partiallyEvaluatedTextSize:d,partiallyEvaluatedIconSize:_,collisionGroup:m}=e.parameters,p=r.get("text-optional"),f=r.get("icon-optional"),g=r.get("text-allow-overlap"),v=r.get("icon-allow-overlap"),x="map"===r.get("text-rotation-alignment"),y="map"===r.get("text-pitch-alignment"),b="none"!==r.get("icon-text-fit"),w="viewport-y"===r.get("symbol-z-order"),T=g&&(v||!a.hasIconData()||f),E=v&&(g||!a.hasTextData()||p);!a.collisionArrays&&u&&a.deserializeCollisionBoxes(u),o&&a.updateCollisionDebugBuffers(this.transform.zoom,u);const C=(e,u,w)=>{if(i[e.crossTileID])return;if(h)return void(this.placements[e.crossTileID]=new xt(!1,!1,!1));let C=!1,S=!1,I=!0,P=null,M={box:null,offscreen:null},z={box:null,offscreen:null},A=null,D=null,L=null,R=0,k=0,B=0;w.textFeatureIndex?R=w.textFeatureIndex:e.useRuntimeCollisionCircles&&(R=e.featureIndex),w.verticalTextFeatureIndex&&(k=w.verticalTextFeatureIndex);const O=t=>{(this.transform.elevation||t.elevation)&&(t.elevation=this.transform.elevation?this.transform.elevation.getAtTileOffset(this.retainedQueryData[a.bucketInstanceId].tileID,t.anchorPointX,t.anchorPointY):0);},F=w.textBox;if(F){O(F);const i=i=>{let o=t.WritingMode.horizontal;if(a.allowVerticalPlacement&&!i&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[e.crossTileID];t&&(this.placedOrientations[e.crossTileID]=t,o=t,this.markUsedOrientation(a,o,e));}return o},o=(i,o)=>{if(a.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&w.verticalTextBox){for(const e of a.writingModes)if(e===t.WritingMode.vertical?(M=o(),z=M):M=i(),M&&M.box&&M.box.length)break}else M=i();};if(r.get("text-variable-anchor")){let s=r.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[e.crossTileID]){const t=this.prevPlacement.variableOffsets[e.crossTileID];s.indexOf(t.anchor)>0&&(s=s.filter(e=>e!==t.anchor),s.unshift(t.anchor));}const l=(t,i,o)=>{const r=e.textBoxScale,l=(t.x2-t.x1)*r+2*t.padding,h=(t.y2-t.y1)*r+2*t.padding,p=b&&!v?i:null;p&&O(p);let f={box:[],offscreen:!1};const w=g?2*s.length:s.length;for(let i=0;i<w;++i){const g=this.attemptAnchorPlacement(s[i%s.length],t,l,h,r,x,y,c,n,m,i>=s.length,e,u,a,o,p,d,_);if(g&&(f=g.placedGlyphBoxes,f&&f.box&&f.box.length)){C=!0,P=g.shift;break}}return f};o(()=>l(F,w.iconBox,t.WritingMode.horizontal),()=>{const i=w.verticalTextBox;return i&&O(i),a.allowVerticalPlacement&&!(M&&M.box&&M.box.length)&&e.numVerticalGlyphVertices>0&&i?l(i,w.verticalIconBox,t.WritingMode.vertical):{box:null,offscreen:null}}),M&&(C=M.box,I=M.offscreen);const h=i(M&&M.box);if(!C&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[e.crossTileID];t&&(this.variableOffsets[e.crossTileID]=t,this.markUsedJustification(a,t.anchor,e,h));}}else {const r=(i,o)=>{const r=a.getSymbolInstanceTextSize(d,e,this.transform.zoom,u),s=this.collisionIndex.placeCollisionBox(r,i,new t.Point(0,0),g,c,n,m.predicate);return s&&s.box&&s.box.length&&(this.markUsedOrientation(a,o,e),this.placedOrientations[e.crossTileID]=o),s};o(()=>r(F,t.WritingMode.horizontal),()=>{const i=w.verticalTextBox;return a.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&i?(O(i),r(i,t.WritingMode.vertical)):{box:null,offscreen:null}}),i(M&&M.box&&M.box.length);}}if(A=M,C=A&&A.box&&A.box.length>0,I=A&&A.offscreen,e.useRuntimeCollisionCircles){const i=a.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex),c=t.evaluateSizeForFeature(a.textSizeData,d,i),h=r.get("text-padding");D=this.collisionIndex.placeCollisionCircles(g,i,a.lineVertexArray,a.glyphOffsetArray,c,n,s,l,o,y,m.predicate,e.collisionCircleDiameter,h,this.retainedQueryData[a.bucketInstanceId].tileID),C=g||D.circles.length>0&&!D.collisionDetected,I=I&&D.offscreen;}if(w.iconFeatureIndex&&(B=w.iconFeatureIndex),w.iconBox){const e=e=>{O(e);const i=b&&P?Et(P.x,P.y,x,y,this.transform.angle):new t.Point(0,0),o=a.getSymbolInstanceIconSize(_,this.transform.zoom,u);return this.collisionIndex.placeCollisionBox(o,e,i,v,c,n,m.predicate)};z&&z.box&&z.box.length&&w.verticalIconBox?(L=e(w.verticalIconBox),S=L.box.length>0):(L=e(w.iconBox),S=L.box.length>0),I=I&&L.offscreen;}const U=p||0===e.numHorizontalGlyphVertices&&0===e.numVerticalGlyphVertices,N=f||0===e.numIconVertices;if(U||N?N?U||(S=S&&C):C=S&&C:S=C=S&&C,C&&A&&A.box&&this.collisionIndex.insertCollisionBox(A.box,r.get("text-ignore-placement"),a.bucketInstanceId,z&&z.box&&k?k:R,m.ID),S&&L&&this.collisionIndex.insertCollisionBox(L.box,r.get("icon-ignore-placement"),a.bucketInstanceId,B,m.ID),D&&(C&&this.collisionIndex.insertCollisionCircles(D.circles,r.get("text-ignore-placement"),a.bucketInstanceId,R,m.ID),o)){const t=a.bucketInstanceId;let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=new yt);for(let t=0;t<D.circles.length;t+=4)e.circles.push(D.circles[t+0]),e.circles.push(D.circles[t+1]),e.circles.push(D.circles[t+2]),e.circles.push(D.collisionDetected?1:0);}this.placements[e.crossTileID]=new xt(C||T,S||E,I||a.justReloaded),i[e.crossTileID]=!0;};if(w){const t=a.getSortedSymbolIndexes(this.transform.angle);for(let e=t.length-1;e>=0;--e){const i=t[e];C(a.symbolInstances.get(i),i,a.collisionArrays[i]);}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)C(a.symbolInstances.get(t),t,a.collisionArrays[t]);if(o&&a.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[a.bucketInstanceId];t.invert(e.invProjMatrix,n),e.viewportMatrix=this.collisionIndex.getViewportMatrix();}a.justReloaded=!1;}markUsedJustification(e,i,o,a){let r;r=a===t.WritingMode.vertical?o.verticalPlacedTextSymbolIndex:{left:o.leftJustifiedTextSymbolIndex,center:o.centerJustifiedTextSymbolIndex,right:o.rightJustifiedTextSymbolIndex}[t.getAnchorJustification(i)];const n=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex,o.verticalPlacedTextSymbolIndex];for(const t of n)t>=0&&(e.text.placedSymbolArray.get(t).crossTileID=r>=0&&t!==r?0:o.crossTileID);}markUsedOrientation(e,i,o){const a=i===t.WritingMode.horizontal||i===t.WritingMode.horizontalOnly?i:0,r=i===t.WritingMode.vertical?i:0,n=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex];for(const t of n)e.text.placedSymbolArray.get(t).placedOrientation=a;o.verticalPlacedTextSymbolIndex&&(e.text.placedSymbolArray.get(o.verticalPlacedTextSymbolIndex).placedOrientation=r);}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const o=e?e.symbolFadeChange(t):1,a=e?e.opacities:{},r=e?e.variableOffsets:{},n=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],r=a[t];r?(this.opacities[t]=new vt(r,o,e.text,e.icon),i=i||e.text!==r.text.placed||e.icon!==r.icon.placed):(this.opacities[t]=new vt(null,o,e.text,e.icon,e.skipFade),i=i||e.text||e.icon);}for(const t in a){const e=a[t];if(!this.opacities[t]){const a=new vt(e,o,!1,!1);a.isHidden()||(this.opacities[t]=a,i=i||e.text.placed||e.icon.placed);}}for(const t in r)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=r[t]);for(const t in n)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=n[t]);i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t);}updateLayerOpacities(t,e){const i={};for(const o of e){const e=o.getBucket(t);e&&o.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,i,o.collisionBoxArray);}}updateBucketOpacities(e,i,o){e.hasTextData()&&e.text.opacityVertexArray.clear(),e.hasIconData()&&e.icon.opacityVertexArray.clear(),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const a=e.layers[0].layout,r=new vt(null,0,!1,!1,!0),n=a.get("text-allow-overlap"),s=a.get("icon-allow-overlap"),l=a.get("text-variable-anchor"),c="map"===a.get("text-rotation-alignment"),h="map"===a.get("text-pitch-alignment"),u="none"!==a.get("icon-text-fit"),d=new vt(null,0,n&&(s||!e.hasIconData()||a.get("icon-optional")),s&&(n||!e.hasTextData()||a.get("text-optional")),!0);!e.collisionArrays&&o&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(o);const _=(t,e,i)=>{for(let o=0;o<e/4;o++)t.opacityVertexArray.emplaceBack(i);};for(let o=0;o<e.symbolInstances.length;o++){const a=e.symbolInstances.get(o),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:s,crossTileID:m}=a;let p=this.opacities[m];i[m]?p=r:p||(p=d,this.opacities[m]=p),i[m]=!0;const f=a.numIconVertices>0,g=this.placedOrientations[a.crossTileID],v=g===t.WritingMode.vertical,x=g===t.WritingMode.horizontal||g===t.WritingMode.horizontalOnly;if(n>0||s>0){const t=Rt(p.text);_(e.text,n,v?kt:t),_(e.text,s,x?kt:t);const i=p.text.isHidden();[a.rightJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.leftJustifiedTextSymbolIndex].forEach(t=>{t>=0&&(e.text.placedSymbolArray.get(t).hidden=i||v?1:0);}),a.verticalPlacedTextSymbolIndex>=0&&(e.text.placedSymbolArray.get(a.verticalPlacedTextSymbolIndex).hidden=i||x?1:0);const o=this.variableOffsets[a.crossTileID];o&&this.markUsedJustification(e,o.anchor,a,g);const r=this.placedOrientations[a.crossTileID];r&&(this.markUsedJustification(e,"left",a,r),this.markUsedOrientation(e,r,a));}if(f){const t=Rt(p.icon),i=!(u&&a.verticalPlacedIconSymbolIndex&&v);a.placedIconSymbolIndex>=0&&(_(e.icon,a.numIconVertices,i?t:kt),e.icon.placedSymbolArray.get(a.placedIconSymbolIndex).hidden=p.icon.isHidden()),a.verticalPlacedIconSymbolIndex>=0&&(_(e.icon,a.numVerticalIconVertices,i?kt:t),e.icon.placedSymbolArray.get(a.verticalPlacedIconSymbolIndex).hidden=p.icon.isHidden());}if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const i=e.collisionArrays[o];if(i){let o=new t.Point(0,0);if(i.textBox||i.verticalTextBox){let t=!0;if(l){const e=this.variableOffsets[m];e?(o=Tt(e.anchor,e.width,e.height,e.textOffset,e.textBoxScale),c&&o._rotate(h?this.transform.angle:-this.transform.angle)):t=!1;}i.textBox&&St(e.textCollisionBox.collisionVertexArray,p.text.placed,!t||v,o.x,o.y),i.verticalTextBox&&St(e.textCollisionBox.collisionVertexArray,p.text.placed,!t||x,o.x,o.y);}const a=Boolean(!x&&i.verticalIconBox);i.iconBox&&St(e.iconCollisionBox.collisionVertexArray,p.icon.placed,a,u?o.x:0,u?o.y:0),i.verticalIconBox&&St(e.iconCollisionBox.collisionVertexArray,p.icon.placed,!a,u?o.x:0,u?o.y:0);}}}if(e.sortFeatures(this.transform.angle),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[e.bucketInstanceId];e.placementInvProjMatrix=t.invProjMatrix,e.placementViewportMatrix=t.viewportMatrix,e.collisionCircleArray=t.circles,delete this.collisionCircleArrays[e.bucketInstanceId];}}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0;}}function St(t,e,i,o,a){t.emplaceBack(e?1:0,i?1:0,o||0,a||0),t.emplaceBack(e?1:0,i?1:0,o||0,a||0),t.emplaceBack(e?1:0,i?1:0,o||0,a||0),t.emplaceBack(e?1:0,i?1:0,o||0,a||0);}const It=Math.pow(2,25),Pt=Math.pow(2,24),Mt=Math.pow(2,17),zt=Math.pow(2,16),At=Math.pow(2,9),Dt=Math.pow(2,8),Lt=Math.pow(2,1);function Rt(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*It+e*Pt+i*Mt+e*zt+i*At+e*Dt+i*Lt+e}const kt=0;class Bt{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&void 0!==t.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(t,e,i,o,a){const r=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(r,o,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,a())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,r.sort((t,e)=>t.sortKey-e.sortKey));this._currentPartIndex<r.length;)if(e.placeLayerBucketPart(r[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,a())return !0;return !1}}class Ot{constructor(t,e,i,o,a,r,n){this.placement=new Ct(t,a,r,n),this._currentPlacementIndex=e.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(e,i,o){const a=t.browser.now(),r=()=>{const e=t.browser.now()-a;return !this._forceFullPlacement&&e>2};for(;this._currentPlacementIndex>=0;){const t=i[e[this._currentPlacementIndex]],a=this.placement.collisionIndex.transform.zoom;if("symbol"===t.type&&(!t.minzoom||t.minzoom<=a)&&(!t.maxzoom||t.maxzoom>a)){if(this._inProgressLayer||(this._inProgressLayer=new Bt(t)),this._inProgressLayer.continuePlacement(o[t.source],this.placement,this._showCollisionBoxes,t,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(t){return this.placement.commit(t),this.placement}}const Ft=512/t.EXTENT/2;class Ut{constructor(t,e,i){this.tileID=t,this.indexedSymbolInstances={},this.bucketInstanceId=i;for(let i=0;i<e.length;i++){const o=e.get(i),a=o.key;this.indexedSymbolInstances[a]||(this.indexedSymbolInstances[a]=[]),this.indexedSymbolInstances[a].push({crossTileID:o.crossTileID,coord:this.getScaledCoordinates(o,t)});}}getScaledCoordinates(e,i){const o=Ft/Math.pow(2,i.canonical.z-this.tileID.canonical.z);return {x:Math.floor((i.canonical.x*t.EXTENT+e.anchorX)*o),y:Math.floor((i.canonical.y*t.EXTENT+e.anchorY)*o)}}findMatches(t,e,i){const o=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let a=0;a<t.length;a++){const r=t.get(a);if(r.crossTileID)continue;const n=this.indexedSymbolInstances[r.key];if(!n)continue;const s=this.getScaledCoordinates(r,e);for(const t of n)if(Math.abs(t.coord.x-s.x)<=o&&Math.abs(t.coord.y-s.y)<=o&&!i[t.crossTileID]){i[t.crossTileID]=!0,r.crossTileID=t.crossTileID;break}}}}class Nt{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class Zt{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],o={};for(const t in i){const a=i[t];a.tileID=a.tileID.unwrapTo(a.tileID.wrap+e),o[a.tileID.key]=a;}this.indexes[t]=o;}this.lng=t;}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key]);}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const o=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const a=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in a){const r=a[i];r.tileID.isChildOf(t)&&r.findMatches(e.symbolInstances,t,o);}else {const r=a[t.scaledTo(Number(i)).key];r&&r.findMatches(e.symbolInstances,t,o);}}for(let t=0;t<e.symbolInstances.length;t++){const a=e.symbolInstances.get(t);a.crossTileID||(a.crossTileID=i.generate(),o[a.crossTileID]=!0);}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new Ut(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i in e.indexedSymbolInstances)for(const o of e.indexedSymbolInstances[i])delete this.usedCrossTileIDs[t][o.crossTileID];}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const o=this.indexes[i];for(const a in o)t[o[a].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[a]),delete o[a],e=!0);}return e}}class Gt{constructor(){this.layerIndexes={},this.crossTileIDs=new Nt,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(t,e,i){let o=this.layerIndexes[t.id];void 0===o&&(o=this.layerIndexes[t.id]=new Zt);let a=!1;const r={};o.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),o.addBucket(i.tileID,e,this.crossTileIDs)&&(a=!0),r[e.bucketInstanceId]=!0);}return o.removeStaleBuckets(r)&&(a=!0),a}pruneUnusedLayers(t){const e={};t.forEach(t=>{e[t]=!0;});for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t];}}const qt=(e,i)=>t.emitValidationErrors(e,i&&i.filter(t=>"source.canvas"!==t.identifier)),Vt=t.pick(j,["addLayer","removeLayer","setPaintProperty","setLayoutProperty","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain"]),$t=t.pick(j,["setCenter","setZoom","setBearing","setPitch"]),jt=function(){const e={},i=t.styleSpec.$version;for(const o in t.styleSpec.$root){const a=t.styleSpec.$root[o];if(a.required){let t=null;t="version"===o?i:"array"===a.type?[]:{},null!=t&&(e[o]=t);}}return e}();class Wt extends t.Evented{constructor(e,i={}){super(),this.map=e,this.dispatcher=new E(q(),this),this.imageManager=new u,this.imageManager.setEventedParent(this),this.glyphManager=new v(e._requestManager,i.localIdeographFontFamily),this.lineAtlas=new T(256,512),this.crossTileSymbolIndex=new Gt,this._layers={},this._num3DLayers=0,this._serializedLayers={},this._order=[],this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this.zoomHistory=new t.ZoomHistory,this._loaded=!1,this._availableImages=[],this._resetUpdates(),this.dispatcher.broadcast("setReferrer",t.getReferrer());const o=this;this._rtlTextPluginCallback=Wt.registerForPluginStateChange(e=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:e.pluginStatus,pluginURL:e.pluginURL},(e,i)=>{if(t.triggerPluginCompletionEvent(e),i&&i.every(t=>t))for(const t in o._sourceCaches){const e=o._sourceCaches[t],i=e.getSource().type;"vector"!==i&&"geojson"!==i||e.reload();}});}),this.on("data",t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.getSource(t.sourceId);if(e&&e.vectorLayerIds)for(const t in this._layers){const i=this._layers[t];i.source===e.id&&this._validateLayer(i);}});}loadURL(e,i={}){this.fire(new t.Event("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!t.isMapboxURL(e);e=this.map._requestManager.normalizeStyleURL(e,i.accessToken);const a=this.map._requestManager.transformRequest(e,t.ResourceType.Style);this._request=t.getJSON(a,(e,i)=>{this._request=null,e?this.fire(new t.ErrorEvent(e)):i&&this._load(i,o);});}loadJSON(e,i={}){this.fire(new t.Event("dataloading",{dataType:"style"})),this._request=t.browser.frame(()=>{this._request=null,this._load(e,!1!==i.validate);});}loadEmpty(){this.fire(new t.Event("dataloading",{dataType:"style"})),this._load(jt,!1);}_load(e,i){if(i&&qt(this,t.validateStyle(e)))return;this._loaded=!0,this.stylesheet=e;for(const t in e.sources)this.addSource(t,e.sources[t],{validate:!1});this._changed=!1,e.sprite?this._loadSprite(e.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(e.glyphs);const o=$(this.stylesheet.layers);this._order=o.map(t=>t.id),this._layers={},this._serializedLayers={};for(let e of o)e=t.createStyleLayer(e),e.setEventedParent(this,{layer:{id:e.id}}),this._layers[e.id]=e,this._serializedLayers[e.id]=e.serialize(),e.is3D()&&this._num3DLayers++;this.dispatcher.broadcast("setLayers",this._serializeLayers(this._order)),this.light=new y(this.stylesheet.light),this.stylesheet.terrain&&this._createTerrain(this.stylesheet.terrain),this.fire(new t.Event("data",{dataType:"style"})),this.fire(new t.Event("style.load"));}_loadSprite(e){this._spriteRequest=function(e,i,o){let a,r,n;const s=t.browser.devicePixelRatio>1?"@2x":"";let l=t.getJSON(i.transformRequest(i.normalizeSpriteURL(e,s,".json"),t.ResourceType.SpriteJSON),(t,e)=>{l=null,n||(n=t,a=e,h());}),c=t.getImage(i.transformRequest(i.normalizeSpriteURL(e,s,".png"),t.ResourceType.SpriteImage),(t,e)=>{c=null,n||(n=t,r=e,h());});function h(){if(n)o(n);else if(a&&r){const e=t.browser.getImageData(r),i={};for(const o in a){const{width:r,height:n,x:s,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_}=a[o],m=new t.RGBAImage({width:r,height:n});t.RGBAImage.copy(e,m,{x:s,y:l},{x:0,y:0},{width:r,height:n}),i[o]={data:m,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(e,this.map._requestManager,(e,i)=>{if(this._spriteRequest=null,e)this.fire(new t.ErrorEvent(e));else if(i)for(const t in i)this.imageManager.addImage(t,i[t]);this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new t.Event("data",{dataType:"style"}));});}_validateLayer(e){const i=this.getSource(e.source);if(!i)return;const o=e.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new t.ErrorEvent(new Error(`Source layer "${o}" `+`does not exist on source "${i.id}" `+`as specified by style layer "${e.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const t in this._sourceCaches)if(!this._sourceCaches[t].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeLayers(t){const e=[];for(const i of t){const t=this._layers[i];"custom"!==t.type&&e.push(t.serialize());}return e}hasTransitions(){if(this.light&&this.light.hasTransition())return !0;for(const t in this._sourceCaches)if(this._sourceCaches[t].hasTransition())return !0;for(const t in this._layers)if(this._layers[t].hasTransition())return !0;return !1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}update(e){if(!this._loaded)return;const i=this._changed;if(this._changed){const t=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(t.length||i.length)&&this._updateWorkerLayers(t,i);for(const t in this._updatedSources){const e=this._updatedSources[t];"reload"===e?this._reloadSource(t):"clear"===e&&this._clearSource(t);}this._updateTilesForChangedImages();for(const t in this._updatedPaintProps)this._layers[t].updateTransitions(e);this.light.updateTransitions(e),this._resetUpdates();}const o={};for(const t in this._sourceCaches){const e=this._sourceCaches[t];o[t]=e.used,e.used=!1;}for(const t of this._order){const i=this._layers[t];if(i.recalculate(e,this._availableImages),!i.isHidden(e.zoom)){const t=this._getLayerSourceCache(i);t&&(t.used=!0);}const o=this.map.painter;if(o){const t=i.getProgramIds();if(!t)continue;const a=i.getProgramConfiguration(e.zoom);for(const e of t)o.useProgram(e,a);}}for(const e in o){const i=this._sourceCaches[e];o[e]!==i.used&&i.getSource().fire(new t.Event("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light.recalculate(e),this.terrain&&this.terrain.recalculate(e),this.z=e.zoom,i&&this.fire(new t.Event("data",{dataType:"style"}));}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this._sourceCaches)this._sourceCaches[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={};}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("updateLayers",{layers:this._serializeLayers(t),removedIds:e});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={};}setState(e){if(this._checkLoaded(),qt(this,t.validateStyle(e)))return !1;(e=t.clone$1(e)).layers=$(e.layers);const i=function(e,i){if(!e)return [{command:j.setStyle,args:[i]}];let o=[];try{if(!t.deepEqual(e.version,i.version))return [{command:j.setStyle,args:[i]}];t.deepEqual(e.center,i.center)||o.push({command:j.setCenter,args:[i.center]}),t.deepEqual(e.zoom,i.zoom)||o.push({command:j.setZoom,args:[i.zoom]}),t.deepEqual(e.bearing,i.bearing)||o.push({command:j.setBearing,args:[i.bearing]}),t.deepEqual(e.pitch,i.pitch)||o.push({command:j.setPitch,args:[i.pitch]}),t.deepEqual(e.sprite,i.sprite)||o.push({command:j.setSprite,args:[i.sprite]}),t.deepEqual(e.glyphs,i.glyphs)||o.push({command:j.setGlyphs,args:[i.glyphs]}),t.deepEqual(e.transition,i.transition)||o.push({command:j.setTransition,args:[i.transition]}),t.deepEqual(e.light,i.light)||o.push({command:j.setLight,args:[i.light]});const a={},r=[];!function(e,i,o,a){let r;for(r in i=i||{},e=e||{})e.hasOwnProperty(r)&&(i.hasOwnProperty(r)||X(r,o,a));for(r in i)i.hasOwnProperty(r)&&(e.hasOwnProperty(r)?t.deepEqual(e[r],i[r])||("geojson"===e[r].type&&"geojson"===i[r].type&&K(e,i,r)?o.push({command:j.setGeoJSONSourceData,args:[r,i[r].data]}):H(r,i,o,a)):W(r,i,o));}(e.sources,i.sources,r,a);const n=[];e.layers&&e.layers.forEach(t=>{a[t.source]?o.push({command:j.removeLayer,args:[t.id]}):n.push(t);});let s=e.terrain;s&&a[s.source]&&(o.push({command:j.setTerrain,args:[void 0]}),s=void 0),o=o.concat(r),t.deepEqual(s,i.terrain)||o.push({command:j.setTerrain,args:[i.terrain]}),function(e,i,o){i=i||[];const a=(e=e||[]).map(J),r=i.map(J),n=e.reduce(Q,{}),s=i.reduce(Q,{}),l=a.slice(),c=Object.create(null);let h,u,d,_,m,p,f;for(h=0,u=0;h<a.length;h++)d=a[h],s.hasOwnProperty(d)?u++:(o.push({command:j.removeLayer,args:[d]}),l.splice(l.indexOf(d,u),1));for(h=0,u=0;h<r.length;h++)d=r[r.length-1-h],l[l.length-1-h]!==d&&(n.hasOwnProperty(d)?(o.push({command:j.removeLayer,args:[d]}),l.splice(l.lastIndexOf(d,l.length-u),1)):u++,p=l[l.length-h],o.push({command:j.addLayer,args:[s[d],p]}),l.splice(l.length-h,0,d),c[d]=!0);for(h=0;h<r.length;h++)if(d=r[h],_=n[d],m=s[d],!c[d]&&!t.deepEqual(_,m))if(t.deepEqual(_.source,m.source)&&t.deepEqual(_["source-layer"],m["source-layer"])&&t.deepEqual(_.type,m.type)){for(f in Y(_.layout,m.layout,o,d,null,j.setLayoutProperty),Y(_.paint,m.paint,o,d,null,j.setPaintProperty),t.deepEqual(_.filter,m.filter)||o.push({command:j.setFilter,args:[d,m.filter]}),t.deepEqual(_.minzoom,m.minzoom)&&t.deepEqual(_.maxzoom,m.maxzoom)||o.push({command:j.setLayerZoomRange,args:[d,m.minzoom,m.maxzoom]}),_)_.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Y(_[f],m[f],o,d,f.slice(6),j.setPaintProperty):t.deepEqual(_[f],m[f])||o.push({command:j.setLayerProperty,args:[d,f,m[f]]}));for(f in m)m.hasOwnProperty(f)&&!_.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Y(_[f],m[f],o,d,f.slice(6),j.setPaintProperty):t.deepEqual(_[f],m[f])||o.push({command:j.setLayerProperty,args:[d,f,m[f]]}));}else o.push({command:j.removeLayer,args:[d]}),p=l[l.lastIndexOf(d)+1],o.push({command:j.addLayer,args:[m,p]});}(n,i.layers,o);}catch(t){console.warn("Unable to compute style diff:",t),o=[{command:j.setStyle,args:[i]}];}return o}(this.serialize(),e).filter(t=>!(t.command in $t));if(0===i.length)return !1;const o=i.filter(t=>!(t.command in Vt));if(o.length>0)throw new Error(`Unimplemented: ${o.map(t=>t.command).join(", ")}.`);return i.forEach(t=>{"setTransition"!==t.command&&this[t.command].apply(this,t.args);}),this.stylesheet=e,!0}addImage(e,i){if(this.getImage(e))return this.fire(new t.ErrorEvent(new Error("An image with this name already exists.")));this.imageManager.addImage(e,i),this._afterImageUpdated(e);}updateImage(t,e){this.imageManager.updateImage(t,e);}getImage(t){return this.imageManager.getImage(t)}removeImage(e){if(!this.getImage(e))return this.fire(new t.ErrorEvent(new Error("No image with this name exists.")));this.imageManager.removeImage(e),this._afterImageUpdated(e);}_afterImageUpdated(e){this._availableImages=this.imageManager.listImages(),this._changedImages[e]=!0,this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new t.Event("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(e,i,o={}){if(this._checkLoaded(),void 0!==this.getSource(e))throw new Error("There is already a source with this ID");if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(t.validateStyle.source,`sources.${e}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const a=R(e,i,this.dispatcher,this);a.setEventedParent(this,()=>({isSourceLoaded:this.loaded(),source:a.serialize(),sourceId:e}));const r=i=>{const o=(i?"symbol:":"other:")+e,r=this._sourceCaches[o]=new t.SourceCache(o,a,i);(i?this._symbolSourceCaches:this._otherSourceCaches)[e]=r,r.style=this,r.onAdd(this.map);};r(!1),"vector"!==i.type&&"geojson"!==i.type||r(!0),a.onAdd&&a.onAdd(this.map),this._changed=!0;}removeSource(e){this._checkLoaded();const i=this.getSource(e);if(void 0===i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===e)return this.fire(new t.ErrorEvent(new Error(`Source "${e}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.get().source===e)return this.fire(new t.ErrorEvent(new Error(`Source "${e}" cannot be removed while terrain is using it.`)));const o=this._getSourceCaches(e);for(const e of o)delete this._sourceCaches[e.id],delete this._updatedSources[e.id],e.fire(new t.Event("data",{sourceDataType:"metadata",dataType:"source",sourceId:e.getSource().id})),e.setEventedParent(null),e.clearTiles();delete this._otherSourceCaches[e],delete this._symbolSourceCaches[e],i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(t,e){this._checkLoaded(),this.getSource(t).setData(e),this._changed=!0;}getSource(t){const e=this._getSourceCache(t);return e&&e.getSource()}addLayer(e,i,o={}){this._checkLoaded();const a=e.id;if(this.getLayer(a))return void this.fire(new t.ErrorEvent(new Error(`Layer with id "${a}" already exists on this map`)));let r;if("custom"===e.type){if(qt(this,t.validateCustomStyleLayer(e)))return;r=t.createStyleLayer(e);}else {if("object"==typeof e.source&&(this.addSource(a,e.source),e=t.clone$1(e),e=t.extend(e,{source:a})),this._validate(t.validateStyle.layer,`layers.${a}`,e,{arrayIndex:-1},o))return;r=t.createStyleLayer(e),this._validateLayer(r),r.setEventedParent(this,{layer:{id:a}}),this._serializedLayers[r.id]=r.serialize(),r.is3D()&&this._num3DLayers++;}const n=i?this._order.indexOf(i):this._order.length;if(i&&-1===n)return void this.fire(new t.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`)));this._order.splice(n,0,a),this._layerOrderChanged=!0,this._layers[a]=r;const s=this._getLayerSourceCache(r);if(this._removedLayers[a]&&r.source&&s&&"custom"!==r.type){const t=this._removedLayers[a];delete this._removedLayers[a],t.type!==r.type?this._updatedSources[r.source]="clear":(this._updatedSources[r.source]="reload",s.pause());}this._updateLayer(r),r.onAdd&&r.onAdd(this.map);}moveLayer(e,i){if(this._checkLoaded(),this._changed=!0,!this._layers[e])return void this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be moved.`)));if(e===i)return;const o=this._order.indexOf(e);this._order.splice(o,1);const a=i?this._order.indexOf(i):this._order.length;i&&-1===a?this.fire(new t.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`))):(this._order.splice(a,0,e),this._layerOrderChanged=!0);}removeLayer(e){this._checkLoaded();const i=this._layers[e];if(!i)return void this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be removed.`)));i.setEventedParent(null),i.is3D()&&this._num3DLayers--;const o=this._order.indexOf(e);this._order.splice(o,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[e]=i,delete this._layers[e],delete this._serializedLayers[e],delete this._updatedLayers[e],delete this._updatedPaintProps[e],i.onRemove&&i.onRemove(this.map);}getLayer(t){return this._layers[t]}hasLayer(t){return t in this._layers}setLayerZoomRange(e,i,o){this._checkLoaded();const a=this.getLayer(e);a?a.minzoom===i&&a.maxzoom===o||(null!=i&&(a.minzoom=i),null!=o&&(a.maxzoom=o),this._updateLayer(a)):this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot have zoom extent.`)));}setFilter(e,i,o={}){this._checkLoaded();const a=this.getLayer(e);if(a){if(!t.deepEqual(a.filter,i))return null==i?(a.filter=void 0,void this._updateLayer(a)):void(this._validate(t.validateStyle.filter,`layers.${a.id}.filter`,i,null,o)||(a.filter=t.clone$1(i),this._updateLayer(a)))}else this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be filtered.`)));}getFilter(e){return t.clone$1(this.getLayer(e).filter)}setLayoutProperty(e,i,o,a={}){this._checkLoaded();const r=this.getLayer(e);r?t.deepEqual(r.getLayoutProperty(i),o)||(r.setLayoutProperty(i,o,a),this._updateLayer(r)):this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be styled.`)));}getLayoutProperty(e,i){const o=this.getLayer(e);if(o)return o.getLayoutProperty(i);this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style.`)));}setPaintProperty(e,i,o,a={}){this._checkLoaded();const r=this.getLayer(e);r?t.deepEqual(r.getPaintProperty(i),o)||(r.setPaintProperty(i,o,a)&&this._updateLayer(r),this._changed=!0,this._updatedPaintProps[e]=!0):this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be styled.`)));}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(e,i){this._checkLoaded();const o=e.source,a=e.sourceLayer,r=this.getSource(o);if(void 0===r)return void this.fire(new t.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const n=r.type;if("geojson"===n&&a)return void this.fire(new t.ErrorEvent(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===n&&!a)return void this.fire(new t.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===e.id&&this.fire(new t.ErrorEvent(new Error("The feature id parameter must be provided.")));const s=this._getSourceCaches(o);for(const t of s)t.setFeatureState(a,e.id,i);}removeFeatureState(e,i){this._checkLoaded();const o=e.source,a=this.getSource(o);if(void 0===a)return void this.fire(new t.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const r=a.type,n="vector"===r?e.sourceLayer:void 0;if("vector"===r&&!n)return void this.fire(new t.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));if(i&&"string"!=typeof e.id&&"number"!=typeof e.id)return void this.fire(new t.ErrorEvent(new Error("A feature id is required to remove its specific state property.")));const s=this._getSourceCaches(o);for(const t of s)t.removeFeatureState(n,e.id,i);}getFeatureState(e){this._checkLoaded();const i=e.source,o=e.sourceLayer,a=this.getSource(i);if(void 0!==a){if("vector"!==a.type||o)return void 0===e.id&&this.fire(new t.ErrorEvent(new Error("The feature id parameter must be provided."))),this._getSourceCaches(i)[0].getFeatureState(o,e.id);this.fire(new t.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));}else this.fire(new t.ErrorEvent(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return t.extend({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){const e={};for(const t in this._sourceCaches){const i=this._sourceCaches[t].getSource();e[i.id]||(e[i.id]=i.serialize());}return t.filterObject({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,light:this.stylesheet.light,terrain:this.stylesheet.terrain,center:this.stylesheet.center,zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,sources:e,layers:this._serializeLayers(this._order)},t=>void 0!==t)}_updateLayer(t){this._updatedLayers[t.id]=!0;const e=this._getLayerSourceCache(t);t.source&&!this._updatedSources[t.source]&&e&&"raster"!==e.getSource().type&&(this._updatedSources[t.source]="reload",e.pause()),this._changed=!0;}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},o=[];for(let a=this._order.length-1;a>=0;a--){const r=this._order[a];if(e(r)){i[r]=a;for(const e of t){const t=e[r];if(t)for(const e of t)o.push(e);}}}o.sort((t,e)=>e.intersectionZ-t.intersectionZ);const a=[];for(let r=this._order.length-1;r>=0;r--){const n=this._order[r];if(e(n))for(let t=o.length-1;t>=0;t--){const e=o[t].feature;if(i[e.layer.id]<r)break;a.push(e),o.pop();}else for(const e of t){const t=e[n];if(t)for(const e of t)a.push(e.feature);}}return a}queryRenderedFeatures(e,i,o){i&&i.filter&&this._validate(t.validateStyle.filter,"queryRenderedFeatures.filter",i.filter,null,i);const a={};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new t.ErrorEvent(new Error("parameters.layers must be an Array."))),[];for(const e of i.layers){const i=this._layers[e];if(!i)return this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be queried for features.`))),[];a[i.source]=!0;}}const r=[];i.availableImages=this._availableImages;const n=i&&i.layers?i.layers.some(t=>{const e=this.getLayer(t);return e&&e.is3D()}):this.has3DLayers(),s=S.createFromScreenPoints(e,o);for(const t in this._sourceCaches){const e=this._sourceCaches[t].getSource().id;i.layers&&!a[e]||r.push(B(this._sourceCaches[t],this._layers,this._serializedLayers,s,i,o,n,!!this.map._showQueryGeometry));}return this.placement&&r.push(function(t,e,i,o,a,r,n){const s={},l=r.queryRenderedSymbols(o),c=[];for(const t of Object.keys(l).map(Number))c.push(n[t]);c.sort(F);for(const i of c){const o=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,a.filter,a.layers,a.availableImages,t);for(const t in o){const e=s[t]=s[t]||[],a=o[t];a.sort((t,e)=>{const o=i.featureSortOrder;if(o){const i=o.indexOf(t.featureIndex);return o.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex});for(const t of a)e.push(t);}}for(const e in s)s[e].forEach(o=>{const a=o.feature,r=i(t[e]).getFeatureState(a.layer["source-layer"],a.id);a.source=a.layer.source,a.layer["source-layer"]&&(a.sourceLayer=a.layer["source-layer"]),a.state=r;});return s}(this._layers,this._serializedLayers,this._getLayerSourceCache.bind(this),s.screenGeometry,i,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(r)}querySourceFeatures(e,i){i&&i.filter&&this._validate(t.validateStyle.filter,"querySourceFeatures.filter",i.filter,null,i);const o=this._getSourceCaches(e);let a=[];for(const t of o)a=a.concat(O(t,i));return a}addSourceType(t,e,i){return Wt.getSourceType(t)?i(new Error(`A source type called "${t}" already exists.`)):(Wt.setSourceType(t,e),e.workerSourceURL?void this.dispatcher.broadcast("loadWorkerSource",{name:t,url:e.workerSourceURL},i):i(null,null))}getLight(){return this.light.getLight()}setLight(e,i={}){this._checkLoaded();const o=this.light.getLight();let a=!1;for(const i in e)if(!t.deepEqual(e[i],o[i])){a=!0;break}if(!a)return;const r={now:t.browser.now(),transition:t.extend({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(e,i),this.light.updateTransitions(r);}setTerrain(e){if(this._checkLoaded(),!e)return delete this.terrain,delete this.stylesheet.terrain,this.dispatcher.broadcast("enableTerrain",!1),void this._force3DLayerUpdate();if("object"==typeof e.source){const i="terrain-dem-src";this.addSource(i,e.source),e=t.clone$1(e),e=t.extend(e,{source:i});}if(!this._validate(t.validateStyle.terrain,"terrain",e))if(this.terrain){const i=this.terrain,o=i.get();for(const a in e)if(!t.deepEqual(e[a],o[a])){i.set(e),this.stylesheet.terrain=e;const o={now:t.browser.now(),transition:t.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);break}}else this._createTerrain(e);}_createTerrain(e){const i=this.terrain=new w(e);this.stylesheet.terrain=e,this.dispatcher.broadcast("enableTerrain",!0),this._force3DLayerUpdate();const o={now:t.browser.now(),transition:t.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);}_force3DLayerUpdate(){for(const t in this._layers){const e=this._layers[t];"fill-extrusion"===e.type&&this._updateLayer(e);}}_validate(e,i,o,a,r={}){return (!r||!1!==r.validate)&&qt(this,e.call(t.validateStyle,t.extend({key:i,style:this.serialize(),value:o,styleSpec:t.styleSpec},a)))}_remove(){this._request&&(this._request.cancel(),this._request=null),this._spriteRequest&&(this._spriteRequest.cancel(),this._spriteRequest=null),t.evented.off("pluginStateChange",this._rtlTextPluginCallback);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this._sourceCaches)this._sourceCaches[t].clearTiles(),this._sourceCaches[t].setEventedParent(null);this.imageManager.setEventedParent(null),this.setEventedParent(null),this.dispatcher.remove();}_clearSource(t){const e=this._getSourceCaches(t);for(const t of e)t.clearTiles();}_reloadSource(t){const e=this._getSourceCaches(t);for(const t of e)t.resume(),t.reload();}_updateSources(t){for(const e in this._sourceCaches)this._sourceCaches[e].update(t);}_generateCollisionBoxes(){for(const t in this._sourceCaches){const e=this._sourceCaches[t];e.resume(),e.reload();}}_updatePlacement(e,i,o,a,r=!1){let n=!1,s=!1;const l={};for(const t of this._order){const i=this._layers[t];if("symbol"!==i.type)continue;if(!l[i.source]){const t=this._getLayerSourceCache(i);if(!t)continue;l[i.source]=t.getRenderableIds(!0).map(e=>t.getTileByID(e)).sort((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1));}const o=this.crossTileSymbolIndex.addLayer(i,l[i.source],e.center.lng);n=n||o;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((r=r||this._layerOrderChanged||0===o)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(t.browser.now(),e.zoom))&&(this.pauseablePlacement=new Ot(e,this._order,r,i,o,a,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(t.browser.now()),s=!0),n&&this.pauseablePlacement.placement.setStale()),s||n)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,l[e.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(t.browser.now())}_releaseSymbolFadeTiles(){for(const t in this._sourceCaches)this._sourceCaches[t].releaseSymbolFadeTiles();}getImages(t,e,i){this.imageManager.getImages(e.icons,i),this._updateTilesForChangedImages();const o=t=>{t&&t.setDependencies(e.tileID.key,e.type,e.icons);};o(this._otherSourceCaches[e.source]),o(this._symbolSourceCaches[e.source]);}getGlyphs(t,e,i){this.glyphManager.getGlyphs(e.stacks,i);}getResource(e,i,o){return t.makeRequest(i,o)}_getSourceCache(t){return this._otherSourceCaches[t]}_getLayerSourceCache(t){return "symbol"===t.type?this._symbolSourceCaches[t.source]:this._otherSourceCaches[t.source]}_getSourceCaches(t){const e=[];return this._otherSourceCaches[t]&&e.push(this._otherSourceCaches[t]),this._symbolSourceCaches[t]&&e.push(this._symbolSourceCaches[t]),e}has3DLayers(){return this._num3DLayers>0}}Wt.getSourceType=function(t){return L[t]},Wt.setSourceType=function(t,e){L[t]=e;},Wt.registerForPluginStateChange=t.registerForPluginStateChange;var Xt="attribute highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;varying highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}";let Ht={};Ht=Ie("","#ifdef TERRAIN\nuniform sampler2D u_dem;uniform sampler2D u_dem_prev;uniform vec4 u_dem_unpack;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform sampler2D u_depth;uniform vec2 u_depth_size_inv;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float decodeElevation(vec4 v) {return dot(vec4(v.xyz*255.0,-1.0),u_dem_unpack);}float currentElevation(vec2 apos) {float dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem,pos));float tr=decodeElevation(texture2D(u_dem,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);}float prevElevation(vec2 apos) {float dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem_prev,pos));float tr=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem_prev,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {float nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {return currentElevation(apos);}\n#endif\nfloat unpack_depth(vec4 rgba_depth)\n{const vec4 bit_shift=vec4(1.0/(256.0*256.0*256.0),1.0/(256.0*256.0),1.0/256.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}bool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;float depth=unpack_depth(texture2D(u_depth,(coord.xy+1.0)*0.5));return coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;vec4 depth=vec4(\nunpack_depth(texture2D(u_depth,uv-df.xz)),unpack_depth(texture2D(u_depth,uv+df.xz)),unpack_depth(texture2D(u_depth,uv-df.zy)),unpack_depth(texture2D(u_depth,uv+df.zy))\n);return dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {vec4 demtl=vec4(texture2D(u_dem,pos).xyz*255.0,-1.0);float tl=dot(demtl,u_dem_unpack);vec4 demtr=vec4(texture2D(u_dem,pos+vec2(off.x,0.0)).xyz*255.0,-1.0);float tr=dot(demtr,u_dem_unpack);vec4 dembl=vec4(texture2D(u_dem,pos+vec2(0.0,off.y)).xyz*255.0,-1.0);float bl=dot(dembl,u_dem_unpack);vec4 dembr=vec4(texture2D(u_dem,pos+off).xyz*255.0,-1.0);float br=dot(dembr,u_dem_unpack);return vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;vec4 bounds=vec4(d,vec2(1.0)-d);h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*word/7.3;}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",!0);const Kt=Ie("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nconst float PI=3.141592653589793;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}const float PI=3.141592653589793;const vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);//Normalized device coordinate that is not rendered."),Yt=Ie("uniform vec4 u_color;uniform float u_opacity;void main() {gl_FragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),Jt=Ie("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),Qt=Ie("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);gl_FragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h4=elevation(c4)+ELEVATION_BIAS;return max(h4,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);float height=circle_elevation(circle_center);vec4 world_center=vec4(circle_center,height,1);vec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);vec4 occlusion_world_center=vec4(circle_center,cantilevered_height,1);vec4 occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nvec4 occlusion_world_center=world_center;vec4 occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),te=Ie("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),ee=Ie("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec4 pos=vec4(floor(a_pos*0.5)+extrude,elevation(floor(a_pos*0.5)),1);gl_Position=u_matrix*pos;}"),ie=Ie("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),oe=Ie("varying float v_placed;varying float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);gl_FragColor =mix(red,blue,step(0.5,v_placed))*0.5;gl_FragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}","attribute vec2 a_pos;attribute vec2 a_anchor_pos;attribute vec2 a_extrude;attribute vec2 a_placed;attribute vec2 a_shift;attribute float a_size_scale;attribute vec2 a_padding;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;varying float v_placed;varying float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_anchor_pos,elevation(a_anchor_pos),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=u_matrix*vec4(a_pos,elevation(a_pos),1.0);gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}"),ae=Ie("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos_2f;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),re=Ie("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;varying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;gl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);}"),ne=Ie("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_FragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);}"),se=Ie("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=outline_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),le=Ie("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),ce=Ie("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),he=Ie("varying vec4 v_color;void main() {gl_FragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;varying vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;\n#ifdef TERRAIN\nvec2 centroid_pos=a_centroid_pos;bool flat_roof=centroid_pos.x !=0.0;float ele=elevation(pos_nx.xy);float hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);gl_Position=mix(u_matrix*vec4(pos_nx.xy,h,1),AWAY,hidden);\n#else\ngl_Position=u_matrix*vec4(pos_nx.xy,t > 0.0 ? height : base,1);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;float directional=clamp(dot(normal,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),ue=Ie("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);gl_FragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;\n#ifdef TERRAIN\nvec2 centroid_pos=a_centroid_pos;bool flat_roof=centroid_pos.x !=0.0;float ele=elevation(pos_nx.xy);float hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);gl_Position=mix(u_matrix*vec4(pos_nx.xy,h,1),AWAY,hidden);\n#else\ngl_Position=u_matrix*vec4(pos_nx.xy,z,1);\n#endif\nvec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),de=Ie("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),_e=Ie("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;void main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;}"),me=Ie("uniform lowp float u_device_pixel_ratio;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_width2=vec2(outset,inset);}"),pe=Ie("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture2D(u_image,v_uv);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_uv_x;attribute float a_split_index;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_width2=vec2(outset,inset);}"),fe=Ie("uniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture2D(u_image,pos_a),texture2D(u_image,pos_b),u_fade);gl_FragColor=color*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),ge=Ie("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture2D(u_image,v_tex_a).a;float sdfdist_b=texture2D(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),ve=Ie("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);gl_FragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos0=(((a_texture_pos/8192.0)-0.5)/u_buffer_scale )+0.5;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),xe=Ie("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;v_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));}"),ye=Ie("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),be=Ie("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),we=Ie("uniform sampler2D u_image0;varying vec2 v_pos0;void main() {gl_FragColor=texture2D(u_image0,v_pos0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_skirt_height;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;const float skirtOffset=24575.0;void main() {v_pos0=a_texture_pos/8192.0;float skirt=float(a_pos.x >=skirtOffset);float elevation=elevation(a_texture_pos)-skirt*u_skirt_height;vec2 decodedPos=a_pos-vec2(skirt*skirtOffset,0.0);gl_Position=u_matrix*vec4(decodedPos,elevation,1.0);}"),Te=Ie("#ifdef GL_ES\nprecision highp float;\n#endif\nvec4 pack_depth(float ndc_z) {float depth=ndc_z*0.5+0.5;const vec4 bit_shift=vec4(256.0*256.0*256.0,256.0*256.0,256.0,1.0);const vec4 bit_mask =vec4(0.0,1.0/256.0,1.0/256.0,1.0/256.0);vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}varying float v_depth;void main() {gl_FragColor=pack_depth(v_depth);}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying float v_depth;void main() {float elevation=elevation(a_texture_pos);gl_Position=u_matrix*vec4(a_pos,elevation,1.0);v_depth=gl_Position.z/gl_Position.w;}"),Ee=Ie("\nvarying lowp vec3 v_uv;uniform lowp samplerCube u_cubemap;uniform lowp float u_opacity;uniform highp float u_temporal_offset;uniform highp vec3 u_sun_direction;highp vec3 hash(highp vec2 p) {highp vec3 p3=fract(vec3(p.xyx)*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract(vec3((p3.x+p3.y)*p3.z,(p3.x+p3.z)*p3.y,(p3.y+p3.z)*p3.x));}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;color.rgb+=rnd/255.0;return color;}float sun_disk(highp vec3 ray_direction,highp vec3 sun_direction) {highp float cos_angle=dot(normalize(ray_direction),sun_direction);const highp float cos_sun_angular_diameter=0.99996192306;const highp float smoothstep_delta=1e-5;return smoothstep(\ncos_sun_angular_diameter-smoothstep_delta,cos_sun_angular_diameter+smoothstep_delta,cos_angle);}float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec3 uv=v_uv;const float y_bias=0.015;uv.y+=y_bias;uv.y=pow(abs(uv.y),1.0/5.0);uv.y=map(uv.y,0.0,1.0,-1.0,1.0);vec3 sky_color=textureCube(u_cubemap,uv).rgb;sky_color.rgb=dither(sky_color.rgb,gl_FragCoord.xy+u_temporal_offset);sky_color+=0.1*sun_disk(v_uv,u_sun_direction);gl_FragColor=vec4(sky_color*u_opacity,u_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",Xt),Ce=Ie("varying highp vec3 v_uv;uniform lowp sampler2D u_color_ramp;uniform lowp vec3 u_center_direction;uniform lowp float u_radius;uniform lowp float u_opacity;uniform highp float u_temporal_offset;highp vec3 hash(highp vec2 p) {highp vec3 p3=fract(vec3(p.xyx)*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract(vec3((p3.x+p3.y)*p3.z,(p3.x+p3.z)*p3.y,(p3.y+p3.z)*p3.x));}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;color.rgb+=rnd/255.0;return color;}void main() {float progress=acos(dot(normalize(v_uv),u_center_direction))/u_radius;vec4 color=texture2D(u_color_ramp,vec2(progress,0.5))*u_opacity;color.rgb=dither(color.rgb,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",Xt),Se=Ie("\nvarying highp vec3 v_position;uniform highp float u_sun_intensity;uniform highp float u_luminance;uniform lowp vec3 u_sun_direction;uniform highp vec4 u_color_tint_r;uniform highp vec4 u_color_tint_m;\n#ifdef GL_ES\nprecision highp float;\n#endif\n#define BETA_R                  vec3(5.5e-6,13.0e-6,22.4e-6)\n#define BETA_M                  vec3(21e-6,21e-6,21e-6)\n#define MIE_G                   0.76\n#define DENSITY_HEIGHT_SCALE_R  8000.0\n#define DENSITY_HEIGHT_SCALE_M  1200.0\n#define PLANET_RADIUS           6360e3\n#define ATMOSPHERE_RADIUS       6420e3\n#define SAMPLE_STEPS            10\n#define DENSITY_STEPS           4\nfloat ray_sphere_exit(vec3 orig,vec3 dir,float radius) {float a=dot(dir,dir);float b=2.0*dot(dir,orig);float c=dot(orig,orig)-radius*radius;float d=sqrt(b*b-4.0*a*c);return (-b+d)/(2.0*a);}vec3 extinction(vec2 density) {return exp(-vec3(BETA_R*u_color_tint_r.a*density.x+BETA_M*u_color_tint_m.a*density.y));}vec2 local_density(vec3 point) {float height=max(length(point)-PLANET_RADIUS,0.0);float exp_r=exp(-height/DENSITY_HEIGHT_SCALE_R);float exp_m=exp(-height/DENSITY_HEIGHT_SCALE_M);return vec2(exp_r,exp_m);}float phase_ray(float cos_angle) {return (3.0/(16.0*PI))*(1.0+cos_angle*cos_angle);}float phase_mie(float cos_angle) {return (3.0/(8.0*PI))*((1.0-MIE_G*MIE_G)*(1.0+cos_angle*cos_angle))/((2.0+MIE_G*MIE_G)*pow(1.0+MIE_G*MIE_G-2.0*MIE_G*cos_angle,1.5));}vec2 density_to_atmosphere(vec3 point,vec3 light_dir) {float ray_len=ray_sphere_exit(point,light_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(DENSITY_STEPS);vec2 density_point_to_atmosphere=vec2(0.0);for (int i=0; i < DENSITY_STEPS;++i) {vec3 point_on_ray=point+light_dir*((float(i)+0.5)*step_len);density_point_to_atmosphere+=local_density(point_on_ray)*step_len;;}return density_point_to_atmosphere;}vec3 atmosphere(vec3 ray_dir,vec3 sun_direction,float sun_intensity) {vec2 density_orig_to_point=vec2(0.0);vec3 scatter_r=vec3(0.0);vec3 scatter_m=vec3(0.0);vec3 origin=vec3(0.0,PLANET_RADIUS,0.0);float ray_len=ray_sphere_exit(origin,ray_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(SAMPLE_STEPS);for (int i=0; i < SAMPLE_STEPS;++i) {vec3 point_on_ray=origin+ray_dir*((float(i)+0.5)*step_len);vec2 density=local_density(point_on_ray)*step_len;density_orig_to_point+=density;vec2 density_point_to_atmosphere=density_to_atmosphere(point_on_ray,sun_direction);vec2 density_orig_to_atmosphere=density_orig_to_point+density_point_to_atmosphere;vec3 extinction=extinction(density_orig_to_atmosphere);scatter_r+=density.x*extinction;scatter_m+=density.y*extinction;}float cos_angle=dot(ray_dir,sun_direction);float phase_r=phase_ray(cos_angle);float phase_m=phase_mie(cos_angle);vec3 beta_r=BETA_R*u_color_tint_r.rgb*u_color_tint_r.a;vec3 beta_m=BETA_M*u_color_tint_m.rgb*u_color_tint_m.a;return (scatter_r*phase_r*beta_r+scatter_m*phase_m*beta_m)*sun_intensity;}const float A=0.15;const float B=0.50;const float C=0.10;const float D=0.20;const float E=0.02;const float F=0.30;vec3 uncharted2_tonemap(vec3 x) {return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;}void main() {vec3 ray_direction=v_position;ray_direction.y=pow(ray_direction.y,5.0);const float y_bias=0.015;ray_direction.y+=y_bias;vec3 color=atmosphere(normalize(ray_direction),u_sun_direction,u_sun_intensity);float white_scale=1.0748724675633854;color=uncharted2_tonemap((log2(2.0/pow(u_luminance,4.0)))*color)*white_scale;gl_FragColor=vec4(color,1.0);}","attribute highp vec3 a_pos_3f;uniform mat3 u_matrix_3f;varying highp vec3 v_position;float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec4 pos=vec4(u_matrix_3f*a_pos_3f,1.0);v_position=pos.xyz;v_position.y*=-1.0;v_position.y=map(v_position.y,-1.0,1.0,0.0,1.0);gl_Position=vec4(a_pos_3f.xy,0.0,1.0);}");function Ie(t,e,i){const o=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,a=e.match(/attribute (highp |mediump |lowp )?([\w]+) ([\w]+)/g),r=t.match(/uniform (highp |mediump |lowp )?([\w]+) ([\w]+)([\s]*)([\w]*)/g),n=e.match(/uniform (highp |mediump |lowp )?([\w]+) ([\w]+)([\s]*)([\w]*)/g);let s=n?n.concat(r):r;i||(s=Ht.staticUniforms.concat(s));const l={};return {fragmentSource:t=t.replace(o,(t,e,i,o,a)=>(l[a]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${a}\nvarying ${i} ${o} ${a};\n#else\nuniform ${i} ${o} u_${a};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${a}\n    ${i} ${o} ${a} = u_${a};\n#endif\n`)),vertexSource:e=e.replace(o,(t,e,i,o,a)=>{const r="float"===o?"vec2":"vec4",n=a.match(/color/)?"color":r;return l[a]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${a}\nuniform lowp float u_${a}_t;\nattribute ${i} ${r} a_${a};\nvarying ${i} ${o} ${a};\n#else\nuniform ${i} ${o} u_${a};\n#endif\n`:"vec4"===n?`\n#ifndef HAS_UNIFORM_u_${a}\n    ${a} = a_${a};\n#else\n    ${i} ${o} ${a} = u_${a};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${a}\n    ${a} = unpack_mix_${n}(a_${a}, u_${a}_t);\n#else\n    ${i} ${o} ${a} = u_${a};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${a}\nuniform lowp float u_${a}_t;\nattribute ${i} ${r} a_${a};\n#else\nuniform ${i} ${o} u_${a};\n#endif\n`:"vec4"===n?`\n#ifndef HAS_UNIFORM_u_${a}\n    ${i} ${o} ${a} = a_${a};\n#else\n    ${i} ${o} ${a} = u_${a};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${a}\n    ${i} ${o} ${a} = unpack_mix_${n}(a_${a}, u_${a}_t);\n#else\n    ${i} ${o} ${a} = u_${a};\n#endif\n`}),staticAttributes:a,staticUniforms:s}}var Pe=Object.freeze({__proto__:null,get preludeTerrain(){return Ht},prelude:Kt,background:Yt,backgroundPattern:Jt,circle:Qt,clippingMask:te,heatmap:ee,heatmapTexture:ie,collisionBox:oe,collisionCircle:ae,debug:re,fill:ne,fillOutline:se,fillOutlinePattern:le,fillPattern:ce,fillExtrusion:he,fillExtrusionPattern:ue,hillshadePrepare:de,hillshade:_e,line:me,lineGradient:pe,linePattern:fe,lineSDF:ge,raster:ve,symbolIcon:xe,symbolSDF:ye,symbolTextAndIcon:be,terrainRaster:we,terrainDepth:Te,skybox:Ee,skyboxGradient:Ce,skyboxCapture:Se});class Me{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(t,e,i,o,a,r,n,s){this.context=t;let l=this.boundPaintVertexBuffers.length!==o.length;for(let t=0;!l&&t<o.length;t++)this.boundPaintVertexBuffers[t]!==o[t]&&(l=!0);t.extVertexArrayObject&&this.vao&&this.boundProgram===e&&this.boundLayoutVertexBuffer===i&&!l&&this.boundIndexBuffer===a&&this.boundVertexOffset===r&&this.boundDynamicVertexBuffer===n&&this.boundDynamicVertexBuffer2===s?(t.bindVertexArrayOES.set(this.vao),n&&n.bind(),a&&a.dynamicDraw&&a.bind(),s&&s.bind()):this.freshBind(e,i,o,a,r,n,s);}freshBind(t,e,i,o,a,r,n){let s;const l=t.numAttributes,c=this.context,h=c.gl;if(c.extVertexArrayObject)this.vao&&this.destroy(),this.vao=c.extVertexArrayObject.createVertexArrayOES(),c.bindVertexArrayOES.set(this.vao),s=0,this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=o,this.boundVertexOffset=a,this.boundDynamicVertexBuffer=r,this.boundDynamicVertexBuffer2=n;else {s=c.currentNumAttributes||0;for(let t=l;t<s;t++)h.disableVertexAttribArray(t);}e.enableAttributes(h,t);for(const e of i)e.enableAttributes(h,t);r&&r.enableAttributes(h,t),n&&n.enableAttributes(h,t),e.bind(),e.setVertexAttribPointers(h,t,a);for(const e of i)e.bind(),e.setVertexAttribPointers(h,t,a);r&&(r.bind(),r.setVertexAttribPointers(h,t,a)),o&&o.bind(),n&&(n.bind(),n.setVertexAttribPointers(h,t,a)),c.currentNumAttributes=l;}destroy(){this.vao&&(this.context.extVertexArrayObject.deleteVertexArrayOES(this.vao),this.vao=null);}}function ze(e,i){const o=Math.pow(2,i.canonical.z),a=i.canonical.y;return [new t.MercatorCoordinate(0,a/o).toLngLat().lat,new t.MercatorCoordinate(0,(a+1)/o).toLngLat().lat]}function Ae(e,i,o,a,r,n,s){const l=e.context,c=l.gl,h=o.fbo;if(!h)return;e.prepareDrawTile(i);const u=e.useProgram("hillshade");l.activeTexture.set(c.TEXTURE0),c.bindTexture(c.TEXTURE_2D,h.colorAttachment.get());const d=((t,e,i,o)=>{const a=i.paint.get("hillshade-shadow-color"),r=i.paint.get("hillshade-highlight-color"),n=i.paint.get("hillshade-accent-color");let s=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(s-=t.transform.angle);const l=!t.options.moving;return {u_matrix:o||t.transform.calculatePosMatrix(e.tileID.toUnwrapped(),l),u_image:0,u_latrange:ze(0,e.tileID),u_light:[i.paint.get("hillshade-exaggeration"),s],u_shadow:a,u_highlight:r,u_accent:n}})(e,o,a,e.terrain?i.posMatrix:null);u.draw(l,c.TRIANGLES,r,n,s,t.CullFaceMode.disabled,d,a.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments);}function De(e,i,o){if(!i.needsDEMTextureUpload)return;const a=e.context,r=a.gl;a.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||e.getTileTexture(o.stride);const n=o.getPixels();i.demTexture?i.demTexture.update(n,{premultiply:!1}):i.demTexture=new t.Texture(a,n,r.RGBA,{premultiply:!1}),i.needsDEMTextureUpload=!1;}function Le(e,i,o,a,r,n){const s=e.context,l=s.gl;if(!i.dem)return;const c=i.dem;if(s.activeTexture.set(l.TEXTURE1),De(e,i,c),!i.demTexture)return;i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);const h=c.dim;s.activeTexture.set(l.TEXTURE0);let u=i.fbo;if(!u){const e=new t.Texture(s,{width:h,height:h,data:null},l.RGBA);e.bind(l.LINEAR,l.CLAMP_TO_EDGE),u=i.fbo=s.createFramebuffer(h,h,!0),u.colorAttachment.set(e.texture);}s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,h,h]),e.useProgram("hillshadePrepare").draw(s,l.TRIANGLES,a,r,n,t.CullFaceMode.disabled,((e,i)=>{const o=i.stride,a=t.create();return t.ortho(a,0,t.EXTENT,-t.EXTENT,0,0,1),t.translate(a,a,[0,-t.EXTENT,0]),{u_matrix:a,u_image:1,u_dimension:[o,o],u_zoom:e.overscaledZ,u_unpack:i.unpackVector}})(i.tileID,c),o.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments),i.needsHillshadePrepare=!1;}const Re=(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_image0:new t.Uniform1i(e,i.u_image0),u_skirt_height:new t.Uniform1f(e,i.u_skirt_height)}),ke=(t,e)=>({u_matrix:t,u_image0:0,u_skirt_height:e}),Be=new class{constructor(){this.operations={};}newMorphing(t,e,i,o,a){if(t in this.operations){const e=this.operations[t];e.to.tileID.key!==i.tileID.key&&(e.queued=i);}else this.operations[t]={startTime:o,phase:0,duration:a,from:e,to:i,queued:null};}getMorphValuesForProxy(t){if(!(t in this.operations))return null;const e=this.operations[t];return {from:e.from,to:e.to,phase:e.phase}}update(t){for(const e in this.operations){const i=this.operations[e];for(i.phase=(t-i.startTime)/i.duration;i.phase>=1||!this._validOp(i);)if(!this._nextOp(i,t)){delete this.operations[e];break}}}_nextOp(t,e){return !!t.queued&&(t.from=t.to,t.to=t.queued,t.queued=null,t.phase=0,t.startTime=e,!0)}_validOp(t){return t.from.hasData()&&t.to.hasData()}},Oe={0:null,1:"TERRAIN_VERTEX_MORPHING"};function Fe(e,i,o,a,r){const n=e.context,s=n.gl;let l=e.useProgram("terrainRaster"),c=0;const h=e.colorModeForRenderPass(),u=new t.DepthMode(s.LEQUAL,t.DepthMode.ReadWrite,e.depthRangeFor3D);Be.update(r);const d=e.transform,_=6*Math.pow(1.5,22-d.zoom)*i.exaggeration();var m,p,f;for(const g of a){const a=o.getTile(g),v=t.StencilMode.disabled,x=i.prevTerrainTileForTile[g.key],y=i.terrainTileForTile[g.key];f=y,null!=(p=x)&&null!=f&&p.hasData()&&f.hasData()&&null!=p.demTexture&&null!=f.demTexture&&p.tileID.key!==f.tileID.key&&Be.newMorphing(g.key,x,y,r,250),n.activeTexture.set(s.TEXTURE0),a.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE,s.LINEAR_MIPMAP_NEAREST);const b=Be.getMorphValuesForProxy(g.key),w=b?1:0;let T;b&&(T={morphing:{srcDemTile:b.from,dstDemTile:b.to,phase:t.easeCubicInOut(b.phase)}});const E=ke(g.posMatrix,Ue(g.canonical,d.renderWorldCopies)?_/10:_);c!==(m=w)&&(l=e.useProgram("terrainRaster",null,Oe[m]),c=m),i.setupElevationDraw(a,l,T),l.draw(n,s.TRIANGLES,u,v,h,t.CullFaceMode.backCCW,E,"terrain_raster",i.gridBuffer,i.gridIndexBuffer,i.gridSegments);}}function Ue(t,e){const i=1<<t.z;return !e&&(0===t.x||t.x===i-1)||0===t.y||t.y===i-1}const Ne=t=>({u_matrix:t});function Ze(e,i,o,a,r){if(r>0){const n=t.browser.now(),s=(n-e.timeAdded)/r,l=i?(n-i.timeAdded)/r:-1,c=o.getSource(),h=a.coveringZoomLevel({tileSize:c.tileSize,roundZoom:c.roundZoom}),u=!i||Math.abs(i.tileID.overscaledZ-h)>Math.abs(e.tileID.overscaledZ-h),d=u&&e.refreshedUponExpiration?1:t.clamp(u?s:1-l,0,1);return e.refreshedUponExpiration&&s>=1&&(e.refreshedUponExpiration=!1),i?{opacity:1,mix:1-d}:{opacity:d,mix:0}}return {opacity:1,mix:0}}const Ge={fill:!0,line:!0,background:!0,hillshade:!0,raster:!0};class qe extends t.SourceCache{constructor(t){const e=R("proxy",{type:"geojson",maxzoom:t.transform.maxZoom},new E(q(),null),t.style);super("proxy",e,!1),e.setEventedParent(this),this.map=this.getSource().map=t,this.used=this._sourceLoaded=!0,this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}update(e,i,o){if(e.freezeTileCoverage)return;this.transform=e;const a=e.coveringTiles({tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,useElevationData:!0}).reduce((i,o)=>{if(i[o.key]="",!this._tiles[o.key]){const i=new t.Tile(o,this._source.tileSize*o.overscaleFactor(),e.tileZoom);i.state="loaded",this._tiles[o.key]=i;}return i},{});for(const t in this._tiles)t in a||(this.freeFBO(t),this._tiles[t].state="unloaded",delete this._tiles[t]);}freeFBO(t){const e=this.proxyCachedFBO[t];void 0!==e&&(this.renderCachePool.push(e),delete this.proxyCachedFBO[t]);}deallocRenderCache(){this.renderCache.forEach(t=>t.fb.destroy()),this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}}class Ve extends t.OverscaledTileID{constructor(t,e,i){super(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y),this.proxyTileKey=e,this.posMatrix=i;}}class $e extends t.Elevation{constructor(e,i){super(),this.painter=e,this.terrainTileForTile={},this.prevTerrainTileForTile={};const[o,a,r]=function(e){const i=new t.StructArrayLayout4i8,o=new t.StructArrayLayout3ui6;i.reserve(17161),o.reserve(33800);const a=t.EXTENT/128,r=t.EXTENT+a/2,n=r+a;for(let e=-a;e<n;e+=a)for(let o=-a;o<n;o+=a){const a=o<0||o>r||e<0||e>r?24575:0,n=t.clamp(Math.round(o),0,t.EXTENT),s=t.clamp(Math.round(e),0,t.EXTENT);i.emplaceBack(n+a,s,n,s);}const s=(t,e)=>{const i=131*e+t;o.emplaceBack(i+1,i,i+131),o.emplaceBack(i+131,i+131+1,i+1);};for(let t=1;t<129;t++)for(let e=1;e<129;e++)s(e,t);return [0,129].forEach(t=>{for(let e=0;e<130;e++)s(e,t),s(t,e);}),[i,o,32768]}(),n=e.context;this.gridBuffer=n.createVertexBuffer(o,A.members),this.gridIndexBuffer=n.createIndexBuffer(a),this.gridSegments=t.SegmentVector.simpleSegment(0,0,o.length,a.length),this.gridNoSkirtSegments=t.SegmentVector.simpleSegment(0,0,o.length,r),this.proxyCoords=[],this.proxiedCoords={},this._visibleDemTiles=[],this._sourceTilesOverlap={},this.proxySourceCache=new qe(i.map),this.orthoMatrix=t.create(),t.ortho(this.orthoMatrix,0,t.EXTENT,0,t.EXTENT,0,1);const s=n.gl;this._overlapStencilMode=new t.StencilMode({func:s.GEQUAL,mask:255},0,255,s.KEEP,s.KEEP,s.REPLACE),this._previousZoom=e.transform.zoom,this.pool=[],this._findCoveringTileCache={},this._tilesDirty={},this.style=i,i.on("data",this._onStyleDataEvent.bind(this));}update(e,i,o){if(e&&e.terrain){this.style!==e&&(e.on("data",this._onStyleDataEvent.bind(this)),this.style=e),this.enabled=!0;const a=e.terrain.properties;this.sourceCache=e._getSourceCache(a.get("source")),this._exaggeration=a.get("exaggeration");const r=()=>{this.sourceCache.used&&t.warnOnce(`Raster DEM source '${this.sourceCache.id}' is used both for terrain and as layer source.\n`+"This leads to lower resolution of hillshade. For full hillshade resolution but higher memory consumption, define another raster DEM source.");const e=this.sourceCache.getSource().tileSize/128,o=this.proxySourceCache.getSource().tileSize;this.sourceCache.update(i,e*o,!0),this._findCoveringTileCache[this.sourceCache.id]={};};this.sourceCache.usedForTerrain||(this._findCoveringTileCache[this.sourceCache.id]={},this.sourceCache.usedForTerrain=!0,r(),this._initializing=!0),r(),i.updateElevation(!o),this._findCoveringTileCache[this.proxySourceCache.id]={},this.proxySourceCache.update(i),this._depthDone=!1,this._emptyDEMTextureDirty=!0;}else this._disable();}_onStyleDataEvent(t){t.coord&&"source"===t.dataType?this._clearRenderCacheForTile(t.sourceCacheId,t.coord):"style"===t.dataType&&(this._invalidateRenderCache=!0);}_disable(){if(this.enabled&&(this.enabled=!1,this.proxySourceCache.deallocRenderCache(),this.painter.style))for(const t in this.painter.style._sourceCaches)this.painter.style._sourceCaches[t].usedForTerrain=!1;}destroy(){this._disable(),this._emptyDEMTexture&&this._emptyDEMTexture.destroy(),this.pool.forEach(t=>t.fb.destroy()),this.pool=[],this._depthFBO&&(this._depthFBO.destroy(),delete this._depthFBO,delete this._depthTexture);}_source(){return this.enabled?this.sourceCache:null}exaggeration(){return this._exaggeration}get visibleDemTiles(){return this._visibleDemTiles}get drapeBufferSize(){const t=2*this.proxySourceCache.getSource().tileSize;return [t,t]}updateTileBinding(e){if(!this.enabled)return;this.prevTerrainTileForTile=this.terrainTileForTile;const i=this.proxySourceCache,o=this.painter.transform;this._initializing&&(this._initializing=0===o._centerAltitude&&-1===this.getAtPoint(t.MercatorCoordinate.fromLngLat(o.center),-1),this._emptyDEMTextureDirty=!this._initializing);const a=this.painter.options;this.drapeFirst=(a.zooming||a.moving||a.rotating||!!this.forceDrapeFirst)&&!this._invalidateRenderCache,this._invalidateRenderCache=!1;const r=this.proxyCoords=i.getIds().map(t=>{const e=i.getTileByID(t).tileID;return e.posMatrix=o.calculatePosMatrix(e.toUnwrapped()),e});!function(e,i){const o=i.transform.pointCoordinate(i.transform.getCameraPoint()),a=new t.Point(o.x,o.y);e.sort((e,i)=>{if(i.overscaledZ-e.overscaledZ)return i.overscaledZ-e.overscaledZ;const o=new t.Point(e.canonical.x+(1<<e.canonical.z)*e.wrap,e.canonical.y),r=new t.Point(i.canonical.x+(1<<i.canonical.z)*i.wrap,i.canonical.y),n=a.mult(1<<e.canonical.z);return n.x-=.5,n.y-=.5,n.distSqr(o)-n.distSqr(r)});}(r,this.painter),this._previousZoom=o.zoom;const n=this.proxyToSource||{};this.proxyToSource={},r.forEach(t=>{this.proxyToSource[t.key]={};}),this.terrainTileForTile={};const s=this.painter.style._sourceCaches;for(const t in s){const i=s[t];if(!i.used)continue;if(i!==this.sourceCache&&(this._findCoveringTileCache[i.id]={}),this._setupProxiedCoordsForOrtho(i,e[t],n),i.usedForTerrain)continue;const o=e[t];i.getSource().reparseOverscaled&&this._assignTerrainTiles(o);}this.proxiedCoords[i.id]=r.map(t=>new Ve(t,t.key,this.orthoMatrix)),this._assignTerrainTiles(r),this._prepareDEMTextures(),this._setupRenderCache(n),this.drapeFirstPending=this.drapeFirst,this.renderingToTexture=!1,this._initFBOPool(),this._updateTimestamp=t.browser.now();const l={};this._visibleDemTiles=[];for(const t of this.proxyCoords){const e=this.terrainTileForTile[t.key];if(!e)continue;const i=e.tileID.key;i in l||(this._visibleDemTiles.push(e),l[i]=i);}}_assignTerrainTiles(t){this._initializing||t.forEach(t=>{if(this.terrainTileForTile[t.key])return;const e=this._findTileCoveringTileID(t,this.sourceCache);e&&(this.terrainTileForTile[t.key]=e);});}_prepareDEMTextures(){const t=this.painter.context,e=t.gl;for(const i in this.terrainTileForTile){const o=this.terrainTileForTile[i],a=o.dem;!a||o.demTexture&&!o.needsDEMTextureUpload||(t.activeTexture.set(e.TEXTURE1),De(this.painter,o,a));}}_prepareDemTileUniforms(t,e,i,o){if(!e||null==e.demTexture)return !1;const a=t.tileID.canonical,r=Math.pow(2,e.tileID.canonical.z-a.z),n=o||"";return i[`u_dem_tl${n}`]=[a.x*r%1,a.y*r%1],i[`u_dem_scale${n}`]=r,!0}get emptyDEMTexture(){return !this._emptyDEMTextureDirty&&this._emptyDEMTexture?this._emptyDEMTexture:this._updateEmptyDEMTexture()}_getLoadedAreaMinimum(){let t=0;const e=this._visibleDemTiles.reduce((e,i)=>{if(!i.dem)return e;const o=i.dem.tree.minimums[0];return o>0&&t++,e+o},0);return t?e/t:0}_updateEmptyDEMTexture(){const e=this.painter.context,i=e.gl;e.activeTexture.set(i.TEXTURE2);const o=this._getLoadedAreaMinimum(),a={width:1,height:1,data:new Uint8Array(t.DEMData.pack(o,this.sourceCache.getSource().encoding))};this._emptyDEMTextureDirty=!1;let r=this._emptyDEMTexture;return r?r.update(a,{premultiply:!1}):r=this._emptyDEMTexture=new t.Texture(e,a,i.RGBA,{premultiply:!1}),r}setupElevationDraw(e,i,o){const a=this.painter.context,r=a.gl,n=(s=this.sourceCache.getSource().encoding,{u_dem:2,u_dem_prev:4,u_dem_unpack:t.DEMData.getUnpackVector(s),u_dem_tl:[0,0],u_dem_tl_prev:[0,0],u_dem_scale:0,u_dem_scale_prev:0,u_dem_size:0,u_dem_lerp:1,u_depth:3,u_depth_size_inv:[0,0],u_exaggeration:0});var s;n.u_dem_size=this.sourceCache.getSource().tileSize,n.u_exaggeration=this.exaggeration();let l=null,c=null,h=1;if(o&&o.morphing){const t=o.morphing.srcDemTile,i=o.morphing.dstDemTile;h=o.morphing.phase,t&&i&&(this._prepareDemTileUniforms(e,t,n,"_prev")&&(c=t),this._prepareDemTileUniforms(e,i,n)&&(l=i));}if(c&&l?(a.activeTexture.set(r.TEXTURE2),l.demTexture.bind(r.NEAREST,r.CLAMP_TO_EDGE,r.NEAREST),a.activeTexture.set(r.TEXTURE4),c.demTexture.bind(r.NEAREST,r.CLAMP_TO_EDGE,r.NEAREST),n.u_dem_lerp=h):(l=this.terrainTileForTile[e.tileID.key],a.activeTexture.set(r.TEXTURE2),(this._prepareDemTileUniforms(e,l,n)?l.demTexture:this.emptyDEMTexture).bind(r.NEAREST,r.CLAMP_TO_EDGE,r.NEAREST)),o&&o.useDepthForOcclusion&&(a.activeTexture.set(r.TEXTURE3),this._depthTexture.bind(r.NEAREST,r.CLAMP_TO_EDGE,r.NEAREST),n.u_depth_size_inv=[1/this._depthFBO.width,1/this._depthFBO.height]),o&&o.useMeterToDem&&l){const e=(1<<l.tileID.canonical.z)*t.mercatorZfromAltitude(1,this.painter.transform.center.lat)*this.sourceCache.getSource().tileSize;n.u_meter_to_dem=e;}o&&o.labelPlaneMatrixInv&&(n.u_label_plane_matrix_inv=o.labelPlaneMatrixInv),i.setTerrainUniformValues(a,n);}renderLayer(t,e){return "translucent"!==this.painter.renderPass?(this._depthDone||"symbol"!==t.type&&"circle"!==t.type||this.drawDepth(),!0):this.drapeFirst&&this.drapeFirstPending?(this.render(),this.drapeFirstPending=!1,!0):!!this._isLayerDrapedOverTerrain(t)&&(this.drapeFirst&&!this.renderingToTexture||this.render(),!0)}render(){this.renderingToTexture=!0;const e=this.painter,i=this.painter.context,o=this.proxySourceCache,a=this.proxiedCoords[o.id],r=()=>{i.bindFramebuffer.set(null),i.viewport.set([0,0,e.width,e.height]),this.renderingToTexture=!1;},n=e.currentLayer;let s=n,l=[];const c=e.style._order;let h=0;for(let u=0;u<a.length;u++){const d=a[u],_=o.getTileByID(d.proxyTileKey),m=o.proxyCachedFBO[d.key],p=this.currentFBO=void 0!==m?o.renderCache[m]:this.pool[h++];if(_.texture=p.tex,void 0!==m&&!p.dirty){l.push(_.tileID);continue}let f;for(i.bindFramebuffer.set(p.fb.framebuffer),this.renderedToTile=!1,p.dirty&&(i.clear({color:t.Color.transparent}),p.dirty=!1),e.currentLayer=n;e.currentLayer<c.length;e.currentLayer++){const t=e.style._layers[c[e.currentLayer]],o=t.isHidden(e.transform.zoom),a=this._isLayerDrapedOverTerrain(t);if(this.drapeFirst&&!a)continue;if(e.currentLayer>s){if(!o&&!a)break;s++;}if(o)continue;const r=this.painter.style._getLayerSourceCache(t),n=r?this.proxyToSource[d.key][r.id]:[d];if(!n)continue;const l=n;i.viewport.set([0,0,p.fb.width,p.fb.height]),f!==(r?r.id:null)&&(this._setupStencil(n,t,r),f=r?r.id:null),e.renderLayer(e,r,t,l);}p.dirty=this.renderedToTile,this.renderedToTile&&l.push(_.tileID),5===h&&(h=0,l.length>0&&(r(),Fe(e,this,o,l,this._updateTimestamp),this.renderingToTexture=!0,l=[]));}r(),l.length>0&&Fe(e,this,o,l,this._updateTimestamp),e.currentLayer=this.drapeFirst?-1:s;}raycast(t,e,i){if(!this._visibleDemTiles)return null;const o=this._visibleDemTiles.filter(t=>t.dem).map(o=>{const a=o.tileID,r=Math.pow(2,a.overscaledZ),{x:n,y:s}=a.canonical,l=n/r,c=(n+1)/r,h=s/r,u=(s+1)/r;return {minx:l,miny:h,maxx:c,maxy:u,t:o.dem.tree.raycastRoot(l,h,c,u,t,e,i),tile:o}});o.sort((t,e)=>(null!==t.t?t.t:Number.MAX_VALUE)-(null!==e.t?e.t:Number.MAX_VALUE));for(const a of o){if(null==a.t)return null;const o=a.tile.dem.tree.raycast(a.minx,a.miny,a.maxx,a.maxy,t,e,i);if(null!=o)return o}return null}_createFBO(){const e=this.painter.context,i=e.gl,o=this.drapeBufferSize;e.activeTexture.set(i.TEXTURE0);const a=new t.Texture(e,{width:o[0],height:o[1],data:null},i.RGBA);a.bind(i.LINEAR,i.CLAMP_TO_EDGE);const r=e.createFramebuffer(o[0],o[1],!1);return r.colorAttachment.set(a.texture),e.extTextureFilterAnisotropic&&!e.extTextureFilterAnisotropicForceOff&&i.texParameterf(i.TEXTURE_2D,e.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.extTextureFilterAnisotropicMax),{fb:r,tex:a,dirty:!1,ref:1}}_initFBOPool(){for(;this.pool.length<Math.min(5,this.proxyCoords.length);)this.pool.push(this._createFBO());}_shouldDisableRenderCache(){return !this.drapeFirst||this.painter.style._order.some(t=>{const e=this.painter.style._layers[t],i=!e.isHidden(this.painter.transform.zoom),o=e.getCrossfadeParameters();return "custom"!==e.type&&!i&&!!o&&1!==o.t})}_clearRasterFadeFromRenderCache(){for(const t in this.painter.style._sourceCaches)if(!(this.painter.style._sourceCaches[t]._source instanceof z))return;for(let t=0;t<this.painter.style._order.length;++t){const e=this.painter.style._layers[this.painter.style._order[t]],i=e.isHidden(this.painter.transform.zoom),o=this.painter.style._getLayerSourceCache(e);if("raster"!==e.type||i||!o)continue;const a=e.paint.get("raster-fade-duration");for(const t of this.proxyCoords){const e=this.proxyToSource[t.key][o.id];if(e)for(const t of e){const e=Ze(o.getTile(t),o.findLoadedParent(t,0),o,this.painter.transform,a);(1!==e.opacity||0!==e.mix)&&this._clearRenderCacheForTile(o.id,t);}}}}_setupRenderCache(t){const e=this.proxySourceCache;if(this._shouldDisableRenderCache()){if(e.renderCache.length>e.renderCachePool.length){const t=Object.values(e.proxyCachedFBO);e.proxyCachedFBO={},e.renderCachePool=e.renderCachePool.concat(t);}return}this._clearRasterFadeFromRenderCache();const i=this.proxyCoords,o=this._tilesDirty;for(let a=i.length-1;a>=0;a--){const r=i[a];if(e.getTileByID(r.key),void 0!==e.proxyCachedFBO[r.key]){const i=t[r.key],a=this.proxyToSource[r.key];let n=0;for(const t in a){const e=a[t],r=i[t];if(!r||r.length!==e.length||e.some((e,i)=>e!==r[i]||o[t]&&o[t].hasOwnProperty(e.key))){n=-1;break}++n;}e.renderCache[e.proxyCachedFBO[r.key]].dirty=n<0||n!==Object.values(i).length;}else {let t=e.renderCachePool.pop();void 0===t&&e.renderCache.length<50&&(t=e.renderCache.length,e.renderCache.push(this._createFBO())),void 0!==t&&(e.proxyCachedFBO[r.key]=t,e.renderCache[t].dirty=!0);}}this._tilesDirty={};}_setupStencil(e,i,o){if(!o||!this._sourceTilesOverlap[o.id])return void(this._overlapStencilType&&(this._overlapStencilType=!1));const a=this.painter.context,r=a.gl;if(e.length<=1)return void(this._overlapStencilType=!1);const n=this.currentFBO,s=n.fb;let l;if(i.isTileClipped())l=e.length,this._overlapStencilMode.test={func:r.EQUAL,mask:255},this._overlapStencilType="Clip";else {if(!(e[0].overscaledZ>e[e.length-1].overscaledZ))return void(this._overlapStencilType=!1);l=1,this._overlapStencilMode.test={func:r.GREATER,mask:255},this._overlapStencilType="Mask";}if(!s.depthAttachment){const e=a.createRenderbuffer(a.gl.DEPTH_STENCIL,s.width,s.height);s.depthAttachment=new t.DepthStencilAttachment(a,s.framebuffer),s.depthAttachment.set(e),a.clear({stencil:0});}n.ref+l>255&&(a.clear({stencil:0}),n.ref=0),n.ref+=l,this._overlapStencilMode.ref=n.ref,i.isTileClipped()&&this._renderTileClippingMasks(e,this._overlapStencilMode.ref);}stencilModeForRTTOverlap(e){return this.renderingToTexture&&this._overlapStencilType?("Clip"===this._overlapStencilType&&(this._overlapStencilMode.ref=this.painter._tileClippingMaskIDs[e.key]),this._overlapStencilMode):t.StencilMode.disabled}_renderTileClippingMasks(e,i){const o=this.painter,a=this.painter.context,r=a.gl;o._tileClippingMaskIDs={},a.setColorMode(t.ColorMode.disabled),a.setDepthMode(t.DepthMode.disabled);const n=o.useProgram("clippingMask");for(const s of e){const e=o._tileClippingMaskIDs[s.key]=--i;n.draw(a,r.TRIANGLES,t.DepthMode.disabled,new t.StencilMode({func:r.ALWAYS,mask:0},e,255,r.KEEP,r.KEEP,r.REPLACE),t.ColorMode.disabled,t.CullFaceMode.disabled,Ne(s.posMatrix),"$clipping",o.tileExtentBuffer,o.quadTriangleIndexBuffer,o.tileExtentSegments);}}pointCoordinate(e){const i=this.painter.transform;if(e.x<0||e.x>i.width||e.y<0||e.y>i.height)return null;const o=[e.x,e.y,1,1];t.transformMat4(o,o,i.pixelMatrixInverse),t.scale$1(o,o,1/o[3]),o[0]/=i.worldSize,o[1]/=i.worldSize;const a=i._camera.position,r=t.mercatorZfromAltitude(1,i.center.lat),n=[a[0],a[1],a[2]/r,0],s=t.subtract([],o.slice(0,3),n);t.normalize(s,s);const l=this.raycast(n,s,this._exaggeration);return null!==l&&l?(t.scaleAndAdd(n,n,s,l),n[3]=n[2],n[2]*=r,n):null}drawDepth(){const e=this.painter,i=e.context,o=this.proxySourceCache,a=Math.ceil(e.width),r=Math.ceil(e.height);if(!this._depthFBO||this._depthFBO.width===a&&this._depthFBO.height===r||(this._depthFBO.destroy(),delete this._depthFBO,delete this._depthTexture),!this._depthFBO){const e=i.gl,o=i.createFramebuffer(a,r,!0);i.activeTexture.set(e.TEXTURE0);const n=new t.Texture(i,{width:a,height:r,data:null},e.RGBA);n.bind(e.NEAREST,e.CLAMP_TO_EDGE),o.colorAttachment.set(n.texture);const s=i.createRenderbuffer(i.gl.DEPTH_COMPONENT16,a,r);o.depthAttachment.set(s),this._depthFBO=o,this._depthTexture=n;}i.bindFramebuffer.set(this._depthFBO.framebuffer),i.viewport.set([0,0,a,r]),function(e,i,o,a){const r=e.context,n=r.gl;r.clear({depth:1});const s=e.useProgram("terrainDepth"),l=new t.DepthMode(n.LESS,t.DepthMode.ReadWrite,e.depthRangeFor3D);for(const e of a){const a=o.getTile(e),c=ke(e.posMatrix,0);i.setupElevationDraw(a,s),s.draw(r,n.TRIANGLES,l,t.StencilMode.disabled,t.ColorMode.unblended,t.CullFaceMode.backCCW,c,"terrain_depth",i.gridBuffer,i.gridIndexBuffer,i.gridNoSkirtSegments);}}(e,this,o,this.proxyCoords),i.bindFramebuffer.set(null),i.viewport.set([0,0,e.width,e.height]),this._depthDone=!0;}_isLayerDrapedOverTerrain(t){return !!this.enabled&&Ge.hasOwnProperty(t.type)}_setupProxiedCoordsForOrtho(t,e,i){if(t.getSource()instanceof D)return this._setupProxiedCoordsForImageSource(t,e,i);this._findCoveringTileCache[t.id]=this._findCoveringTileCache[t.id]||{};const o=this.proxiedCoords[t.id]=[],a=this.proxyCoords;for(let e=0;e<a.length;e++){const r=a[e],n=this._findTileCoveringTileID(r,t);if(n){const e=this._createProxiedId(r,n,i[r.key]&&i[r.key][t.id]);o.push(e),this.proxyToSource[r.key][t.id]=[e];}}let r=!1;for(let a=0;a<e.length;a++){const n=t.getTile(e[a]);if(!n||!n.hasData())continue;const s=this._findTileCoveringTileID(n.tileID,this.proxySourceCache);if(s&&s.tileID.canonical.z!==n.tileID.canonical.z){const e=this.proxyToSource[s.tileID.key][t.id],a=this._createProxiedId(s.tileID,n,i[s.tileID.key]&&i[s.tileID.key][t.id]);e?e.splice(e.length-1,0,a):this.proxyToSource[s.tileID.key][t.id]=[a],o.push(a),r=!0;}}this._sourceTilesOverlap[t.id]=r;}_setupProxiedCoordsForImageSource(e,i,o){if(!e.getSource().loaded())return;const a=this.proxiedCoords[e.id]=[],r=this.proxyCoords,n=e.getSource(),s=new t.Point(n.tileID.x,n.tileID.y)._div(1<<n.tileID.z),l=n.coordinates.map(t.MercatorCoordinate.fromLngLat).reduce((t,e)=>(t.min.x=Math.min(t.min.x,e.x-s.x),t.min.y=Math.min(t.min.y,e.y-s.y),t.max.x=Math.max(t.max.x,e.x-s.x),t.max.y=Math.max(t.max.y,e.y-s.y),t),{min:new t.Point(Number.MAX_VALUE,Number.MAX_VALUE),max:new t.Point(-Number.MAX_VALUE,-Number.MAX_VALUE)}),c=(e,i)=>{const o=e.wrap+e.canonical.x/(1<<e.canonical.z),a=e.canonical.y/(1<<e.canonical.z),r=t.EXTENT/(1<<e.canonical.z),n=i.wrap+i.canonical.x/(1<<i.canonical.z),s=i.canonical.y/(1<<i.canonical.z);return o+r<n+l.min.x||o>n+l.max.x||a+r<s+l.min.y||a>s+l.max.y};for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<i.length;t++){const r=e.getTile(i[t]);if(!r||!r.hasData())continue;if(c(n,r.tileID))continue;const s=this._createProxiedId(n,r,o[n.key]&&o[n.key][e.id]),l=this.proxyToSource[n.key][e.id];l?l.push(s):this.proxyToSource[n.key][e.id]=[s],a.push(s);}}}_createProxiedId(e,i,o){let a=this.orthoMatrix;if(o){const t=o.find(t=>t.key===i.tileID.key);if(t)return t}if(i.tileID.key!==e.key){const o=e.canonical.z-i.tileID.canonical.z;let r,n,s;a=t.create();const l=i.tileID.wrap-e.wrap<<e.overscaledZ;o>0?(r=t.EXTENT>>o,n=r*((i.tileID.canonical.x<<o)-e.canonical.x+l),s=r*((i.tileID.canonical.y<<o)-e.canonical.y)):(r=t.EXTENT<<-o,n=t.EXTENT*(i.tileID.canonical.x-(e.canonical.x+l<<-o)),s=t.EXTENT*(i.tileID.canonical.y-(e.canonical.y<<-o))),t.ortho(a,0,r,0,r,0,1),t.translate(a,a,[n,s,0]);}return new Ve(i.tileID,e.key,a)}_findTileCoveringTileID(e,i){let o=i.getTile(e);if(o&&o.hasData())return o;const a=this._findCoveringTileCache[i.id],r=a[e.key];if(o=r?i.getTileByID(r):null,o&&o.hasData()||null===r)return o;let n=o?o.tileID:e,s=n.overscaledZ;const l=i.getSource().minzoom,c=[];if(!r){const a=i.getSource().maxzoom;if(e.canonical.z>=a){const o=e.canonical.z-a;i.getSource().reparseOverscaled?(s=Math.max(e.canonical.z+2,i.transform.tileZoom),n=new t.OverscaledTileID(s,e.wrap,a,e.canonical.x>>o,e.canonical.y>>o)):0!==o&&(s=a,n=new t.OverscaledTileID(s,e.wrap,a,e.canonical.x>>o,e.canonical.y>>o));}n.key!==e.key&&(c.push(n.key),o=i.getTile(n));}const h=t=>{c.forEach(e=>{a[e]=t;}),c.length=0;};for(s-=1;s>=l&&(!o||!o.hasData());s--){o&&h(o.tileID.key);const t=n.calculateScaledKey(s);if(o=i.getTileByID(t),o&&o.hasData())break;const e=a[t];if(null===e)break;void 0===e?c.push(t):o=i.getTileByID(e);}return h(o?o.tileID.key:null),o&&o.hasData()?o:null}findDEMTileFor(t){return this.enabled?this._findTileCoveringTileID(t,this.sourceCache):null}prepareDrawTile(t){this.renderedToTile||(this.renderedToTile=!0);}_clearRenderCacheForTile(t,e){let i=this._tilesDirty[t];i||(i=this._tilesDirty[t]={}),i[e.key]=!0;}}function je(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const o=t[i].split(" ");e.push(o.pop());}return e}class We{static cacheKey(t,e,i){let o=`${t}${i?i.cacheKey:""}`;for(const t of e)o+=`/${t}`;return o}constructor(e,i,o,a,r,n){const s=e.gl;this.program=s.createProgram();const l=je(o.staticAttributes),c=a?a.getBinderAttributes():[],h=l.concat(c),u=o.staticUniforms?je(o.staticUniforms):[],d=a?a.getBinderUniforms():[],_=u.concat(d),m=[];for(const t of _)m.indexOf(t)<0&&m.push(t);let p=a?a.defines():[];p=p.concat(n.map(t=>`#define ${t}`));const f=p.concat(Kt.fragmentSource,o.fragmentSource).join("\n"),g=p.concat(Kt.vertexSource,Ht.vertexSource,o.vertexSource).join("\n"),v=s.createShader(s.FRAGMENT_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(v,f),s.compileShader(v),s.attachShader(this.program,v);const x=s.createShader(s.VERTEX_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(x,g),s.compileShader(x),s.attachShader(this.program,x),this.attributes={};const y={};this.numAttributes=h.length;for(let t=0;t<this.numAttributes;t++)h[t]&&(s.bindAttribLocation(this.program,t,h[t]),this.attributes[h[t]]=t);s.linkProgram(this.program),s.deleteShader(x),s.deleteShader(v);for(let t=0;t<m.length;t++){const e=m[t];if(e&&!y[e]){const t=s.getUniformLocation(this.program,e);t&&(y[e]=t);}}this.fixedUniforms=r(e,y),this.binderUniforms=a?a.getUniforms(e,y):[],-1!==n.indexOf("TERRAIN")&&(this.terrainUniforms=((e,i)=>({u_dem:new t.Uniform1i(e,i.u_dem),u_dem_prev:new t.Uniform1i(e,i.u_dem_prev),u_dem_unpack:new t.Uniform4f(e,i.u_dem_unpack),u_dem_tl:new t.Uniform2f(e,i.u_dem_tl),u_dem_scale:new t.Uniform1f(e,i.u_dem_scale),u_dem_tl_prev:new t.Uniform2f(e,i.u_dem_tl_prev),u_dem_scale_prev:new t.Uniform1f(e,i.u_dem_scale_prev),u_dem_size:new t.Uniform1f(e,i.u_dem_size),u_dem_lerp:new t.Uniform1f(e,i.u_dem_lerp),u_exaggeration:new t.Uniform1f(e,i.u_exaggeration),u_depth:new t.Uniform1i(e,i.u_depth),u_depth_size_inv:new t.Uniform2f(e,i.u_depth_size_inv),u_meter_to_dem:new t.Uniform1f(e,i.u_meter_to_dem),u_label_plane_matrix_inv:new t.UniformMatrix4f(e,i.u_label_plane_matrix_inv)}))(e,y));}setTerrainUniformValues(t,e){if(!this.terrainUniforms)return;const i=this.terrainUniforms;if(!this.failedToCreate){t.program.set(this.program);for(const t in e)i[t].set(e[t]);}}draw(t,e,i,o,a,r,n,s,l,c,h,u,d,_,m,p){const f=t.gl;if(this.failedToCreate)return;t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(o),t.setColorMode(a),t.setCullFace(r);for(const t in this.fixedUniforms)this.fixedUniforms[t].set(n[t]);_&&_.setUniforms(t,this.binderUniforms,u,{zoom:d});const g={[f.LINES]:2,[f.TRIANGLES]:3,[f.LINE_STRIP]:1}[e];for(const i of h.get()){const o=i.vaos||(i.vaos={});(o[s]||(o[s]=new Me)).bind(t,this,l,_?_.getPaintVertexBuffers():[],c,i.vertexOffset,m,p),f.drawElements(e,i.primitiveLength*g,f.UNSIGNED_SHORT,i.primitiveOffset*g*2);}}}function Xe(t,e,i){const o=1/C(i,1,e.transform.tileZoom),a=Math.pow(2,i.tileID.overscaledZ),r=i.tileSize*Math.pow(2,e.transform.tileZoom)/a,n=r*(i.tileID.canonical.x+i.tileID.wrap*a),s=r*i.tileID.canonical.y;return {u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[o,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[n>>16,s>>16],u_pixel_coord_lower:[65535&n,65535&s]}}const He=(e,i,o,a)=>{const r=i.style.light,n=r.properties.get("position"),s=[n.x,n.y,n.z],l=t.create$1();"viewport"===r.properties.get("anchor")&&(t.fromRotation(l,-i.transform.angle),t.transformMat3(s,s,l));const c=r.properties.get("color");return {u_matrix:e,u_lightpos:s,u_lightintensity:r.properties.get("intensity"),u_lightcolor:[c.r,c.g,c.b],u_vertical_gradient:+o,u_opacity:a}},Ke=(e,i,o,a,r,n,s)=>t.extend(He(e,i,o,a),Xe(n,i,s),{u_height_factor:-Math.pow(2,r.overscaledZ)/s.tileSize/8}),Ye=t=>({u_matrix:t}),Je=(e,i,o,a)=>t.extend(Ye(e),Xe(o,i,a)),Qe=(t,e)=>({u_matrix:t,u_world:e}),ti=(e,i,o,a,r)=>t.extend(Je(e,i,o,a),{u_world:r}),ei=(e,i,o,a)=>{const r=e.transform;let n;if("map"===a.paint.get("circle-pitch-alignment")){const t=C(o,1,r.zoom);n=[t,t];}else n=r.pixelsToGLUnits;return {u_camera_to_center_distance:r.cameraToCenterDistance,u_matrix:e.translatePosMatrix(i.posMatrix,o,a.paint.get("circle-translate"),a.paint.get("circle-translate-anchor")),u_device_pixel_ratio:t.browser.devicePixelRatio,u_extrude_scale:n}},ii=t=>{const e=[];return "map"===t.paint.get("circle-pitch-alignment")&&e.push("PITCH_WITH_MAP"),"map"===t.paint.get("circle-pitch-scale")&&e.push("SCALE_WITH_MAP"),e},oi=(e,i,o)=>{const a=t.EXTENT/o.tileSize;return {u_matrix:e,u_camera_to_center_distance:i.cameraToCenterDistance,u_extrude_scale:[i.pixelsToGLUnits[0]/a,i.pixelsToGLUnits[1]/a]}},ai=(t,e,i=1)=>({u_matrix:t,u_color:e,u_overlay:0,u_overlay_scale:i}),ri=(t,e,i,o)=>({u_matrix:t,u_extrude_scale:C(e,1,i),u_intensity:o}),ni=(e,i,o,a)=>{const r=e.transform;return {u_matrix:ui(e,i,o,a),u_ratio:1/C(i,1,r.zoom),u_device_pixel_ratio:t.browser.devicePixelRatio,u_units_to_pixels:[1/r.pixelsToGLUnits[0],1/r.pixelsToGLUnits[1]]}},si=(e,i,o,a,r)=>t.extend(ni(e,i,o,a),{u_image:0,u_image_height:r}),li=(e,i,o,a,r)=>{const n=e.transform,s=hi(i,n);return {u_matrix:ui(e,i,o,r),u_texsize:i.imageAtlasTexture.size,u_ratio:1/C(i,1,n.zoom),u_device_pixel_ratio:t.browser.devicePixelRatio,u_image:0,u_scale:[s,a.fromScale,a.toScale],u_fade:a.t,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},ci=(e,i,o,a,r,n)=>{const s=e.lineAtlas,l=hi(i,e.transform),c="round"===o.layout.get("line-cap"),h=s.getDash(a.from,c),u=s.getDash(a.to,c),d=h.width*r.fromScale,_=u.width*r.toScale;return t.extend(ni(e,i,o,n),{u_patternscale_a:[l/d,-h.height/2],u_patternscale_b:[l/_,-u.height/2],u_sdfgamma:s.width/(256*Math.min(d,_)*t.browser.devicePixelRatio)/2,u_image:0,u_tex_y_a:h.y,u_tex_y_b:u.y,u_mix:r.t})};function hi(t,e){return 1/C(t,1,e.tileZoom)}function ui(t,e,i,o){return t.translatePosMatrix(o||e.tileID.posMatrix,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const di=(t,e,i,o,a)=>{return {u_matrix:t,u_tl_parent:e,u_scale_parent:i,u_buffer_scale:1,u_fade_t:o.mix,u_opacity:o.opacity*a.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:a.paint.get("raster-brightness-min"),u_brightness_high:a.paint.get("raster-brightness-max"),u_saturation_factor:(n=a.paint.get("raster-saturation"),n>0?1-1/(1.001-n):-n),u_contrast_factor:(r=a.paint.get("raster-contrast"),r>0?1/(1-r):1+r),u_spin_weights:_i(a.paint.get("raster-hue-rotate"))};var r,n;};function _i(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return [(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const mi=(t,e,i,o,a,r,n,s,l,c)=>{const h=a.transform;return {u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:h.cameraToCenterDistance,u_pitch:h.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:h.width/h.height,u_fade_change:a.options.fadeDuration?a.symbolFadeChange:1,u_matrix:r,u_label_plane_matrix:n,u_coord_matrix:s,u_is_text:+l,u_pitch_with_map:+o,u_texsize:c,u_texture:0}},pi=(e,i,o,a,r,n,s,l,c,h,u)=>{const d=r.transform;return t.extend(mi(e,i,o,a,r,n,s,l,c,h),{u_gamma_scale:a?Math.cos(d._pitch)*d.cameraToCenterDistance:1,u_device_pixel_ratio:t.browser.devicePixelRatio,u_is_halo:+u})},fi=(e,i,o,a,r,n,s,l,c,h)=>t.extend(pi(e,i,o,a,r,n,s,l,!0,c,!0),{u_texsize_icon:h,u_texture_icon:1}),gi=(t,e,i)=>({u_matrix:t,u_opacity:e,u_color:i}),vi=(e,i,o,a,r,n)=>t.extend(function(t,e,i,o){const a=i.imageManager.getPattern(t.from.toString()),r=i.imageManager.getPattern(t.to.toString()),{width:n,height:s}=i.imageManager.getPixelSize(),l=Math.pow(2,o.tileID.overscaledZ),c=o.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(o.tileID.canonical.x+o.tileID.wrap*l),u=c*o.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:a.tl,u_pattern_br_a:a.br,u_pattern_tl_b:r.tl,u_pattern_br_b:r.br,u_texsize:[n,s],u_mix:e.t,u_pattern_size_a:a.displaySize,u_pattern_size_b:r.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/C(o,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(a,n,o,r),{u_matrix:e,u_opacity:i}),xi={fillExtrusion:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_lightpos:new t.Uniform3f(e,i.u_lightpos),u_lightintensity:new t.Uniform1f(e,i.u_lightintensity),u_lightcolor:new t.Uniform3f(e,i.u_lightcolor),u_vertical_gradient:new t.Uniform1f(e,i.u_vertical_gradient),u_opacity:new t.Uniform1f(e,i.u_opacity)}),fillExtrusionPattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_lightpos:new t.Uniform3f(e,i.u_lightpos),u_lightintensity:new t.Uniform1f(e,i.u_lightintensity),u_lightcolor:new t.Uniform3f(e,i.u_lightcolor),u_vertical_gradient:new t.Uniform1f(e,i.u_vertical_gradient),u_height_factor:new t.Uniform1f(e,i.u_height_factor),u_image:new t.Uniform1i(e,i.u_image),u_texsize:new t.Uniform2f(e,i.u_texsize),u_pixel_coord_upper:new t.Uniform2f(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.Uniform2f(e,i.u_pixel_coord_lower),u_scale:new t.Uniform3f(e,i.u_scale),u_fade:new t.Uniform1f(e,i.u_fade),u_opacity:new t.Uniform1f(e,i.u_opacity)}),fill:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix)}),fillPattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_image:new t.Uniform1i(e,i.u_image),u_texsize:new t.Uniform2f(e,i.u_texsize),u_pixel_coord_upper:new t.Uniform2f(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.Uniform2f(e,i.u_pixel_coord_lower),u_scale:new t.Uniform3f(e,i.u_scale),u_fade:new t.Uniform1f(e,i.u_fade)}),fillOutline:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_world:new t.Uniform2f(e,i.u_world)}),fillOutlinePattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_world:new t.Uniform2f(e,i.u_world),u_image:new t.Uniform1i(e,i.u_image),u_texsize:new t.Uniform2f(e,i.u_texsize),u_pixel_coord_upper:new t.Uniform2f(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.Uniform2f(e,i.u_pixel_coord_lower),u_scale:new t.Uniform3f(e,i.u_scale),u_fade:new t.Uniform1f(e,i.u_fade)}),circle:(e,i)=>({u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_extrude_scale:new t.Uniform2f(e,i.u_extrude_scale),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_matrix:new t.UniformMatrix4f(e,i.u_matrix)}),collisionBox:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_extrude_scale:new t.Uniform2f(e,i.u_extrude_scale)}),collisionCircle:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_inv_matrix:new t.UniformMatrix4f(e,i.u_inv_matrix),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_viewport_size:new t.Uniform2f(e,i.u_viewport_size)}),debug:(e,i)=>({u_color:new t.UniformColor(e,i.u_color),u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_overlay:new t.Uniform1i(e,i.u_overlay),u_overlay_scale:new t.Uniform1f(e,i.u_overlay_scale)}),clippingMask:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix)}),heatmap:(e,i)=>({u_extrude_scale:new t.Uniform1f(e,i.u_extrude_scale),u_intensity:new t.Uniform1f(e,i.u_intensity),u_matrix:new t.UniformMatrix4f(e,i.u_matrix)}),heatmapTexture:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_world:new t.Uniform2f(e,i.u_world),u_image:new t.Uniform1i(e,i.u_image),u_color_ramp:new t.Uniform1i(e,i.u_color_ramp),u_opacity:new t.Uniform1f(e,i.u_opacity)}),hillshade:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_image:new t.Uniform1i(e,i.u_image),u_latrange:new t.Uniform2f(e,i.u_latrange),u_light:new t.Uniform2f(e,i.u_light),u_shadow:new t.UniformColor(e,i.u_shadow),u_highlight:new t.UniformColor(e,i.u_highlight),u_accent:new t.UniformColor(e,i.u_accent)}),hillshadePrepare:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_image:new t.Uniform1i(e,i.u_image),u_dimension:new t.Uniform2f(e,i.u_dimension),u_zoom:new t.Uniform1f(e,i.u_zoom),u_unpack:new t.Uniform4f(e,i.u_unpack)}),line:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_ratio:new t.Uniform1f(e,i.u_ratio),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.Uniform2f(e,i.u_units_to_pixels)}),lineGradient:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_ratio:new t.Uniform1f(e,i.u_ratio),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.Uniform2f(e,i.u_units_to_pixels),u_image:new t.Uniform1i(e,i.u_image),u_image_height:new t.Uniform1f(e,i.u_image_height)}),linePattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_texsize:new t.Uniform2f(e,i.u_texsize),u_ratio:new t.Uniform1f(e,i.u_ratio),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_image:new t.Uniform1i(e,i.u_image),u_units_to_pixels:new t.Uniform2f(e,i.u_units_to_pixels),u_scale:new t.Uniform3f(e,i.u_scale),u_fade:new t.Uniform1f(e,i.u_fade)}),lineSDF:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_ratio:new t.Uniform1f(e,i.u_ratio),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.Uniform2f(e,i.u_units_to_pixels),u_patternscale_a:new t.Uniform2f(e,i.u_patternscale_a),u_patternscale_b:new t.Uniform2f(e,i.u_patternscale_b),u_sdfgamma:new t.Uniform1f(e,i.u_sdfgamma),u_image:new t.Uniform1i(e,i.u_image),u_tex_y_a:new t.Uniform1f(e,i.u_tex_y_a),u_tex_y_b:new t.Uniform1f(e,i.u_tex_y_b),u_mix:new t.Uniform1f(e,i.u_mix)}),raster:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_tl_parent:new t.Uniform2f(e,i.u_tl_parent),u_scale_parent:new t.Uniform1f(e,i.u_scale_parent),u_buffer_scale:new t.Uniform1f(e,i.u_buffer_scale),u_fade_t:new t.Uniform1f(e,i.u_fade_t),u_opacity:new t.Uniform1f(e,i.u_opacity),u_image0:new t.Uniform1i(e,i.u_image0),u_image1:new t.Uniform1i(e,i.u_image1),u_brightness_low:new t.Uniform1f(e,i.u_brightness_low),u_brightness_high:new t.Uniform1f(e,i.u_brightness_high),u_saturation_factor:new t.Uniform1f(e,i.u_saturation_factor),u_contrast_factor:new t.Uniform1f(e,i.u_contrast_factor),u_spin_weights:new t.Uniform3f(e,i.u_spin_weights)}),symbolIcon:(e,i)=>({u_is_size_zoom_constant:new t.Uniform1i(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.Uniform1i(e,i.u_is_size_feature_constant),u_size_t:new t.Uniform1f(e,i.u_size_t),u_size:new t.Uniform1f(e,i.u_size),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_pitch:new t.Uniform1f(e,i.u_pitch),u_rotate_symbol:new t.Uniform1i(e,i.u_rotate_symbol),u_aspect_ratio:new t.Uniform1f(e,i.u_aspect_ratio),u_fade_change:new t.Uniform1f(e,i.u_fade_change),u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_label_plane_matrix:new t.UniformMatrix4f(e,i.u_label_plane_matrix),u_coord_matrix:new t.UniformMatrix4f(e,i.u_coord_matrix),u_is_text:new t.Uniform1i(e,i.u_is_text),u_pitch_with_map:new t.Uniform1i(e,i.u_pitch_with_map),u_texsize:new t.Uniform2f(e,i.u_texsize),u_texture:new t.Uniform1i(e,i.u_texture)}),symbolSDF:(e,i)=>({u_is_size_zoom_constant:new t.Uniform1i(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.Uniform1i(e,i.u_is_size_feature_constant),u_size_t:new t.Uniform1f(e,i.u_size_t),u_size:new t.Uniform1f(e,i.u_size),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_pitch:new t.Uniform1f(e,i.u_pitch),u_rotate_symbol:new t.Uniform1i(e,i.u_rotate_symbol),u_aspect_ratio:new t.Uniform1f(e,i.u_aspect_ratio),u_fade_change:new t.Uniform1f(e,i.u_fade_change),u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_label_plane_matrix:new t.UniformMatrix4f(e,i.u_label_plane_matrix),u_coord_matrix:new t.UniformMatrix4f(e,i.u_coord_matrix),u_is_text:new t.Uniform1i(e,i.u_is_text),u_pitch_with_map:new t.Uniform1i(e,i.u_pitch_with_map),u_texsize:new t.Uniform2f(e,i.u_texsize),u_texture:new t.Uniform1i(e,i.u_texture),u_gamma_scale:new t.Uniform1f(e,i.u_gamma_scale),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_is_halo:new t.Uniform1i(e,i.u_is_halo)}),symbolTextAndIcon:(e,i)=>({u_is_size_zoom_constant:new t.Uniform1i(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.Uniform1i(e,i.u_is_size_feature_constant),u_size_t:new t.Uniform1f(e,i.u_size_t),u_size:new t.Uniform1f(e,i.u_size),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_pitch:new t.Uniform1f(e,i.u_pitch),u_rotate_symbol:new t.Uniform1i(e,i.u_rotate_symbol),u_aspect_ratio:new t.Uniform1f(e,i.u_aspect_ratio),u_fade_change:new t.Uniform1f(e,i.u_fade_change),u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_label_plane_matrix:new t.UniformMatrix4f(e,i.u_label_plane_matrix),u_coord_matrix:new t.UniformMatrix4f(e,i.u_coord_matrix),u_is_text:new t.Uniform1i(e,i.u_is_text),u_pitch_with_map:new t.Uniform1i(e,i.u_pitch_with_map),u_texsize:new t.Uniform2f(e,i.u_texsize),u_texsize_icon:new t.Uniform2f(e,i.u_texsize_icon),u_texture:new t.Uniform1i(e,i.u_texture),u_texture_icon:new t.Uniform1i(e,i.u_texture_icon),u_gamma_scale:new t.Uniform1f(e,i.u_gamma_scale),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_is_halo:new t.Uniform1i(e,i.u_is_halo)}),background:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_opacity:new t.Uniform1f(e,i.u_opacity),u_color:new t.UniformColor(e,i.u_color)}),backgroundPattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_opacity:new t.Uniform1f(e,i.u_opacity),u_image:new t.Uniform1i(e,i.u_image),u_pattern_tl_a:new t.Uniform2f(e,i.u_pattern_tl_a),u_pattern_br_a:new t.Uniform2f(e,i.u_pattern_br_a),u_pattern_tl_b:new t.Uniform2f(e,i.u_pattern_tl_b),u_pattern_br_b:new t.Uniform2f(e,i.u_pattern_br_b),u_texsize:new t.Uniform2f(e,i.u_texsize),u_mix:new t.Uniform1f(e,i.u_mix),u_pattern_size_a:new t.Uniform2f(e,i.u_pattern_size_a),u_pattern_size_b:new t.Uniform2f(e,i.u_pattern_size_b),u_scale_a:new t.Uniform1f(e,i.u_scale_a),u_scale_b:new t.Uniform1f(e,i.u_scale_b),u_pixel_coord_upper:new t.Uniform2f(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.Uniform2f(e,i.u_pixel_coord_lower),u_tile_units_to_pixels:new t.Uniform1f(e,i.u_tile_units_to_pixels)}),terrainRaster:Re,terrainDepth:Re,skybox:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_sun_direction:new t.Uniform3f(e,i.u_sun_direction),u_cubemap:new t.Uniform1i(e,i.u_cubemap),u_opacity:new t.Uniform1f(e,i.u_opacity),u_temporal_offset:new t.Uniform1f(e,i.u_temporal_offset)}),skyboxGradient:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_color_ramp:new t.Uniform1i(e,i.u_color_ramp),u_center_direction:new t.Uniform3f(e,i.u_center_direction),u_radius:new t.Uniform1f(e,i.u_radius),u_opacity:new t.Uniform1f(e,i.u_opacity),u_temporal_offset:new t.Uniform1f(e,i.u_temporal_offset)}),skyboxCapture:(e,i)=>({u_matrix_3f:new t.UniformMatrix3f(e,i.u_matrix_3f),u_sun_direction:new t.Uniform3f(e,i.u_sun_direction),u_sun_intensity:new t.Uniform1f(e,i.u_sun_intensity),u_color_tint_r:new t.Uniform4f(e,i.u_color_tint_r),u_color_tint_m:new t.Uniform4f(e,i.u_color_tint_m),u_luminance:new t.Uniform1f(e,i.u_luminance)})};let yi;function bi(e,i,o,a,r,n,s){const l=e.context,c=l.gl,h=e.useProgram("collisionBox"),u=[];let d=0,_=0;for(let m=0;m<a.length;m++){const p=a[m],f=i.getTile(p),g=f.getBucket(o);if(!g)continue;let v=p.posMatrix;0===r[0]&&0===r[1]||(v=e.translatePosMatrix(p.posMatrix,f,r,n));const x=s?g.textCollisionBox:g.iconCollisionBox,y=g.collisionCircleArray;if(y.length>0){const i=t.create(),o=v;t.mul(i,g.placementInvProjMatrix,e.transform.glCoordMatrix),t.mul(i,i,g.placementViewportMatrix),u.push({circleArray:y,circleOffset:_,transform:o,invTransform:i}),d+=y.length/4,_=d;}x&&(e.terrain&&e.terrain.setupElevationDraw(f,h),h.draw(l,c.LINES,t.DepthMode.disabled,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.disabled,oi(v,e.transform,f),o.id,x.layoutVertexBuffer,x.indexBuffer,x.segments,null,e.transform.zoom,null,x.collisionVertexBuffer,x.collisionVertexBufferExt));}if(!s||!u.length)return;const m=e.useProgram("collisionCircle"),p=new t.StructArrayLayout2f1f2i16;p.resize(4*d),p._trim();let f=0;for(const t of u)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,o=t.circleArray[i+0],a=t.circleArray[i+1],r=t.circleArray[i+2],n=t.circleArray[i+3];p.emplace(f++,o,a,r,n,0),p.emplace(f++,o,a,r,n,1),p.emplace(f++,o,a,r,n,2),p.emplace(f++,o,a,r,n,3);}(!yi||yi.length<2*d)&&(yi=function(e){const i=2*e,o=new t.StructArrayLayout3ui6;o.resize(i),o._trim();for(let t=0;t<i;t++){const e=6*t;o.uint16[e+0]=4*t+0,o.uint16[e+1]=4*t+1,o.uint16[e+2]=4*t+2,o.uint16[e+3]=4*t+2,o.uint16[e+4]=4*t+3,o.uint16[e+5]=4*t+0;}return o}(d));const g=l.createIndexBuffer(yi,!0),v=l.createVertexBuffer(p,t.collisionCircleLayout.members,!0);for(const i of u){const a={u_matrix:i.transform,u_inv_matrix:i.invTransform,u_camera_to_center_distance:(x=e.transform).cameraToCenterDistance,u_viewport_size:[x.width,x.height]};m.draw(l,c.TRIANGLES,t.DepthMode.disabled,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.disabled,a,o.id,v,g,t.SegmentVector.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,e.transform.zoom,null,null,null);}var x;v.destroy(),g.destroy();}const wi=t.identity(new Float32Array(16));function Ti(e,i,o,a,r,n){const{horizontalAlign:s,verticalAlign:l}=t.getAnchorAlignment(e),c=-(s-.5)*i,h=-(l-.5)*o,u=t.evaluateVariableOffset(e,a);return new t.Point((c/r+u[0])*n,(h/r+u[1])*n)}function Ei(e,i,o,a,r,n,s,l,c,h,u,d){const _=e.text.placedSymbolArray,m=e.text.dynamicLayoutVertexArray,p=e.icon.dynamicLayoutVertexArray,f={};m.clear();for(let p=0;p<_.length;p++){const g=_.get(p),v=e.allowVerticalPlacement&&!g.placedOrientation,x=g.hidden||!g.crossTileID||v?null:a[g.crossTileID];if(x){const a=new t.Point(g.anchorX,g.anchorY),_=d(a),p=at(a,o?l:s,_),v=rt(n.cameraToCenterDistance,p.signedDistanceFromCamera);let y=r.evaluateSizeForFeature(e.textSizeData,h,g)*v/t.ONE_EM;o&&(y*=e.tilePixelRatio/c);const{width:b,height:w,anchor:T,textOffset:E,textBoxScale:C}=x,S=Ti(T,b,w,E,C,y),I=o?at(a.add(S),s,_).point:p.point.add(i?S.rotate(-n.angle):S),P=e.allowVerticalPlacement&&g.placedOrientation===t.WritingMode.vertical?Math.PI/2:0;for(let e=0;e<g.numGlyphs;e++)t.addDynamicAttributes(m,I,P);u&&g.associatedIconIndex>=0&&(f[g.associatedIconIndex]={shiftedAnchor:I,angle:P});}else mt(g.numGlyphs,m);}if(u){p.clear();const i=e.icon.placedSymbolArray;for(let e=0;e<i.length;e++){const o=i.get(e);if(o.hidden)mt(o.numGlyphs,p);else {const i=f[e];if(i)for(let e=0;e<o.numGlyphs;e++)t.addDynamicAttributes(p,i.shiftedAnchor,i.angle);else mt(o.numGlyphs,p);}}e.icon.dynamicLayoutVertexBuffer.updateData(p);}e.text.dynamicLayoutVertexBuffer.updateData(m);}function Ci(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function Si(e,i,o,a,r,n,s,l,c,h,u,d){const _=e.context,m=_.gl,p=e.transform,f="map"===l,g="map"===c,v=f&&"point"!==o.layout.get("symbol-placement"),x=f&&!g&&!v,y=void 0!==o.layout.get("symbol-sort-key").constantOr(1);let b=!1;const w=e.depthModeForSublayer(0,t.DepthMode.ReadOnly),T=o.layout.get("text-variable-anchor"),E=[],S=e.terrain&&g?["PITCH_WITH_MAP_TERRAIN"]:null;for(const l of a){const a=i.getTile(l),c=a.getBucket(o);if(!c)continue;const u=r?c.text:c.icon;if(!u||!u.segments.get().length)continue;const d=u.programConfigurations.get(o.id),_=r||c.sdfIcons,w=r?c.textSizeData:c.iconSizeData,I=g||0!==p.pitch,P=e.useProgram(Ci(_,r,c),d,S),M=t.evaluateSizeForZoom(w,p.zoom);let z,A,D,L,R=[0,0],k=null;if(r){if(A=a.glyphAtlasTexture,D=m.LINEAR,z=a.glyphAtlasTexture.size,c.iconsInText){R=a.imageAtlasTexture.size,k=a.imageAtlasTexture;const t="composite"===w.kind||"camera"===w.kind;L=I||e.options.rotating||e.options.zooming||t?m.LINEAR:m.NEAREST;}}else {const t=1!==o.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;A=a.imageAtlasTexture,D=_||e.options.rotating||e.options.zooming||t||I?m.LINEAR:m.NEAREST,z=a.imageAtlasTexture.size;}const B=C(a,1,e.transform.zoom),O=it(l.posMatrix,g,f,e.transform,B),F=e.terrain&&g&&v?t.invert(new Float32Array(16),O):wi,U=ot(l.posMatrix,g,f,e.transform,B),N=T&&c.hasTextData(),Z="none"!==o.layout.get("icon-text-fit")&&N&&c.hasIconData();if(v){const t=p.elevation;st(c,l.posMatrix,e,r,O,U,g,h,t?e=>t.getAtTileOffset(l,e.x,e.y):null);}const G=e.translatePosMatrix(l.posMatrix,a,n,s),q=v||r&&T||Z?wi:O,V=e.translatePosMatrix(U,a,n,s,!0),$=_&&0!==o.paint.get(r?"text-halo-width":"icon-halo-width").constantOr(1);let j;j=_?c.iconsInText?fi(w.kind,M,x,g,e,G,q,V,z,R):pi(w.kind,M,x,g,e,G,q,V,r,z,!0):mi(w.kind,M,x,g,e,G,q,V,r,z);const W={program:P,buffers:u,uniformValues:j,atlasTexture:A,atlasTextureIcon:k,atlasInterpolation:D,atlasInterpolationIcon:L,isSDF:_,hasHalo:$,tile:a,labelPlaneMatrixInv:F};if(y&&c.canOverlap){b=!0;const e=u.segments.get();for(const i of e)E.push({segments:new t.SegmentVector([i]),sortKey:i.sortKey,state:W});}else E.push({segments:u.segments,sortKey:0,state:W});}b&&E.sort((t,e)=>t.sortKey-e.sortKey);for(const t of E){const i=t.state;if(e.terrain&&e.terrain.setupElevationDraw(i.tile,i.program,{useDepthForOcclusion:!0,labelPlaneMatrixInv:i.labelPlaneMatrixInv}),_.activeTexture.set(m.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,m.CLAMP_TO_EDGE),i.atlasTextureIcon&&(_.activeTexture.set(m.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,m.CLAMP_TO_EDGE)),i.isSDF){const a=i.uniformValues;i.hasHalo&&(a.u_is_halo=1,Ii(i.buffers,t.segments,o,e,i.program,w,u,d,a)),a.u_is_halo=0;}Ii(i.buffers,t.segments,o,e,i.program,w,u,d,i.uniformValues);}}function Ii(e,i,o,a,r,n,s,l,c){const h=a.context;r.draw(h,h.gl.TRIANGLES,n,s,l,t.CullFaceMode.disabled,c,o.id,e.layoutVertexBuffer,e.indexBuffer,i,o.paint,a.transform.zoom,e.programConfigurations.get(o.id),e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer);}function Pi(e,i,o,a,r,n,s){const l=e.context.gl,c=o.paint.get("fill-pattern"),h=c&&c.constantOr(1),u=o.getCrossfadeParameters();let d,_,m,p,f;s?(_=h&&!o.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",d=l.LINES):(_=h?"fillPattern":"fill",d=l.TRIANGLES);for(const g of a){const a=i.getTile(g);if(h&&!a.patternsLoaded())continue;const v=a.getBucket(o);if(!v)continue;e.prepareDrawTile(g);const x=v.programConfigurations.get(o.id),y=e.useProgram(_,x);h&&(e.context.activeTexture.set(l.TEXTURE0),a.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),x.updatePaintBuffers(u));const b=c.constantOr(null);if(b&&a.imageAtlas){const t=a.imageAtlas,e=t.patternPositions[b.to.toString()],i=t.patternPositions[b.from.toString()];e&&i&&x.setConstantPatternPositions(e,i);}const w=e.translatePosMatrix(g.posMatrix,a,o.paint.get("fill-translate"),o.paint.get("fill-translate-anchor"));if(s){p=v.indexBuffer2,f=v.segments2;const t=e.terrain&&e.terrain.renderingToTexture?e.terrain.drapeBufferSize:[l.drawingBufferWidth,l.drawingBufferHeight];m="fillOutlinePattern"===_&&h?ti(w,e,u,a,t):Qe(w,t);}else p=v.indexBuffer,f=v.segments,m=h?Je(w,e,u,a):Ye(w);y.draw(e.context,d,r,e.stencilModeForClipping(g),n,t.CullFaceMode.disabled,m,o.id,v.layoutVertexBuffer,p,f,o.paint,e.transform.zoom,x);}}function Mi(e,i,o,a,r,n,s){const l=e.context,c=l.gl,h=o.paint.get("fill-extrusion-pattern"),u=h.constantOr(1),d=o.getCrossfadeParameters(),_=o.paint.get("fill-extrusion-opacity");for(const m of a){const a=i.getTile(m),p=a.getBucket(o);if(!p)continue;const f=p.programConfigurations.get(o.id),g=e.useProgram(u?"fillExtrusionPattern":"fillExtrusion",f);if(e.terrain){const t=e.terrain;if(!p.enableTerrain)continue;if(t.setupElevationDraw(a,g,{useMeterToDem:!0}),zi(l,i,m,p,o,t),!p.centroidVertexBuffer){const t=g.attributes.a_centroid_pos;void 0!==t&&c.vertexAttrib2f(t,0,0);}}u&&(e.context.activeTexture.set(c.TEXTURE0),a.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),f.updatePaintBuffers(d));const v=h.constantOr(null);if(v&&a.imageAtlas){const t=a.imageAtlas,e=t.patternPositions[v.to.toString()],i=t.patternPositions[v.from.toString()];e&&i&&f.setConstantPatternPositions(e,i);}const x=e.translatePosMatrix(m.posMatrix,a,o.paint.get("fill-extrusion-translate"),o.paint.get("fill-extrusion-translate-anchor")),y=o.paint.get("fill-extrusion-vertical-gradient"),b=u?Ke(x,e,y,_,m,d,a):He(x,e,y,_);g.draw(l,l.gl.TRIANGLES,r,n,s,t.CullFaceMode.backCCW,b,o.id,p.layoutVertexBuffer,p.indexBuffer,p.segments,o.paint,e.transform.zoom,f,e.terrain?p.centroidVertexBuffer:null);}}function zi(e,i,o,a,r,n){const s=[e=>{let i=e.canonical.x-1,o=e.wrap;return i<0&&(i=(1<<e.canonical.z)-1,o--),new t.OverscaledTileID(e.overscaledZ,o,e.canonical.z,i,e.canonical.y)},e=>{let i=e.canonical.x+1,o=e.wrap;return i===1<<e.canonical.z&&(i=0,o++),new t.OverscaledTileID(e.overscaledZ,o,e.canonical.z,i,e.canonical.y)},e=>new t.OverscaledTileID(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,(0===e.canonical.y?1<<e.canonical.z:e.canonical.y)-1),e=>new t.OverscaledTileID(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y===(1<<e.canonical.z)-1?0:e.canonical.y+1)],l=t=>{const e=i.getSource().maxzoom;for(const o of [0,-1,1]){if(t.overscaledZ+o<e)continue;if(o>0&&t.overscaledZ<e)continue;const a=i.getTileByID(t.calculateScaledKey(t.overscaledZ+o));if(a&&a.hasData()){const t=a.getBucket(r);if(t)return t}}},c=[0,0,0],h=(e,i)=>(c[0]=Math.min(e.min.y,i.min.y),c[1]=Math.max(e.max.y,i.max.y),c[2]=t.EXTENT-i.min.x>e.max.x?i.min.x-t.EXTENT:e.max.x,c),u=(e,i)=>(c[0]=Math.min(e.min.x,i.min.x),c[1]=Math.max(e.max.x,i.max.x),c[2]=t.EXTENT-i.min.y>e.max.y?i.min.y-t.EXTENT:e.max.y,c),d=[(t,e)=>h(t,e),(t,e)=>h(e,t),(t,e)=>u(t,e),(t,e)=>u(e,t)],_=new t.Point(0,0);let m,p,f;const g=(e,i,a,r,s)=>{const l=[[r?a:e,r?e:a,0],[r?a:i,r?i:a,0]],c=s<0?t.EXTENT+s:s,h=[r?c:(e+i)/2,r?(e+i)/2:c,0];return 0===a&&s<0||0!==a&&s>0?n.getForTilePoints(f,[h],!0,p):l.push(h),n.getForTilePoints(o,l,!0,m),Math.max(l[0][2],l[1][2],h[2])/n.exaggeration()};for(let e=0;e<4;e++){const i=a.borders[e];if(0===i.length&&(a.borderDone[e]=!0),a.borderDone[e])continue;const r=f=s[e](o),c=l(r);if(!c||!c.enableTerrain)continue;if(p=n.findDEMTileFor(r),!p||!p.dem)continue;if(!m){const t=n.findDEMTileFor(o);if(!t||!t.dem)return;m=t;}const h=(e<2?1:5)-e,u=c.borders[h];let v=0;for(let o=0;o<i.length;o++){const r=a.featuresOnBorder[i[o]],n=r.borders[e];let s;for(;v<u.length&&(s=c.featuresOnBorder[u[v]],!(s.borders[h][1]>n[0]+3));)c.borderDone[h]||c.encodeCentroid(void 0,s,!1),v++;if(s&&v<u.length){const i=v;let o=0;for(;!(s.borders[h][0]>n[1]-3)&&(o++,++v!==u.length);)s=c.featuresOnBorder[u[v]];if(s=c.featuresOnBorder[u[i]],r.intersectsCount()>1||s.intersectsCount()>1||1!==o){1!==o&&(v=i),a.encodeCentroid(void 0,r,!1),c.borderDone[h]||c.encodeCentroid(void 0,s,!1);continue}const l=d[e](r,s),m=e%2?t.EXTENT-1:0;_.x=g(l[0],Math.min(t.EXTENT-1,l[1]),m,e<2,l[2]),_.y=0,a.encodeCentroid(_,r,!1),c.borderDone[h]||c.encodeCentroid(_,s,!1);}else a.encodeCentroid(void 0,r,!1);}a.borderDone[e]=a.needsCentroidUpdate=!0,c.borderDone[h]||(c.borderDone[h]=c.needsCentroidUpdate=!0);}(a.needsCentroidUpdate||!a.centroidVertexBuffer&&0!==a.centroidVertexArray.length)&&a.uploadCentroid(e);}const Ai=new t.Color(1,0,0,1),Di=new t.Color(0,1,0,1),Li=new t.Color(0,0,1,1),Ri=new t.Color(1,0,1,1),ki=new t.Color(0,1,1,1);function Bi(t,e,i,o){Fi(t,0,e+i/2,t.transform.width,i,o);}function Oi(t,e,i,o){Fi(t,e-i/2,0,i,t.transform.height,o);}function Fi(e,i,o,a,r,n){const s=e.context,l=s.gl;l.enable(l.SCISSOR_TEST),l.scissor(i*t.browser.devicePixelRatio,o*t.browser.devicePixelRatio,a*t.browser.devicePixelRatio,r*t.browser.devicePixelRatio),s.clear({color:n}),l.disable(l.SCISSOR_TEST);}function Ui(e,i,o){const a=e.context,r=a.gl,n=o.posMatrix,s=e.useProgram("debug"),l=i.getTileByID(o.key);e.terrain&&e.terrain.setupElevationDraw(l,s);const c=t.DepthMode.disabled,h=t.StencilMode.disabled,u=e.colorModeForRenderPass();a.activeTexture.set(r.TEXTURE0),e.emptyTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE),s.draw(a,r.LINE_STRIP,c,h,u,t.CullFaceMode.disabled,ai(n,t.Color.red),"$debug",e.debugBuffer,e.tileBorderIndexBuffer,e.debugSegments);const d=l.latestRawTileData,_=Math.floor((d&&d.byteLength||0)/1024),m=i.getTile(o).tileSize,p=512/Math.min(m,512)*(o.overscaledZ/e.transform.zoom)*.5;let f=o.canonical.toString();o.overscaledZ!==o.canonical.z&&(f+=` => ${o.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,o=t.context.gl,a=t.debugOverlayCanvas.getContext("2d");a.clearRect(0,0,i.width,i.height),a.shadowColor="white",a.shadowBlur=2,a.lineWidth=1.5,a.strokeStyle="white",a.textBaseline="top",a.font="bold 36px Open Sans, sans-serif",a.fillText(e,5,5),a.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE);}(e,`${f} ${_}kb`),s.draw(a,r.TRIANGLES,c,h,t.ColorMode.alphaBlended,t.CullFaceMode.disabled,ai(n,t.Color.transparent,p),"$debug",e.debugBuffer,e.quadTriangleIndexBuffer,e.debugSegments);}const Ni=t.createLayout([{name:"a_pos_3f",components:3,type:"Float32"}]),{members:Zi}=Ni;function Gi(t,e,i,o){t.emplaceBack(e,i,o);}class qi{constructor(e){this.vertexArray=new t.StructArrayLayout3f12,this.indices=new t.StructArrayLayout3ui6,Gi(this.vertexArray,-1,-1,1),Gi(this.vertexArray,1,-1,1),Gi(this.vertexArray,-1,1,1),Gi(this.vertexArray,1,1,1),Gi(this.vertexArray,-1,-1,-1),Gi(this.vertexArray,1,-1,-1),Gi(this.vertexArray,-1,1,-1),Gi(this.vertexArray,1,1,-1),this.indices.emplaceBack(5,1,3),this.indices.emplaceBack(3,7,5),this.indices.emplaceBack(6,2,0),this.indices.emplaceBack(0,4,6),this.indices.emplaceBack(2,6,7),this.indices.emplaceBack(7,3,2),this.indices.emplaceBack(5,4,0),this.indices.emplaceBack(0,1,5),this.indices.emplaceBack(0,2,3),this.indices.emplaceBack(3,1,0),this.indices.emplaceBack(7,6,4),this.indices.emplaceBack(4,5,7),this.vertexBuffer=e.createVertexBuffer(this.vertexArray,Zi),this.indexBuffer=e.createIndexBuffer(this.indices),this.segment=t.SegmentVector.simpleSegment(0,0,36,12);}}function Vi(e,i,o,a,r,n){const s=e.gl,l=i.paint.get("sky-atmosphere-color"),c=i.paint.get("sky-atmosphere-halo-color"),h=i.paint.get("sky-atmosphere-sun-intensity"),u=((t,e,i,o,a)=>({u_matrix_3f:t,u_sun_direction:e,u_sun_intensity:i,u_color_tint_r:[o.r,o.g,o.b,o.a],u_color_tint_m:[a.r,a.g,a.b,a.a],u_luminance:5e-5}))(t.fromMat4([],a),r,h,l,c);s.framebufferTexture2D(s.FRAMEBUFFER,s.COLOR_ATTACHMENT0,s.TEXTURE_CUBE_MAP_POSITIVE_X+n,i.skyboxTexture,0),o.draw(e,s.TRIANGLES,t.DepthMode.disabled,t.StencilMode.disabled,t.ColorMode.unblended,t.CullFaceMode.frontCW,u,"skyboxCapture",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}const $i={symbol:function(e,i,o,a,r){if("translucent"!==e.renderPass)return;const n=t.StencilMode.disabled,s=e.colorModeForRenderPass();o.layout.get("text-variable-anchor")&&function(e,i,o,a,r,n,s){const l=i.transform,c="map"===r,h="map"===n;for(const r of e){const e=a.getTile(r),n=e.getBucket(o);if(!n||!n.text||!n.text.segments.get().length)continue;const u=t.evaluateSizeForZoom(n.textSizeData,l.zoom),d=C(e,1,i.transform.zoom),_=it(r.posMatrix,h,c,i.transform,d),m="none"!==o.layout.get("icon-text-fit")&&n.hasIconData();if(u){const i=Math.pow(2,l.zoom-e.tileID.overscaledZ),o=l.elevation;Ei(n,c,h,s,t.symbolSize,l,_,r.posMatrix,i,u,m,o?t=>o.getAtTileOffset(r,t.x,t.y):t=>0);}}}(a,e,o,i,o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),r),0!==o.paint.get("icon-opacity").constantOr(1)&&Si(e,i,o,a,!1,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),o.layout.get("icon-rotation-alignment"),o.layout.get("icon-pitch-alignment"),o.layout.get("icon-keep-upright"),n,s),0!==o.paint.get("text-opacity").constantOr(1)&&Si(e,i,o,a,!0,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),o.layout.get("text-keep-upright"),n,s),i.map.showCollisionBoxes&&(bi(e,i,o,a,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),!0),bi(e,i,o,a,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),!1));},circle:function(e,i,o,a){if("translucent"!==e.renderPass)return;const r=o.paint.get("circle-opacity"),n=o.paint.get("circle-stroke-width"),s=o.paint.get("circle-stroke-opacity"),l=void 0!==o.layout.get("circle-sort-key").constantOr(1);if(0===r.constantOr(1)&&(0===n.constantOr(1)||0===s.constantOr(1)))return;const c=e.context,h=c.gl,u=e.depthModeForSublayer(0,t.DepthMode.ReadOnly),d=t.StencilMode.disabled,_=e.colorModeForRenderPass(),m=[];for(let r=0;r<a.length;r++){const n=a[r],s=i.getTile(n),c=s.getBucket(o);if(!c)continue;const h=c.programConfigurations.get(o.id),u=ii(o),d={programConfiguration:h,program:e.useProgram("circle",h,u),layoutVertexBuffer:c.layoutVertexBuffer,indexBuffer:c.indexBuffer,uniformValues:ei(e,n,s,o),tile:s};if(l){const e=c.segments.get();for(const i of e)m.push({segments:new t.SegmentVector([i]),sortKey:i.sortKey,state:d});}else m.push({segments:c.segments,sortKey:0,state:d});}l&&m.sort((t,e)=>t.sortKey-e.sortKey);for(const i of m){const{programConfiguration:a,program:r,layoutVertexBuffer:n,indexBuffer:s,uniformValues:l,tile:m}=i.state,p=i.segments;e.terrain&&e.terrain.setupElevationDraw(m,r,{useDepthForOcclusion:!0}),r.draw(c,h.TRIANGLES,u,d,_,t.CullFaceMode.disabled,l,o.id,n,s,p,o.paint,e.transform.zoom,a);}},heatmap:function(e,i,o,a){if(0!==o.paint.get("heatmap-opacity"))if("offscreen"===e.renderPass){const r=e.context,n=r.gl,s=t.StencilMode.disabled,l=new t.ColorMode([n.ONE,n.ONE],t.Color.transparent,[!0,!0,!0,!0]);!function(t,e,i){const o=t.gl;t.activeTexture.set(o.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let a=i.heatmapFbo;if(a)o.bindTexture(o.TEXTURE_2D,a.colorAttachment.get()),t.bindFramebuffer.set(a.framebuffer);else {const r=o.createTexture();o.bindTexture(o.TEXTURE_2D,r),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,o.LINEAR),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,o.LINEAR),a=i.heatmapFbo=t.createFramebuffer(e.width/4,e.height/4,!1),function(t,e,i,o){const a=t.gl;a.texImage2D(a.TEXTURE_2D,0,a.RGBA,e.width/4,e.height/4,0,a.RGBA,t.extRenderToTextureHalfFloat?t.extTextureHalfFloat.HALF_FLOAT_OES:a.UNSIGNED_BYTE,null),o.colorAttachment.set(i);}(t,e,r,a);}}(r,e,o),r.clear({color:t.Color.transparent});for(let c=0;c<a.length;c++){const h=a[c];if(i.hasRenderableParent(h))continue;const u=i.getTile(h),d=u.getBucket(o);if(!d)continue;const _=d.programConfigurations.get(o.id),m=e.useProgram("heatmap",_),{zoom:p}=e.transform;e.terrain&&e.terrain.setupElevationDraw(u,m),m.draw(r,n.TRIANGLES,t.DepthMode.disabled,s,l,t.CullFaceMode.disabled,ri(h.posMatrix,u,p,o.paint.get("heatmap-intensity")),o.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,o.paint,e.transform.zoom,_);}r.viewport.set([0,0,e.width,e.height]);}else "translucent"===e.renderPass&&(e.context.setColorMode(e.colorModeForRenderPass()),function(e,i){const o=e.context,a=o.gl,r=i.heatmapFbo;if(!r)return;o.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,r.colorAttachment.get()),o.activeTexture.set(a.TEXTURE1);let n=i.colorRampTexture;n||(n=i.colorRampTexture=new t.Texture(o,i.colorRamp,a.RGBA)),n.bind(a.LINEAR,a.CLAMP_TO_EDGE),e.useProgram("heatmapTexture").draw(o,a.TRIANGLES,t.DepthMode.disabled,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.disabled,((e,i,o,a)=>{const r=t.create();t.ortho(r,0,e.width,e.height,0,0,1);const n=e.context.gl;return {u_matrix:r,u_world:[n.drawingBufferWidth,n.drawingBufferHeight],u_image:0,u_color_ramp:1,u_opacity:i.paint.get("heatmap-opacity")}})(e,i),i.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,i.paint,e.transform.zoom);}(e,o));},line:function(e,i,o,a){if("translucent"!==e.renderPass)return;const r=o.paint.get("line-opacity"),n=o.paint.get("line-width");if(0===r.constantOr(1)||0===n.constantOr(1))return;const s=e.depthModeForSublayer(0,t.DepthMode.ReadOnly),l=e.colorModeForRenderPass(),c=o.paint.get("line-dasharray"),h=o.paint.get("line-pattern"),u=h.constantOr(1),d=o.paint.get("line-gradient"),_=o.getCrossfadeParameters(),m=u?"linePattern":c?"lineSDF":d?"lineGradient":"line",p=e.context,f=p.gl;let g=!0;for(const r of a){const a=i.getTile(r);if(u&&!a.patternsLoaded())continue;const n=a.getBucket(o);if(!n)continue;e.prepareDrawTile(r);const v=n.programConfigurations.get(o.id),x=e.context.program.get(),y=e.useProgram(m,v),b=g||y.program!==x,w=h.constantOr(null);if(w&&a.imageAtlas){const t=a.imageAtlas,e=t.patternPositions[w.to.toString()],i=t.patternPositions[w.from.toString()];e&&i&&v.setConstantPatternPositions(e,i);}const T=e.terrain?r.posMatrix:null,E=u?li(e,a,o,_,T):c?ci(e,a,o,c,_,T):d?si(e,a,o,T,n.lineClipsArray.length):ni(e,a,o,T);if(u)p.activeTexture.set(f.TEXTURE0),a.imageAtlasTexture.bind(f.LINEAR,f.CLAMP_TO_EDGE),v.updatePaintBuffers(_);else if(c&&(b||e.lineAtlas.dirty))p.activeTexture.set(f.TEXTURE0),e.lineAtlas.bind(p);else if(d){const a=n.gradients[o.id];let s=a.texture;if(o.gradientVersion!==a.version){let l=256;if(o.stepInterpolant){const o=i.getSource().maxzoom,a=r.canonical.z===o?Math.ceil(1<<e.transform.maxZoom-r.canonical.z):1;l=t.clamp(t.nextPowerOfTwo(n.maxLineLength/t.EXTENT*1024*a),256,p.maxTextureSize);}a.gradient=t.renderColorRamp({expression:o.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:a.gradient||void 0,clips:n.lineClipsArray}),a.texture?a.texture.update(a.gradient):a.texture=new t.Texture(p,a.gradient,f.RGBA),a.version=o.gradientVersion,s=a.texture;}p.activeTexture.set(f.TEXTURE0),s.bind(o.stepInterpolant?f.NEAREST:f.LINEAR,f.CLAMP_TO_EDGE);}y.draw(p,f.TRIANGLES,s,e.stencilModeForClipping(r),l,t.CullFaceMode.disabled,E,o.id,n.layoutVertexBuffer,n.indexBuffer,n.segments,o.paint,e.transform.zoom,v,n.layoutVertexBuffer2),g=!1;}},fill:function(e,i,o,a){const r=o.paint.get("fill-color"),n=o.paint.get("fill-opacity");if(0===n.constantOr(1))return;const s=e.colorModeForRenderPass(),l=o.paint.get("fill-pattern"),c=e.opaquePassEnabledForLayer()&&!l.constantOr(1)&&1===r.constantOr(t.Color.transparent).a&&1===n.constantOr(0)?"opaque":"translucent";if(e.renderPass===c){const r=e.depthModeForSublayer(1,"opaque"===e.renderPass?t.DepthMode.ReadWrite:t.DepthMode.ReadOnly);Pi(e,i,o,a,r,s,!1);}if("translucent"===e.renderPass&&o.paint.get("fill-antialias")){const r=e.depthModeForSublayer(o.getPaintProperty("fill-outline-color")?2:0,t.DepthMode.ReadOnly);Pi(e,i,o,a,r,s,!0);}},"fill-extrusion":function(e,i,o,a){const r=o.paint.get("fill-extrusion-opacity");if(0!==r&&"translucent"===e.renderPass){const n=new t.DepthMode(e.context.gl.LEQUAL,t.DepthMode.ReadWrite,e.depthRangeFor3D);if(1!==r||o.paint.get("fill-extrusion-pattern").constantOr(1))Mi(e,i,o,a,n,t.StencilMode.disabled,t.ColorMode.disabled),Mi(e,i,o,a,n,e.stencilModeFor3D(),e.colorModeForRenderPass());else {const r=e.colorModeForRenderPass();Mi(e,i,o,a,n,t.StencilMode.disabled,r);}}},hillshade:function(e,i,o,a){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const r=e.context,n=e.depthModeForSublayer(0,t.DepthMode.ReadOnly),s=e.colorModeForRenderPass(),l=e.terrain&&e.terrain.renderingToTexture,[c,h]="translucent"!==e.renderPass||l?[{},a]:e.stencilConfigForOverlap(a);for(const a of h){const r=i.getTile(a);if(r.needsHillshadePrepare&&"offscreen"===e.renderPass)Le(e,r,o,n,t.StencilMode.disabled,s);else if("translucent"===e.renderPass){const t=l&&e.terrain?e.terrain.stencilModeForRTTOverlap(a):c[a.overscaledZ];Ae(e,a,r,o,n,t,s);}}r.viewport.set([0,0,e.width,e.height]);},raster:function(e,i,o,a,r,n){if("translucent"!==e.renderPass)return;if(0===o.paint.get("raster-opacity"))return;if(!a.length)return;const s=e.context,l=s.gl,c=i.getSource(),h=e.useProgram("raster"),u=e.colorModeForRenderPass(),d=e.terrain&&e.terrain.renderingToTexture,[_,m]=c instanceof D||d?[{},a]:e.stencilConfigForOverlap(a),p=m[m.length-1].overscaledZ,f=!e.options.moving;for(const a of m){const r=d?t.DepthMode.disabled:e.depthModeForSublayer(a.overscaledZ-p,1===o.paint.get("raster-opacity")?t.DepthMode.ReadWrite:t.DepthMode.ReadOnly,l.LESS),m=i.getTile(a);if(d&&(!m||!m.hasData()))continue;const g=d?a.posMatrix:e.transform.calculatePosMatrix(a.toUnwrapped(),f),v=e.terrain&&d?e.terrain.stencilModeForRTTOverlap(a):_[a.overscaledZ],x=n?0:o.paint.get("raster-fade-duration");m.registerFadeDuration(x);const y=i.findLoadedParent(a,0),b=Ze(m,y,i,e.transform,x);let w,T;e.terrain&&e.terrain.prepareDrawTile(a);const E="nearest"===o.paint.get("raster-resampling")?l.NEAREST:l.LINEAR;s.activeTexture.set(l.TEXTURE0),m.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST),s.activeTexture.set(l.TEXTURE1),y?(y.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST),w=Math.pow(2,y.tileID.overscaledZ-m.tileID.overscaledZ),T=[m.tileID.canonical.x*w%1,m.tileID.canonical.y*w%1]):m.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST);const C=di(g,T||[0,0],w||1,b,o);c instanceof D?h.draw(s,l.TRIANGLES,r,t.StencilMode.disabled,u,t.CullFaceMode.disabled,C,o.id,c.boundsBuffer,e.quadTriangleIndexBuffer,c.boundsSegments):h.draw(s,l.TRIANGLES,r,v,u,t.CullFaceMode.disabled,C,o.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments);}},background:function(e,i,o,a){const r=o.paint.get("background-color"),n=o.paint.get("background-opacity");if(0===n)return;const s=e.context,l=s.gl,c=e.transform,h=c.tileSize,u=o.paint.get("background-pattern");if(e.isPatternMissing(u))return;const d=!u&&1===r.a&&1===n&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==d)return;const _=t.StencilMode.disabled,m=e.depthModeForSublayer(0,"opaque"===d?t.DepthMode.ReadWrite:t.DepthMode.ReadOnly),p=e.colorModeForRenderPass(),f=e.useProgram(u?"backgroundPattern":"background"),g=a||c.coveringTiles({tileSize:h});u&&(s.activeTexture.set(l.TEXTURE0),e.imageManager.bind(e.context));const v=o.getCrossfadeParameters();for(const i of g){const c=a?i.posMatrix:e.transform.calculatePosMatrix(i.toUnwrapped());e.prepareDrawTile(i);const d=u?vi(c,n,e,u,{tileID:i,tileSize:h},v):gi(c,n,r);f.draw(s,l.TRIANGLES,m,_,p,t.CullFaceMode.disabled,d,o.id,e.tileExtentBuffer,e.quadTriangleIndexBuffer,e.tileExtentSegments);}},sky:function(e,i,o){const a=o.paint.get("sky-opacity");if(0===a)return;const r=e.context,n=o.paint.get("sky-type"),s=new t.DepthMode(r.gl.LEQUAL,t.DepthMode.ReadOnly,[0,1]),l=e.frameCounter/1e3%1;"atmosphere"===n?"offscreen"===e.renderPass?o.needsSkyboxCapture(e)&&(function(e,i,o,a){const r=e.context,n=r.gl;let s=i.skyboxFbo;if(!s){s=i.skyboxFbo=r.createFramebuffer(32,32,!1),i.skyboxGeometry=new qi(r),i.skyboxTexture=r.gl.createTexture(),n.bindTexture(n.TEXTURE_CUBE_MAP,i.skyboxTexture),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_MIN_FILTER,n.LINEAR),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_MAG_FILTER,n.LINEAR);for(let t=0;t<6;++t)n.texImage2D(n.TEXTURE_CUBE_MAP_POSITIVE_X+t,0,n.RGBA,32,32,0,n.RGBA,n.UNSIGNED_BYTE,null);}r.bindFramebuffer.set(s.framebuffer),r.viewport.set([0,0,32,32]);const l=i.getCenter(e,!0),c=e.useProgram("skyboxCapture"),h=new Float64Array(16);t.identity(h),t.rotateY(h,h,.5*-Math.PI),Vi(r,i,c,h,l,0),t.identity(h),t.rotateY(h,h,.5*Math.PI),Vi(r,i,c,h,l,1),t.identity(h),t.rotateX(h,h,.5*-Math.PI),Vi(r,i,c,h,l,2),t.identity(h),t.rotateX(h,h,.5*Math.PI),Vi(r,i,c,h,l,3),t.identity(h),Vi(r,i,c,h,l,4),t.identity(h),t.rotateY(h,h,Math.PI),Vi(r,i,c,h,l,5),r.viewport.set([0,0,e.width,e.height]);}(e,o),o.markSkyboxValid(e)):"sky"===e.renderPass&&function(e,i,o,a,r){const n=e.context,s=n.gl,l=e.transform,c=e.useProgram("skybox");n.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_CUBE_MAP,i.skyboxTexture);const h=((t,e,i,o,a)=>({u_matrix:t,u_sun_direction:e,u_cubemap:0,u_opacity:o,u_temporal_offset:a}))(l.skyboxMatrix,i.getCenter(e,!1),0,a,r);c.draw(n,s.TRIANGLES,o,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.backCW,h,"skybox",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(e,o,s,a,l):"gradient"===n&&"sky"===e.renderPass&&function(e,i,o,a,r){const n=e.context,s=n.gl,l=e.transform,c=e.useProgram("skyboxGradient");i.skyboxGeometry||(i.skyboxGeometry=new qi(n)),n.activeTexture.set(s.TEXTURE0);let h=i.colorRampTexture;h||(h=i.colorRampTexture=new t.Texture(n,i.colorRamp,s.RGBA)),h.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=((e,i,o,a,r)=>({u_matrix:e,u_color_ramp:0,u_center_direction:i,u_radius:t.degToRad(o),u_opacity:a,u_temporal_offset:r}))(l.skyboxMatrix,i.getCenter(e,!1),i.paint.get("sky-gradient-radius"),a,r);c.draw(n,s.TRIANGLES,o,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.backCW,u,"skyboxGradient",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(e,o,s,a,l);},debug:function(t,e,i){for(let o=0;o<i.length;o++)Ui(t,e,i[o]);},custom:function(e,i,o){const a=e.context,r=o.implementation;if("offscreen"===e.renderPass){const t=r.prerender;t&&(e.setCustomLayerDefaults(),a.setColorMode(e.colorModeForRenderPass()),t.call(r,a.gl,e.transform.customLayerMatrix()),a.setDirty(),e.setBaseState());}else if("translucent"===e.renderPass){e.setCustomLayerDefaults(),a.setColorMode(e.colorModeForRenderPass()),a.setStencilMode(t.StencilMode.disabled);const i="3d"===r.renderingMode?new t.DepthMode(e.context.gl.LEQUAL,t.DepthMode.ReadWrite,e.depthRangeFor3D):e.depthModeForSublayer(0,t.DepthMode.ReadOnly);a.setDepthMode(i),r.render(a.gl,e.transform.customLayerMatrix()),a.setDirty(),e.setBaseState(),a.bindFramebuffer.set(null);}}};class ji{constructor(e,i){this.context=new t.Context(e),this.transform=i,this._tileTextures={},this.frameCopies=[],this.loadTimeStamps=[],this.setup(),this.numSublayers=t.SourceCache.maxUnderzooming+t.SourceCache.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new Gt,this.gpuTimers={},this.frameCounter=0;}updateTerrain(t,e){const i=!!t&&!!t.terrain;if(!(i||this._terrain&&this._terrain.enabled))return;this._terrain||(this._terrain=new $e(this,t));const o=this._terrain;this.transform.elevation=i?o:null,o.update(t,this.transform,e);}get terrain(){return this._terrain&&this._terrain.enabled?this._terrain:null}resize(e,i){if(this.width=e*t.browser.devicePixelRatio,this.height=i*t.browser.devicePixelRatio,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style._order)this.style._layers[t].resize();}setup(){const e=this.context,i=new t.StructArrayLayout2i4;i.emplaceBack(0,0),i.emplaceBack(t.EXTENT,0),i.emplaceBack(0,t.EXTENT),i.emplaceBack(t.EXTENT,t.EXTENT),this.tileExtentBuffer=e.createVertexBuffer(i,t.posAttributes.members),this.tileExtentSegments=t.SegmentVector.simpleSegment(0,0,4,2);const o=new t.StructArrayLayout2i4;o.emplaceBack(0,0),o.emplaceBack(t.EXTENT,0),o.emplaceBack(0,t.EXTENT),o.emplaceBack(t.EXTENT,t.EXTENT),this.debugBuffer=e.createVertexBuffer(o,t.posAttributes.members),this.debugSegments=t.SegmentVector.simpleSegment(0,0,4,5);const a=new t.StructArrayLayout4i8;a.emplaceBack(0,0,0,0),a.emplaceBack(t.EXTENT,0,t.EXTENT,0),a.emplaceBack(0,t.EXTENT,0,t.EXTENT),a.emplaceBack(t.EXTENT,t.EXTENT,t.EXTENT,t.EXTENT),this.rasterBoundsBuffer=e.createVertexBuffer(a,A.members),this.rasterBoundsSegments=t.SegmentVector.simpleSegment(0,0,4,2);const r=new t.StructArrayLayout2i4;r.emplaceBack(0,0),r.emplaceBack(1,0),r.emplaceBack(0,1),r.emplaceBack(1,1),this.viewportBuffer=e.createVertexBuffer(r,t.posAttributes.members),this.viewportSegments=t.SegmentVector.simpleSegment(0,0,4,2);const n=new t.StructArrayLayout1ui2;n.emplaceBack(0),n.emplaceBack(1),n.emplaceBack(3),n.emplaceBack(2),n.emplaceBack(0),this.tileBorderIndexBuffer=e.createIndexBuffer(n);const s=new t.StructArrayLayout3ui6;s.emplaceBack(0,1,2),s.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=e.createIndexBuffer(s),this.emptyTexture=new t.Texture(e,{width:1,height:1,data:new Uint8Array([0,0,0,0])},e.gl.RGBA);const l=this.context.gl;this.stencilClearMode=new t.StencilMode({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.loadTimeStamps.push(t.window.performance.now());}clearStencil(){const e=this.context,i=e.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const o=t.create();t.ortho(o,0,this.width,this.height,0,0,1),t.scale(o,o,[i.drawingBufferWidth,i.drawingBufferHeight,0]),this.useProgram("clippingMask").draw(e,i.TRIANGLES,t.DepthMode.disabled,this.stencilClearMode,t.ColorMode.disabled,t.CullFaceMode.disabled,Ne(o),"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(e,i,o){if(!(i&&this.currentStencilSource!==i.id&&e.isTileClipped()&&o&&o.length))return;this.currentStencilSource=i.id;const a=this.context,r=a.gl;this.nextStencilID+o.length>256&&this.clearStencil(),a.setColorMode(t.ColorMode.disabled),a.setDepthMode(t.DepthMode.disabled);const n=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const e of o){const i=this._tileClippingMaskIDs[e.key]=this.nextStencilID++;n.draw(a,r.TRIANGLES,t.DepthMode.disabled,new t.StencilMode({func:r.ALWAYS,mask:0},i,255,r.KEEP,r.KEEP,r.REPLACE),t.ColorMode.disabled,t.CullFaceMode.disabled,Ne(e.posMatrix),"$clipping",this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const e=this.nextStencilID++,i=this.context.gl;return new t.StencilMode({func:i.NOTEQUAL,mask:255},e,255,i.KEEP,i.KEEP,i.REPLACE)}stencilModeForClipping(e){if(this.terrain)return this.terrain.stencilModeForRTTOverlap(e);const i=this.context.gl;return new t.StencilMode({func:i.EQUAL,mask:255},this._tileClippingMaskIDs[e.key],0,i.KEEP,i.KEEP,i.REPLACE)}stencilConfigForOverlap(e){const i=this.context.gl,o=e.sort((t,e)=>e.overscaledZ-t.overscaledZ),a=o[o.length-1].overscaledZ,r=o[0].overscaledZ-a+1;if(r>1){this.currentStencilSource=void 0,this.nextStencilID+r>256&&this.clearStencil();const e={};for(let o=0;o<r;o++)e[o+a]=new t.StencilMode({func:i.GEQUAL,mask:255},o+this.nextStencilID,255,i.KEEP,i.KEEP,i.REPLACE);return this.nextStencilID+=r,[e,o]}return [{[a]:t.StencilMode.disabled},o]}colorModeForRenderPass(){const e=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new t.ColorMode([e.CONSTANT_COLOR,e.ONE],new t.Color(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?t.ColorMode.unblended:t.ColorMode.alphaBlended}depthModeForSublayer(e,i,o){if(!this.opaquePassEnabledForLayer())return t.DepthMode.disabled;const a=1-((1+this.currentLayer)*this.numSublayers+e)*this.depthEpsilon;return new t.DepthMode(o||this.context.gl.LEQUAL,i,[a,a])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(e,i){this.style=e,this.options=i,this.lineAtlas=e.lineAtlas,this.imageManager=e.imageManager,this.glyphManager=e.glyphManager,this.symbolFadeChange=e.placement.symbolFadeChange(t.browser.now()),this.imageManager.beginFrame();const o=this.style._order,a=this.style._sourceCaches;for(const t in a){const e=a[t];e.used&&e.prepare(this.context);}const r={},n={},s={};for(const t in a){const e=a[t];r[t]=e.getVisibleCoordinates(),n[t]=r[t].slice().reverse(),s[t]=e.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let t=0;t<o.length;t++)if(this.style._layers[o[t]].is3D()){this.opaquePassCutoff=t;break}this.terrain&&(this.terrain.updateTileBinding(s),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const t of o){const i=this.style._layers[t],o=e._getLayerSourceCache(i);if(!i.hasOffscreenPass()||i.isHidden(this.transform.zoom))continue;const a=o?n[o.id]:void 0;("custom"===i.type||i.isSky()||a&&a.length)&&this.renderLayer(this,o,i,a);}for(this.context.bindFramebuffer.set(null),this.context.clear({color:i.showOverdrawInspector?t.Color.black:t.Color.transparent,depth:1}),this.clearStencil(),this._showOverdrawInspector=i.showOverdrawInspector,this.depthRangeFor3D=[0,1-(e._order.length+2)*this.numSublayers*this.depthEpsilon],this.renderPass="opaque",this.currentLayer=o.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[o[this.currentLayer]],i=e._getLayerSourceCache(t);if(this.terrain&&this.terrain.renderLayer(t,i)||t.isSky())continue;const a=i?n[i.id]:void 0;this._renderTileClippingMasks(t,i,a),this.renderLayer(this,i,t,a);}if(this.renderPass="sky",this.transform.isHorizonVisible())for(this.currentLayer=0;this.currentLayer<o.length;this.currentLayer++){const t=this.style._layers[o[this.currentLayer]],i=e._getLayerSourceCache(t);t.isSky()&&this.renderLayer(this,i,t,i?n[i.id]:void 0);}for(this.renderPass="translucent",this.currentLayer=0;this.currentLayer<o.length;this.currentLayer++){const t=this.style._layers[o[this.currentLayer]],i=e._getLayerSourceCache(t);if(this.terrain&&this.terrain.renderLayer(t,i)||t.isSky())continue;const a=i?("symbol"===t.type?s:n)[i.id]:void 0;this._renderTileClippingMasks(t,i,i?r[i.id]:void 0),this.renderLayer(this,i,t,a);}if(this.options.showTileBoundaries||this.options.showQueryGeometry){let i=null;t.values(this.style._layers).forEach(t=>{const o=e._getLayerSourceCache(t);o&&!t.isHidden(this.transform.zoom)&&(!i||i.getSource().maxzoom<o.getSource().maxzoom)&&(i=o);}),i&&this.options.showTileBoundaries&&$i.debug(this,i,i.getVisibleCoordinates());}this.options.showPadding&&function(t){const e=t.transform.padding;Bi(t,t.transform.height-(e.top||0),3,Ai),Bi(t,e.bottom||0,3,Di),Oi(t,e.left||0,3,Li),Oi(t,t.transform.width-(e.right||0),3,Ri);const i=t.transform.centerPoint;!function(t,e,i,o){Fi(t,e-1,i-10,2,20,o),Fi(t,e-10,i-1,20,2,o);}(t,i.x,t.transform.height-i.y,ki);}(this),this.context.setDefault(),this.frameCounter=(this.frameCounter+1)%t.MAX_SAFE_INTEGER,this.tileLoaded&&this.options.speedIndexTiming&&(this.loadTimeStamps.push(t.window.performance.now()),this.saveCanvasCopy());}renderLayer(t,e,i,o){i.isHidden(this.transform.zoom)||("background"===i.type||"sky"===i.type||"custom"===i.type||o&&o.length)&&(this.id=i.id,this.gpuTimingStart(i),$i[i.type](t,e,i,o,this.style.placement.variableOffsets,this.options.isInitialLoad),this.gpuTimingEnd());}gpuTimingStart(t){if(!this.options.gpuTiming)return;const e=this.context.extTimerQuery;let i=this.gpuTimers[t.id];i||(i=this.gpuTimers[t.id]={calls:0,cpuTime:0,query:e.createQueryEXT()}),i.calls++,e.beginQueryEXT(e.TIME_ELAPSED_EXT,i.query);}gpuTimingEnd(){if(!this.options.gpuTiming)return;const t=this.context.extTimerQuery;t.endQueryEXT(t.TIME_ELAPSED_EXT);}collectGpuTimers(){const t=this.gpuTimers;return this.gpuTimers={},t}queryGpuTimers(t){const e={};for(const i in t){const o=t[i],a=this.context.extTimerQuery,r=a.getQueryObjectEXT(o.query,a.QUERY_RESULT_EXT)/1e6;a.deleteQueryEXT(o.query),e[i]=r;}return e}translatePosMatrix(e,i,o,a,r){if(!o[0]&&!o[1])return e;const n=r?"map"===a?this.transform.angle:0:"viewport"===a?-this.transform.angle:0;if(n){const t=Math.sin(n),e=Math.cos(n);o=[o[0]*e-o[1]*t,o[0]*t+o[1]*e];}const s=[r?o[0]:C(i,o[0],this.transform.zoom),r?o[1]:C(i,o[1],this.transform.zoom),0],l=new Float32Array(16);return t.translate(l,e,s),l}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t];}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return !1;if(!t.from||!t.to)return !0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return !e||!i}currentGlobalDefines(){const t=this.terrain&&this.terrain.renderingToTexture,e=[];return this.terrain&&!this.terrain.renderingToTexture&&e.push("TERRAIN"),t&&e.push("RENDER_TO_TEXTURE"),this._showOverdrawInspector&&e.push("OVERDRAW_INSPECTOR"),e}useProgram(t,e,i){this.cache=this.cache||{};const o=i||[],a=this.currentGlobalDefines().concat(o),r=We.cacheKey(t,a,e);return this.cache[r]||(this.cache[r]=new We(this.context,t,Pe[t],e,xi[t],a)),this.cache[r]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=t.window.document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new t.Texture(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this._terrain&&this._terrain.destroy(),this.emptyTexture.destroy(),this.debugOverlayTexture&&this.debugOverlayTexture.destroy();}prepareDrawTile(t){this.terrain&&this.terrain.prepareDrawTile(t);}setTileLoadedFlag(t){this.tileLoaded=t;}saveCanvasCopy(){this.frameCopies.push(this.canvasCopy()),this.tileLoaded=!1;}canvasCopy(){const t=this.context.gl,e=t.createTexture();return t.bindTexture(t.TEXTURE_2D,e),t.copyTexImage2D(t.TEXTURE_2D,0,t.RGBA,0,0,t.drawingBufferWidth,t.drawingBufferHeight,0),e}getCanvasCopiesAndTimestamps(){return {canvasCopies:this.frameCopies,timeStamps:this.loadTimeStamps}}}class Wi{constructor(t=0,e=0,i=0,o=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=o;}interpolate(e,i,o){return null!=i.top&&null!=e.top&&(this.top=t.number(e.top,i.top,o)),null!=i.bottom&&null!=e.bottom&&(this.bottom=t.number(e.bottom,i.bottom,o)),null!=i.left&&null!=e.left&&(this.left=t.number(e.left,i.left,o)),null!=i.right&&null!=e.right&&(this.right=t.number(e.right,i.right,o)),this}getCenter(e,i){const o=t.clamp((this.left+e-this.right)/2,0,e),a=t.clamp((this.top+i-this.bottom)/2,0,i);return new t.Point(o,a)}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new Wi(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function Xi(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}function Hi(t,e,i){t[4*e+0]=i[0],t[4*e+1]=i[1],t[4*e+2]=i[2],t[4*e+3]=i[3];}function Ki(e,i){const o=Xi(e,3);t.fromQuat(e,i),Hi(e,3,o);}function Yi(t,e){Hi(t,3,[e[0],e[1],e[2],1]);}function Ji(e,i){const o=t.identity$1([]);return t.rotateZ$1(o,o,-i),t.rotateX$1(o,o,-e),o}function Qi(e,i){const o=[e[0],e[1],0],a=[i[0],i[1],0];if(t.length(o)>=1e-15){const e=t.normalize([],o);t.scale$2(a,e,t.dot(a,e)),i[0]=a[0],i[1]=a[1];}const r=t.cross([],i,e);if(t.len(r)<1e-15)return null;const n=Math.atan2(-r[1],r[0]);return Ji(Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2]),n)}class to{constructor(t,e){this.position=t,this.orientation=e;}get position(){return this._position}set position(e){this._position=this._renderWorldCopies?function(e){if(!e)return;const i=Array.isArray(e)?new t.MercatorCoordinate(e[0],e[1],e[2]):e;return i.x=t.wrap(i.x,0,1),i}(e):e;}lookAtPoint(e,i){if(this.orientation=null,!this.position)return;const o=this._elevation?this._elevation.getAtPoint(t.MercatorCoordinate.fromLngLat(e)):0,a=this.position,r=t.MercatorCoordinate.fromLngLat(e,o),n=[r.x-a.x,r.y-a.y,r.z-a.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=Qi(n,i);}setPitchBearing(e,i){this.orientation=Ji(t.degToRad(e),t.degToRad(-i));}}class eo{constructor(e,i){this._transform=t.identity([]),this._orientation=t.identity$1([]),i&&(this._orientation=i,Ki(this._transform,this._orientation)),e&&Yi(this._transform,e);}get mercatorPosition(){const e=this.position;return new t.MercatorCoordinate(e[0],e[1],e[2])}get position(){const t=Xi(this._transform,3);return [t[0],t[1],t[2]]}set position(t){Yi(this._transform,t);}get orientation(){return this._orientation}set orientation(t){this._orientation=t,Ki(this._transform,this._orientation);}getPitchBearing(){const t=this.forward(),e=this.right();return {bearing:Math.atan2(-e[1],e[0]),pitch:Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2])}}setPitchBearing(t,e){this._orientation=Ji(t,e),Ki(this._transform,this._orientation);}forward(){const t=Xi(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=Xi(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=Xi(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(e,i){const o=new Float64Array(16);return t.invert(o,this.getWorldToCamera(e,i)),o}getWorldToCamera(e,i){const o=new Float64Array(16),a=new Float64Array(4),r=this.position;return t.conjugate(a,this._orientation),t.scale$2(r,r,-e),t.fromQuat(o,a),t.translate(o,o,r),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(e,i,o,a){const r=new Float64Array(16);return t.perspective(r,e,i,o,a),r}clone(){return new eo([...this.position],[...this.orientation])}}class io{constructor(e,i,o,a,r){this.tileSize=512,this.maxValidLatitude=85.051129,this._renderWorldCopies=void 0===r||r,this._minZoom=e||0,this._maxZoom=i||22,this._minPitch=null==o?0:o,this._maxPitch=null==a?60:a,this.setMaxBounds(),this.width=0,this.height=0,this._center=new t.LngLat(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._unmodified=!0,this._edgeInsets=new Wi,this._posMatrixCache={},this._alignedPosMatrixCache={},this._camera=new eo,this._centerAltitude=0,this.cameraElevationReference="ground";}clone(){const t=new io(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies);return t._elevation=this._elevation,t._centerAltitude=this._centerAltitude,t.tileSize=this.tileSize,t.latRange=this.latRange,t.width=this.width,t.height=this.height,t.cameraElevationReference=this.cameraElevationReference,t._center=this._center,t._setZoom(this.zoom),t._cameraZoom=this._cameraZoom,t.angle=this.angle,t._fov=this._fov,t._pitch=this._pitch,t._unmodified=this._unmodified,t._edgeInsets=this._edgeInsets.clone(),t._camera=this._camera.clone(),t._calcMatrices(),t.freezeTileCoverage=this.freezeTileCoverage,t}get elevation(){return this._elevation}set elevation(t){this._elevation!==t&&(this._elevation=t,t?this._updateCenterElevation()&&this._updateCameraOnTerrain():(this._cameraZoom=null,this._centerAltitude=0),this._calcMatrices());}updateElevation(t){this._terrainEnabled()&&null==this._cameraZoom&&this._updateCenterElevation()&&this._updateCameraOnTerrain(),t&&this._constrainCameraAltitude(),this._calcMatrices();}get minZoom(){return this._minZoom}set minZoom(t){this._minZoom!==t&&(this._minZoom=t,this.zoom=Math.max(this.zoom,t));}get maxZoom(){return this._maxZoom}set maxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.zoom=Math.min(this.zoom,t));}get minPitch(){return this._minPitch}set minPitch(t){this._minPitch!==t&&(this._minPitch=t,this.pitch=Math.max(this.pitch,t));}get maxPitch(){return this._maxPitch}set maxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.pitch=Math.min(this.pitch,t));}get renderWorldCopies(){return this._renderWorldCopies}set renderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t;}get worldSize(){return this.tileSize*this.scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new t.Point(this.width,this.height)}get bearing(){return -this.angle/Math.PI*180}set bearing(e){const i=-t.wrap(e,-180,180)*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=t.create$2(),t.rotate(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(e){const i=t.clamp(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get fov(){return this._fov/Math.PI*180}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=t/180*Math.PI,this._calcMatrices());}get zoom(){return this._zoom}set zoom(t){const e=Math.min(Math.max(t,this.minZoom),this.maxZoom);this._zoom!==e&&(this._unmodified=!1,this._setZoom(e),this._terrainEnabled()&&this._updateCameraOnTerrain(),this._constrain(),this._calcMatrices());}_setZoom(t){this._zoom=t,this.scale=this.zoomScale(t),this.tileZoom=Math.floor(t),this.zoomFraction=t-this.tileZoom;}_updateCenterElevation(){if(!this._elevation)return !1;const e=this._elevation.getAtPoint(t.MercatorCoordinate.fromLngLat(this.center),-1);return -1===e?(this._cameraZoom=null,!1):(this._centerAltitude=e,!0)}_updateCameraOnTerrain(){const e=this.cameraToCenterDistance/this.worldSize,i=t.mercatorZfromAltitude(this._centerAltitude,this.center.lat);this._cameraZoom=this._zoomFromMercatorZ(i+e);}get center(){return this._center}set center(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCenterElevation()?this._updateCameraOnTerrain():this._cameraZoom=null:this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._cameraZoom||!this._elevation)return;const e=this._cameraZoom,i=this._elevation.getAtPoint(t.MercatorCoordinate.fromLngLat(this.center)),o=t.mercatorZfromAltitude(i,this.center.lat),a=this._mercatorZfromZoom(e),r=this._mercatorZfromZoom(this._maxZoom),n=Math.max(a-o,r);this._setZoom(this._zoomFromMercatorZ(n));}get padding(){return this._edgeInsets.toJSON()}set padding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices());}computeZoomRelativeTo(e){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,e.toAltitude()));let o;o=e.z<this._camera.position[2]?[i.x,i.y,i.z]:[e.x,e.y,e.z];const a=t.length(t.sub([],this._camera.position,o));return t.clamp(this._zoomFromMercatorZ(a),this._minZoom,this._maxZoom)}setFreeCameraOptions(e){if(!this.height)return;if(!e.position&&!e.orientation)return;this._updateCameraState();let i=!1;if(e.orientation&&!t.exactEquals(e.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(e.orientation)),e.position){const o=[e.position.x,e.position.y,e.position.z];t.exactEquals$1(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const e=this._camera.position,i=new to;return i.position=new t.MercatorCoordinate(e[0],e[1],e[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this._renderWorldCopies,i}_setCameraOrientation(e){if(!t.length$1(e))return !1;t.normalize$1(e,e);const i=t.transformQuat([],[0,0,-1],e),o=t.transformQuat([],[0,-1,0],e);if(o[2]<0)return !1;const a=Qi(i,o);return !!a&&(this._camera.orientation=a,!0)}_setCameraPosition(e){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,a=this.cameraToCenterDistance;e[2]=t.clamp(e[2],a/o,a/i),this._camera.position=e;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(t){const e=(t.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/t.tileSize));return Math.max(0,e)}getVisibleUnwrappedCoordinates(e){const i=[new t.UnwrappedTileID(0,e)];if(this._renderWorldCopies){const o=this.pointCoordinate(new t.Point(0,0)),a=this.pointCoordinate(new t.Point(this.width,0)),r=this.pointCoordinate(new t.Point(this.width,this.height)),n=this.pointCoordinate(new t.Point(0,this.height)),s=Math.floor(Math.min(o.x,a.x,r.x,n.x)),l=Math.floor(Math.max(o.x,a.x,r.x,n.x)),c=1;for(let o=s-c;o<=l+c;o++)0!==o&&i.push(new t.UnwrappedTileID(o,e));}return i}coveringTiles(e){let i=this.coveringZoomLevel(e);const o=i,a=!!e.useElevationData;if(void 0!==e.minzoom&&i<e.minzoom)return [];void 0!==e.maxzoom&&i>e.maxzoom&&(i=e.maxzoom);const r=t.MercatorCoordinate.fromLngLat(this.center),n=1<<i,s=[n*r.x,n*r.y,0],l=t.Frustum.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i),c=this.pointCoordinate(this.getCameraPoint()),h=n*t.mercatorZfromAltitude(1,this.center.lat),u=this._camera.position[2]/t.mercatorZfromAltitude(1,this.center.lat),d=[n*c.x,n*c.y,u],_=this.cameraToCenterDistance/e.tileSize*(e.roundZoom?1:.502),m=this.pitch<=60&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation?i:0,p=this.elevation?1e4*this.elevation.exaggeration():0,f=e=>({aabb:new t.Aabb([e*n,0,-p],[(e+1)*n,n,p]),zoom:0,x:0,y:0,wrap:e,fullyVisible:!1}),g=[],v=[],x=i,y=e.reparseOverscaled?o:i,b=(t,e)=>{if(!this._elevation)return;const i=this._elevation.getMinMaxForTile(e);i&&(t.min[2]=i.min,t.max[2]=i.max,t.center[2]=(t.min[2]+t.max[2])/2);},w=t=>t*t,T=w((u-this._centerAltitude)*h),E=(t,e)=>{if(e*w(.707)<t)return 1;const i=Math.sqrt(e/t);return i/(1/.707+(Math.pow(1.1,i-1/.707+1)-1)/(1.1-1)-1)};if(this._renderWorldCopies)for(let t=1;t<=3;t++)g.push(f(-t)),g.push(f(t));for(g.push(f(0));g.length>0;){const o=g.pop(),r=o.x,n=o.y;let c=o.fullyVisible;if(!c){const t=o.aabb.intersects(l);if(0===t)continue;c=2===t;}let u=!0;if(m<=o.zoom&&o.zoom<x){const t=o.aabb.distanceX(d),e=o.aabb.distanceY(d);let i=T;a&&(i=w(o.aabb.distanceZ(d)*h));const r=t*t+e*e+i;u=r<w((1<<x-o.zoom)*_*E(Math.max(i,T),r));}if(o.zoom!==x&&u)for(let e=0;e<4;e++){const i=(r<<1)+e%2,s=(n<<1)+(e>>1),l=o.aabb.quadrant(e);let h=null;a&&o.zoom>x-6&&(h=new t.OverscaledTileID(o.zoom+1===x?y:o.zoom+1,o.wrap,o.zoom+1,i,s),b(l,h)),g.push({aabb:l,zoom:o.zoom+1,x:i,y:s,wrap:o.wrap,fullyVisible:c,tileID:h});}else {const a=o.zoom===x?y:o.zoom;if(e.minzoom&&e.minzoom>a)continue;const l=s[0]-(.5+r+(o.wrap<<o.zoom))*(1<<i-o.zoom),c=s[1]-.5-n,h=o.tileID?o.tileID:new t.OverscaledTileID(a,o.wrap,o.zoom,r,n);v.push({tileID:h,distanceSq:l*l+c*c});}}return v.sort((t,e)=>t.distanceSq-e.distanceSq).map(t=>t.tileID)}resize(t,e){this.width=t,this.height=e,this.pixelsToGLUnits=[2/t,-2/e],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(t){return Math.pow(2,t)}scaleZoom(t){return Math.log(t)/Math.LN2}project(e){const i=t.clamp(e.lat,-this.maxValidLatitude,this.maxValidLatitude);return new t.Point(t.mercatorXfromLng(e.lng)*this.worldSize,t.mercatorYfromLat(i)*this.worldSize)}unproject(e){return new t.MercatorCoordinate(e.x/this.worldSize,e.y/this.worldSize).toLngLat()}get point(){return this.project(this.center)}setLocationAtPoint(e,i){const o=this.pointCoordinate(i),a=this.pointCoordinate(this.centerPoint),r=this.locationCoordinate(e),n=new t.MercatorCoordinate(r.x-(o.x-a.x),r.y-(o.y-a.y));this.center=this.coordinateLocation(n),this._renderWorldCopies&&(this.center=this.center.wrap());}setLocation(t){this.center=this.coordinateLocation(t),this._renderWorldCopies&&(this.center=this.center.wrap());}locationPoint(t){return this._coordinatePoint(this.locationCoordinate(t),!1)}locationPoint3D(t){return this._coordinatePoint(this.locationCoordinate(t),!0)}pointLocation(t){return this.coordinateLocation(this.pointCoordinate(t))}pointLocation3D(t){return this.coordinateLocation(this.pointCoordinate3D(t))}locationCoordinate(e){return t.MercatorCoordinate.fromLngLat(e)}coordinateLocation(t){return t.toLngLat()}pointRayIntersection(e,i){const o=null!=i?i:this._centerAltitude,a=[e.x,e.y,0,1],r=[e.x,e.y,1,1];t.transformMat4(a,a,this.pixelMatrixInverse),t.transformMat4(r,r,this.pixelMatrixInverse);const n=r[3];t.scale$1(a,a,1/a[3]),t.scale$1(r,r,1/n);const s=a[2],l=r[2];return {p0:a,p1:r,t:s===l?0:(o-s)/(l-s)}}screenPointToMercatorRay(e){const i=[e.x,e.y,0,1],o=[e.x,e.y,1,1];return t.transformMat4(i,i,this.pixelMatrixInverse),t.transformMat4(o,o,this.pixelMatrixInverse),t.scale$1(i,i,1/i[3]),t.scale$1(o,o,1/o[3]),i[2]=t.mercatorZfromAltitude(i[2],this._center.lat)*this.worldSize,o[2]=t.mercatorZfromAltitude(o[2],this._center.lat)*this.worldSize,t.scale$1(i,i,1/this.worldSize),t.scale$1(o,o,1/this.worldSize),new t.Ray([i[0],i[1],i[2]],t.normalize([],t.sub([],o,i)))}rayIntersectionCoordinate(e){const{p0:i,p1:o,t:a}=e,r=t.mercatorZfromAltitude(i[2],this._center.lat),n=t.mercatorZfromAltitude(o[2],this._center.lat);return new t.MercatorCoordinate(t.number(i[0],o[0],a)/this.worldSize,t.number(i[1],o[1],a)/this.worldSize,t.number(r,n,a))}pointCoordinate(e){const i=this.horizonLineFromTop(!1),o=new t.Point(e.x,Math.max(i,e.y));return this.rayIntersectionCoordinate(this.pointRayIntersection(o))}pointCoordinate3D(e){if(!this.elevation)return this.pointCoordinate(e);const i=this.elevation;let o=this.elevation.pointCoordinate(e);if(o)return new t.MercatorCoordinate(o[0],o[1],o[2]);let a=0,r=this.horizonLineFromTop();if(e.y>r)return this.pointCoordinate(e);const n=.02*r,s=e.clone();for(let e=0;e<10&&r-a>n;e++){s.y=t.number(a,r,.66);const e=i.pointCoordinate(s);e?(r=s.y,o=e):a=s.y;}return o?new t.MercatorCoordinate(o[0],o[1],o[2]):this.pointCoordinate(e)}isPointAboveHorizon(t){if(this.elevation)return !this.elevation.pointCoordinate(t);{const e=this.horizonLineFromTop();return t.y<e}}_coordinatePoint(e,i){const o=i&&this.elevation?this.elevation.getAtPoint(e,this._centerAltitude):this._centerAltitude,a=[e.x*this.worldSize,e.y*this.worldSize,o+e.toAltitude(),1];return t.transformMat4(a,a,this.pixelMatrix),a[3]>0?new t.Point(a[0]/a[3],a[1]/a[3]):new t.Point(Number.MAX_VALUE,Number.MAX_VALUE)}getBounds(){return this._terrainEnabled()?this._getBounds3D():(new t.LngLatBounds).extend(this.pointLocation(new t.Point(0,0))).extend(this.pointLocation(new t.Point(this.width,0))).extend(this.pointLocation(new t.Point(this.width,this.height))).extend(this.pointLocation(new t.Point(0,this.height)))}_getBounds3D(){const e=this.elevation,i=e.visibleDemTiles.reduce((t,e)=>{if(e.dem){const i=e.dem.tree;t.min=Math.min(t.min,i.minimums[0]),t.max=Math.max(t.max,i.maximums[0]);}return t},{min:Number.MAX_VALUE,max:0});i.min*=e.exaggeration(),i.max*=e.exaggeration();const o=this.horizonLineFromTop();return [new t.Point(0,o),new t.Point(this.width,o),new t.Point(this.width,this.height),new t.Point(0,this.height)].reduce((t,e)=>t.extend(this.coordinateLocation(this.rayIntersectionCoordinate(this.pointRayIntersection(e,i.min)))).extend(this.coordinateLocation(this.rayIntersectionCoordinate(this.pointRayIntersection(e,i.max)))),new t.LngLatBounds)}horizonLineFromTop(t=!0){const e=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))+this.centerOffset.y,i=this.height/2-.97*e;return t?Math.max(0,i):i}getMaxBounds(){return this.latRange&&2===this.latRange.length&&this.lngRange&&2===this.lngRange.length?new t.LngLatBounds([this.lngRange[0],this.latRange[0]],[this.lngRange[1],this.latRange[1]]):null}setMaxBounds(t){t?(this.lngRange=[t.getWest(),t.getEast()],this.latRange=[t.getSouth(),t.getNorth()],this._constrain()):(this.lngRange=null,this.latRange=[-this.maxValidLatitude,this.maxValidLatitude]);}calculatePosMatrix(e,i=!1){const o=e.key,a=i?this._alignedPosMatrixCache:this._posMatrixCache;if(a[o])return a[o];const r=e.canonical,n=this.worldSize/this.zoomScale(r.z),s=r.x+Math.pow(2,r.z)*e.wrap,l=t.identity(new Float64Array(16));return t.translate(l,l,[s*n,r.y*n,0]),t.scale(l,l,[n/t.EXTENT,n/t.EXTENT,1]),t.multiply(l,i?this.alignedProjMatrix:this.projMatrix,l),a[o]=new Float32Array(l),a[o]}customLayerMatrix(){return this.mercatorMatrix.slice()}recenterOnTerrain(){if(!this._elevation)return;const e=this._elevation;this._updateCameraState();const i=this._camera.position,o=this._camera.forward();if(i.z<=0||o[2]>=0)return;const a=t.mercatorZfromAltitude(1,this._center.lat);i[2]/=a,o[2]/=a,t.normalize(o,o);const r=e.raycast(i,o,e.exaggeration());if(r){const e=t.scaleAndAdd([],i,o,r),a=new t.MercatorCoordinate(e[0],e[1],t.mercatorZfromAltitude(e[2],t.latFromMercatorY(e[1]))),n=this._camera.position,s=a.z+t.length([a.x-n[0],a.y-n[1],a.z-n[2]]);this._cameraZoom=this._zoomFromMercatorZ(s),this._centerAltitude=a.toAltitude(),this._center=a.toLngLat(),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCameraAltitude(){if(!this._elevation)return;const e=this._elevation;this._updateCameraState();const i=e.getAtPoint(this._camera.mercatorPosition),o=this._minimumHeightOverTerrain()*Math.cos(t.degToRad(this._maxPitch)),a=t.mercatorZfromAltitude(i,this._center.lat),r=this._camera.position[2]-a;if(r<o){const e=t.MercatorCoordinate.fromLngLat(this._center,this._centerAltitude),i=this._camera.mercatorPosition,a=[e.x-i.x,e.y-i.y,e.z-i.z],n=t.length(a);a[2]-=o-r;const s=t.length(a);if(0===s)return;t.scale$2(a,a,n/s),this._camera.position=[e.x-a[0],e.y-a[1],e.z-a[2]],this._camera.orientation=Qi(a,this._camera.up()),this._updateStateFromCamera();}}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;let e,i,o,a,r=-90,n=90,s=-180,l=180;const c=this.size,h=this._unmodified;if(this.latRange){const i=this.latRange;r=t.mercatorYfromLat(i[1])*this.worldSize,n=t.mercatorYfromLat(i[0])*this.worldSize,e=n-r<c.y?c.y/(n-r):0;}if(this.lngRange){const e=this.lngRange;s=t.mercatorXfromLng(e[0])*this.worldSize,l=t.mercatorXfromLng(e[1])*this.worldSize,i=l-s<c.x?c.x/(l-s):0;}const u=this.point,d=Math.max(i||0,e||0);if(d)return this.center=this.unproject(new t.Point(i?(l+s)/2:u.x,e?(n+r)/2:u.y)),this.zoom+=this.scaleZoom(d),this._unmodified=h,void(this._constraining=!1);if(this.latRange){const t=u.y,e=c.y/2;t-e<r&&(a=r+e),t+e>n&&(a=n-e);}if(this.lngRange){const t=u.x,e=c.x/2;t-e<s&&(o=s+e),t+e>l&&(o=l-e);}void 0===o&&void 0===a||(this.center=this.unproject(new t.Point(void 0!==o?o:u.x,void 0!==a?a:u.y))),this._constrainCameraAltitude(),this._unmodified=h,this._constraining=!1;}_minZoomForBounds(){const e=(t,e)=>Math.log2(t/(this.tileSize*Math.abs(e[1]-e[0])));let i=0;if(this.latRange){const o=this.latRange;i=e(this.height,[t.mercatorYfromLat(o[0]),t.mercatorYfromLat(o[1])]);}let o=0;if(this.lngRange){const i=this.lngRange;o=e(this.width,[t.mercatorXfromLng(i[0]),t.mercatorXfromLng(i[1])]);}return Math.max(i,o)}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const e=this.centerOffset;this.cameraToCenterDistance=.5/Math.tan(this._fov/2)*this.height;const i=t.mercatorZfromAltitude(1,this.center.lat)*this.worldSize;this._updateCameraState();const o=Math.PI/2+this._pitch,a=this.fovAboveCenter,r=this._camera.position[2]*this.worldSize/Math.cos(this._pitch),n=Math.sin(a)*r/Math.sin(t.clamp(Math.PI-o-a,.01,Math.PI-.01)),s=this.point,l=s.x,c=s.y,h=1.01*(Math.cos(Math.PI/2-this._pitch)*n+r),u=this.height/50,d=this._camera.getWorldToCamera(this.worldSize,i),_=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,u,h);_[8]=2*-e.x/this.width,_[9]=2*e.y/this.height;let m=t.mul([],_,d);this.mercatorMatrix=t.scale([],m,[this.worldSize,this.worldSize,this.worldSize/i]),this.projMatrix=m,this.invProjMatrix=t.invert(new Float64Array(16),this.projMatrix);const p=new Float32Array(16);t.identity(p),t.scale(p,p,[1,-1,1]),t.rotateX(p,p,this._pitch),t.rotateZ(p,p,this.angle);const f=t.perspective(new Float32Array(16),this._fov,this.width/this.height,u,h);f[8]=2*-e.x/this.width,f[9]=2*e.y/this.height,this.skyboxMatrix=t.multiply(p,f,p);const g=this.width%2/2,v=this.height%2/2,x=Math.cos(this.angle),y=Math.sin(this.angle),b=l-Math.round(l)+x*g+y*v,w=c-Math.round(c)+x*v+y*g,T=new Float64Array(m);if(t.translate(T,T,[b>.5?b-1:b,w>.5?w-1:w,0]),this.alignedProjMatrix=T,m=t.create(),t.scale(m,m,[this.width/2,-this.height/2,1]),t.translate(m,m,[1,-1,0]),this.labelPlaneMatrix=m,m=t.create(),t.scale(m,m,[1,-1,1]),t.translate(m,m,[-1,-1,0]),t.scale(m,m,[2/this.width,2/this.height,1]),this.glCoordMatrix=m,this.pixelMatrix=t.multiply(new Float64Array(16),this.labelPlaneMatrix,this.projMatrix),m=t.invert(new Float64Array(16),this.pixelMatrix),!m)throw new Error("failed to invert matrix");this.pixelMatrixInverse=m,this._posMatrixCache={},this._alignedPosMatrixCache={};}_updateCameraState(){if(!this.height)return;this._camera.setPitchBearing(this._pitch,this.angle);const e=this._camera.forward(),i=this.cameraToCenterDistance,o=this.point,a=this._mercatorZfromZoom(this._cameraZoom?this._cameraZoom:this._zoom)-t.mercatorZfromAltitude(this._centerAltitude,this.center.lat),r=this.cameraToCenterDistance/a;this._camera.position=[o.x/this.worldSize-e[0]*i/r,o.y/this.worldSize-e[1]*i/r,t.mercatorZfromAltitude(this._centerAltitude,this._center.lat)+-e[2]*i/r];}_translateCameraConstrained(e){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=e[2];let a=1;o>0&&(a=Math.min((i-this._camera.position[2])/o,1)),this._camera.position=t.scaleAndAdd([],this._camera.position,e,a),this._updateStateFromCamera();}_updateStateFromCamera(){const e=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:a}=this._camera.getPitchBearing(),r=t.mercatorZfromAltitude(this._centerAltitude,this.center.lat),n=this._mercatorZfromZoom(this._maxZoom)*Math.cos(t.degToRad(this._maxPitch)),s=Math.max((e[2]-r)/Math.cos(o),n),l=this._zoomFromMercatorZ(s);t.scaleAndAdd(e,e,i,s),this._pitch=t.clamp(o,t.degToRad(this.minPitch),t.degToRad(this.maxPitch)),this.angle=t.wrap(a,-Math.PI,Math.PI),this._setZoom(t.clamp(l,this._minZoom,this._maxZoom)),this._terrainEnabled()&&this._updateCameraOnTerrain(),this._center=new t.MercatorCoordinate(e[0],e[1],e[2]).toLngLat(),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(t){return Math.pow(2,t)*this.tileSize}_mercatorZfromZoom(t){return this.cameraToCenterDistance/this._worldSizeFromZoom(t)}_minimumHeightOverTerrain(){const t=Math.min((null!=this._cameraZoom?this._cameraZoom:this._zoom)+2,this._maxZoom);return this._mercatorZfromZoom(t)}_zoomFromMercatorZ(t){return this.scaleZoom(this.cameraToCenterDistance/(t*this.tileSize))}_terrainEnabled(){return !!this._elevation}isHorizonVisibleForPoints(e,i){const o=Math.min(e.x,i.x),a=Math.max(e.x,i.x),r=Math.min(e.y,i.y),n=Math.max(e.y,i.y),s=[new t.Point(o,r),new t.Point(a,n),new t.Point(o,n),new t.Point(a,r)],l=this._renderWorldCopies?-3:0,c=this._renderWorldCopies?4:1;for(const t of s){const e=this.pointRayIntersection(t);if(e.t<0)return !0;const i=this.rayIntersectionCoordinate(e);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+t.radToDeg(this.fovAboveCenter)>88||this.isHorizonVisibleForPoints(new t.Point(0,0),new t.Point(this.width,this.height))}zoomDeltaToMovement(e,i){const o=t.length(t.sub([],this._camera.position,e)),a=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(a)}getCameraPoint(){const e=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new t.Point(0,e))}}class oo{constructor(e){this._hashName=e&&encodeURIComponent(e),t.bindAll(["_getCurrentHash","_onHashChange","_updateHash"],this),this._updateHash=function(t,e){let i=!1,o=null;const a=()=>{o=null,i&&(t(),o=setTimeout(a,300),i=!1);};return ()=>(i=!0,o||a(),o)}(this._updateHashUnthrottled.bind(this));}addTo(e){return this._map=e,t.window.addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return t.window.removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),delete this._map,this}getHashString(e){const i=this._map.getCenter(),o=Math.round(100*this._map.getZoom())/100,a=Math.ceil((o*Math.LN2+Math.log(512/360/.5))/Math.LN10),r=Math.pow(10,a),n=Math.round(i.lng*r)/r,s=Math.round(i.lat*r)/r,l=this._map.getBearing(),c=this._map.getPitch();let h="";if(h+=e?`/${n}/${s}/${o}`:`${o}/${s}/${n}`,(l||c)&&(h+=`/${Math.round(10*l)/10}`),c&&(h+=`/${Math.round(c)}`),this._hashName){const e=this._hashName;let i=!1;const o=t.window.location.hash.slice(1).split("&").map(t=>{const o=t.split("=")[0];return o===e?(i=!0,`${o}=${h}`):t}).filter(t=>t);return i||o.push(`${e}=${h}`),`#${o.join("&")}`}return `#${h}`}_getCurrentHash(){const e=t.window.location.hash.replace("#","");if(this._hashName){let t;return e.split("&").map(t=>t.split("=")).forEach(e=>{e[0]===this._hashName&&(t=e);}),(t&&t[1]||"").split("/")}return e.split("/")}_onHashChange(){const t=this._getCurrentHash();if(t.length>=3&&!t.some(t=>isNaN(t))){const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0}return !1}_updateHashUnthrottled(){const e=t.window.location.href.replace(/(#.+)?$/,this.getHashString());t.window.history.replaceState(t.window.history.state,null,e);}}const ao={linearity:.3,easing:t.bezier(0,0,.3,1)},ro=t.extend({deceleration:2500,maxSpeed:1400},ao),no=t.extend({deceleration:20,maxSpeed:1400},ao),so=t.extend({deceleration:1e3,maxSpeed:360},ao),lo=t.extend({deceleration:1e3,maxSpeed:90},ao);class co{constructor(t){this._map=t,this.clear();}clear(){this._inertiaBuffer=[];}record(e){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:t.browser.now(),settings:e});}_drainInertiaBuffer(){const e=this._inertiaBuffer,i=t.browser.now();for(;e.length>0&&i-e[0].time>160;)e.shift();}_onMoveEnd(e){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,pan:new t.Point(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)i.zoom+=t.zoomDelta||0,i.bearing+=t.bearingDelta||0,i.pitch+=t.pitchDelta||0,t.panDelta&&i.pan._add(t.panDelta),t.around&&(i.around=t.around),t.pinchAround&&(i.pinchAround=t.pinchAround);const o=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,a={};if(i.pan.mag()){const r=uo(i.pan.mag(),o,t.extend({},ro,e||{}));a.offset=i.pan.mult(r.amount/i.pan.mag()),a.center=this._map.transform.center,ho(a,r);}if(i.zoom){const t=uo(i.zoom,o,no);a.zoom=this._map.transform.zoom+t.amount,ho(a,t);}if(i.bearing){const e=uo(i.bearing,o,so);a.bearing=this._map.transform.bearing+t.clamp(e.amount,-179,179),ho(a,e);}if(i.pitch){const t=uo(i.pitch,o,lo);a.pitch=this._map.transform.pitch+t.amount,ho(a,t);}if(a.zoom||a.bearing){const t=void 0===i.pinchAround?i.around:i.pinchAround;a.around=t?this._map.unproject(t):this._map.getCenter();}return this.clear(),t.extend(a,{noMoveStart:!0})}}function ho(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing);}function uo(e,i,o){const{maxSpeed:a,linearity:r,deceleration:n}=o,s=t.clamp(e*r/(i/1e3),-a,a),l=Math.abs(s)/(n*r);return {easing:o.easing,duration:1e3*l,amount:s*(l/2)}}class _o extends t.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,o,r={}){const n=a.mousePos(i.getCanvasContainer(),o),s=i.unproject(n);super(e,t.extend({point:n,lngLat:s,originalEvent:o},r)),this._defaultPrevented=!1,this.target=i;}}class mo extends t.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,o){const r="touchend"===e?o.changedTouches:o.touches,n=a.touchPos(i.getCanvasContainer(),r),s=n.map(t=>i.unproject(t)),l=n.reduce((t,e,i,o)=>t.add(e.div(o.length)),new t.Point(0,0));super(e,{points:n,point:l,lngLats:s,lngLat:i.unproject(l),originalEvent:o}),this._defaultPrevented=!1;}}class po extends t.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1;}}class fo{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance;}reset(){delete this._mousedownPos;}wheel(t){return this._firePreventable(new po(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new _o(t.type,this._map,t))}mouseup(t){this._map.fire(new _o(t.type,this._map,t));}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new _o(t.type,this._map,t));}dblclick(t){return this._firePreventable(new _o(t.type,this._map,t))}mouseover(t){this._map.fire(new _o(t.type,this._map,t));}mouseout(t){this._map.fire(new _o(t.type,this._map,t));}touchstart(t){return this._firePreventable(new mo(t.type,this._map,t))}touchmove(t){this._map.fire(new mo(t.type,this._map,t));}touchend(t){this._map.fire(new mo(t.type,this._map,t));}touchcancel(t){this._map.fire(new mo(t.type,this._map,t));}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class go{constructor(t){this._map=t;}reset(){this._delayContextMenu=!1,delete this._contextMenuEvent;}mousemove(t){this._map.fire(new _o(t.type,this._map,t));}mousedown(){this._delayContextMenu=!0;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new _o("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._map.fire(new _o(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class vo{constructor(t,e){this._map=t,this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(a.disableDrag(),this._startPos=this._lastPos=e,this._active=!0);}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const o=this._startPos;this._lastPos=i,this._box||(this._box=a.create("div","mapboxgl-boxzoom",this._container),this._container.classList.add("mapboxgl-crosshair"),this._fireEvent("boxzoomstart",t));const r=Math.min(o.x,i.x),n=Math.max(o.x,i.x),s=Math.min(o.y,i.y),l=Math.max(o.y,i.y);a.setTransform(this._box,`translate(${r}px,${s}px)`),this._box.style.width=`${n-r}px`,this._box.style.height=`${l-s}px`;}mouseupWindow(e,i){if(!this._active)return;if(0!==e.button)return;const o=this._startPos,r=i;if(this.reset(),a.suppressClick(),o.x!==r.x||o.y!==r.y)return this._map.fire(new t.Event("boxzoomend",{originalEvent:e})),{cameraAnimation:t=>t.fitScreenCoordinates(o,r,this._map.getBearing(),{linear:!1})};this._fireEvent("boxzoomcancel",e);}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t));}reset(){this._active=!1,this._container.classList.remove("mapboxgl-crosshair"),this._box&&(a.remove(this._box),this._box=null),a.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(e,i){return this._map.fire(new t.Event(e,{originalEvent:i}))}}function xo(t,e){const i={};for(let o=0;o<t.length;o++)i[t[o].identifier]=e[o];return i}class yo{constructor(t){this.reset(),this.numTouches=t.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(e,i,o){(this.centroid||o.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=e.timeStamp),o.length===this.numTouches&&(this.centroid=function(e){const i=new t.Point(0,0);for(const t of e)i._add(t);return i.div(e.length)}(i),this.touches=xo(o,i)));}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const o=xo(i,e);for(const t in this.touches){const e=this.touches[t],i=o[t];(!i||i.dist(e)>30)&&(this.aborted=!0);}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class bo{constructor(t){this.singleTap=new yo(t),this.numTaps=t.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(t,e,i){this.singleTap.touchstart(t,e,i);}touchmove(t,e,i){this.singleTap.touchmove(t,e,i);}touchend(t,e,i){const o=this.singleTap.touchend(t,e,i);if(o){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(o)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=o,this.count===this.numTaps)return this.reset(),o}}}class wo{constructor(){this._zoomIn=new bo({numTouches:1,numTaps:2}),this._zoomOut=new bo({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i);}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i);}touchend(t,e,i){const o=this._zoomIn.touchend(t,e,i),a=this._zoomOut.touchend(t,e,i);return o?(this._active=!0,t.preventDefault(),setTimeout(()=>this.reset(),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:e.getZoom()+1,around:e.unproject(o)},{originalEvent:t})}):a?(this._active=!0,t.preventDefault(),setTimeout(()=>this.reset(),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:e.getZoom()-1,around:e.unproject(a)},{originalEvent:t})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}const To={0:1,2:2};class Eo{constructor(t){this.reset(),this._clickTolerance=t.clickTolerance||1;}reset(){this._active=!1,this._moved=!1,delete this._lastPoint,delete this._eventButton;}_correctButton(t,e){return !1}_move(t,e){return {}}mousedown(t,e){if(this._lastPoint)return;const i=a.mouseButton(t);this._correctButton(t,i)&&(this._lastPoint=e,this._eventButton=i);}mousemoveWindow(t,e){const i=this._lastPoint;if(i)if(t.preventDefault(),function(t,e){const i=To[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton))this.reset();else if(this._moved||!(e.dist(i)<this._clickTolerance))return this._moved=!0,this._lastPoint=e,this._move(i,e)}mouseupWindow(t){this._lastPoint&&a.mouseButton(t)===this._eventButton&&(this._moved&&a.suppressClick(),this.reset());}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Co extends Eo{mousedown(t,e){super.mousedown(t,e),this._lastPoint&&(this._active=!0);}_correctButton(t,e){return 0===e&&!t.ctrlKey}_move(t,e){return {around:e,panDelta:e.sub(t)}}}class So extends Eo{_correctButton(t,e){return 0===e&&t.ctrlKey||2===e}_move(t,e){const i=.8*(e.x-t.x);if(i)return this._active=!0,{bearingDelta:i}}contextmenu(t){t.preventDefault();}}class Io extends Eo{_correctButton(t,e){return 0===e&&t.ctrlKey||2===e}_move(t,e){const i=-.5*(e.y-t.y);if(i)return this._active=!0,{pitchDelta:i}}contextmenu(t){t.preventDefault();}}class Po{constructor(t){this._minTouches=1,this._clickTolerance=t.clickTolerance||1,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new t.Point(0,0);}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active&&!(i.length<this._minTouches))return t.preventDefault(),this._calculateTransform(t,e,i)}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&i.length<this._minTouches&&this.reset();}touchcancel(){this.reset();}_calculateTransform(e,i,o){o.length>0&&(this._active=!0);const a=xo(o,i),r=new t.Point(0,0),n=new t.Point(0,0);let s=0;for(const t in a){const e=a[t],i=this._touches[t];i&&(r._add(e),n._add(e.sub(i)),s++,a[t]=e);}if(this._touches=a,s<this._minTouches||!n.mag())return;const l=n.div(s);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:r.div(s),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Mo{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}_start(t){}_move(t,e,i){return {}}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]));}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[o,a]=this._firstTwoTouches,r=zo(i,e,o),n=zo(i,e,a);if(!r||!n)return;const s=this._aroundCenter?null:r.add(n).div(2);return this._move([r,n],s,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[o,r]=this._firstTwoTouches,n=zo(i,e,o),s=zo(i,e,r);n&&s||(this._active&&a.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}function zo(t,e,i){for(let o=0;o<t.length;o++)if(t[o].identifier===i)return e[o]}function Ao(t,e){return Math.log(t/e)/Math.LN2}class Do extends Mo{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(t){this._startDistance=this._distance=t[0].dist(t[1]);}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(Ao(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Ao(this._distance,i),pinchAround:e}}}function Lo(t,e){return 180*t.angleWith(e)/Math.PI}class Ro extends Mo{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1]);}_move(t,e){const i=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Lo(this._vector,i),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=Lo(t,this._startVector);return Math.abs(i)<e}}function ko(t){return Math.abs(t.y)>Math.abs(t.x)}class Bo extends Mo{reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}_start(t){this._lastPoints=t,ko(t[0].sub(t[1]))&&(this._valid=!1);}_move(t,e,i){const o=t[0].sub(this._lastPoints[0]),a=t[1].sub(this._lastPoints[1]);if(this._valid=this.gestureBeginsVertically(o,a,i.timeStamp),this._valid)return this._lastPoints=t,this._active=!0,{pitchDelta:(o.y+a.y)/2*-.5}}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const o=t.mag()>=2,a=e.mag()>=2;if(!o&&!a)return;if(!o||!a)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const r=t.y>0==e.y>0;return ko(t)&&ko(e)&&r}}const Oo={panStep:100,bearingStep:15,pitchStep:10};class Fo{constructor(){const t=Oo;this._panStep=t.panStep,this._bearingStep=t.bearingStep,this._pitchStep=t.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,o=0,a=0,r=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),a=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),a=1);break;case 38:t.shiftKey?o=1:(t.preventDefault(),r=-1);break;case 40:t.shiftKey?o=-1:(t.preventDefault(),r=1);break;default:return}return this._rotationDisabled&&(i=0,o=0),{cameraAnimation:n=>{const s=n.getZoom();n.easeTo({duration:300,easeId:"keyboardHandler",easing:Uo,zoom:e?Math.round(s)+e*(t.shiftKey?2:1):s,bearing:n.getBearing()+i*this._bearingStep,pitch:n.getPitch()+o*this._pitchStep,offset:[-a*this._panStep,-r*this._panStep],center:n.getCenter()},{originalEvent:t});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function Uo(t){return t*(2-t)}class No{constructor(e,i){this._map=e,this._el=e.getCanvasContainer(),this._handler=i,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=1/450,t.bindAll(["_onTimeout"],this);}setZoomRate(t){this._defaultZoomRate=t;}setWheelZoomRate(t){this._wheelZoomRate=t;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=t&&"center"===t.around);}disable(){this.isEnabled()&&(this._enabled=!1);}wheel(e){if(!this.isEnabled())return;let i=e.deltaMode===t.window.WheelEvent.DOM_DELTA_LINE?40*e.deltaY:e.deltaY;const o=t.browser.now(),a=o-(this._lastWheelEventTime||0);this._lastWheelEventTime=o,0!==i&&i%4.000244140625==0?this._type="wheel":0!==i&&Math.abs(i)<4?this._type="trackpad":a>400?(this._type=null,this._lastValue=i,this._timeout=setTimeout(this._onTimeout,40,e)):this._type||(this._type=Math.abs(a*i)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,i+=this._lastValue)),e.shiftKey&&i&&(i/=4),this._type&&(this._lastWheelEvent=e,this._delta-=i,this._active||this._start(e)),e.preventDefault();}_onTimeout(t){this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t);}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const e=a.mousePos(this._el,t);this._aroundPoint=this._aroundCenter?this._map.transform.centerPoint:e,this._aroundCoord=this._map.transform.pointCoordinate3D(this._aroundPoint),this._targetZoom=void 0,this._frameId||(this._frameId=!0,this._handler._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const e=this._map.transform,i=()=>e._terrainEnabled()?e.computeZoomRelativeTo(this._aroundCoord):e.zoom;if(0!==this._delta){const t="wheel"===this._type&&Math.abs(this._delta)>4.000244140625?this._wheelZoomRate:this._defaultZoomRate;let o=2/(1+Math.exp(-Math.abs(this._delta*t)));this._delta<0&&0!==o&&(o=1/o);const a=i(),r=Math.pow(2,a),n="number"==typeof this._targetZoom?e.zoomScale(this._targetZoom):r;this._targetZoom=Math.min(e.maxZoom,Math.max(e.minZoom,e.scaleZoom(n*o))),"wheel"===this._type&&(this._startZoom=i(),this._easing=this._smoothOutEasing(200)),this._delta=0;}const o="number"==typeof this._targetZoom?this._targetZoom:i(),a=this._startZoom,r=this._easing;let n,s=!1;if("wheel"===this._type&&a&&r){const e=Math.min((t.browser.now()-this._lastWheelEventTime)/200,1),i=r(e);n=t.number(a,o,i),e<1?this._frameId||(this._frameId=!0):s=!0;}else n=o,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout(()=>{this._zooming=!1,this._handler._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout;},200)),{noInertia:!0,needsRenderFrame:!s,zoomDelta:n-i(),around:this._aroundPoint,aroundCoord:this._aroundCoord,originalEvent:this._lastWheelEvent}}_smoothOutEasing(e){let i=t.ease;if(this._prevEase){const e=this._prevEase,o=(t.browser.now()-e.start)/e.duration,a=e.easing(o+.01)-e.easing(o),r=.27/Math.sqrt(a*a+1e-4)*.01,n=Math.sqrt(.0729-r*r);i=t.bezier(r,n,.25,1);}return this._prevEase={start:t.browser.now(),duration:e,easing:i},i}reset(){this._active=!1;}}class Zo{constructor(t,e){this._clickZoom=t,this._tapZoom=e;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class Go{constructor(){this.reset();}reset(){this._active=!1;}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:i.getZoom()+(t.shiftKey?-1:1),around:i.unproject(e)},{originalEvent:t});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class qo{constructor(){this._tap=new bo({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,this._tap.reset();}touchstart(t,e,i){this._swipePoint||(this._tapTime&&t.timeStamp-this._tapTime>500&&this.reset(),this._tapTime?i.length>0&&(this._swipePoint=e[0],this._swipeTouch=i[0].identifier):this._tap.touchstart(t,e,i));}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const o=e[0],a=o.y-this._swipePoint.y;return this._swipePoint=o,t.preventDefault(),this._active=!0,{zoomDelta:a/128}}}else this._tap.touchmove(t,e,i);}touchend(t,e,i){this._tapTime?this._swipePoint&&0===i.length&&this.reset():this._tap.touchend(t,e,i)&&(this._tapTime=t.timeStamp);}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Vo{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i;}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("mapboxgl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("mapboxgl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class $o{constructor(t,e,i){this._pitchWithRotate=t.pitchWithRotate,this._mouseRotate=e,this._mousePitch=i;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class jo{constructor(t,e,i,o){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=o,this._rotationDisabled=!1,this._enabled=!0;}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("mapboxgl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("mapboxgl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}const Wo=t=>t.zoom||t.drag||t.pitch||t.rotate;class Xo extends t.Event{}class Ho{constructor(){this.constants=[1,1,.01],this.radius=0;}setup(e,i){const o=t.sub([],i,e);this.radius=t.length(o[2]<0?t.div([],o,this.constants):[o[0],o[1],0]);}projectRay(e){t.div(e,e,this.constants),t.normalize(e,e),t.mul$1(e,e,this.constants);const i=t.scale$2([],e,this.radius);if(i[2]>0){const e=t.scale$2([],[0,0,1],t.dot(i,[0,0,1])),o=t.scale$2([],t.normalize([],[i[0],i[1],0]),this.radius),a=t.add([],i,t.scale$2([],t.sub([],t.add([],o,e),i),2));i[0]=a[0],i[1]=a[1];}return i}}function Ko(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta}class Yo{constructor(e,i){this._map=e,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new co(e),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._trackingEllipsoid=new Ho,this._dragOrigin=null,this._eventsInProgress={},this._addDefaultHandlers(i),t.bindAll(["handleEvent","handleWindowEvent"],this);const o=this._el;this._listeners=[[o,"touchstart",{passive:!0}],[o,"touchmove",{passive:!1}],[o,"touchend",void 0],[o,"touchcancel",void 0],[o,"mousedown",void 0],[o,"mousemove",void 0],[o,"mouseup",void 0],[t.window.document,"mousemove",{capture:!0}],[t.window.document,"mouseup",void 0],[o,"mouseover",void 0],[o,"mouseout",void 0],[o,"dblclick",void 0],[o,"click",void 0],[o,"keydown",{capture:!1}],[o,"keyup",void 0],[o,"wheel",{passive:!1}],[o,"contextmenu",void 0],[t.window,"blur",void 0]];for(const[e,i,o]of this._listeners)a.addEventListener(e,i,e===t.window.document?this.handleWindowEvent:this.handleEvent,o);}destroy(){for(const[e,i,o]of this._listeners)a.removeEventListener(e,i,e===t.window.document?this.handleWindowEvent:this.handleEvent,o);}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new fo(e,t));const o=e.boxZoom=new vo(e,t);this._add("boxZoom",o);const a=new wo,r=new Go;e.doubleClickZoom=new Zo(r,a),this._add("tapZoom",a),this._add("clickZoom",r);const n=new qo;this._add("tapDragZoom",n);const s=e.touchPitch=new Bo;this._add("touchPitch",s);const l=new So(t),c=new Io(t);e.dragRotate=new $o(t,l,c),this._add("mouseRotate",l,["mousePitch"]),this._add("mousePitch",c,["mouseRotate"]);const h=new Co(t),u=new Po(t);e.dragPan=new Vo(i,h,u),this._add("mousePan",h),this._add("touchPan",u,["touchZoom","touchRotate"]);const d=new Ro,_=new Do;e.touchZoomRotate=new jo(i,_,d,n),this._add("touchRotate",d,["touchPan","touchZoom"]),this._add("touchZoom",_,["touchPan","touchRotate"]),this._add("blockableMapEvent",new go(e));const m=e.scrollZoom=new No(e,this);this._add("scrollZoom",m,["mousePan"]);const p=e.keyboard=new Fo;this._add("keyboard",p);for(const i of ["boxZoom","doubleClickZoom","tapDragZoom","touchPitch","dragRotate","dragPan","touchZoomRotate","scrollZoom","keyboard"])t.interactive&&t[i]&&e[i].enable(t[i]);}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e;}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[];}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(Wo(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const o in t)if(o!==i&&(!e||e.indexOf(o)<0))return !0;return !1}handleWindowEvent(t){this.handleEvent(t,`${t.type}Window`);}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}handleEvent(t,e){if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type?void 0:t,o={needsRenderFrame:!1},r={},n={},s=t.touches?this._getMapTouches(t.touches):void 0,l=s?a.touchPos(this._el,s):a.mousePos(this._el,t);for(const{handlerName:a,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;this._blockedByActive(n,h,a)?c.reset():c[e||t.type]&&(u=c[e||t.type](t,l,s),this.mergeHandlerResult(o,r,u,a,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||c.isActive())&&(n[a]=c);}const c={};for(const t in this._previousActiveHandlers)n[t]||(c[t]=i);this._previousActiveHandlers=n,(Object.keys(c).length||Ko(o))&&(this._changes.push([o,r,c]),this._triggerRenderFrame()),(Object.keys(n).length||Ko(o))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:h}=o;h&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],h(this._map));}mergeHandlerResult(e,i,o,a,r){if(!o)return;t.extend(e,o);const n={handlerName:a,originalEvent:o.originalEvent||r};void 0!==o.zoomDelta&&(i.zoom=n),void 0!==o.panDelta&&(i.drag=n),void 0!==o.pitchDelta&&(i.pitch=n),void 0!==o.bearingDelta&&(i.rotate=n);}_applyChanges(){const e={},i={},o={};for(const[a,r,n]of this._changes)a.panDelta&&(e.panDelta=(e.panDelta||new t.Point(0,0))._add(a.panDelta)),a.zoomDelta&&(e.zoomDelta=(e.zoomDelta||0)+a.zoomDelta),a.bearingDelta&&(e.bearingDelta=(e.bearingDelta||0)+a.bearingDelta),a.pitchDelta&&(e.pitchDelta=(e.pitchDelta||0)+a.pitchDelta),void 0!==a.around&&(e.around=a.around),void 0!==a.aroundCoord&&(e.aroundCoord=a.aroundCoord),void 0!==a.pinchAround&&(e.pinchAround=a.pinchAround),a.noInertia&&(e.noInertia=a.noInertia),t.extend(i,r),t.extend(o,n);this._updateMapTransform(e,i,o),this._changes=[];}_updateMapTransform(e,i,o){const a=this._map,r=a.transform,n=t=>[t.x,t.y,t.z];if((t=>{const e=this._eventsInProgress.drag;return e&&!this._handlersById[e.handlerName].isActive()})()&&!Ko(e)){const t=r.zoom;r.cameraElevationReference="sea",r.recenterOnTerrain(),r.cameraElevationReference="ground",t!==r.zoom&&this._map._update(!0);}if(!Ko(e))return this._fireEvents(i,o,!0);let{panDelta:s,zoomDelta:l,bearingDelta:c,pitchDelta:h,around:u,aroundCoord:d,pinchAround:_}=e;void 0!==_&&(u=_),(t=>i.drag&&!this._eventsInProgress.drag)()&&u&&(this._dragOrigin=n(r.pointCoordinate3D(u)),this._trackingEllipsoid.setup(r._camera.position,this._dragOrigin)),r.cameraElevationReference="sea",a._stop(!0),u=u||a.transform.centerPoint,c&&(r.bearing+=c),h&&(r.pitch+=h),r._updateCameraState();const m=[0,0,0];if(s){const t=r.screenPointToMercatorRay(u),e=r.screenPointToMercatorRay(u.sub(s)),i=this._trackingEllipsoid.projectRay(t.dir),o=this._trackingEllipsoid.projectRay(e.dir);m[0]=o[0]-i[0],m[1]=o[1]-i[1];}const p=r.zoom,f=[0,0,0];if(l){const e=n(d||r.pointCoordinate3D(u)),i={dir:t.normalize([],t.sub([],e,r._camera.position))},o=r.screenPointToMercatorRay(r.centerPoint);if(i.dir[2]<0){const a=t.altitudeFromMercatorZ(e[2],e[1]),s=r.rayIntersectionCoordinate(r.pointRayIntersection(r.centerPoint,a)),c=r.zoomDeltaToMovement(n(s),l)*(o.dir[2]/i.dir[2]);t.scale$2(f,i.dir,c);}else if(r._terrainEnabled()){const o=r.zoomDeltaToMovement(e,l);t.scale$2(f,i.dir,o);}}const g=t.add(m,m,f);r._translateCameraConstrained(g),l&&Math.abs(r.zoom-p)>1e-4&&r.recenterOnTerrain(),r.cameraElevationReference="ground",this._map._update(),e.noInertia||this._inertia.record(e),this._fireEvents(i,o,!0);}_fireEvents(e,i,o){const a=Wo(this._eventsInProgress),r=Wo(e),n={};for(const t in e){const{originalEvent:i}=e[t];this._eventsInProgress[t]||(n[`${t}start`]=i),this._eventsInProgress[t]=e[t];}!a&&r&&this._fireEvent("movestart",r.originalEvent);for(const t in n)this._fireEvent(t,n[t]);r&&this._fireEvent("move",r.originalEvent);for(const t in e){const{originalEvent:i}=e[t];this._fireEvent(t,i);}const s={};let l;for(const t in this._eventsInProgress){const{handlerName:e,originalEvent:o}=this._eventsInProgress[t];this._handlersById[e].isActive()||(delete this._eventsInProgress[t],l=i[e]||o,s[`${t}end`]=l);}for(const t in s)this._fireEvent(t,s[t]);const c=Wo(this._eventsInProgress);if(o&&(a||r)&&!c){this._updatingCamera=!0;const e=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;e?(i(e.bearing||this._map.getBearing())&&(e.bearing=0),this._map.easeTo(e,{originalEvent:l})):(this._map.fire(new t.Event("moveend",{originalEvent:l})),i(this._map.getBearing())&&this._map.resetNorth()),this._updatingCamera=!1;}}_fireEvent(e,i){this._map.fire(new t.Event(e,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add(t=>{delete this._frameId,this.handleEvent(new Xo("renderFrame",{timeStamp:t})),this._applyChanges();})}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class Jo extends t.Evented{constructor(e,i){super(),this._moving=!1,this._zooming=!1,this.transform=e,this._bearingSnap=i.bearingSnap,t.bindAll(["_renderFrameCallback"],this);}getCenter(){return new t.LngLat(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}panBy(e,i,o){return e=t.Point.convert(e).mult(-1),this.panTo(this.transform.center,t.extend({offset:e},i),o)}panTo(e,i,o){return this.easeTo(t.extend({center:e},i),o)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(e,i,o){return this.easeTo(t.extend({zoom:e},i),o)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(e,i,o){return this.easeTo(t.extend({bearing:e},i),o)}resetNorth(e,i){return this.rotateTo(0,t.extend({duration:1e3},e),i),this}resetNorthPitch(e,i){return this.easeTo(t.extend({bearing:0,pitch:0,duration:1e3},e),i),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}cameraForBounds(e,i){e=t.LngLatBounds.convert(e);const o=i&&i.bearing||0;return this._cameraForBoxAndBearing(e.getNorthWest(),e.getSouthEast(),o,i)}_extendCameraOptions(e){const i={top:0,bottom:0,right:0,left:0};if("number"==typeof(e=t.extend({padding:i,offset:[0,0],maxZoom:this.transform.maxZoom},e)).padding){const t=e.padding;e.padding={top:t,bottom:t,right:t,left:t};}return e.padding=t.extend(i,e.padding),e}_cameraForBoxAndBearing(e,i,o,a){const r=this._extendCameraOptions(a),n=this.transform,s=n.padding,l=n.project(t.LngLat.convert(e)),c=n.project(t.LngLat.convert(i)),h=l.rotate(-t.degToRad(o)),u=c.rotate(-t.degToRad(o)),d=new t.Point(Math.max(h.x,u.x),Math.max(h.y,u.y)),_=new t.Point(Math.min(h.x,u.x),Math.min(h.y,u.y)),m=d.sub(_),p=(n.width-(s.left+s.right+r.padding.left+r.padding.right))/m.x,f=(n.height-(s.top+s.bottom+r.padding.top+r.padding.bottom))/m.y;if(f<0||p<0)return void t.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.");const g=Math.min(n.scaleZoom(n.scale*Math.min(p,f)),r.maxZoom),v="number"==typeof r.offset.x?new t.Point(r.offset.x,r.offset.y):t.Point.convert(r.offset),x=new t.Point((r.padding.left-r.padding.right)/2,(r.padding.top-r.padding.bottom)/2).rotate(o*Math.PI/180),y=v.add(x).mult(n.scale/n.zoomScale(g));return {center:n.unproject(l.add(c).div(2).sub(y)),zoom:g,bearing:o}}_cameraForBox(e,i,o,a,r){const n=this._extendCameraOptions(r);o=o||0,a=a||0,e=t.LngLat.convert(e),i=t.LngLat.convert(i);const s=this.transform.clone();s.padding=n.padding;const l=this.getFreeCameraOptions(),c=new t.LngLat(.5*(e.lng+i.lng),.5*(e.lat+i.lat)),h=.5*(o+a);if(s._camera.position[2]<t.mercatorZfromAltitude(h,c.lat))return void t.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.");l.lookAtPoint(c),s.setFreeCameraOptions(l);const u=t.MercatorCoordinate.fromLngLat(e),d=t.MercatorCoordinate.fromLngLat(i),_=s.pointRayIntersection(s.centerPoint,h),m=[(p=s.rayIntersectionCoordinate(_)).x,p.y,p.z];var p;const f=s.screenPointToMercatorRay(s.centerPoint);let g,v=0;do{const e=Math.floor(s.zoom),i=1<<e,r=Math.min(i*u.x,i*d.x),n=Math.min(i*u.y,i*d.y),l=Math.max(i*u.x,i*d.x),c=Math.max(i*u.y,i*d.y),h=new t.Aabb([r,n,o],[l,c,a]),_=t.Frustum.fromInvProjectionMatrix(s.invProjMatrix,s.worldSize,e);if(2!==h.intersects(_)){g&&(s._camera.position=t.scaleAndAdd([],s._camera.position,f.dir,-g),s._updateStateFromCamera());break}const p=t.sub([],s._camera.position,m);g=.5*t.length(p),s._camera.position=t.scaleAndAdd([],s._camera.position,f.dir,g);try{s._updateStateFromCamera();}catch(e){return void t.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}}while(++v<10);return {center:s.center,zoom:s.zoom,bearing:s.bearing,pitch:s.pitch}}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}_raycastElevationBox(e,i){const o=this.transform.elevation;if(!o)return;const a=new t.Point(e.x,i.y),r=new t.Point(i.x,e.y),n=o.pointCoordinate(e);if(!n)return;const s=o.pointCoordinate(i);if(!s)return;const l=o.pointCoordinate(a);if(!l)return;const c=o.pointCoordinate(r);if(!c)return;const h=new t.MercatorCoordinate(n[0],n[1]).toLngLat(),u=new t.MercatorCoordinate(s[0],s[1]).toLngLat(),d=new t.MercatorCoordinate(l[0],l[1]).toLngLat(),_=new t.MercatorCoordinate(c[0],c[1]).toLngLat(),m=Math.min(h.lng,Math.min(u.lng,Math.min(d.lng,_.lng))),p=Math.min(h.lat,Math.min(u.lat,Math.min(d.lat,_.lat))),f=Math.max(h.lng,Math.max(u.lng,Math.max(d.lng,_.lng))),g=Math.max(h.lat,Math.max(u.lat,Math.max(d.lat,_.lat))),v=Math.min(n[3],Math.min(s[3],Math.min(l[3],c[3]))),x=Math.max(n[3],Math.max(s[3],Math.max(l[3],c[3])));return {minLngLat:new t.LngLat(m,p),maxLngLat:new t.LngLat(f,g),minAltitude:v,maxAltitude:x}}fitScreenCoordinates(e,i,o,a,r){let n,s,l,c;const h=t.Point.convert(e),u=t.Point.convert(i),d=this._raycastElevationBox(h,u);if(d)n=d.minLngLat,s=d.maxLngLat,l=d.minAltitude,c=d.maxAltitude;else {if(this.transform.isHorizonVisibleForPoints(h,u))return this;n=this.transform.pointLocation(h),s=this.transform.pointLocation(u);}return this._fitInternal(0===this.transform.pitch?this._cameraForBoxAndBearing(this.transform.pointLocation(t.Point.convert(e)),this.transform.pointLocation(t.Point.convert(i)),o,a):this._cameraForBox(n,s,l,c,a),a,r)}_fitInternal(e,i,o){return e?(delete(i=t.extend(e,i)).padding,i.linear?this.easeTo(i,o):this.flyTo(i,o)):this}jumpTo(e,i){this.stop();const o=this.transform;let a=!1,r=!1,n=!1;return "zoom"in e&&o.zoom!==+e.zoom&&(a=!0,o.zoom=+e.zoom),void 0!==e.center&&(o.center=t.LngLat.convert(e.center)),"bearing"in e&&o.bearing!==+e.bearing&&(r=!0,o.bearing=+e.bearing),"pitch"in e&&o.pitch!==+e.pitch&&(n=!0,o.pitch=+e.pitch),null==e.padding||o.isPaddingEqual(e.padding)||(o.padding=e.padding),this.fire(new t.Event("movestart",i)).fire(new t.Event("move",i)),a&&this.fire(new t.Event("zoomstart",i)).fire(new t.Event("zoom",i)).fire(new t.Event("zoomend",i)),r&&this.fire(new t.Event("rotatestart",i)).fire(new t.Event("rotate",i)).fire(new t.Event("rotateend",i)),n&&this.fire(new t.Event("pitchstart",i)).fire(new t.Event("pitch",i)).fire(new t.Event("pitchend",i)),this.fire(new t.Event("moveend",i))}getFreeCameraOptions(){return this.transform.getFreeCameraOptions()}setFreeCameraOptions(e,i){this.stop();const o=this.transform,a=o.zoom,r=o.pitch,n=o.bearing;o.setFreeCameraOptions(e);const s=a!==o.zoom,l=r!==o.pitch,c=n!==o.bearing;return this.fire(new t.Event("movestart",i)).fire(new t.Event("move",i)),s&&this.fire(new t.Event("zoomstart",i)).fire(new t.Event("zoom",i)).fire(new t.Event("zoomend",i)),c&&this.fire(new t.Event("rotatestart",i)).fire(new t.Event("rotate",i)).fire(new t.Event("rotateend",i)),l&&this.fire(new t.Event("pitchstart",i)).fire(new t.Event("pitch",i)).fire(new t.Event("pitchend",i)),this.fire(new t.Event("moveend",i)),this}easeTo(e,i){this._stop(!1,e.easeId),(!1===(e=t.extend({offset:[0,0],duration:500,easing:t.ease},e)).animate||!e.essential&&t.browser.prefersReducedMotion)&&(e.duration=0);const o=this.transform,a=this.getZoom(),r=this.getBearing(),n=this.getPitch(),s=this.getPadding(),l="zoom"in e?+e.zoom:a,c="bearing"in e?this._normalizeBearing(e.bearing,r):r,h="pitch"in e?+e.pitch:n,u="padding"in e?e.padding:o.padding,d=t.Point.convert(e.offset);let _=o.centerPoint.add(d);const m=o.pointLocation(_),p=t.LngLat.convert(e.center||m);this._normalizeCenter(p);const f=o.project(m),g=o.project(p).sub(f),v=o.zoomScale(l-a);let x,y;e.around&&(x=t.LngLat.convert(e.around),y=o.locationPoint(x));const b={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=this._zooming||l!==a,this._rotating=this._rotating||r!==c,this._pitching=this._pitching||h!==n,this._padding=!o.isPaddingEqual(u),this._easeId=e.easeId,this._prepareEase(i,e.noMoveStart,b),this._ease(e=>{if(this._zooming&&(o.zoom=t.number(a,l,e)),this._rotating&&(o.bearing=t.number(r,c,e)),this._pitching&&(o.pitch=t.number(n,h,e)),this._padding&&(o.interpolatePadding(s,u,e),_=o.centerPoint.add(d)),x)o.setLocationAtPoint(x,y);else {const t=o.zoomScale(o.zoom-a),i=l>a?Math.min(2,v):Math.max(.5,v),r=Math.pow(i,1-e),n=o.unproject(f.add(g.mult(e*r)).mult(t));o.setLocationAtPoint(o.renderWorldCopies?n.wrap():n,_);}this._fireMoveEvents(i);},t=>{o.recenterOnTerrain(),this._afterEase(i,t);},e),this}_prepareEase(e,i,o={}){this._moving=!0,this.transform.cameraElevationReference="sea",i||o.moving||this.fire(new t.Event("movestart",e)),this._zooming&&!o.zooming&&this.fire(new t.Event("zoomstart",e)),this._rotating&&!o.rotating&&this.fire(new t.Event("rotatestart",e)),this._pitching&&!o.pitching&&this.fire(new t.Event("pitchstart",e));}_fireMoveEvents(e){this.fire(new t.Event("move",e)),this._zooming&&this.fire(new t.Event("zoom",e)),this._rotating&&this.fire(new t.Event("rotate",e)),this._pitching&&this.fire(new t.Event("pitch",e));}_afterEase(e,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId,this.transform.cameraElevationReference="ground";const o=this._zooming,a=this._rotating,r=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,o&&this.fire(new t.Event("zoomend",e)),a&&this.fire(new t.Event("rotateend",e)),r&&this.fire(new t.Event("pitchend",e)),this.fire(new t.Event("moveend",e));}flyTo(e,i){if(!e.essential&&t.browser.prefersReducedMotion){const o=t.pick(e,["center","zoom","bearing","pitch","around"]);return this.jumpTo(o,i)}this.stop(),e=t.extend({offset:[0,0],speed:1.2,curve:1.42,easing:t.ease},e);const o=this.transform,a=this.getZoom(),r=this.getBearing(),n=this.getPitch(),s=this.getPadding(),l="zoom"in e?t.clamp(+e.zoom,o.minZoom,o.maxZoom):a,c="bearing"in e?this._normalizeBearing(e.bearing,r):r,h="pitch"in e?+e.pitch:n,u="padding"in e?e.padding:o.padding,d=o.zoomScale(l-a),_=t.Point.convert(e.offset);let m=o.centerPoint.add(_);const p=o.pointLocation(m),f=t.LngLat.convert(e.center||p);this._normalizeCenter(f);const g=o.project(p),v=o.project(f).sub(g);let x=e.curve;const y=Math.max(o.width,o.height),b=y/d,w=v.mag();if("minZoom"in e){const i=t.clamp(Math.min(e.minZoom,a,l),o.minZoom,o.maxZoom),r=y/o.zoomScale(i-a);x=Math.sqrt(r/w*2);}const T=x*x;function E(t){const e=(b*b-y*y+(t?-1:1)*T*T*w*w)/(2*(t?b:y)*T*w);return Math.log(Math.sqrt(e*e+1)-e)}function C(t){return (Math.exp(t)-Math.exp(-t))/2}function S(t){return (Math.exp(t)+Math.exp(-t))/2}const I=E(0);let P=function(t){return S(I)/S(I+x*t)},M=function(t){return y*((S(I)*(C(e=I+x*t)/S(e))-C(I))/T)/w;var e;},z=(E(1)-I)/x;if(Math.abs(w)<1e-6||!isFinite(z)){if(Math.abs(y-b)<1e-6)return this.easeTo(e,i);const t=b<y?-1:1;z=Math.abs(Math.log(b/y))/x,M=function(){return 0},P=function(e){return Math.exp(t*x*e)};}return e.duration="duration"in e?+e.duration:1e3*z/("screenSpeed"in e?+e.screenSpeed/x:+e.speed),e.maxDuration&&e.duration>e.maxDuration&&(e.duration=0),this._zooming=!0,this._rotating=r!==c,this._pitching=h!==n,this._padding=!o.isPaddingEqual(u),this._prepareEase(i,!1),this._ease(e=>{const d=e*z,p=1/P(d);o.zoom=1===e?l:a+o.scaleZoom(p),this._rotating&&(o.bearing=t.number(r,c,e)),this._pitching&&(o.pitch=t.number(n,h,e)),this._padding&&(o.interpolatePadding(s,u,e),m=o.centerPoint.add(_));const x=1===e?f:o.unproject(g.add(v.mult(M(d))).mult(p));o.setLocationAtPoint(o.renderWorldCopies?x.wrap():x,m),o._updateCenterElevation(),this._fireMoveEvents(i);},()=>this._afterEase(i),e),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(t,e){if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e);}if(!t){const t=this.handlers;t&&t.stop(!1);}return this}_ease(e,i,o){!1===o.animate||0===o.duration?(e(1),i()):(this._easeStart=t.browser.now(),this._easeOptions=o,this._onEaseFrame=e,this._onEaseEnd=i,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_renderFrameCallback(){const e=Math.min((t.browser.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(e)),e<1?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();}_normalizeBearing(e,i){e=t.wrap(e,-180,180);const o=Math.abs(e-i);return Math.abs(e-360-i)<o&&(e-=360),Math.abs(e+360-i)<o&&(e+=360),e}_normalizeCenter(t){const e=this.transform;if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0;}}class Qo{constructor(e={}){this.options=e,t.bindAll(["_toggleAttribution","_updateEditLink","_updateData","_updateCompact"],this);}getDefaultPosition(){return "bottom-right"}onAdd(t){const e=this.options&&this.options.compact;return this._map=t,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-attrib"),this._compactButton=a.create("button","mapboxgl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=a.create("div","mapboxgl-ctrl-attrib-inner",this._container),this._innerContainer.setAttribute("role","list"),e&&this._container.classList.add("mapboxgl-compact"),this._updateAttributions(),this._updateEditLink(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("moveend",this._updateEditLink),void 0===e&&(this._map.on("resize",this._updateCompact),this._updateCompact()),this._container}onRemove(){a.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("moveend",this._updateEditLink),this._map.off("resize",this._updateCompact),this._map=void 0,this._attribHTML=void 0;}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i);}_toggleAttribution(){this._container.classList.contains("mapboxgl-compact-show")?(this._container.classList.remove("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-pressed","false")):(this._container.classList.add("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-pressed","true"));}_updateEditLink(){let e=this._editLink;e||(e=this._editLink=this._container.querySelector(".mapbox-improve-map"));const i=[{key:"owner",value:this.styleOwner},{key:"id",value:this.styleId},{key:"access_token",value:this._map._requestManager._customAccessToken||t.config.ACCESS_TOKEN}];if(e){const o=i.reduce((t,e,o)=>(e.value&&(t+=`${e.key}=${e.value}${o<i.length-1?"&":""}`),t),"?");e.href=`${t.config.FEEDBACK_URL}/${o}${this._map._hash?this._map._hash.getHashString(!0):""}`,e.rel="noopener nofollow",this._setElementTitle(e,"MapFeedback");}}_updateData(t){!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType||(this._updateAttributions(),this._updateEditLink());}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map(t=>"string"!=typeof t?"":t)):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id;}const e=this._map.style._sourceCaches;for(const i in e){const o=e[i];if(o.used){const e=o.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution);}}t.sort((t,e)=>t.length-e.length),t=t.filter((e,i)=>{for(let o=i+1;o<t.length;o++)if(t[o].indexOf(e)>=0)return !1;return !0});const i=t.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,t.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("mapboxgl-attrib-empty")):this._container.classList.add("mapboxgl-attrib-empty"),this._editLink=null);}_updateCompact(){this._map.getCanvasContainer().offsetWidth<=640?this._container.classList.add("mapboxgl-compact"):this._container.classList.remove("mapboxgl-compact","mapboxgl-compact-show");}}class ta{constructor(){t.bindAll(["_updateLogo"],this),t.bindAll(["_updateCompact"],this);}onAdd(t){this._map=t,this._container=a.create("div","mapboxgl-ctrl");const e=a.create("a","mapboxgl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://www.mapbox.com/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="none",this._map.on("sourcedata",this._updateLogo),this._updateLogo(),this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){a.remove(this._container),this._map.off("sourcedata",this._updateLogo),this._map.off("resize",this._updateCompact);}getDefaultPosition(){return "bottom-left"}_updateLogo(t){t&&"metadata"!==t.sourceDataType||(this._container.style.display=this._logoRequired()?"block":"none");}_logoRequired(){if(!this._map.style)return;const t=this._map.style._sourceCaches;if(0===Object.entries(t).length)return !0;for(const e in t){const i=t[e].getSource();if(i.hasOwnProperty("mapbox_logo")&&!i.mapbox_logo)return !1}return !0}_updateCompact(){const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<250?e.classList.add("mapboxgl-compact"):e.classList.remove("mapboxgl-compact");}}}class ea{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}const ia={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"Mapbox logo","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm"},{HTMLImageElement:oa,HTMLElement:aa,ImageBitmap:ra}=t.window,na={center:[0,0],zoom:0,bearing:0,pitch:0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:85,interactive:!0,scrollZoom:!0,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,bearingSnap:7,clickTolerance:3,pitchWithRotate:!0,hash:!1,attributionControl:!0,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,trackResize:!0,renderWorldCopies:!0,refreshExpiredTiles:!0,maxTileCacheSize:null,localIdeographFontFamily:"sans-serif",transformRequest:null,accessToken:null,fadeDuration:300,crossSourceCollisions:!0};function sa(t){t.parentNode&&t.parentNode.removeChild(t);}const la={showCompass:!0,showZoom:!0,visualizePitch:!1};class ca{constructor(e,i,o=!1){this._clickTolerance=10,this.element=i,this.mouseRotate=new So({clickTolerance:e.dragRotate._mouseRotate._clickTolerance}),this.map=e,o&&(this.mousePitch=new Io({clickTolerance:e.dragRotate._mousePitch._clickTolerance})),t.bindAll(["mousedown","mousemove","mouseup","touchstart","touchmove","touchend","reset"],this),a.addEventListener(i,"mousedown",this.mousedown),a.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),a.addEventListener(i,"touchmove",this.touchmove),a.addEventListener(i,"touchend",this.touchend),a.addEventListener(i,"touchcancel",this.reset);}down(t,e){this.mouseRotate.mousedown(t,e),this.mousePitch&&this.mousePitch.mousedown(t,e),a.disableDrag();}move(t,e){const i=this.map,o=this.mouseRotate.mousemoveWindow(t,e);if(o&&o.bearingDelta&&i.setBearing(i.getBearing()+o.bearingDelta),this.mousePitch){const o=this.mousePitch.mousemoveWindow(t,e);o&&o.pitchDelta&&i.setPitch(i.getPitch()+o.pitchDelta);}}off(){const t=this.element;a.removeEventListener(t,"mousedown",this.mousedown),a.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),a.removeEventListener(t,"touchmove",this.touchmove),a.removeEventListener(t,"touchend",this.touchend),a.removeEventListener(t,"touchcancel",this.reset),this.offTemp();}offTemp(){a.enableDrag(),a.removeEventListener(t.window,"mousemove",this.mousemove),a.removeEventListener(t.window,"mouseup",this.mouseup);}mousedown(e){this.down(t.extend({},e,{ctrlKey:!0,preventDefault:()=>e.preventDefault()}),a.mousePos(this.element,e)),a.addEventListener(t.window,"mousemove",this.mousemove),a.addEventListener(t.window,"mouseup",this.mouseup);}mousemove(t){this.move(t,a.mousePos(this.element,t));}mouseup(t){this.mouseRotate.mouseupWindow(t),this.mousePitch&&this.mousePitch.mouseupWindow(t),this.offTemp();}touchstart(t){1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=a.touchPos(this.element,t.targetTouches)[0],this.down({type:"mousedown",button:0,ctrlKey:!0,preventDefault:()=>t.preventDefault()},this._startPos));}touchmove(t){1!==t.targetTouches.length?this.reset():(this._lastPos=a.touchPos(this.element,t.targetTouches)[0],this.move({preventDefault:()=>t.preventDefault()},this._lastPos));}touchend(t){0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),this.reset();}reset(){this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp();}}function ha(e,i,o){if(e=new t.LngLat(e.lng,e.lat),i){const a=new t.LngLat(e.lng-360,e.lat),r=new t.LngLat(e.lng+360,e.lat),n=360*Math.ceil(Math.abs(e.lng-o.center.lng)/360),s=o.locationPoint(e).distSqr(i),l=i.x<0||i.y<0||i.x>o.width||i.y>o.height;o.locationPoint(a).distSqr(i)<s&&(l||Math.abs(a.lng-o.center.lng)<n)?e=a:o.locationPoint(r).distSqr(i)<s&&(l||Math.abs(r.lng-o.center.lng)<n)&&(e=r);}for(;Math.abs(e.lng-o.center.lng)>180;){const t=o.locationPoint(e);if(t.x>=0&&t.y>=0&&t.x<=o.width&&t.y<=o.height)break;e.lng>o.center.lng?e.lng-=360:e.lng+=360;}return e}const ua={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function da(t,e,i){const o=t.classList;for(const t in ua)o.remove(`mapboxgl-${i}-anchor-${t}`);o.add(`mapboxgl-${i}-anchor-${e}`);}class _a extends t.Evented{constructor(e,i){if(super(),(e instanceof t.window.HTMLElement||i)&&(e=t.extend({element:e},i)),t.bindAll(["_update","_onMove","_onUp","_addDragHandler","_onMapClick","_onKeyPress"],this),this._anchor=e&&e.anchor||"center",this._color=e&&e.color||"#3FB1CE",this._scale=e&&e.scale||1,this._draggable=e&&e.draggable||!1,this._clickTolerance=e&&e.clickTolerance||0,this._isDragging=!1,this._state="inactive",this._rotation=e&&e.rotation||0,this._rotationAlignment=e&&e.rotationAlignment||"auto",this._pitchAlignment=e&&e.pitchAlignment&&"auto"!==e.pitchAlignment?e.pitchAlignment:this._rotationAlignment,e&&e.element)this._element=e.element,this._offset=t.Point.convert(e&&e.offset||[0,0]);else {this._defaultMarker=!0,this._element=a.create("div"),this._element.setAttribute("aria-label","Map marker");const i=a.createNS("http://www.w3.org/2000/svg","svg"),o=41,r=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${o}px`),i.setAttributeNS(null,"width",`${r}px`),i.setAttributeNS(null,"viewBox",`0 0 ${r} ${o}`);const n=a.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"stroke","none"),n.setAttributeNS(null,"stroke-width","1"),n.setAttributeNS(null,"fill","none"),n.setAttributeNS(null,"fill-rule","evenodd");const s=a.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const l=a.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"transform","translate(3.0, 29.0)"),l.setAttributeNS(null,"fill","#000000");const c=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of c){const e=a.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),l.appendChild(e);}const h=a.createNS("http://www.w3.org/2000/svg","g");h.setAttributeNS(null,"fill",this._color);const u=a.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),h.appendChild(u);const d=a.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=a.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const m=a.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(6.0, 7.0)"),m.setAttributeNS(null,"fill","#FFFFFF");const p=a.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=a.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=a.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),p.appendChild(f),p.appendChild(g),s.appendChild(l),s.appendChild(h),s.appendChild(d),s.appendChild(m),s.appendChild(p),i.appendChild(s),i.setAttributeNS(null,"height",`${o*this._scale}px`),i.setAttributeNS(null,"width",`${r*this._scale}px`),this._element.appendChild(i),this._offset=t.Point.convert(e&&e.offset||[0,-14]);}this._element.classList.add("mapboxgl-marker"),this._element.addEventListener("dragstart",t=>{t.preventDefault();}),this._element.addEventListener("mousedown",t=>{t.preventDefault();}),da(this._element,this._anchor,"marker"),this._popup=null;}addTo(t){return this.remove(),this._map=t,t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),a.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.LngLat.convert(e),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,o=Math.sqrt(Math.pow(i,2)/2);t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-e],"bottom-left":[o,-1*(e-i+o)],"bottom-right":[-o,-1*(e-i+o)],left:[i,-1*(e-i)],right:[-i,-1*(e-i)]}:this._offset;}this._popup=t,this._lngLat&&this._popup.setLngLat(this._lngLat),this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}_onKeyPress(t){const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup();}_onMapClick(t){const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup();}getPopup(){return this._popup}togglePopup(){const t=this._popup;return t?(t.isOpen()?t.remove():t.addTo(this._map),this):this}_updateOcclusion(){this._occlusionTimer||(this._occlusionTimer=setTimeout(this._onOcclusionTimer.bind(this),60));}_onOcclusionTimer(){const t=this._map.transform,e=this._pos?this._pos.sub(this._transformedOffset()):null;if(e&&e.x>=0&&e.x<t.width&&e.y>=0&&e.y<t.height){const t=this._map.unproject(e),i=this._map.getFreeCameraOptions();if(i.position){const e=i.position.toLngLat(),o=e.distanceTo(t),a=e.distanceTo(this._lngLat);this._element.classList.toggle("mapboxgl-marker-occluded",o<.9*a);}}this._occlusionTimer=null;}_update(t){if(!this._map)return;this._map.transform.renderWorldCopies&&(this._lngLat=ha(this._lngLat,this._pos,this._map.transform)),this._pos=this._map.project(this._lngLat)._add(this._transformedOffset()),this._map.transform.elevation&&this._updateOcclusion();let e="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?e=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(e=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let i="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?i="rotateX(0deg)":"map"===this._pitchAlignment&&(i=`rotateX(${this._map.getPitch()}deg)`),t&&"moveend"!==t.type||(this._pos=this._pos.round()),a.setTransform(this._element,`${ua[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${i} ${e}`);}_transformedOffset(){if(!this._defaultMarker)return this._offset;const t=this._map.transform,e=this._offset.mult(this._scale);return "map"===this._rotationAlignment&&e._rotate(t.angle),"map"===this._pitchAlignment&&(e.y*=Math.cos(t._pitch)),e}getOffset(){return this._offset}setOffset(e){return this._offset=t.Point.convert(e),this._update(),this}_onMove(e){if(!this._isDragging){const t=this._clickTolerance||this._map._clickTolerance;this._isDragging=e.point.dist(this._pointerdownPos)>=t;}this._isDragging&&(this._pos=e.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new t.Event("dragstart"))),this.fire(new t.Event("drag")));}_onUp(){this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new t.Event("dragend")),this._state="inactive";}_addDragHandler(t){this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._transformedOffset()),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}}const ma={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let pa,fa=0,ga=!1;const va={maxWidth:100,unit:"metric"};function xa(t,e,i){const o=i&&i.maxWidth||100,a=t._container.clientHeight/2,r=t.unproject([0,a]),n=t.unproject([o,a]),s=r.distanceTo(n);if(i&&"imperial"===i.unit){const i=3.2808*s;i>5280?ya(e,o,i/5280,t._getUIString("ScaleControl.Miles")):ya(e,o,i,t._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?ya(e,o,s/1852,t._getUIString("ScaleControl.NauticalMiles")):s>=1e3?ya(e,o,s/1e3,t._getUIString("ScaleControl.Kilometers")):ya(e,o,s,t._getUIString("ScaleControl.Meters"));}function ya(t,e,i,o){const a=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=`${e*(a/i)}px`,t.innerHTML=`${a}&nbsp;${o}`;}const ba={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px"},wa=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", "),Ta={version:t.version,supported:e,setRTLTextPlugin:t.setRTLTextPlugin,getRTLTextPluginStatus:t.getRTLTextPluginStatus,Map:class extends Jo{constructor(e){if(null!=(e=t.extend({},na,e)).minZoom&&null!=e.maxZoom&&e.minZoom>e.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=e.minPitch&&null!=e.maxPitch&&e.minPitch>e.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=e.minPitch&&e.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=e.maxPitch&&e.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(super(new io(e.minZoom,e.maxZoom,e.minPitch,e.maxPitch,e.renderWorldCopies),e),this._interactive=e.interactive,this._maxTileCacheSize=e.maxTileCacheSize,this._failIfMajorPerformanceCaveat=e.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=e.preserveDrawingBuffer,this._antialias=e.antialias,this._trackResize=e.trackResize,this._bearingSnap=e.bearingSnap,this._refreshExpiredTiles=e.refreshExpiredTiles,this._fadeDuration=e.fadeDuration,this._isInitialLoad=!0,this._crossSourceCollisions=e.crossSourceCollisions,this._crossFadingFactor=1,this._collectResourceTiming=e.collectResourceTiming,this._renderTaskQueue=new ea,this._controls=[],this._mapId=t.uniqueId(),this._locale=t.extend({},ia,e.locale),this._clickTolerance=e.clickTolerance,this._requestManager=new t.RequestManager(e.transformRequest,e.accessToken),"string"==typeof e.container){if(this._container=t.window.document.getElementById(e.container),!this._container)throw new Error(`Container '${e.container}' not found.`)}else {if(!(e.container instanceof aa))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=e.container;}if(e.maxBounds&&this.setMaxBounds(e.maxBounds),t.bindAll(["_onWindowOnline","_onWindowResize","_onMapScroll","_contextLost","_contextRestored"],this),this._setupContainer(),this._setupPainter(),void 0===this.painter)throw new Error("Failed to initialize WebGL.");this.on("move",()=>this._update(!1)),this.on("moveend",()=>this._update(!1)),this.on("zoom",()=>this._update(!0)),void 0!==t.window&&(t.window.addEventListener("online",this._onWindowOnline,!1),t.window.addEventListener("resize",this._onWindowResize,!1),t.window.addEventListener("orientationchange",this._onWindowResize,!1)),this.handlers=new Yo(this,e),this._hash=e.hash&&new oo("string"==typeof e.hash&&e.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:e.center,zoom:e.zoom,bearing:e.bearing,pitch:e.pitch}),e.bounds&&(this.resize(),this.fitBounds(e.bounds,t.extend({},e.fitBoundsOptions,{duration:0})))),this.resize(),this._localIdeographFontFamily=e.localIdeographFontFamily,e.style&&this.setStyle(e.style,{localIdeographFontFamily:e.localIdeographFontFamily}),e.attributionControl&&this.addControl(new Qo({customAttribution:e.customAttribution})),this._logoControl=new ta,this.addControl(this._logoControl,e.logoPosition),this.on("style.load",()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet);}),this.on("data",e=>{this._update("style"===e.dataType),this.fire(new t.Event(`${e.dataType}data`,e));}),this.on("dataloading",e=>{this.fire(new t.Event(`${e.dataType}dataloading`,e));});}_getMapId(){return this._mapId}addControl(e,i){if(void 0===i&&(i=e.getDefaultPosition?e.getDefaultPosition():"top-right"),!e||!e.onAdd)return this.fire(new t.ErrorEvent(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const o=e.onAdd(this);this._controls.push(e);const a=this._controlPositions[i];return -1!==i.indexOf("bottom")?a.insertBefore(o,a.firstChild):a.appendChild(o),this}removeControl(e){if(!e||!e.onRemove)return this.fire(new t.ErrorEvent(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(e);return i>-1&&this._controls.splice(i,1),e.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}resize(e){const i=this._containerDimensions(),o=i[0],a=i[1];this._resizeCanvas(o,a),this.transform.resize(o,a),this.painter.resize(o,a);const r=!this._moving;return r&&(this.stop(),this.fire(new t.Event("movestart",e)).fire(new t.Event("move",e))),this.fire(new t.Event("resize",e)),r&&this.fire(new t.Event("moveend",e)),this}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(e){return this.transform.setMaxBounds(t.LngLatBounds.convert(e)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.minZoom=t,this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.maxZoom=t,this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.minPitch=t,this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?85:t)>85)throw new Error("maxPitch must be less than or equal to 85");if(t>=this.transform.minPitch)return this.transform.maxPitch=t,this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.renderWorldCopies=t,this._update()}project(e){return this.transform.locationPoint3D(t.LngLat.convert(e))}unproject(e){return this.transform.pointLocation3D(t.Point.convert(e))}isMoving(){return this._moving||this.handlers&&this.handlers.isMoving()}isZooming(){return this._zooming||this.handlers&&this.handlers.isZooming()}isRotating(){return this._rotating||this.handlers&&this.handlers.isRotating()}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let o=!1;const a=a=>{const r=this.getLayer(e)?this.queryRenderedFeatures(a.point,{layers:[e]}):[];r.length?o||(o=!0,i.call(this,new _o(t,this,a.originalEvent,{features:r}))):o=!1;};return {layer:e,listener:i,delegates:{mousemove:a,mouseout:()=>{o=!1;}}}}if("mouseleave"===t||"mouseout"===t){let o=!1;const a=a=>{(this.getLayer(e)?this.queryRenderedFeatures(a.point,{layers:[e]}):[]).length?o=!0:o&&(o=!1,i.call(this,new _o(t,this,a.originalEvent)));},r=e=>{o&&(o=!1,i.call(this,new _o(t,this,e.originalEvent)));};return {layer:e,listener:i,delegates:{mousemove:a,mouseout:r}}}{const o=t=>{const o=this.getLayer(e)?this.queryRenderedFeatures(t.point,{layers:[e]}):[];o.length&&(t.features=o,i.call(this,t),delete t.features);};return {layer:e,listener:i,delegates:{[t]:o}}}}on(t,e,i){if(void 0===i)return super.on(t,e);const o=this._createDelegatedListener(t,e,i);this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(o);for(const t in o.delegates)this.on(t,o.delegates[t]);return this}once(t,e,i){if(void 0===i)return super.once(t,e);const o=this._createDelegatedListener(t,e,i);for(const t in o.delegates)this.once(t,o.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._delegatedListeners&&this._delegatedListeners[t]&&(o=>{const a=this._delegatedListeners[t];for(let t=0;t<a.length;t++){const o=a[t];if(o.layer===e&&o.listener===i){for(const t in o.delegates)this.off(t,o.delegates[t]);return a.splice(t,1),this}}})(),this)}queryRenderedFeatures(e,i){return this.style?(void 0!==i||void 0===e||e instanceof t.Point||Array.isArray(e)||(i=e,e=void 0),this.style.queryRenderedFeatures(e=e||[[0,0],[this.transform.width,this.transform.height]],i=i||{},this.transform)):[]}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(e,i){return !1!==(i=t.extend({},{localIdeographFontFamily:this._localIdeographFontFamily},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&e?(this._diffStyle(e,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._updateStyle(e,i))}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){return this.style&&(this.style.setEventedParent(null),this.style._remove(),delete this.style),t&&(this.style=new Wt(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t):this.style.loadJSON(t)),this._updateTerrain(),this}_lazyInitEmptyStyle(){this.style||(this.style=new Wt(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(e,i){if("string"==typeof e){const o=this._requestManager.normalizeStyleURL(e),a=this._requestManager.transformRequest(o,t.ResourceType.Style);t.getJSON(a,(e,o)=>{e?this.fire(new t.ErrorEvent(e)):o&&this._updateDiff(o,i);});}else "object"==typeof e&&this._updateDiff(e,i);}_updateDiff(e,i){try{this.style.setState(e)&&this._update(!0);}catch(o){t.warnOnce(`Unable to perform style diff: ${o.message||o.error||o}.  Rebuilding the style from scratch.`),this._updateStyle(e,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():t.warnOnce("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(e){const i=this.style&&this.style._getSourceCaches(e);if(0!==i.length)return i.every(t=>t.loaded());this.fire(new t.ErrorEvent(new Error(`There is no source with ID '${e}'`)));}areTilesLoaded(){const t=this.style&&this.style._sourceCaches;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}}return !0}addSourceType(t,e,i){return this._lazyInitEmptyStyle(),this.style.addSourceType(t,e,i)}removeSource(t){return this.style.removeSource(t),this._updateTerrain(),this._update(!0)}getSource(t){return this.style.getSource(t)}addImage(e,i,{pixelRatio:o=1,sdf:a=!1,stretchX:r,stretchY:n,content:s}={}){if(this._lazyInitEmptyStyle(),i instanceof oa||ra&&i instanceof ra){const{width:l,height:c,data:h}=t.browser.getImageData(i);this.style.addImage(e,{data:new t.RGBAImage({width:l,height:c},h),pixelRatio:o,stretchX:r,stretchY:n,content:s,sdf:a,version:0});}else {if(void 0===i.width||void 0===i.height)return this.fire(new t.ErrorEvent(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:l,height:c,data:h}=i,u=i;this.style.addImage(e,{data:new t.RGBAImage({width:l,height:c},new Uint8Array(h)),pixelRatio:o,stretchX:r,stretchY:n,content:s,sdf:a,version:0,userImage:u}),u.onAdd&&u.onAdd(this,e);}}}updateImage(e,i){const o=this.style.getImage(e);if(!o)return this.fire(new t.ErrorEvent(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const a=i instanceof oa||ra&&i instanceof ra?t.browser.getImageData(i):i,{width:r,height:n,data:s}=a;return void 0===r||void 0===n?this.fire(new t.ErrorEvent(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`"))):r!==o.data.width||n!==o.data.height?this.fire(new t.ErrorEvent(new Error("The width and height of the updated image must be that same as the previous version of the image"))):(o.data.replace(s,!(i instanceof oa||ra&&i instanceof ra)),void this.style.updateImage(e,o))}hasImage(e){return e?!!this.style.getImage(e):(this.fire(new t.ErrorEvent(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t);}loadImage(e,i){t.getImage(this._requestManager.transformRequest(e,t.ResourceType.Image),i);}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,o={}){return this.style.setPaintProperty(t,e,i,o),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,o={}){return this.style.setLayoutProperty(t,e,i,o),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setTerrain(t){return this._lazyInitEmptyStyle(),this.style.setTerrain(t),this._update(!0)}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_detectMissingCSS(){"rgb(250, 128, 114)"!==t.window.getComputedStyle(this._missingCSSCanary).getPropertyValue("background-color")&&t.warnOnce("This page appears to be missing CSS declarations for Mapbox GL JS, which may cause the map to display incorrectly. Please ensure your page includes mapbox-gl.css, as described in https://www.mapbox.com/mapbox-gl-js/api/.");}_setupContainer(){const t=this._container;t.classList.add("mapboxgl-map"),(this._missingCSSCanary=a.create("div","mapboxgl-canary",t)).style.visibility="hidden",this._detectMissingCSS();const e=this._canvasContainer=a.create("div","mapboxgl-canvas-container",t);this._interactive&&e.classList.add("mapboxgl-interactive"),this._canvas=a.create("canvas","mapboxgl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex","0"),this._canvas.setAttribute("aria-label","Map"),this._canvas.setAttribute("role","region");const i=this._containerDimensions();this._resizeCanvas(i[0],i[1]);const o=this._controlContainer=a.create("div","mapboxgl-control-container",t),r=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach(t=>{r[t]=a.create("div",`mapboxgl-ctrl-${t}`,o);}),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(e,i){const o=t.browser.devicePixelRatio||1;this._canvas.width=o*e,this._canvas.height=o*i,this._canvas.style.width=`${e}px`,this._canvas.style.height=`${i}px`;}_setupPainter(){const i=t.extend({},e.webGLContextAttributes,{failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1}),o=this._canvas.getContext("webgl",i)||this._canvas.getContext("experimental-webgl",i);o?(this.painter=new ji(o,this.transform),this.on("data",t=>{"source"===t.dataType&&this.painter.setTileLoadedFlag(!0);}),t.webpSupported.testSupport(o)):this.fire(new t.ErrorEvent(new Error("Failed to initialize WebGL")));}_contextLost(e){e.preventDefault(),this._frame&&(this._frame.cancel(),this._frame=null),this.fire(new t.Event("webglcontextlost",{originalEvent:e}));}_contextRestored(e){this._setupPainter(),this.resize(),this._update(),this.fire(new t.Event("webglcontextrestored",{originalEvent:e}));}_onMapScroll(t){if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t);}_render(e){let i,o=0;const a=this.painter.context.extTimerQuery;if(this.listens("gpu-timing-frame")&&(i=a.createQueryEXT(),a.beginQueryEXT(a.TIME_ELAPSED_EXT,i),o=t.browser.now()),this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(e),this._removed)return;let r=!1;const n=this._isInitialLoad?0:this._fadeDuration;if(this.style&&this._styleDirty){this._styleDirty=!1;const e=this.transform.zoom,i=t.browser.now();this.style.zoomHistory.update(e,i);const o=new t.EvaluationParameters(e,{now:i,fadeDuration:n,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),a=o.crossFadingFactor();1===a&&a===this._crossFadingFactor||(r=!0,this._crossFadingFactor=a),this.style.update(o);}if(this.style&&this._sourcesDirty&&(this._sourcesDirty=!1,this._updateTerrain(),this.style._updateSources(this.transform)),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,n,this._crossSourceCollisions),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,showQueryGeometry:!!this._showQueryGeometry,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:n,isInitialLoad:this._isInitialLoad,showPadding:this.showPadding,gpuTiming:!!this.listens("gpu-timing-layer"),speedIndexTiming:this.speedIndexTiming}),this.fire(new t.Event("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,this.fire(new t.Event("load"))),this.style&&(this.style.hasTransitions()||r)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles(),this.listens("gpu-timing-frame")){const e=t.browser.now()-o;a.endQueryEXT(a.TIME_ELAPSED_EXT,i),setTimeout(()=>{const o=a.getQueryObjectEXT(i,a.QUERY_RESULT_EXT)/1e6;a.deleteQueryEXT(i),this.fire(new t.Event("gpu-timing-frame",{cpuTime:e,gpuTime:o}));},50);}if(this.listens("gpu-timing-layer")){const e=this.painter.collectGpuTimers();setTimeout(()=>{const i=this.painter.queryGpuTimers(e);this.fire(new t.Event("gpu-timing-layer",{layerTimes:i}));},50);}const s=this._sourcesDirty||this._styleDirty||this._placementDirty;if(s||this._repaint)this.triggerRepaint();else if(this._triggerFrame(!1),!this.isMoving()&&this.loaded()&&(this.fire(new t.Event("idle")),this._isInitialLoad&&this._authenticate(),this._isInitialLoad=!1,this.speedIndexTiming)){const e=this._calculateSpeedIndex();this.fire(new t.Event("speedindexcompleted",{speedIndex:e})),this.speedIndexTiming=!1;}return !this._loaded||this._fullyLoaded||s||(this._fullyLoaded=!0),this}_authenticate(){t.getMapSessionAPI(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,e=>{if(e&&(e.message===t.AUTH_ERR_MSG||401===e.status)){console.error("Error: A valid Mapbox access token is required to use Mapbox GL JS. To create an account or a new access token, visit https://account.mapbox.com/"),t.browser.setErrorState();const e=this.painter.context.gl;this._logoControl instanceof ta&&this._logoControl._updateLogo(),e&&e.clear(e.DEPTH_BUFFER_BIT|e.COLOR_BUFFER_BIT|e.STENCIL_BUFFER_BIT);}}),t.postMapLoadEvent(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,()=>{});}_updateTerrain(){this.painter.updateTerrain(this.style,this.isMoving()||this.isRotating()||this.isZooming());}_calculateSpeedIndex(){const t=this.painter.canvasCopy(),e=this.painter.getCanvasCopiesAndTimestamps();e.timeStamps.push(performance.now());const i=this.painter.context.gl,o=i.createFramebuffer();function a(t){i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,t,0);const e=new Uint8Array(i.drawingBufferWidth*i.drawingBufferHeight*4);return i.readPixels(0,0,i.drawingBufferWidth,i.drawingBufferHeight,i.RGBA,i.UNSIGNED_BYTE,e),e}return i.bindFramebuffer(i.FRAMEBUFFER,o),this._canvasPixelComparison(a(t),e.canvasCopies.map(a),e.timeStamps)}_canvasPixelComparison(t,e,i){let o=i[1]-i[0];const a=t.length/4;for(let r=0;r<e.length;r++){const n=e[r];let s=0;for(let e=0;e<n.length;e+=4)n[e]===t[e]&&n[e+1]===t[e+1]&&n[e+2]===t[e+2]&&n[e+3]===t[e+3]&&(s+=1);o+=(i[r+2]-i[r+1])*(1-s/a);}return o}remove(){this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frame&&(this._frame.cancel(),this._frame=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),void 0!==t.window&&(t.window.removeEventListener("resize",this._onWindowResize,!1),t.window.removeEventListener("orientationchange",this._onWindowResize,!1),t.window.removeEventListener("online",this._onWindowOnline,!1));const e=this.painter.context.gl.getExtension("WEBGL_lose_context");e&&e.loseContext(),sa(this._canvasContainer),sa(this._controlContainer),sa(this._missingCSSCanary),this._container.classList.remove("mapboxgl-map"),this._removed=!0,this.fire(new t.Event("remove"));}triggerRepaint(){this._triggerFrame(!0);}_triggerFrame(e){this._renderNextFrame=this._renderNextFrame||e,this.style&&!this._frame&&(this._frame=t.browser.frame(t=>{const e=!!this._renderNextFrame;this._frame=null,this._renderNextFrame=null,e&&this._render(t);}));}_onWindowOnline(){this._update();}_onWindowResize(t){this._trackResize&&this.resize({originalEvent:t})._update();}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update());}get speedIndexTiming(){return !!this._speedIndexTiming}set speedIndexTiming(t){this._speedIndexTiming!==t&&(this._speedIndexTiming=t,this._update());}get showPadding(){return !!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update());}get repaint(){return !!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(t){this._vertices=t,this._update();}_setCacheLimits(e,i){t.setCacheLimits(e,i);}get version(){return t.version}},NavigationControl:class{constructor(e){this.options=t.extend({},la,e),this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._container.addEventListener("contextmenu",t=>t.preventDefault()),this.options.showZoom&&(t.bindAll(["_setButtonTitle","_updateZoomButtons"],this),this._zoomInButton=this._createButton("mapboxgl-ctrl-zoom-in",t=>this._map.zoomIn({},{originalEvent:t})),a.create("span","mapboxgl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden",!0),this._zoomOutButton=this._createButton("mapboxgl-ctrl-zoom-out",t=>this._map.zoomOut({},{originalEvent:t})),a.create("span","mapboxgl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden",!0)),this.options.showCompass&&(t.bindAll(["_rotateCompassArrow"],this),this._compass=this._createButton("mapboxgl-ctrl-compass",t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t});}),this._compassIcon=a.create("span","mapboxgl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden",!0));}_updateZoomButtons(){const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString());}_rotateCompassArrow(){const t=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitch*(Math.PI/180)),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${this._map.transform.angle*(180/Math.PI)}deg)`:`rotate(${this._map.transform.angle*(180/Math.PI)}deg)`;this._compassIcon.style.transform=t;}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new ca(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){a.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map;}_createButton(t,e){const i=a.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}_setButtonTitle(t,e){const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i);}},GeolocateControl:class extends t.Evented{constructor(e){super(),this.options=t.extend({},ma,e),t.bindAll(["_onSuccess","_onError","_onZoom","_finish","_setupUI","_updateCamera","_updateMarker"],this);}onAdd(e){var i;return this._map=e,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),i=this._setupUI,void 0!==pa?i(pa):void 0!==t.window.navigator.permissions?t.window.navigator.permissions.query({name:"geolocation"}).then(t=>{pa="denied"!==t.state,i(pa);}):(pa=!!t.window.navigator.geolocation,i(pa)),this._container}onRemove(){void 0!==this._geolocationWatchID&&(t.window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),a.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,fa=0,ga=!1;}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");}}_onSuccess(e){if(this._map){if(this._isOutOfMapMaxBounds(e))return this._setErrorState(),this.fire(new t.Event("outofmaxbounds",e)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=e,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(e),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(e),this.options.showUserLocation&&this._dotElement.classList.remove("mapboxgl-user-location-dot-stale"),this.fire(new t.Event("geolocate",e)),this._finish();}}_updateCamera(e){const i=new t.LngLat(e.coords.longitude,e.coords.latitude),o=e.coords.accuracy,a=this._map.getBearing(),r=t.extend({bearing:a},this.options.fitBoundsOptions);this._map.fitBounds(i.toBounds(o),r,{geolocateSource:!0});}_updateMarker(e){if(e){const i=new t.LngLat(e.coords.longitude,e.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=e.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();}_updateCircleRadius(){const t=this._map._container.clientHeight/2,e=this._map.unproject([0,t]),i=this._map.unproject([1,t]),o=e.distanceTo(i),a=Math.ceil(2*this._accuracy/o);this._circleElement.style.width=`${a}px`,this._circleElement.style.height=`${a}px`;}_onZoom(){this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}_onError(e){if(this._map){if(this.options.trackUserLocation)if(1===e.code){this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===e.code&&ga)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("mapboxgl-user-location-dot-stale"),this.fire(new t.Event("error",e)),this._finish();}}_finish(){this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;}_setupUI(e){if(this._container.addEventListener("contextmenu",t=>t.preventDefault()),this._geolocateButton=a.create("button","mapboxgl-ctrl-geolocate",this._container),a.create("span","mapboxgl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden",!0),this._geolocateButton.type="button",!1===e){t.warnOnce("Geolocation support is not available so the GeolocateControl will be disabled.");const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}else {const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=a.create("div","mapboxgl-user-location-dot"),this._userLocationDotMarker=new _a(this._dotElement),this._circleElement=a.create("div","mapboxgl-user-location-accuracy-circle"),this._accuracyCircleMarker=new _a({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",this.trigger.bind(this)),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",e=>{e.geolocateSource||"ACTIVE_LOCK"!==this._watchState||e.originalEvent&&"resize"===e.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this.fire(new t.Event("trackuserlocationend")));});}trigger(){if(!this._setup)return t.warnOnce("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new t.Event("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":fa--,ga=!1,this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this.fire(new t.Event("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new t.Event("trackuserlocationstart"));}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"BACKGROUND":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");break;case"BACKGROUND_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error");}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),fa++,fa>1?(e={maximumAge:6e5,timeout:0},ga=!0):(e=this.options.positionOptions,ga=!1),this._geolocationWatchID=t.window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,e);}}else t.window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){t.window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},AttributionControl:Qo,ScaleControl:class{constructor(e){this.options=t.extend({},va,e),t.bindAll(["_onMove","setUnit"],this);}getDefaultPosition(){return "bottom-left"}_onMove(){xa(this._map,this._container,this.options);}onAdd(t){return this._map=t,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){a.remove(this._container),this._map.off("move",this._onMove),this._map=void 0;}setUnit(t){this.options.unit=t,xa(this._map,this._container,this.options);}},FullscreenControl:class{constructor(e){this._fullscreen=!1,e&&e.container&&(e.container instanceof t.window.HTMLElement?this._container=e.container:t.warnOnce("Full screen control 'container' must be a DOM element.")),t.bindAll(["_onClickFullscreen","_changeIcon"],this),"onfullscreenchange"in t.window.document?this._fullscreenchange="fullscreenchange":"onwebkitfullscreenchange"in t.window.document&&(this._fullscreenchange="webkitfullscreenchange");}onAdd(e){return this._map=e,this._container||(this._container=this._map.getContainer()),this._controlContainer=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._checkFullscreenSupport()?this._setupUI():(this._controlContainer.style.display="none",t.warnOnce("This device does not support fullscreen mode.")),this._controlContainer}onRemove(){a.remove(this._controlContainer),this._map=null,t.window.document.removeEventListener(this._fullscreenchange,this._changeIcon);}_checkFullscreenSupport(){return !(!t.window.document.fullscreenEnabled&&!t.window.document.webkitFullscreenEnabled)}_setupUI(){const e=this._fullscreenButton=a.create("button","mapboxgl-ctrl-fullscreen",this._controlContainer);a.create("span","mapboxgl-ctrl-icon",e).setAttribute("aria-hidden",!0),e.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),t.window.document.addEventListener(this._fullscreenchange,this._changeIcon);}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_changeIcon(){(t.window.document.fullscreenElement||t.window.document.webkitFullscreenElement)===this._container!==this._fullscreen&&(this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("mapboxgl-ctrl-shrink"),this._fullscreenButton.classList.toggle("mapboxgl-ctrl-fullscreen"),this._updateTitle());}_onClickFullscreen(){this._isFullscreen()?t.window.document.exitFullscreen?t.window.document.exitFullscreen():t.window.document.webkitCancelFullScreen&&t.window.document.webkitCancelFullScreen():this._container.requestFullscreen?this._container.requestFullscreen():this._container.webkitRequestFullscreen&&this._container.webkitRequestFullscreen();}},Popup:class extends t.Evented{constructor(e){super(),this.options=t.extend(Object.create(ba),e),t.bindAll(["_update","_onClose","remove","_onMouseMove","_onMouseUp","_onDrag"],this);}addTo(e){return this._map&&this.remove(),this._map=e,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.add("mapboxgl-track-pointer")):this._map.on("move",this._update),this.fire(new t.Event("open")),this}isOpen(){return !!this._map}remove(){return this._content&&a.remove(this._content),this._container&&(a.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),delete this._map),this.fire(new t.Event("close")),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.LngLat.convert(e),this._pos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.remove("mapboxgl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.add("mapboxgl-track-pointer")),this}getElement(){return this._container}setText(e){return this.setDOMContent(t.window.document.createTextNode(e))}setHTML(e){const i=t.window.document.createDocumentFragment(),o=t.window.document.createElement("body");let a;for(o.innerHTML=e;a=o.firstChild,a;)i.appendChild(a);return this.setDOMContent(i)}getMaxWidth(){return this._container&&this._container.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=a.create("div","mapboxgl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){this._container&&this._container.classList.add(t);}removeClassName(t){this._container&&this._container.classList.remove(t);}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}_createCloseButton(){this.options.closeButton&&(this._closeButton=a.create("button","mapboxgl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.setAttribute("aria-label","Close popup"),this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose));}_onMouseUp(t){this._update(t.point);}_onMouseMove(t){this._update(t.point);}_onDrag(t){this._update(t.point);}_update(e){if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(this._container||(this._container=a.create("div","mapboxgl-popup",this._map.getContainer()),this._tip=a.create("div","mapboxgl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className&&this.options.className.split(" ").forEach(t=>this._container.classList.add(t)),this._trackPointer&&this._container.classList.add("mapboxgl-popup-track-pointer")),this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._map.transform.renderWorldCopies&&!this._trackPointer&&(this._lngLat=ha(this._lngLat,this._pos,this._map.transform)),this._trackPointer&&!e)return;const i=this._pos=this._trackPointer&&e?e:this._map.project(this._lngLat);let o=this.options.anchor;const r=function e(i){if(i){if("number"==typeof i){const e=Math.round(Math.sqrt(.5*Math.pow(i,2)));return {center:new t.Point(0,0),top:new t.Point(0,i),"top-left":new t.Point(e,e),"top-right":new t.Point(-e,e),bottom:new t.Point(0,-i),"bottom-left":new t.Point(e,-e),"bottom-right":new t.Point(-e,-e),left:new t.Point(i,0),right:new t.Point(-i,0)}}if(i instanceof t.Point||Array.isArray(i)){const e=t.Point.convert(i);return {center:e,top:e,"top-left":e,"top-right":e,bottom:e,"bottom-left":e,"bottom-right":e,left:e,right:e}}return {center:t.Point.convert(i.center||[0,0]),top:t.Point.convert(i.top||[0,0]),"top-left":t.Point.convert(i["top-left"]||[0,0]),"top-right":t.Point.convert(i["top-right"]||[0,0]),bottom:t.Point.convert(i.bottom||[0,0]),"bottom-left":t.Point.convert(i["bottom-left"]||[0,0]),"bottom-right":t.Point.convert(i["bottom-right"]||[0,0]),left:t.Point.convert(i.left||[0,0]),right:t.Point.convert(i.right||[0,0])}}return e(new t.Point(0,0))}(this.options.offset);if(!o){const t=this._container.offsetWidth,e=this._container.offsetHeight;let a;a=i.y+r.bottom.y<e?["top"]:i.y>this._map.transform.height-e?["bottom"]:[],i.x<t/2?a.push("left"):i.x>this._map.transform.width-t/2&&a.push("right"),o=0===a.length?"bottom":a.join("-");}const n=i.add(r[o]).round();a.setTransform(this._container,`${ua[o]} translate(${n.x}px,${n.y}px)`),da(this._container,o,"popup");}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(wa);t&&t.focus();}_onClose(){this.remove();}},Marker:_a,Style:Wt,LngLat:t.LngLat,LngLatBounds:t.LngLatBounds,Point:t.Point,MercatorCoordinate:t.MercatorCoordinate,FreeCameraOptions:to,Evented:t.Evented,config:t.config,prewarm:function(){q().acquire(N);},clearPrewarmedResources:function(){const t=G;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(N),G=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},get accessToken(){return t.config.ACCESS_TOKEN},set accessToken(e){t.config.ACCESS_TOKEN=e;},get baseApiUrl(){return t.config.API_URL},set baseApiUrl(e){t.config.API_URL=e;},get workerCount(){return Z.workerCount},set workerCount(t){Z.workerCount=t;},get maxParallelImageRequests(){return t.config.MAX_PARALLEL_IMAGE_REQUESTS},set maxParallelImageRequests(e){t.config.MAX_PARALLEL_IMAGE_REQUESTS=e;},clearStorage(e){t.clearTileCache(e);},workerUrl:"",workerClass:null,setNow:t.browser.setNow,restoreNow:t.browser.restoreNow};return Ta}));

//

return mapboxgl;

})));
//# sourceMappingURL=mapbox-gl.js.map
