# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.resource_list import ResourceList  # noqa: F401,E501
from odahuflow.sdk.models import util


class ResourceRequirements(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, limits: ResourceList=None, requests: ResourceList=None):  # noqa: E501
        """ResourceRequirements - a model defined in Swagger

        :param limits: The limits of this ResourceRequirements.  # noqa: E501
        :type limits: ResourceList
        :param requests: The requests of this ResourceRequirements.  # noqa: E501
        :type requests: ResourceList
        """
        self.swagger_types = {
            'limits': ResourceList,
            'requests': ResourceList
        }

        self.attribute_map = {
            'limits': 'limits',
            'requests': 'requests'
        }

        self._limits = limits
        self._requests = requests

    @classmethod
    def from_dict(cls, dikt) -> 'ResourceRequirements':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ResourceRequirements of this ResourceRequirements.  # noqa: E501
        :rtype: ResourceRequirements
        """
        return util.deserialize_model(dikt, cls)

    @property
    def limits(self) -> ResourceList:
        """Gets the limits of this ResourceRequirements.

        Limits describes the maximum amount of compute resources allowed.  # noqa: E501

        :return: The limits of this ResourceRequirements.
        :rtype: ResourceList
        """
        return self._limits

    @limits.setter
    def limits(self, limits: ResourceList):
        """Sets the limits of this ResourceRequirements.

        Limits describes the maximum amount of compute resources allowed.  # noqa: E501

        :param limits: The limits of this ResourceRequirements.
        :type limits: ResourceList
        """

        self._limits = limits

    @property
    def requests(self) -> ResourceList:
        """Gets the requests of this ResourceRequirements.

        Requests describes the minimum amount of compute resources required.  # noqa: E501

        :return: The requests of this ResourceRequirements.
        :rtype: ResourceList
        """
        return self._requests

    @requests.setter
    def requests(self, requests: ResourceList):
        """Sets the requests of this ResourceRequirements.

        Requests describes the minimum amount of compute resources required.  # noqa: E501

        :param requests: The requests of this ResourceRequirements.
        :type requests: ResourceList
        """

        self._requests = requests
