# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.model_packaging_result import ModelPackagingResult  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelPackagingStatus(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, created_at: str=None, exit_code: int=None, message: str=None, pod_name: str=None, reason: str=None, results: List[ModelPackagingResult]=None, state: str=None, updated_at: str=None):  # noqa: E501
        """ModelPackagingStatus - a model defined in Swagger

        :param created_at: The created_at of this ModelPackagingStatus.  # noqa: E501
        :type created_at: str
        :param exit_code: The exit_code of this ModelPackagingStatus.  # noqa: E501
        :type exit_code: int
        :param message: The message of this ModelPackagingStatus.  # noqa: E501
        :type message: str
        :param pod_name: The pod_name of this ModelPackagingStatus.  # noqa: E501
        :type pod_name: str
        :param reason: The reason of this ModelPackagingStatus.  # noqa: E501
        :type reason: str
        :param results: The results of this ModelPackagingStatus.  # noqa: E501
        :type results: List[ModelPackagingResult]
        :param state: The state of this ModelPackagingStatus.  # noqa: E501
        :type state: str
        :param updated_at: The updated_at of this ModelPackagingStatus.  # noqa: E501
        :type updated_at: str
        """
        self.swagger_types = {
            'created_at': str,
            'exit_code': int,
            'message': str,
            'pod_name': str,
            'reason': str,
            'results': List[ModelPackagingResult],
            'state': str,
            'updated_at': str
        }

        self.attribute_map = {
            'created_at': 'createdAt',
            'exit_code': 'exitCode',
            'message': 'message',
            'pod_name': 'podName',
            'reason': 'reason',
            'results': 'results',
            'state': 'state',
            'updated_at': 'updatedAt'
        }

        self._created_at = created_at
        self._exit_code = exit_code
        self._message = message
        self._pod_name = pod_name
        self._reason = reason
        self._results = results
        self._state = state
        self._updated_at = updated_at

    @classmethod
    def from_dict(cls, dikt) -> 'ModelPackagingStatus':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelPackagingStatus of this ModelPackagingStatus.  # noqa: E501
        :rtype: ModelPackagingStatus
        """
        return util.deserialize_model(dikt, cls)

    @property
    def created_at(self) -> str:
        """Gets the created_at of this ModelPackagingStatus.


        :return: The created_at of this ModelPackagingStatus.
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at: str):
        """Sets the created_at of this ModelPackagingStatus.


        :param created_at: The created_at of this ModelPackagingStatus.
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def exit_code(self) -> int:
        """Gets the exit_code of this ModelPackagingStatus.

        Pod exit code  # noqa: E501

        :return: The exit_code of this ModelPackagingStatus.
        :rtype: int
        """
        return self._exit_code

    @exit_code.setter
    def exit_code(self, exit_code: int):
        """Sets the exit_code of this ModelPackagingStatus.

        Pod exit code  # noqa: E501

        :param exit_code: The exit_code of this ModelPackagingStatus.
        :type exit_code: int
        """

        self._exit_code = exit_code

    @property
    def message(self) -> str:
        """Gets the message of this ModelPackagingStatus.

        Pod last log  # noqa: E501

        :return: The message of this ModelPackagingStatus.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str):
        """Sets the message of this ModelPackagingStatus.

        Pod last log  # noqa: E501

        :param message: The message of this ModelPackagingStatus.
        :type message: str
        """

        self._message = message

    @property
    def pod_name(self) -> str:
        """Gets the pod_name of this ModelPackagingStatus.

        Pod package for name  # noqa: E501

        :return: The pod_name of this ModelPackagingStatus.
        :rtype: str
        """
        return self._pod_name

    @pod_name.setter
    def pod_name(self, pod_name: str):
        """Sets the pod_name of this ModelPackagingStatus.

        Pod package for name  # noqa: E501

        :param pod_name: The pod_name of this ModelPackagingStatus.
        :type pod_name: str
        """

        self._pod_name = pod_name

    @property
    def reason(self) -> str:
        """Gets the reason of this ModelPackagingStatus.

        Pod reason  # noqa: E501

        :return: The reason of this ModelPackagingStatus.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason: str):
        """Sets the reason of this ModelPackagingStatus.

        Pod reason  # noqa: E501

        :param reason: The reason of this ModelPackagingStatus.
        :type reason: str
        """

        self._reason = reason

    @property
    def results(self) -> List[ModelPackagingResult]:
        """Gets the results of this ModelPackagingStatus.

        List of packaing results  # noqa: E501

        :return: The results of this ModelPackagingStatus.
        :rtype: List[ModelPackagingResult]
        """
        return self._results

    @results.setter
    def results(self, results: List[ModelPackagingResult]):
        """Sets the results of this ModelPackagingStatus.

        List of packaing results  # noqa: E501

        :param results: The results of this ModelPackagingStatus.
        :type results: List[ModelPackagingResult]
        """

        self._results = results

    @property
    def state(self) -> str:
        """Gets the state of this ModelPackagingStatus.

        Model Packaging State  # noqa: E501

        :return: The state of this ModelPackagingStatus.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str):
        """Sets the state of this ModelPackagingStatus.

        Model Packaging State  # noqa: E501

        :param state: The state of this ModelPackagingStatus.
        :type state: str
        """

        self._state = state

    @property
    def updated_at(self) -> str:
        """Gets the updated_at of this ModelPackagingStatus.


        :return: The updated_at of this ModelPackagingStatus.
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at: str):
        """Sets the updated_at of this ModelPackagingStatus.


        :param updated_at: The updated_at of this ModelPackagingStatus.
        :type updated_at: str
        """

        self._updated_at = updated_at
