# pdom
Simulation toolkit for the Photocatalytic Degradation of Organic Molecules


[![PyPi](https://img.shields.io/pypi/v/pdom.svg?style=for-the-badge)](https://pypi.org/project/pdom/)
[![Status](https://img.shields.io/pypi/status/pdom.svg?style=for-the-badge)](https://pypi.org/project/pdom/)
[![License](https://img.shields.io/github/license/theia-dev/pdom.svg?style=for-the-badge)](https://github.com/theia-dev/pdom/blob/master/LICENSE.txt)

[![Github issues](https://img.shields.io/github/issues/theia-dev/pdom.svg?style=for-the-badge)](https://github.com/theia-dev/pdom/issues)
[![Coverage](https://img.shields.io/coveralls/github/theia-dev/pdom?style=for-the-badge)](https://coveralls.io/github/theia-dev/pdom)
[![Build](https://img.shields.io/travis/theia-dev/pdom.svg?style=for-the-badge)](https://travis-ci.org/theia-dev/pdom)


[![DOI](https://img.shields.io/badge/DOI-10.1016%2Fj.cej.2014.05.147-green?style=for-the-badge)](https://doi.org/10.1016/j.cej.2014.05.147)
[![Documentation](https://img.shields.io/readthedocs/pdom.svg?style=for-the-badge)](https://pdom.readthedocs.io)



## Setup

Most features of pdom can be directly accessed from its command-line tools.
The easiest way to install them on your system is via [pipx](https://pipxproject.github.io/pipx/).
So if you just need the CLI, use the following line to install pdom.

    pipx install pdom
    

You can also install the `pdom` library directly through the Python Package Index ([PyPI](https://pypi.org)) for use in your own projects.
The use of a [virtual environment](https://docs.python.org/3/tutorial/venv.html) is recommended.

    pip install pdom


If the stable version of `pdom` on PyPI is missing a particular function, you can install the latest version directly from the GitHub repository.

    pip install -U git+https://github.com/theia-dev/pdom.git#egg=pdom

## Citation
If you use `pdom` in your work please cite the paper describing the [basic models](https://doi.org/10.1016/j.cej.2014.05.147) 


> Eckert, H., Bobeth, M., Teixeira, S., Kühn, K., & Cuniberti, G.
> **Modeling of photocatalytic degradation of organic components in water by nanoparticle suspension.**
> *Chemical Engineering Journal* **261**, (2015). 
> doi: [10.1016/j.cej.2014.05.147](https://doi.org/10.1016/j.cej.2014.05.147)

***

The full source code can be accessed on [GitHub](https://github.com/theia-dev/pdom) with the corresponding documentation hosted at [Read the docs](https://pdom.readthedocs.io).
