# auto generated by update_py.py

from . import message_pb2 as message_pb


def _rspAccountStr(self):
    return '<account tg={} avail={} withd={} marketV={} curMarr={}>'.format(
        self.account_id, self.avail_amt, self.balance,
        self.mkt_value, self.frz_margin
    )


def _positionInfoStr(self):
    return '<pos-{}-{} tkr={} src={} dir={} mm={} pos={} ydpos={} cost={} frz={} avail={} brw={} i={} lpx={} rr={} pnl={} | {} | {}>'.format(
        message_pb.Exchange.Name(self.exchange), message_pb.SecurityType.Name(self.security_type), self.symbol,
        self.sub_account, message_pb.Direction.Name(self.direction), message_pb.MarginMode.Name(self.margin_mode),
        self.position, self.yd_pos, self.pos_cost, self.frz_pos, self.avail_pos, self.borrowed, self.interest,
        self.liq_price, self.risk_rate, self.pnl, self.realized_pnl, self.unrealized_pnl
    )


def _gatewayPositionStr(self):
    s = '<position tg={} count={}\n'.format(self.account_id, len(self.positions))
    for pos in self.positions:
        s += '\t' + str(pos) + '\n'
    s += '>'
    return s


def _gatewayOrdersStr(self):
    s = '<orders tg={} count={}\n'.format(self.account_id, len(self.orders))
    for order in self.orders:
        s += '\t' + str(order) + '\n'
    s += '>'
    return s


def _reqOrderCancelStr(self):
    return '<oc oid={} rid={} tg_name={}>'.format(
        self.order_id, self.req_id, self.account_id
    )


def _rspOrderCancelStr(self):
    return '<roc rid={} oid={} ref={} eid={} err={}>'.format(
        self.req_id, self.order_id, self.order_ref, self.err_id, self.err_msg
    )


def _reqOrderInsertStr(self):
    return '<ord-{} pid={} tg={} exch={} ref={} tkr={} px={} vol={} type={} dir={}>'.format(
        self.order_id, self.parent_id, self.account_id, message_pb.Exchange.Name(self.exchange),
        self.order_ref, self.symbol, self.entrust_price, self.entrust_vol,
        message_pb.OrderType.Name(self.order_type), message_pb.Side.Name(self.side)
    )


def _rspOrderInsertStr(self):
    return '<roi oid={} ref={} err_id={} err_msg={}>'.format(
        self.order_id, self.order_ref, self.err_id, self.err_msg
    )


def _rtnOrderStr(self):
    return '<o oid={} ref={} tg={} exch={} ass={} tkr={} tp={} status={} traded={} create_t={} update_t={}>'.format(
        self.order_id, self.order_ref, self.account_id, message_pb.Exchange.Name(self.exchange),
        message_pb.SecurityType.Name(self.security_type), self.symbol,
        message_pb.OrderType.Name(self.order_type), message_pb.OrderStatus.Name(self.order_status),
        self.traded_vol, self.create_time.ToDatetime(), self.update_time.ToDatetime()
    )


def _rtnTradeStr(self):
    return '<t tid={} oid={} ref={} tg={} exch={} ass={} tkr={} dir={} tp={} px={} vol={} comm={} t={}>'.format(
        self.trade_ref, self.order_id, self.order_ref, self.account_id, message_pb.Exchange.Name(self.exchange),
        message_pb.SecurityType.Name(self.security_type), self.symbol, message_pb.Side.Name(self.side),
        message_pb.OrderType.Name(self.order_type), self.traded_price, self.traded_vol, self.commission,
        self.trade_time.ToDatetime()
    )


def _rspOrderInfoStr(self):
    return '<ord-{} tg={} exch={} ref={} tkr={} px={} vol={} type={} dir={} status={} vol_traded={}>'.format(
        self.order_id, self.account_id, message_pb.Exchange.Name(self.exchange), self.order_ref,
        self.symbol, self.entrust_price, self.entrust_vol, message_pb.OrderType.Name(self.order_type),
        message_pb.Side.Name(self.side), message_pb.OrderStatus.Name(self.order_status), self.traded_vol
    )


def _rspHistoryTradesStr(self):
    s = '<trades tg={} count={}\n'.format(self.account_id, len(self.trades))
    for trade in self.trades:
        s += '\t' + str(trade) + '\n'
    s += '>'
    return s


def _rspCancelActiveOrdersStr(self):
    return '<aoc eid={} err={}>'.format(self.err_id, self.err_msg)


# message_pb.ReqAccount.__str__
message_pb.RspAccount.__str__ = _rspAccountStr
# message_pb.ReqPosition.__str__
message_pb.PositionInfo.__str__ = _positionInfoStr
message_pb.GatewayPosition.__str__ = _gatewayPositionStr
# message_pb.ReqActiveOrders.__str__
message_pb.GatewayOrders.__str__ = _gatewayOrdersStr
message_pb.ReqOrderCancel.__str__ = _reqOrderCancelStr
message_pb.RspOrderCancel.__str__ = _rspOrderCancelStr
message_pb.ReqOrderInsert.__str__ = _reqOrderInsertStr
message_pb.RspOrderInsert.__str__ = _rspOrderInsertStr
message_pb.RtnOrder.__str__ = _rtnOrderStr
message_pb.RtnTrade.__str__ = _rtnTradeStr
# message_pb.ReqOrderInfo.__str__
message_pb.RspOrderInfo.__str__ = _rspOrderInfoStr
# message_pb.ReqHistoryTrades.__str__
message_pb.RspHistoryTrades.__str__ = _rspHistoryTradesStr
# message_pb.ReqCancelActiveOrders.__str__
message_pb.RspCancelActiveOrders.__str__ = _rspCancelActiveOrdersStr
