# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.35.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class TransferRequest(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Push to card or pull from card
    """


    class MetaOapg:
        required = {
            "amount",
            "originating_account_id",
            "external_card_id",
            "currency",
            "type",
        }
        
        class properties:
            amount = schemas.IntSchema
        
            @staticmethod
            def currency() -> typing.Type['CurrencyCode']:
                return CurrencyCode
            external_card_id = schemas.UUIDSchema
            originating_account_id = schemas.UUIDSchema
        
            @staticmethod
            def type() -> typing.Type['TransferTypeRequest']:
                return TransferTypeRequest
        
            @staticmethod
            def merchant() -> typing.Type['Merchant']:
                return Merchant
            __annotations__ = {
                "amount": amount,
                "currency": currency,
                "external_card_id": external_card_id,
                "originating_account_id": originating_account_id,
                "type": type,
                "merchant": merchant,
            }
    
    amount: MetaOapg.properties.amount
    originating_account_id: MetaOapg.properties.originating_account_id
    external_card_id: MetaOapg.properties.external_card_id
    currency: 'CurrencyCode'
    type: 'TransferTypeRequest'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["currency"]) -> 'CurrencyCode': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["external_card_id"]) -> MetaOapg.properties.external_card_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["originating_account_id"]) -> MetaOapg.properties.originating_account_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> 'TransferTypeRequest': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["merchant"]) -> 'Merchant': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["amount", "currency", "external_card_id", "originating_account_id", "type", "merchant", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["currency"]) -> 'CurrencyCode': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["external_card_id"]) -> MetaOapg.properties.external_card_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["originating_account_id"]) -> MetaOapg.properties.originating_account_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> 'TransferTypeRequest': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["merchant"]) -> typing.Union['Merchant', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["amount", "currency", "external_card_id", "originating_account_id", "type", "merchant", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        amount: typing.Union[MetaOapg.properties.amount, decimal.Decimal, int, ],
        originating_account_id: typing.Union[MetaOapg.properties.originating_account_id, str, uuid.UUID, ],
        external_card_id: typing.Union[MetaOapg.properties.external_card_id, str, uuid.UUID, ],
        currency: 'CurrencyCode',
        type: 'TransferTypeRequest',
        merchant: typing.Union['Merchant', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'TransferRequest':
        return super().__new__(
            cls,
            *_args,
            amount=amount,
            originating_account_id=originating_account_id,
            external_card_id=external_card_id,
            currency=currency,
            type=type,
            merchant=merchant,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.currency_code import CurrencyCode
from synctera_client.model.merchant import Merchant
from synctera_client.model.transfer_type_request import TransferTypeRequest
