# 一种不需要密码的加密方法（用于防止网盘扫描等场景）

安全与便利总是难以兼顾，记忆密码或管理密码，加密或解密时输入密码等操作如果能彻底免除，会非常便利，但是安全性也自然会降低。

幸好，日常生活中有些场景本身就不要求很高的安全规格，只需要稍稍加点防护就足够了。

比如上传到网盘，只要不被轻易扫描、或者万一泄露文件时让人看着一堆乱码不乐意花时间精力去解密，就足够了。

因此，我想到了**把密钥直接内嵌到密文里**的方法，从此不需要记忆或管理密码，因为密码就在密文里，解密时也不需要填写密码，用脚本自动化提取密码就可以解密了，方便到极致！

当然，该方法只适用于大多数普通文件，不适用于真正的机密。

## 听起来不靠谱？（原理）

其实很靠谱，因为：

1. 一般人根本想不到密码就在密文里
2. 就算想到了，也不知道具体位置
3. 如果我把一个密钥拆成 3 段，分别镶嵌在不同位置，就更难猜了
4. 如果我把密钥拆成 N 段，并且调换顺序后再镶嵌进密文里，你还乐意去猜吗？

而加密解密却很方便，不需要记住密码，因为程序可以自动化提取密钥。

即便如此，当然还是不适用于真正的机密，但日常大多数文件这样处理已经足够安全了。

## 开源脚本

不久之前我做了一个命令行工具框架，用来管理零散的脚本，这个加密脚本也是其中的一个插件。

安装框架的方法看这里: https://github.com/ahui2016/ffe/blob/main/docs/usage.md (简单来说， pip install ffe 就可以了，要求 python 3.10+)

安装了 ffe 之后，用以下命令安装这个加密解密脚本：

```sh
ffe install -i https://github.com/ahui2016/ffe/raw/main/recipes/mimi.py
```

如果遇到网络问题，也可以使用 gitee 地址：

```sh
ffe install -i https://gitee.com/ipelago/ffe/raw/main/recipes/mimi.py
```

最后安装依赖 `pip install cryptography` (只依赖这一个第三方库)

## 使用方法

- 使用命令 `ffe info -r mimi` 可查看详细说明。
- 使用命令 `ffe run -r mimi file.txt` 即可加密 file.txt, 加密后的文件是 file.txt.mimi。
- 使用命令 `ffe run -r mimi file.txt.mimi` 即可解密 file.txt.mimi, 解密后的文件是 file.txt （**命令是一样的，根据文件的后缀名来自动选择加密/解密**）

可见，加密解密过程都不需要输入密码。

使用命令 `ffe dump -r mimi file.txt > mimi.toml` 可以生成一个 mimi.toml 文件，以后可以使用命令 `ffe run -f mimi.toml` 来执行相同的任务，这对于需要经常重复的操作来说是很方便的。而且，在 toml 文件里还可以添加别的任务（比如打包压缩），一次性依次执行一系列任务。

## 关于 ffe

ffe 是一个命令行插件框架，可以用 Python 来写插件，多个插件可组合使用，适合用来管理零散的脚本。后续我还会发帖介绍我写的插件，比如免费上传文件到云端。多个文件组合后，使用一个命令
`ffe run -f <toml file>` 即可一次性执行打包、加密、上传，toml 文件的编辑也很直观。
