# Generated by Django 2.2.7 on 2020-11-03 00:04

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_wireguard.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='WireguardInterface',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True, validators=[django.core.validators.RegexValidator('^[A-z0-9]+$', 'Interface Name must be a string of alphanumeric chars.')], verbose_name='Interface Name')),
                ('listen_port', models.PositiveIntegerField(validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='Listen Port')),
                ('address', models.TextField(blank=True, validators=[django_wireguard.validators.validate_allowed_ips], verbose_name='Interface addresses.')),
                ('private_key', models.CharField(blank=True, max_length=64, validators=[django_wireguard.validators.validate_wireguard_private_key], verbose_name='Private Key (leave empty to auto generate)')),
            ],
            options={
                'verbose_name': 'WireGuard Interface',
                'verbose_name_plural': 'WireGuard Interfaces',
            },
        ),
        migrations.CreateModel(
            name='WireguardPeer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('private_key', models.CharField(blank=True, max_length=64, null=True, validators=[django_wireguard.validators.validate_wireguard_private_key], verbose_name="Peer's Private Key")),
                ('public_key', models.CharField(blank=True, max_length=64, unique=True, validators=[django_wireguard.validators.validate_wireguard_public_key], verbose_name="Peer's Public Key")),
                ('dns', models.TextField(blank=True, help_text='Comma separated list.', validators=[django_wireguard.validators.validate_allowed_ips], verbose_name='DNS')),
                ('address', models.CharField(blank=True, max_length=20, validators=[django_wireguard.validators.validate_private_ipv4], verbose_name='Address')),
                ('interface_allowed_ips', models.TextField(blank=True, help_text='One per line', validators=[django_wireguard.validators.validate_allowed_ips], verbose_name='Interface Allowed IPs')),
                ('allowed_ips', models.TextField(blank=True, help_text='Comma separated list.', validators=[django_wireguard.validators.validate_allowed_ips], verbose_name='Allowed IPs')),
                ('interface_persistent_keepalive', models.PositiveIntegerField(blank=True, default=0, verbose_name='Interface Persistent Keepalive')),
                ('persistent_keepalive', models.PositiveIntegerField(blank=True, default=0, verbose_name='Persistent Keepalive')),
                ('interface', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='peers', to='django_wireguard.WireguardInterface', verbose_name='Interface')),
            ],
            options={
                'verbose_name': 'WireGuard Peer',
                'verbose_name_plural': 'WireGuard Peers',
                'unique_together': {('interface', 'name')},
            },
        ),
    ]
