# Filter-Picker

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3609025.svg)](https://doi.org/10.5281/zenodo.3609025)
[![Travis (.org)](https://img.shields.io/travis/mbagagli/filterpicker?label=travis-build&style=plastic)](https://travis-ci.org/github/mbagagli/filterpicker)
[![Documentation Status](https://readthedocs.org/projects/filterpicker/badge/?version=latest)](https://filterpicker.readthedocs.io/en/latest/?badge=latest)

AUTHOR: Matteo Bagagli

VERSION: 1.1.0

DATE: 05/2022

-------------------------------------------------------

FilterPicker is a general purpose, broad-band, phase detector and picker which is applicable to
real-time seismic monitoring and earthquake early-warning.
This module is a Python implementation of the A.Lomax Filter Picker and has has been rewritten using NumPy libraries.
For a full method description the reader is referred to the main authors paper.

If you make use of this package, please consider citing* it with the provided DOI. Thanks :)

```
@misc{mbagagli_2019_3609025,
    author       = {Matteo Bagagli},
    title        = {filterpicker: general purpose, broad-band, phase detector and picker},
    month        = Nov,
    year         = 2019,
    doi          = {10.5281/zenodo.3609025},
    version      = {1.0.3},
    publisher    = {Zenodo},
    url          = {https://doi.org/10.5281/zenodo.3609025}
    }
```


<!-- # "(e.g. -x  # only linear detrend and mean removal"
# "      -x bandpass 1 30 2 # linear detrend and mean removal + "
# "filtering (type f1 [f2] n-poles)"
# "   USAGE: %(prog)s STREAMPATH -p 0.20 1.0 0.1 5 10 2 "
# "-x bandpass 1 30 -o fp_picks.csv" -->


## Installation

### PyPI

The package has been uploaded in _PyPI_ repository.
For the stable releases you could just type:
```
pip install filterpicker  # (latest 1.1.0)
```
and be ready to go. If you want all the newest features and bugfix, please fork the project or clone it locally (see below the manual installation procedures).

Please note that PyPI releases don't support Python=3.5.
If you would like to have it, download the GitHub release `v1.0.5`.

Since version `v1.1.0` the support for Python=3.5 has been dropped!
All commits are always tested on CI to ensure stability over releases.

### Manual installation and contribution

If you want to install the library manually or just being updated to the latest patches,
the installation is pretty easy because the package comes with an installer.
All the dependencies are explained in the `requirements.txt` file.
It is still recommended, though, to use a virtual environment (`conda` or `pipenv`)

Just open a terminal and type
```
$ git clone https://github.com/billy4all/filterpicker /somwhere/in/my/pc
$ cd where/you/cloned
$ # optionally activate your virtual env
$ pip install .
$ pytest  # to double-check the correct installation (need to install pytest first)
```
For contributions (that are very welcome), please use the `DEVELOP` branch as the upstream one.

## How to
If you did install manually the package you can try the software by running the scripts
in the `example` folder (manual installation).

Although being used mostly as a seismic phase-picker, this software is a great transient detector
that could come handy for other time-series analysis as well. For this reason, I tried to mantain the
library dependencies as clean as possible (only `numpy` and `matplotlib`).
In fact, in order to work the software needs only a `numpy.array` and a sampling time.

From `v1.1.0` I provide a python wrapper for seismic-phases picking: `bin/run_filter_picker.py`.
The script can be called from commandline and comes with an helper (`run_filter_picker.py --help`)
n order to work, the scripts needs to have the [ObsPy](https://github.com/obspy/obspy) library installed in
order to handle the I/O operations.  Example usage:
```bash
$ run_filter_picker.py OBSPY-STREAM-PATH -p 0.20  1.0  0.1  5  10  2 -x bp 2 1 30 --plot
```


--------------------------------------------------------------
For any issues bug reports, the use of the GitHub [issues panel](https://github.com/mbagagli/filterpicker/issues)
is preferred. Otherwise, send an email to the [maintainer](mailto:matteo.bagagli@ingv.it).


#### References

- Lomax, A., C. Satriano and M. Vassallo (2012), Automatic picker developments and optimization: FilterPicker - a robust, broadband picker for real-time seismic monitoring and earthquake early-warning, Seism. Res. Lett. , 83, 531-540, doi: 10.1785/gssrl.83.3.531.

- Vassallo, M., C. Satriano and A. Lomax, (2012), Automatic picker developments and optimization: A strategy for improving the performances of automatic phase pickers, Seism. Res. Lett. , 83, 541-554, doi: 10.1785/gssrl.83.3.541.

- [MATLAB package](https://ch.mathworks.com/matlabcentral/fileexchange/69211-filterpicker-a-robust-broadband-phase-detector-and-picker)
