# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nodeum_sdk.configuration import Configuration


class TaskSchedule(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'task_id': 'int',
        'rrule': 'str',
        'done': 'bool',
        'next': 'str',
        'missed_count': 'int',
        'skipped_count': 'int',
        'missed_last': 'str',
        'missed_first': 'str'
    }

    attribute_map = {
        'id': 'id',
        'task_id': 'task_id',
        'rrule': 'rrule',
        'done': 'done',
        'next': 'next',
        'missed_count': 'missed_count',
        'skipped_count': 'skipped_count',
        'missed_last': 'missed_last',
        'missed_first': 'missed_first'
    }

    def __init__(self, id=None, task_id=None, rrule=None, done=None, next=None, missed_count=None, skipped_count=None, missed_last=None, missed_first=None, local_vars_configuration=None):  # noqa: E501
        """TaskSchedule - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._task_id = None
        self._rrule = None
        self._done = None
        self._next = None
        self._missed_count = None
        self._skipped_count = None
        self._missed_last = None
        self._missed_first = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if task_id is not None:
            self.task_id = task_id
        if rrule is not None:
            self.rrule = rrule
        if done is not None:
            self.done = done
        if next is not None:
            self.next = next
        if missed_count is not None:
            self.missed_count = missed_count
        if skipped_count is not None:
            self.skipped_count = skipped_count
        if missed_last is not None:
            self.missed_last = missed_last
        if missed_first is not None:
            self.missed_first = missed_first

    @property
    def id(self):
        """Gets the id of this TaskSchedule.  # noqa: E501


        :return: The id of this TaskSchedule.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TaskSchedule.


        :param id: The id of this TaskSchedule.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def task_id(self):
        """Gets the task_id of this TaskSchedule.  # noqa: E501


        :return: The task_id of this TaskSchedule.  # noqa: E501
        :rtype: int
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this TaskSchedule.


        :param task_id: The task_id of this TaskSchedule.  # noqa: E501
        :type: int
        """

        self._task_id = task_id

    @property
    def rrule(self):
        """Gets the rrule of this TaskSchedule.  # noqa: E501


        :return: The rrule of this TaskSchedule.  # noqa: E501
        :rtype: str
        """
        return self._rrule

    @rrule.setter
    def rrule(self, rrule):
        """Sets the rrule of this TaskSchedule.


        :param rrule: The rrule of this TaskSchedule.  # noqa: E501
        :type: str
        """

        self._rrule = rrule

    @property
    def done(self):
        """Gets the done of this TaskSchedule.  # noqa: E501


        :return: The done of this TaskSchedule.  # noqa: E501
        :rtype: bool
        """
        return self._done

    @done.setter
    def done(self, done):
        """Sets the done of this TaskSchedule.


        :param done: The done of this TaskSchedule.  # noqa: E501
        :type: bool
        """

        self._done = done

    @property
    def next(self):
        """Gets the next of this TaskSchedule.  # noqa: E501


        :return: The next of this TaskSchedule.  # noqa: E501
        :rtype: str
        """
        return self._next

    @next.setter
    def next(self, next):
        """Sets the next of this TaskSchedule.


        :param next: The next of this TaskSchedule.  # noqa: E501
        :type: str
        """

        self._next = next

    @property
    def missed_count(self):
        """Gets the missed_count of this TaskSchedule.  # noqa: E501


        :return: The missed_count of this TaskSchedule.  # noqa: E501
        :rtype: int
        """
        return self._missed_count

    @missed_count.setter
    def missed_count(self, missed_count):
        """Sets the missed_count of this TaskSchedule.


        :param missed_count: The missed_count of this TaskSchedule.  # noqa: E501
        :type: int
        """

        self._missed_count = missed_count

    @property
    def skipped_count(self):
        """Gets the skipped_count of this TaskSchedule.  # noqa: E501


        :return: The skipped_count of this TaskSchedule.  # noqa: E501
        :rtype: int
        """
        return self._skipped_count

    @skipped_count.setter
    def skipped_count(self, skipped_count):
        """Sets the skipped_count of this TaskSchedule.


        :param skipped_count: The skipped_count of this TaskSchedule.  # noqa: E501
        :type: int
        """

        self._skipped_count = skipped_count

    @property
    def missed_last(self):
        """Gets the missed_last of this TaskSchedule.  # noqa: E501


        :return: The missed_last of this TaskSchedule.  # noqa: E501
        :rtype: str
        """
        return self._missed_last

    @missed_last.setter
    def missed_last(self, missed_last):
        """Sets the missed_last of this TaskSchedule.


        :param missed_last: The missed_last of this TaskSchedule.  # noqa: E501
        :type: str
        """

        self._missed_last = missed_last

    @property
    def missed_first(self):
        """Gets the missed_first of this TaskSchedule.  # noqa: E501


        :return: The missed_first of this TaskSchedule.  # noqa: E501
        :rtype: str
        """
        return self._missed_first

    @missed_first.setter
    def missed_first(self, missed_first):
        """Sets the missed_first of this TaskSchedule.


        :param missed_first: The missed_first of this TaskSchedule.  # noqa: E501
        :type: str
        """

        self._missed_first = missed_first

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskSchedule):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskSchedule):
            return True

        return self.to_dict() != other.to_dict()
