# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nodeum_sdk.api_client import ApiClient
from nodeum_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TaskExecutionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def index_task_executions(self, **kwargs):  # noqa: E501
        """Lists all task executions.  # noqa: E501

        **API Key Scope**: task_executions / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_task_executions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param bool complete_list: If `false`, only includes the last correct execution of a task.
        :param str id: Filter on id
        :param str task_id: Filter on task id
        :param str name: Filter on name
        :param str workflow_type: Filter on task workflow type
        :param str workflow_action: Filter on task workflow action
        :param str source_type: Filter on task source type
        :param str destination_type: Filter on task destination type
        :param str status: Filter on status
        :param str log_time: Filter on log time
        :param str job_started: Filter on job started
        :param str job_finished: Filter on job finished
        :param str creation_date: Filter on creation date
        :param str modification_date: Filter on modification date
        :param str to_process_size: Filter on to process size
        :param str processed_size: Filter on processed size
        :param str to_process_files: Filter on to process files
        :param str processed_files: Filter on processed files
        :param str finalized_files: Filter on finalized files
        :param str estimation_time: Filter on estimation time
        :param str bandwidth: Filter on bandwidth
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskExecutionCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_task_executions_with_http_info(**kwargs)  # noqa: E501

    def index_task_executions_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all task executions.  # noqa: E501

        **API Key Scope**: task_executions / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_task_executions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param bool complete_list: If `false`, only includes the last correct execution of a task.
        :param str id: Filter on id
        :param str task_id: Filter on task id
        :param str name: Filter on name
        :param str workflow_type: Filter on task workflow type
        :param str workflow_action: Filter on task workflow action
        :param str source_type: Filter on task source type
        :param str destination_type: Filter on task destination type
        :param str status: Filter on status
        :param str log_time: Filter on log time
        :param str job_started: Filter on job started
        :param str job_finished: Filter on job finished
        :param str creation_date: Filter on creation date
        :param str modification_date: Filter on modification date
        :param str to_process_size: Filter on to process size
        :param str processed_size: Filter on processed size
        :param str to_process_files: Filter on to process files
        :param str processed_files: Filter on processed files
        :param str finalized_files: Filter on finalized files
        :param str estimation_time: Filter on estimation time
        :param str bandwidth: Filter on bandwidth
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskExecutionCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'offset',
            'sort_by',
            'complete_list',
            'id',
            'task_id',
            'name',
            'workflow_type',
            'workflow_action',
            'source_type',
            'destination_type',
            'status',
            'log_time',
            'job_started',
            'job_finished',
            'creation_date',
            'modification_date',
            'to_process_size',
            'processed_size',
            'to_process_files',
            'processed_files',
            'finalized_files',
            'estimation_time',
            'bandwidth'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_task_executions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'complete_list' in local_var_params and local_var_params['complete_list'] is not None:  # noqa: E501
            query_params.append(('complete_list', local_var_params['complete_list']))  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('task_id', local_var_params['task_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'workflow_type' in local_var_params and local_var_params['workflow_type'] is not None:  # noqa: E501
            query_params.append(('workflow_type', local_var_params['workflow_type']))  # noqa: E501
        if 'workflow_action' in local_var_params and local_var_params['workflow_action'] is not None:  # noqa: E501
            query_params.append(('workflow_action', local_var_params['workflow_action']))  # noqa: E501
        if 'source_type' in local_var_params and local_var_params['source_type'] is not None:  # noqa: E501
            query_params.append(('source_type', local_var_params['source_type']))  # noqa: E501
        if 'destination_type' in local_var_params and local_var_params['destination_type'] is not None:  # noqa: E501
            query_params.append(('destination_type', local_var_params['destination_type']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'log_time' in local_var_params and local_var_params['log_time'] is not None:  # noqa: E501
            query_params.append(('log_time', local_var_params['log_time']))  # noqa: E501
        if 'job_started' in local_var_params and local_var_params['job_started'] is not None:  # noqa: E501
            query_params.append(('job_started', local_var_params['job_started']))  # noqa: E501
        if 'job_finished' in local_var_params and local_var_params['job_finished'] is not None:  # noqa: E501
            query_params.append(('job_finished', local_var_params['job_finished']))  # noqa: E501
        if 'creation_date' in local_var_params and local_var_params['creation_date'] is not None:  # noqa: E501
            query_params.append(('creation_date', local_var_params['creation_date']))  # noqa: E501
        if 'modification_date' in local_var_params and local_var_params['modification_date'] is not None:  # noqa: E501
            query_params.append(('modification_date', local_var_params['modification_date']))  # noqa: E501
        if 'to_process_size' in local_var_params and local_var_params['to_process_size'] is not None:  # noqa: E501
            query_params.append(('to_process_size', local_var_params['to_process_size']))  # noqa: E501
        if 'processed_size' in local_var_params and local_var_params['processed_size'] is not None:  # noqa: E501
            query_params.append(('processed_size', local_var_params['processed_size']))  # noqa: E501
        if 'to_process_files' in local_var_params and local_var_params['to_process_files'] is not None:  # noqa: E501
            query_params.append(('to_process_files', local_var_params['to_process_files']))  # noqa: E501
        if 'processed_files' in local_var_params and local_var_params['processed_files'] is not None:  # noqa: E501
            query_params.append(('processed_files', local_var_params['processed_files']))  # noqa: E501
        if 'finalized_files' in local_var_params and local_var_params['finalized_files'] is not None:  # noqa: E501
            query_params.append(('finalized_files', local_var_params['finalized_files']))  # noqa: E501
        if 'estimation_time' in local_var_params and local_var_params['estimation_time'] is not None:  # noqa: E501
            query_params.append(('estimation_time', local_var_params['estimation_time']))  # noqa: E501
        if 'bandwidth' in local_var_params and local_var_params['bandwidth'] is not None:  # noqa: E501
            query_params.append(('bandwidth', local_var_params['bandwidth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task_executions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskExecutionCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_task_executions_by_task(self, **kwargs):  # noqa: E501
        """Lists all task executions.  # noqa: E501

        **API Key Scope**: task_executions / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_task_executions_by_task(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Filter on task id
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str name: Filter on name
        :param str workflow_type: Filter on task workflow type
        :param str workflow_action: Filter on task workflow action
        :param str source_type: Filter on task source type
        :param str destination_type: Filter on task destination type
        :param str status: Filter on status
        :param str log_time: Filter on log time
        :param str job_started: Filter on job started
        :param str job_finished: Filter on job finished
        :param str to_process_size: Filter on to process size
        :param str processed_size: Filter on processed size
        :param str to_process_files: Filter on to process files
        :param str processed_files: Filter on processed files
        :param str finalized_files: Filter on finalized files
        :param str estimation_time: Filter on estimation time
        :param str bandwidth: Filter on bandwidth
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskExecutionCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_task_executions_by_task_with_http_info(**kwargs)  # noqa: E501

    def index_task_executions_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all task executions.  # noqa: E501

        **API Key Scope**: task_executions / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_task_executions_by_task_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Filter on task id
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str name: Filter on name
        :param str workflow_type: Filter on task workflow type
        :param str workflow_action: Filter on task workflow action
        :param str source_type: Filter on task source type
        :param str destination_type: Filter on task destination type
        :param str status: Filter on status
        :param str log_time: Filter on log time
        :param str job_started: Filter on job started
        :param str job_finished: Filter on job finished
        :param str to_process_size: Filter on to process size
        :param str processed_size: Filter on processed size
        :param str to_process_files: Filter on to process files
        :param str processed_files: Filter on processed files
        :param str finalized_files: Filter on finalized files
        :param str estimation_time: Filter on estimation time
        :param str bandwidth: Filter on bandwidth
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskExecutionCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'limit',
            'offset',
            'sort_by',
            'id',
            'name',
            'workflow_type',
            'workflow_action',
            'source_type',
            'destination_type',
            'status',
            'log_time',
            'job_started',
            'job_finished',
            'to_process_size',
            'processed_size',
            'to_process_files',
            'processed_files',
            'finalized_files',
            'estimation_time',
            'bandwidth'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_task_executions_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('task_id', local_var_params['task_id']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'workflow_type' in local_var_params and local_var_params['workflow_type'] is not None:  # noqa: E501
            query_params.append(('workflow_type', local_var_params['workflow_type']))  # noqa: E501
        if 'workflow_action' in local_var_params and local_var_params['workflow_action'] is not None:  # noqa: E501
            query_params.append(('workflow_action', local_var_params['workflow_action']))  # noqa: E501
        if 'source_type' in local_var_params and local_var_params['source_type'] is not None:  # noqa: E501
            query_params.append(('source_type', local_var_params['source_type']))  # noqa: E501
        if 'destination_type' in local_var_params and local_var_params['destination_type'] is not None:  # noqa: E501
            query_params.append(('destination_type', local_var_params['destination_type']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'log_time' in local_var_params and local_var_params['log_time'] is not None:  # noqa: E501
            query_params.append(('log_time', local_var_params['log_time']))  # noqa: E501
        if 'job_started' in local_var_params and local_var_params['job_started'] is not None:  # noqa: E501
            query_params.append(('job_started', local_var_params['job_started']))  # noqa: E501
        if 'job_finished' in local_var_params and local_var_params['job_finished'] is not None:  # noqa: E501
            query_params.append(('job_finished', local_var_params['job_finished']))  # noqa: E501
        if 'to_process_size' in local_var_params and local_var_params['to_process_size'] is not None:  # noqa: E501
            query_params.append(('to_process_size', local_var_params['to_process_size']))  # noqa: E501
        if 'processed_size' in local_var_params and local_var_params['processed_size'] is not None:  # noqa: E501
            query_params.append(('processed_size', local_var_params['processed_size']))  # noqa: E501
        if 'to_process_files' in local_var_params and local_var_params['to_process_files'] is not None:  # noqa: E501
            query_params.append(('to_process_files', local_var_params['to_process_files']))  # noqa: E501
        if 'processed_files' in local_var_params and local_var_params['processed_files'] is not None:  # noqa: E501
            query_params.append(('processed_files', local_var_params['processed_files']))  # noqa: E501
        if 'finalized_files' in local_var_params and local_var_params['finalized_files'] is not None:  # noqa: E501
            query_params.append(('finalized_files', local_var_params['finalized_files']))  # noqa: E501
        if 'estimation_time' in local_var_params and local_var_params['estimation_time'] is not None:  # noqa: E501
            query_params.append(('estimation_time', local_var_params['estimation_time']))  # noqa: E501
        if 'bandwidth' in local_var_params and local_var_params['bandwidth'] is not None:  # noqa: E501
            query_params.append(('bandwidth', local_var_params['bandwidth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/task_executions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskExecutionCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_task_execution(self, **kwargs):  # noqa: E501
        """Displays a specific task execution.  # noqa: E501

        **API Key Scope**: task_executions / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_task_execution(task_execution_id=task_execution_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_task_execution_with_http_info(**kwargs)  # noqa: E501

    def show_task_execution_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific task execution.  # noqa: E501

        **API Key Scope**: task_executions / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_task_execution_with_http_info(task_execution_id=task_execution_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskExecution, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_execution_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_task_execution" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `show_task_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/task_executions/{task_execution_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskExecution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_task_execution_by_task(self, **kwargs):  # noqa: E501
        """Displays a specific task execution.  # noqa: E501

        **API Key Scope**: task_executions / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_task_execution_by_task(task_id=task_id_value, task_execution_id=task_execution_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_task_execution_by_task_with_http_info(**kwargs)  # noqa: E501

    def show_task_execution_by_task_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific task execution.  # noqa: E501

        **API Key Scope**: task_executions / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_task_execution_by_task_with_http_info(task_id=task_id_value, task_execution_id=task_execution_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Numeric ID or name of task. Task names are not unique, it's recommanded to use numeric ID. (required)
        :param str task_execution_id: Numeric ID of task execution. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskExecution, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_execution_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_task_execution_by_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `show_task_execution_by_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id' is set
        if self.api_client.client_side_validation and ('task_execution_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_execution_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_execution_id` when calling `show_task_execution_by_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['task_id'] = local_var_params['task_id']  # noqa: E501
        if 'task_execution_id' in local_var_params:
            path_params['task_execution_id'] = local_var_params['task_execution_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/tasks/{task_id}/task_executions/{task_execution_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskExecution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
