# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nodeum_sdk.api_client import ApiClient
from nodeum_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ContainersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_container(self, **kwargs):  # noqa: E501
        """Creates a new container.  # noqa: E501

        It **does not** yet create the file structure and configure the samba connection. Use API v1 instead.  **API Key Scope**: containers / create  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_container(container_body=container_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Container container_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_container_with_http_info(**kwargs)  # noqa: E501

    def create_container_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a new container.  # noqa: E501

        It **does not** yet create the file structure and configure the samba connection. Use API v1 instead.  **API Key Scope**: containers / create  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_container_with_http_info(container_body=container_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Container container_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Container, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_body' is set
        if self.api_client.client_side_validation and ('container_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_body` when calling `create_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'container_body' in local_var_params:
            body_params = local_var_params['container_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Container',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_container_privilege(self, **kwargs):  # noqa: E501
        """Creates a new privilege on the container.  # noqa: E501

        **API Key Scope**: container_privileges / create  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_container_privilege(container_id=container_id_value, container_privilege_body=container_privilege_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param ContainerPrivilege container_privilege_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerPrivilege
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_container_privilege_with_http_info(**kwargs)  # noqa: E501

    def create_container_privilege_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a new privilege on the container.  # noqa: E501

        **API Key Scope**: container_privileges / create  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_container_privilege_with_http_info(container_id=container_id_value, container_privilege_body=container_privilege_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param ContainerPrivilege container_privilege_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerPrivilege, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'container_privilege_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_container_privilege" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `create_container_privilege`")  # noqa: E501
        # verify the required parameter 'container_privilege_body' is set
        if self.api_client.client_side_validation and ('container_privilege_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_privilege_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_privilege_body` when calling `create_container_privilege`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'container_privilege_body' in local_var_params:
            body_params = local_var_params['container_privilege_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/container_privileges', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerPrivilege',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_container(self, **kwargs):  # noqa: E501
        """Destroys a specific container.  # noqa: E501

        **API Key Scope**: containers / destroy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_container(container_id=container_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_container_with_http_info(**kwargs)  # noqa: E501

    def destroy_container_with_http_info(self, **kwargs):  # noqa: E501
        """Destroys a specific container.  # noqa: E501

        **API Key Scope**: containers / destroy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_container_with_http_info(container_id=container_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `destroy_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_container_privilege(self, **kwargs):  # noqa: E501
        """Destroys a specific privilege.  # noqa: E501

        **API Key Scope**: container_privileges / destroy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_container_privilege(container_id=container_id_value, container_privilege_id=container_privilege_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int container_privilege_id: Numeric ID of container privilege. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_container_privilege_with_http_info(**kwargs)  # noqa: E501

    def destroy_container_privilege_with_http_info(self, **kwargs):  # noqa: E501
        """Destroys a specific privilege.  # noqa: E501

        **API Key Scope**: container_privileges / destroy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_container_privilege_with_http_info(container_id=container_id_value, container_privilege_id=container_privilege_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int container_privilege_id: Numeric ID of container privilege. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'container_privilege_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_container_privilege" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `destroy_container_privilege`")  # noqa: E501
        # verify the required parameter 'container_privilege_id' is set
        if self.api_client.client_side_validation and ('container_privilege_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_privilege_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_privilege_id` when calling `destroy_container_privilege`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501
        if 'container_privilege_id' in local_var_params:
            path_params['container_privilege_id'] = local_var_params['container_privilege_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/container_privileges/{container_privilege_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_container_privileges(self, **kwargs):  # noqa: E501
        """Lists all privilege on the container.  # noqa: E501

        **API Key Scope**: container_privileges / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_container_privileges(container_id=container_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str name: Filter on name
        :param str privilege: Filter on privilege
        :param str type: Filter on type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerPrivilegeCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_container_privileges_with_http_info(**kwargs)  # noqa: E501

    def index_container_privileges_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all privilege on the container.  # noqa: E501

        **API Key Scope**: container_privileges / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_container_privileges_with_http_info(container_id=container_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str name: Filter on name
        :param str privilege: Filter on privilege
        :param str type: Filter on type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerPrivilegeCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'limit',
            'offset',
            'sort_by',
            'id',
            'name',
            'privilege',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_container_privileges" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `index_container_privileges`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'privilege' in local_var_params and local_var_params['privilege'] is not None:  # noqa: E501
            query_params.append(('privilege', local_var_params['privilege']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/container_privileges', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerPrivilegeCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_containers(self, **kwargs):  # noqa: E501
        """Lists all containers.  # noqa: E501

        **API Key Scope**: containers / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_containers(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str name: Filter on name
        :param str comment: Filter on comment
        :param str quota_total_size: Filter on quota total size
        :param str quota_on_cache: Filter on quota on cache
        :param str stat_total_files: Filter on stat total files
        :param str stat_total_size: Filter on stat total size
        :param str stat_size_on_cache: Filter on stat size on cache
        :param str guest_right: Filter on guest right
        :param str last_update: Filter on last update
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.index_containers_with_http_info(**kwargs)  # noqa: E501

    def index_containers_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all containers.  # noqa: E501

        **API Key Scope**: containers / index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_containers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: The number of items to display for pagination.
        :param int offset: The number of items to skip for pagination.
        :param list[str] sort_by: Sort results by attribute.  Can sort on multiple attributes, separated by `|`. Order direction can be suffixing the attribute by either `:asc` (default) or `:desc`.
        :param str id: Filter on id
        :param str name: Filter on name
        :param str comment: Filter on comment
        :param str quota_total_size: Filter on quota total size
        :param str quota_on_cache: Filter on quota on cache
        :param str stat_total_files: Filter on stat total files
        :param str stat_total_size: Filter on stat total size
        :param str stat_size_on_cache: Filter on stat size on cache
        :param str guest_right: Filter on guest right
        :param str last_update: Filter on last update
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerCollection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'offset',
            'sort_by',
            'id',
            'name',
            'comment',
            'quota_total_size',
            'quota_on_cache',
            'stat_total_files',
            'stat_total_size',
            'stat_size_on_cache',
            'guest_right',
            'last_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_containers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sort_by'] = 'pipe'  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'comment' in local_var_params and local_var_params['comment'] is not None:  # noqa: E501
            query_params.append(('comment', local_var_params['comment']))  # noqa: E501
        if 'quota_total_size' in local_var_params and local_var_params['quota_total_size'] is not None:  # noqa: E501
            query_params.append(('quota_total_size', local_var_params['quota_total_size']))  # noqa: E501
        if 'quota_on_cache' in local_var_params and local_var_params['quota_on_cache'] is not None:  # noqa: E501
            query_params.append(('quota_on_cache', local_var_params['quota_on_cache']))  # noqa: E501
        if 'stat_total_files' in local_var_params and local_var_params['stat_total_files'] is not None:  # noqa: E501
            query_params.append(('stat_total_files', local_var_params['stat_total_files']))  # noqa: E501
        if 'stat_total_size' in local_var_params and local_var_params['stat_total_size'] is not None:  # noqa: E501
            query_params.append(('stat_total_size', local_var_params['stat_total_size']))  # noqa: E501
        if 'stat_size_on_cache' in local_var_params and local_var_params['stat_size_on_cache'] is not None:  # noqa: E501
            query_params.append(('stat_size_on_cache', local_var_params['stat_size_on_cache']))  # noqa: E501
        if 'guest_right' in local_var_params and local_var_params['guest_right'] is not None:  # noqa: E501
            query_params.append(('guest_right', local_var_params['guest_right']))  # noqa: E501
        if 'last_update' in local_var_params and local_var_params['last_update'] is not None:  # noqa: E501
            query_params.append(('last_update', local_var_params['last_update']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_container(self, **kwargs):  # noqa: E501
        """Displays a specific container.  # noqa: E501

        **API Key Scope**: containers / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_container(container_id=container_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_container_with_http_info(**kwargs)  # noqa: E501

    def show_container_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific container.  # noqa: E501

        **API Key Scope**: containers / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_container_with_http_info(container_id=container_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Container, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `show_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Container',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_container_privilege(self, **kwargs):  # noqa: E501
        """Displays a specific privilege.  # noqa: E501

        **API Key Scope**: container_privileges / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_container_privilege(container_id=container_id_value, container_privilege_id=container_privilege_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int container_privilege_id: Numeric ID of container privilege. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerPrivilege
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.show_container_privilege_with_http_info(**kwargs)  # noqa: E501

    def show_container_privilege_with_http_info(self, **kwargs):  # noqa: E501
        """Displays a specific privilege.  # noqa: E501

        **API Key Scope**: container_privileges / show  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_container_privilege_with_http_info(container_id=container_id_value, container_privilege_id=container_privilege_id_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int container_privilege_id: Numeric ID of container privilege. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerPrivilege, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'container_privilege_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_container_privilege" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `show_container_privilege`")  # noqa: E501
        # verify the required parameter 'container_privilege_id' is set
        if self.api_client.client_side_validation and ('container_privilege_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_privilege_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_privilege_id` when calling `show_container_privilege`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501
        if 'container_privilege_id' in local_var_params:
            path_params['container_privilege_id'] = local_var_params['container_privilege_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/container_privileges/{container_privilege_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerPrivilege',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_container(self, **kwargs):  # noqa: E501
        """Updates a specific container.  # noqa: E501

        It **does not** yet create the file structure and configure the samba connection. Use API v1 instead.  **API Key Scope**: containers / update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_container(container_id=container_id_value, container_body=container_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param Container container_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_container_with_http_info(**kwargs)  # noqa: E501

    def update_container_with_http_info(self, **kwargs):  # noqa: E501
        """Updates a specific container.  # noqa: E501

        It **does not** yet create the file structure and configure the samba connection. Use API v1 instead.  **API Key Scope**: containers / update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_container_with_http_info(container_id=container_id_value, container_body=container_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param Container container_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Container, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'container_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `update_container`")  # noqa: E501
        # verify the required parameter 'container_body' is set
        if self.api_client.client_side_validation and ('container_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_body` when calling `update_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'container_body' in local_var_params:
            body_params = local_var_params['container_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Container',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_container_privilege(self, **kwargs):  # noqa: E501
        """Updates a specific privilege.  # noqa: E501

        **API Key Scope**: container_privileges / update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_container_privilege(container_id=container_id_value, container_privilege_id=container_privilege_id_value, container_privilege_body=container_privilege_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int container_privilege_id: Numeric ID of container privilege. (required)
        :param ContainerPrivilege container_privilege_body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerPrivilege
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_container_privilege_with_http_info(**kwargs)  # noqa: E501

    def update_container_privilege_with_http_info(self, **kwargs):  # noqa: E501
        """Updates a specific privilege.  # noqa: E501

        **API Key Scope**: container_privileges / update  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_container_privilege_with_http_info(container_id=container_id_value, container_privilege_id=container_privilege_id_value, container_privilege_body=container_privilege_body_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_id: Numeric ID or name of container. (required)
        :param int container_privilege_id: Numeric ID of container privilege. (required)
        :param ContainerPrivilege container_privilege_body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerPrivilege, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_id',
            'container_privilege_id',
            'container_privilege_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_container_privilege" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_id` when calling `update_container_privilege`")  # noqa: E501
        # verify the required parameter 'container_privilege_id' is set
        if self.api_client.client_side_validation and ('container_privilege_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_privilege_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_privilege_id` when calling `update_container_privilege`")  # noqa: E501
        # verify the required parameter 'container_privilege_body' is set
        if self.api_client.client_side_validation and ('container_privilege_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_privilege_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_privilege_body` when calling `update_container_privilege`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in local_var_params:
            path_params['container_id'] = local_var_params['container_id']  # noqa: E501
        if 'container_privilege_id' in local_var_params:
            path_params['container_privilege_id'] = local_var_params['container_privilege_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'container_privilege_body' in local_var_params:
            body_params = local_var_params['container_privilege_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth', 'BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/container_privileges/{container_privilege_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerPrivilege',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
