import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSalesforceUserLicenseConfig extends cdktf.TerraformMetaArguments {
    /**
    * A string that uniquely identifies a particular user license. Valid options vary depending on organization type and configuration. For a complete list see https://developer.salesforce.com/docs/atlas.en-us.api.meta/api/sforce_api_objects_userlicense.htm
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/d/user_license#license_definition_key DataSalesforceUserLicense#license_definition_key}
    */
    readonly licenseDefinitionKey: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/salesforce/d/user_license salesforce_user_license}
*/
export declare class DataSalesforceUserLicense extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "salesforce_user_license";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/salesforce/d/user_license salesforce_user_license} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSalesforceUserLicenseConfig
    */
    constructor(scope: Construct, id: string, config: DataSalesforceUserLicenseConfig);
    get id(): string;
    private _licenseDefinitionKey?;
    get licenseDefinitionKey(): string;
    set licenseDefinitionKey(value: string);
    get licenseDefinitionKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
