import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSalesforceProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the profile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/d/profile#name DataSalesforceProfile#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/salesforce/d/profile salesforce_profile}
*/
export declare class DataSalesforceProfile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "salesforce_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/salesforce/d/profile salesforce_profile} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSalesforceProfileConfig
    */
    constructor(scope: Construct, id: string, config: DataSalesforceProfileConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
