#!/usr/bin/env python
#
# Unofficial Instagram Python client. Built with the use of the selenium,
# and requests modules.
# Copyright (C) 2015-2021
# David Henry Francis Wicker <wickerdevs@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser Public License for more details.
#
# You should have received a copy of the GNU Lesser Public License
# along with this program.  If not, see [http://www.gnu.org/licenses/].

from instaclient.errors.common import InstaClientError

class InvalidShortCodeError(InstaClientError):
    """Raised when trying to navigate to a page with an invalid shortcode.

    Args:
        shortcode (str)
    """
    def __init__(self, shortcode):
        self.shortcode = shortcode
        super().__init__(message='Invalid shortcode')

    def __str__(self):
        return f'{self.shortcode} -> {self.message}'