# coding: utf-8

"""
    fatcat

    Fatcat is a scalable, versioned, API-oriented catalog of bibliographic entities and file metadata.   # noqa: E501

    The version of the OpenAPI document: 0.3.1
    Contact: webservices@archive.org
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ReleaseExtIds(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'doi': 'str',
        'wikidata_qid': 'str',
        'isbn13': 'str',
        'pmid': 'str',
        'pmcid': 'str',
        'core': 'str',
        'arxiv': 'str',
        'jstor': 'str',
        'ark': 'str',
        'mag': 'str'
    }

    attribute_map = {
        'doi': 'doi',
        'wikidata_qid': 'wikidata_qid',
        'isbn13': 'isbn13',
        'pmid': 'pmid',
        'pmcid': 'pmcid',
        'core': 'core',
        'arxiv': 'arxiv',
        'jstor': 'jstor',
        'ark': 'ark',
        'mag': 'mag'
    }

    def __init__(self, doi=None, wikidata_qid=None, isbn13=None, pmid=None, pmcid=None, core=None, arxiv=None, jstor=None, ark=None, mag=None):  # noqa: E501
        """ReleaseExtIds - a model defined in OpenAPI"""  # noqa: E501

        self._doi = None
        self._wikidata_qid = None
        self._isbn13 = None
        self._pmid = None
        self._pmcid = None
        self._core = None
        self._arxiv = None
        self._jstor = None
        self._ark = None
        self._mag = None
        self.discriminator = None

        if doi is not None:
            self.doi = doi
        if wikidata_qid is not None:
            self.wikidata_qid = wikidata_qid
        if isbn13 is not None:
            self.isbn13 = isbn13
        if pmid is not None:
            self.pmid = pmid
        if pmcid is not None:
            self.pmcid = pmcid
        if core is not None:
            self.core = core
        if arxiv is not None:
            self.arxiv = arxiv
        if jstor is not None:
            self.jstor = jstor
        if ark is not None:
            self.ark = ark
        if mag is not None:
            self.mag = mag

    @property
    def doi(self):
        """Gets the doi of this ReleaseExtIds.  # noqa: E501

        Digital Object Identifier (DOI), mostly for published papers and datasets. Should be registered and resolvable via https://doi.org/   # noqa: E501

        :return: The doi of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._doi

    @doi.setter
    def doi(self, doi):
        """Sets the doi of this ReleaseExtIds.

        Digital Object Identifier (DOI), mostly for published papers and datasets. Should be registered and resolvable via https://doi.org/   # noqa: E501

        :param doi: The doi of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._doi = doi

    @property
    def wikidata_qid(self):
        """Gets the wikidata_qid of this ReleaseExtIds.  # noqa: E501

        Wikidata entity QID  # noqa: E501

        :return: The wikidata_qid of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._wikidata_qid

    @wikidata_qid.setter
    def wikidata_qid(self, wikidata_qid):
        """Sets the wikidata_qid of this ReleaseExtIds.

        Wikidata entity QID  # noqa: E501

        :param wikidata_qid: The wikidata_qid of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._wikidata_qid = wikidata_qid

    @property
    def isbn13(self):
        """Gets the isbn13 of this ReleaseExtIds.  # noqa: E501

        ISBN-13, for books. Usually not set for chapters. ISBN-10 should be converted to ISBN-13.   # noqa: E501

        :return: The isbn13 of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._isbn13

    @isbn13.setter
    def isbn13(self, isbn13):
        """Sets the isbn13 of this ReleaseExtIds.

        ISBN-13, for books. Usually not set for chapters. ISBN-10 should be converted to ISBN-13.   # noqa: E501

        :param isbn13: The isbn13 of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._isbn13 = isbn13

    @property
    def pmid(self):
        """Gets the pmid of this ReleaseExtIds.  # noqa: E501

        PubMed Identifier  # noqa: E501

        :return: The pmid of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._pmid

    @pmid.setter
    def pmid(self, pmid):
        """Sets the pmid of this ReleaseExtIds.

        PubMed Identifier  # noqa: E501

        :param pmid: The pmid of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._pmid = pmid

    @property
    def pmcid(self):
        """Gets the pmcid of this ReleaseExtIds.  # noqa: E501

        PubMed Central Identifier  # noqa: E501

        :return: The pmcid of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._pmcid

    @pmcid.setter
    def pmcid(self, pmcid):
        """Sets the pmcid of this ReleaseExtIds.

        PubMed Central Identifier  # noqa: E501

        :param pmcid: The pmcid of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._pmcid = pmcid

    @property
    def core(self):
        """Gets the core of this ReleaseExtIds.  # noqa: E501

        CORE (https://core.ac.uk) identifier  # noqa: E501

        :return: The core of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._core

    @core.setter
    def core(self, core):
        """Sets the core of this ReleaseExtIds.

        CORE (https://core.ac.uk) identifier  # noqa: E501

        :param core: The core of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._core = core

    @property
    def arxiv(self):
        """Gets the arxiv of this ReleaseExtIds.  # noqa: E501

        arXiv (https://arxiv.org) identifier; must include version  # noqa: E501

        :return: The arxiv of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._arxiv

    @arxiv.setter
    def arxiv(self, arxiv):
        """Sets the arxiv of this ReleaseExtIds.

        arXiv (https://arxiv.org) identifier; must include version  # noqa: E501

        :param arxiv: The arxiv of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._arxiv = arxiv

    @property
    def jstor(self):
        """Gets the jstor of this ReleaseExtIds.  # noqa: E501

        JSTOR work identifier  # noqa: E501

        :return: The jstor of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._jstor

    @jstor.setter
    def jstor(self, jstor):
        """Sets the jstor of this ReleaseExtIds.

        JSTOR work identifier  # noqa: E501

        :param jstor: The jstor of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._jstor = jstor

    @property
    def ark(self):
        """Gets the ark of this ReleaseExtIds.  # noqa: E501

        ARK identifier  # noqa: E501

        :return: The ark of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._ark

    @ark.setter
    def ark(self, ark):
        """Sets the ark of this ReleaseExtIds.

        ARK identifier  # noqa: E501

        :param ark: The ark of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._ark = ark

    @property
    def mag(self):
        """Gets the mag of this ReleaseExtIds.  # noqa: E501

        Microsoft Academic Graph identifier  # noqa: E501

        :return: The mag of this ReleaseExtIds.  # noqa: E501
        :rtype: str
        """
        return self._mag

    @mag.setter
    def mag(self, mag):
        """Sets the mag of this ReleaseExtIds.

        Microsoft Academic Graph identifier  # noqa: E501

        :param mag: The mag of this ReleaseExtIds.  # noqa: E501
        :type: str
        """

        self._mag = mag

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReleaseExtIds):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
