"""
Type annotations for account service type definitions.

[Open documentation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_account/type_defs/)

Usage::

    ```python
    from mypy_boto3_account.type_defs import AlternateContactTypeDef

    data: AlternateContactTypeDef = {...}
    ```
"""
import sys
from typing import Dict, List, Sequence

from .literals import AlternateContactTypeType, RegionOptStatusType

if sys.version_info >= (3, 9):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict


__all__ = (
    "AlternateContactTypeDef",
    "ContactInformationTypeDef",
    "DeleteAlternateContactRequestRequestTypeDef",
    "DisableRegionRequestRequestTypeDef",
    "ResponseMetadataTypeDef",
    "EnableRegionRequestRequestTypeDef",
    "GetAlternateContactRequestRequestTypeDef",
    "GetContactInformationRequestRequestTypeDef",
    "GetRegionOptStatusRequestRequestTypeDef",
    "ListRegionsRequestRequestTypeDef",
    "RegionTypeDef",
    "PutAlternateContactRequestRequestTypeDef",
    "PutContactInformationRequestRequestTypeDef",
    "EmptyResponseMetadataTypeDef",
    "GetAlternateContactResponseTypeDef",
    "GetContactInformationResponseTypeDef",
    "GetRegionOptStatusResponseTypeDef",
    "ListRegionsResponseTypeDef",
)

AlternateContactTypeDef = TypedDict(
    "AlternateContactTypeDef",
    {
        "AlternateContactType": AlternateContactTypeType,
        "EmailAddress": str,
        "Name": str,
        "PhoneNumber": str,
        "Title": str,
    },
    total=False,
)

_RequiredContactInformationTypeDef = TypedDict(
    "_RequiredContactInformationTypeDef",
    {
        "AddressLine1": str,
        "City": str,
        "CountryCode": str,
        "FullName": str,
        "PhoneNumber": str,
        "PostalCode": str,
    },
)
_OptionalContactInformationTypeDef = TypedDict(
    "_OptionalContactInformationTypeDef",
    {
        "AddressLine2": str,
        "AddressLine3": str,
        "CompanyName": str,
        "DistrictOrCounty": str,
        "StateOrRegion": str,
        "WebsiteUrl": str,
    },
    total=False,
)


class ContactInformationTypeDef(
    _RequiredContactInformationTypeDef, _OptionalContactInformationTypeDef
):
    pass


_RequiredDeleteAlternateContactRequestRequestTypeDef = TypedDict(
    "_RequiredDeleteAlternateContactRequestRequestTypeDef",
    {
        "AlternateContactType": AlternateContactTypeType,
    },
)
_OptionalDeleteAlternateContactRequestRequestTypeDef = TypedDict(
    "_OptionalDeleteAlternateContactRequestRequestTypeDef",
    {
        "AccountId": str,
    },
    total=False,
)


class DeleteAlternateContactRequestRequestTypeDef(
    _RequiredDeleteAlternateContactRequestRequestTypeDef,
    _OptionalDeleteAlternateContactRequestRequestTypeDef,
):
    pass


_RequiredDisableRegionRequestRequestTypeDef = TypedDict(
    "_RequiredDisableRegionRequestRequestTypeDef",
    {
        "RegionName": str,
    },
)
_OptionalDisableRegionRequestRequestTypeDef = TypedDict(
    "_OptionalDisableRegionRequestRequestTypeDef",
    {
        "AccountId": str,
    },
    total=False,
)


class DisableRegionRequestRequestTypeDef(
    _RequiredDisableRegionRequestRequestTypeDef, _OptionalDisableRegionRequestRequestTypeDef
):
    pass


ResponseMetadataTypeDef = TypedDict(
    "ResponseMetadataTypeDef",
    {
        "RequestId": str,
        "HostId": str,
        "HTTPStatusCode": int,
        "HTTPHeaders": Dict[str, str],
        "RetryAttempts": int,
    },
)

_RequiredEnableRegionRequestRequestTypeDef = TypedDict(
    "_RequiredEnableRegionRequestRequestTypeDef",
    {
        "RegionName": str,
    },
)
_OptionalEnableRegionRequestRequestTypeDef = TypedDict(
    "_OptionalEnableRegionRequestRequestTypeDef",
    {
        "AccountId": str,
    },
    total=False,
)


class EnableRegionRequestRequestTypeDef(
    _RequiredEnableRegionRequestRequestTypeDef, _OptionalEnableRegionRequestRequestTypeDef
):
    pass


_RequiredGetAlternateContactRequestRequestTypeDef = TypedDict(
    "_RequiredGetAlternateContactRequestRequestTypeDef",
    {
        "AlternateContactType": AlternateContactTypeType,
    },
)
_OptionalGetAlternateContactRequestRequestTypeDef = TypedDict(
    "_OptionalGetAlternateContactRequestRequestTypeDef",
    {
        "AccountId": str,
    },
    total=False,
)


class GetAlternateContactRequestRequestTypeDef(
    _RequiredGetAlternateContactRequestRequestTypeDef,
    _OptionalGetAlternateContactRequestRequestTypeDef,
):
    pass


GetContactInformationRequestRequestTypeDef = TypedDict(
    "GetContactInformationRequestRequestTypeDef",
    {
        "AccountId": str,
    },
    total=False,
)

_RequiredGetRegionOptStatusRequestRequestTypeDef = TypedDict(
    "_RequiredGetRegionOptStatusRequestRequestTypeDef",
    {
        "RegionName": str,
    },
)
_OptionalGetRegionOptStatusRequestRequestTypeDef = TypedDict(
    "_OptionalGetRegionOptStatusRequestRequestTypeDef",
    {
        "AccountId": str,
    },
    total=False,
)


class GetRegionOptStatusRequestRequestTypeDef(
    _RequiredGetRegionOptStatusRequestRequestTypeDef,
    _OptionalGetRegionOptStatusRequestRequestTypeDef,
):
    pass


ListRegionsRequestRequestTypeDef = TypedDict(
    "ListRegionsRequestRequestTypeDef",
    {
        "AccountId": str,
        "MaxResults": int,
        "NextToken": str,
        "RegionOptStatusContains": Sequence[RegionOptStatusType],
    },
    total=False,
)

RegionTypeDef = TypedDict(
    "RegionTypeDef",
    {
        "RegionName": str,
        "RegionOptStatus": RegionOptStatusType,
    },
    total=False,
)

_RequiredPutAlternateContactRequestRequestTypeDef = TypedDict(
    "_RequiredPutAlternateContactRequestRequestTypeDef",
    {
        "AlternateContactType": AlternateContactTypeType,
        "EmailAddress": str,
        "Name": str,
        "PhoneNumber": str,
        "Title": str,
    },
)
_OptionalPutAlternateContactRequestRequestTypeDef = TypedDict(
    "_OptionalPutAlternateContactRequestRequestTypeDef",
    {
        "AccountId": str,
    },
    total=False,
)


class PutAlternateContactRequestRequestTypeDef(
    _RequiredPutAlternateContactRequestRequestTypeDef,
    _OptionalPutAlternateContactRequestRequestTypeDef,
):
    pass


_RequiredPutContactInformationRequestRequestTypeDef = TypedDict(
    "_RequiredPutContactInformationRequestRequestTypeDef",
    {
        "ContactInformation": ContactInformationTypeDef,
    },
)
_OptionalPutContactInformationRequestRequestTypeDef = TypedDict(
    "_OptionalPutContactInformationRequestRequestTypeDef",
    {
        "AccountId": str,
    },
    total=False,
)


class PutContactInformationRequestRequestTypeDef(
    _RequiredPutContactInformationRequestRequestTypeDef,
    _OptionalPutContactInformationRequestRequestTypeDef,
):
    pass


EmptyResponseMetadataTypeDef = TypedDict(
    "EmptyResponseMetadataTypeDef",
    {
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

GetAlternateContactResponseTypeDef = TypedDict(
    "GetAlternateContactResponseTypeDef",
    {
        "AlternateContact": AlternateContactTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

GetContactInformationResponseTypeDef = TypedDict(
    "GetContactInformationResponseTypeDef",
    {
        "ContactInformation": ContactInformationTypeDef,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

GetRegionOptStatusResponseTypeDef = TypedDict(
    "GetRegionOptStatusResponseTypeDef",
    {
        "RegionName": str,
        "RegionOptStatus": RegionOptStatusType,
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)

ListRegionsResponseTypeDef = TypedDict(
    "ListRegionsResponseTypeDef",
    {
        "NextToken": str,
        "Regions": List[RegionTypeDef],
        "ResponseMetadata": ResponseMetadataTypeDef,
    },
)
