# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['edelweiss_data_cli']

package_data = \
{'': ['*']}

install_requires = \
['docopt>=0.6.2,<0.7.0', 'edelweiss-data>=0.2.4,<0.3.0']

entry_points = \
{'console_scripts': ['edelweiss = edelweiss_data_cli.__main__:main']}

setup_kwargs = {
    'name': 'edelweiss-data-cli',
    'version': '0.1.0a1',
    'description': 'CLI client for EdelweissData',
    'long_description': '# Edelweiss Data CLI\n\nA CLI tool for [Edelweiss Data](https://edelweissdata.com):\nConvenient publishing of scientific data with proper versioning, rich metadata support and a powerful API\n\n## Installation\n\nInstall globally from [PyPi](https://pypi.org/project/edelweiss-data/) using [pip](https://pip.pypa.io/):\n\n```bash\npip install edelweiss-data-cli\n\n```\n\n## Usage\n\nRun `edelweiss --help` to see a list of available commands.\n\nBy default, the tool uses the public edelweiss api at `https://api.edelweissdata.com`.\nThe `--url` flag lets you use an alternative edelweiss api:\n\n```bash\nedelweiss --url https://${MY_DOMAIN} <command>\n```\n\nFor each command, use the `--help` flag for more information:\n\n```bash\nedelweiss <command> --help\n```\n\n## Commands\n\n### Authenticate\n\nUse the `authenticate` command to generate access tokens and refresh tokens.\n\n```bash\nedelweiss authenticate\n```\n\nThe CLI responds with:\n\n```\nVisit this url in your web browser to sign into edelweiss:\nhttps://edelweiss.eu.auth0.com/activate?user_code=XXXX-XXXX\n\nYour authorization token is XXXX-XXXX\nWaiting for authentication.....\n```\n\nOpen the url in your web browser and follow the instructions to sign up or sign in. After you have signed in via the web browser, the CLI will print out the result:\n\n- `access_token` - this is the bearer token for you to attach to all http requests.\n- `expires_in` - the number of seconds until your access token expires; by default 86400 seconds.\n\n\nUse the `--help` flag to see what options are available with the authenticate command:\n\n```bash\nyarn run authenticate -- --help\n```\n\n*Caution*: If you sign up with a new email/password then you will receive an email to let you validate your address.  Access tokens generated by the CLI tool are not valid until you have validated your email address.\n\n### Other commands\n\nWe have lots of ideas for other Edelweiss commands, but they are not implemented yet. For example:\n\n- Create a dataset\n- Fetch a dataset\n- Search for datasets\n- Manage read/write permissions\n\nPlease [create an issue](https://github.com/DouglasConnect/edelweiss-data-cli-python/issues) to lend your support to any of these suggested features.\n',
    'author': 'Edelweiss Connect',
    'author_email': 'info@edelweissconnect.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/DouglasConnect/edelweiss-data-cli-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
