# Edelweiss Data CLI

A CLI tool for [Edelweiss Data](https://edelweissdata.com):
Convenient publishing of scientific data with proper versioning, rich metadata support and a powerful API

## Installation

Install globally from [PyPi](https://pypi.org/project/edelweiss-data/) using [pip](https://pip.pypa.io/):

```bash
pip install edelweiss-data-cli

```

## Usage

Run `edelweiss --help` to see a list of available commands.

By default, the tool uses the public edelweiss api at `https://api.edelweissdata.com`.
The `--url` flag lets you use an alternative edelweiss api:

```bash
edelweiss --url https://${MY_DOMAIN} <command>
```

For each command, use the `--help` flag for more information:

```bash
edelweiss <command> --help
```

## Commands

### Authenticate

Use the `authenticate` command to generate access tokens and refresh tokens.

```bash
edelweiss authenticate
```

The CLI responds with:

```
Visit this url in your web browser to sign into edelweiss:
https://edelweiss.eu.auth0.com/activate?user_code=XXXX-XXXX

Your authorization token is XXXX-XXXX
Waiting for authentication.....
```

Open the url in your web browser and follow the instructions to sign up or sign in. After you have signed in via the web browser, the CLI will print out the result:

- `access_token` - this is the bearer token for you to attach to all http requests.
- `expires_in` - the number of seconds until your access token expires; by default 86400 seconds.


Use the `--help` flag to see what options are available with the authenticate command:

```bash
yarn run authenticate -- --help
```

*Caution*: If you sign up with a new email/password then you will receive an email to let you validate your address.  Access tokens generated by the CLI tool are not valid until you have validated your email address.

### Other commands

We have lots of ideas for other Edelweiss commands, but they are not implemented yet. For example:

- Create a dataset
- Fetch a dataset
- Search for datasets
- Manage read/write permissions

Please [create an issue](https://github.com/DouglasConnect/edelweiss-data-cli-python/issues) to lend your support to any of these suggested features.
