#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['infercnvpy',
 'infercnvpy.datasets',
 'infercnvpy.datasets.data',
 'infercnvpy.io',
 'infercnvpy.pl',
 'infercnvpy.pp',
 'infercnvpy.tests',
 'infercnvpy.tl']

package_data = \
{'': ['*']}

install_requires = \
['anndata>=0.7.3',
 'scanpy>=1.6.0',
 'pandas>=1',
 'numpy>=1.20',
 'tqdm>=4.42.0',
 'setuptools_scm',
 'pytoml',
 'gtfparse>=1.2.1',
 'leidenalg']

extras_require = \
{':sys_platform == "win32"': ['pycairo>=1.20'],
 'copykat': ['rpy2'],
 'doc': ['sphinx>=3.0.1,<3.1',
         'sphinx_autodoc_typehints>=1.8.0',
         'scanpydoc>=0.5',
         'sphinx_rtd_theme>=0.4,<0.5',
         'nbsphinx>=0.6.0',
         'jupytext',
         'sphinxcontrib-bibtex>=1.0.0',
         'pycairo',
         'jupyter_client',
         'ipykernel'],
 'test': ['pytest', 'black', 'pre-commit']}

setup(name='infercnvpy',
      version='0.2.0',
      description='Python library to infer copy number variation (CNV) from single-cell RNA-seq data',
      author='Gregor Sturm',
      author_email='gregor.sturm@i-med.ac.at',
      url='https://github.com/icbi-lab/infercnvpy',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>= 3.8',
     )
