"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DbVault = exports.DbVaultProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const hbr_generated_1 = require("./hbr.generated");
Object.defineProperty(exports, "DbVaultProperty", { enumerable: true, get: function () { return hbr_generated_1.RosDbVault; } });
/**
 * A ROS resource type:  `ALIYUN::HBR::DbVault`
 */
class DbVault extends ros.Resource {
    /**
     * Create a new `ALIYUN::HBR::DbVault`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDbVault = new hbr_generated_1.RosDbVault(this, id, {
            description: props.description,
            vaultName: props.vaultName,
            retentionDays: props.retentionDays,
            vaultRegionId: props.vaultRegionId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDbVault;
        this.attrDescription = rosDbVault.attrDescription;
        this.attrRetentionDays = rosDbVault.attrRetentionDays;
        this.attrVaultId = rosDbVault.attrVaultId;
        this.attrVaultName = rosDbVault.attrVaultName;
        this.attrVaultRegionId = rosDbVault.attrVaultRegionId;
    }
}
exports.DbVault = DbVault;
//# sourceMappingURL=data:application/json;base64,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