
###############################################################################
##             This file is generated by hackerforms-protocol.               ##
##        Do not change this file. Any changes will be overwritten.          ##
###############################################################################

import typing
import io
from ..socket import send, receive
from .input_types import *
from .output_types import *
from .metadata import metadata
from .validation import validate_widget_props

class WidgetSchema:
  def __init__(self):
    self.widgets: typing.List[typing.Union[Input, Output]] = []

  def convert_answer(self, form_answers: typing.Dict) -> typing.Dict:
    '''Convert the answer from the form to the expected format
    Args:
        answer: The answer from the form
    Returns:
        The converted answer
    '''
    answer: typing.Dict = {}
    inputs = list(
        filter(lambda widget: isinstance(widget, Input), self.widgets))
    
    for input in inputs:
        answer[input.key] = input.convert_answer(form_answers[input.key])
    return answer

  def json(self):
    '''Get the json representation of the form
    Returns:
        The json representation of the form
    '''
    return [widget.json() for widget in self.widgets]

  
  
  def read_cards(self, label: str, options: typing.Any, **kwargs):
    '''Read cards from the user

      Positional Args:
        label (str): The text related to this fieldoptions (list): The options to display to the user, eg. [{'title': 'Option 1', 'image': 'https://image_1.png', 'description': 'option 1 description'},{'title': 'Option 2', 'image': 'https://image_2.png', 'description': 'option 2 description'}]
      
      Keyword Args:
        multiple (bool): Whether the user can select multiple options
        initial_value (list): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        searchable (bool): Whether to show a search bar
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the label arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', label)
    self.widgets.append(CardsInput(key, label, options, **kwargs))
    return self
  
  def read_code(self, label: str, **kwargs):
    '''Read a code snippet from the user with a text highlight

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        language (str): The programming language
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the label arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', label)
    self.widgets.append(CodeInput(key, label, **kwargs))
    return self
  
  def read_currency(self, message: str, **kwargs):
    '''Read a number value from the user with a currency mask

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not, eg. "this field is required"
        placeholder (str): The placeholder text to display to the user
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        min (float): The minimum value allowed, eg. "0"
        max (float): The maximum value allowed, eg. "100"
        step (float): The value to be incremented or decremented while using the input button
        currency (str): The currency to display to the user, eg. "USD", "BRL, "EUR", "GBP" (default is USD)
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(CurrencyInput(key, message, **kwargs))
    return self
  
  def read_date(self, message: str, **kwargs):
    '''Read a date value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (datetime.date or time.struct_time or str (YYYY-MM-DD)): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(DateInput(key, message, **kwargs))
    return self
  
  def read_dropdown(self, message: str, options: typing.Union[typing.List[str], typing.List[typing.Dict]], **kwargs):
    '''Read a dropdown value from the user

      Positional Args:
        message (str): The message to display to the useroptions (list): The options to display to the user, eg. ['Option 1', 'Option 2'] or [{'label': 'Option 1', 'value': '1'}, {'label': 'Option 2', 'value': '2'}]
      
      Keyword Args:
        multiple (bool): Whether the user can select multiple options
        initial_value: The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(DropdownInput(key, message, options, **kwargs))
    return self
  
  def read_email(self, message: str, **kwargs):
    '''Read an email value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(EmailInput(key, message, **kwargs))
    return self
  
  def read_file(self, message: str, **kwargs):
    '''Read a file value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        multiple (bool): Whether the user will be allowed to upload multiple files
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(FileInput(key, message, **kwargs))
    return self
  
  def read_html_list(self, label: str, options: typing.Any, **kwargs):
    '''Read list of html values from the user

      Positional Args:
        label (str): The text related to this fieldoptions (list): The options to display to the user, eg. [{'html': '<div class="container">Info 1A</div>', 'value': 'info1'},{'html': '<div class="container">Info 2B</div>', 'value': 'info2'}]
      
      Keyword Args:
        initial_value (list): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        multiple (bool): Whether the user can select multiple options
        css (str): The css related to the html item in options
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the label arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', label)
    self.widgets.append(HTMLListInput(key, label, options, **kwargs))
    return self
  
  def read_image(self, message: str, **kwargs):
    '''Read a image file value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        multiple (bool): Whether the user will be allowed to upload multiple files
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(ImageInput(key, message, **kwargs))
    return self
  
  def read_list(self, item_schema: typing.Any, **kwargs):
    '''Read a list value from the user

      Positional Args:
        item_schema (ListItemSchema): The schema for the items of the list
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        min (float): Min value accepted by the input
        max (float): Max value accepted by the input
        add_button_text (str): Label to be displayed on the add button. The default is "+".
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the "result" arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', "result")
    self.widgets.append(ListInput(key, item_schema, **kwargs))
    return self
  
  def read_multiple_choice(self, message: str, options: typing.Union[typing.List[str], typing.List[typing.Dict]], **kwargs):
    '''Read a multiple choice value from the user

      Positional Args:
        message (str): The message to display to the useroptions (list): The options to display to the user, eg. ['Option 1', 'Option 2'] or [{'label': 'Option 1', 'value': '1'}, {'label': 'Option 2', 'value': '2'}]
      
      Keyword Args:
        multiple (bool): Whether the user can select multiple options
        min (number): The minimal amount of options that should be selected
        max (number): The maximum amount of options that should be selected
        initial_value: The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(MultipleChoiceInput(key, message, options, **kwargs))
    return self
  
  def read_nps(self, label: str, **kwargs):
    '''Gets NPS feedback from user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        min (int): Min value accepted by the input
        max (int): Max value accepted by the input
        min_hint (str): Text to display next to the min value
        max_hint (str): Text to display next to the max value
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the label arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', label)
    self.widgets.append(NpsInput(key, label, **kwargs))
    return self
  
  def read_number(self, message: str, **kwargs):
    '''Read a number value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        min (float): Min value accepted by the input
        max (float): Max value accepted by the input
        step (float): The value to be incremented or decremented while using the input button
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(NumberInput(key, message, **kwargs))
    return self
  
  def read_pandas_row_selection(self, df: typing.Any, **kwargs):
    '''Display a pandas dataframe as a table and allow the user to select rows

      Positional Args:
        df (pandas.DataFrame): The pandas dataframe to be displayed
      
      Keyword Args:
        required: Whether the input is required or not
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the "result" arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', "result")
    self.widgets.append(PandasRowSelectionInput(key, df, **kwargs))
    return self
  
  def read_password(self, message: str, **kwargs):
    '''Read a password value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        lowercase_required (bool or str): Whether the input must have at least one lowercase character
        uppercase_required (bool or str): Whether the input must have at least one uppercase character
        special_required (bool or str): Whether the input must have at least one special character
        digit_required (bool or str): Whether the input must have at least one digit
        min_length (int): Minimum length of the password
        max_length (int): Maximum length of the password
        size (int): Size of the password
        pattern (str): A regex pattern for the accepted password
        autocomplete (str): The autocomplete HTML attribute
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(PasswordInput(key, message, **kwargs))
    return self
  
  def read_phone(self, message: str, **kwargs):
    '''Read a phone number value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(PhoneInput(key, message, **kwargs))
    return self
  
  def read_tag(self, message: str, **kwargs):
    '''Read a tag value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (list): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(TagInput(key, message, **kwargs))
    return self
  
  def read(self, message: str, **kwargs):
    '''Read a text value from the user simple text input

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''

    key = kwargs.pop('key', message)
    self.widgets.append(TextInput(key, message, **kwargs))
    return self
  
  def read_textarea(self, message: str, **kwargs):
    '''Read a text value from the user with a text area input

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(TextareaInput(key, message, **kwargs))
    return self
  
  def read_time(self, message: str, **kwargs):
    '''Read a time value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        format (str): Whether the input is in the format 24hs or AM/PM. Default is 24hs.
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(TimeInput(key, message, **kwargs))
    return self
  
  def read_video(self, message: str, **kwargs):
    '''Read a video file value from the user

      Positional Args:
        message (str): The message to display to the user
      
      Keyword Args:
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        multiple (bool): Whether the user will be allowed to upload multiple files
        columns: The number of columns of the input
        key: The key of the input's value on the form result. Defaults to the message arg
        

      Returns:
        The form object
    '''
    key = kwargs.pop('key', message)
    self.widgets.append(VideoInput(key, message, **kwargs))
    return self

  
  
  def display_file(self, file: typing.Union[str, io.IOBase], **kwargs):
    '''Display a button for the user to download a file
      

      Positional Args:
        file (file-like or str (path, url, base64)): The file to download
        
      
      Keyword Args:
        download_text (str): The text to display on the button that will download the file
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(FileOutput(file, **kwargs))
    return self
  
  def display_html(self, html: str, **kwargs):
    '''Display a html snippet to the user
      

      Positional Args:
        html (str): The html snippet to display to the user
        full_width (bool): Whether the input should use full screen width
        
      
      Keyword Args:
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(HTMLOutput(html, **kwargs))
    return self
  
  def display_iframe(self, url_or_html: str, **kwargs):
    '''Display an inline iframe to the user
      

      Positional Args:
        url_or_html (str): The link to the document or the own document to display to the user
        
      
      Keyword Args:
        width (int): The width of the iframe
        height (int): The height of the iframe
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(IFrameOutput(url_or_html, **kwargs))
    return self
  
  def display_image(self, image: typing.Union[str, io.IOBase], **kwargs):
    '''Display an image to the user
      

      Positional Args:
        image (file-like or str (path, url, base64)): The image to display to the user
        
      
      Keyword Args:
        full_width (bool): Whether the input should use full screen width
        subtitle (str): The subtitle of the image
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(ImageOutput(image, **kwargs))
    return self
  
  def display_link(self, link_url: str, **kwargs):
    '''Display a link to the user
      

      Positional Args:
        link_url (str): The url of the link to display to the user
        
      
      Keyword Args:
        full_width (bool): Whether the input should use full screen width
        link_text (str): The text to display on the link
        same_tab (bool): Whether to open the link in the same tab or not
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(LinkOutput(link_url, **kwargs))
    return self
  
  def display_markdown(self, text: str, **kwargs):
    '''Display a formatted text to the user
      

      Positional Args:
        text (str): The formatted text to display to the user
        
      
      Keyword Args:
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(MarkdownOutput(text, **kwargs))
    return self
  
  def display_pandas(self, df: typing.Any, **kwargs):
    '''Display a pandas dataframe to the user
      

      Positional Args:
        df (pandas.DataFrame): The dataframe to display to the user
        
      
      Keyword Args:
        full_width (bool): Whether the input should use full screen width
        display_index (bool): Whether to show a index column
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(PandasOutput(df, **kwargs))
    return self
  
  def display_plotly(self, fig: typing.Any, **kwargs):
    '''Display a plotly figure to the user
      

      Positional Args:
        fig (plotly.Figure): The figure to display to the user
        
      
      Keyword Args:
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(PlotlyOutput(fig, **kwargs))
    return self
  
  def display(self, message: str, **kwargs):
    '''Display a message to the user
      

      Positional Args:
        message (str): The message to display to the user
        
      
      Keyword Args:
        full_width (bool): Whether the input should use full screen width
        columns: The number of columns of the input
        

      Returns:
        The form object
    '''
    self.widgets.append(TextOutput(message, **kwargs))
    return self

  input = read

class PageResponse(dict):
  def __init__(self, data, action):
    self.action = action
    self.data = data

  def __getitem__(self, key):
    return self.data[key]

  def __setitem__(self, key, value):
    self.data[key] = value

  def __delitem__(self, key):
    del self.data[key]

  def __iter__(self):
    return iter(self.data)

  def __len__(self):
    return len(self.data)

  def __contains__(self, key):
    return key in self.data

  def __str__(self):
    return str(self.data)
  
  def __repr__(self):
    return repr(self.data)

  def __cmp__(self, cmp_dict):
    return self.__cmp__(self.data, cmp_dict)

  def keys(self):
    return self.data.keys()

  def values(self):
    return self.data.values()

  def items(self):
    return self.data.items()

  def clear(self):
    return self.data.clear()

  def copy(self):
    return PageResponse(self.data.copy(), self.action)

  def has_key(self, key):
    return key in self.data

  def update(self, *args, **kwargs):
    return self.data.update(*args, **kwargs)
  
  def pop(self, *args):
    return self.data.pop(*args)


class Page(WidgetSchema):
    '''A form page that can be displayed to the user

    This is a page that can be displayed to the user. It can be used to
    show data as well as collect informations. After configuring the
    inputs and outputs, use the run method to display the form to the
    user and collect the answers.
    '''

    def __init__(self):
        super().__init__()

    def run(self, actions = "Next" , columns: float = 1) -> typing.Dict:
        '''Run the form

        Args:
            button_text: The text of the button that is used to submit the form
            columns: The number of columns of the form

        Returns:
            The form result as a dict with the keys being the key of the input and the value being the value of the input
        '''
        
        for widget in self.widgets:
          validate_widget_props(widget.json())
        
        if isinstance(actions, list):
          actions = actions
        elif actions is None:
          actions = []
        else:
          actions = [actions]
        
        send({
            'type': 'form',
            'widgets': self.json(),
            'columns': columns,
            'actions': actions
        })
        form_response: typing.Dict = receive()

        return PageResponse(self.convert_answer(form_response["payload"]), form_response.get("action")) 


class ListItemSchema(WidgetSchema):
    '''A schema for a list item

    This schema is used to define the schema of a list item.
    '''

    def __init__(self):
        super().__init__()

    def convert_answer(self, form_answers: typing.Dict) -> typing.Dict:
        '''Convert the answer from the form to the expected format

        Args:
            answer: The answer from the form

        Returns:
            The converted answer
        '''
        answer: typing.Dict = form_answers
        inputs = list(
            filter(lambda widget: isinstance(widget, Input), self.widgets))

        for input in inputs:
            answer[input.key] = input.convert_answer(form_answers[input.key])
        return answer