# MDF Connect Client
[![PyPI](https://img.shields.io/pypi/v/mdf_connect_client.svg)](https://pypi.python.org/pypi/mdf-connect-client) [![Build Status](https://travis-ci.org/materials-data-facility/connect_client.svg?branch=master)](https://travis-ci.org/materials-data-facility/connect_client) [![Coverage Status](https://coveralls.io/repos/github/materials-data-facility/connect_client/badge.svg?branch=master)](https://coveralls.io/github/materials-data-facility/connect_client?branch=master) [![Read the Docs](https://readthedocs.org/projects/mdf-connect-client/badge/?version=master)](http://mdf-connect-client.readthedocs.io/en/master/)

The MDF Connect Client is the Python client to easily submit datasets to MDF Connect.

# Installation

```
pip install mdf_connect_client
```

### For Developers
```
git clone https://github.com/materials-data-facility/connect_client.git
cd connect_client
pip install -e .
```

# Documentation and examples
Documentation is available on [Read the Docs](https://mdf-connect-client.readthedocs.io/) and [GitHub](https://github.com/materials-data-facility/connect_client/tree/master/docs/). Examples and tutorials are provided as Jupyter notebooks, which can optionally be run interactively with [Jupyter](http://jupyter.org/).


# Requirements
* The Connect Client requires Python 3.5 or greater.
* To submit data to MDF Connect, you must have an account recognized by Globus Auth (including Google, ORCiD, many academic institutions, or a [free Globus ID](https://www.globusid.org/create)), and be a member of the [MDF Connect Convert Globus Group](https://app.globus.org/groups/cc192dca-3751-11e8-90c1-0a7c735d220a).


# Support
This work was performed under financial assistance award 70NANB14H012 from U.S. Department of Commerce, National Institute of Standards and Technology as part of the [Center for Hierarchical Material Design (CHiMaD)](http://chimad.northwestern.edu). This work was performed under the following financial assistance award 70NANB19H005 from U.S. Department of Commerce, National Institute of Standards and Technology as part of the Center for Hierarchical Materials Design (CHiMaD). This work was also supported by the National Science Foundation as part of the [Midwest Big Data Hub](http://midwestbigdatahub.org) under NSF Award Number: 1636950 "BD Spokes: SPOKE: MIDWEST: Collaborative: Integrative Materials Design (IMaD): Leverage, Innovate, and Disseminate".
