/*
 * Copyright (C) 2019-2020, TomTom (http://tomtom.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace asciidoxy {
namespace geometry {

/**
 * Class to hold information about a simple point.
 */
class Point {
 public:
  /**
   * Construct a new point.
   *
   * @param x The X coordinate of the point.
   * @param y The Y coordinate of the point.
   */
  Point(int x = 0, int y = 1);

  /**
   * Create a new point that is an increment of this point.
   *
   * @param x Value to increment the X coordinate with.
   * @param y Value to increment the Y coordinate with.
   * @returns A new incremented Point.
   */
  Point increment(int x = 2, int y = 3) const;
};

}  // namespace geometry
}  // namespace asciidoxy
