from unittest import TestCase
from btcmagic import script

class TestScriptSerialization(TestCase):

    def setUp(self):
        self.scripts = [
            (
                b'I0F\x02!\x00\xda\x1eY\xd7\x8b\xb8\x8c\xa7\xc3\xe1:JoN%\x9d]\xd8\xcb\x17}_y\x19\x9b\xf0$\xb1\xf5q!\xd5\x02!\x00\x8d\x1d\x988`jb\xedK\xd0\x11\xa6\xce\x8a B\xae-\xc3\x8f\xd0S\x81\xb5\n\xa3\x88\xa1\xc8\xbd\x91P\x01A\x04\xd3\xb6\x15\xc6\t\xe4\x8a\xe8\x13\x89\xf6a{PG;\xf4\xc9?c\xc9\x85<\xd08\xaaO\x00\xa9\x89\xeb\xd6*\xe8%5U\xe2L\x88\xb99\x81}\xa1\x8c\xd4\xe7&?\xdaj\x0e\x81P\x97X\x9b\xb9\nZk?\xf1',
                [b'0F\x02!\x00\xda\x1eY\xd7\x8b\xb8\x8c\xa7\xc3\xe1:JoN%\x9d]\xd8\xcb\x17}_y\x19\x9b\xf0$\xb1\xf5q!\xd5\x02!\x00\x8d\x1d\x988`jb\xedK\xd0\x11\xa6\xce\x8a B\xae-\xc3\x8f\xd0S\x81\xb5\n\xa3\x88\xa1\xc8\xbd\x91P\x01', b'\x04\xd3\xb6\x15\xc6\t\xe4\x8a\xe8\x13\x89\xf6a{PG;\xf4\xc9?c\xc9\x85<\xd08\xaaO\x00\xa9\x89\xeb\xd6*\xe8%5U\xe2L\x88\xb99\x81}\xa1\x8c\xd4\xe7&?\xdaj\x0e\x81P\x97X\x9b\xb9\nZk?\xf1']
            ),
            (
                b'j\x08\x10\xe2\xcd\xc1\xaf\x05\x18\x01',
                [script.Opcode.OP_RETURN, b'\x10\xe2\xcd\xc1\xaf\x05\x18\x01']
            ),
            (
                b'v\xa9\x14\x9f\xe1MP\xc9Z\xbdn\xcd\xdc]a%\\\xfeZ\xeb\xeb\xa7\xe9\x88\xac',
                [script.Opcode.OP_DUP, script.Opcode.OP_HASH160, b'\x9f\xe1MP\xc9Z\xbdn\xcd\xdc]a%\\\xfeZ\xeb\xeb\xa7\xe9', script.Opcode.OP_EQUALVERIFY, script.Opcode.OP_CHECKSIG]
            )
        ]

    def test_serialize(self):
        for s in self.scripts:
            self.assertEqual(
                s[0],
                script.serialize(s[1])
            )

    def test_deserialize(self):
        for s in self.scripts:
            self.assertEqual(
                script.deserialize(s[0]),
                s[1]
            )

class TestScriptBuilding(TestCase):
    def test_build(self):
        self.assertEqual(
            script.make_p2pk(b'\x02\x8dO@#`d\x9c\x9e"\xec\x8f\xd2\x01\xa3\xcc\xe5\x8c|aL\xc4d\xb0\xd8b}\xed\xe2\xa9G\xb1\xd7'),
            b'!\x02\x8dO@#`d\x9c\x9e"\xec\x8f\xd2\x01\xa3\xcc\xe5\x8c|aL\xc4d\xb0\xd8b}\xed\xe2\xa9G\xb1\xd7\xac'
        )

        self.assertEqual(
            script.make_p2pkh(b'\xf5\x8e:\xac\xc8BO\x04)\\\x14\xacfu\x11\x8b\x7f\n8\r'),
            b'v\xa9\x14\xf5\x8e:\xac\xc8BO\x04)\\\x14\xacfu\x11\x8b\x7f\n8\r\x88\xac'
        )

        self.assertEqual(
            script.make_p2sh(b'\xf5\x8e:\xac\xc8BO\x04)\\\x14\xacfu\x11\x8b\x7f\n8\r'),
            b'\xa9\x14\xf5\x8e:\xac\xc8BO\x04)\\\x14\xacfu\x11\x8b\x7f\n8\r\x87'
        )

        self.assertEqual(
            script.make_data(b'g\x8b\xe5\xdc\x96m\x10\xed\xf1\xaf\xe6\xf9\x1e\xce\x8b\xd8Gt\xad3'),
            b'j\x14g\x8b\xe5\xdc\x96m\x10\xed\xf1\xaf\xe6\xf9\x1e\xce\x8b\xd8Gt\xad3'
        )

class TestScriptParsing(TestCase):
    def test_parse(self):
        self.assertEqual(
            script.parse_p2pkh(script.deserialize(b'v\xa9\x14\xf5\x8e:\xac\xc8BO\x04)\\\x14\xacfu\x11\x8b\x7f\n8\r\x88\xac')),
            b'\xf5\x8e:\xac\xc8BO\x04)\\\x14\xacfu\x11\x8b\x7f\n8\r'
        )

        self.assertEqual(
            script.parse_p2sh(script.deserialize(b'\xa9\x14\xf5\x8e:\xac\xc8BO\x04)\\\x14\xacfu\x11\x8b\x7f\n8\r\x87')),
            b'\xf5\x8e:\xac\xc8BO\x04)\\\x14\xacfu\x11\x8b\x7f\n8\r'
        )

        self.assertEqual(
            script.parse_data(script.deserialize(b'j\x14g\x8b\xe5\xdc\x96m\x10\xed\xf1\xaf\xe6\xf9\x1e\xce\x8b\xd8Gt\xad3')),
            b'g\x8b\xe5\xdc\x96m\x10\xed\xf1\xaf\xe6\xf9\x1e\xce\x8b\xd8Gt\xad3'
        )
