"""
Scraping module for Idealista data extraction.

This module provides scrapers for various Idealista data:
- Agent details (phone, address, website, email)
- Agent orchestration
- Property details
- Property listings
"""

from .agent_details import AgentDetailsScraper
from .agent_orchestrator import AgentScraper
from .property_scraper import PropertyDetailsScraper
from .listing_scraper import (
    extract_property_urls,
    extract_property_count,
    generate_pagination_urls,
    scrape_property_type,
    scrape_agent_listings,
)

__all__ = [
    "AgentDetailsScraper",
    "AgentScraper",
    "PropertyDetailsScraper",
    "extract_property_urls",
    "extract_property_count",
    "generate_pagination_urls",
    "scrape_property_type",
    "scrape_agent_listings",
]
