"""Idealista Scraper - Production web scraper for Idealista real estate listings.

This package provides a complete solution for scraping property listings,
agent information, and images from Idealista.com with support for:
- Async scraping with configurable concurrency
- Progress tracking and resumable sessions
- S3 image upload
- MongoDB-compatible data transformation
"""
from __future__ import annotations

__version__ = "1.0.0"
__author__ = "Antony Ngigge"

# Lazy imports to avoid circular dependencies and improve startup time
__all__ = [
    "__version__",
    "PropertyDetailsScraper",
    "AgentDetailsScraper",
    "HTMLParser",
    "S3ImageUploader",
    "MongoCleaner",
    "clean_html_content",
]


def __getattr__(name: str):
    """Lazy load heavy modules only when accessed."""
    if name == "PropertyDetailsScraper":
        from idealista_scraper.scraping.property_scraper import PropertyDetailsScraper

        return PropertyDetailsScraper
    if name == "AgentDetailsScraper":
        from idealista_scraper.scraping.agent_details import AgentDetailsScraper

        return AgentDetailsScraper
    if name == "HTMLParser":
        from idealista_scraper.parsing.html_parser import HTMLParser

        return HTMLParser
    if name == "clean_html_content":
        from idealista_scraper.parsing.html_parser import clean_html_content

        return clean_html_content
    if name == "S3ImageUploader":
        from idealista_scraper.upload.s3 import S3ImageUploader

        return S3ImageUploader
    if name == "MongoCleaner":
        from idealista_scraper.transform.cleaner import MongoCleaner

        return MongoCleaner
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
